// Copyright 2017 The go-github AUTHORS. All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by gen-accessors; DO NOT EDIT.
// Instead, please run "go generate ./..." as described here:
// https://github.com/google/go-github/blob/master/CONTRIBUTING.md#submitting-a-patch

package github

import (
	"encoding/json"
	"time"
)

// GetRetryAfter returns the RetryAfter field if it's non-nil, zero value otherwise.
func (a *AbuseRateLimitError) GetRetryAfter() time.Duration {
	if a == nil || a.RetryAfter == nil {
		return 0
	}
	return *a.RetryAfter
}

// GetGithubOwnedAllowed returns the GithubOwnedAllowed field if it's non-nil, zero value otherwise.
func (a *ActionsAllowed) GetGithubOwnedAllowed() bool {
	if a == nil || a.GithubOwnedAllowed == nil {
		return false
	}
	return *a.GithubOwnedAllowed
}

// GetVerifiedAllowed returns the VerifiedAllowed field if it's non-nil, zero value otherwise.
func (a *ActionsAllowed) GetVerifiedAllowed() bool {
	if a == nil || a.VerifiedAllowed == nil {
		return false
	}
	return *a.VerifiedAllowed
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetKey() string {
	if a == nil || a.Key == nil {
		return ""
	}
	return *a.Key
}

// GetLastAccessedAt returns the LastAccessedAt field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetLastAccessedAt() Timestamp {
	if a == nil || a.LastAccessedAt == nil {
		return Timestamp{}
	}
	return *a.LastAccessedAt
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetRef() string {
	if a == nil || a.Ref == nil {
		return ""
	}
	return *a.Ref
}

// GetSizeInBytes returns the SizeInBytes field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetSizeInBytes() int64 {
	if a == nil || a.SizeInBytes == nil {
		return 0
	}
	return *a.SizeInBytes
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (a *ActionsCache) GetVersion() string {
	if a == nil || a.Version == nil {
		return ""
	}
	return *a.Version
}

// GetDirection returns the Direction field if it's non-nil, zero value otherwise.
func (a *ActionsCacheListOptions) GetDirection() string {
	if a == nil || a.Direction == nil {
		return ""
	}
	return *a.Direction
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (a *ActionsCacheListOptions) GetKey() string {
	if a == nil || a.Key == nil {
		return ""
	}
	return *a.Key
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (a *ActionsCacheListOptions) GetRef() string {
	if a == nil || a.Ref == nil {
		return ""
	}
	return *a.Ref
}

// GetSort returns the Sort field if it's non-nil, zero value otherwise.
func (a *ActionsCacheListOptions) GetSort() string {
	if a == nil || a.Sort == nil {
		return ""
	}
	return *a.Sort
}

// GetAllowedActions returns the AllowedActions field if it's non-nil, zero value otherwise.
func (a *ActionsPermissions) GetAllowedActions() string {
	if a == nil || a.AllowedActions == nil {
		return ""
	}
	return *a.AllowedActions
}

// GetEnabledRepositories returns the EnabledRepositories field if it's non-nil, zero value otherwise.
func (a *ActionsPermissions) GetEnabledRepositories() string {
	if a == nil || a.EnabledRepositories == nil {
		return ""
	}
	return *a.EnabledRepositories
}

// GetSelectedActionsURL returns the SelectedActionsURL field if it's non-nil, zero value otherwise.
func (a *ActionsPermissions) GetSelectedActionsURL() string {
	if a == nil || a.SelectedActionsURL == nil {
		return ""
	}
	return *a.SelectedActionsURL
}

// GetAllowedActions returns the AllowedActions field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsEnterprise) GetAllowedActions() string {
	if a == nil || a.AllowedActions == nil {
		return ""
	}
	return *a.AllowedActions
}

// GetEnabledOrganizations returns the EnabledOrganizations field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsEnterprise) GetEnabledOrganizations() string {
	if a == nil || a.EnabledOrganizations == nil {
		return ""
	}
	return *a.EnabledOrganizations
}

// GetSelectedActionsURL returns the SelectedActionsURL field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsEnterprise) GetSelectedActionsURL() string {
	if a == nil || a.SelectedActionsURL == nil {
		return ""
	}
	return *a.SelectedActionsURL
}

// GetAllowedActions returns the AllowedActions field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsRepository) GetAllowedActions() string {
	if a == nil || a.AllowedActions == nil {
		return ""
	}
	return *a.AllowedActions
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsRepository) GetEnabled() bool {
	if a == nil || a.Enabled == nil {
		return false
	}
	return *a.Enabled
}

// GetSelectedActionsURL returns the SelectedActionsURL field if it's non-nil, zero value otherwise.
func (a *ActionsPermissionsRepository) GetSelectedActionsURL() string {
	if a == nil || a.SelectedActionsURL == nil {
		return ""
	}
	return *a.SelectedActionsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *ActionsVariable) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetSelectedRepositoriesURL returns the SelectedRepositoriesURL field if it's non-nil, zero value otherwise.
func (a *ActionsVariable) GetSelectedRepositoriesURL() string {
	if a == nil || a.SelectedRepositoriesURL == nil {
		return ""
	}
	return *a.SelectedRepositoriesURL
}

// GetSelectedRepositoryIDs returns the SelectedRepositoryIDs field.
func (a *ActionsVariable) GetSelectedRepositoryIDs() *SelectedRepoIDs {
	if a == nil {
		return nil
	}
	return a.SelectedRepositoryIDs
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *ActionsVariable) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (a *ActionsVariable) GetVisibility() string {
	if a == nil || a.Visibility == nil {
		return ""
	}
	return *a.Visibility
}

// GetCountryCode returns the CountryCode field if it's non-nil, zero value otherwise.
func (a *ActorLocation) GetCountryCode() string {
	if a == nil || a.CountryCode == nil {
		return ""
	}
	return *a.CountryCode
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (a *AdminEnforcedChanges) GetFrom() bool {
	if a == nil || a.From == nil {
		return false
	}
	return *a.From
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *AdminEnforcement) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetComments returns the Comments field.
func (a *AdminStats) GetComments() *CommentStats {
	if a == nil {
		return nil
	}
	return a.Comments
}

// GetGists returns the Gists field.
func (a *AdminStats) GetGists() *GistStats {
	if a == nil {
		return nil
	}
	return a.Gists
}

// GetHooks returns the Hooks field.
func (a *AdminStats) GetHooks() *HookStats {
	if a == nil {
		return nil
	}
	return a.Hooks
}

// GetIssues returns the Issues field.
func (a *AdminStats) GetIssues() *IssueStats {
	if a == nil {
		return nil
	}
	return a.Issues
}

// GetMilestones returns the Milestones field.
func (a *AdminStats) GetMilestones() *MilestoneStats {
	if a == nil {
		return nil
	}
	return a.Milestones
}

// GetOrgs returns the Orgs field.
func (a *AdminStats) GetOrgs() *OrgStats {
	if a == nil {
		return nil
	}
	return a.Orgs
}

// GetPages returns the Pages field.
func (a *AdminStats) GetPages() *PageStats {
	if a == nil {
		return nil
	}
	return a.Pages
}

// GetPulls returns the Pulls field.
func (a *AdminStats) GetPulls() *PullStats {
	if a == nil {
		return nil
	}
	return a.Pulls
}

// GetRepos returns the Repos field.
func (a *AdminStats) GetRepos() *RepoStats {
	if a == nil {
		return nil
	}
	return a.Repos
}

// GetUsers returns the Users field.
func (a *AdminStats) GetUsers() *UserStats {
	if a == nil {
		return nil
	}
	return a.Users
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (a *AdvancedSecurity) GetStatus() string {
	if a == nil || a.Status == nil {
		return ""
	}
	return *a.Status
}

// GetLastPushedDate returns the LastPushedDate field if it's non-nil, zero value otherwise.
func (a *AdvancedSecurityCommittersBreakdown) GetLastPushedDate() string {
	if a == nil || a.LastPushedDate == nil {
		return ""
	}
	return *a.LastPushedDate
}

// GetUserLogin returns the UserLogin field if it's non-nil, zero value otherwise.
func (a *AdvancedSecurityCommittersBreakdown) GetUserLogin() string {
	if a == nil || a.UserLogin == nil {
		return ""
	}
	return *a.UserLogin
}

// GetScore returns the Score field.
func (a *AdvisoryCVSS) GetScore() *float64 {
	if a == nil {
		return nil
	}
	return a.Score
}

// GetVectorString returns the VectorString field if it's non-nil, zero value otherwise.
func (a *AdvisoryCVSS) GetVectorString() string {
	if a == nil || a.VectorString == nil {
		return ""
	}
	return *a.VectorString
}

// GetCWEID returns the CWEID field if it's non-nil, zero value otherwise.
func (a *AdvisoryCWEs) GetCWEID() string {
	if a == nil || a.CWEID == nil {
		return ""
	}
	return *a.CWEID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (a *AdvisoryCWEs) GetName() string {
	if a == nil || a.Name == nil {
		return ""
	}
	return *a.Name
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (a *AdvisoryIdentifier) GetType() string {
	if a == nil || a.Type == nil {
		return ""
	}
	return *a.Type
}

// GetValue returns the Value field if it's non-nil, zero value otherwise.
func (a *AdvisoryIdentifier) GetValue() string {
	if a == nil || a.Value == nil {
		return ""
	}
	return *a.Value
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *AdvisoryReference) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetFirstPatchedVersion returns the FirstPatchedVersion field.
func (a *AdvisoryVulnerability) GetFirstPatchedVersion() *FirstPatchedVersion {
	if a == nil {
		return nil
	}
	return a.FirstPatchedVersion
}

// GetPackage returns the Package field.
func (a *AdvisoryVulnerability) GetPackage() *VulnerabilityPackage {
	if a == nil {
		return nil
	}
	return a.Package
}

// GetPatchedVersions returns the PatchedVersions field if it's non-nil, zero value otherwise.
func (a *AdvisoryVulnerability) GetPatchedVersions() string {
	if a == nil || a.PatchedVersions == nil {
		return ""
	}
	return *a.PatchedVersions
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (a *AdvisoryVulnerability) GetSeverity() string {
	if a == nil || a.Severity == nil {
		return ""
	}
	return *a.Severity
}

// GetVulnerableVersionRange returns the VulnerableVersionRange field if it's non-nil, zero value otherwise.
func (a *AdvisoryVulnerability) GetVulnerableVersionRange() string {
	if a == nil || a.VulnerableVersionRange == nil {
		return ""
	}
	return *a.VulnerableVersionRange
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (a *Alert) GetClosedAt() Timestamp {
	if a == nil || a.ClosedAt == nil {
		return Timestamp{}
	}
	return *a.ClosedAt
}

// GetClosedBy returns the ClosedBy field.
func (a *Alert) GetClosedBy() *User {
	if a == nil {
		return nil
	}
	return a.ClosedBy
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *Alert) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetDismissedAt returns the DismissedAt field if it's non-nil, zero value otherwise.
func (a *Alert) GetDismissedAt() Timestamp {
	if a == nil || a.DismissedAt == nil {
		return Timestamp{}
	}
	return *a.DismissedAt
}

// GetDismissedBy returns the DismissedBy field.
func (a *Alert) GetDismissedBy() *User {
	if a == nil {
		return nil
	}
	return a.DismissedBy
}

// GetDismissedComment returns the DismissedComment field if it's non-nil, zero value otherwise.
func (a *Alert) GetDismissedComment() string {
	if a == nil || a.DismissedComment == nil {
		return ""
	}
	return *a.DismissedComment
}

// GetDismissedReason returns the DismissedReason field if it's non-nil, zero value otherwise.
func (a *Alert) GetDismissedReason() string {
	if a == nil || a.DismissedReason == nil {
		return ""
	}
	return *a.DismissedReason
}

// GetFixedAt returns the FixedAt field if it's non-nil, zero value otherwise.
func (a *Alert) GetFixedAt() Timestamp {
	if a == nil || a.FixedAt == nil {
		return Timestamp{}
	}
	return *a.FixedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (a *Alert) GetHTMLURL() string {
	if a == nil || a.HTMLURL == nil {
		return ""
	}
	return *a.HTMLURL
}

// GetInstancesURL returns the InstancesURL field if it's non-nil, zero value otherwise.
func (a *Alert) GetInstancesURL() string {
	if a == nil || a.InstancesURL == nil {
		return ""
	}
	return *a.InstancesURL
}

// GetMostRecentInstance returns the MostRecentInstance field.
func (a *Alert) GetMostRecentInstance() *MostRecentInstance {
	if a == nil {
		return nil
	}
	return a.MostRecentInstance
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (a *Alert) GetNumber() int {
	if a == nil || a.Number == nil {
		return 0
	}
	return *a.Number
}

// GetRepository returns the Repository field.
func (a *Alert) GetRepository() *Repository {
	if a == nil {
		return nil
	}
	return a.Repository
}

// GetRule returns the Rule field.
func (a *Alert) GetRule() *Rule {
	if a == nil {
		return nil
	}
	return a.Rule
}

// GetRuleDescription returns the RuleDescription field if it's non-nil, zero value otherwise.
func (a *Alert) GetRuleDescription() string {
	if a == nil || a.RuleDescription == nil {
		return ""
	}
	return *a.RuleDescription
}

// GetRuleID returns the RuleID field if it's non-nil, zero value otherwise.
func (a *Alert) GetRuleID() string {
	if a == nil || a.RuleID == nil {
		return ""
	}
	return *a.RuleID
}

// GetRuleSeverity returns the RuleSeverity field if it's non-nil, zero value otherwise.
func (a *Alert) GetRuleSeverity() string {
	if a == nil || a.RuleSeverity == nil {
		return ""
	}
	return *a.RuleSeverity
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (a *Alert) GetState() string {
	if a == nil || a.State == nil {
		return ""
	}
	return *a.State
}

// GetTool returns the Tool field.
func (a *Alert) GetTool() *Tool {
	if a == nil {
		return nil
	}
	return a.Tool
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *Alert) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *Alert) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (a *AllowDeletionsEnforcementLevelChanges) GetFrom() string {
	if a == nil || a.From == nil {
		return ""
	}
	return *a.From
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (a *AllowForkSyncing) GetEnabled() bool {
	if a == nil || a.Enabled == nil {
		return false
	}
	return *a.Enabled
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (a *AnalysesListOptions) GetRef() string {
	if a == nil || a.Ref == nil {
		return ""
	}
	return *a.Ref
}

// GetSarifID returns the SarifID field if it's non-nil, zero value otherwise.
func (a *AnalysesListOptions) GetSarifID() string {
	if a == nil || a.SarifID == nil {
		return ""
	}
	return *a.SarifID
}

// GetDomains returns the Domains field.
func (a *APIMeta) GetDomains() *APIMetaDomains {
	if a == nil {
		return nil
	}
	return a.Domains
}

// GetSSHKeyFingerprints returns the SSHKeyFingerprints map if it's non-nil, an empty map otherwise.
func (a *APIMeta) GetSSHKeyFingerprints() map[string]string {
	if a == nil || a.SSHKeyFingerprints == nil {
		return map[string]string{}
	}
	return a.SSHKeyFingerprints
}

// GetVerifiablePasswordAuthentication returns the VerifiablePasswordAuthentication field if it's non-nil, zero value otherwise.
func (a *APIMeta) GetVerifiablePasswordAuthentication() bool {
	if a == nil || a.VerifiablePasswordAuthentication == nil {
		return false
	}
	return *a.VerifiablePasswordAuthentication
}

// GetArtifactAttestations returns the ArtifactAttestations field.
func (a *APIMetaDomains) GetArtifactAttestations() *APIMetaArtifactAttestations {
	if a == nil {
		return nil
	}
	return a.ArtifactAttestations
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *App) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (a *App) GetDescription() string {
	if a == nil || a.Description == nil {
		return ""
	}
	return *a.Description
}

// GetExternalURL returns the ExternalURL field if it's non-nil, zero value otherwise.
func (a *App) GetExternalURL() string {
	if a == nil || a.ExternalURL == nil {
		return ""
	}
	return *a.ExternalURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (a *App) GetHTMLURL() string {
	if a == nil || a.HTMLURL == nil {
		return ""
	}
	return *a.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *App) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetInstallationsCount returns the InstallationsCount field if it's non-nil, zero value otherwise.
func (a *App) GetInstallationsCount() int {
	if a == nil || a.InstallationsCount == nil {
		return 0
	}
	return *a.InstallationsCount
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (a *App) GetName() string {
	if a == nil || a.Name == nil {
		return ""
	}
	return *a.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (a *App) GetNodeID() string {
	if a == nil || a.NodeID == nil {
		return ""
	}
	return *a.NodeID
}

// GetOwner returns the Owner field.
func (a *App) GetOwner() *User {
	if a == nil {
		return nil
	}
	return a.Owner
}

// GetPermissions returns the Permissions field.
func (a *App) GetPermissions() *InstallationPermissions {
	if a == nil {
		return nil
	}
	return a.Permissions
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (a *App) GetSlug() string {
	if a == nil || a.Slug == nil {
		return ""
	}
	return *a.Slug
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *App) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetClientID returns the ClientID field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetClientID() string {
	if a == nil || a.ClientID == nil {
		return ""
	}
	return *a.ClientID
}

// GetClientSecret returns the ClientSecret field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetClientSecret() string {
	if a == nil || a.ClientSecret == nil {
		return ""
	}
	return *a.ClientSecret
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetDescription() string {
	if a == nil || a.Description == nil {
		return ""
	}
	return *a.Description
}

// GetExternalURL returns the ExternalURL field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetExternalURL() string {
	if a == nil || a.ExternalURL == nil {
		return ""
	}
	return *a.ExternalURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetHTMLURL() string {
	if a == nil || a.HTMLURL == nil {
		return ""
	}
	return *a.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetName() string {
	if a == nil || a.Name == nil {
		return ""
	}
	return *a.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetNodeID() string {
	if a == nil || a.NodeID == nil {
		return ""
	}
	return *a.NodeID
}

// GetOwner returns the Owner field.
func (a *AppConfig) GetOwner() *User {
	if a == nil {
		return nil
	}
	return a.Owner
}

// GetPEM returns the PEM field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetPEM() string {
	if a == nil || a.PEM == nil {
		return ""
	}
	return *a.PEM
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetSlug() string {
	if a == nil || a.Slug == nil {
		return ""
	}
	return *a.Slug
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetWebhookSecret returns the WebhookSecret field if it's non-nil, zero value otherwise.
func (a *AppConfig) GetWebhookSecret() string {
	if a == nil || a.WebhookSecret == nil {
		return ""
	}
	return *a.WebhookSecret
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (a *ArchivedAt) GetFrom() Timestamp {
	if a == nil || a.From == nil {
		return Timestamp{}
	}
	return *a.From
}

// GetTo returns the To field if it's non-nil, zero value otherwise.
func (a *ArchivedAt) GetTo() Timestamp {
	if a == nil || a.To == nil {
		return Timestamp{}
	}
	return *a.To
}

// GetArchiveDownloadURL returns the ArchiveDownloadURL field if it's non-nil, zero value otherwise.
func (a *Artifact) GetArchiveDownloadURL() string {
	if a == nil || a.ArchiveDownloadURL == nil {
		return ""
	}
	return *a.ArchiveDownloadURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *Artifact) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetExpired returns the Expired field if it's non-nil, zero value otherwise.
func (a *Artifact) GetExpired() bool {
	if a == nil || a.Expired == nil {
		return false
	}
	return *a.Expired
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (a *Artifact) GetExpiresAt() Timestamp {
	if a == nil || a.ExpiresAt == nil {
		return Timestamp{}
	}
	return *a.ExpiresAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *Artifact) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (a *Artifact) GetName() string {
	if a == nil || a.Name == nil {
		return ""
	}
	return *a.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (a *Artifact) GetNodeID() string {
	if a == nil || a.NodeID == nil {
		return ""
	}
	return *a.NodeID
}

// GetSizeInBytes returns the SizeInBytes field if it's non-nil, zero value otherwise.
func (a *Artifact) GetSizeInBytes() int64 {
	if a == nil || a.SizeInBytes == nil {
		return 0
	}
	return *a.SizeInBytes
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *Artifact) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *Artifact) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetWorkflowRun returns the WorkflowRun field.
func (a *Artifact) GetWorkflowRun() *ArtifactWorkflowRun {
	if a == nil {
		return nil
	}
	return a.WorkflowRun
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (a *ArtifactList) GetTotalCount() int64 {
	if a == nil || a.TotalCount == nil {
		return 0
	}
	return *a.TotalCount
}

// GetHeadBranch returns the HeadBranch field if it's non-nil, zero value otherwise.
func (a *ArtifactWorkflowRun) GetHeadBranch() string {
	if a == nil || a.HeadBranch == nil {
		return ""
	}
	return *a.HeadBranch
}

// GetHeadRepositoryID returns the HeadRepositoryID field if it's non-nil, zero value otherwise.
func (a *ArtifactWorkflowRun) GetHeadRepositoryID() int64 {
	if a == nil || a.HeadRepositoryID == nil {
		return 0
	}
	return *a.HeadRepositoryID
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (a *ArtifactWorkflowRun) GetHeadSHA() string {
	if a == nil || a.HeadSHA == nil {
		return ""
	}
	return *a.HeadSHA
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *ArtifactWorkflowRun) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetRepositoryID returns the RepositoryID field if it's non-nil, zero value otherwise.
func (a *ArtifactWorkflowRun) GetRepositoryID() int64 {
	if a == nil || a.RepositoryID == nil {
		return 0
	}
	return *a.RepositoryID
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (a *Attachment) GetBody() string {
	if a == nil || a.Body == nil {
		return ""
	}
	return *a.Body
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *Attachment) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (a *Attachment) GetTitle() string {
	if a == nil || a.Title == nil {
		return ""
	}
	return *a.Title
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetAction() string {
	if a == nil || a.Action == nil {
		return ""
	}
	return *a.Action
}

// GetActor returns the Actor field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetActor() string {
	if a == nil || a.Actor == nil {
		return ""
	}
	return *a.Actor
}

// GetActorID returns the ActorID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetActorID() int64 {
	if a == nil || a.ActorID == nil {
		return 0
	}
	return *a.ActorID
}

// GetActorLocation returns the ActorLocation field.
func (a *AuditEntry) GetActorLocation() *ActorLocation {
	if a == nil {
		return nil
	}
	return a.ActorLocation
}

// GetBusiness returns the Business field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetBusiness() string {
	if a == nil || a.Business == nil {
		return ""
	}
	return *a.Business
}

// GetBusinessID returns the BusinessID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetBusinessID() int64 {
	if a == nil || a.BusinessID == nil {
		return 0
	}
	return *a.BusinessID
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetDocumentID returns the DocumentID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetDocumentID() string {
	if a == nil || a.DocumentID == nil {
		return ""
	}
	return *a.DocumentID
}

// GetExternalIdentityNameID returns the ExternalIdentityNameID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetExternalIdentityNameID() string {
	if a == nil || a.ExternalIdentityNameID == nil {
		return ""
	}
	return *a.ExternalIdentityNameID
}

// GetExternalIdentityUsername returns the ExternalIdentityUsername field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetExternalIdentityUsername() string {
	if a == nil || a.ExternalIdentityUsername == nil {
		return ""
	}
	return *a.ExternalIdentityUsername
}

// GetHashedToken returns the HashedToken field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetHashedToken() string {
	if a == nil || a.HashedToken == nil {
		return ""
	}
	return *a.HashedToken
}

// GetOrg returns the Org field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetOrg() string {
	if a == nil || a.Org == nil {
		return ""
	}
	return *a.Org
}

// GetOrgID returns the OrgID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetOrgID() int64 {
	if a == nil || a.OrgID == nil {
		return 0
	}
	return *a.OrgID
}

// GetTimestamp returns the Timestamp field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetTimestamp() Timestamp {
	if a == nil || a.Timestamp == nil {
		return Timestamp{}
	}
	return *a.Timestamp
}

// GetTokenID returns the TokenID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetTokenID() int64 {
	if a == nil || a.TokenID == nil {
		return 0
	}
	return *a.TokenID
}

// GetTokenScopes returns the TokenScopes field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetTokenScopes() string {
	if a == nil || a.TokenScopes == nil {
		return ""
	}
	return *a.TokenScopes
}

// GetUser returns the User field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetUser() string {
	if a == nil || a.User == nil {
		return ""
	}
	return *a.User
}

// GetUserID returns the UserID field if it's non-nil, zero value otherwise.
func (a *AuditEntry) GetUserID() int64 {
	if a == nil || a.UserID == nil {
		return 0
	}
	return *a.UserID
}

// GetApp returns the App field.
func (a *Authorization) GetApp() *AuthorizationApp {
	if a == nil {
		return nil
	}
	return a.App
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (a *Authorization) GetCreatedAt() Timestamp {
	if a == nil || a.CreatedAt == nil {
		return Timestamp{}
	}
	return *a.CreatedAt
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (a *Authorization) GetFingerprint() string {
	if a == nil || a.Fingerprint == nil {
		return ""
	}
	return *a.Fingerprint
}

// GetHashedToken returns the HashedToken field if it's non-nil, zero value otherwise.
func (a *Authorization) GetHashedToken() string {
	if a == nil || a.HashedToken == nil {
		return ""
	}
	return *a.HashedToken
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *Authorization) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetNote returns the Note field if it's non-nil, zero value otherwise.
func (a *Authorization) GetNote() string {
	if a == nil || a.Note == nil {
		return ""
	}
	return *a.Note
}

// GetNoteURL returns the NoteURL field if it's non-nil, zero value otherwise.
func (a *Authorization) GetNoteURL() string {
	if a == nil || a.NoteURL == nil {
		return ""
	}
	return *a.NoteURL
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (a *Authorization) GetToken() string {
	if a == nil || a.Token == nil {
		return ""
	}
	return *a.Token
}

// GetTokenLastEight returns the TokenLastEight field if it's non-nil, zero value otherwise.
func (a *Authorization) GetTokenLastEight() string {
	if a == nil || a.TokenLastEight == nil {
		return ""
	}
	return *a.TokenLastEight
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (a *Authorization) GetUpdatedAt() Timestamp {
	if a == nil || a.UpdatedAt == nil {
		return Timestamp{}
	}
	return *a.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *Authorization) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetUser returns the User field.
func (a *Authorization) GetUser() *User {
	if a == nil {
		return nil
	}
	return a.User
}

// GetClientID returns the ClientID field if it's non-nil, zero value otherwise.
func (a *AuthorizationApp) GetClientID() string {
	if a == nil || a.ClientID == nil {
		return ""
	}
	return *a.ClientID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (a *AuthorizationApp) GetName() string {
	if a == nil || a.Name == nil {
		return ""
	}
	return *a.Name
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (a *AuthorizationApp) GetURL() string {
	if a == nil || a.URL == nil {
		return ""
	}
	return *a.URL
}

// GetClientID returns the ClientID field if it's non-nil, zero value otherwise.
func (a *AuthorizationRequest) GetClientID() string {
	if a == nil || a.ClientID == nil {
		return ""
	}
	return *a.ClientID
}

// GetClientSecret returns the ClientSecret field if it's non-nil, zero value otherwise.
func (a *AuthorizationRequest) GetClientSecret() string {
	if a == nil || a.ClientSecret == nil {
		return ""
	}
	return *a.ClientSecret
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (a *AuthorizationRequest) GetFingerprint() string {
	if a == nil || a.Fingerprint == nil {
		return ""
	}
	return *a.Fingerprint
}

// GetNote returns the Note field if it's non-nil, zero value otherwise.
func (a *AuthorizationRequest) GetNote() string {
	if a == nil || a.Note == nil {
		return ""
	}
	return *a.Note
}

// GetNoteURL returns the NoteURL field if it's non-nil, zero value otherwise.
func (a *AuthorizationRequest) GetNoteURL() string {
	if a == nil || a.NoteURL == nil {
		return ""
	}
	return *a.NoteURL
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (a *AuthorizationUpdateRequest) GetFingerprint() string {
	if a == nil || a.Fingerprint == nil {
		return ""
	}
	return *a.Fingerprint
}

// GetNote returns the Note field if it's non-nil, zero value otherwise.
func (a *AuthorizationUpdateRequest) GetNote() string {
	if a == nil || a.Note == nil {
		return ""
	}
	return *a.Note
}

// GetNoteURL returns the NoteURL field if it's non-nil, zero value otherwise.
func (a *AuthorizationUpdateRequest) GetNoteURL() string {
	if a == nil || a.NoteURL == nil {
		return ""
	}
	return *a.NoteURL
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (a *AuthorizedActorsOnly) GetFrom() bool {
	if a == nil || a.From == nil {
		return false
	}
	return *a.From
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (a *AuthorizedDismissalActorsOnlyChanges) GetFrom() bool {
	if a == nil || a.From == nil {
		return false
	}
	return *a.From
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (a *Autolink) GetID() int64 {
	if a == nil || a.ID == nil {
		return 0
	}
	return *a.ID
}

// GetIsAlphanumeric returns the IsAlphanumeric field if it's non-nil, zero value otherwise.
func (a *Autolink) GetIsAlphanumeric() bool {
	if a == nil || a.IsAlphanumeric == nil {
		return false
	}
	return *a.IsAlphanumeric
}

// GetKeyPrefix returns the KeyPrefix field if it's non-nil, zero value otherwise.
func (a *Autolink) GetKeyPrefix() string {
	if a == nil || a.KeyPrefix == nil {
		return ""
	}
	return *a.KeyPrefix
}

// GetURLTemplate returns the URLTemplate field if it's non-nil, zero value otherwise.
func (a *Autolink) GetURLTemplate() string {
	if a == nil || a.URLTemplate == nil {
		return ""
	}
	return *a.URLTemplate
}

// GetIsAlphanumeric returns the IsAlphanumeric field if it's non-nil, zero value otherwise.
func (a *AutolinkOptions) GetIsAlphanumeric() bool {
	if a == nil || a.IsAlphanumeric == nil {
		return false
	}
	return *a.IsAlphanumeric
}

// GetKeyPrefix returns the KeyPrefix field if it's non-nil, zero value otherwise.
func (a *AutolinkOptions) GetKeyPrefix() string {
	if a == nil || a.KeyPrefix == nil {
		return ""
	}
	return *a.KeyPrefix
}

// GetURLTemplate returns the URLTemplate field if it's non-nil, zero value otherwise.
func (a *AutolinkOptions) GetURLTemplate() string {
	if a == nil || a.URLTemplate == nil {
		return ""
	}
	return *a.URLTemplate
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (a *AutomatedSecurityFixes) GetEnabled() bool {
	if a == nil || a.Enabled == nil {
		return false
	}
	return *a.Enabled
}

// GetPaused returns the Paused field if it's non-nil, zero value otherwise.
func (a *AutomatedSecurityFixes) GetPaused() bool {
	if a == nil || a.Paused == nil {
		return false
	}
	return *a.Paused
}

// GetAppID returns the AppID field if it's non-nil, zero value otherwise.
func (a *AutoTriggerCheck) GetAppID() int64 {
	if a == nil || a.AppID == nil {
		return 0
	}
	return *a.AppID
}

// GetSetting returns the Setting field if it's non-nil, zero value otherwise.
func (a *AutoTriggerCheck) GetSetting() bool {
	if a == nil || a.Setting == nil {
		return false
	}
	return *a.Setting
}

// GetContent returns the Content field if it's non-nil, zero value otherwise.
func (b *Blob) GetContent() string {
	if b == nil || b.Content == nil {
		return ""
	}
	return *b.Content
}

// GetEncoding returns the Encoding field if it's non-nil, zero value otherwise.
func (b *Blob) GetEncoding() string {
	if b == nil || b.Encoding == nil {
		return ""
	}
	return *b.Encoding
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (b *Blob) GetNodeID() string {
	if b == nil || b.NodeID == nil {
		return ""
	}
	return *b.NodeID
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (b *Blob) GetSHA() string {
	if b == nil || b.SHA == nil {
		return ""
	}
	return *b.SHA
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (b *Blob) GetSize() int {
	if b == nil || b.Size == nil {
		return 0
	}
	return *b.Size
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (b *Blob) GetURL() string {
	if b == nil || b.URL == nil {
		return ""
	}
	return *b.URL
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (b *BlockCreations) GetEnabled() bool {
	if b == nil || b.Enabled == nil {
		return false
	}
	return *b.Enabled
}

// GetCommit returns the Commit field.
func (b *Branch) GetCommit() *RepositoryCommit {
	if b == nil {
		return nil
	}
	return b.Commit
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (b *Branch) GetName() string {
	if b == nil || b.Name == nil {
		return ""
	}
	return *b.Name
}

// GetProtected returns the Protected field if it's non-nil, zero value otherwise.
func (b *Branch) GetProtected() bool {
	if b == nil || b.Protected == nil {
		return false
	}
	return *b.Protected
}

// GetProtection returns the Protection field.
func (b *Branch) GetProtection() *Protection {
	if b == nil {
		return nil
	}
	return b.Protection
}

// GetCommit returns the Commit field.
func (b *BranchCommit) GetCommit() *Commit {
	if b == nil {
		return nil
	}
	return b.Commit
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (b *BranchCommit) GetName() string {
	if b == nil || b.Name == nil {
		return ""
	}
	return *b.Name
}

// GetProtected returns the Protected field if it's non-nil, zero value otherwise.
func (b *BranchCommit) GetProtected() bool {
	if b == nil || b.Protected == nil {
		return false
	}
	return *b.Protected
}

// GetProtected returns the Protected field if it's non-nil, zero value otherwise.
func (b *BranchListOptions) GetProtected() bool {
	if b == nil || b.Protected == nil {
		return false
	}
	return *b.Protected
}

// GetCustomBranchPolicies returns the CustomBranchPolicies field if it's non-nil, zero value otherwise.
func (b *BranchPolicy) GetCustomBranchPolicies() bool {
	if b == nil || b.CustomBranchPolicies == nil {
		return false
	}
	return *b.CustomBranchPolicies
}

// GetProtectedBranches returns the ProtectedBranches field if it's non-nil, zero value otherwise.
func (b *BranchPolicy) GetProtectedBranches() bool {
	if b == nil || b.ProtectedBranches == nil {
		return false
	}
	return *b.ProtectedBranches
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (b *BranchProtectionConfigurationEvent) GetAction() string {
	if b == nil || b.Action == nil {
		return ""
	}
	return *b.Action
}

// GetEnterprise returns the Enterprise field.
func (b *BranchProtectionConfigurationEvent) GetEnterprise() *Enterprise {
	if b == nil {
		return nil
	}
	return b.Enterprise
}

// GetInstallation returns the Installation field.
func (b *BranchProtectionConfigurationEvent) GetInstallation() *Installation {
	if b == nil {
		return nil
	}
	return b.Installation
}

// GetOrg returns the Org field.
func (b *BranchProtectionConfigurationEvent) GetOrg() *Organization {
	if b == nil {
		return nil
	}
	return b.Org
}

// GetRepo returns the Repo field.
func (b *BranchProtectionConfigurationEvent) GetRepo() *Repository {
	if b == nil {
		return nil
	}
	return b.Repo
}

// GetSender returns the Sender field.
func (b *BranchProtectionConfigurationEvent) GetSender() *User {
	if b == nil {
		return nil
	}
	return b.Sender
}

// GetAdminEnforced returns the AdminEnforced field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetAdminEnforced() bool {
	if b == nil || b.AdminEnforced == nil {
		return false
	}
	return *b.AdminEnforced
}

// GetAllowDeletionsEnforcementLevel returns the AllowDeletionsEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetAllowDeletionsEnforcementLevel() string {
	if b == nil || b.AllowDeletionsEnforcementLevel == nil {
		return ""
	}
	return *b.AllowDeletionsEnforcementLevel
}

// GetAllowForcePushesEnforcementLevel returns the AllowForcePushesEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetAllowForcePushesEnforcementLevel() string {
	if b == nil || b.AllowForcePushesEnforcementLevel == nil {
		return ""
	}
	return *b.AllowForcePushesEnforcementLevel
}

// GetAuthorizedActorsOnly returns the AuthorizedActorsOnly field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetAuthorizedActorsOnly() bool {
	if b == nil || b.AuthorizedActorsOnly == nil {
		return false
	}
	return *b.AuthorizedActorsOnly
}

// GetAuthorizedDismissalActorsOnly returns the AuthorizedDismissalActorsOnly field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetAuthorizedDismissalActorsOnly() bool {
	if b == nil || b.AuthorizedDismissalActorsOnly == nil {
		return false
	}
	return *b.AuthorizedDismissalActorsOnly
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetCreatedAt() Timestamp {
	if b == nil || b.CreatedAt == nil {
		return Timestamp{}
	}
	return *b.CreatedAt
}

// GetDismissStaleReviewsOnPush returns the DismissStaleReviewsOnPush field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetDismissStaleReviewsOnPush() bool {
	if b == nil || b.DismissStaleReviewsOnPush == nil {
		return false
	}
	return *b.DismissStaleReviewsOnPush
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetID() int64 {
	if b == nil || b.ID == nil {
		return 0
	}
	return *b.ID
}

// GetIgnoreApprovalsFromContributors returns the IgnoreApprovalsFromContributors field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetIgnoreApprovalsFromContributors() bool {
	if b == nil || b.IgnoreApprovalsFromContributors == nil {
		return false
	}
	return *b.IgnoreApprovalsFromContributors
}

// GetLinearHistoryRequirementEnforcementLevel returns the LinearHistoryRequirementEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetLinearHistoryRequirementEnforcementLevel() string {
	if b == nil || b.LinearHistoryRequirementEnforcementLevel == nil {
		return ""
	}
	return *b.LinearHistoryRequirementEnforcementLevel
}

// GetMergeQueueEnforcementLevel returns the MergeQueueEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetMergeQueueEnforcementLevel() string {
	if b == nil || b.MergeQueueEnforcementLevel == nil {
		return ""
	}
	return *b.MergeQueueEnforcementLevel
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetName() string {
	if b == nil || b.Name == nil {
		return ""
	}
	return *b.Name
}

// GetPullRequestReviewsEnforcementLevel returns the PullRequestReviewsEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetPullRequestReviewsEnforcementLevel() string {
	if b == nil || b.PullRequestReviewsEnforcementLevel == nil {
		return ""
	}
	return *b.PullRequestReviewsEnforcementLevel
}

// GetRepositoryID returns the RepositoryID field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRepositoryID() int64 {
	if b == nil || b.RepositoryID == nil {
		return 0
	}
	return *b.RepositoryID
}

// GetRequireCodeOwnerReview returns the RequireCodeOwnerReview field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRequireCodeOwnerReview() bool {
	if b == nil || b.RequireCodeOwnerReview == nil {
		return false
	}
	return *b.RequireCodeOwnerReview
}

// GetRequiredApprovingReviewCount returns the RequiredApprovingReviewCount field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRequiredApprovingReviewCount() int {
	if b == nil || b.RequiredApprovingReviewCount == nil {
		return 0
	}
	return *b.RequiredApprovingReviewCount
}

// GetRequiredConversationResolutionLevel returns the RequiredConversationResolutionLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRequiredConversationResolutionLevel() string {
	if b == nil || b.RequiredConversationResolutionLevel == nil {
		return ""
	}
	return *b.RequiredConversationResolutionLevel
}

// GetRequiredDeploymentsEnforcementLevel returns the RequiredDeploymentsEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRequiredDeploymentsEnforcementLevel() string {
	if b == nil || b.RequiredDeploymentsEnforcementLevel == nil {
		return ""
	}
	return *b.RequiredDeploymentsEnforcementLevel
}

// GetRequiredStatusChecksEnforcementLevel returns the RequiredStatusChecksEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetRequiredStatusChecksEnforcementLevel() string {
	if b == nil || b.RequiredStatusChecksEnforcementLevel == nil {
		return ""
	}
	return *b.RequiredStatusChecksEnforcementLevel
}

// GetSignatureRequirementEnforcementLevel returns the SignatureRequirementEnforcementLevel field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetSignatureRequirementEnforcementLevel() string {
	if b == nil || b.SignatureRequirementEnforcementLevel == nil {
		return ""
	}
	return *b.SignatureRequirementEnforcementLevel
}

// GetStrictRequiredStatusChecksPolicy returns the StrictRequiredStatusChecksPolicy field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetStrictRequiredStatusChecksPolicy() bool {
	if b == nil || b.StrictRequiredStatusChecksPolicy == nil {
		return false
	}
	return *b.StrictRequiredStatusChecksPolicy
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRule) GetUpdatedAt() Timestamp {
	if b == nil || b.UpdatedAt == nil {
		return Timestamp{}
	}
	return *b.UpdatedAt
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (b *BranchProtectionRuleEvent) GetAction() string {
	if b == nil || b.Action == nil {
		return ""
	}
	return *b.Action
}

// GetChanges returns the Changes field.
func (b *BranchProtectionRuleEvent) GetChanges() *ProtectionChanges {
	if b == nil {
		return nil
	}
	return b.Changes
}

// GetInstallation returns the Installation field.
func (b *BranchProtectionRuleEvent) GetInstallation() *Installation {
	if b == nil {
		return nil
	}
	return b.Installation
}

// GetOrg returns the Org field.
func (b *BranchProtectionRuleEvent) GetOrg() *Organization {
	if b == nil {
		return nil
	}
	return b.Org
}

// GetRepo returns the Repo field.
func (b *BranchProtectionRuleEvent) GetRepo() *Repository {
	if b == nil {
		return nil
	}
	return b.Repo
}

// GetRule returns the Rule field.
func (b *BranchProtectionRuleEvent) GetRule() *BranchProtectionRule {
	if b == nil {
		return nil
	}
	return b.Rule
}

// GetSender returns the Sender field.
func (b *BranchProtectionRuleEvent) GetSender() *User {
	if b == nil {
		return nil
	}
	return b.Sender
}

// GetActorID returns the ActorID field if it's non-nil, zero value otherwise.
func (b *BypassActor) GetActorID() int64 {
	if b == nil || b.ActorID == nil {
		return 0
	}
	return *b.ActorID
}

// GetActorType returns the ActorType field.
func (b *BypassActor) GetActorType() *BypassActorType {
	if b == nil {
		return nil
	}
	return b.ActorType
}

// GetBypassMode returns the BypassMode field.
func (b *BypassActor) GetBypassMode() *BypassMode {
	if b == nil {
		return nil
	}
	return b.BypassMode
}

// GetApp returns the App field.
func (c *CheckRun) GetApp() *App {
	if c == nil {
		return nil
	}
	return c.App
}

// GetCheckSuite returns the CheckSuite field.
func (c *CheckRun) GetCheckSuite() *CheckSuite {
	if c == nil {
		return nil
	}
	return c.CheckSuite
}

// GetCompletedAt returns the CompletedAt field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetCompletedAt() Timestamp {
	if c == nil || c.CompletedAt == nil {
		return Timestamp{}
	}
	return *c.CompletedAt
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetConclusion() string {
	if c == nil || c.Conclusion == nil {
		return ""
	}
	return *c.Conclusion
}

// GetDetailsURL returns the DetailsURL field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetDetailsURL() string {
	if c == nil || c.DetailsURL == nil {
		return ""
	}
	return *c.DetailsURL
}

// GetExternalID returns the ExternalID field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetExternalID() string {
	if c == nil || c.ExternalID == nil {
		return ""
	}
	return *c.ExternalID
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetHeadSHA() string {
	if c == nil || c.HeadSHA == nil {
		return ""
	}
	return *c.HeadSHA
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetOutput returns the Output field.
func (c *CheckRun) GetOutput() *CheckRunOutput {
	if c == nil {
		return nil
	}
	return c.Output
}

// GetStartedAt returns the StartedAt field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetStartedAt() Timestamp {
	if c == nil || c.StartedAt == nil {
		return Timestamp{}
	}
	return *c.StartedAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CheckRun) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetAnnotationLevel returns the AnnotationLevel field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetAnnotationLevel() string {
	if c == nil || c.AnnotationLevel == nil {
		return ""
	}
	return *c.AnnotationLevel
}

// GetEndColumn returns the EndColumn field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetEndColumn() int {
	if c == nil || c.EndColumn == nil {
		return 0
	}
	return *c.EndColumn
}

// GetEndLine returns the EndLine field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetEndLine() int {
	if c == nil || c.EndLine == nil {
		return 0
	}
	return *c.EndLine
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetMessage() string {
	if c == nil || c.Message == nil {
		return ""
	}
	return *c.Message
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetPath() string {
	if c == nil || c.Path == nil {
		return ""
	}
	return *c.Path
}

// GetRawDetails returns the RawDetails field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetRawDetails() string {
	if c == nil || c.RawDetails == nil {
		return ""
	}
	return *c.RawDetails
}

// GetStartColumn returns the StartColumn field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetStartColumn() int {
	if c == nil || c.StartColumn == nil {
		return 0
	}
	return *c.StartColumn
}

// GetStartLine returns the StartLine field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetStartLine() int {
	if c == nil || c.StartLine == nil {
		return 0
	}
	return *c.StartLine
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (c *CheckRunAnnotation) GetTitle() string {
	if c == nil || c.Title == nil {
		return ""
	}
	return *c.Title
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CheckRunEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetCheckRun returns the CheckRun field.
func (c *CheckRunEvent) GetCheckRun() *CheckRun {
	if c == nil {
		return nil
	}
	return c.CheckRun
}

// GetInstallation returns the Installation field.
func (c *CheckRunEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CheckRunEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetRepo returns the Repo field.
func (c *CheckRunEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetRequestedAction returns the RequestedAction field.
func (c *CheckRunEvent) GetRequestedAction() *RequestedAction {
	if c == nil {
		return nil
	}
	return c.RequestedAction
}

// GetSender returns the Sender field.
func (c *CheckRunEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetAlt returns the Alt field if it's non-nil, zero value otherwise.
func (c *CheckRunImage) GetAlt() string {
	if c == nil || c.Alt == nil {
		return ""
	}
	return *c.Alt
}

// GetCaption returns the Caption field if it's non-nil, zero value otherwise.
func (c *CheckRunImage) GetCaption() string {
	if c == nil || c.Caption == nil {
		return ""
	}
	return *c.Caption
}

// GetImageURL returns the ImageURL field if it's non-nil, zero value otherwise.
func (c *CheckRunImage) GetImageURL() string {
	if c == nil || c.ImageURL == nil {
		return ""
	}
	return *c.ImageURL
}

// GetAnnotationsCount returns the AnnotationsCount field if it's non-nil, zero value otherwise.
func (c *CheckRunOutput) GetAnnotationsCount() int {
	if c == nil || c.AnnotationsCount == nil {
		return 0
	}
	return *c.AnnotationsCount
}

// GetAnnotationsURL returns the AnnotationsURL field if it's non-nil, zero value otherwise.
func (c *CheckRunOutput) GetAnnotationsURL() string {
	if c == nil || c.AnnotationsURL == nil {
		return ""
	}
	return *c.AnnotationsURL
}

// GetSummary returns the Summary field if it's non-nil, zero value otherwise.
func (c *CheckRunOutput) GetSummary() string {
	if c == nil || c.Summary == nil {
		return ""
	}
	return *c.Summary
}

// GetText returns the Text field if it's non-nil, zero value otherwise.
func (c *CheckRunOutput) GetText() string {
	if c == nil || c.Text == nil {
		return ""
	}
	return *c.Text
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (c *CheckRunOutput) GetTitle() string {
	if c == nil || c.Title == nil {
		return ""
	}
	return *c.Title
}

// GetAfterSHA returns the AfterSHA field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetAfterSHA() string {
	if c == nil || c.AfterSHA == nil {
		return ""
	}
	return *c.AfterSHA
}

// GetApp returns the App field.
func (c *CheckSuite) GetApp() *App {
	if c == nil {
		return nil
	}
	return c.App
}

// GetBeforeSHA returns the BeforeSHA field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetBeforeSHA() string {
	if c == nil || c.BeforeSHA == nil {
		return ""
	}
	return *c.BeforeSHA
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetConclusion() string {
	if c == nil || c.Conclusion == nil {
		return ""
	}
	return *c.Conclusion
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetHeadBranch returns the HeadBranch field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetHeadBranch() string {
	if c == nil || c.HeadBranch == nil {
		return ""
	}
	return *c.HeadBranch
}

// GetHeadCommit returns the HeadCommit field.
func (c *CheckSuite) GetHeadCommit() *Commit {
	if c == nil {
		return nil
	}
	return c.HeadCommit
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetHeadSHA() string {
	if c == nil || c.HeadSHA == nil {
		return ""
	}
	return *c.HeadSHA
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetLatestCheckRunsCount returns the LatestCheckRunsCount field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetLatestCheckRunsCount() int64 {
	if c == nil || c.LatestCheckRunsCount == nil {
		return 0
	}
	return *c.LatestCheckRunsCount
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetRepository returns the Repository field.
func (c *CheckSuite) GetRepository() *Repository {
	if c == nil {
		return nil
	}
	return c.Repository
}

// GetRerequestable returns the Rerequestable field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetRerequestable() bool {
	if c == nil || c.Rerequestable == nil {
		return false
	}
	return *c.Rerequestable
}

// GetRunsRerequestable returns the RunsRerequestable field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetRunsRerequestable() bool {
	if c == nil || c.RunsRerequestable == nil {
		return false
	}
	return *c.RunsRerequestable
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CheckSuite) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CheckSuiteEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetCheckSuite returns the CheckSuite field.
func (c *CheckSuiteEvent) GetCheckSuite() *CheckSuite {
	if c == nil {
		return nil
	}
	return c.CheckSuite
}

// GetInstallation returns the Installation field.
func (c *CheckSuiteEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CheckSuiteEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetRepo returns the Repo field.
func (c *CheckSuiteEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *CheckSuiteEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetPreferences returns the Preferences field.
func (c *CheckSuitePreferenceResults) GetPreferences() *PreferenceList {
	if c == nil {
		return nil
	}
	return c.Preferences
}

// GetRepository returns the Repository field.
func (c *CheckSuitePreferenceResults) GetRepository() *Repository {
	if c == nil {
		return nil
	}
	return c.Repository
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (c *ClusterSSHKey) GetFingerprint() string {
	if c == nil || c.Fingerprint == nil {
		return ""
	}
	return *c.Fingerprint
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (c *ClusterSSHKey) GetKey() string {
	if c == nil || c.Key == nil {
		return ""
	}
	return *c.Key
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *ClusterStatus) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (c *ClusterStatusNode) GetHostname() string {
	if c == nil || c.Hostname == nil {
		return ""
	}
	return *c.Hostname
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *ClusterStatusNode) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetDetails returns the Details field if it's non-nil, zero value otherwise.
func (c *ClusterStatusNodeServiceItem) GetDetails() string {
	if c == nil || c.Details == nil {
		return ""
	}
	return *c.Details
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *ClusterStatusNodeServiceItem) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *ClusterStatusNodeServiceItem) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (c *CodeOfConduct) GetBody() string {
	if c == nil || c.Body == nil {
		return ""
	}
	return *c.Body
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (c *CodeOfConduct) GetKey() string {
	if c == nil || c.Key == nil {
		return ""
	}
	return *c.Key
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CodeOfConduct) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CodeOfConduct) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetSuggestion returns the Suggestion field if it's non-nil, zero value otherwise.
func (c *CodeownersError) GetSuggestion() string {
	if c == nil || c.Suggestion == nil {
		return ""
	}
	return *c.Suggestion
}

// GetContentType returns the ContentType field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetContentType() string {
	if c == nil || c.ContentType == nil {
		return ""
	}
	return *c.ContentType
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetLanguage returns the Language field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetLanguage() string {
	if c == nil || c.Language == nil {
		return ""
	}
	return *c.Language
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetSize() int64 {
	if c == nil || c.Size == nil {
		return 0
	}
	return *c.Size
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetUploader returns the Uploader field.
func (c *CodeQLDatabase) GetUploader() *User {
	if c == nil {
		return nil
	}
	return c.Uploader
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CodeQLDatabase) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CodeResult) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CodeResult) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (c *CodeResult) GetPath() string {
	if c == nil || c.Path == nil {
		return ""
	}
	return *c.Path
}

// GetRepository returns the Repository field.
func (c *CodeResult) GetRepository() *Repository {
	if c == nil {
		return nil
	}
	return c.Repository
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (c *CodeResult) GetSHA() string {
	if c == nil || c.SHA == nil {
		return ""
	}
	return *c.SHA
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CodeScanningAlertEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetAlert returns the Alert field.
func (c *CodeScanningAlertEvent) GetAlert() *Alert {
	if c == nil {
		return nil
	}
	return c.Alert
}

// GetCommitOID returns the CommitOID field if it's non-nil, zero value otherwise.
func (c *CodeScanningAlertEvent) GetCommitOID() string {
	if c == nil || c.CommitOID == nil {
		return ""
	}
	return *c.CommitOID
}

// GetInstallation returns the Installation field.
func (c *CodeScanningAlertEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CodeScanningAlertEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (c *CodeScanningAlertEvent) GetRef() string {
	if c == nil || c.Ref == nil {
		return ""
	}
	return *c.Ref
}

// GetRepo returns the Repo field.
func (c *CodeScanningAlertEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *CodeScanningAlertEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetDismissedComment returns the DismissedComment field if it's non-nil, zero value otherwise.
func (c *CodeScanningAlertState) GetDismissedComment() string {
	if c == nil || c.DismissedComment == nil {
		return ""
	}
	return *c.DismissedComment
}

// GetDismissedReason returns the DismissedReason field if it's non-nil, zero value otherwise.
func (c *CodeScanningAlertState) GetDismissedReason() string {
	if c == nil || c.DismissedReason == nil {
		return ""
	}
	return *c.DismissedReason
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (c *CodeSearchResult) GetIncompleteResults() bool {
	if c == nil || c.IncompleteResults == nil {
		return false
	}
	return *c.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (c *CodeSearchResult) GetTotal() int {
	if c == nil || c.Total == nil {
		return 0
	}
	return *c.Total
}

// GetAdvancedSecurity returns the AdvancedSecurity field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetAdvancedSecurity() string {
	if c == nil || c.AdvancedSecurity == nil {
		return ""
	}
	return *c.AdvancedSecurity
}

// GetCodeScanningDefaultSetup returns the CodeScanningDefaultSetup field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetCodeScanningDefaultSetup() string {
	if c == nil || c.CodeScanningDefaultSetup == nil {
		return ""
	}
	return *c.CodeScanningDefaultSetup
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetDependabotAlerts returns the DependabotAlerts field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetDependabotAlerts() string {
	if c == nil || c.DependabotAlerts == nil {
		return ""
	}
	return *c.DependabotAlerts
}

// GetDependabotSecurityUpdates returns the DependabotSecurityUpdates field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetDependabotSecurityUpdates() string {
	if c == nil || c.DependabotSecurityUpdates == nil {
		return ""
	}
	return *c.DependabotSecurityUpdates
}

// GetDependencyGraph returns the DependencyGraph field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetDependencyGraph() string {
	if c == nil || c.DependencyGraph == nil {
		return ""
	}
	return *c.DependencyGraph
}

// GetDependencyGraphAutosubmitAction returns the DependencyGraphAutosubmitAction field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetDependencyGraphAutosubmitAction() string {
	if c == nil || c.DependencyGraphAutosubmitAction == nil {
		return ""
	}
	return *c.DependencyGraphAutosubmitAction
}

// GetDependencyGraphAutosubmitActionOptions returns the DependencyGraphAutosubmitActionOptions field.
func (c *CodeSecurityConfiguration) GetDependencyGraphAutosubmitActionOptions() *DependencyGraphAutosubmitActionOptions {
	if c == nil {
		return nil
	}
	return c.DependencyGraphAutosubmitActionOptions
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetEnforcement returns the Enforcement field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetEnforcement() string {
	if c == nil || c.Enforcement == nil {
		return ""
	}
	return *c.Enforcement
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetPrivateVulnerabilityReporting returns the PrivateVulnerabilityReporting field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetPrivateVulnerabilityReporting() string {
	if c == nil || c.PrivateVulnerabilityReporting == nil {
		return ""
	}
	return *c.PrivateVulnerabilityReporting
}

// GetSecretScanning returns the SecretScanning field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetSecretScanning() string {
	if c == nil || c.SecretScanning == nil {
		return ""
	}
	return *c.SecretScanning
}

// GetSecretScanningNonProviderPatterns returns the SecretScanningNonProviderPatterns field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetSecretScanningNonProviderPatterns() string {
	if c == nil || c.SecretScanningNonProviderPatterns == nil {
		return ""
	}
	return *c.SecretScanningNonProviderPatterns
}

// GetSecretScanningPushProtection returns the SecretScanningPushProtection field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetSecretScanningPushProtection() string {
	if c == nil || c.SecretScanningPushProtection == nil {
		return ""
	}
	return *c.SecretScanningPushProtection
}

// GetSecretScanningValidityChecks returns the SecretScanningValidityChecks field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetSecretScanningValidityChecks() string {
	if c == nil || c.SecretScanningValidityChecks == nil {
		return ""
	}
	return *c.SecretScanningValidityChecks
}

// GetTargetType returns the TargetType field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetTargetType() string {
	if c == nil || c.TargetType == nil {
		return ""
	}
	return *c.TargetType
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfiguration) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetConfiguration returns the Configuration field.
func (c *CodeSecurityConfigurationWithDefaultForNewRepos) GetConfiguration() *CodeSecurityConfiguration {
	if c == nil {
		return nil
	}
	return c.Configuration
}

// GetDefaultForNewRepos returns the DefaultForNewRepos field if it's non-nil, zero value otherwise.
func (c *CodeSecurityConfigurationWithDefaultForNewRepos) GetDefaultForNewRepos() string {
	if c == nil || c.DefaultForNewRepos == nil {
		return ""
	}
	return *c.DefaultForNewRepos
}

// GetBillableOwner returns the BillableOwner field.
func (c *Codespace) GetBillableOwner() *User {
	if c == nil {
		return nil
	}
	return c.BillableOwner
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *Codespace) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetDevcontainerPath returns the DevcontainerPath field if it's non-nil, zero value otherwise.
func (c *Codespace) GetDevcontainerPath() string {
	if c == nil || c.DevcontainerPath == nil {
		return ""
	}
	return *c.DevcontainerPath
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (c *Codespace) GetDisplayName() string {
	if c == nil || c.DisplayName == nil {
		return ""
	}
	return *c.DisplayName
}

// GetEnvironmentID returns the EnvironmentID field if it's non-nil, zero value otherwise.
func (c *Codespace) GetEnvironmentID() string {
	if c == nil || c.EnvironmentID == nil {
		return ""
	}
	return *c.EnvironmentID
}

// GetGitStatus returns the GitStatus field.
func (c *Codespace) GetGitStatus() *CodespacesGitStatus {
	if c == nil {
		return nil
	}
	return c.GitStatus
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *Codespace) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetIdleTimeoutMinutes returns the IdleTimeoutMinutes field if it's non-nil, zero value otherwise.
func (c *Codespace) GetIdleTimeoutMinutes() int {
	if c == nil || c.IdleTimeoutMinutes == nil {
		return 0
	}
	return *c.IdleTimeoutMinutes
}

// GetIdleTimeoutNotice returns the IdleTimeoutNotice field if it's non-nil, zero value otherwise.
func (c *Codespace) GetIdleTimeoutNotice() string {
	if c == nil || c.IdleTimeoutNotice == nil {
		return ""
	}
	return *c.IdleTimeoutNotice
}

// GetLastKnownStopNotice returns the LastKnownStopNotice field if it's non-nil, zero value otherwise.
func (c *Codespace) GetLastKnownStopNotice() string {
	if c == nil || c.LastKnownStopNotice == nil {
		return ""
	}
	return *c.LastKnownStopNotice
}

// GetLastUsedAt returns the LastUsedAt field if it's non-nil, zero value otherwise.
func (c *Codespace) GetLastUsedAt() Timestamp {
	if c == nil || c.LastUsedAt == nil {
		return Timestamp{}
	}
	return *c.LastUsedAt
}

// GetLocation returns the Location field if it's non-nil, zero value otherwise.
func (c *Codespace) GetLocation() string {
	if c == nil || c.Location == nil {
		return ""
	}
	return *c.Location
}

// GetMachine returns the Machine field.
func (c *Codespace) GetMachine() *CodespacesMachine {
	if c == nil {
		return nil
	}
	return c.Machine
}

// GetMachinesURL returns the MachinesURL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetMachinesURL() string {
	if c == nil || c.MachinesURL == nil {
		return ""
	}
	return *c.MachinesURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *Codespace) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetOwner returns the Owner field.
func (c *Codespace) GetOwner() *User {
	if c == nil {
		return nil
	}
	return c.Owner
}

// GetPendingOperation returns the PendingOperation field if it's non-nil, zero value otherwise.
func (c *Codespace) GetPendingOperation() bool {
	if c == nil || c.PendingOperation == nil {
		return false
	}
	return *c.PendingOperation
}

// GetPendingOperationDisabledReason returns the PendingOperationDisabledReason field if it's non-nil, zero value otherwise.
func (c *Codespace) GetPendingOperationDisabledReason() string {
	if c == nil || c.PendingOperationDisabledReason == nil {
		return ""
	}
	return *c.PendingOperationDisabledReason
}

// GetPrebuild returns the Prebuild field if it's non-nil, zero value otherwise.
func (c *Codespace) GetPrebuild() bool {
	if c == nil || c.Prebuild == nil {
		return false
	}
	return *c.Prebuild
}

// GetPullsURL returns the PullsURL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetPullsURL() string {
	if c == nil || c.PullsURL == nil {
		return ""
	}
	return *c.PullsURL
}

// GetRepository returns the Repository field.
func (c *Codespace) GetRepository() *Repository {
	if c == nil {
		return nil
	}
	return c.Repository
}

// GetRetentionExpiresAt returns the RetentionExpiresAt field if it's non-nil, zero value otherwise.
func (c *Codespace) GetRetentionExpiresAt() Timestamp {
	if c == nil || c.RetentionExpiresAt == nil {
		return Timestamp{}
	}
	return *c.RetentionExpiresAt
}

// GetRetentionPeriodMinutes returns the RetentionPeriodMinutes field if it's non-nil, zero value otherwise.
func (c *Codespace) GetRetentionPeriodMinutes() int {
	if c == nil || c.RetentionPeriodMinutes == nil {
		return 0
	}
	return *c.RetentionPeriodMinutes
}

// GetRuntimeConstraints returns the RuntimeConstraints field.
func (c *Codespace) GetRuntimeConstraints() *CodespacesRuntimeConstraints {
	if c == nil {
		return nil
	}
	return c.RuntimeConstraints
}

// GetStartURL returns the StartURL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetStartURL() string {
	if c == nil || c.StartURL == nil {
		return ""
	}
	return *c.StartURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (c *Codespace) GetState() string {
	if c == nil || c.State == nil {
		return ""
	}
	return *c.State
}

// GetStopURL returns the StopURL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetStopURL() string {
	if c == nil || c.StopURL == nil {
		return ""
	}
	return *c.StopURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *Codespace) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetWebURL returns the WebURL field if it's non-nil, zero value otherwise.
func (c *Codespace) GetWebURL() string {
	if c == nil || c.WebURL == nil {
		return ""
	}
	return *c.WebURL
}

// GetAhead returns the Ahead field if it's non-nil, zero value otherwise.
func (c *CodespacesGitStatus) GetAhead() int {
	if c == nil || c.Ahead == nil {
		return 0
	}
	return *c.Ahead
}

// GetBehind returns the Behind field if it's non-nil, zero value otherwise.
func (c *CodespacesGitStatus) GetBehind() int {
	if c == nil || c.Behind == nil {
		return 0
	}
	return *c.Behind
}

// GetHasUncommittedChanges returns the HasUncommittedChanges field if it's non-nil, zero value otherwise.
func (c *CodespacesGitStatus) GetHasUncommittedChanges() bool {
	if c == nil || c.HasUncommittedChanges == nil {
		return false
	}
	return *c.HasUncommittedChanges
}

// GetHasUnpushedChanges returns the HasUnpushedChanges field if it's non-nil, zero value otherwise.
func (c *CodespacesGitStatus) GetHasUnpushedChanges() bool {
	if c == nil || c.HasUnpushedChanges == nil {
		return false
	}
	return *c.HasUnpushedChanges
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (c *CodespacesGitStatus) GetRef() string {
	if c == nil || c.Ref == nil {
		return ""
	}
	return *c.Ref
}

// GetCPUs returns the CPUs field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetCPUs() int {
	if c == nil || c.CPUs == nil {
		return 0
	}
	return *c.CPUs
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetDisplayName() string {
	if c == nil || c.DisplayName == nil {
		return ""
	}
	return *c.DisplayName
}

// GetMemoryInBytes returns the MemoryInBytes field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetMemoryInBytes() int64 {
	if c == nil || c.MemoryInBytes == nil {
		return 0
	}
	return *c.MemoryInBytes
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetOperatingSystem returns the OperatingSystem field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetOperatingSystem() string {
	if c == nil || c.OperatingSystem == nil {
		return ""
	}
	return *c.OperatingSystem
}

// GetPrebuildAvailability returns the PrebuildAvailability field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetPrebuildAvailability() string {
	if c == nil || c.PrebuildAvailability == nil {
		return ""
	}
	return *c.PrebuildAvailability
}

// GetStorageInBytes returns the StorageInBytes field if it's non-nil, zero value otherwise.
func (c *CodespacesMachine) GetStorageInBytes() int64 {
	if c == nil || c.StorageInBytes == nil {
		return 0
	}
	return *c.StorageInBytes
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CollaboratorInvitation) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CollaboratorInvitation) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CollaboratorInvitation) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetInvitee returns the Invitee field.
func (c *CollaboratorInvitation) GetInvitee() *User {
	if c == nil {
		return nil
	}
	return c.Invitee
}

// GetInviter returns the Inviter field.
func (c *CollaboratorInvitation) GetInviter() *User {
	if c == nil {
		return nil
	}
	return c.Inviter
}

// GetPermissions returns the Permissions field if it's non-nil, zero value otherwise.
func (c *CollaboratorInvitation) GetPermissions() string {
	if c == nil || c.Permissions == nil {
		return ""
	}
	return *c.Permissions
}

// GetRepo returns the Repo field.
func (c *CollaboratorInvitation) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CollaboratorInvitation) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetCommitURL returns the CommitURL field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetCommitURL() string {
	if c == nil || c.CommitURL == nil {
		return ""
	}
	return *c.CommitURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetRepositoryURL() string {
	if c == nil || c.RepositoryURL == nil {
		return ""
	}
	return *c.RepositoryURL
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetSHA() string {
	if c == nil || c.SHA == nil {
		return ""
	}
	return *c.SHA
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetState() string {
	if c == nil || c.State == nil {
		return ""
	}
	return *c.State
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (c *CombinedStatus) GetTotalCount() int {
	if c == nil || c.TotalCount == nil {
		return 0
	}
	return *c.TotalCount
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *Comment) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetAuthorAssociation() string {
	if c == nil || c.AuthorAssociation == nil {
		return ""
	}
	return *c.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetBody() string {
	if c == nil || c.Body == nil {
		return ""
	}
	return *c.Body
}

// GetChildCommentCount returns the ChildCommentCount field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetChildCommentCount() int {
	if c == nil || c.ChildCommentCount == nil {
		return 0
	}
	return *c.ChildCommentCount
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetDiscussionID returns the DiscussionID field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetDiscussionID() int64 {
	if c == nil || c.DiscussionID == nil {
		return 0
	}
	return *c.DiscussionID
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetParentID returns the ParentID field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetParentID() int64 {
	if c == nil || c.ParentID == nil {
		return 0
	}
	return *c.ParentID
}

// GetReactions returns the Reactions field.
func (c *CommentDiscussion) GetReactions() *Reactions {
	if c == nil {
		return nil
	}
	return c.Reactions
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetRepositoryURL() string {
	if c == nil || c.RepositoryURL == nil {
		return ""
	}
	return *c.RepositoryURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CommentDiscussion) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetUser returns the User field.
func (c *CommentDiscussion) GetUser() *User {
	if c == nil {
		return nil
	}
	return c.User
}

// GetTotalCommitComments returns the TotalCommitComments field if it's non-nil, zero value otherwise.
func (c *CommentStats) GetTotalCommitComments() int {
	if c == nil || c.TotalCommitComments == nil {
		return 0
	}
	return *c.TotalCommitComments
}

// GetTotalGistComments returns the TotalGistComments field if it's non-nil, zero value otherwise.
func (c *CommentStats) GetTotalGistComments() int {
	if c == nil || c.TotalGistComments == nil {
		return 0
	}
	return *c.TotalGistComments
}

// GetTotalIssueComments returns the TotalIssueComments field if it's non-nil, zero value otherwise.
func (c *CommentStats) GetTotalIssueComments() int {
	if c == nil || c.TotalIssueComments == nil {
		return 0
	}
	return *c.TotalIssueComments
}

// GetTotalPullRequestComments returns the TotalPullRequestComments field if it's non-nil, zero value otherwise.
func (c *CommentStats) GetTotalPullRequestComments() int {
	if c == nil || c.TotalPullRequestComments == nil {
		return 0
	}
	return *c.TotalPullRequestComments
}

// GetAuthor returns the Author field.
func (c *Commit) GetAuthor() *CommitAuthor {
	if c == nil {
		return nil
	}
	return c.Author
}

// GetCommentCount returns the CommentCount field if it's non-nil, zero value otherwise.
func (c *Commit) GetCommentCount() int {
	if c == nil || c.CommentCount == nil {
		return 0
	}
	return *c.CommentCount
}

// GetCommitter returns the Committer field.
func (c *Commit) GetCommitter() *CommitAuthor {
	if c == nil {
		return nil
	}
	return c.Committer
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *Commit) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (c *Commit) GetMessage() string {
	if c == nil || c.Message == nil {
		return ""
	}
	return *c.Message
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *Commit) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (c *Commit) GetSHA() string {
	if c == nil || c.SHA == nil {
		return ""
	}
	return *c.SHA
}

// GetTree returns the Tree field.
func (c *Commit) GetTree() *Tree {
	if c == nil {
		return nil
	}
	return c.Tree
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *Commit) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetVerification returns the Verification field.
func (c *Commit) GetVerification() *SignatureVerification {
	if c == nil {
		return nil
	}
	return c.Verification
}

// GetDate returns the Date field if it's non-nil, zero value otherwise.
func (c *CommitAuthor) GetDate() Timestamp {
	if c == nil || c.Date == nil {
		return Timestamp{}
	}
	return *c.Date
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (c *CommitAuthor) GetEmail() string {
	if c == nil || c.Email == nil {
		return ""
	}
	return *c.Email
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (c *CommitAuthor) GetLogin() string {
	if c == nil || c.Login == nil {
		return ""
	}
	return *c.Login
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CommitAuthor) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CommitCommentEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetComment returns the Comment field.
func (c *CommitCommentEvent) GetComment() *RepositoryComment {
	if c == nil {
		return nil
	}
	return c.Comment
}

// GetInstallation returns the Installation field.
func (c *CommitCommentEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CommitCommentEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetRepo returns the Repo field.
func (c *CommitCommentEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *CommitCommentEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetAdditions returns the Additions field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetAdditions() int {
	if c == nil || c.Additions == nil {
		return 0
	}
	return *c.Additions
}

// GetBlobURL returns the BlobURL field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetBlobURL() string {
	if c == nil || c.BlobURL == nil {
		return ""
	}
	return *c.BlobURL
}

// GetChanges returns the Changes field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetChanges() int {
	if c == nil || c.Changes == nil {
		return 0
	}
	return *c.Changes
}

// GetContentsURL returns the ContentsURL field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetContentsURL() string {
	if c == nil || c.ContentsURL == nil {
		return ""
	}
	return *c.ContentsURL
}

// GetDeletions returns the Deletions field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetDeletions() int {
	if c == nil || c.Deletions == nil {
		return 0
	}
	return *c.Deletions
}

// GetFilename returns the Filename field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetFilename() string {
	if c == nil || c.Filename == nil {
		return ""
	}
	return *c.Filename
}

// GetPatch returns the Patch field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetPatch() string {
	if c == nil || c.Patch == nil {
		return ""
	}
	return *c.Patch
}

// GetPreviousFilename returns the PreviousFilename field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetPreviousFilename() string {
	if c == nil || c.PreviousFilename == nil {
		return ""
	}
	return *c.PreviousFilename
}

// GetRawURL returns the RawURL field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetRawURL() string {
	if c == nil || c.RawURL == nil {
		return ""
	}
	return *c.RawURL
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetSHA() string {
	if c == nil || c.SHA == nil {
		return ""
	}
	return *c.SHA
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *CommitFile) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetAuthor returns the Author field.
func (c *CommitResult) GetAuthor() *User {
	if c == nil {
		return nil
	}
	return c.Author
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (c *CommitResult) GetCommentsURL() string {
	if c == nil || c.CommentsURL == nil {
		return ""
	}
	return *c.CommentsURL
}

// GetCommit returns the Commit field.
func (c *CommitResult) GetCommit() *Commit {
	if c == nil {
		return nil
	}
	return c.Commit
}

// GetCommitter returns the Committer field.
func (c *CommitResult) GetCommitter() *User {
	if c == nil {
		return nil
	}
	return c.Committer
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CommitResult) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetRepository returns the Repository field.
func (c *CommitResult) GetRepository() *Repository {
	if c == nil {
		return nil
	}
	return c.Repository
}

// GetScore returns the Score field.
func (c *CommitResult) GetScore() *float64 {
	if c == nil {
		return nil
	}
	return c.Score
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (c *CommitResult) GetSHA() string {
	if c == nil || c.SHA == nil {
		return ""
	}
	return *c.SHA
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CommitResult) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetAheadBy returns the AheadBy field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetAheadBy() int {
	if c == nil || c.AheadBy == nil {
		return 0
	}
	return *c.AheadBy
}

// GetBaseCommit returns the BaseCommit field.
func (c *CommitsComparison) GetBaseCommit() *RepositoryCommit {
	if c == nil {
		return nil
	}
	return c.BaseCommit
}

// GetBehindBy returns the BehindBy field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetBehindBy() int {
	if c == nil || c.BehindBy == nil {
		return 0
	}
	return *c.BehindBy
}

// GetDiffURL returns the DiffURL field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetDiffURL() string {
	if c == nil || c.DiffURL == nil {
		return ""
	}
	return *c.DiffURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetMergeBaseCommit returns the MergeBaseCommit field.
func (c *CommitsComparison) GetMergeBaseCommit() *RepositoryCommit {
	if c == nil {
		return nil
	}
	return c.MergeBaseCommit
}

// GetPatchURL returns the PatchURL field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetPatchURL() string {
	if c == nil || c.PatchURL == nil {
		return ""
	}
	return *c.PatchURL
}

// GetPermalinkURL returns the PermalinkURL field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetPermalinkURL() string {
	if c == nil || c.PermalinkURL == nil {
		return ""
	}
	return *c.PermalinkURL
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetTotalCommits returns the TotalCommits field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetTotalCommits() int {
	if c == nil || c.TotalCommits == nil {
		return 0
	}
	return *c.TotalCommits
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *CommitsComparison) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (c *CommitsSearchResult) GetIncompleteResults() bool {
	if c == nil || c.IncompleteResults == nil {
		return false
	}
	return *c.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (c *CommitsSearchResult) GetTotal() int {
	if c == nil || c.Total == nil {
		return 0
	}
	return *c.Total
}

// GetAdditions returns the Additions field if it's non-nil, zero value otherwise.
func (c *CommitStats) GetAdditions() int {
	if c == nil || c.Additions == nil {
		return 0
	}
	return *c.Additions
}

// GetDeletions returns the Deletions field if it's non-nil, zero value otherwise.
func (c *CommitStats) GetDeletions() int {
	if c == nil || c.Deletions == nil {
		return 0
	}
	return *c.Deletions
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (c *CommitStats) GetTotal() int {
	if c == nil || c.Total == nil {
		return 0
	}
	return *c.Total
}

// GetCodeOfConduct returns the CodeOfConduct field.
func (c *CommunityHealthFiles) GetCodeOfConduct() *Metric {
	if c == nil {
		return nil
	}
	return c.CodeOfConduct
}

// GetCodeOfConductFile returns the CodeOfConductFile field.
func (c *CommunityHealthFiles) GetCodeOfConductFile() *Metric {
	if c == nil {
		return nil
	}
	return c.CodeOfConductFile
}

// GetContributing returns the Contributing field.
func (c *CommunityHealthFiles) GetContributing() *Metric {
	if c == nil {
		return nil
	}
	return c.Contributing
}

// GetIssueTemplate returns the IssueTemplate field.
func (c *CommunityHealthFiles) GetIssueTemplate() *Metric {
	if c == nil {
		return nil
	}
	return c.IssueTemplate
}

// GetLicense returns the License field.
func (c *CommunityHealthFiles) GetLicense() *Metric {
	if c == nil {
		return nil
	}
	return c.License
}

// GetPullRequestTemplate returns the PullRequestTemplate field.
func (c *CommunityHealthFiles) GetPullRequestTemplate() *Metric {
	if c == nil {
		return nil
	}
	return c.PullRequestTemplate
}

// GetReadme returns the Readme field.
func (c *CommunityHealthFiles) GetReadme() *Metric {
	if c == nil {
		return nil
	}
	return c.Readme
}

// GetContentReportsEnabled returns the ContentReportsEnabled field if it's non-nil, zero value otherwise.
func (c *CommunityHealthMetrics) GetContentReportsEnabled() bool {
	if c == nil || c.ContentReportsEnabled == nil {
		return false
	}
	return *c.ContentReportsEnabled
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CommunityHealthMetrics) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetDocumentation returns the Documentation field if it's non-nil, zero value otherwise.
func (c *CommunityHealthMetrics) GetDocumentation() string {
	if c == nil || c.Documentation == nil {
		return ""
	}
	return *c.Documentation
}

// GetFiles returns the Files field.
func (c *CommunityHealthMetrics) GetFiles() *CommunityHealthFiles {
	if c == nil {
		return nil
	}
	return c.Files
}

// GetHealthPercentage returns the HealthPercentage field if it's non-nil, zero value otherwise.
func (c *CommunityHealthMetrics) GetHealthPercentage() int {
	if c == nil || c.HealthPercentage == nil {
		return 0
	}
	return *c.HealthPercentage
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CommunityHealthMetrics) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetLastRequestID returns the LastRequestID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNode) GetLastRequestID() string {
	if c == nil || c.LastRequestID == nil {
		return ""
	}
	return *c.LastRequestID
}

// GetNode returns the Node field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNode) GetNode() string {
	if c == nil || c.Node == nil {
		return ""
	}
	return *c.Node
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetBody() string {
	if c == nil || c.Body == nil {
		return ""
	}
	return *c.Body
}

// GetConfigRunID returns the ConfigRunID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetConfigRunID() string {
	if c == nil || c.ConfigRunID == nil {
		return ""
	}
	return *c.ConfigRunID
}

// GetEventName returns the EventName field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetEventName() string {
	if c == nil || c.EventName == nil {
		return ""
	}
	return *c.EventName
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetHostname() string {
	if c == nil || c.Hostname == nil {
		return ""
	}
	return *c.Hostname
}

// GetSeverityText returns the SeverityText field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetSeverityText() string {
	if c == nil || c.SeverityText == nil {
		return ""
	}
	return *c.SeverityText
}

// GetSpanDepth returns the SpanDepth field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetSpanDepth() int {
	if c == nil || c.SpanDepth == nil {
		return 0
	}
	return *c.SpanDepth
}

// GetSpanID returns the SpanID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetSpanID() string {
	if c == nil || c.SpanID == nil {
		return ""
	}
	return *c.SpanID
}

// GetSpanParentID returns the SpanParentID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetSpanParentID() int64 {
	if c == nil || c.SpanParentID == nil {
		return 0
	}
	return *c.SpanParentID
}

// GetTimestamp returns the Timestamp field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetTimestamp() Timestamp {
	if c == nil || c.Timestamp == nil {
		return Timestamp{}
	}
	return *c.Timestamp
}

// GetTopology returns the Topology field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetTopology() string {
	if c == nil || c.Topology == nil {
		return ""
	}
	return *c.Topology
}

// GetTraceID returns the TraceID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsNodeEvent) GetTraceID() string {
	if c == nil || c.TraceID == nil {
		return ""
	}
	return *c.TraceID
}

// GetLastRequestID returns the LastRequestID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyEventsOptions) GetLastRequestID() string {
	if c == nil || c.LastRequestID == nil {
		return ""
	}
	return *c.LastRequestID
}

// GetRunID returns the RunID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyOptions) GetRunID() string {
	if c == nil || c.RunID == nil {
		return ""
	}
	return *c.RunID
}

// GetRunning returns the Running field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatus) GetRunning() bool {
	if c == nil || c.Running == nil {
		return false
	}
	return *c.Running
}

// GetSuccessful returns the Successful field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatus) GetSuccessful() bool {
	if c == nil || c.Successful == nil {
		return false
	}
	return *c.Successful
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatusNode) GetHostname() string {
	if c == nil || c.Hostname == nil {
		return ""
	}
	return *c.Hostname
}

// GetRunID returns the RunID field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatusNode) GetRunID() string {
	if c == nil || c.RunID == nil {
		return ""
	}
	return *c.RunID
}

// GetRunning returns the Running field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatusNode) GetRunning() bool {
	if c == nil || c.Running == nil {
		return false
	}
	return *c.Running
}

// GetSuccessful returns the Successful field if it's non-nil, zero value otherwise.
func (c *ConfigApplyStatusNode) GetSuccessful() bool {
	if c == nil || c.Successful == nil {
		return false
	}
	return *c.Successful
}

// GetAdminPassword returns the AdminPassword field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetAdminPassword() string {
	if c == nil || c.AdminPassword == nil {
		return ""
	}
	return *c.AdminPassword
}

// GetAssets returns the Assets field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetAssets() string {
	if c == nil || c.Assets == nil {
		return ""
	}
	return *c.Assets
}

// GetAuthMode returns the AuthMode field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetAuthMode() string {
	if c == nil || c.AuthMode == nil {
		return ""
	}
	return *c.AuthMode
}

// GetAvatar returns the Avatar field.
func (c *ConfigSettings) GetAvatar() *ConfigSettingsAvatar {
	if c == nil {
		return nil
	}
	return c.Avatar
}

// GetCAS returns the CAS field.
func (c *ConfigSettings) GetCAS() *ConfigSettingsCAS {
	if c == nil {
		return nil
	}
	return c.CAS
}

// GetCollectd returns the Collectd field.
func (c *ConfigSettings) GetCollectd() *ConfigSettingsCollectd {
	if c == nil {
		return nil
	}
	return c.Collectd
}

// GetConfigurationID returns the ConfigurationID field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetConfigurationID() int64 {
	if c == nil || c.ConfigurationID == nil {
		return 0
	}
	return *c.ConfigurationID
}

// GetConfigurationRunCount returns the ConfigurationRunCount field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetConfigurationRunCount() int {
	if c == nil || c.ConfigurationRunCount == nil {
		return 0
	}
	return *c.ConfigurationRunCount
}

// GetCustomer returns the Customer field.
func (c *ConfigSettings) GetCustomer() *ConfigSettingsCustomer {
	if c == nil {
		return nil
	}
	return c.Customer
}

// GetExpireSessions returns the ExpireSessions field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetExpireSessions() bool {
	if c == nil || c.ExpireSessions == nil {
		return false
	}
	return *c.ExpireSessions
}

// GetGithubHostname returns the GithubHostname field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetGithubHostname() string {
	if c == nil || c.GithubHostname == nil {
		return ""
	}
	return *c.GithubHostname
}

// GetGithubOAuth returns the GithubOAuth field.
func (c *ConfigSettings) GetGithubOAuth() *ConfigSettingsGithubOAuth {
	if c == nil {
		return nil
	}
	return c.GithubOAuth
}

// GetGithubSSL returns the GithubSSL field.
func (c *ConfigSettings) GetGithubSSL() *ConfigSettingsGithubSSL {
	if c == nil {
		return nil
	}
	return c.GithubSSL
}

// GetHTTPProxy returns the HTTPProxy field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetHTTPProxy() string {
	if c == nil || c.HTTPProxy == nil {
		return ""
	}
	return *c.HTTPProxy
}

// GetIdenticonsHost returns the IdenticonsHost field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetIdenticonsHost() string {
	if c == nil || c.IdenticonsHost == nil {
		return ""
	}
	return *c.IdenticonsHost
}

// GetLDAP returns the LDAP field.
func (c *ConfigSettings) GetLDAP() *ConfigSettingsLDAP {
	if c == nil {
		return nil
	}
	return c.LDAP
}

// GetLicense returns the License field.
func (c *ConfigSettings) GetLicense() *ConfigSettingsLicenseSettings {
	if c == nil {
		return nil
	}
	return c.License
}

// GetLoadBalancer returns the LoadBalancer field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetLoadBalancer() string {
	if c == nil || c.LoadBalancer == nil {
		return ""
	}
	return *c.LoadBalancer
}

// GetMapping returns the Mapping field.
func (c *ConfigSettings) GetMapping() *ConfigSettingsMapping {
	if c == nil {
		return nil
	}
	return c.Mapping
}

// GetNTP returns the NTP field.
func (c *ConfigSettings) GetNTP() *ConfigSettingsNTP {
	if c == nil {
		return nil
	}
	return c.NTP
}

// GetPages returns the Pages field.
func (c *ConfigSettings) GetPages() *ConfigSettingsPagesSettings {
	if c == nil {
		return nil
	}
	return c.Pages
}

// GetPrivateMode returns the PrivateMode field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetPrivateMode() bool {
	if c == nil || c.PrivateMode == nil {
		return false
	}
	return *c.PrivateMode
}

// GetPublicPages returns the PublicPages field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetPublicPages() bool {
	if c == nil || c.PublicPages == nil {
		return false
	}
	return *c.PublicPages
}

// GetSAML returns the SAML field.
func (c *ConfigSettings) GetSAML() *ConfigSettingsSAML {
	if c == nil {
		return nil
	}
	return c.SAML
}

// GetSignupEnabled returns the SignupEnabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetSignupEnabled() bool {
	if c == nil || c.SignupEnabled == nil {
		return false
	}
	return *c.SignupEnabled
}

// GetSMTP returns the SMTP field.
func (c *ConfigSettings) GetSMTP() *ConfigSettingsSMTP {
	if c == nil {
		return nil
	}
	return c.SMTP
}

// GetSNMP returns the SNMP field.
func (c *ConfigSettings) GetSNMP() *ConfigSettingsSNMP {
	if c == nil {
		return nil
	}
	return c.SNMP
}

// GetSubdomainIsolation returns the SubdomainIsolation field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetSubdomainIsolation() bool {
	if c == nil || c.SubdomainIsolation == nil {
		return false
	}
	return *c.SubdomainIsolation
}

// GetSyslog returns the Syslog field.
func (c *ConfigSettings) GetSyslog() *ConfigSettingsSyslog {
	if c == nil {
		return nil
	}
	return c.Syslog
}

// GetTimezone returns the Timezone field if it's non-nil, zero value otherwise.
func (c *ConfigSettings) GetTimezone() string {
	if c == nil || c.Timezone == nil {
		return ""
	}
	return *c.Timezone
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsAvatar) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetURI returns the URI field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsAvatar) GetURI() string {
	if c == nil || c.URI == nil {
		return ""
	}
	return *c.URI
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCAS) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetEncryption returns the Encryption field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetEncryption() string {
	if c == nil || c.Encryption == nil {
		return ""
	}
	return *c.Encryption
}

// GetPassword returns the Password field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetPassword() string {
	if c == nil || c.Password == nil {
		return ""
	}
	return *c.Password
}

// GetPort returns the Port field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetPort() int {
	if c == nil || c.Port == nil {
		return 0
	}
	return *c.Port
}

// GetServer returns the Server field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetServer() string {
	if c == nil || c.Server == nil {
		return ""
	}
	return *c.Server
}

// GetUsername returns the Username field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCollectd) GetUsername() string {
	if c == nil || c.Username == nil {
		return ""
	}
	return *c.Username
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCustomer) GetEmail() string {
	if c == nil || c.Email == nil {
		return ""
	}
	return *c.Email
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCustomer) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetPublicKeyData returns the PublicKeyData field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCustomer) GetPublicKeyData() string {
	if c == nil || c.PublicKeyData == nil {
		return ""
	}
	return *c.PublicKeyData
}

// GetSecret returns the Secret field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCustomer) GetSecret() string {
	if c == nil || c.Secret == nil {
		return ""
	}
	return *c.Secret
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsCustomer) GetUUID() string {
	if c == nil || c.UUID == nil {
		return ""
	}
	return *c.UUID
}

// GetClientID returns the ClientID field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubOAuth) GetClientID() string {
	if c == nil || c.ClientID == nil {
		return ""
	}
	return *c.ClientID
}

// GetClientSecret returns the ClientSecret field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubOAuth) GetClientSecret() string {
	if c == nil || c.ClientSecret == nil {
		return ""
	}
	return *c.ClientSecret
}

// GetOrganizationName returns the OrganizationName field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubOAuth) GetOrganizationName() string {
	if c == nil || c.OrganizationName == nil {
		return ""
	}
	return *c.OrganizationName
}

// GetOrganizationTeam returns the OrganizationTeam field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubOAuth) GetOrganizationTeam() string {
	if c == nil || c.OrganizationTeam == nil {
		return ""
	}
	return *c.OrganizationTeam
}

// GetCert returns the Cert field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubSSL) GetCert() string {
	if c == nil || c.Cert == nil {
		return ""
	}
	return *c.Cert
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubSSL) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsGithubSSL) GetKey() string {
	if c == nil || c.Key == nil {
		return ""
	}
	return *c.Key
}

// GetAdminGroup returns the AdminGroup field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetAdminGroup() string {
	if c == nil || c.AdminGroup == nil {
		return ""
	}
	return *c.AdminGroup
}

// GetBindDN returns the BindDN field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetBindDN() string {
	if c == nil || c.BindDN == nil {
		return ""
	}
	return *c.BindDN
}

// GetHost returns the Host field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetHost() string {
	if c == nil || c.Host == nil {
		return ""
	}
	return *c.Host
}

// GetMethod returns the Method field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetMethod() string {
	if c == nil || c.Method == nil {
		return ""
	}
	return *c.Method
}

// GetPassword returns the Password field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetPassword() string {
	if c == nil || c.Password == nil {
		return ""
	}
	return *c.Password
}

// GetPort returns the Port field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetPort() int {
	if c == nil || c.Port == nil {
		return 0
	}
	return *c.Port
}

// GetPosixSupport returns the PosixSupport field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetPosixSupport() bool {
	if c == nil || c.PosixSupport == nil {
		return false
	}
	return *c.PosixSupport
}

// GetProfile returns the Profile field.
func (c *ConfigSettingsLDAP) GetProfile() *ConfigSettingsLDAPProfile {
	if c == nil {
		return nil
	}
	return c.Profile
}

// GetReconciliation returns the Reconciliation field.
func (c *ConfigSettingsLDAP) GetReconciliation() *ConfigSettingsLDAPReconciliation {
	if c == nil {
		return nil
	}
	return c.Reconciliation
}

// GetRecursiveGroupSearch returns the RecursiveGroupSearch field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetRecursiveGroupSearch() bool {
	if c == nil || c.RecursiveGroupSearch == nil {
		return false
	}
	return *c.RecursiveGroupSearch
}

// GetSearchStrategy returns the SearchStrategy field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetSearchStrategy() string {
	if c == nil || c.SearchStrategy == nil {
		return ""
	}
	return *c.SearchStrategy
}

// GetSyncEnabled returns the SyncEnabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetSyncEnabled() bool {
	if c == nil || c.SyncEnabled == nil {
		return false
	}
	return *c.SyncEnabled
}

// GetTeamSyncInterval returns the TeamSyncInterval field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetTeamSyncInterval() int {
	if c == nil || c.TeamSyncInterval == nil {
		return 0
	}
	return *c.TeamSyncInterval
}

// GetUID returns the UID field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetUID() string {
	if c == nil || c.UID == nil {
		return ""
	}
	return *c.UID
}

// GetUserSyncEmails returns the UserSyncEmails field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetUserSyncEmails() bool {
	if c == nil || c.UserSyncEmails == nil {
		return false
	}
	return *c.UserSyncEmails
}

// GetUserSyncInterval returns the UserSyncInterval field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetUserSyncInterval() int {
	if c == nil || c.UserSyncInterval == nil {
		return 0
	}
	return *c.UserSyncInterval
}

// GetUserSyncKeys returns the UserSyncKeys field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetUserSyncKeys() bool {
	if c == nil || c.UserSyncKeys == nil {
		return false
	}
	return *c.UserSyncKeys
}

// GetVirtualAttributeEnabled returns the VirtualAttributeEnabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAP) GetVirtualAttributeEnabled() bool {
	if c == nil || c.VirtualAttributeEnabled == nil {
		return false
	}
	return *c.VirtualAttributeEnabled
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPProfile) GetKey() string {
	if c == nil || c.Key == nil {
		return ""
	}
	return *c.Key
}

// GetMail returns the Mail field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPProfile) GetMail() string {
	if c == nil || c.Mail == nil {
		return ""
	}
	return *c.Mail
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPProfile) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetUID returns the UID field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPProfile) GetUID() string {
	if c == nil || c.UID == nil {
		return ""
	}
	return *c.UID
}

// GetOrg returns the Org field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPReconciliation) GetOrg() string {
	if c == nil || c.Org == nil {
		return ""
	}
	return *c.Org
}

// GetUser returns the User field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLDAPReconciliation) GetUser() string {
	if c == nil || c.User == nil {
		return ""
	}
	return *c.User
}

// GetClusterSupport returns the ClusterSupport field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetClusterSupport() bool {
	if c == nil || c.ClusterSupport == nil {
		return false
	}
	return *c.ClusterSupport
}

// GetEvaluation returns the Evaluation field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetEvaluation() bool {
	if c == nil || c.Evaluation == nil {
		return false
	}
	return *c.Evaluation
}

// GetExpireAt returns the ExpireAt field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetExpireAt() Timestamp {
	if c == nil || c.ExpireAt == nil {
		return Timestamp{}
	}
	return *c.ExpireAt
}

// GetPerpetual returns the Perpetual field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetPerpetual() bool {
	if c == nil || c.Perpetual == nil {
		return false
	}
	return *c.Perpetual
}

// GetSeats returns the Seats field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetSeats() int {
	if c == nil || c.Seats == nil {
		return 0
	}
	return *c.Seats
}

// GetSSHAllowed returns the SSHAllowed field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetSSHAllowed() bool {
	if c == nil || c.SSHAllowed == nil {
		return false
	}
	return *c.SSHAllowed
}

// GetSupportKey returns the SupportKey field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetSupportKey() string {
	if c == nil || c.SupportKey == nil {
		return ""
	}
	return *c.SupportKey
}

// GetUnlimitedSeating returns the UnlimitedSeating field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsLicenseSettings) GetUnlimitedSeating() bool {
	if c == nil || c.UnlimitedSeating == nil {
		return false
	}
	return *c.UnlimitedSeating
}

// GetBasemap returns the Basemap field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsMapping) GetBasemap() string {
	if c == nil || c.Basemap == nil {
		return ""
	}
	return *c.Basemap
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsMapping) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetTileserver returns the Tileserver field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsMapping) GetTileserver() string {
	if c == nil || c.Tileserver == nil {
		return ""
	}
	return *c.Tileserver
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsMapping) GetToken() string {
	if c == nil || c.Token == nil {
		return ""
	}
	return *c.Token
}

// GetPrimaryServer returns the PrimaryServer field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsNTP) GetPrimaryServer() string {
	if c == nil || c.PrimaryServer == nil {
		return ""
	}
	return *c.PrimaryServer
}

// GetSecondaryServer returns the SecondaryServer field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsNTP) GetSecondaryServer() string {
	if c == nil || c.SecondaryServer == nil {
		return ""
	}
	return *c.SecondaryServer
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsPagesSettings) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetCertificate returns the Certificate field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetCertificate() string {
	if c == nil || c.Certificate == nil {
		return ""
	}
	return *c.Certificate
}

// GetCertificatePath returns the CertificatePath field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetCertificatePath() string {
	if c == nil || c.CertificatePath == nil {
		return ""
	}
	return *c.CertificatePath
}

// GetDisableAdminDemote returns the DisableAdminDemote field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetDisableAdminDemote() bool {
	if c == nil || c.DisableAdminDemote == nil {
		return false
	}
	return *c.DisableAdminDemote
}

// GetIDPInitiatedSSO returns the IDPInitiatedSSO field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetIDPInitiatedSSO() bool {
	if c == nil || c.IDPInitiatedSSO == nil {
		return false
	}
	return *c.IDPInitiatedSSO
}

// GetIssuer returns the Issuer field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetIssuer() string {
	if c == nil || c.Issuer == nil {
		return ""
	}
	return *c.Issuer
}

// GetSSOURL returns the SSOURL field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSAML) GetSSOURL() string {
	if c == nil || c.SSOURL == nil {
		return ""
	}
	return *c.SSOURL
}

// GetAddress returns the Address field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetAddress() string {
	if c == nil || c.Address == nil {
		return ""
	}
	return *c.Address
}

// GetAuthentication returns the Authentication field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetAuthentication() string {
	if c == nil || c.Authentication == nil {
		return ""
	}
	return *c.Authentication
}

// GetDiscardToNoreplyAddress returns the DiscardToNoreplyAddress field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetDiscardToNoreplyAddress() bool {
	if c == nil || c.DiscardToNoreplyAddress == nil {
		return false
	}
	return *c.DiscardToNoreplyAddress
}

// GetDomain returns the Domain field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetDomain() string {
	if c == nil || c.Domain == nil {
		return ""
	}
	return *c.Domain
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetEnableStarttlsAuto returns the EnableStarttlsAuto field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetEnableStarttlsAuto() bool {
	if c == nil || c.EnableStarttlsAuto == nil {
		return false
	}
	return *c.EnableStarttlsAuto
}

// GetNoreplyAddress returns the NoreplyAddress field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetNoreplyAddress() string {
	if c == nil || c.NoreplyAddress == nil {
		return ""
	}
	return *c.NoreplyAddress
}

// GetPassword returns the Password field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetPassword() string {
	if c == nil || c.Password == nil {
		return ""
	}
	return *c.Password
}

// GetPort returns the Port field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetPort() string {
	if c == nil || c.Port == nil {
		return ""
	}
	return *c.Port
}

// GetSupportAddress returns the SupportAddress field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetSupportAddress() string {
	if c == nil || c.SupportAddress == nil {
		return ""
	}
	return *c.SupportAddress
}

// GetSupportAddressType returns the SupportAddressType field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetSupportAddressType() string {
	if c == nil || c.SupportAddressType == nil {
		return ""
	}
	return *c.SupportAddressType
}

// GetUsername returns the Username field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetUsername() string {
	if c == nil || c.Username == nil {
		return ""
	}
	return *c.Username
}

// GetUserName returns the UserName field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSMTP) GetUserName() string {
	if c == nil || c.UserName == nil {
		return ""
	}
	return *c.UserName
}

// GetCommunity returns the Community field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSNMP) GetCommunity() string {
	if c == nil || c.Community == nil {
		return ""
	}
	return *c.Community
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSNMP) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSyslog) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetProtocolName returns the ProtocolName field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSyslog) GetProtocolName() string {
	if c == nil || c.ProtocolName == nil {
		return ""
	}
	return *c.ProtocolName
}

// GetServer returns the Server field if it's non-nil, zero value otherwise.
func (c *ConfigSettingsSyslog) GetServer() string {
	if c == nil || c.Server == nil {
		return ""
	}
	return *c.Server
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *ConnectionServiceItem) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (c *ConnectionServiceItem) GetNumber() int {
	if c == nil || c.Number == nil {
		return 0
	}
	return *c.Number
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *ContentReference) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *ContentReference) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetReference returns the Reference field if it's non-nil, zero value otherwise.
func (c *ContentReference) GetReference() string {
	if c == nil || c.Reference == nil {
		return ""
	}
	return *c.Reference
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *ContentReferenceEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetContentReference returns the ContentReference field.
func (c *ContentReferenceEvent) GetContentReference() *ContentReference {
	if c == nil {
		return nil
	}
	return c.ContentReference
}

// GetInstallation returns the Installation field.
func (c *ContentReferenceEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetRepo returns the Repo field.
func (c *ContentReferenceEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *ContentReferenceEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetAvatarURL() string {
	if c == nil || c.AvatarURL == nil {
		return ""
	}
	return *c.AvatarURL
}

// GetContributions returns the Contributions field if it's non-nil, zero value otherwise.
func (c *Contributor) GetContributions() int {
	if c == nil || c.Contributions == nil {
		return 0
	}
	return *c.Contributions
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (c *Contributor) GetEmail() string {
	if c == nil || c.Email == nil {
		return ""
	}
	return *c.Email
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetEventsURL() string {
	if c == nil || c.EventsURL == nil {
		return ""
	}
	return *c.EventsURL
}

// GetFollowersURL returns the FollowersURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetFollowersURL() string {
	if c == nil || c.FollowersURL == nil {
		return ""
	}
	return *c.FollowersURL
}

// GetFollowingURL returns the FollowingURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetFollowingURL() string {
	if c == nil || c.FollowingURL == nil {
		return ""
	}
	return *c.FollowingURL
}

// GetGistsURL returns the GistsURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetGistsURL() string {
	if c == nil || c.GistsURL == nil {
		return ""
	}
	return *c.GistsURL
}

// GetGravatarID returns the GravatarID field if it's non-nil, zero value otherwise.
func (c *Contributor) GetGravatarID() string {
	if c == nil || c.GravatarID == nil {
		return ""
	}
	return *c.GravatarID
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetHTMLURL() string {
	if c == nil || c.HTMLURL == nil {
		return ""
	}
	return *c.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *Contributor) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (c *Contributor) GetLogin() string {
	if c == nil || c.Login == nil {
		return ""
	}
	return *c.Login
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *Contributor) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *Contributor) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetOrganizationsURL returns the OrganizationsURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetOrganizationsURL() string {
	if c == nil || c.OrganizationsURL == nil {
		return ""
	}
	return *c.OrganizationsURL
}

// GetReceivedEventsURL returns the ReceivedEventsURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetReceivedEventsURL() string {
	if c == nil || c.ReceivedEventsURL == nil {
		return ""
	}
	return *c.ReceivedEventsURL
}

// GetReposURL returns the ReposURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetReposURL() string {
	if c == nil || c.ReposURL == nil {
		return ""
	}
	return *c.ReposURL
}

// GetSiteAdmin returns the SiteAdmin field if it's non-nil, zero value otherwise.
func (c *Contributor) GetSiteAdmin() bool {
	if c == nil || c.SiteAdmin == nil {
		return false
	}
	return *c.SiteAdmin
}

// GetStarredURL returns the StarredURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetStarredURL() string {
	if c == nil || c.StarredURL == nil {
		return ""
	}
	return *c.StarredURL
}

// GetSubscriptionsURL returns the SubscriptionsURL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetSubscriptionsURL() string {
	if c == nil || c.SubscriptionsURL == nil {
		return ""
	}
	return *c.SubscriptionsURL
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (c *Contributor) GetType() string {
	if c == nil || c.Type == nil {
		return ""
	}
	return *c.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (c *Contributor) GetURL() string {
	if c == nil || c.URL == nil {
		return ""
	}
	return *c.URL
}

// GetAuthor returns the Author field.
func (c *ContributorStats) GetAuthor() *Contributor {
	if c == nil {
		return nil
	}
	return c.Author
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (c *ContributorStats) GetTotal() int {
	if c == nil || c.Total == nil {
		return 0
	}
	return *c.Total
}

// GetCustomModelTrainingDate returns the CustomModelTrainingDate field if it's non-nil, zero value otherwise.
func (c *CopilotDotcomChatModel) GetCustomModelTrainingDate() string {
	if c == nil || c.CustomModelTrainingDate == nil {
		return ""
	}
	return *c.CustomModelTrainingDate
}

// GetCustomModelTrainingDate returns the CustomModelTrainingDate field if it's non-nil, zero value otherwise.
func (c *CopilotDotcomPullRequestsModel) GetCustomModelTrainingDate() string {
	if c == nil || c.CustomModelTrainingDate == nil {
		return ""
	}
	return *c.CustomModelTrainingDate
}

// GetCustomModelTrainingDate returns the CustomModelTrainingDate field if it's non-nil, zero value otherwise.
func (c *CopilotIDEChatModel) GetCustomModelTrainingDate() string {
	if c == nil || c.CustomModelTrainingDate == nil {
		return ""
	}
	return *c.CustomModelTrainingDate
}

// GetCustomModelTrainingDate returns the CustomModelTrainingDate field if it's non-nil, zero value otherwise.
func (c *CopilotIDECodeCompletionsModel) GetCustomModelTrainingDate() string {
	if c == nil || c.CustomModelTrainingDate == nil {
		return ""
	}
	return *c.CustomModelTrainingDate
}

// GetCopilotDotcomChat returns the CopilotDotcomChat field.
func (c *CopilotMetrics) GetCopilotDotcomChat() *CopilotDotcomChat {
	if c == nil {
		return nil
	}
	return c.CopilotDotcomChat
}

// GetCopilotDotcomPullRequests returns the CopilotDotcomPullRequests field.
func (c *CopilotMetrics) GetCopilotDotcomPullRequests() *CopilotDotcomPullRequests {
	if c == nil {
		return nil
	}
	return c.CopilotDotcomPullRequests
}

// GetCopilotIDEChat returns the CopilotIDEChat field.
func (c *CopilotMetrics) GetCopilotIDEChat() *CopilotIDEChat {
	if c == nil {
		return nil
	}
	return c.CopilotIDEChat
}

// GetCopilotIDECodeCompletions returns the CopilotIDECodeCompletions field.
func (c *CopilotMetrics) GetCopilotIDECodeCompletions() *CopilotIDECodeCompletions {
	if c == nil {
		return nil
	}
	return c.CopilotIDECodeCompletions
}

// GetTotalActiveUsers returns the TotalActiveUsers field if it's non-nil, zero value otherwise.
func (c *CopilotMetrics) GetTotalActiveUsers() int {
	if c == nil || c.TotalActiveUsers == nil {
		return 0
	}
	return *c.TotalActiveUsers
}

// GetTotalEngagedUsers returns the TotalEngagedUsers field if it's non-nil, zero value otherwise.
func (c *CopilotMetrics) GetTotalEngagedUsers() int {
	if c == nil || c.TotalEngagedUsers == nil {
		return 0
	}
	return *c.TotalEngagedUsers
}

// GetSince returns the Since field if it's non-nil, zero value otherwise.
func (c *CopilotMetricsListOptions) GetSince() time.Time {
	if c == nil || c.Since == nil {
		return time.Time{}
	}
	return *c.Since
}

// GetUntil returns the Until field if it's non-nil, zero value otherwise.
func (c *CopilotMetricsListOptions) GetUntil() time.Time {
	if c == nil || c.Until == nil {
		return time.Time{}
	}
	return *c.Until
}

// GetSeatBreakdown returns the SeatBreakdown field.
func (c *CopilotOrganizationDetails) GetSeatBreakdown() *CopilotSeatBreakdown {
	if c == nil {
		return nil
	}
	return c.SeatBreakdown
}

// GetAssigningTeam returns the AssigningTeam field.
func (c *CopilotSeatDetails) GetAssigningTeam() *Team {
	if c == nil {
		return nil
	}
	return c.AssigningTeam
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetLastActivityAt returns the LastActivityAt field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetLastActivityAt() Timestamp {
	if c == nil || c.LastActivityAt == nil {
		return Timestamp{}
	}
	return *c.LastActivityAt
}

// GetLastActivityEditor returns the LastActivityEditor field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetLastActivityEditor() string {
	if c == nil || c.LastActivityEditor == nil {
		return ""
	}
	return *c.LastActivityEditor
}

// GetPendingCancellationDate returns the PendingCancellationDate field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetPendingCancellationDate() string {
	if c == nil || c.PendingCancellationDate == nil {
		return ""
	}
	return *c.PendingCancellationDate
}

// GetPlanType returns the PlanType field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetPlanType() string {
	if c == nil || c.PlanType == nil {
		return ""
	}
	return *c.PlanType
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CopilotSeatDetails) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetCompletedAt returns the CompletedAt field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetCompletedAt() Timestamp {
	if c == nil || c.CompletedAt == nil {
		return Timestamp{}
	}
	return *c.CompletedAt
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetConclusion() string {
	if c == nil || c.Conclusion == nil {
		return ""
	}
	return *c.Conclusion
}

// GetDetailsURL returns the DetailsURL field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetDetailsURL() string {
	if c == nil || c.DetailsURL == nil {
		return ""
	}
	return *c.DetailsURL
}

// GetExternalID returns the ExternalID field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetExternalID() string {
	if c == nil || c.ExternalID == nil {
		return ""
	}
	return *c.ExternalID
}

// GetOutput returns the Output field.
func (c *CreateCheckRunOptions) GetOutput() *CheckRunOutput {
	if c == nil {
		return nil
	}
	return c.Output
}

// GetStartedAt returns the StartedAt field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetStartedAt() Timestamp {
	if c == nil || c.StartedAt == nil {
		return Timestamp{}
	}
	return *c.StartedAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (c *CreateCheckRunOptions) GetStatus() string {
	if c == nil || c.Status == nil {
		return ""
	}
	return *c.Status
}

// GetHeadBranch returns the HeadBranch field if it's non-nil, zero value otherwise.
func (c *CreateCheckSuiteOptions) GetHeadBranch() string {
	if c == nil || c.HeadBranch == nil {
		return ""
	}
	return *c.HeadBranch
}

// GetClientIP returns the ClientIP field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetClientIP() string {
	if c == nil || c.ClientIP == nil {
		return ""
	}
	return *c.ClientIP
}

// GetDevcontainerPath returns the DevcontainerPath field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetDevcontainerPath() string {
	if c == nil || c.DevcontainerPath == nil {
		return ""
	}
	return *c.DevcontainerPath
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetDisplayName() string {
	if c == nil || c.DisplayName == nil {
		return ""
	}
	return *c.DisplayName
}

// GetGeo returns the Geo field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetGeo() string {
	if c == nil || c.Geo == nil {
		return ""
	}
	return *c.Geo
}

// GetIdleTimeoutMinutes returns the IdleTimeoutMinutes field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetIdleTimeoutMinutes() int {
	if c == nil || c.IdleTimeoutMinutes == nil {
		return 0
	}
	return *c.IdleTimeoutMinutes
}

// GetMachine returns the Machine field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetMachine() string {
	if c == nil || c.Machine == nil {
		return ""
	}
	return *c.Machine
}

// GetMultiRepoPermissionsOptOut returns the MultiRepoPermissionsOptOut field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetMultiRepoPermissionsOptOut() bool {
	if c == nil || c.MultiRepoPermissionsOptOut == nil {
		return false
	}
	return *c.MultiRepoPermissionsOptOut
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetRef() string {
	if c == nil || c.Ref == nil {
		return ""
	}
	return *c.Ref
}

// GetRetentionPeriodMinutes returns the RetentionPeriodMinutes field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetRetentionPeriodMinutes() int {
	if c == nil || c.RetentionPeriodMinutes == nil {
		return 0
	}
	return *c.RetentionPeriodMinutes
}

// GetWorkingDirectory returns the WorkingDirectory field if it's non-nil, zero value otherwise.
func (c *CreateCodespaceOptions) GetWorkingDirectory() string {
	if c == nil || c.WorkingDirectory == nil {
		return ""
	}
	return *c.WorkingDirectory
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (c *CreateEnterpriseRunnerGroupRequest) GetAllowsPublicRepositories() bool {
	if c == nil || c.AllowsPublicRepositories == nil {
		return false
	}
	return *c.AllowsPublicRepositories
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CreateEnterpriseRunnerGroupRequest) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (c *CreateEnterpriseRunnerGroupRequest) GetRestrictedToWorkflows() bool {
	if c == nil || c.RestrictedToWorkflows == nil {
		return false
	}
	return *c.RestrictedToWorkflows
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (c *CreateEnterpriseRunnerGroupRequest) GetVisibility() string {
	if c == nil || c.Visibility == nil {
		return ""
	}
	return *c.Visibility
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CreateEvent) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetInstallation returns the Installation field.
func (c *CreateEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetMasterBranch returns the MasterBranch field if it's non-nil, zero value otherwise.
func (c *CreateEvent) GetMasterBranch() string {
	if c == nil || c.MasterBranch == nil {
		return ""
	}
	return *c.MasterBranch
}

// GetOrg returns the Org field.
func (c *CreateEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetPusherType returns the PusherType field if it's non-nil, zero value otherwise.
func (c *CreateEvent) GetPusherType() string {
	if c == nil || c.PusherType == nil {
		return ""
	}
	return *c.PusherType
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (c *CreateEvent) GetRef() string {
	if c == nil || c.Ref == nil {
		return ""
	}
	return *c.Ref
}

// GetRefType returns the RefType field if it's non-nil, zero value otherwise.
func (c *CreateEvent) GetRefType() string {
	if c == nil || c.RefType == nil {
		return ""
	}
	return *c.RefType
}

// GetRepo returns the Repo field.
func (c *CreateEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *CreateEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (c *CreateOrgInvitationOptions) GetEmail() string {
	if c == nil || c.Email == nil {
		return ""
	}
	return *c.Email
}

// GetInviteeID returns the InviteeID field if it's non-nil, zero value otherwise.
func (c *CreateOrgInvitationOptions) GetInviteeID() int64 {
	if c == nil || c.InviteeID == nil {
		return 0
	}
	return *c.InviteeID
}

// GetRole returns the Role field if it's non-nil, zero value otherwise.
func (c *CreateOrgInvitationOptions) GetRole() string {
	if c == nil || c.Role == nil {
		return ""
	}
	return *c.Role
}

// GetBaseRole returns the BaseRole field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateCustomRepoRoleOptions) GetBaseRole() string {
	if c == nil || c.BaseRole == nil {
		return ""
	}
	return *c.BaseRole
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateCustomRepoRoleOptions) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateCustomRepoRoleOptions) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetColor returns the Color field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateIssueTypesOptions) GetColor() string {
	if c == nil || c.Color == nil {
		return ""
	}
	return *c.Color
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateIssueTypesOptions) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetIsPrivate returns the IsPrivate field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateIssueTypesOptions) GetIsPrivate() bool {
	if c == nil || c.IsPrivate == nil {
		return false
	}
	return *c.IsPrivate
}

// GetBaseRole returns the BaseRole field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateOrgRoleOptions) GetBaseRole() string {
	if c == nil || c.BaseRole == nil {
		return ""
	}
	return *c.BaseRole
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateOrgRoleOptions) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CreateOrUpdateOrgRoleOptions) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (c *CreateProtectedChanges) GetFrom() bool {
	if c == nil || c.From == nil {
		return false
	}
	return *c.From
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (c *CreateRunnerGroupRequest) GetAllowsPublicRepositories() bool {
	if c == nil || c.AllowsPublicRepositories == nil {
		return false
	}
	return *c.AllowsPublicRepositories
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CreateRunnerGroupRequest) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (c *CreateRunnerGroupRequest) GetRestrictedToWorkflows() bool {
	if c == nil || c.RestrictedToWorkflows == nil {
		return false
	}
	return *c.RestrictedToWorkflows
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (c *CreateRunnerGroupRequest) GetVisibility() string {
	if c == nil || c.Visibility == nil {
		return ""
	}
	return *c.Visibility
}

// GetCanAdminsBypass returns the CanAdminsBypass field if it's non-nil, zero value otherwise.
func (c *CreateUpdateEnvironment) GetCanAdminsBypass() bool {
	if c == nil || c.CanAdminsBypass == nil {
		return false
	}
	return *c.CanAdminsBypass
}

// GetDeploymentBranchPolicy returns the DeploymentBranchPolicy field.
func (c *CreateUpdateEnvironment) GetDeploymentBranchPolicy() *BranchPolicy {
	if c == nil {
		return nil
	}
	return c.DeploymentBranchPolicy
}

// GetPreventSelfReview returns the PreventSelfReview field if it's non-nil, zero value otherwise.
func (c *CreateUpdateEnvironment) GetPreventSelfReview() bool {
	if c == nil || c.PreventSelfReview == nil {
		return false
	}
	return *c.PreventSelfReview
}

// GetWaitTimer returns the WaitTimer field if it's non-nil, zero value otherwise.
func (c *CreateUpdateEnvironment) GetWaitTimer() int {
	if c == nil || c.WaitTimer == nil {
		return 0
	}
	return *c.WaitTimer
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (c *CreateUserRequest) GetEmail() string {
	if c == nil || c.Email == nil {
		return ""
	}
	return *c.Email
}

// GetSuspended returns the Suspended field if it's non-nil, zero value otherwise.
func (c *CreateUserRequest) GetSuspended() bool {
	if c == nil || c.Suspended == nil {
		return false
	}
	return *c.Suspended
}

// GetCreated returns the Created field if it's non-nil, zero value otherwise.
func (c *CreationInfo) GetCreated() Timestamp {
	if c == nil || c.Created == nil {
		return Timestamp{}
	}
	return *c.Created
}

// GetAuthorizedCredentialExpiresAt returns the AuthorizedCredentialExpiresAt field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetAuthorizedCredentialExpiresAt() Timestamp {
	if c == nil || c.AuthorizedCredentialExpiresAt == nil {
		return Timestamp{}
	}
	return *c.AuthorizedCredentialExpiresAt
}

// GetAuthorizedCredentialID returns the AuthorizedCredentialID field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetAuthorizedCredentialID() int64 {
	if c == nil || c.AuthorizedCredentialID == nil {
		return 0
	}
	return *c.AuthorizedCredentialID
}

// GetAuthorizedCredentialNote returns the AuthorizedCredentialNote field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetAuthorizedCredentialNote() string {
	if c == nil || c.AuthorizedCredentialNote == nil {
		return ""
	}
	return *c.AuthorizedCredentialNote
}

// GetAuthorizedCredentialTitle returns the AuthorizedCredentialTitle field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetAuthorizedCredentialTitle() string {
	if c == nil || c.AuthorizedCredentialTitle == nil {
		return ""
	}
	return *c.AuthorizedCredentialTitle
}

// GetCredentialAccessedAt returns the CredentialAccessedAt field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetCredentialAccessedAt() Timestamp {
	if c == nil || c.CredentialAccessedAt == nil {
		return Timestamp{}
	}
	return *c.CredentialAccessedAt
}

// GetCredentialAuthorizedAt returns the CredentialAuthorizedAt field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetCredentialAuthorizedAt() Timestamp {
	if c == nil || c.CredentialAuthorizedAt == nil {
		return Timestamp{}
	}
	return *c.CredentialAuthorizedAt
}

// GetCredentialID returns the CredentialID field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetCredentialID() int64 {
	if c == nil || c.CredentialID == nil {
		return 0
	}
	return *c.CredentialID
}

// GetCredentialType returns the CredentialType field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetCredentialType() string {
	if c == nil || c.CredentialType == nil {
		return ""
	}
	return *c.CredentialType
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetFingerprint() string {
	if c == nil || c.Fingerprint == nil {
		return ""
	}
	return *c.Fingerprint
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetLogin() string {
	if c == nil || c.Login == nil {
		return ""
	}
	return *c.Login
}

// GetTokenLastEight returns the TokenLastEight field if it's non-nil, zero value otherwise.
func (c *CredentialAuthorization) GetTokenLastEight() string {
	if c == nil || c.TokenLastEight == nil {
		return ""
	}
	return *c.TokenLastEight
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (c *Credit) GetType() string {
	if c == nil || c.Type == nil {
		return ""
	}
	return *c.Type
}

// GetUser returns the User field.
func (c *Credit) GetUser() *User {
	if c == nil {
		return nil
	}
	return c.User
}

// GetApp returns the App field.
func (c *CustomDeploymentProtectionRule) GetApp() *CustomDeploymentProtectionRuleApp {
	if c == nil {
		return nil
	}
	return c.App
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRule) GetEnabled() bool {
	if c == nil || c.Enabled == nil {
		return false
	}
	return *c.Enabled
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRule) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRule) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRuleApp) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetIntegrationURL returns the IntegrationURL field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRuleApp) GetIntegrationURL() string {
	if c == nil || c.IntegrationURL == nil {
		return ""
	}
	return *c.IntegrationURL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRuleApp) GetNodeID() string {
	if c == nil || c.NodeID == nil {
		return ""
	}
	return *c.NodeID
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRuleApp) GetSlug() string {
	if c == nil || c.Slug == nil {
		return ""
	}
	return *c.Slug
}

// GetIntegrationID returns the IntegrationID field if it's non-nil, zero value otherwise.
func (c *CustomDeploymentProtectionRuleRequest) GetIntegrationID() int64 {
	if c == nil || c.IntegrationID == nil {
		return 0
	}
	return *c.IntegrationID
}

// GetBaseRole returns the BaseRole field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetBaseRole() string {
	if c == nil || c.BaseRole == nil {
		return ""
	}
	return *c.BaseRole
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetOrg returns the Org field.
func (c *CustomOrgRoles) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetSource returns the Source field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetSource() string {
	if c == nil || c.Source == nil {
		return ""
	}
	return *c.Source
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CustomOrgRoles) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetDefaultValue returns the DefaultValue field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetDefaultValue() string {
	if c == nil || c.DefaultValue == nil {
		return ""
	}
	return *c.DefaultValue
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetPropertyName returns the PropertyName field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetPropertyName() string {
	if c == nil || c.PropertyName == nil {
		return ""
	}
	return *c.PropertyName
}

// GetRequired returns the Required field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetRequired() bool {
	if c == nil || c.Required == nil {
		return false
	}
	return *c.Required
}

// GetSourceType returns the SourceType field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetSourceType() string {
	if c == nil || c.SourceType == nil {
		return ""
	}
	return *c.SourceType
}

// GetValuesEditableBy returns the ValuesEditableBy field if it's non-nil, zero value otherwise.
func (c *CustomProperty) GetValuesEditableBy() string {
	if c == nil || c.ValuesEditableBy == nil {
		return ""
	}
	return *c.ValuesEditableBy
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CustomPropertyEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetDefinition returns the Definition field.
func (c *CustomPropertyEvent) GetDefinition() *CustomProperty {
	if c == nil {
		return nil
	}
	return c.Definition
}

// GetEnterprise returns the Enterprise field.
func (c *CustomPropertyEvent) GetEnterprise() *Enterprise {
	if c == nil {
		return nil
	}
	return c.Enterprise
}

// GetInstallation returns the Installation field.
func (c *CustomPropertyEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CustomPropertyEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetSender returns the Sender field.
func (c *CustomPropertyEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (c *CustomPropertyValuesEvent) GetAction() string {
	if c == nil || c.Action == nil {
		return ""
	}
	return *c.Action
}

// GetEnterprise returns the Enterprise field.
func (c *CustomPropertyValuesEvent) GetEnterprise() *Enterprise {
	if c == nil {
		return nil
	}
	return c.Enterprise
}

// GetInstallation returns the Installation field.
func (c *CustomPropertyValuesEvent) GetInstallation() *Installation {
	if c == nil {
		return nil
	}
	return c.Installation
}

// GetOrg returns the Org field.
func (c *CustomPropertyValuesEvent) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetRepo returns the Repo field.
func (c *CustomPropertyValuesEvent) GetRepo() *Repository {
	if c == nil {
		return nil
	}
	return c.Repo
}

// GetSender returns the Sender field.
func (c *CustomPropertyValuesEvent) GetSender() *User {
	if c == nil {
		return nil
	}
	return c.Sender
}

// GetBaseRole returns the BaseRole field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetBaseRole() string {
	if c == nil || c.BaseRole == nil {
		return ""
	}
	return *c.BaseRole
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetCreatedAt() Timestamp {
	if c == nil || c.CreatedAt == nil {
		return Timestamp{}
	}
	return *c.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetDescription() string {
	if c == nil || c.Description == nil {
		return ""
	}
	return *c.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetID() int64 {
	if c == nil || c.ID == nil {
		return 0
	}
	return *c.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetName() string {
	if c == nil || c.Name == nil {
		return ""
	}
	return *c.Name
}

// GetOrg returns the Org field.
func (c *CustomRepoRoles) GetOrg() *Organization {
	if c == nil {
		return nil
	}
	return c.Org
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (c *CustomRepoRoles) GetUpdatedAt() Timestamp {
	if c == nil || c.UpdatedAt == nil {
		return Timestamp{}
	}
	return *c.UpdatedAt
}

// GetQuerySuite returns the QuerySuite field if it's non-nil, zero value otherwise.
func (d *DefaultSetupConfiguration) GetQuerySuite() string {
	if d == nil || d.QuerySuite == nil {
		return ""
	}
	return *d.QuerySuite
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *DefaultSetupConfiguration) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DefaultSetupConfiguration) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetCanApprovePullRequestReviews returns the CanApprovePullRequestReviews field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionEnterprise) GetCanApprovePullRequestReviews() bool {
	if d == nil || d.CanApprovePullRequestReviews == nil {
		return false
	}
	return *d.CanApprovePullRequestReviews
}

// GetDefaultWorkflowPermissions returns the DefaultWorkflowPermissions field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionEnterprise) GetDefaultWorkflowPermissions() string {
	if d == nil || d.DefaultWorkflowPermissions == nil {
		return ""
	}
	return *d.DefaultWorkflowPermissions
}

// GetCanApprovePullRequestReviews returns the CanApprovePullRequestReviews field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionOrganization) GetCanApprovePullRequestReviews() bool {
	if d == nil || d.CanApprovePullRequestReviews == nil {
		return false
	}
	return *d.CanApprovePullRequestReviews
}

// GetDefaultWorkflowPermissions returns the DefaultWorkflowPermissions field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionOrganization) GetDefaultWorkflowPermissions() string {
	if d == nil || d.DefaultWorkflowPermissions == nil {
		return ""
	}
	return *d.DefaultWorkflowPermissions
}

// GetCanApprovePullRequestReviews returns the CanApprovePullRequestReviews field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionRepository) GetCanApprovePullRequestReviews() bool {
	if d == nil || d.CanApprovePullRequestReviews == nil {
		return false
	}
	return *d.CanApprovePullRequestReviews
}

// GetDefaultWorkflowPermissions returns the DefaultWorkflowPermissions field if it's non-nil, zero value otherwise.
func (d *DefaultWorkflowPermissionRepository) GetDefaultWorkflowPermissions() string {
	if d == nil || d.DefaultWorkflowPermissions == nil {
		return ""
	}
	return *d.DefaultWorkflowPermissions
}

// GetConfirmDeleteURL returns the ConfirmDeleteURL field if it's non-nil, zero value otherwise.
func (d *DeleteAnalysis) GetConfirmDeleteURL() string {
	if d == nil || d.ConfirmDeleteURL == nil {
		return ""
	}
	return *d.ConfirmDeleteURL
}

// GetNextAnalysisURL returns the NextAnalysisURL field if it's non-nil, zero value otherwise.
func (d *DeleteAnalysis) GetNextAnalysisURL() string {
	if d == nil || d.NextAnalysisURL == nil {
		return ""
	}
	return *d.NextAnalysisURL
}

// GetInstallation returns the Installation field.
func (d *DeleteEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrg returns the Org field.
func (d *DeleteEvent) GetOrg() *Organization {
	if d == nil {
		return nil
	}
	return d.Org
}

// GetPusherType returns the PusherType field if it's non-nil, zero value otherwise.
func (d *DeleteEvent) GetPusherType() string {
	if d == nil || d.PusherType == nil {
		return ""
	}
	return *d.PusherType
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (d *DeleteEvent) GetRef() string {
	if d == nil || d.Ref == nil {
		return ""
	}
	return *d.Ref
}

// GetRefType returns the RefType field if it's non-nil, zero value otherwise.
func (d *DeleteEvent) GetRefType() string {
	if d == nil || d.RefType == nil {
		return ""
	}
	return *d.RefType
}

// GetRepo returns the Repo field.
func (d *DeleteEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DeleteEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetAutoDismissedAt returns the AutoDismissedAt field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetAutoDismissedAt() Timestamp {
	if d == nil || d.AutoDismissedAt == nil {
		return Timestamp{}
	}
	return *d.AutoDismissedAt
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetDependency returns the Dependency field.
func (d *DependabotAlert) GetDependency() *Dependency {
	if d == nil {
		return nil
	}
	return d.Dependency
}

// GetDismissedAt returns the DismissedAt field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetDismissedAt() Timestamp {
	if d == nil || d.DismissedAt == nil {
		return Timestamp{}
	}
	return *d.DismissedAt
}

// GetDismissedBy returns the DismissedBy field.
func (d *DependabotAlert) GetDismissedBy() *User {
	if d == nil {
		return nil
	}
	return d.DismissedBy
}

// GetDismissedComment returns the DismissedComment field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetDismissedComment() string {
	if d == nil || d.DismissedComment == nil {
		return ""
	}
	return *d.DismissedComment
}

// GetDismissedReason returns the DismissedReason field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetDismissedReason() string {
	if d == nil || d.DismissedReason == nil {
		return ""
	}
	return *d.DismissedReason
}

// GetFixedAt returns the FixedAt field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetFixedAt() Timestamp {
	if d == nil || d.FixedAt == nil {
		return Timestamp{}
	}
	return *d.FixedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetHTMLURL() string {
	if d == nil || d.HTMLURL == nil {
		return ""
	}
	return *d.HTMLURL
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetNumber() int {
	if d == nil || d.Number == nil {
		return 0
	}
	return *d.Number
}

// GetRepository returns the Repository field.
func (d *DependabotAlert) GetRepository() *Repository {
	if d == nil {
		return nil
	}
	return d.Repository
}

// GetSecurityAdvisory returns the SecurityAdvisory field.
func (d *DependabotAlert) GetSecurityAdvisory() *DependabotSecurityAdvisory {
	if d == nil {
		return nil
	}
	return d.SecurityAdvisory
}

// GetSecurityVulnerability returns the SecurityVulnerability field.
func (d *DependabotAlert) GetSecurityVulnerability() *AdvisoryVulnerability {
	if d == nil {
		return nil
	}
	return d.SecurityVulnerability
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (d *DependabotAlert) GetURL() string {
	if d == nil || d.URL == nil {
		return ""
	}
	return *d.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DependabotAlertEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetAlert returns the Alert field.
func (d *DependabotAlertEvent) GetAlert() *DependabotAlert {
	if d == nil {
		return nil
	}
	return d.Alert
}

// GetEnterprise returns the Enterprise field.
func (d *DependabotAlertEvent) GetEnterprise() *Enterprise {
	if d == nil {
		return nil
	}
	return d.Enterprise
}

// GetInstallation returns the Installation field.
func (d *DependabotAlertEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrganization returns the Organization field.
func (d *DependabotAlertEvent) GetOrganization() *Organization {
	if d == nil {
		return nil
	}
	return d.Organization
}

// GetRepo returns the Repo field.
func (d *DependabotAlertEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DependabotAlertEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetDismissedComment returns the DismissedComment field if it's non-nil, zero value otherwise.
func (d *DependabotAlertState) GetDismissedComment() string {
	if d == nil || d.DismissedComment == nil {
		return ""
	}
	return *d.DismissedComment
}

// GetDismissedReason returns the DismissedReason field if it's non-nil, zero value otherwise.
func (d *DependabotAlertState) GetDismissedReason() string {
	if d == nil || d.DismissedReason == nil {
		return ""
	}
	return *d.DismissedReason
}

// GetCVEID returns the CVEID field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetCVEID() string {
	if d == nil || d.CVEID == nil {
		return ""
	}
	return *d.CVEID
}

// GetCVSS returns the CVSS field.
func (d *DependabotSecurityAdvisory) GetCVSS() *AdvisoryCVSS {
	if d == nil {
		return nil
	}
	return d.CVSS
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEPSS returns the EPSS field.
func (d *DependabotSecurityAdvisory) GetEPSS() *AdvisoryEPSS {
	if d == nil {
		return nil
	}
	return d.EPSS
}

// GetGHSAID returns the GHSAID field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetGHSAID() string {
	if d == nil || d.GHSAID == nil {
		return ""
	}
	return *d.GHSAID
}

// GetPublishedAt returns the PublishedAt field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetPublishedAt() Timestamp {
	if d == nil || d.PublishedAt == nil {
		return Timestamp{}
	}
	return *d.PublishedAt
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetSeverity() string {
	if d == nil || d.Severity == nil {
		return ""
	}
	return *d.Severity
}

// GetSummary returns the Summary field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetSummary() string {
	if d == nil || d.Summary == nil {
		return ""
	}
	return *d.Summary
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetWithdrawnAt returns the WithdrawnAt field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityAdvisory) GetWithdrawnAt() Timestamp {
	if d == nil || d.WithdrawnAt == nil {
		return Timestamp{}
	}
	return *d.WithdrawnAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (d *DependabotSecurityUpdates) GetStatus() string {
	if d == nil || d.Status == nil {
		return ""
	}
	return *d.Status
}

// GetManifestPath returns the ManifestPath field if it's non-nil, zero value otherwise.
func (d *Dependency) GetManifestPath() string {
	if d == nil || d.ManifestPath == nil {
		return ""
	}
	return *d.ManifestPath
}

// GetPackage returns the Package field.
func (d *Dependency) GetPackage() *VulnerabilityPackage {
	if d == nil {
		return nil
	}
	return d.Package
}

// GetScope returns the Scope field if it's non-nil, zero value otherwise.
func (d *Dependency) GetScope() string {
	if d == nil || d.Scope == nil {
		return ""
	}
	return *d.Scope
}

// GetLabeledRunners returns the LabeledRunners field if it's non-nil, zero value otherwise.
func (d *DependencyGraphAutosubmitActionOptions) GetLabeledRunners() bool {
	if d == nil || d.LabeledRunners == nil {
		return false
	}
	return *d.LabeledRunners
}

// GetDetector returns the Detector field.
func (d *DependencyGraphSnapshot) GetDetector() *DependencyGraphSnapshotDetector {
	if d == nil {
		return nil
	}
	return d.Detector
}

// GetJob returns the Job field.
func (d *DependencyGraphSnapshot) GetJob() *DependencyGraphSnapshotJob {
	if d == nil {
		return nil
	}
	return d.Job
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshot) GetRef() string {
	if d == nil || d.Ref == nil {
		return ""
	}
	return *d.Ref
}

// GetScanned returns the Scanned field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshot) GetScanned() Timestamp {
	if d == nil || d.Scanned == nil {
		return Timestamp{}
	}
	return *d.Scanned
}

// GetSha returns the Sha field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshot) GetSha() string {
	if d == nil || d.Sha == nil {
		return ""
	}
	return *d.Sha
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotCreationData) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotCreationData) GetMessage() string {
	if d == nil || d.Message == nil {
		return ""
	}
	return *d.Message
}

// GetResult returns the Result field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotCreationData) GetResult() string {
	if d == nil || d.Result == nil {
		return ""
	}
	return *d.Result
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotDetector) GetName() string {
	if d == nil || d.Name == nil {
		return ""
	}
	return *d.Name
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotDetector) GetURL() string {
	if d == nil || d.URL == nil {
		return ""
	}
	return *d.URL
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotDetector) GetVersion() string {
	if d == nil || d.Version == nil {
		return ""
	}
	return *d.Version
}

// GetCorrelator returns the Correlator field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotJob) GetCorrelator() string {
	if d == nil || d.Correlator == nil {
		return ""
	}
	return *d.Correlator
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotJob) GetHTMLURL() string {
	if d == nil || d.HTMLURL == nil {
		return ""
	}
	return *d.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotJob) GetID() string {
	if d == nil || d.ID == nil {
		return ""
	}
	return *d.ID
}

// GetFile returns the File field.
func (d *DependencyGraphSnapshotManifest) GetFile() *DependencyGraphSnapshotManifestFile {
	if d == nil {
		return nil
	}
	return d.File
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotManifest) GetName() string {
	if d == nil || d.Name == nil {
		return ""
	}
	return *d.Name
}

// GetSourceLocation returns the SourceLocation field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotManifestFile) GetSourceLocation() string {
	if d == nil || d.SourceLocation == nil {
		return ""
	}
	return *d.SourceLocation
}

// GetPackageURL returns the PackageURL field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotResolvedDependency) GetPackageURL() string {
	if d == nil || d.PackageURL == nil {
		return ""
	}
	return *d.PackageURL
}

// GetRelationship returns the Relationship field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotResolvedDependency) GetRelationship() string {
	if d == nil || d.Relationship == nil {
		return ""
	}
	return *d.Relationship
}

// GetScope returns the Scope field if it's non-nil, zero value otherwise.
func (d *DependencyGraphSnapshotResolvedDependency) GetScope() string {
	if d == nil || d.Scope == nil {
		return ""
	}
	return *d.Scope
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DeployKeyEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetInstallation returns the Installation field.
func (d *DeployKeyEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetKey returns the Key field.
func (d *DeployKeyEvent) GetKey() *Key {
	if d == nil {
		return nil
	}
	return d.Key
}

// GetOrganization returns the Organization field.
func (d *DeployKeyEvent) GetOrganization() *Organization {
	if d == nil {
		return nil
	}
	return d.Organization
}

// GetRepo returns the Repo field.
func (d *DeployKeyEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DeployKeyEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *Deployment) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetCreator returns the Creator field.
func (d *Deployment) GetCreator() *User {
	if d == nil {
		return nil
	}
	return d.Creator
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *Deployment) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *Deployment) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *Deployment) GetID() int64 {
	if d == nil || d.ID == nil {
		return 0
	}
	return *d.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *Deployment) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (d *Deployment) GetRef() string {
	if d == nil || d.Ref == nil {
		return ""
	}
	return *d.Ref
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (d *Deployment) GetRepositoryURL() string {
	if d == nil || d.RepositoryURL == nil {
		return ""
	}
	return *d.RepositoryURL
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (d *Deployment) GetSHA() string {
	if d == nil || d.SHA == nil {
		return ""
	}
	return *d.SHA
}

// GetStatusesURL returns the StatusesURL field if it's non-nil, zero value otherwise.
func (d *Deployment) GetStatusesURL() string {
	if d == nil || d.StatusesURL == nil {
		return ""
	}
	return *d.StatusesURL
}

// GetTask returns the Task field if it's non-nil, zero value otherwise.
func (d *Deployment) GetTask() string {
	if d == nil || d.Task == nil {
		return ""
	}
	return *d.Task
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *Deployment) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (d *Deployment) GetURL() string {
	if d == nil || d.URL == nil {
		return ""
	}
	return *d.URL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicy) GetID() int64 {
	if d == nil || d.ID == nil {
		return 0
	}
	return *d.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicy) GetName() string {
	if d == nil || d.Name == nil {
		return ""
	}
	return *d.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicy) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicy) GetType() string {
	if d == nil || d.Type == nil {
		return ""
	}
	return *d.Type
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicyRequest) GetName() string {
	if d == nil || d.Name == nil {
		return ""
	}
	return *d.Name
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicyRequest) GetType() string {
	if d == nil || d.Type == nil {
		return ""
	}
	return *d.Type
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (d *DeploymentBranchPolicyResponse) GetTotalCount() int {
	if d == nil || d.TotalCount == nil {
		return 0
	}
	return *d.TotalCount
}

// GetDeployment returns the Deployment field.
func (d *DeploymentEvent) GetDeployment() *Deployment {
	if d == nil {
		return nil
	}
	return d.Deployment
}

// GetInstallation returns the Installation field.
func (d *DeploymentEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrg returns the Org field.
func (d *DeploymentEvent) GetOrg() *Organization {
	if d == nil {
		return nil
	}
	return d.Org
}

// GetRepo returns the Repo field.
func (d *DeploymentEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DeploymentEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetWorkflow returns the Workflow field.
func (d *DeploymentEvent) GetWorkflow() *Workflow {
	if d == nil {
		return nil
	}
	return d.Workflow
}

// GetWorkflowRun returns the WorkflowRun field.
func (d *DeploymentEvent) GetWorkflowRun() *WorkflowRun {
	if d == nil {
		return nil
	}
	return d.WorkflowRun
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DeploymentProtectionRuleEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetDeployment returns the Deployment field.
func (d *DeploymentProtectionRuleEvent) GetDeployment() *Deployment {
	if d == nil {
		return nil
	}
	return d.Deployment
}

// GetDeploymentCallbackURL returns the DeploymentCallbackURL field if it's non-nil, zero value otherwise.
func (d *DeploymentProtectionRuleEvent) GetDeploymentCallbackURL() string {
	if d == nil || d.DeploymentCallbackURL == nil {
		return ""
	}
	return *d.DeploymentCallbackURL
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *DeploymentProtectionRuleEvent) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (d *DeploymentProtectionRuleEvent) GetEvent() string {
	if d == nil || d.Event == nil {
		return ""
	}
	return *d.Event
}

// GetInstallation returns the Installation field.
func (d *DeploymentProtectionRuleEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrganization returns the Organization field.
func (d *DeploymentProtectionRuleEvent) GetOrganization() *Organization {
	if d == nil {
		return nil
	}
	return d.Organization
}

// GetRepo returns the Repo field.
func (d *DeploymentProtectionRuleEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DeploymentProtectionRuleEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetAutoMerge returns the AutoMerge field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetAutoMerge() bool {
	if d == nil || d.AutoMerge == nil {
		return false
	}
	return *d.AutoMerge
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetProductionEnvironment returns the ProductionEnvironment field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetProductionEnvironment() bool {
	if d == nil || d.ProductionEnvironment == nil {
		return false
	}
	return *d.ProductionEnvironment
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetRef() string {
	if d == nil || d.Ref == nil {
		return ""
	}
	return *d.Ref
}

// GetRequiredContexts returns the RequiredContexts field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetRequiredContexts() []string {
	if d == nil || d.RequiredContexts == nil {
		return nil
	}
	return *d.RequiredContexts
}

// GetTask returns the Task field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetTask() string {
	if d == nil || d.Task == nil {
		return ""
	}
	return *d.Task
}

// GetTransientEnvironment returns the TransientEnvironment field if it's non-nil, zero value otherwise.
func (d *DeploymentRequest) GetTransientEnvironment() bool {
	if d == nil || d.TransientEnvironment == nil {
		return false
	}
	return *d.TransientEnvironment
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DeploymentReviewEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetApprover returns the Approver field.
func (d *DeploymentReviewEvent) GetApprover() *User {
	if d == nil {
		return nil
	}
	return d.Approver
}

// GetComment returns the Comment field if it's non-nil, zero value otherwise.
func (d *DeploymentReviewEvent) GetComment() string {
	if d == nil || d.Comment == nil {
		return ""
	}
	return *d.Comment
}

// GetEnterprise returns the Enterprise field.
func (d *DeploymentReviewEvent) GetEnterprise() *Enterprise {
	if d == nil {
		return nil
	}
	return d.Enterprise
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *DeploymentReviewEvent) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetInstallation returns the Installation field.
func (d *DeploymentReviewEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrganization returns the Organization field.
func (d *DeploymentReviewEvent) GetOrganization() *Organization {
	if d == nil {
		return nil
	}
	return d.Organization
}

// GetRepo returns the Repo field.
func (d *DeploymentReviewEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetRequester returns the Requester field.
func (d *DeploymentReviewEvent) GetRequester() *User {
	if d == nil {
		return nil
	}
	return d.Requester
}

// GetSender returns the Sender field.
func (d *DeploymentReviewEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetSince returns the Since field if it's non-nil, zero value otherwise.
func (d *DeploymentReviewEvent) GetSince() string {
	if d == nil || d.Since == nil {
		return ""
	}
	return *d.Since
}

// GetWorkflowJobRun returns the WorkflowJobRun field.
func (d *DeploymentReviewEvent) GetWorkflowJobRun() *WorkflowJobRun {
	if d == nil {
		return nil
	}
	return d.WorkflowJobRun
}

// GetWorkflowRun returns the WorkflowRun field.
func (d *DeploymentReviewEvent) GetWorkflowRun() *WorkflowRun {
	if d == nil {
		return nil
	}
	return d.WorkflowRun
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetCreator returns the Creator field.
func (d *DeploymentStatus) GetCreator() *User {
	if d == nil {
		return nil
	}
	return d.Creator
}

// GetDeploymentURL returns the DeploymentURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetDeploymentURL() string {
	if d == nil || d.DeploymentURL == nil {
		return ""
	}
	return *d.DeploymentURL
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetEnvironmentURL returns the EnvironmentURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetEnvironmentURL() string {
	if d == nil || d.EnvironmentURL == nil {
		return ""
	}
	return *d.EnvironmentURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetID() int64 {
	if d == nil || d.ID == nil {
		return 0
	}
	return *d.ID
}

// GetLogURL returns the LogURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetLogURL() string {
	if d == nil || d.LogURL == nil {
		return ""
	}
	return *d.LogURL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetRepositoryURL() string {
	if d == nil || d.RepositoryURL == nil {
		return ""
	}
	return *d.RepositoryURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetTargetURL returns the TargetURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetTargetURL() string {
	if d == nil || d.TargetURL == nil {
		return ""
	}
	return *d.TargetURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatus) GetURL() string {
	if d == nil || d.URL == nil {
		return ""
	}
	return *d.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetDeployment returns the Deployment field.
func (d *DeploymentStatusEvent) GetDeployment() *Deployment {
	if d == nil {
		return nil
	}
	return d.Deployment
}

// GetDeploymentStatus returns the DeploymentStatus field.
func (d *DeploymentStatusEvent) GetDeploymentStatus() *DeploymentStatus {
	if d == nil {
		return nil
	}
	return d.DeploymentStatus
}

// GetInstallation returns the Installation field.
func (d *DeploymentStatusEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrg returns the Org field.
func (d *DeploymentStatusEvent) GetOrg() *Organization {
	if d == nil {
		return nil
	}
	return d.Org
}

// GetRepo returns the Repo field.
func (d *DeploymentStatusEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DeploymentStatusEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetAutoInactive returns the AutoInactive field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetAutoInactive() bool {
	if d == nil || d.AutoInactive == nil {
		return false
	}
	return *d.AutoInactive
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetEnvironment() string {
	if d == nil || d.Environment == nil {
		return ""
	}
	return *d.Environment
}

// GetEnvironmentURL returns the EnvironmentURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetEnvironmentURL() string {
	if d == nil || d.EnvironmentURL == nil {
		return ""
	}
	return *d.EnvironmentURL
}

// GetLogURL returns the LogURL field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetLogURL() string {
	if d == nil || d.LogURL == nil {
		return ""
	}
	return *d.LogURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *DeploymentStatusRequest) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetActiveLockReason returns the ActiveLockReason field if it's non-nil, zero value otherwise.
func (d *Discussion) GetActiveLockReason() string {
	if d == nil || d.ActiveLockReason == nil {
		return ""
	}
	return *d.ActiveLockReason
}

// GetAnswerChosenAt returns the AnswerChosenAt field if it's non-nil, zero value otherwise.
func (d *Discussion) GetAnswerChosenAt() Timestamp {
	if d == nil || d.AnswerChosenAt == nil {
		return Timestamp{}
	}
	return *d.AnswerChosenAt
}

// GetAnswerChosenBy returns the AnswerChosenBy field if it's non-nil, zero value otherwise.
func (d *Discussion) GetAnswerChosenBy() string {
	if d == nil || d.AnswerChosenBy == nil {
		return ""
	}
	return *d.AnswerChosenBy
}

// GetAnswerHTMLURL returns the AnswerHTMLURL field if it's non-nil, zero value otherwise.
func (d *Discussion) GetAnswerHTMLURL() string {
	if d == nil || d.AnswerHTMLURL == nil {
		return ""
	}
	return *d.AnswerHTMLURL
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (d *Discussion) GetAuthorAssociation() string {
	if d == nil || d.AuthorAssociation == nil {
		return ""
	}
	return *d.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (d *Discussion) GetBody() string {
	if d == nil || d.Body == nil {
		return ""
	}
	return *d.Body
}

// GetComments returns the Comments field if it's non-nil, zero value otherwise.
func (d *Discussion) GetComments() int {
	if d == nil || d.Comments == nil {
		return 0
	}
	return *d.Comments
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *Discussion) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetDiscussionCategory returns the DiscussionCategory field.
func (d *Discussion) GetDiscussionCategory() *DiscussionCategory {
	if d == nil {
		return nil
	}
	return d.DiscussionCategory
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (d *Discussion) GetHTMLURL() string {
	if d == nil || d.HTMLURL == nil {
		return ""
	}
	return *d.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *Discussion) GetID() int64 {
	if d == nil || d.ID == nil {
		return 0
	}
	return *d.ID
}

// GetLocked returns the Locked field if it's non-nil, zero value otherwise.
func (d *Discussion) GetLocked() bool {
	if d == nil || d.Locked == nil {
		return false
	}
	return *d.Locked
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *Discussion) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (d *Discussion) GetNumber() int {
	if d == nil || d.Number == nil {
		return 0
	}
	return *d.Number
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (d *Discussion) GetRepositoryURL() string {
	if d == nil || d.RepositoryURL == nil {
		return ""
	}
	return *d.RepositoryURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *Discussion) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (d *Discussion) GetTitle() string {
	if d == nil || d.Title == nil {
		return ""
	}
	return *d.Title
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *Discussion) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetUser returns the User field.
func (d *Discussion) GetUser() *User {
	if d == nil {
		return nil
	}
	return d.User
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetDescription() string {
	if d == nil || d.Description == nil {
		return ""
	}
	return *d.Description
}

// GetEmoji returns the Emoji field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetEmoji() string {
	if d == nil || d.Emoji == nil {
		return ""
	}
	return *d.Emoji
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetID() int64 {
	if d == nil || d.ID == nil {
		return 0
	}
	return *d.ID
}

// GetIsAnswerable returns the IsAnswerable field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetIsAnswerable() bool {
	if d == nil || d.IsAnswerable == nil {
		return false
	}
	return *d.IsAnswerable
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetName() string {
	if d == nil || d.Name == nil {
		return ""
	}
	return *d.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetRepositoryID returns the RepositoryID field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetRepositoryID() int64 {
	if d == nil || d.RepositoryID == nil {
		return 0
	}
	return *d.RepositoryID
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetSlug() string {
	if d == nil || d.Slug == nil {
		return ""
	}
	return *d.Slug
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DiscussionCategory) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetAuthor returns the Author field.
func (d *DiscussionComment) GetAuthor() *User {
	if d == nil {
		return nil
	}
	return d.Author
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetBody() string {
	if d == nil || d.Body == nil {
		return ""
	}
	return *d.Body
}

// GetBodyHTML returns the BodyHTML field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetBodyHTML() string {
	if d == nil || d.BodyHTML == nil {
		return ""
	}
	return *d.BodyHTML
}

// GetBodyVersion returns the BodyVersion field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetBodyVersion() string {
	if d == nil || d.BodyVersion == nil {
		return ""
	}
	return *d.BodyVersion
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetCreatedAt() Timestamp {
	if d == nil || d.CreatedAt == nil {
		return Timestamp{}
	}
	return *d.CreatedAt
}

// GetDiscussionURL returns the DiscussionURL field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetDiscussionURL() string {
	if d == nil || d.DiscussionURL == nil {
		return ""
	}
	return *d.DiscussionURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetHTMLURL() string {
	if d == nil || d.HTMLURL == nil {
		return ""
	}
	return *d.HTMLURL
}

// GetLastEditedAt returns the LastEditedAt field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetLastEditedAt() Timestamp {
	if d == nil || d.LastEditedAt == nil {
		return Timestamp{}
	}
	return *d.LastEditedAt
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetNodeID() string {
	if d == nil || d.NodeID == nil {
		return ""
	}
	return *d.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetNumber() int {
	if d == nil || d.Number == nil {
		return 0
	}
	return *d.Number
}

// GetReactions returns the Reactions field.
func (d *DiscussionComment) GetReactions() *Reactions {
	if d == nil {
		return nil
	}
	return d.Reactions
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetUpdatedAt() Timestamp {
	if d == nil || d.UpdatedAt == nil {
		return Timestamp{}
	}
	return *d.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (d *DiscussionComment) GetURL() string {
	if d == nil || d.URL == nil {
		return ""
	}
	return *d.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DiscussionCommentEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetComment returns the Comment field.
func (d *DiscussionCommentEvent) GetComment() *CommentDiscussion {
	if d == nil {
		return nil
	}
	return d.Comment
}

// GetDiscussion returns the Discussion field.
func (d *DiscussionCommentEvent) GetDiscussion() *Discussion {
	if d == nil {
		return nil
	}
	return d.Discussion
}

// GetInstallation returns the Installation field.
func (d *DiscussionCommentEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrg returns the Org field.
func (d *DiscussionCommentEvent) GetOrg() *Organization {
	if d == nil {
		return nil
	}
	return d.Org
}

// GetRepo returns the Repo field.
func (d *DiscussionCommentEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DiscussionCommentEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (d *DiscussionEvent) GetAction() string {
	if d == nil || d.Action == nil {
		return ""
	}
	return *d.Action
}

// GetDiscussion returns the Discussion field.
func (d *DiscussionEvent) GetDiscussion() *Discussion {
	if d == nil {
		return nil
	}
	return d.Discussion
}

// GetInstallation returns the Installation field.
func (d *DiscussionEvent) GetInstallation() *Installation {
	if d == nil {
		return nil
	}
	return d.Installation
}

// GetOrg returns the Org field.
func (d *DiscussionEvent) GetOrg() *Organization {
	if d == nil {
		return nil
	}
	return d.Org
}

// GetRepo returns the Repo field.
func (d *DiscussionEvent) GetRepo() *Repository {
	if d == nil {
		return nil
	}
	return d.Repo
}

// GetSender returns the Sender field.
func (d *DiscussionEvent) GetSender() *User {
	if d == nil {
		return nil
	}
	return d.Sender
}

// GetApps returns the Apps field if it's non-nil, zero value otherwise.
func (d *DismissalRestrictionsRequest) GetApps() []string {
	if d == nil || d.Apps == nil {
		return nil
	}
	return *d.Apps
}

// GetTeams returns the Teams field if it's non-nil, zero value otherwise.
func (d *DismissalRestrictionsRequest) GetTeams() []string {
	if d == nil || d.Teams == nil {
		return nil
	}
	return *d.Teams
}

// GetUsers returns the Users field if it's non-nil, zero value otherwise.
func (d *DismissalRestrictionsRequest) GetUsers() []string {
	if d == nil || d.Users == nil {
		return nil
	}
	return *d.Users
}

// GetDismissalCommitID returns the DismissalCommitID field if it's non-nil, zero value otherwise.
func (d *DismissedReview) GetDismissalCommitID() string {
	if d == nil || d.DismissalCommitID == nil {
		return ""
	}
	return *d.DismissalCommitID
}

// GetDismissalMessage returns the DismissalMessage field if it's non-nil, zero value otherwise.
func (d *DismissedReview) GetDismissalMessage() string {
	if d == nil || d.DismissalMessage == nil {
		return ""
	}
	return *d.DismissalMessage
}

// GetReviewID returns the ReviewID field if it's non-nil, zero value otherwise.
func (d *DismissedReview) GetReviewID() int64 {
	if d == nil || d.ReviewID == nil {
		return 0
	}
	return *d.ReviewID
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (d *DismissedReview) GetState() string {
	if d == nil || d.State == nil {
		return ""
	}
	return *d.State
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (d *DismissStaleReviewsOnPushChanges) GetFrom() bool {
	if d == nil || d.From == nil {
		return false
	}
	return *d.From
}

// GetClientPayload returns the ClientPayload field if it's non-nil, zero value otherwise.
func (d *DispatchRequestOptions) GetClientPayload() json.RawMessage {
	if d == nil || d.ClientPayload == nil {
		return json.RawMessage{}
	}
	return *d.ClientPayload
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetBody() string {
	if d == nil || d.Body == nil {
		return ""
	}
	return *d.Body
}

// GetLine returns the Line field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetLine() int {
	if d == nil || d.Line == nil {
		return 0
	}
	return *d.Line
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetPath() string {
	if d == nil || d.Path == nil {
		return ""
	}
	return *d.Path
}

// GetPosition returns the Position field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetPosition() int {
	if d == nil || d.Position == nil {
		return 0
	}
	return *d.Position
}

// GetSide returns the Side field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetSide() string {
	if d == nil || d.Side == nil {
		return ""
	}
	return *d.Side
}

// GetStartLine returns the StartLine field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetStartLine() int {
	if d == nil || d.StartLine == nil {
		return 0
	}
	return *d.StartLine
}

// GetStartSide returns the StartSide field if it's non-nil, zero value otherwise.
func (d *DraftReviewComment) GetStartSide() string {
	if d == nil || d.StartSide == nil {
		return ""
	}
	return *d.StartSide
}

// GetRef returns the Ref field.
func (e *EditBase) GetRef() *EditRef {
	if e == nil {
		return nil
	}
	return e.Ref
}

// GetSHA returns the SHA field.
func (e *EditBase) GetSHA() *EditSHA {
	if e == nil {
		return nil
	}
	return e.SHA
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (e *EditBody) GetFrom() string {
	if e == nil || e.From == nil {
		return ""
	}
	return *e.From
}

// GetBase returns the Base field.
func (e *EditChange) GetBase() *EditBase {
	if e == nil {
		return nil
	}
	return e.Base
}

// GetBody returns the Body field.
func (e *EditChange) GetBody() *EditBody {
	if e == nil {
		return nil
	}
	return e.Body
}

// GetDefaultBranch returns the DefaultBranch field.
func (e *EditChange) GetDefaultBranch() *EditDefaultBranch {
	if e == nil {
		return nil
	}
	return e.DefaultBranch
}

// GetOwner returns the Owner field.
func (e *EditChange) GetOwner() *EditOwner {
	if e == nil {
		return nil
	}
	return e.Owner
}

// GetRepo returns the Repo field.
func (e *EditChange) GetRepo() *EditRepo {
	if e == nil {
		return nil
	}
	return e.Repo
}

// GetTitle returns the Title field.
func (e *EditChange) GetTitle() *EditTitle {
	if e == nil {
		return nil
	}
	return e.Title
}

// GetTopics returns the Topics field.
func (e *EditChange) GetTopics() *EditTopics {
	if e == nil {
		return nil
	}
	return e.Topics
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (e *EditDefaultBranch) GetFrom() string {
	if e == nil || e.From == nil {
		return ""
	}
	return *e.From
}

// GetOwnerInfo returns the OwnerInfo field.
func (e *EditOwner) GetOwnerInfo() *OwnerInfo {
	if e == nil {
		return nil
	}
	return e.OwnerInfo
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (e *EditRef) GetFrom() string {
	if e == nil || e.From == nil {
		return ""
	}
	return *e.From
}

// GetName returns the Name field.
func (e *EditRepo) GetName() *RepoName {
	if e == nil {
		return nil
	}
	return e.Name
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (e *EditSHA) GetFrom() string {
	if e == nil || e.From == nil {
		return ""
	}
	return *e.From
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (e *EditTitle) GetFrom() string {
	if e == nil || e.From == nil {
		return ""
	}
	return *e.From
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetAvatarURL() string {
	if e == nil || e.AvatarURL == nil {
		return ""
	}
	return *e.AvatarURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetCreatedAt() Timestamp {
	if e == nil || e.CreatedAt == nil {
		return Timestamp{}
	}
	return *e.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetDescription() string {
	if e == nil || e.Description == nil {
		return ""
	}
	return *e.Description
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetHTMLURL() string {
	if e == nil || e.HTMLURL == nil {
		return ""
	}
	return *e.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetID() int {
	if e == nil || e.ID == nil {
		return 0
	}
	return *e.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetName() string {
	if e == nil || e.Name == nil {
		return ""
	}
	return *e.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetNodeID() string {
	if e == nil || e.NodeID == nil {
		return ""
	}
	return *e.NodeID
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetSlug() string {
	if e == nil || e.Slug == nil {
		return ""
	}
	return *e.Slug
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetUpdatedAt() Timestamp {
	if e == nil || e.UpdatedAt == nil {
		return Timestamp{}
	}
	return *e.UpdatedAt
}

// GetWebsiteURL returns the WebsiteURL field if it's non-nil, zero value otherwise.
func (e *Enterprise) GetWebsiteURL() string {
	if e == nil || e.WebsiteURL == nil {
		return ""
	}
	return *e.WebsiteURL
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetAllowsPublicRepositories() bool {
	if e == nil || e.AllowsPublicRepositories == nil {
		return false
	}
	return *e.AllowsPublicRepositories
}

// GetDefault returns the Default field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetDefault() bool {
	if e == nil || e.Default == nil {
		return false
	}
	return *e.Default
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetID() int64 {
	if e == nil || e.ID == nil {
		return 0
	}
	return *e.ID
}

// GetInherited returns the Inherited field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetInherited() bool {
	if e == nil || e.Inherited == nil {
		return false
	}
	return *e.Inherited
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetName() string {
	if e == nil || e.Name == nil {
		return ""
	}
	return *e.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetRestrictedToWorkflows() bool {
	if e == nil || e.RestrictedToWorkflows == nil {
		return false
	}
	return *e.RestrictedToWorkflows
}

// GetRunnersURL returns the RunnersURL field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetRunnersURL() string {
	if e == nil || e.RunnersURL == nil {
		return ""
	}
	return *e.RunnersURL
}

// GetSelectedOrganizationsURL returns the SelectedOrganizationsURL field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetSelectedOrganizationsURL() string {
	if e == nil || e.SelectedOrganizationsURL == nil {
		return ""
	}
	return *e.SelectedOrganizationsURL
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetVisibility() string {
	if e == nil || e.Visibility == nil {
		return ""
	}
	return *e.Visibility
}

// GetWorkflowRestrictionsReadOnly returns the WorkflowRestrictionsReadOnly field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroup) GetWorkflowRestrictionsReadOnly() bool {
	if e == nil || e.WorkflowRestrictionsReadOnly == nil {
		return false
	}
	return *e.WorkflowRestrictionsReadOnly
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (e *EnterpriseRunnerGroups) GetTotalCount() int {
	if e == nil || e.TotalCount == nil {
		return 0
	}
	return *e.TotalCount
}

// GetAdvancedSecurityEnabledForNewRepositories returns the AdvancedSecurityEnabledForNewRepositories field if it's non-nil, zero value otherwise.
func (e *EnterpriseSecurityAnalysisSettings) GetAdvancedSecurityEnabledForNewRepositories() bool {
	if e == nil || e.AdvancedSecurityEnabledForNewRepositories == nil {
		return false
	}
	return *e.AdvancedSecurityEnabledForNewRepositories
}

// GetSecretScanningEnabledForNewRepositories returns the SecretScanningEnabledForNewRepositories field if it's non-nil, zero value otherwise.
func (e *EnterpriseSecurityAnalysisSettings) GetSecretScanningEnabledForNewRepositories() bool {
	if e == nil || e.SecretScanningEnabledForNewRepositories == nil {
		return false
	}
	return *e.SecretScanningEnabledForNewRepositories
}

// GetSecretScanningPushProtectionCustomLink returns the SecretScanningPushProtectionCustomLink field if it's non-nil, zero value otherwise.
func (e *EnterpriseSecurityAnalysisSettings) GetSecretScanningPushProtectionCustomLink() string {
	if e == nil || e.SecretScanningPushProtectionCustomLink == nil {
		return ""
	}
	return *e.SecretScanningPushProtectionCustomLink
}

// GetSecretScanningPushProtectionEnabledForNewRepositories returns the SecretScanningPushProtectionEnabledForNewRepositories field if it's non-nil, zero value otherwise.
func (e *EnterpriseSecurityAnalysisSettings) GetSecretScanningPushProtectionEnabledForNewRepositories() bool {
	if e == nil || e.SecretScanningPushProtectionEnabledForNewRepositories == nil {
		return false
	}
	return *e.SecretScanningPushProtectionEnabledForNewRepositories
}

// GetSecretScanningValidityChecksEnabled returns the SecretScanningValidityChecksEnabled field if it's non-nil, zero value otherwise.
func (e *EnterpriseSecurityAnalysisSettings) GetSecretScanningValidityChecksEnabled() bool {
	if e == nil || e.SecretScanningValidityChecksEnabled == nil {
		return false
	}
	return *e.SecretScanningValidityChecksEnabled
}

// GetCanAdminsBypass returns the CanAdminsBypass field if it's non-nil, zero value otherwise.
func (e *Environment) GetCanAdminsBypass() bool {
	if e == nil || e.CanAdminsBypass == nil {
		return false
	}
	return *e.CanAdminsBypass
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (e *Environment) GetCreatedAt() Timestamp {
	if e == nil || e.CreatedAt == nil {
		return Timestamp{}
	}
	return *e.CreatedAt
}

// GetDeploymentBranchPolicy returns the DeploymentBranchPolicy field.
func (e *Environment) GetDeploymentBranchPolicy() *BranchPolicy {
	if e == nil {
		return nil
	}
	return e.DeploymentBranchPolicy
}

// GetEnvironmentName returns the EnvironmentName field if it's non-nil, zero value otherwise.
func (e *Environment) GetEnvironmentName() string {
	if e == nil || e.EnvironmentName == nil {
		return ""
	}
	return *e.EnvironmentName
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (e *Environment) GetHTMLURL() string {
	if e == nil || e.HTMLURL == nil {
		return ""
	}
	return *e.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (e *Environment) GetID() int64 {
	if e == nil || e.ID == nil {
		return 0
	}
	return *e.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (e *Environment) GetName() string {
	if e == nil || e.Name == nil {
		return ""
	}
	return *e.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (e *Environment) GetNodeID() string {
	if e == nil || e.NodeID == nil {
		return ""
	}
	return *e.NodeID
}

// GetOwner returns the Owner field if it's non-nil, zero value otherwise.
func (e *Environment) GetOwner() string {
	if e == nil || e.Owner == nil {
		return ""
	}
	return *e.Owner
}

// GetRepo returns the Repo field if it's non-nil, zero value otherwise.
func (e *Environment) GetRepo() string {
	if e == nil || e.Repo == nil {
		return ""
	}
	return *e.Repo
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (e *Environment) GetUpdatedAt() Timestamp {
	if e == nil || e.UpdatedAt == nil {
		return Timestamp{}
	}
	return *e.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (e *Environment) GetURL() string {
	if e == nil || e.URL == nil {
		return ""
	}
	return *e.URL
}

// GetWaitTimer returns the WaitTimer field if it's non-nil, zero value otherwise.
func (e *Environment) GetWaitTimer() int {
	if e == nil || e.WaitTimer == nil {
		return 0
	}
	return *e.WaitTimer
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (e *EnvResponse) GetTotalCount() int {
	if e == nil || e.TotalCount == nil {
		return 0
	}
	return *e.TotalCount
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (e *EnvReviewers) GetID() int64 {
	if e == nil || e.ID == nil {
		return 0
	}
	return *e.ID
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (e *EnvReviewers) GetType() string {
	if e == nil || e.Type == nil {
		return ""
	}
	return *e.Type
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (e *ErrorBlock) GetCreatedAt() Timestamp {
	if e == nil || e.CreatedAt == nil {
		return Timestamp{}
	}
	return *e.CreatedAt
}

// GetBlock returns the Block field.
func (e *ErrorResponse) GetBlock() *ErrorBlock {
	if e == nil {
		return nil
	}
	return e.Block
}

// GetActor returns the Actor field.
func (e *Event) GetActor() *User {
	if e == nil {
		return nil
	}
	return e.Actor
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (e *Event) GetCreatedAt() Timestamp {
	if e == nil || e.CreatedAt == nil {
		return Timestamp{}
	}
	return *e.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (e *Event) GetID() string {
	if e == nil || e.ID == nil {
		return ""
	}
	return *e.ID
}

// GetOrg returns the Org field.
func (e *Event) GetOrg() *Organization {
	if e == nil {
		return nil
	}
	return e.Org
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (e *Event) GetPublic() bool {
	if e == nil || e.Public == nil {
		return false
	}
	return *e.Public
}

// GetRawPayload returns the RawPayload field if it's non-nil, zero value otherwise.
func (e *Event) GetRawPayload() json.RawMessage {
	if e == nil || e.RawPayload == nil {
		return json.RawMessage{}
	}
	return *e.RawPayload
}

// GetRepo returns the Repo field.
func (e *Event) GetRepo() *Repository {
	if e == nil {
		return nil
	}
	return e.Repo
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (e *Event) GetType() string {
	if e == nil || e.Type == nil {
		return ""
	}
	return *e.Type
}

// GetGroupID returns the GroupID field if it's non-nil, zero value otherwise.
func (e *ExternalGroup) GetGroupID() int64 {
	if e == nil || e.GroupID == nil {
		return 0
	}
	return *e.GroupID
}

// GetGroupName returns the GroupName field if it's non-nil, zero value otherwise.
func (e *ExternalGroup) GetGroupName() string {
	if e == nil || e.GroupName == nil {
		return ""
	}
	return *e.GroupName
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (e *ExternalGroup) GetUpdatedAt() Timestamp {
	if e == nil || e.UpdatedAt == nil {
		return Timestamp{}
	}
	return *e.UpdatedAt
}

// GetMemberEmail returns the MemberEmail field if it's non-nil, zero value otherwise.
func (e *ExternalGroupMember) GetMemberEmail() string {
	if e == nil || e.MemberEmail == nil {
		return ""
	}
	return *e.MemberEmail
}

// GetMemberID returns the MemberID field if it's non-nil, zero value otherwise.
func (e *ExternalGroupMember) GetMemberID() int64 {
	if e == nil || e.MemberID == nil {
		return 0
	}
	return *e.MemberID
}

// GetMemberLogin returns the MemberLogin field if it's non-nil, zero value otherwise.
func (e *ExternalGroupMember) GetMemberLogin() string {
	if e == nil || e.MemberLogin == nil {
		return ""
	}
	return *e.MemberLogin
}

// GetMemberName returns the MemberName field if it's non-nil, zero value otherwise.
func (e *ExternalGroupMember) GetMemberName() string {
	if e == nil || e.MemberName == nil {
		return ""
	}
	return *e.MemberName
}

// GetTeamID returns the TeamID field if it's non-nil, zero value otherwise.
func (e *ExternalGroupTeam) GetTeamID() int64 {
	if e == nil || e.TeamID == nil {
		return 0
	}
	return *e.TeamID
}

// GetTeamName returns the TeamName field if it's non-nil, zero value otherwise.
func (e *ExternalGroupTeam) GetTeamName() string {
	if e == nil || e.TeamName == nil {
		return ""
	}
	return *e.TeamName
}

// GetHRef returns the HRef field if it's non-nil, zero value otherwise.
func (f *FeedLink) GetHRef() string {
	if f == nil || f.HRef == nil {
		return ""
	}
	return *f.HRef
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (f *FeedLink) GetType() string {
	if f == nil || f.Type == nil {
		return ""
	}
	return *f.Type
}

// GetCurrentUser returns the CurrentUser field.
func (f *FeedLinks) GetCurrentUser() *FeedLink {
	if f == nil {
		return nil
	}
	return f.CurrentUser
}

// GetCurrentUserActor returns the CurrentUserActor field.
func (f *FeedLinks) GetCurrentUserActor() *FeedLink {
	if f == nil {
		return nil
	}
	return f.CurrentUserActor
}

// GetCurrentUserOrganization returns the CurrentUserOrganization field.
func (f *FeedLinks) GetCurrentUserOrganization() *FeedLink {
	if f == nil {
		return nil
	}
	return f.CurrentUserOrganization
}

// GetCurrentUserPublic returns the CurrentUserPublic field.
func (f *FeedLinks) GetCurrentUserPublic() *FeedLink {
	if f == nil {
		return nil
	}
	return f.CurrentUserPublic
}

// GetTimeline returns the Timeline field.
func (f *FeedLinks) GetTimeline() *FeedLink {
	if f == nil {
		return nil
	}
	return f.Timeline
}

// GetUser returns the User field.
func (f *FeedLinks) GetUser() *FeedLink {
	if f == nil {
		return nil
	}
	return f.User
}

// GetCurrentUserActorURL returns the CurrentUserActorURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetCurrentUserActorURL() string {
	if f == nil || f.CurrentUserActorURL == nil {
		return ""
	}
	return *f.CurrentUserActorURL
}

// GetCurrentUserOrganizationURL returns the CurrentUserOrganizationURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetCurrentUserOrganizationURL() string {
	if f == nil || f.CurrentUserOrganizationURL == nil {
		return ""
	}
	return *f.CurrentUserOrganizationURL
}

// GetCurrentUserPublicURL returns the CurrentUserPublicURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetCurrentUserPublicURL() string {
	if f == nil || f.CurrentUserPublicURL == nil {
		return ""
	}
	return *f.CurrentUserPublicURL
}

// GetCurrentUserURL returns the CurrentUserURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetCurrentUserURL() string {
	if f == nil || f.CurrentUserURL == nil {
		return ""
	}
	return *f.CurrentUserURL
}

// GetLinks returns the Links field.
func (f *Feeds) GetLinks() *FeedLinks {
	if f == nil {
		return nil
	}
	return f.Links
}

// GetTimelineURL returns the TimelineURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetTimelineURL() string {
	if f == nil || f.TimelineURL == nil {
		return ""
	}
	return *f.TimelineURL
}

// GetUserURL returns the UserURL field if it's non-nil, zero value otherwise.
func (f *Feeds) GetUserURL() string {
	if f == nil || f.UserURL == nil {
		return ""
	}
	return *f.UserURL
}

// GetIdentifier returns the Identifier field if it's non-nil, zero value otherwise.
func (f *FirstPatchedVersion) GetIdentifier() string {
	if f == nil || f.Identifier == nil {
		return ""
	}
	return *f.Identifier
}

// GetForkee returns the Forkee field.
func (f *ForkEvent) GetForkee() *Repository {
	if f == nil {
		return nil
	}
	return f.Forkee
}

// GetInstallation returns the Installation field.
func (f *ForkEvent) GetInstallation() *Installation {
	if f == nil {
		return nil
	}
	return f.Installation
}

// GetRepo returns the Repo field.
func (f *ForkEvent) GetRepo() *Repository {
	if f == nil {
		return nil
	}
	return f.Repo
}

// GetSender returns the Sender field.
func (f *ForkEvent) GetSender() *User {
	if f == nil {
		return nil
	}
	return f.Sender
}

// GetWorkFolder returns the WorkFolder field if it's non-nil, zero value otherwise.
func (g *GenerateJITConfigRequest) GetWorkFolder() string {
	if g == nil || g.WorkFolder == nil {
		return ""
	}
	return *g.WorkFolder
}

// GetPreviousTagName returns the PreviousTagName field if it's non-nil, zero value otherwise.
func (g *GenerateNotesOptions) GetPreviousTagName() string {
	if g == nil || g.PreviousTagName == nil {
		return ""
	}
	return *g.PreviousTagName
}

// GetTargetCommitish returns the TargetCommitish field if it's non-nil, zero value otherwise.
func (g *GenerateNotesOptions) GetTargetCommitish() string {
	if g == nil || g.TargetCommitish == nil {
		return ""
	}
	return *g.TargetCommitish
}

// GetInclude returns the Include field if it's non-nil, zero value otherwise.
func (g *GetAuditLogOptions) GetInclude() string {
	if g == nil || g.Include == nil {
		return ""
	}
	return *g.Include
}

// GetOrder returns the Order field if it's non-nil, zero value otherwise.
func (g *GetAuditLogOptions) GetOrder() string {
	if g == nil || g.Order == nil {
		return ""
	}
	return *g.Order
}

// GetPhrase returns the Phrase field if it's non-nil, zero value otherwise.
func (g *GetAuditLogOptions) GetPhrase() string {
	if g == nil || g.Phrase == nil {
		return ""
	}
	return *g.Phrase
}

// GetComments returns the Comments field if it's non-nil, zero value otherwise.
func (g *Gist) GetComments() int {
	if g == nil || g.Comments == nil {
		return 0
	}
	return *g.Comments
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (g *Gist) GetCreatedAt() Timestamp {
	if g == nil || g.CreatedAt == nil {
		return Timestamp{}
	}
	return *g.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (g *Gist) GetDescription() string {
	if g == nil || g.Description == nil {
		return ""
	}
	return *g.Description
}

// GetFiles returns the Files map if it's non-nil, an empty map otherwise.
func (g *Gist) GetFiles() map[GistFilename]GistFile {
	if g == nil || g.Files == nil {
		return map[GistFilename]GistFile{}
	}
	return g.Files
}

// GetGitPullURL returns the GitPullURL field if it's non-nil, zero value otherwise.
func (g *Gist) GetGitPullURL() string {
	if g == nil || g.GitPullURL == nil {
		return ""
	}
	return *g.GitPullURL
}

// GetGitPushURL returns the GitPushURL field if it's non-nil, zero value otherwise.
func (g *Gist) GetGitPushURL() string {
	if g == nil || g.GitPushURL == nil {
		return ""
	}
	return *g.GitPushURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (g *Gist) GetHTMLURL() string {
	if g == nil || g.HTMLURL == nil {
		return ""
	}
	return *g.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *Gist) GetID() string {
	if g == nil || g.ID == nil {
		return ""
	}
	return *g.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (g *Gist) GetNodeID() string {
	if g == nil || g.NodeID == nil {
		return ""
	}
	return *g.NodeID
}

// GetOwner returns the Owner field.
func (g *Gist) GetOwner() *User {
	if g == nil {
		return nil
	}
	return g.Owner
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (g *Gist) GetPublic() bool {
	if g == nil || g.Public == nil {
		return false
	}
	return *g.Public
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (g *Gist) GetUpdatedAt() Timestamp {
	if g == nil || g.UpdatedAt == nil {
		return Timestamp{}
	}
	return *g.UpdatedAt
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (g *GistComment) GetBody() string {
	if g == nil || g.Body == nil {
		return ""
	}
	return *g.Body
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (g *GistComment) GetCreatedAt() Timestamp {
	if g == nil || g.CreatedAt == nil {
		return Timestamp{}
	}
	return *g.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *GistComment) GetID() int64 {
	if g == nil || g.ID == nil {
		return 0
	}
	return *g.ID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (g *GistComment) GetURL() string {
	if g == nil || g.URL == nil {
		return ""
	}
	return *g.URL
}

// GetUser returns the User field.
func (g *GistComment) GetUser() *User {
	if g == nil {
		return nil
	}
	return g.User
}

// GetChangeStatus returns the ChangeStatus field.
func (g *GistCommit) GetChangeStatus() *CommitStats {
	if g == nil {
		return nil
	}
	return g.ChangeStatus
}

// GetCommittedAt returns the CommittedAt field if it's non-nil, zero value otherwise.
func (g *GistCommit) GetCommittedAt() Timestamp {
	if g == nil || g.CommittedAt == nil {
		return Timestamp{}
	}
	return *g.CommittedAt
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (g *GistCommit) GetNodeID() string {
	if g == nil || g.NodeID == nil {
		return ""
	}
	return *g.NodeID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (g *GistCommit) GetURL() string {
	if g == nil || g.URL == nil {
		return ""
	}
	return *g.URL
}

// GetUser returns the User field.
func (g *GistCommit) GetUser() *User {
	if g == nil {
		return nil
	}
	return g.User
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (g *GistCommit) GetVersion() string {
	if g == nil || g.Version == nil {
		return ""
	}
	return *g.Version
}

// GetContent returns the Content field if it's non-nil, zero value otherwise.
func (g *GistFile) GetContent() string {
	if g == nil || g.Content == nil {
		return ""
	}
	return *g.Content
}

// GetFilename returns the Filename field if it's non-nil, zero value otherwise.
func (g *GistFile) GetFilename() string {
	if g == nil || g.Filename == nil {
		return ""
	}
	return *g.Filename
}

// GetLanguage returns the Language field if it's non-nil, zero value otherwise.
func (g *GistFile) GetLanguage() string {
	if g == nil || g.Language == nil {
		return ""
	}
	return *g.Language
}

// GetRawURL returns the RawURL field if it's non-nil, zero value otherwise.
func (g *GistFile) GetRawURL() string {
	if g == nil || g.RawURL == nil {
		return ""
	}
	return *g.RawURL
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (g *GistFile) GetSize() int {
	if g == nil || g.Size == nil {
		return 0
	}
	return *g.Size
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (g *GistFile) GetType() string {
	if g == nil || g.Type == nil {
		return ""
	}
	return *g.Type
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (g *GistFork) GetCreatedAt() Timestamp {
	if g == nil || g.CreatedAt == nil {
		return Timestamp{}
	}
	return *g.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *GistFork) GetID() string {
	if g == nil || g.ID == nil {
		return ""
	}
	return *g.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (g *GistFork) GetNodeID() string {
	if g == nil || g.NodeID == nil {
		return ""
	}
	return *g.NodeID
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (g *GistFork) GetUpdatedAt() Timestamp {
	if g == nil || g.UpdatedAt == nil {
		return Timestamp{}
	}
	return *g.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (g *GistFork) GetURL() string {
	if g == nil || g.URL == nil {
		return ""
	}
	return *g.URL
}

// GetUser returns the User field.
func (g *GistFork) GetUser() *User {
	if g == nil {
		return nil
	}
	return g.User
}

// GetPrivateGists returns the PrivateGists field if it's non-nil, zero value otherwise.
func (g *GistStats) GetPrivateGists() int {
	if g == nil || g.PrivateGists == nil {
		return 0
	}
	return *g.PrivateGists
}

// GetPublicGists returns the PublicGists field if it's non-nil, zero value otherwise.
func (g *GistStats) GetPublicGists() int {
	if g == nil || g.PublicGists == nil {
		return 0
	}
	return *g.PublicGists
}

// GetTotalGists returns the TotalGists field if it's non-nil, zero value otherwise.
func (g *GistStats) GetTotalGists() int {
	if g == nil || g.TotalGists == nil {
		return 0
	}
	return *g.TotalGists
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (g *GitHubAppAuthorizationEvent) GetAction() string {
	if g == nil || g.Action == nil {
		return ""
	}
	return *g.Action
}

// GetInstallation returns the Installation field.
func (g *GitHubAppAuthorizationEvent) GetInstallation() *Installation {
	if g == nil {
		return nil
	}
	return g.Installation
}

// GetSender returns the Sender field.
func (g *GitHubAppAuthorizationEvent) GetSender() *User {
	if g == nil {
		return nil
	}
	return g.Sender
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (g *Gitignore) GetName() string {
	if g == nil || g.Name == nil {
		return ""
	}
	return *g.Name
}

// GetSource returns the Source field if it's non-nil, zero value otherwise.
func (g *Gitignore) GetSource() string {
	if g == nil || g.Source == nil {
		return ""
	}
	return *g.Source
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (g *GitObject) GetSHA() string {
	if g == nil || g.SHA == nil {
		return ""
	}
	return *g.SHA
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (g *GitObject) GetType() string {
	if g == nil || g.Type == nil {
		return ""
	}
	return *g.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (g *GitObject) GetURL() string {
	if g == nil || g.URL == nil {
		return ""
	}
	return *g.URL
}

// GetGithubReviewedAt returns the GithubReviewedAt field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetGithubReviewedAt() Timestamp {
	if g == nil || g.GithubReviewedAt == nil {
		return Timestamp{}
	}
	return *g.GithubReviewedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetID() int64 {
	if g == nil || g.ID == nil {
		return 0
	}
	return *g.ID
}

// GetNVDPublishedAt returns the NVDPublishedAt field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetNVDPublishedAt() Timestamp {
	if g == nil || g.NVDPublishedAt == nil {
		return Timestamp{}
	}
	return *g.NVDPublishedAt
}

// GetRepositoryAdvisoryURL returns the RepositoryAdvisoryURL field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetRepositoryAdvisoryURL() string {
	if g == nil || g.RepositoryAdvisoryURL == nil {
		return ""
	}
	return *g.RepositoryAdvisoryURL
}

// GetSourceCodeLocation returns the SourceCodeLocation field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetSourceCodeLocation() string {
	if g == nil || g.SourceCodeLocation == nil {
		return ""
	}
	return *g.SourceCodeLocation
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityAdvisory) GetType() string {
	if g == nil || g.Type == nil {
		return ""
	}
	return *g.Type
}

// GetFirstPatchedVersion returns the FirstPatchedVersion field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityVulnerability) GetFirstPatchedVersion() string {
	if g == nil || g.FirstPatchedVersion == nil {
		return ""
	}
	return *g.FirstPatchedVersion
}

// GetPackage returns the Package field.
func (g *GlobalSecurityVulnerability) GetPackage() *VulnerabilityPackage {
	if g == nil {
		return nil
	}
	return g.Package
}

// GetVulnerableVersionRange returns the VulnerableVersionRange field if it's non-nil, zero value otherwise.
func (g *GlobalSecurityVulnerability) GetVulnerableVersionRange() string {
	if g == nil || g.VulnerableVersionRange == nil {
		return ""
	}
	return *g.VulnerableVersionRange
}

// GetInstallation returns the Installation field.
func (g *GollumEvent) GetInstallation() *Installation {
	if g == nil {
		return nil
	}
	return g.Installation
}

// GetOrg returns the Org field.
func (g *GollumEvent) GetOrg() *Organization {
	if g == nil {
		return nil
	}
	return g.Org
}

// GetRepo returns the Repo field.
func (g *GollumEvent) GetRepo() *Repository {
	if g == nil {
		return nil
	}
	return g.Repo
}

// GetSender returns the Sender field.
func (g *GollumEvent) GetSender() *User {
	if g == nil {
		return nil
	}
	return g.Sender
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (g *GPGEmail) GetEmail() string {
	if g == nil || g.Email == nil {
		return ""
	}
	return *g.Email
}

// GetVerified returns the Verified field if it's non-nil, zero value otherwise.
func (g *GPGEmail) GetVerified() bool {
	if g == nil || g.Verified == nil {
		return false
	}
	return *g.Verified
}

// GetCanCertify returns the CanCertify field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetCanCertify() bool {
	if g == nil || g.CanCertify == nil {
		return false
	}
	return *g.CanCertify
}

// GetCanEncryptComms returns the CanEncryptComms field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetCanEncryptComms() bool {
	if g == nil || g.CanEncryptComms == nil {
		return false
	}
	return *g.CanEncryptComms
}

// GetCanEncryptStorage returns the CanEncryptStorage field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetCanEncryptStorage() bool {
	if g == nil || g.CanEncryptStorage == nil {
		return false
	}
	return *g.CanEncryptStorage
}

// GetCanSign returns the CanSign field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetCanSign() bool {
	if g == nil || g.CanSign == nil {
		return false
	}
	return *g.CanSign
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetCreatedAt() Timestamp {
	if g == nil || g.CreatedAt == nil {
		return Timestamp{}
	}
	return *g.CreatedAt
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetExpiresAt() Timestamp {
	if g == nil || g.ExpiresAt == nil {
		return Timestamp{}
	}
	return *g.ExpiresAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetID() int64 {
	if g == nil || g.ID == nil {
		return 0
	}
	return *g.ID
}

// GetKeyID returns the KeyID field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetKeyID() string {
	if g == nil || g.KeyID == nil {
		return ""
	}
	return *g.KeyID
}

// GetPrimaryKeyID returns the PrimaryKeyID field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetPrimaryKeyID() int64 {
	if g == nil || g.PrimaryKeyID == nil {
		return 0
	}
	return *g.PrimaryKeyID
}

// GetPublicKey returns the PublicKey field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetPublicKey() string {
	if g == nil || g.PublicKey == nil {
		return ""
	}
	return *g.PublicKey
}

// GetRawKey returns the RawKey field if it's non-nil, zero value otherwise.
func (g *GPGKey) GetRawKey() string {
	if g == nil || g.RawKey == nil {
		return ""
	}
	return *g.RawKey
}

// GetApp returns the App field.
func (g *Grant) GetApp() *AuthorizationApp {
	if g == nil {
		return nil
	}
	return g.App
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (g *Grant) GetCreatedAt() Timestamp {
	if g == nil || g.CreatedAt == nil {
		return Timestamp{}
	}
	return *g.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (g *Grant) GetID() int64 {
	if g == nil || g.ID == nil {
		return 0
	}
	return *g.ID
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (g *Grant) GetUpdatedAt() Timestamp {
	if g == nil || g.UpdatedAt == nil {
		return Timestamp{}
	}
	return *g.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (g *Grant) GetURL() string {
	if g == nil || g.URL == nil {
		return ""
	}
	return *g.URL
}

// GetAuthor returns the Author field.
func (h *HeadCommit) GetAuthor() *CommitAuthor {
	if h == nil {
		return nil
	}
	return h.Author
}

// GetCommitter returns the Committer field.
func (h *HeadCommit) GetCommitter() *CommitAuthor {
	if h == nil {
		return nil
	}
	return h.Committer
}

// GetDistinct returns the Distinct field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetDistinct() bool {
	if h == nil || h.Distinct == nil {
		return false
	}
	return *h.Distinct
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetID() string {
	if h == nil || h.ID == nil {
		return ""
	}
	return *h.ID
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetMessage() string {
	if h == nil || h.Message == nil {
		return ""
	}
	return *h.Message
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetSHA() string {
	if h == nil || h.SHA == nil {
		return ""
	}
	return *h.SHA
}

// GetTimestamp returns the Timestamp field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetTimestamp() Timestamp {
	if h == nil || h.Timestamp == nil {
		return Timestamp{}
	}
	return *h.Timestamp
}

// GetTreeID returns the TreeID field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetTreeID() string {
	if h == nil || h.TreeID == nil {
		return ""
	}
	return *h.TreeID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (h *HeadCommit) GetURL() string {
	if h == nil || h.URL == nil {
		return ""
	}
	return *h.URL
}

// GetActive returns the Active field if it's non-nil, zero value otherwise.
func (h *Hook) GetActive() bool {
	if h == nil || h.Active == nil {
		return false
	}
	return *h.Active
}

// GetConfig returns the Config field.
func (h *Hook) GetConfig() *HookConfig {
	if h == nil {
		return nil
	}
	return h.Config
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (h *Hook) GetCreatedAt() Timestamp {
	if h == nil || h.CreatedAt == nil {
		return Timestamp{}
	}
	return *h.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (h *Hook) GetID() int64 {
	if h == nil || h.ID == nil {
		return 0
	}
	return *h.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (h *Hook) GetName() string {
	if h == nil || h.Name == nil {
		return ""
	}
	return *h.Name
}

// GetPingURL returns the PingURL field if it's non-nil, zero value otherwise.
func (h *Hook) GetPingURL() string {
	if h == nil || h.PingURL == nil {
		return ""
	}
	return *h.PingURL
}

// GetTestURL returns the TestURL field if it's non-nil, zero value otherwise.
func (h *Hook) GetTestURL() string {
	if h == nil || h.TestURL == nil {
		return ""
	}
	return *h.TestURL
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (h *Hook) GetType() string {
	if h == nil || h.Type == nil {
		return ""
	}
	return *h.Type
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (h *Hook) GetUpdatedAt() Timestamp {
	if h == nil || h.UpdatedAt == nil {
		return Timestamp{}
	}
	return *h.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (h *Hook) GetURL() string {
	if h == nil || h.URL == nil {
		return ""
	}
	return *h.URL
}

// GetContentType returns the ContentType field if it's non-nil, zero value otherwise.
func (h *HookConfig) GetContentType() string {
	if h == nil || h.ContentType == nil {
		return ""
	}
	return *h.ContentType
}

// GetInsecureSSL returns the InsecureSSL field if it's non-nil, zero value otherwise.
func (h *HookConfig) GetInsecureSSL() string {
	if h == nil || h.InsecureSSL == nil {
		return ""
	}
	return *h.InsecureSSL
}

// GetSecret returns the Secret field if it's non-nil, zero value otherwise.
func (h *HookConfig) GetSecret() string {
	if h == nil || h.Secret == nil {
		return ""
	}
	return *h.Secret
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (h *HookConfig) GetURL() string {
	if h == nil || h.URL == nil {
		return ""
	}
	return *h.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetAction() string {
	if h == nil || h.Action == nil {
		return ""
	}
	return *h.Action
}

// GetDeliveredAt returns the DeliveredAt field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetDeliveredAt() Timestamp {
	if h == nil || h.DeliveredAt == nil {
		return Timestamp{}
	}
	return *h.DeliveredAt
}

// GetDuration returns the Duration field.
func (h *HookDelivery) GetDuration() *float64 {
	if h == nil {
		return nil
	}
	return h.Duration
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetEvent() string {
	if h == nil || h.Event == nil {
		return ""
	}
	return *h.Event
}

// GetGUID returns the GUID field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetGUID() string {
	if h == nil || h.GUID == nil {
		return ""
	}
	return *h.GUID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetID() int64 {
	if h == nil || h.ID == nil {
		return 0
	}
	return *h.ID
}

// GetInstallationID returns the InstallationID field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetInstallationID() int64 {
	if h == nil || h.InstallationID == nil {
		return 0
	}
	return *h.InstallationID
}

// GetRedelivery returns the Redelivery field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetRedelivery() bool {
	if h == nil || h.Redelivery == nil {
		return false
	}
	return *h.Redelivery
}

// GetRepositoryID returns the RepositoryID field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetRepositoryID() int64 {
	if h == nil || h.RepositoryID == nil {
		return 0
	}
	return *h.RepositoryID
}

// GetRequest returns the Request field.
func (h *HookDelivery) GetRequest() *HookRequest {
	if h == nil {
		return nil
	}
	return h.Request
}

// GetResponse returns the Response field.
func (h *HookDelivery) GetResponse() *HookResponse {
	if h == nil {
		return nil
	}
	return h.Response
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetStatus() string {
	if h == nil || h.Status == nil {
		return ""
	}
	return *h.Status
}

// GetStatusCode returns the StatusCode field if it's non-nil, zero value otherwise.
func (h *HookDelivery) GetStatusCode() int {
	if h == nil || h.StatusCode == nil {
		return 0
	}
	return *h.StatusCode
}

// GetHeaders returns the Headers map if it's non-nil, an empty map otherwise.
func (h *HookRequest) GetHeaders() map[string]string {
	if h == nil || h.Headers == nil {
		return map[string]string{}
	}
	return h.Headers
}

// GetRawPayload returns the RawPayload field if it's non-nil, zero value otherwise.
func (h *HookRequest) GetRawPayload() json.RawMessage {
	if h == nil || h.RawPayload == nil {
		return json.RawMessage{}
	}
	return *h.RawPayload
}

// GetHeaders returns the Headers map if it's non-nil, an empty map otherwise.
func (h *HookResponse) GetHeaders() map[string]string {
	if h == nil || h.Headers == nil {
		return map[string]string{}
	}
	return h.Headers
}

// GetRawPayload returns the RawPayload field if it's non-nil, zero value otherwise.
func (h *HookResponse) GetRawPayload() json.RawMessage {
	if h == nil || h.RawPayload == nil {
		return json.RawMessage{}
	}
	return *h.RawPayload
}

// GetActiveHooks returns the ActiveHooks field if it's non-nil, zero value otherwise.
func (h *HookStats) GetActiveHooks() int {
	if h == nil || h.ActiveHooks == nil {
		return 0
	}
	return *h.ActiveHooks
}

// GetInactiveHooks returns the InactiveHooks field if it's non-nil, zero value otherwise.
func (h *HookStats) GetInactiveHooks() int {
	if h == nil || h.InactiveHooks == nil {
		return 0
	}
	return *h.InactiveHooks
}

// GetTotalHooks returns the TotalHooks field if it's non-nil, zero value otherwise.
func (h *HookStats) GetTotalHooks() int {
	if h == nil || h.TotalHooks == nil {
		return 0
	}
	return *h.TotalHooks
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetID() int64 {
	if h == nil || h.ID == nil {
		return 0
	}
	return *h.ID
}

// GetImageDetails returns the ImageDetails field.
func (h *HostedRunner) GetImageDetails() *HostedRunnerImageDetail {
	if h == nil {
		return nil
	}
	return h.ImageDetails
}

// GetLastActiveOn returns the LastActiveOn field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetLastActiveOn() Timestamp {
	if h == nil || h.LastActiveOn == nil {
		return Timestamp{}
	}
	return *h.LastActiveOn
}

// GetMachineSizeDetails returns the MachineSizeDetails field.
func (h *HostedRunner) GetMachineSizeDetails() *HostedRunnerMachineSpec {
	if h == nil {
		return nil
	}
	return h.MachineSizeDetails
}

// GetMaximumRunners returns the MaximumRunners field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetMaximumRunners() int64 {
	if h == nil || h.MaximumRunners == nil {
		return 0
	}
	return *h.MaximumRunners
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetName() string {
	if h == nil || h.Name == nil {
		return ""
	}
	return *h.Name
}

// GetPlatform returns the Platform field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetPlatform() string {
	if h == nil || h.Platform == nil {
		return ""
	}
	return *h.Platform
}

// GetPublicIPEnabled returns the PublicIPEnabled field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetPublicIPEnabled() bool {
	if h == nil || h.PublicIPEnabled == nil {
		return false
	}
	return *h.PublicIPEnabled
}

// GetRunnerGroupID returns the RunnerGroupID field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetRunnerGroupID() int64 {
	if h == nil || h.RunnerGroupID == nil {
		return 0
	}
	return *h.RunnerGroupID
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (h *HostedRunner) GetStatus() string {
	if h == nil || h.Status == nil {
		return ""
	}
	return *h.Status
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (h *HostedRunnerImageDetail) GetDisplayName() string {
	if h == nil || h.DisplayName == nil {
		return ""
	}
	return *h.DisplayName
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (h *HostedRunnerImageDetail) GetID() string {
	if h == nil || h.ID == nil {
		return ""
	}
	return *h.ID
}

// GetSizeGB returns the SizeGB field if it's non-nil, zero value otherwise.
func (h *HostedRunnerImageDetail) GetSizeGB() int64 {
	if h == nil || h.SizeGB == nil {
		return 0
	}
	return *h.SizeGB
}

// GetSource returns the Source field if it's non-nil, zero value otherwise.
func (h *HostedRunnerImageDetail) GetSource() string {
	if h == nil || h.Source == nil {
		return ""
	}
	return *h.Source
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (h *HostedRunnerImageDetail) GetVersion() string {
	if h == nil || h.Version == nil {
		return ""
	}
	return *h.Version
}

// GetPublicIPs returns the PublicIPs field.
func (h *HostedRunnerPublicIPLimits) GetPublicIPs() *PublicIPUsage {
	if h == nil {
		return nil
	}
	return h.PublicIPs
}

// GetGroupDescription returns the GroupDescription field if it's non-nil, zero value otherwise.
func (i *IDPGroup) GetGroupDescription() string {
	if i == nil || i.GroupDescription == nil {
		return ""
	}
	return *i.GroupDescription
}

// GetGroupID returns the GroupID field if it's non-nil, zero value otherwise.
func (i *IDPGroup) GetGroupID() string {
	if i == nil || i.GroupID == nil {
		return ""
	}
	return *i.GroupID
}

// GetGroupName returns the GroupName field if it's non-nil, zero value otherwise.
func (i *IDPGroup) GetGroupName() string {
	if i == nil || i.GroupName == nil {
		return ""
	}
	return *i.GroupName
}

// GetAuthorsCount returns the AuthorsCount field if it's non-nil, zero value otherwise.
func (i *Import) GetAuthorsCount() int {
	if i == nil || i.AuthorsCount == nil {
		return 0
	}
	return *i.AuthorsCount
}

// GetAuthorsURL returns the AuthorsURL field if it's non-nil, zero value otherwise.
func (i *Import) GetAuthorsURL() string {
	if i == nil || i.AuthorsURL == nil {
		return ""
	}
	return *i.AuthorsURL
}

// GetCommitCount returns the CommitCount field if it's non-nil, zero value otherwise.
func (i *Import) GetCommitCount() int {
	if i == nil || i.CommitCount == nil {
		return 0
	}
	return *i.CommitCount
}

// GetFailedStep returns the FailedStep field if it's non-nil, zero value otherwise.
func (i *Import) GetFailedStep() string {
	if i == nil || i.FailedStep == nil {
		return ""
	}
	return *i.FailedStep
}

// GetHasLargeFiles returns the HasLargeFiles field if it's non-nil, zero value otherwise.
func (i *Import) GetHasLargeFiles() bool {
	if i == nil || i.HasLargeFiles == nil {
		return false
	}
	return *i.HasLargeFiles
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (i *Import) GetHTMLURL() string {
	if i == nil || i.HTMLURL == nil {
		return ""
	}
	return *i.HTMLURL
}

// GetHumanName returns the HumanName field if it's non-nil, zero value otherwise.
func (i *Import) GetHumanName() string {
	if i == nil || i.HumanName == nil {
		return ""
	}
	return *i.HumanName
}

// GetLargeFilesCount returns the LargeFilesCount field if it's non-nil, zero value otherwise.
func (i *Import) GetLargeFilesCount() int {
	if i == nil || i.LargeFilesCount == nil {
		return 0
	}
	return *i.LargeFilesCount
}

// GetLargeFilesSize returns the LargeFilesSize field if it's non-nil, zero value otherwise.
func (i *Import) GetLargeFilesSize() int {
	if i == nil || i.LargeFilesSize == nil {
		return 0
	}
	return *i.LargeFilesSize
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (i *Import) GetMessage() string {
	if i == nil || i.Message == nil {
		return ""
	}
	return *i.Message
}

// GetPercent returns the Percent field if it's non-nil, zero value otherwise.
func (i *Import) GetPercent() int {
	if i == nil || i.Percent == nil {
		return 0
	}
	return *i.Percent
}

// GetPushPercent returns the PushPercent field if it's non-nil, zero value otherwise.
func (i *Import) GetPushPercent() int {
	if i == nil || i.PushPercent == nil {
		return 0
	}
	return *i.PushPercent
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (i *Import) GetRepositoryURL() string {
	if i == nil || i.RepositoryURL == nil {
		return ""
	}
	return *i.RepositoryURL
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (i *Import) GetStatus() string {
	if i == nil || i.Status == nil {
		return ""
	}
	return *i.Status
}

// GetStatusText returns the StatusText field if it's non-nil, zero value otherwise.
func (i *Import) GetStatusText() string {
	if i == nil || i.StatusText == nil {
		return ""
	}
	return *i.StatusText
}

// GetTFVCProject returns the TFVCProject field if it's non-nil, zero value otherwise.
func (i *Import) GetTFVCProject() string {
	if i == nil || i.TFVCProject == nil {
		return ""
	}
	return *i.TFVCProject
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (i *Import) GetURL() string {
	if i == nil || i.URL == nil {
		return ""
	}
	return *i.URL
}

// GetUseLFS returns the UseLFS field if it's non-nil, zero value otherwise.
func (i *Import) GetUseLFS() string {
	if i == nil || i.UseLFS == nil {
		return ""
	}
	return *i.UseLFS
}

// GetVCS returns the VCS field if it's non-nil, zero value otherwise.
func (i *Import) GetVCS() string {
	if i == nil || i.VCS == nil {
		return ""
	}
	return *i.VCS
}

// GetVCSPassword returns the VCSPassword field if it's non-nil, zero value otherwise.
func (i *Import) GetVCSPassword() string {
	if i == nil || i.VCSPassword == nil {
		return ""
	}
	return *i.VCSPassword
}

// GetVCSURL returns the VCSURL field if it's non-nil, zero value otherwise.
func (i *Import) GetVCSURL() string {
	if i == nil || i.VCSURL == nil {
		return ""
	}
	return *i.VCSURL
}

// GetVCSUsername returns the VCSUsername field if it's non-nil, zero value otherwise.
func (i *Import) GetVCSUsername() string {
	if i == nil || i.VCSUsername == nil {
		return ""
	}
	return *i.VCSUsername
}

// GetAccessTokensURL returns the AccessTokensURL field if it's non-nil, zero value otherwise.
func (i *Installation) GetAccessTokensURL() string {
	if i == nil || i.AccessTokensURL == nil {
		return ""
	}
	return *i.AccessTokensURL
}

// GetAccount returns the Account field.
func (i *Installation) GetAccount() *User {
	if i == nil {
		return nil
	}
	return i.Account
}

// GetAppID returns the AppID field if it's non-nil, zero value otherwise.
func (i *Installation) GetAppID() int64 {
	if i == nil || i.AppID == nil {
		return 0
	}
	return *i.AppID
}

// GetAppSlug returns the AppSlug field if it's non-nil, zero value otherwise.
func (i *Installation) GetAppSlug() string {
	if i == nil || i.AppSlug == nil {
		return ""
	}
	return *i.AppSlug
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *Installation) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetHasMultipleSingleFiles returns the HasMultipleSingleFiles field if it's non-nil, zero value otherwise.
func (i *Installation) GetHasMultipleSingleFiles() bool {
	if i == nil || i.HasMultipleSingleFiles == nil {
		return false
	}
	return *i.HasMultipleSingleFiles
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (i *Installation) GetHTMLURL() string {
	if i == nil || i.HTMLURL == nil {
		return ""
	}
	return *i.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *Installation) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *Installation) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetPermissions returns the Permissions field.
func (i *Installation) GetPermissions() *InstallationPermissions {
	if i == nil {
		return nil
	}
	return i.Permissions
}

// GetRepositoriesURL returns the RepositoriesURL field if it's non-nil, zero value otherwise.
func (i *Installation) GetRepositoriesURL() string {
	if i == nil || i.RepositoriesURL == nil {
		return ""
	}
	return *i.RepositoriesURL
}

// GetRepositorySelection returns the RepositorySelection field if it's non-nil, zero value otherwise.
func (i *Installation) GetRepositorySelection() string {
	if i == nil || i.RepositorySelection == nil {
		return ""
	}
	return *i.RepositorySelection
}

// GetSingleFileName returns the SingleFileName field if it's non-nil, zero value otherwise.
func (i *Installation) GetSingleFileName() string {
	if i == nil || i.SingleFileName == nil {
		return ""
	}
	return *i.SingleFileName
}

// GetSuspendedAt returns the SuspendedAt field if it's non-nil, zero value otherwise.
func (i *Installation) GetSuspendedAt() Timestamp {
	if i == nil || i.SuspendedAt == nil {
		return Timestamp{}
	}
	return *i.SuspendedAt
}

// GetSuspendedBy returns the SuspendedBy field.
func (i *Installation) GetSuspendedBy() *User {
	if i == nil {
		return nil
	}
	return i.SuspendedBy
}

// GetTargetID returns the TargetID field if it's non-nil, zero value otherwise.
func (i *Installation) GetTargetID() int64 {
	if i == nil || i.TargetID == nil {
		return 0
	}
	return *i.TargetID
}

// GetTargetType returns the TargetType field if it's non-nil, zero value otherwise.
func (i *Installation) GetTargetType() string {
	if i == nil || i.TargetType == nil {
		return ""
	}
	return *i.TargetType
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *Installation) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetLogin returns the Login field.
func (i *InstallationChanges) GetLogin() *InstallationLoginChange {
	if i == nil {
		return nil
	}
	return i.Login
}

// GetSlug returns the Slug field.
func (i *InstallationChanges) GetSlug() *InstallationSlugChange {
	if i == nil {
		return nil
	}
	return i.Slug
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (i *InstallationEvent) GetAction() string {
	if i == nil || i.Action == nil {
		return ""
	}
	return *i.Action
}

// GetInstallation returns the Installation field.
func (i *InstallationEvent) GetInstallation() *Installation {
	if i == nil {
		return nil
	}
	return i.Installation
}

// GetOrg returns the Org field.
func (i *InstallationEvent) GetOrg() *Organization {
	if i == nil {
		return nil
	}
	return i.Org
}

// GetRequester returns the Requester field.
func (i *InstallationEvent) GetRequester() *User {
	if i == nil {
		return nil
	}
	return i.Requester
}

// GetSender returns the Sender field.
func (i *InstallationEvent) GetSender() *User {
	if i == nil {
		return nil
	}
	return i.Sender
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (i *InstallationLoginChange) GetFrom() string {
	if i == nil || i.From == nil {
		return ""
	}
	return *i.From
}

// GetActions returns the Actions field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetActions() string {
	if i == nil || i.Actions == nil {
		return ""
	}
	return *i.Actions
}

// GetActionsVariables returns the ActionsVariables field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetActionsVariables() string {
	if i == nil || i.ActionsVariables == nil {
		return ""
	}
	return *i.ActionsVariables
}

// GetAdministration returns the Administration field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetAdministration() string {
	if i == nil || i.Administration == nil {
		return ""
	}
	return *i.Administration
}

// GetAttestations returns the Attestations field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetAttestations() string {
	if i == nil || i.Attestations == nil {
		return ""
	}
	return *i.Attestations
}

// GetBlocking returns the Blocking field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetBlocking() string {
	if i == nil || i.Blocking == nil {
		return ""
	}
	return *i.Blocking
}

// GetChecks returns the Checks field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetChecks() string {
	if i == nil || i.Checks == nil {
		return ""
	}
	return *i.Checks
}

// GetCodespaces returns the Codespaces field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCodespaces() string {
	if i == nil || i.Codespaces == nil {
		return ""
	}
	return *i.Codespaces
}

// GetCodespacesLifecycleAdmin returns the CodespacesLifecycleAdmin field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCodespacesLifecycleAdmin() string {
	if i == nil || i.CodespacesLifecycleAdmin == nil {
		return ""
	}
	return *i.CodespacesLifecycleAdmin
}

// GetCodespacesMetadata returns the CodespacesMetadata field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCodespacesMetadata() string {
	if i == nil || i.CodespacesMetadata == nil {
		return ""
	}
	return *i.CodespacesMetadata
}

// GetCodespacesSecrets returns the CodespacesSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCodespacesSecrets() string {
	if i == nil || i.CodespacesSecrets == nil {
		return ""
	}
	return *i.CodespacesSecrets
}

// GetCodespacesUserSecrets returns the CodespacesUserSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCodespacesUserSecrets() string {
	if i == nil || i.CodespacesUserSecrets == nil {
		return ""
	}
	return *i.CodespacesUserSecrets
}

// GetContentReferences returns the ContentReferences field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetContentReferences() string {
	if i == nil || i.ContentReferences == nil {
		return ""
	}
	return *i.ContentReferences
}

// GetContents returns the Contents field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetContents() string {
	if i == nil || i.Contents == nil {
		return ""
	}
	return *i.Contents
}

// GetCopilotMessages returns the CopilotMessages field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetCopilotMessages() string {
	if i == nil || i.CopilotMessages == nil {
		return ""
	}
	return *i.CopilotMessages
}

// GetDependabotSecrets returns the DependabotSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetDependabotSecrets() string {
	if i == nil || i.DependabotSecrets == nil {
		return ""
	}
	return *i.DependabotSecrets
}

// GetDeployments returns the Deployments field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetDeployments() string {
	if i == nil || i.Deployments == nil {
		return ""
	}
	return *i.Deployments
}

// GetDiscussions returns the Discussions field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetDiscussions() string {
	if i == nil || i.Discussions == nil {
		return ""
	}
	return *i.Discussions
}

// GetEmails returns the Emails field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetEmails() string {
	if i == nil || i.Emails == nil {
		return ""
	}
	return *i.Emails
}

// GetEnvironments returns the Environments field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetEnvironments() string {
	if i == nil || i.Environments == nil {
		return ""
	}
	return *i.Environments
}

// GetFollowers returns the Followers field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetFollowers() string {
	if i == nil || i.Followers == nil {
		return ""
	}
	return *i.Followers
}

// GetGists returns the Gists field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetGists() string {
	if i == nil || i.Gists == nil {
		return ""
	}
	return *i.Gists
}

// GetGitSigningSSHPublicKeys returns the GitSigningSSHPublicKeys field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetGitSigningSSHPublicKeys() string {
	if i == nil || i.GitSigningSSHPublicKeys == nil {
		return ""
	}
	return *i.GitSigningSSHPublicKeys
}

// GetGPGKeys returns the GPGKeys field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetGPGKeys() string {
	if i == nil || i.GPGKeys == nil {
		return ""
	}
	return *i.GPGKeys
}

// GetInteractionLimits returns the InteractionLimits field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetInteractionLimits() string {
	if i == nil || i.InteractionLimits == nil {
		return ""
	}
	return *i.InteractionLimits
}

// GetIssues returns the Issues field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetIssues() string {
	if i == nil || i.Issues == nil {
		return ""
	}
	return *i.Issues
}

// GetKeys returns the Keys field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetKeys() string {
	if i == nil || i.Keys == nil {
		return ""
	}
	return *i.Keys
}

// GetMembers returns the Members field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetMembers() string {
	if i == nil || i.Members == nil {
		return ""
	}
	return *i.Members
}

// GetMergeQueues returns the MergeQueues field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetMergeQueues() string {
	if i == nil || i.MergeQueues == nil {
		return ""
	}
	return *i.MergeQueues
}

// GetMetadata returns the Metadata field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetMetadata() string {
	if i == nil || i.Metadata == nil {
		return ""
	}
	return *i.Metadata
}

// GetOrganizationActionsVariables returns the OrganizationActionsVariables field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationActionsVariables() string {
	if i == nil || i.OrganizationActionsVariables == nil {
		return ""
	}
	return *i.OrganizationActionsVariables
}

// GetOrganizationAdministration returns the OrganizationAdministration field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationAdministration() string {
	if i == nil || i.OrganizationAdministration == nil {
		return ""
	}
	return *i.OrganizationAdministration
}

// GetOrganizationAnnouncementBanners returns the OrganizationAnnouncementBanners field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationAnnouncementBanners() string {
	if i == nil || i.OrganizationAnnouncementBanners == nil {
		return ""
	}
	return *i.OrganizationAnnouncementBanners
}

// GetOrganizationAPIInsights returns the OrganizationAPIInsights field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationAPIInsights() string {
	if i == nil || i.OrganizationAPIInsights == nil {
		return ""
	}
	return *i.OrganizationAPIInsights
}

// GetOrganizationCodespaces returns the OrganizationCodespaces field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCodespaces() string {
	if i == nil || i.OrganizationCodespaces == nil {
		return ""
	}
	return *i.OrganizationCodespaces
}

// GetOrganizationCodespacesSecrets returns the OrganizationCodespacesSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCodespacesSecrets() string {
	if i == nil || i.OrganizationCodespacesSecrets == nil {
		return ""
	}
	return *i.OrganizationCodespacesSecrets
}

// GetOrganizationCodespacesSettings returns the OrganizationCodespacesSettings field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCodespacesSettings() string {
	if i == nil || i.OrganizationCodespacesSettings == nil {
		return ""
	}
	return *i.OrganizationCodespacesSettings
}

// GetOrganizationCopilotSeatManagement returns the OrganizationCopilotSeatManagement field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCopilotSeatManagement() string {
	if i == nil || i.OrganizationCopilotSeatManagement == nil {
		return ""
	}
	return *i.OrganizationCopilotSeatManagement
}

// GetOrganizationCustomOrgRoles returns the OrganizationCustomOrgRoles field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCustomOrgRoles() string {
	if i == nil || i.OrganizationCustomOrgRoles == nil {
		return ""
	}
	return *i.OrganizationCustomOrgRoles
}

// GetOrganizationCustomProperties returns the OrganizationCustomProperties field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCustomProperties() string {
	if i == nil || i.OrganizationCustomProperties == nil {
		return ""
	}
	return *i.OrganizationCustomProperties
}

// GetOrganizationCustomRoles returns the OrganizationCustomRoles field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationCustomRoles() string {
	if i == nil || i.OrganizationCustomRoles == nil {
		return ""
	}
	return *i.OrganizationCustomRoles
}

// GetOrganizationDependabotSecrets returns the OrganizationDependabotSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationDependabotSecrets() string {
	if i == nil || i.OrganizationDependabotSecrets == nil {
		return ""
	}
	return *i.OrganizationDependabotSecrets
}

// GetOrganizationEvents returns the OrganizationEvents field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationEvents() string {
	if i == nil || i.OrganizationEvents == nil {
		return ""
	}
	return *i.OrganizationEvents
}

// GetOrganizationHooks returns the OrganizationHooks field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationHooks() string {
	if i == nil || i.OrganizationHooks == nil {
		return ""
	}
	return *i.OrganizationHooks
}

// GetOrganizationKnowledgeBases returns the OrganizationKnowledgeBases field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationKnowledgeBases() string {
	if i == nil || i.OrganizationKnowledgeBases == nil {
		return ""
	}
	return *i.OrganizationKnowledgeBases
}

// GetOrganizationPackages returns the OrganizationPackages field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationPackages() string {
	if i == nil || i.OrganizationPackages == nil {
		return ""
	}
	return *i.OrganizationPackages
}

// GetOrganizationPersonalAccessTokenRequests returns the OrganizationPersonalAccessTokenRequests field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationPersonalAccessTokenRequests() string {
	if i == nil || i.OrganizationPersonalAccessTokenRequests == nil {
		return ""
	}
	return *i.OrganizationPersonalAccessTokenRequests
}

// GetOrganizationPersonalAccessTokens returns the OrganizationPersonalAccessTokens field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationPersonalAccessTokens() string {
	if i == nil || i.OrganizationPersonalAccessTokens == nil {
		return ""
	}
	return *i.OrganizationPersonalAccessTokens
}

// GetOrganizationPlan returns the OrganizationPlan field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationPlan() string {
	if i == nil || i.OrganizationPlan == nil {
		return ""
	}
	return *i.OrganizationPlan
}

// GetOrganizationPreReceiveHooks returns the OrganizationPreReceiveHooks field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationPreReceiveHooks() string {
	if i == nil || i.OrganizationPreReceiveHooks == nil {
		return ""
	}
	return *i.OrganizationPreReceiveHooks
}

// GetOrganizationProjects returns the OrganizationProjects field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationProjects() string {
	if i == nil || i.OrganizationProjects == nil {
		return ""
	}
	return *i.OrganizationProjects
}

// GetOrganizationSecrets returns the OrganizationSecrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationSecrets() string {
	if i == nil || i.OrganizationSecrets == nil {
		return ""
	}
	return *i.OrganizationSecrets
}

// GetOrganizationSelfHostedRunners returns the OrganizationSelfHostedRunners field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationSelfHostedRunners() string {
	if i == nil || i.OrganizationSelfHostedRunners == nil {
		return ""
	}
	return *i.OrganizationSelfHostedRunners
}

// GetOrganizationUserBlocking returns the OrganizationUserBlocking field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetOrganizationUserBlocking() string {
	if i == nil || i.OrganizationUserBlocking == nil {
		return ""
	}
	return *i.OrganizationUserBlocking
}

// GetPackages returns the Packages field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetPackages() string {
	if i == nil || i.Packages == nil {
		return ""
	}
	return *i.Packages
}

// GetPages returns the Pages field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetPages() string {
	if i == nil || i.Pages == nil {
		return ""
	}
	return *i.Pages
}

// GetPlan returns the Plan field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetPlan() string {
	if i == nil || i.Plan == nil {
		return ""
	}
	return *i.Plan
}

// GetProfile returns the Profile field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetProfile() string {
	if i == nil || i.Profile == nil {
		return ""
	}
	return *i.Profile
}

// GetPullRequests returns the PullRequests field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetPullRequests() string {
	if i == nil || i.PullRequests == nil {
		return ""
	}
	return *i.PullRequests
}

// GetRepositoryAdvisories returns the RepositoryAdvisories field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetRepositoryAdvisories() string {
	if i == nil || i.RepositoryAdvisories == nil {
		return ""
	}
	return *i.RepositoryAdvisories
}

// GetRepositoryCustomProperties returns the RepositoryCustomProperties field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetRepositoryCustomProperties() string {
	if i == nil || i.RepositoryCustomProperties == nil {
		return ""
	}
	return *i.RepositoryCustomProperties
}

// GetRepositoryHooks returns the RepositoryHooks field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetRepositoryHooks() string {
	if i == nil || i.RepositoryHooks == nil {
		return ""
	}
	return *i.RepositoryHooks
}

// GetRepositoryPreReceiveHooks returns the RepositoryPreReceiveHooks field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetRepositoryPreReceiveHooks() string {
	if i == nil || i.RepositoryPreReceiveHooks == nil {
		return ""
	}
	return *i.RepositoryPreReceiveHooks
}

// GetRepositoryProjects returns the RepositoryProjects field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetRepositoryProjects() string {
	if i == nil || i.RepositoryProjects == nil {
		return ""
	}
	return *i.RepositoryProjects
}

// GetSecrets returns the Secrets field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetSecrets() string {
	if i == nil || i.Secrets == nil {
		return ""
	}
	return *i.Secrets
}

// GetSecretScanningAlerts returns the SecretScanningAlerts field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetSecretScanningAlerts() string {
	if i == nil || i.SecretScanningAlerts == nil {
		return ""
	}
	return *i.SecretScanningAlerts
}

// GetSecurityEvents returns the SecurityEvents field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetSecurityEvents() string {
	if i == nil || i.SecurityEvents == nil {
		return ""
	}
	return *i.SecurityEvents
}

// GetSingleFile returns the SingleFile field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetSingleFile() string {
	if i == nil || i.SingleFile == nil {
		return ""
	}
	return *i.SingleFile
}

// GetStarring returns the Starring field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetStarring() string {
	if i == nil || i.Starring == nil {
		return ""
	}
	return *i.Starring
}

// GetStatuses returns the Statuses field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetStatuses() string {
	if i == nil || i.Statuses == nil {
		return ""
	}
	return *i.Statuses
}

// GetTeamDiscussions returns the TeamDiscussions field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetTeamDiscussions() string {
	if i == nil || i.TeamDiscussions == nil {
		return ""
	}
	return *i.TeamDiscussions
}

// GetUserEvents returns the UserEvents field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetUserEvents() string {
	if i == nil || i.UserEvents == nil {
		return ""
	}
	return *i.UserEvents
}

// GetVulnerabilityAlerts returns the VulnerabilityAlerts field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetVulnerabilityAlerts() string {
	if i == nil || i.VulnerabilityAlerts == nil {
		return ""
	}
	return *i.VulnerabilityAlerts
}

// GetWatching returns the Watching field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetWatching() string {
	if i == nil || i.Watching == nil {
		return ""
	}
	return *i.Watching
}

// GetWorkflows returns the Workflows field if it's non-nil, zero value otherwise.
func (i *InstallationPermissions) GetWorkflows() string {
	if i == nil || i.Workflows == nil {
		return ""
	}
	return *i.Workflows
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (i *InstallationRepositoriesEvent) GetAction() string {
	if i == nil || i.Action == nil {
		return ""
	}
	return *i.Action
}

// GetInstallation returns the Installation field.
func (i *InstallationRepositoriesEvent) GetInstallation() *Installation {
	if i == nil {
		return nil
	}
	return i.Installation
}

// GetOrg returns the Org field.
func (i *InstallationRepositoriesEvent) GetOrg() *Organization {
	if i == nil {
		return nil
	}
	return i.Org
}

// GetRepositorySelection returns the RepositorySelection field if it's non-nil, zero value otherwise.
func (i *InstallationRepositoriesEvent) GetRepositorySelection() string {
	if i == nil || i.RepositorySelection == nil {
		return ""
	}
	return *i.RepositorySelection
}

// GetSender returns the Sender field.
func (i *InstallationRepositoriesEvent) GetSender() *User {
	if i == nil {
		return nil
	}
	return i.Sender
}

// GetAccount returns the Account field.
func (i *InstallationRequest) GetAccount() *User {
	if i == nil {
		return nil
	}
	return i.Account
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *InstallationRequest) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *InstallationRequest) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *InstallationRequest) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetRequester returns the Requester field.
func (i *InstallationRequest) GetRequester() *User {
	if i == nil {
		return nil
	}
	return i.Requester
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (i *InstallationSlugChange) GetFrom() string {
	if i == nil || i.From == nil {
		return ""
	}
	return *i.From
}

// GetAccount returns the Account field.
func (i *InstallationTargetEvent) GetAccount() *User {
	if i == nil {
		return nil
	}
	return i.Account
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (i *InstallationTargetEvent) GetAction() string {
	if i == nil || i.Action == nil {
		return ""
	}
	return *i.Action
}

// GetChanges returns the Changes field.
func (i *InstallationTargetEvent) GetChanges() *InstallationChanges {
	if i == nil {
		return nil
	}
	return i.Changes
}

// GetEnterprise returns the Enterprise field.
func (i *InstallationTargetEvent) GetEnterprise() *Enterprise {
	if i == nil {
		return nil
	}
	return i.Enterprise
}

// GetInstallation returns the Installation field.
func (i *InstallationTargetEvent) GetInstallation() *Installation {
	if i == nil {
		return nil
	}
	return i.Installation
}

// GetOrganization returns the Organization field.
func (i *InstallationTargetEvent) GetOrganization() *Organization {
	if i == nil {
		return nil
	}
	return i.Organization
}

// GetRepository returns the Repository field.
func (i *InstallationTargetEvent) GetRepository() *Repository {
	if i == nil {
		return nil
	}
	return i.Repository
}

// GetSender returns the Sender field.
func (i *InstallationTargetEvent) GetSender() *User {
	if i == nil {
		return nil
	}
	return i.Sender
}

// GetTargetType returns the TargetType field if it's non-nil, zero value otherwise.
func (i *InstallationTargetEvent) GetTargetType() string {
	if i == nil || i.TargetType == nil {
		return ""
	}
	return *i.TargetType
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (i *InstallationToken) GetExpiresAt() Timestamp {
	if i == nil || i.ExpiresAt == nil {
		return Timestamp{}
	}
	return *i.ExpiresAt
}

// GetPermissions returns the Permissions field.
func (i *InstallationToken) GetPermissions() *InstallationPermissions {
	if i == nil {
		return nil
	}
	return i.Permissions
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (i *InstallationToken) GetToken() string {
	if i == nil || i.Token == nil {
		return ""
	}
	return *i.Token
}

// GetPermissions returns the Permissions field.
func (i *InstallationTokenListRepoOptions) GetPermissions() *InstallationPermissions {
	if i == nil {
		return nil
	}
	return i.Permissions
}

// GetPermissions returns the Permissions field.
func (i *InstallationTokenOptions) GetPermissions() *InstallationPermissions {
	if i == nil {
		return nil
	}
	return i.Permissions
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (i *InteractionRestriction) GetExpiresAt() Timestamp {
	if i == nil || i.ExpiresAt == nil {
		return Timestamp{}
	}
	return *i.ExpiresAt
}

// GetLimit returns the Limit field if it's non-nil, zero value otherwise.
func (i *InteractionRestriction) GetLimit() string {
	if i == nil || i.Limit == nil {
		return ""
	}
	return *i.Limit
}

// GetOrigin returns the Origin field if it's non-nil, zero value otherwise.
func (i *InteractionRestriction) GetOrigin() string {
	if i == nil || i.Origin == nil {
		return ""
	}
	return *i.Origin
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *Invitation) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (i *Invitation) GetEmail() string {
	if i == nil || i.Email == nil {
		return ""
	}
	return *i.Email
}

// GetFailedAt returns the FailedAt field if it's non-nil, zero value otherwise.
func (i *Invitation) GetFailedAt() Timestamp {
	if i == nil || i.FailedAt == nil {
		return Timestamp{}
	}
	return *i.FailedAt
}

// GetFailedReason returns the FailedReason field if it's non-nil, zero value otherwise.
func (i *Invitation) GetFailedReason() string {
	if i == nil || i.FailedReason == nil {
		return ""
	}
	return *i.FailedReason
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *Invitation) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetInvitationTeamURL returns the InvitationTeamURL field if it's non-nil, zero value otherwise.
func (i *Invitation) GetInvitationTeamURL() string {
	if i == nil || i.InvitationTeamURL == nil {
		return ""
	}
	return *i.InvitationTeamURL
}

// GetInviter returns the Inviter field.
func (i *Invitation) GetInviter() *User {
	if i == nil {
		return nil
	}
	return i.Inviter
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (i *Invitation) GetLogin() string {
	if i == nil || i.Login == nil {
		return ""
	}
	return *i.Login
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *Invitation) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetRole returns the Role field if it's non-nil, zero value otherwise.
func (i *Invitation) GetRole() string {
	if i == nil || i.Role == nil {
		return ""
	}
	return *i.Role
}

// GetTeamCount returns the TeamCount field if it's non-nil, zero value otherwise.
func (i *Invitation) GetTeamCount() int {
	if i == nil || i.TeamCount == nil {
		return 0
	}
	return *i.TeamCount
}

// GetActiveLockReason returns the ActiveLockReason field if it's non-nil, zero value otherwise.
func (i *Issue) GetActiveLockReason() string {
	if i == nil || i.ActiveLockReason == nil {
		return ""
	}
	return *i.ActiveLockReason
}

// GetAssignee returns the Assignee field.
func (i *Issue) GetAssignee() *User {
	if i == nil {
		return nil
	}
	return i.Assignee
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (i *Issue) GetAuthorAssociation() string {
	if i == nil || i.AuthorAssociation == nil {
		return ""
	}
	return *i.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (i *Issue) GetBody() string {
	if i == nil || i.Body == nil {
		return ""
	}
	return *i.Body
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (i *Issue) GetClosedAt() Timestamp {
	if i == nil || i.ClosedAt == nil {
		return Timestamp{}
	}
	return *i.ClosedAt
}

// GetClosedBy returns the ClosedBy field.
func (i *Issue) GetClosedBy() *User {
	if i == nil {
		return nil
	}
	return i.ClosedBy
}

// GetComments returns the Comments field if it's non-nil, zero value otherwise.
func (i *Issue) GetComments() int {
	if i == nil || i.Comments == nil {
		return 0
	}
	return *i.Comments
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (i *Issue) GetCommentsURL() string {
	if i == nil || i.CommentsURL == nil {
		return ""
	}
	return *i.CommentsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *Issue) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (i *Issue) GetDraft() bool {
	if i == nil || i.Draft == nil {
		return false
	}
	return *i.Draft
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (i *Issue) GetEventsURL() string {
	if i == nil || i.EventsURL == nil {
		return ""
	}
	return *i.EventsURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (i *Issue) GetHTMLURL() string {
	if i == nil || i.HTMLURL == nil {
		return ""
	}
	return *i.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *Issue) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetLabelsURL returns the LabelsURL field if it's non-nil, zero value otherwise.
func (i *Issue) GetLabelsURL() string {
	if i == nil || i.LabelsURL == nil {
		return ""
	}
	return *i.LabelsURL
}

// GetLocked returns the Locked field if it's non-nil, zero value otherwise.
func (i *Issue) GetLocked() bool {
	if i == nil || i.Locked == nil {
		return false
	}
	return *i.Locked
}

// GetMilestone returns the Milestone field.
func (i *Issue) GetMilestone() *Milestone {
	if i == nil {
		return nil
	}
	return i.Milestone
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *Issue) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (i *Issue) GetNumber() int {
	if i == nil || i.Number == nil {
		return 0
	}
	return *i.Number
}

// GetPullRequestLinks returns the PullRequestLinks field.
func (i *Issue) GetPullRequestLinks() *PullRequestLinks {
	if i == nil {
		return nil
	}
	return i.PullRequestLinks
}

// GetReactions returns the Reactions field.
func (i *Issue) GetReactions() *Reactions {
	if i == nil {
		return nil
	}
	return i.Reactions
}

// GetRepository returns the Repository field.
func (i *Issue) GetRepository() *Repository {
	if i == nil {
		return nil
	}
	return i.Repository
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (i *Issue) GetRepositoryURL() string {
	if i == nil || i.RepositoryURL == nil {
		return ""
	}
	return *i.RepositoryURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (i *Issue) GetState() string {
	if i == nil || i.State == nil {
		return ""
	}
	return *i.State
}

// GetStateReason returns the StateReason field if it's non-nil, zero value otherwise.
func (i *Issue) GetStateReason() string {
	if i == nil || i.StateReason == nil {
		return ""
	}
	return *i.StateReason
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (i *Issue) GetTitle() string {
	if i == nil || i.Title == nil {
		return ""
	}
	return *i.Title
}

// GetType returns the Type field.
func (i *Issue) GetType() *IssueType {
	if i == nil {
		return nil
	}
	return i.Type
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *Issue) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (i *Issue) GetURL() string {
	if i == nil || i.URL == nil {
		return ""
	}
	return *i.URL
}

// GetUser returns the User field.
func (i *Issue) GetUser() *User {
	if i == nil {
		return nil
	}
	return i.User
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetAuthorAssociation() string {
	if i == nil || i.AuthorAssociation == nil {
		return ""
	}
	return *i.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetBody() string {
	if i == nil || i.Body == nil {
		return ""
	}
	return *i.Body
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetHTMLURL() string {
	if i == nil || i.HTMLURL == nil {
		return ""
	}
	return *i.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetIssueURL returns the IssueURL field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetIssueURL() string {
	if i == nil || i.IssueURL == nil {
		return ""
	}
	return *i.IssueURL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetReactions returns the Reactions field.
func (i *IssueComment) GetReactions() *Reactions {
	if i == nil {
		return nil
	}
	return i.Reactions
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (i *IssueComment) GetURL() string {
	if i == nil || i.URL == nil {
		return ""
	}
	return *i.URL
}

// GetUser returns the User field.
func (i *IssueComment) GetUser() *User {
	if i == nil {
		return nil
	}
	return i.User
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (i *IssueCommentEvent) GetAction() string {
	if i == nil || i.Action == nil {
		return ""
	}
	return *i.Action
}

// GetChanges returns the Changes field.
func (i *IssueCommentEvent) GetChanges() *EditChange {
	if i == nil {
		return nil
	}
	return i.Changes
}

// GetComment returns the Comment field.
func (i *IssueCommentEvent) GetComment() *IssueComment {
	if i == nil {
		return nil
	}
	return i.Comment
}

// GetInstallation returns the Installation field.
func (i *IssueCommentEvent) GetInstallation() *Installation {
	if i == nil {
		return nil
	}
	return i.Installation
}

// GetIssue returns the Issue field.
func (i *IssueCommentEvent) GetIssue() *Issue {
	if i == nil {
		return nil
	}
	return i.Issue
}

// GetOrganization returns the Organization field.
func (i *IssueCommentEvent) GetOrganization() *Organization {
	if i == nil {
		return nil
	}
	return i.Organization
}

// GetRepo returns the Repo field.
func (i *IssueCommentEvent) GetRepo() *Repository {
	if i == nil {
		return nil
	}
	return i.Repo
}

// GetSender returns the Sender field.
func (i *IssueCommentEvent) GetSender() *User {
	if i == nil {
		return nil
	}
	return i.Sender
}

// GetActor returns the Actor field.
func (i *IssueEvent) GetActor() *User {
	if i == nil {
		return nil
	}
	return i.Actor
}

// GetAssignee returns the Assignee field.
func (i *IssueEvent) GetAssignee() *User {
	if i == nil {
		return nil
	}
	return i.Assignee
}

// GetAssigner returns the Assigner field.
func (i *IssueEvent) GetAssigner() *User {
	if i == nil {
		return nil
	}
	return i.Assigner
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetCommitID() string {
	if i == nil || i.CommitID == nil {
		return ""
	}
	return *i.CommitID
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetDismissedReview returns the DismissedReview field.
func (i *IssueEvent) GetDismissedReview() *DismissedReview {
	if i == nil {
		return nil
	}
	return i.DismissedReview
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetEvent() string {
	if i == nil || i.Event == nil {
		return ""
	}
	return *i.Event
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetIssue returns the Issue field.
func (i *IssueEvent) GetIssue() *Issue {
	if i == nil {
		return nil
	}
	return i.Issue
}

// GetLabel returns the Label field.
func (i *IssueEvent) GetLabel() *Label {
	if i == nil {
		return nil
	}
	return i.Label
}

// GetLockReason returns the LockReason field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetLockReason() string {
	if i == nil || i.LockReason == nil {
		return ""
	}
	return *i.LockReason
}

// GetMilestone returns the Milestone field.
func (i *IssueEvent) GetMilestone() *Milestone {
	if i == nil {
		return nil
	}
	return i.Milestone
}

// GetPerformedViaGithubApp returns the PerformedViaGithubApp field.
func (i *IssueEvent) GetPerformedViaGithubApp() *App {
	if i == nil {
		return nil
	}
	return i.PerformedViaGithubApp
}

// GetRename returns the Rename field.
func (i *IssueEvent) GetRename() *Rename {
	if i == nil {
		return nil
	}
	return i.Rename
}

// GetRepository returns the Repository field.
func (i *IssueEvent) GetRepository() *Repository {
	if i == nil {
		return nil
	}
	return i.Repository
}

// GetRequestedReviewer returns the RequestedReviewer field.
func (i *IssueEvent) GetRequestedReviewer() *User {
	if i == nil {
		return nil
	}
	return i.RequestedReviewer
}

// GetRequestedTeam returns the RequestedTeam field.
func (i *IssueEvent) GetRequestedTeam() *Team {
	if i == nil {
		return nil
	}
	return i.RequestedTeam
}

// GetReviewRequester returns the ReviewRequester field.
func (i *IssueEvent) GetReviewRequester() *User {
	if i == nil {
		return nil
	}
	return i.ReviewRequester
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (i *IssueEvent) GetURL() string {
	if i == nil || i.URL == nil {
		return ""
	}
	return *i.URL
}

// GetAssignee returns the Assignee field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetAssignee() string {
	if i == nil || i.Assignee == nil {
		return ""
	}
	return *i.Assignee
}

// GetClosed returns the Closed field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetClosed() bool {
	if i == nil || i.Closed == nil {
		return false
	}
	return *i.Closed
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetClosedAt() Timestamp {
	if i == nil || i.ClosedAt == nil {
		return Timestamp{}
	}
	return *i.ClosedAt
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetMilestone returns the Milestone field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetMilestone() int {
	if i == nil || i.Milestone == nil {
		return 0
	}
	return *i.Milestone
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *IssueImport) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetCode returns the Code field if it's non-nil, zero value otherwise.
func (i *IssueImportError) GetCode() string {
	if i == nil || i.Code == nil {
		return ""
	}
	return *i.Code
}

// GetField returns the Field field if it's non-nil, zero value otherwise.
func (i *IssueImportError) GetField() string {
	if i == nil || i.Field == nil {
		return ""
	}
	return *i.Field
}

// GetLocation returns the Location field if it's non-nil, zero value otherwise.
func (i *IssueImportError) GetLocation() string {
	if i == nil || i.Location == nil {
		return ""
	}
	return *i.Location
}

// GetResource returns the Resource field if it's non-nil, zero value otherwise.
func (i *IssueImportError) GetResource() string {
	if i == nil || i.Resource == nil {
		return ""
	}
	return *i.Resource
}

// GetValue returns the Value field if it's non-nil, zero value otherwise.
func (i *IssueImportError) GetValue() string {
	if i == nil || i.Value == nil {
		return ""
	}
	return *i.Value
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetDocumentationURL returns the DocumentationURL field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetDocumentationURL() string {
	if i == nil || i.DocumentationURL == nil {
		return ""
	}
	return *i.DocumentationURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetID() int {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetImportIssuesURL returns the ImportIssuesURL field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetImportIssuesURL() string {
	if i == nil || i.ImportIssuesURL == nil {
		return ""
	}
	return *i.ImportIssuesURL
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetMessage() string {
	if i == nil || i.Message == nil {
		return ""
	}
	return *i.Message
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetRepositoryURL() string {
	if i == nil || i.RepositoryURL == nil {
		return ""
	}
	return *i.RepositoryURL
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetStatus() string {
	if i == nil || i.Status == nil {
		return ""
	}
	return *i.Status
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (i *IssueImportResponse) GetURL() string {
	if i == nil || i.URL == nil {
		return ""
	}
	return *i.URL
}

// GetDirection returns the Direction field if it's non-nil, zero value otherwise.
func (i *IssueListCommentsOptions) GetDirection() string {
	if i == nil || i.Direction == nil {
		return ""
	}
	return *i.Direction
}

// GetSince returns the Since field if it's non-nil, zero value otherwise.
func (i *IssueListCommentsOptions) GetSince() time.Time {
	if i == nil || i.Since == nil {
		return time.Time{}
	}
	return *i.Since
}

// GetSort returns the Sort field if it's non-nil, zero value otherwise.
func (i *IssueListCommentsOptions) GetSort() string {
	if i == nil || i.Sort == nil {
		return ""
	}
	return *i.Sort
}

// GetAssignee returns the Assignee field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetAssignee() string {
	if i == nil || i.Assignee == nil {
		return ""
	}
	return *i.Assignee
}

// GetAssignees returns the Assignees field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetAssignees() []string {
	if i == nil || i.Assignees == nil {
		return nil
	}
	return *i.Assignees
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetBody() string {
	if i == nil || i.Body == nil {
		return ""
	}
	return *i.Body
}

// GetLabels returns the Labels field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetLabels() []string {
	if i == nil || i.Labels == nil {
		return nil
	}
	return *i.Labels
}

// GetMilestone returns the Milestone field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetMilestone() int {
	if i == nil || i.Milestone == nil {
		return 0
	}
	return *i.Milestone
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetState() string {
	if i == nil || i.State == nil {
		return ""
	}
	return *i.State
}

// GetStateReason returns the StateReason field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetStateReason() string {
	if i == nil || i.StateReason == nil {
		return ""
	}
	return *i.StateReason
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetTitle() string {
	if i == nil || i.Title == nil {
		return ""
	}
	return *i.Title
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (i *IssueRequest) GetType() string {
	if i == nil || i.Type == nil {
		return ""
	}
	return *i.Type
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (i *IssuesEvent) GetAction() string {
	if i == nil || i.Action == nil {
		return ""
	}
	return *i.Action
}

// GetAssignee returns the Assignee field.
func (i *IssuesEvent) GetAssignee() *User {
	if i == nil {
		return nil
	}
	return i.Assignee
}

// GetChanges returns the Changes field.
func (i *IssuesEvent) GetChanges() *EditChange {
	if i == nil {
		return nil
	}
	return i.Changes
}

// GetInstallation returns the Installation field.
func (i *IssuesEvent) GetInstallation() *Installation {
	if i == nil {
		return nil
	}
	return i.Installation
}

// GetIssue returns the Issue field.
func (i *IssuesEvent) GetIssue() *Issue {
	if i == nil {
		return nil
	}
	return i.Issue
}

// GetLabel returns the Label field.
func (i *IssuesEvent) GetLabel() *Label {
	if i == nil {
		return nil
	}
	return i.Label
}

// GetMilestone returns the Milestone field.
func (i *IssuesEvent) GetMilestone() *Milestone {
	if i == nil {
		return nil
	}
	return i.Milestone
}

// GetOrg returns the Org field.
func (i *IssuesEvent) GetOrg() *Organization {
	if i == nil {
		return nil
	}
	return i.Org
}

// GetRepo returns the Repo field.
func (i *IssuesEvent) GetRepo() *Repository {
	if i == nil {
		return nil
	}
	return i.Repo
}

// GetSender returns the Sender field.
func (i *IssuesEvent) GetSender() *User {
	if i == nil {
		return nil
	}
	return i.Sender
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (i *IssuesSearchResult) GetIncompleteResults() bool {
	if i == nil || i.IncompleteResults == nil {
		return false
	}
	return *i.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (i *IssuesSearchResult) GetTotal() int {
	if i == nil || i.Total == nil {
		return 0
	}
	return *i.Total
}

// GetClosedIssues returns the ClosedIssues field if it's non-nil, zero value otherwise.
func (i *IssueStats) GetClosedIssues() int {
	if i == nil || i.ClosedIssues == nil {
		return 0
	}
	return *i.ClosedIssues
}

// GetOpenIssues returns the OpenIssues field if it's non-nil, zero value otherwise.
func (i *IssueStats) GetOpenIssues() int {
	if i == nil || i.OpenIssues == nil {
		return 0
	}
	return *i.OpenIssues
}

// GetTotalIssues returns the TotalIssues field if it's non-nil, zero value otherwise.
func (i *IssueStats) GetTotalIssues() int {
	if i == nil || i.TotalIssues == nil {
		return 0
	}
	return *i.TotalIssues
}

// GetColor returns the Color field if it's non-nil, zero value otherwise.
func (i *IssueType) GetColor() string {
	if i == nil || i.Color == nil {
		return ""
	}
	return *i.Color
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (i *IssueType) GetCreatedAt() Timestamp {
	if i == nil || i.CreatedAt == nil {
		return Timestamp{}
	}
	return *i.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (i *IssueType) GetDescription() string {
	if i == nil || i.Description == nil {
		return ""
	}
	return *i.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (i *IssueType) GetID() int64 {
	if i == nil || i.ID == nil {
		return 0
	}
	return *i.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (i *IssueType) GetName() string {
	if i == nil || i.Name == nil {
		return ""
	}
	return *i.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (i *IssueType) GetNodeID() string {
	if i == nil || i.NodeID == nil {
		return ""
	}
	return *i.NodeID
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (i *IssueType) GetUpdatedAt() Timestamp {
	if i == nil || i.UpdatedAt == nil {
		return Timestamp{}
	}
	return *i.UpdatedAt
}

// GetEncodedJITConfig returns the EncodedJITConfig field if it's non-nil, zero value otherwise.
func (j *JITRunnerConfig) GetEncodedJITConfig() string {
	if j == nil || j.EncodedJITConfig == nil {
		return ""
	}
	return *j.EncodedJITConfig
}

// GetRunner returns the Runner field.
func (j *JITRunnerConfig) GetRunner() *Runner {
	if j == nil {
		return nil
	}
	return j.Runner
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (j *Jobs) GetTotalCount() int {
	if j == nil || j.TotalCount == nil {
		return 0
	}
	return *j.TotalCount
}

// GetAddedBy returns the AddedBy field if it's non-nil, zero value otherwise.
func (k *Key) GetAddedBy() string {
	if k == nil || k.AddedBy == nil {
		return ""
	}
	return *k.AddedBy
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (k *Key) GetCreatedAt() Timestamp {
	if k == nil || k.CreatedAt == nil {
		return Timestamp{}
	}
	return *k.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (k *Key) GetID() int64 {
	if k == nil || k.ID == nil {
		return 0
	}
	return *k.ID
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (k *Key) GetKey() string {
	if k == nil || k.Key == nil {
		return ""
	}
	return *k.Key
}

// GetLastUsed returns the LastUsed field if it's non-nil, zero value otherwise.
func (k *Key) GetLastUsed() Timestamp {
	if k == nil || k.LastUsed == nil {
		return Timestamp{}
	}
	return *k.LastUsed
}

// GetReadOnly returns the ReadOnly field if it's non-nil, zero value otherwise.
func (k *Key) GetReadOnly() bool {
	if k == nil || k.ReadOnly == nil {
		return false
	}
	return *k.ReadOnly
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (k *Key) GetTitle() string {
	if k == nil || k.Title == nil {
		return ""
	}
	return *k.Title
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (k *Key) GetURL() string {
	if k == nil || k.URL == nil {
		return ""
	}
	return *k.URL
}

// GetVerified returns the Verified field if it's non-nil, zero value otherwise.
func (k *Key) GetVerified() bool {
	if k == nil || k.Verified == nil {
		return false
	}
	return *k.Verified
}

// GetColor returns the Color field if it's non-nil, zero value otherwise.
func (l *Label) GetColor() string {
	if l == nil || l.Color == nil {
		return ""
	}
	return *l.Color
}

// GetDefault returns the Default field if it's non-nil, zero value otherwise.
func (l *Label) GetDefault() bool {
	if l == nil || l.Default == nil {
		return false
	}
	return *l.Default
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (l *Label) GetDescription() string {
	if l == nil || l.Description == nil {
		return ""
	}
	return *l.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (l *Label) GetID() int64 {
	if l == nil || l.ID == nil {
		return 0
	}
	return *l.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (l *Label) GetName() string {
	if l == nil || l.Name == nil {
		return ""
	}
	return *l.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (l *Label) GetNodeID() string {
	if l == nil || l.NodeID == nil {
		return ""
	}
	return *l.NodeID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (l *Label) GetURL() string {
	if l == nil || l.URL == nil {
		return ""
	}
	return *l.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (l *LabelEvent) GetAction() string {
	if l == nil || l.Action == nil {
		return ""
	}
	return *l.Action
}

// GetChanges returns the Changes field.
func (l *LabelEvent) GetChanges() *EditChange {
	if l == nil {
		return nil
	}
	return l.Changes
}

// GetInstallation returns the Installation field.
func (l *LabelEvent) GetInstallation() *Installation {
	if l == nil {
		return nil
	}
	return l.Installation
}

// GetLabel returns the Label field.
func (l *LabelEvent) GetLabel() *Label {
	if l == nil {
		return nil
	}
	return l.Label
}

// GetOrg returns the Org field.
func (l *LabelEvent) GetOrg() *Organization {
	if l == nil {
		return nil
	}
	return l.Org
}

// GetRepo returns the Repo field.
func (l *LabelEvent) GetRepo() *Repository {
	if l == nil {
		return nil
	}
	return l.Repo
}

// GetSender returns the Sender field.
func (l *LabelEvent) GetSender() *User {
	if l == nil {
		return nil
	}
	return l.Sender
}

// GetColor returns the Color field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetColor() string {
	if l == nil || l.Color == nil {
		return ""
	}
	return *l.Color
}

// GetDefault returns the Default field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetDefault() bool {
	if l == nil || l.Default == nil {
		return false
	}
	return *l.Default
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetDescription() string {
	if l == nil || l.Description == nil {
		return ""
	}
	return *l.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetID() int64 {
	if l == nil || l.ID == nil {
		return 0
	}
	return *l.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetName() string {
	if l == nil || l.Name == nil {
		return ""
	}
	return *l.Name
}

// GetScore returns the Score field.
func (l *LabelResult) GetScore() *float64 {
	if l == nil {
		return nil
	}
	return l.Score
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (l *LabelResult) GetURL() string {
	if l == nil || l.URL == nil {
		return ""
	}
	return *l.URL
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (l *LabelsSearchResult) GetIncompleteResults() bool {
	if l == nil || l.IncompleteResults == nil {
		return false
	}
	return *l.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (l *LabelsSearchResult) GetTotal() int {
	if l == nil || l.Total == nil {
		return 0
	}
	return *l.Total
}

// GetOID returns the OID field if it's non-nil, zero value otherwise.
func (l *LargeFile) GetOID() string {
	if l == nil || l.OID == nil {
		return ""
	}
	return *l.OID
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (l *LargeFile) GetPath() string {
	if l == nil || l.Path == nil {
		return ""
	}
	return *l.Path
}

// GetRefName returns the RefName field if it's non-nil, zero value otherwise.
func (l *LargeFile) GetRefName() string {
	if l == nil || l.RefName == nil {
		return ""
	}
	return *l.RefName
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (l *LargeFile) GetSize() int {
	if l == nil || l.Size == nil {
		return 0
	}
	return *l.Size
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (l *License) GetBody() string {
	if l == nil || l.Body == nil {
		return ""
	}
	return *l.Body
}

// GetConditions returns the Conditions field if it's non-nil, zero value otherwise.
func (l *License) GetConditions() []string {
	if l == nil || l.Conditions == nil {
		return nil
	}
	return *l.Conditions
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (l *License) GetDescription() string {
	if l == nil || l.Description == nil {
		return ""
	}
	return *l.Description
}

// GetFeatured returns the Featured field if it's non-nil, zero value otherwise.
func (l *License) GetFeatured() bool {
	if l == nil || l.Featured == nil {
		return false
	}
	return *l.Featured
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (l *License) GetHTMLURL() string {
	if l == nil || l.HTMLURL == nil {
		return ""
	}
	return *l.HTMLURL
}

// GetImplementation returns the Implementation field if it's non-nil, zero value otherwise.
func (l *License) GetImplementation() string {
	if l == nil || l.Implementation == nil {
		return ""
	}
	return *l.Implementation
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (l *License) GetKey() string {
	if l == nil || l.Key == nil {
		return ""
	}
	return *l.Key
}

// GetLimitations returns the Limitations field if it's non-nil, zero value otherwise.
func (l *License) GetLimitations() []string {
	if l == nil || l.Limitations == nil {
		return nil
	}
	return *l.Limitations
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (l *License) GetName() string {
	if l == nil || l.Name == nil {
		return ""
	}
	return *l.Name
}

// GetPermissions returns the Permissions field if it's non-nil, zero value otherwise.
func (l *License) GetPermissions() []string {
	if l == nil || l.Permissions == nil {
		return nil
	}
	return *l.Permissions
}

// GetSPDXID returns the SPDXID field if it's non-nil, zero value otherwise.
func (l *License) GetSPDXID() string {
	if l == nil || l.SPDXID == nil {
		return ""
	}
	return *l.SPDXID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (l *License) GetURL() string {
	if l == nil || l.URL == nil {
		return ""
	}
	return *l.URL
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (l *LicenseCheck) GetStatus() string {
	if l == nil || l.Status == nil {
		return ""
	}
	return *l.Status
}

// GetAdvancedSecurityEnabled returns the AdvancedSecurityEnabled field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetAdvancedSecurityEnabled() bool {
	if l == nil || l.AdvancedSecurityEnabled == nil {
		return false
	}
	return *l.AdvancedSecurityEnabled
}

// GetAdvancedSecuritySeats returns the AdvancedSecuritySeats field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetAdvancedSecuritySeats() int {
	if l == nil || l.AdvancedSecuritySeats == nil {
		return 0
	}
	return *l.AdvancedSecuritySeats
}

// GetClusterSupport returns the ClusterSupport field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetClusterSupport() bool {
	if l == nil || l.ClusterSupport == nil {
		return false
	}
	return *l.ClusterSupport
}

// GetCompany returns the Company field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetCompany() string {
	if l == nil || l.Company == nil {
		return ""
	}
	return *l.Company
}

// GetCroquetSupport returns the CroquetSupport field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetCroquetSupport() bool {
	if l == nil || l.CroquetSupport == nil {
		return false
	}
	return *l.CroquetSupport
}

// GetCustomTerms returns the CustomTerms field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetCustomTerms() bool {
	if l == nil || l.CustomTerms == nil {
		return false
	}
	return *l.CustomTerms
}

// GetEvaluation returns the Evaluation field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetEvaluation() bool {
	if l == nil || l.Evaluation == nil {
		return false
	}
	return *l.Evaluation
}

// GetExpireAt returns the ExpireAt field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetExpireAt() Timestamp {
	if l == nil || l.ExpireAt == nil {
		return Timestamp{}
	}
	return *l.ExpireAt
}

// GetInsightsEnabled returns the InsightsEnabled field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetInsightsEnabled() bool {
	if l == nil || l.InsightsEnabled == nil {
		return false
	}
	return *l.InsightsEnabled
}

// GetInsightsExpireAt returns the InsightsExpireAt field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetInsightsExpireAt() Timestamp {
	if l == nil || l.InsightsExpireAt == nil {
		return Timestamp{}
	}
	return *l.InsightsExpireAt
}

// GetLearningLabEvaluationExpires returns the LearningLabEvaluationExpires field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetLearningLabEvaluationExpires() Timestamp {
	if l == nil || l.LearningLabEvaluationExpires == nil {
		return Timestamp{}
	}
	return *l.LearningLabEvaluationExpires
}

// GetLearningLabSeats returns the LearningLabSeats field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetLearningLabSeats() int {
	if l == nil || l.LearningLabSeats == nil {
		return 0
	}
	return *l.LearningLabSeats
}

// GetPerpetual returns the Perpetual field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetPerpetual() bool {
	if l == nil || l.Perpetual == nil {
		return false
	}
	return *l.Perpetual
}

// GetReferenceNumber returns the ReferenceNumber field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetReferenceNumber() string {
	if l == nil || l.ReferenceNumber == nil {
		return ""
	}
	return *l.ReferenceNumber
}

// GetSeats returns the Seats field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetSeats() int {
	if l == nil || l.Seats == nil {
		return 0
	}
	return *l.Seats
}

// GetSSHAllowed returns the SSHAllowed field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetSSHAllowed() bool {
	if l == nil || l.SSHAllowed == nil {
		return false
	}
	return *l.SSHAllowed
}

// GetSupportKey returns the SupportKey field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetSupportKey() string {
	if l == nil || l.SupportKey == nil {
		return ""
	}
	return *l.SupportKey
}

// GetUnlimitedSeating returns the UnlimitedSeating field if it's non-nil, zero value otherwise.
func (l *LicenseStatus) GetUnlimitedSeating() bool {
	if l == nil || l.UnlimitedSeating == nil {
		return false
	}
	return *l.UnlimitedSeating
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (l *LinearHistoryRequirementEnforcementLevelChanges) GetFrom() string {
	if l == nil || l.From == nil {
		return ""
	}
	return *l.From
}

// GetDirection returns the Direction field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetDirection() string {
	if l == nil || l.Direction == nil {
		return ""
	}
	return *l.Direction
}

// GetEcosystem returns the Ecosystem field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetEcosystem() string {
	if l == nil || l.Ecosystem == nil {
		return ""
	}
	return *l.Ecosystem
}

// GetPackage returns the Package field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetPackage() string {
	if l == nil || l.Package == nil {
		return ""
	}
	return *l.Package
}

// GetScope returns the Scope field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetScope() string {
	if l == nil || l.Scope == nil {
		return ""
	}
	return *l.Scope
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetSeverity() string {
	if l == nil || l.Severity == nil {
		return ""
	}
	return *l.Severity
}

// GetSort returns the Sort field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetSort() string {
	if l == nil || l.Sort == nil {
		return ""
	}
	return *l.Sort
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (l *ListAlertsOptions) GetState() string {
	if l == nil || l.State == nil {
		return ""
	}
	return *l.State
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (l *ListArtifactsOptions) GetName() string {
	if l == nil || l.Name == nil {
		return ""
	}
	return *l.Name
}

// GetAppID returns the AppID field if it's non-nil, zero value otherwise.
func (l *ListCheckRunsOptions) GetAppID() int64 {
	if l == nil || l.AppID == nil {
		return 0
	}
	return *l.AppID
}

// GetCheckName returns the CheckName field if it's non-nil, zero value otherwise.
func (l *ListCheckRunsOptions) GetCheckName() string {
	if l == nil || l.CheckName == nil {
		return ""
	}
	return *l.CheckName
}

// GetFilter returns the Filter field if it's non-nil, zero value otherwise.
func (l *ListCheckRunsOptions) GetFilter() string {
	if l == nil || l.Filter == nil {
		return ""
	}
	return *l.Filter
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (l *ListCheckRunsOptions) GetStatus() string {
	if l == nil || l.Status == nil {
		return ""
	}
	return *l.Status
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (l *ListCheckRunsResults) GetTotal() int {
	if l == nil || l.Total == nil {
		return 0
	}
	return *l.Total
}

// GetAppID returns the AppID field if it's non-nil, zero value otherwise.
func (l *ListCheckSuiteOptions) GetAppID() int {
	if l == nil || l.AppID == nil {
		return 0
	}
	return *l.AppID
}

// GetCheckName returns the CheckName field if it's non-nil, zero value otherwise.
func (l *ListCheckSuiteOptions) GetCheckName() string {
	if l == nil || l.CheckName == nil {
		return ""
	}
	return *l.CheckName
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (l *ListCheckSuiteResults) GetTotal() int {
	if l == nil || l.Total == nil {
		return 0
	}
	return *l.Total
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (l *ListCodespaces) GetTotalCount() int {
	if l == nil || l.TotalCount == nil {
		return 0
	}
	return *l.TotalCount
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (l *ListCustomDeploymentRuleIntegrationsResponse) GetTotalCount() int {
	if l == nil || l.TotalCount == nil {
		return 0
	}
	return *l.TotalCount
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (l *ListDeploymentProtectionRuleResponse) GetTotalCount() int {
	if l == nil || l.TotalCount == nil {
		return 0
	}
	return *l.TotalCount
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (l *ListExternalGroupsOptions) GetDisplayName() string {
	if l == nil || l.DisplayName == nil {
		return ""
	}
	return *l.DisplayName
}

// GetAffects returns the Affects field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetAffects() string {
	if l == nil || l.Affects == nil {
		return ""
	}
	return *l.Affects
}

// GetCVEID returns the CVEID field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetCVEID() string {
	if l == nil || l.CVEID == nil {
		return ""
	}
	return *l.CVEID
}

// GetEcosystem returns the Ecosystem field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetEcosystem() string {
	if l == nil || l.Ecosystem == nil {
		return ""
	}
	return *l.Ecosystem
}

// GetGHSAID returns the GHSAID field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetGHSAID() string {
	if l == nil || l.GHSAID == nil {
		return ""
	}
	return *l.GHSAID
}

// GetIsWithdrawn returns the IsWithdrawn field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetIsWithdrawn() bool {
	if l == nil || l.IsWithdrawn == nil {
		return false
	}
	return *l.IsWithdrawn
}

// GetModified returns the Modified field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetModified() string {
	if l == nil || l.Modified == nil {
		return ""
	}
	return *l.Modified
}

// GetPublished returns the Published field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetPublished() string {
	if l == nil || l.Published == nil {
		return ""
	}
	return *l.Published
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetSeverity() string {
	if l == nil || l.Severity == nil {
		return ""
	}
	return *l.Severity
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetType() string {
	if l == nil || l.Type == nil {
		return ""
	}
	return *l.Type
}

// GetUpdated returns the Updated field if it's non-nil, zero value otherwise.
func (l *ListGlobalSecurityAdvisoriesOptions) GetUpdated() string {
	if l == nil || l.Updated == nil {
		return ""
	}
	return *l.Updated
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (l *ListOrganizations) GetTotalCount() int {
	if l == nil || l.TotalCount == nil {
		return 0
	}
	return *l.TotalCount
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (l *ListRepositories) GetTotalCount() int {
	if l == nil || l.TotalCount == nil {
		return 0
	}
	return *l.TotalCount
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (l *ListRunnersOptions) GetName() string {
	if l == nil || l.Name == nil {
		return ""
	}
	return *l.Name
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (l *ListSCIMProvisionedIdentitiesOptions) GetCount() int {
	if l == nil || l.Count == nil {
		return 0
	}
	return *l.Count
}

// GetFilter returns the Filter field if it's non-nil, zero value otherwise.
func (l *ListSCIMProvisionedIdentitiesOptions) GetFilter() string {
	if l == nil || l.Filter == nil {
		return ""
	}
	return *l.Filter
}

// GetStartIndex returns the StartIndex field if it's non-nil, zero value otherwise.
func (l *ListSCIMProvisionedIdentitiesOptions) GetStartIndex() int {
	if l == nil || l.StartIndex == nil {
		return 0
	}
	return *l.StartIndex
}

// GetEndColumn returns the EndColumn field if it's non-nil, zero value otherwise.
func (l *Location) GetEndColumn() int {
	if l == nil || l.EndColumn == nil {
		return 0
	}
	return *l.EndColumn
}

// GetEndLine returns the EndLine field if it's non-nil, zero value otherwise.
func (l *Location) GetEndLine() int {
	if l == nil || l.EndLine == nil {
		return 0
	}
	return *l.EndLine
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (l *Location) GetPath() string {
	if l == nil || l.Path == nil {
		return ""
	}
	return *l.Path
}

// GetStartColumn returns the StartColumn field if it's non-nil, zero value otherwise.
func (l *Location) GetStartColumn() int {
	if l == nil || l.StartColumn == nil {
		return 0
	}
	return *l.StartColumn
}

// GetStartLine returns the StartLine field if it's non-nil, zero value otherwise.
func (l *Location) GetStartLine() int {
	if l == nil || l.StartLine == nil {
		return 0
	}
	return *l.StartLine
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (l *LockBranch) GetEnabled() bool {
	if l == nil || l.Enabled == nil {
		return false
	}
	return *l.Enabled
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (m *MaintenanceOperationStatus) GetHostname() string {
	if m == nil || m.Hostname == nil {
		return ""
	}
	return *m.Hostname
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (m *MaintenanceOperationStatus) GetMessage() string {
	if m == nil || m.Message == nil {
		return ""
	}
	return *m.Message
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (m *MaintenanceOperationStatus) GetUUID() string {
	if m == nil || m.UUID == nil {
		return ""
	}
	return *m.UUID
}

// GetMaintenanceModeMessage returns the MaintenanceModeMessage field if it's non-nil, zero value otherwise.
func (m *MaintenanceOptions) GetMaintenanceModeMessage() string {
	if m == nil || m.MaintenanceModeMessage == nil {
		return ""
	}
	return *m.MaintenanceModeMessage
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (m *MaintenanceOptions) GetUUID() string {
	if m == nil || m.UUID == nil {
		return ""
	}
	return *m.UUID
}

// GetWhen returns the When field if it's non-nil, zero value otherwise.
func (m *MaintenanceOptions) GetWhen() string {
	if m == nil || m.When == nil {
		return ""
	}
	return *m.When
}

// GetCanUnsetMaintenance returns the CanUnsetMaintenance field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetCanUnsetMaintenance() bool {
	if m == nil || m.CanUnsetMaintenance == nil {
		return false
	}
	return *m.CanUnsetMaintenance
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetHostname() string {
	if m == nil || m.Hostname == nil {
		return ""
	}
	return *m.Hostname
}

// GetMaintenanceModeMessage returns the MaintenanceModeMessage field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetMaintenanceModeMessage() string {
	if m == nil || m.MaintenanceModeMessage == nil {
		return ""
	}
	return *m.MaintenanceModeMessage
}

// GetScheduledTime returns the ScheduledTime field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetScheduledTime() Timestamp {
	if m == nil || m.ScheduledTime == nil {
		return Timestamp{}
	}
	return *m.ScheduledTime
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetStatus() string {
	if m == nil || m.Status == nil {
		return ""
	}
	return *m.Status
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (m *MaintenanceStatus) GetUUID() string {
	if m == nil || m.UUID == nil {
		return ""
	}
	return *m.UUID
}

// GetEffectiveDate returns the EffectiveDate field if it's non-nil, zero value otherwise.
func (m *MarketplacePendingChange) GetEffectiveDate() Timestamp {
	if m == nil || m.EffectiveDate == nil {
		return Timestamp{}
	}
	return *m.EffectiveDate
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *MarketplacePendingChange) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetPlan returns the Plan field.
func (m *MarketplacePendingChange) GetPlan() *MarketplacePlan {
	if m == nil {
		return nil
	}
	return m.Plan
}

// GetUnitCount returns the UnitCount field if it's non-nil, zero value otherwise.
func (m *MarketplacePendingChange) GetUnitCount() int {
	if m == nil || m.UnitCount == nil {
		return 0
	}
	return *m.UnitCount
}

// GetAccountsURL returns the AccountsURL field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetAccountsURL() string {
	if m == nil || m.AccountsURL == nil {
		return ""
	}
	return *m.AccountsURL
}

// GetBullets returns the Bullets field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetBullets() []string {
	if m == nil || m.Bullets == nil {
		return nil
	}
	return *m.Bullets
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetDescription() string {
	if m == nil || m.Description == nil {
		return ""
	}
	return *m.Description
}

// GetHasFreeTrial returns the HasFreeTrial field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetHasFreeTrial() bool {
	if m == nil || m.HasFreeTrial == nil {
		return false
	}
	return *m.HasFreeTrial
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetMonthlyPriceInCents returns the MonthlyPriceInCents field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetMonthlyPriceInCents() int {
	if m == nil || m.MonthlyPriceInCents == nil {
		return 0
	}
	return *m.MonthlyPriceInCents
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetName() string {
	if m == nil || m.Name == nil {
		return ""
	}
	return *m.Name
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetNumber() int {
	if m == nil || m.Number == nil {
		return 0
	}
	return *m.Number
}

// GetPriceModel returns the PriceModel field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetPriceModel() string {
	if m == nil || m.PriceModel == nil {
		return ""
	}
	return *m.PriceModel
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetState() string {
	if m == nil || m.State == nil {
		return ""
	}
	return *m.State
}

// GetUnitName returns the UnitName field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetUnitName() string {
	if m == nil || m.UnitName == nil {
		return ""
	}
	return *m.UnitName
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetYearlyPriceInCents returns the YearlyPriceInCents field if it's non-nil, zero value otherwise.
func (m *MarketplacePlan) GetYearlyPriceInCents() int {
	if m == nil || m.YearlyPriceInCents == nil {
		return 0
	}
	return *m.YearlyPriceInCents
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *MarketplacePlanAccount) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (m *MarketplacePlanAccount) GetLogin() string {
	if m == nil || m.Login == nil {
		return ""
	}
	return *m.Login
}

// GetMarketplacePendingChange returns the MarketplacePendingChange field.
func (m *MarketplacePlanAccount) GetMarketplacePendingChange() *MarketplacePendingChange {
	if m == nil {
		return nil
	}
	return m.MarketplacePendingChange
}

// GetMarketplacePurchase returns the MarketplacePurchase field.
func (m *MarketplacePlanAccount) GetMarketplacePurchase() *MarketplacePurchase {
	if m == nil {
		return nil
	}
	return m.MarketplacePurchase
}

// GetOrganizationBillingEmail returns the OrganizationBillingEmail field if it's non-nil, zero value otherwise.
func (m *MarketplacePlanAccount) GetOrganizationBillingEmail() string {
	if m == nil || m.OrganizationBillingEmail == nil {
		return ""
	}
	return *m.OrganizationBillingEmail
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (m *MarketplacePlanAccount) GetType() string {
	if m == nil || m.Type == nil {
		return ""
	}
	return *m.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *MarketplacePlanAccount) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetAccount returns the Account field.
func (m *MarketplacePurchase) GetAccount() *MarketplacePurchaseAccount {
	if m == nil {
		return nil
	}
	return m.Account
}

// GetBillingCycle returns the BillingCycle field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetBillingCycle() string {
	if m == nil || m.BillingCycle == nil {
		return ""
	}
	return *m.BillingCycle
}

// GetFreeTrialEndsOn returns the FreeTrialEndsOn field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetFreeTrialEndsOn() Timestamp {
	if m == nil || m.FreeTrialEndsOn == nil {
		return Timestamp{}
	}
	return *m.FreeTrialEndsOn
}

// GetNextBillingDate returns the NextBillingDate field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetNextBillingDate() Timestamp {
	if m == nil || m.NextBillingDate == nil {
		return Timestamp{}
	}
	return *m.NextBillingDate
}

// GetOnFreeTrial returns the OnFreeTrial field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetOnFreeTrial() bool {
	if m == nil || m.OnFreeTrial == nil {
		return false
	}
	return *m.OnFreeTrial
}

// GetPlan returns the Plan field.
func (m *MarketplacePurchase) GetPlan() *MarketplacePlan {
	if m == nil {
		return nil
	}
	return m.Plan
}

// GetUnitCount returns the UnitCount field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetUnitCount() int {
	if m == nil || m.UnitCount == nil {
		return 0
	}
	return *m.UnitCount
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchase) GetUpdatedAt() Timestamp {
	if m == nil || m.UpdatedAt == nil {
		return Timestamp{}
	}
	return *m.UpdatedAt
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetEmail() string {
	if m == nil || m.Email == nil {
		return ""
	}
	return *m.Email
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetLogin() string {
	if m == nil || m.Login == nil {
		return ""
	}
	return *m.Login
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetNodeID() string {
	if m == nil || m.NodeID == nil {
		return ""
	}
	return *m.NodeID
}

// GetOrganizationBillingEmail returns the OrganizationBillingEmail field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetOrganizationBillingEmail() string {
	if m == nil || m.OrganizationBillingEmail == nil {
		return ""
	}
	return *m.OrganizationBillingEmail
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetType() string {
	if m == nil || m.Type == nil {
		return ""
	}
	return *m.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseAccount) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetEffectiveDate returns the EffectiveDate field if it's non-nil, zero value otherwise.
func (m *MarketplacePurchaseEvent) GetEffectiveDate() Timestamp {
	if m == nil || m.EffectiveDate == nil {
		return Timestamp{}
	}
	return *m.EffectiveDate
}

// GetInstallation returns the Installation field.
func (m *MarketplacePurchaseEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetMarketplacePurchase returns the MarketplacePurchase field.
func (m *MarketplacePurchaseEvent) GetMarketplacePurchase() *MarketplacePurchase {
	if m == nil {
		return nil
	}
	return m.MarketplacePurchase
}

// GetOrg returns the Org field.
func (m *MarketplacePurchaseEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetPreviousMarketplacePurchase returns the PreviousMarketplacePurchase field.
func (m *MarketplacePurchaseEvent) GetPreviousMarketplacePurchase() *MarketplacePurchase {
	if m == nil {
		return nil
	}
	return m.PreviousMarketplacePurchase
}

// GetSender returns the Sender field.
func (m *MarketplacePurchaseEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetText returns the Text field if it's non-nil, zero value otherwise.
func (m *Match) GetText() string {
	if m == nil || m.Text == nil {
		return ""
	}
	return *m.Text
}

// GetPermission returns the Permission field.
func (m *MemberChanges) GetPermission() *MemberChangesPermission {
	if m == nil {
		return nil
	}
	return m.Permission
}

// GetRoleName returns the RoleName field.
func (m *MemberChanges) GetRoleName() *MemberChangesRoleName {
	if m == nil {
		return nil
	}
	return m.RoleName
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (m *MemberChangesPermission) GetFrom() string {
	if m == nil || m.From == nil {
		return ""
	}
	return *m.From
}

// GetTo returns the To field if it's non-nil, zero value otherwise.
func (m *MemberChangesPermission) GetTo() string {
	if m == nil || m.To == nil {
		return ""
	}
	return *m.To
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (m *MemberChangesRoleName) GetFrom() string {
	if m == nil || m.From == nil {
		return ""
	}
	return *m.From
}

// GetTo returns the To field if it's non-nil, zero value otherwise.
func (m *MemberChangesRoleName) GetTo() string {
	if m == nil || m.To == nil {
		return ""
	}
	return *m.To
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MemberEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetChanges returns the Changes field.
func (m *MemberEvent) GetChanges() *MemberChanges {
	if m == nil {
		return nil
	}
	return m.Changes
}

// GetInstallation returns the Installation field.
func (m *MemberEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetMember returns the Member field.
func (m *MemberEvent) GetMember() *User {
	if m == nil {
		return nil
	}
	return m.Member
}

// GetOrg returns the Org field.
func (m *MemberEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetRepo returns the Repo field.
func (m *MemberEvent) GetRepo() *Repository {
	if m == nil {
		return nil
	}
	return m.Repo
}

// GetSender returns the Sender field.
func (m *MemberEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetOrganization returns the Organization field.
func (m *Membership) GetOrganization() *Organization {
	if m == nil {
		return nil
	}
	return m.Organization
}

// GetOrganizationURL returns the OrganizationURL field if it's non-nil, zero value otherwise.
func (m *Membership) GetOrganizationURL() string {
	if m == nil || m.OrganizationURL == nil {
		return ""
	}
	return *m.OrganizationURL
}

// GetRole returns the Role field if it's non-nil, zero value otherwise.
func (m *Membership) GetRole() string {
	if m == nil || m.Role == nil {
		return ""
	}
	return *m.Role
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (m *Membership) GetState() string {
	if m == nil || m.State == nil {
		return ""
	}
	return *m.State
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *Membership) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetUser returns the User field.
func (m *Membership) GetUser() *User {
	if m == nil {
		return nil
	}
	return m.User
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MembershipEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetInstallation returns the Installation field.
func (m *MembershipEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetMember returns the Member field.
func (m *MembershipEvent) GetMember() *User {
	if m == nil {
		return nil
	}
	return m.Member
}

// GetOrg returns the Org field.
func (m *MembershipEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetScope returns the Scope field if it's non-nil, zero value otherwise.
func (m *MembershipEvent) GetScope() string {
	if m == nil || m.Scope == nil {
		return ""
	}
	return *m.Scope
}

// GetSender returns the Sender field.
func (m *MembershipEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetTeam returns the Team field.
func (m *MembershipEvent) GetTeam() *Team {
	if m == nil {
		return nil
	}
	return m.Team
}

// GetBaseRef returns the BaseRef field if it's non-nil, zero value otherwise.
func (m *MergeGroup) GetBaseRef() string {
	if m == nil || m.BaseRef == nil {
		return ""
	}
	return *m.BaseRef
}

// GetBaseSHA returns the BaseSHA field if it's non-nil, zero value otherwise.
func (m *MergeGroup) GetBaseSHA() string {
	if m == nil || m.BaseSHA == nil {
		return ""
	}
	return *m.BaseSHA
}

// GetHeadCommit returns the HeadCommit field.
func (m *MergeGroup) GetHeadCommit() *Commit {
	if m == nil {
		return nil
	}
	return m.HeadCommit
}

// GetHeadRef returns the HeadRef field if it's non-nil, zero value otherwise.
func (m *MergeGroup) GetHeadRef() string {
	if m == nil || m.HeadRef == nil {
		return ""
	}
	return *m.HeadRef
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (m *MergeGroup) GetHeadSHA() string {
	if m == nil || m.HeadSHA == nil {
		return ""
	}
	return *m.HeadSHA
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MergeGroupEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetInstallation returns the Installation field.
func (m *MergeGroupEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetMergeGroup returns the MergeGroup field.
func (m *MergeGroupEvent) GetMergeGroup() *MergeGroup {
	if m == nil {
		return nil
	}
	return m.MergeGroup
}

// GetOrg returns the Org field.
func (m *MergeGroupEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (m *MergeGroupEvent) GetReason() string {
	if m == nil || m.Reason == nil {
		return ""
	}
	return *m.Reason
}

// GetRepo returns the Repo field.
func (m *MergeGroupEvent) GetRepo() *Repository {
	if m == nil {
		return nil
	}
	return m.Repo
}

// GetSender returns the Sender field.
func (m *MergeGroupEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetText returns the Text field if it's non-nil, zero value otherwise.
func (m *Message) GetText() string {
	if m == nil || m.Text == nil {
		return ""
	}
	return *m.Text
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MetaEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetHook returns the Hook field.
func (m *MetaEvent) GetHook() *Hook {
	if m == nil {
		return nil
	}
	return m.Hook
}

// GetHookID returns the HookID field if it's non-nil, zero value otherwise.
func (m *MetaEvent) GetHookID() int64 {
	if m == nil || m.HookID == nil {
		return 0
	}
	return *m.HookID
}

// GetInstallation returns the Installation field.
func (m *MetaEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetOrg returns the Org field.
func (m *MetaEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetRepo returns the Repo field.
func (m *MetaEvent) GetRepo() *Repository {
	if m == nil {
		return nil
	}
	return m.Repo
}

// GetSender returns the Sender field.
func (m *MetaEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (m *Metric) GetHTMLURL() string {
	if m == nil || m.HTMLURL == nil {
		return ""
	}
	return *m.HTMLURL
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (m *Metric) GetKey() string {
	if m == nil || m.Key == nil {
		return ""
	}
	return *m.Key
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (m *Metric) GetName() string {
	if m == nil || m.Name == nil {
		return ""
	}
	return *m.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (m *Metric) GetNodeID() string {
	if m == nil || m.NodeID == nil {
		return ""
	}
	return *m.NodeID
}

// GetSPDXID returns the SPDXID field if it's non-nil, zero value otherwise.
func (m *Metric) GetSPDXID() string {
	if m == nil || m.SPDXID == nil {
		return ""
	}
	return *m.SPDXID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *Metric) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (m *Migration) GetCreatedAt() string {
	if m == nil || m.CreatedAt == nil {
		return ""
	}
	return *m.CreatedAt
}

// GetExcludeAttachments returns the ExcludeAttachments field if it's non-nil, zero value otherwise.
func (m *Migration) GetExcludeAttachments() bool {
	if m == nil || m.ExcludeAttachments == nil {
		return false
	}
	return *m.ExcludeAttachments
}

// GetGUID returns the GUID field if it's non-nil, zero value otherwise.
func (m *Migration) GetGUID() string {
	if m == nil || m.GUID == nil {
		return ""
	}
	return *m.GUID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *Migration) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetLockRepositories returns the LockRepositories field if it's non-nil, zero value otherwise.
func (m *Migration) GetLockRepositories() bool {
	if m == nil || m.LockRepositories == nil {
		return false
	}
	return *m.LockRepositories
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (m *Migration) GetState() string {
	if m == nil || m.State == nil {
		return ""
	}
	return *m.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (m *Migration) GetUpdatedAt() string {
	if m == nil || m.UpdatedAt == nil {
		return ""
	}
	return *m.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *Migration) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (m *Milestone) GetClosedAt() Timestamp {
	if m == nil || m.ClosedAt == nil {
		return Timestamp{}
	}
	return *m.ClosedAt
}

// GetClosedIssues returns the ClosedIssues field if it's non-nil, zero value otherwise.
func (m *Milestone) GetClosedIssues() int {
	if m == nil || m.ClosedIssues == nil {
		return 0
	}
	return *m.ClosedIssues
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (m *Milestone) GetCreatedAt() Timestamp {
	if m == nil || m.CreatedAt == nil {
		return Timestamp{}
	}
	return *m.CreatedAt
}

// GetCreator returns the Creator field.
func (m *Milestone) GetCreator() *User {
	if m == nil {
		return nil
	}
	return m.Creator
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (m *Milestone) GetDescription() string {
	if m == nil || m.Description == nil {
		return ""
	}
	return *m.Description
}

// GetDueOn returns the DueOn field if it's non-nil, zero value otherwise.
func (m *Milestone) GetDueOn() Timestamp {
	if m == nil || m.DueOn == nil {
		return Timestamp{}
	}
	return *m.DueOn
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (m *Milestone) GetHTMLURL() string {
	if m == nil || m.HTMLURL == nil {
		return ""
	}
	return *m.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (m *Milestone) GetID() int64 {
	if m == nil || m.ID == nil {
		return 0
	}
	return *m.ID
}

// GetLabelsURL returns the LabelsURL field if it's non-nil, zero value otherwise.
func (m *Milestone) GetLabelsURL() string {
	if m == nil || m.LabelsURL == nil {
		return ""
	}
	return *m.LabelsURL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (m *Milestone) GetNodeID() string {
	if m == nil || m.NodeID == nil {
		return ""
	}
	return *m.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (m *Milestone) GetNumber() int {
	if m == nil || m.Number == nil {
		return 0
	}
	return *m.Number
}

// GetOpenIssues returns the OpenIssues field if it's non-nil, zero value otherwise.
func (m *Milestone) GetOpenIssues() int {
	if m == nil || m.OpenIssues == nil {
		return 0
	}
	return *m.OpenIssues
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (m *Milestone) GetState() string {
	if m == nil || m.State == nil {
		return ""
	}
	return *m.State
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (m *Milestone) GetTitle() string {
	if m == nil || m.Title == nil {
		return ""
	}
	return *m.Title
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (m *Milestone) GetUpdatedAt() Timestamp {
	if m == nil || m.UpdatedAt == nil {
		return Timestamp{}
	}
	return *m.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (m *Milestone) GetURL() string {
	if m == nil || m.URL == nil {
		return ""
	}
	return *m.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (m *MilestoneEvent) GetAction() string {
	if m == nil || m.Action == nil {
		return ""
	}
	return *m.Action
}

// GetChanges returns the Changes field.
func (m *MilestoneEvent) GetChanges() *EditChange {
	if m == nil {
		return nil
	}
	return m.Changes
}

// GetInstallation returns the Installation field.
func (m *MilestoneEvent) GetInstallation() *Installation {
	if m == nil {
		return nil
	}
	return m.Installation
}

// GetMilestone returns the Milestone field.
func (m *MilestoneEvent) GetMilestone() *Milestone {
	if m == nil {
		return nil
	}
	return m.Milestone
}

// GetOrg returns the Org field.
func (m *MilestoneEvent) GetOrg() *Organization {
	if m == nil {
		return nil
	}
	return m.Org
}

// GetRepo returns the Repo field.
func (m *MilestoneEvent) GetRepo() *Repository {
	if m == nil {
		return nil
	}
	return m.Repo
}

// GetSender returns the Sender field.
func (m *MilestoneEvent) GetSender() *User {
	if m == nil {
		return nil
	}
	return m.Sender
}

// GetClosedMilestones returns the ClosedMilestones field if it's non-nil, zero value otherwise.
func (m *MilestoneStats) GetClosedMilestones() int {
	if m == nil || m.ClosedMilestones == nil {
		return 0
	}
	return *m.ClosedMilestones
}

// GetOpenMilestones returns the OpenMilestones field if it's non-nil, zero value otherwise.
func (m *MilestoneStats) GetOpenMilestones() int {
	if m == nil || m.OpenMilestones == nil {
		return 0
	}
	return *m.OpenMilestones
}

// GetTotalMilestones returns the TotalMilestones field if it's non-nil, zero value otherwise.
func (m *MilestoneStats) GetTotalMilestones() int {
	if m == nil || m.TotalMilestones == nil {
		return 0
	}
	return *m.TotalMilestones
}

// GetAnalysisKey returns the AnalysisKey field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetAnalysisKey() string {
	if m == nil || m.AnalysisKey == nil {
		return ""
	}
	return *m.AnalysisKey
}

// GetCategory returns the Category field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetCategory() string {
	if m == nil || m.Category == nil {
		return ""
	}
	return *m.Category
}

// GetCommitSHA returns the CommitSHA field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetCommitSHA() string {
	if m == nil || m.CommitSHA == nil {
		return ""
	}
	return *m.CommitSHA
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetEnvironment() string {
	if m == nil || m.Environment == nil {
		return ""
	}
	return *m.Environment
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetHTMLURL() string {
	if m == nil || m.HTMLURL == nil {
		return ""
	}
	return *m.HTMLURL
}

// GetLocation returns the Location field.
func (m *MostRecentInstance) GetLocation() *Location {
	if m == nil {
		return nil
	}
	return m.Location
}

// GetMessage returns the Message field.
func (m *MostRecentInstance) GetMessage() *Message {
	if m == nil {
		return nil
	}
	return m.Message
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetRef() string {
	if m == nil || m.Ref == nil {
		return ""
	}
	return *m.Ref
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (m *MostRecentInstance) GetState() string {
	if m == nil || m.State == nil {
		return ""
	}
	return *m.State
}

// GetComputeService returns the ComputeService field.
func (n *NetworkConfiguration) GetComputeService() *ComputeService {
	if n == nil {
		return nil
	}
	return n.ComputeService
}

// GetCreatedOn returns the CreatedOn field if it's non-nil, zero value otherwise.
func (n *NetworkConfiguration) GetCreatedOn() Timestamp {
	if n == nil || n.CreatedOn == nil {
		return Timestamp{}
	}
	return *n.CreatedOn
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (n *NetworkConfiguration) GetID() string {
	if n == nil || n.ID == nil {
		return ""
	}
	return *n.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (n *NetworkConfiguration) GetName() string {
	if n == nil || n.Name == nil {
		return ""
	}
	return *n.Name
}

// GetComputeService returns the ComputeService field.
func (n *NetworkConfigurationRequest) GetComputeService() *ComputeService {
	if n == nil {
		return nil
	}
	return n.ComputeService
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (n *NetworkConfigurationRequest) GetName() string {
	if n == nil || n.Name == nil {
		return ""
	}
	return *n.Name
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (n *NetworkConfigurations) GetTotalCount() int64 {
	if n == nil || n.TotalCount == nil {
		return 0
	}
	return *n.TotalCount
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (n *NetworkSettingsResource) GetID() string {
	if n == nil || n.ID == nil {
		return ""
	}
	return *n.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (n *NetworkSettingsResource) GetName() string {
	if n == nil || n.Name == nil {
		return ""
	}
	return *n.Name
}

// GetNetworkConfigurationID returns the NetworkConfigurationID field if it's non-nil, zero value otherwise.
func (n *NetworkSettingsResource) GetNetworkConfigurationID() string {
	if n == nil || n.NetworkConfigurationID == nil {
		return ""
	}
	return *n.NetworkConfigurationID
}

// GetRegion returns the Region field if it's non-nil, zero value otherwise.
func (n *NetworkSettingsResource) GetRegion() string {
	if n == nil || n.Region == nil {
		return ""
	}
	return *n.Region
}

// GetSubnetID returns the SubnetID field if it's non-nil, zero value otherwise.
func (n *NetworkSettingsResource) GetSubnetID() string {
	if n == nil || n.SubnetID == nil {
		return ""
	}
	return *n.SubnetID
}

// GetBase returns the Base field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetBase() string {
	if n == nil || n.Base == nil {
		return ""
	}
	return *n.Base
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetBody() string {
	if n == nil || n.Body == nil {
		return ""
	}
	return *n.Body
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetDraft() bool {
	if n == nil || n.Draft == nil {
		return false
	}
	return *n.Draft
}

// GetHead returns the Head field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetHead() string {
	if n == nil || n.Head == nil {
		return ""
	}
	return *n.Head
}

// GetHeadRepo returns the HeadRepo field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetHeadRepo() string {
	if n == nil || n.HeadRepo == nil {
		return ""
	}
	return *n.HeadRepo
}

// GetIssue returns the Issue field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetIssue() int {
	if n == nil || n.Issue == nil {
		return 0
	}
	return *n.Issue
}

// GetMaintainerCanModify returns the MaintainerCanModify field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetMaintainerCanModify() bool {
	if n == nil || n.MaintainerCanModify == nil {
		return false
	}
	return *n.MaintainerCanModify
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (n *NewPullRequest) GetTitle() string {
	if n == nil || n.Title == nil {
		return ""
	}
	return *n.Title
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetDescription() string {
	if n == nil || n.Description == nil {
		return ""
	}
	return *n.Description
}

// GetLDAPDN returns the LDAPDN field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetLDAPDN() string {
	if n == nil || n.LDAPDN == nil {
		return ""
	}
	return *n.LDAPDN
}

// GetNotificationSetting returns the NotificationSetting field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetNotificationSetting() string {
	if n == nil || n.NotificationSetting == nil {
		return ""
	}
	return *n.NotificationSetting
}

// GetParentTeamID returns the ParentTeamID field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetParentTeamID() int64 {
	if n == nil || n.ParentTeamID == nil {
		return 0
	}
	return *n.ParentTeamID
}

// GetPermission returns the Permission field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetPermission() string {
	if n == nil || n.Permission == nil {
		return ""
	}
	return *n.Permission
}

// GetPrivacy returns the Privacy field if it's non-nil, zero value otherwise.
func (n *NewTeam) GetPrivacy() string {
	if n == nil || n.Privacy == nil {
		return ""
	}
	return *n.Privacy
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (n *NodeDetails) GetHostname() string {
	if n == nil || n.Hostname == nil {
		return ""
	}
	return *n.Hostname
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (n *NodeDetails) GetUUID() string {
	if n == nil || n.UUID == nil {
		return ""
	}
	return *n.UUID
}

// GetTopology returns the Topology field if it's non-nil, zero value otherwise.
func (n *NodeMetadataStatus) GetTopology() string {
	if n == nil || n.Topology == nil {
		return ""
	}
	return *n.Topology
}

// GetClusterRoles returns the ClusterRoles field if it's non-nil, zero value otherwise.
func (n *NodeQueryOptions) GetClusterRoles() string {
	if n == nil || n.ClusterRoles == nil {
		return ""
	}
	return *n.ClusterRoles
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (n *NodeQueryOptions) GetUUID() string {
	if n == nil || n.UUID == nil {
		return ""
	}
	return *n.UUID
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (n *NodeReleaseVersion) GetHostname() string {
	if n == nil || n.Hostname == nil {
		return ""
	}
	return *n.Hostname
}

// GetVersion returns the Version field.
func (n *NodeReleaseVersion) GetVersion() *ReleaseVersion {
	if n == nil {
		return nil
	}
	return n.Version
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (n *Notification) GetID() string {
	if n == nil || n.ID == nil {
		return ""
	}
	return *n.ID
}

// GetLastReadAt returns the LastReadAt field if it's non-nil, zero value otherwise.
func (n *Notification) GetLastReadAt() Timestamp {
	if n == nil || n.LastReadAt == nil {
		return Timestamp{}
	}
	return *n.LastReadAt
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (n *Notification) GetReason() string {
	if n == nil || n.Reason == nil {
		return ""
	}
	return *n.Reason
}

// GetRepository returns the Repository field.
func (n *Notification) GetRepository() *Repository {
	if n == nil {
		return nil
	}
	return n.Repository
}

// GetSubject returns the Subject field.
func (n *Notification) GetSubject() *NotificationSubject {
	if n == nil {
		return nil
	}
	return n.Subject
}

// GetUnread returns the Unread field if it's non-nil, zero value otherwise.
func (n *Notification) GetUnread() bool {
	if n == nil || n.Unread == nil {
		return false
	}
	return *n.Unread
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (n *Notification) GetUpdatedAt() Timestamp {
	if n == nil || n.UpdatedAt == nil {
		return Timestamp{}
	}
	return *n.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (n *Notification) GetURL() string {
	if n == nil || n.URL == nil {
		return ""
	}
	return *n.URL
}

// GetLatestCommentURL returns the LatestCommentURL field if it's non-nil, zero value otherwise.
func (n *NotificationSubject) GetLatestCommentURL() string {
	if n == nil || n.LatestCommentURL == nil {
		return ""
	}
	return *n.LatestCommentURL
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (n *NotificationSubject) GetTitle() string {
	if n == nil || n.Title == nil {
		return ""
	}
	return *n.Title
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (n *NotificationSubject) GetType() string {
	if n == nil || n.Type == nil {
		return ""
	}
	return *n.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (n *NotificationSubject) GetURL() string {
	if n == nil || n.URL == nil {
		return ""
	}
	return *n.URL
}

// GetClientID returns the ClientID field if it's non-nil, zero value otherwise.
func (o *OAuthAPP) GetClientID() string {
	if o == nil || o.ClientID == nil {
		return ""
	}
	return *o.ClientID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (o *OAuthAPP) GetName() string {
	if o == nil || o.Name == nil {
		return ""
	}
	return *o.Name
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (o *OAuthAPP) GetURL() string {
	if o == nil || o.URL == nil {
		return ""
	}
	return *o.URL
}

// GetUseDefault returns the UseDefault field if it's non-nil, zero value otherwise.
func (o *OIDCSubjectClaimCustomTemplate) GetUseDefault() bool {
	if o == nil || o.UseDefault == nil {
		return false
	}
	return *o.UseDefault
}

// GetAdvancedSecurityEnabledForNewRepos returns the AdvancedSecurityEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetAdvancedSecurityEnabledForNewRepos() bool {
	if o == nil || o.AdvancedSecurityEnabledForNewRepos == nil {
		return false
	}
	return *o.AdvancedSecurityEnabledForNewRepos
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetAvatarURL() string {
	if o == nil || o.AvatarURL == nil {
		return ""
	}
	return *o.AvatarURL
}

// GetBillingEmail returns the BillingEmail field if it's non-nil, zero value otherwise.
func (o *Organization) GetBillingEmail() string {
	if o == nil || o.BillingEmail == nil {
		return ""
	}
	return *o.BillingEmail
}

// GetBlog returns the Blog field if it's non-nil, zero value otherwise.
func (o *Organization) GetBlog() string {
	if o == nil || o.Blog == nil {
		return ""
	}
	return *o.Blog
}

// GetCollaborators returns the Collaborators field if it's non-nil, zero value otherwise.
func (o *Organization) GetCollaborators() int {
	if o == nil || o.Collaborators == nil {
		return 0
	}
	return *o.Collaborators
}

// GetCompany returns the Company field if it's non-nil, zero value otherwise.
func (o *Organization) GetCompany() string {
	if o == nil || o.Company == nil {
		return ""
	}
	return *o.Company
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (o *Organization) GetCreatedAt() Timestamp {
	if o == nil || o.CreatedAt == nil {
		return Timestamp{}
	}
	return *o.CreatedAt
}

// GetDefaultRepoPermission returns the DefaultRepoPermission field if it's non-nil, zero value otherwise.
func (o *Organization) GetDefaultRepoPermission() string {
	if o == nil || o.DefaultRepoPermission == nil {
		return ""
	}
	return *o.DefaultRepoPermission
}

// GetDefaultRepoSettings returns the DefaultRepoSettings field if it's non-nil, zero value otherwise.
func (o *Organization) GetDefaultRepoSettings() string {
	if o == nil || o.DefaultRepoSettings == nil {
		return ""
	}
	return *o.DefaultRepoSettings
}

// GetDependabotAlertsEnabledForNewRepos returns the DependabotAlertsEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetDependabotAlertsEnabledForNewRepos() bool {
	if o == nil || o.DependabotAlertsEnabledForNewRepos == nil {
		return false
	}
	return *o.DependabotAlertsEnabledForNewRepos
}

// GetDependabotSecurityUpdatesEnabledForNewRepos returns the DependabotSecurityUpdatesEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetDependabotSecurityUpdatesEnabledForNewRepos() bool {
	if o == nil || o.DependabotSecurityUpdatesEnabledForNewRepos == nil {
		return false
	}
	return *o.DependabotSecurityUpdatesEnabledForNewRepos
}

// GetDependencyGraphEnabledForNewRepos returns the DependencyGraphEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetDependencyGraphEnabledForNewRepos() bool {
	if o == nil || o.DependencyGraphEnabledForNewRepos == nil {
		return false
	}
	return *o.DependencyGraphEnabledForNewRepos
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (o *Organization) GetDescription() string {
	if o == nil || o.Description == nil {
		return ""
	}
	return *o.Description
}

// GetDiskUsage returns the DiskUsage field if it's non-nil, zero value otherwise.
func (o *Organization) GetDiskUsage() int {
	if o == nil || o.DiskUsage == nil {
		return 0
	}
	return *o.DiskUsage
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (o *Organization) GetEmail() string {
	if o == nil || o.Email == nil {
		return ""
	}
	return *o.Email
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetEventsURL() string {
	if o == nil || o.EventsURL == nil {
		return ""
	}
	return *o.EventsURL
}

// GetFollowers returns the Followers field if it's non-nil, zero value otherwise.
func (o *Organization) GetFollowers() int {
	if o == nil || o.Followers == nil {
		return 0
	}
	return *o.Followers
}

// GetFollowing returns the Following field if it's non-nil, zero value otherwise.
func (o *Organization) GetFollowing() int {
	if o == nil || o.Following == nil {
		return 0
	}
	return *o.Following
}

// GetHasOrganizationProjects returns the HasOrganizationProjects field if it's non-nil, zero value otherwise.
func (o *Organization) GetHasOrganizationProjects() bool {
	if o == nil || o.HasOrganizationProjects == nil {
		return false
	}
	return *o.HasOrganizationProjects
}

// GetHasRepositoryProjects returns the HasRepositoryProjects field if it's non-nil, zero value otherwise.
func (o *Organization) GetHasRepositoryProjects() bool {
	if o == nil || o.HasRepositoryProjects == nil {
		return false
	}
	return *o.HasRepositoryProjects
}

// GetHooksURL returns the HooksURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetHooksURL() string {
	if o == nil || o.HooksURL == nil {
		return ""
	}
	return *o.HooksURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetHTMLURL() string {
	if o == nil || o.HTMLURL == nil {
		return ""
	}
	return *o.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (o *Organization) GetID() int64 {
	if o == nil || o.ID == nil {
		return 0
	}
	return *o.ID
}

// GetIssuesURL returns the IssuesURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetIssuesURL() string {
	if o == nil || o.IssuesURL == nil {
		return ""
	}
	return *o.IssuesURL
}

// GetIsVerified returns the IsVerified field if it's non-nil, zero value otherwise.
func (o *Organization) GetIsVerified() bool {
	if o == nil || o.IsVerified == nil {
		return false
	}
	return *o.IsVerified
}

// GetLocation returns the Location field if it's non-nil, zero value otherwise.
func (o *Organization) GetLocation() string {
	if o == nil || o.Location == nil {
		return ""
	}
	return *o.Location
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (o *Organization) GetLogin() string {
	if o == nil || o.Login == nil {
		return ""
	}
	return *o.Login
}

// GetMembersAllowedRepositoryCreationType returns the MembersAllowedRepositoryCreationType field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersAllowedRepositoryCreationType() string {
	if o == nil || o.MembersAllowedRepositoryCreationType == nil {
		return ""
	}
	return *o.MembersAllowedRepositoryCreationType
}

// GetMembersCanCreateInternalRepos returns the MembersCanCreateInternalRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreateInternalRepos() bool {
	if o == nil || o.MembersCanCreateInternalRepos == nil {
		return false
	}
	return *o.MembersCanCreateInternalRepos
}

// GetMembersCanCreatePages returns the MembersCanCreatePages field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreatePages() bool {
	if o == nil || o.MembersCanCreatePages == nil {
		return false
	}
	return *o.MembersCanCreatePages
}

// GetMembersCanCreatePrivatePages returns the MembersCanCreatePrivatePages field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreatePrivatePages() bool {
	if o == nil || o.MembersCanCreatePrivatePages == nil {
		return false
	}
	return *o.MembersCanCreatePrivatePages
}

// GetMembersCanCreatePrivateRepos returns the MembersCanCreatePrivateRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreatePrivateRepos() bool {
	if o == nil || o.MembersCanCreatePrivateRepos == nil {
		return false
	}
	return *o.MembersCanCreatePrivateRepos
}

// GetMembersCanCreatePublicPages returns the MembersCanCreatePublicPages field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreatePublicPages() bool {
	if o == nil || o.MembersCanCreatePublicPages == nil {
		return false
	}
	return *o.MembersCanCreatePublicPages
}

// GetMembersCanCreatePublicRepos returns the MembersCanCreatePublicRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreatePublicRepos() bool {
	if o == nil || o.MembersCanCreatePublicRepos == nil {
		return false
	}
	return *o.MembersCanCreatePublicRepos
}

// GetMembersCanCreateRepos returns the MembersCanCreateRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanCreateRepos() bool {
	if o == nil || o.MembersCanCreateRepos == nil {
		return false
	}
	return *o.MembersCanCreateRepos
}

// GetMembersCanForkPrivateRepos returns the MembersCanForkPrivateRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersCanForkPrivateRepos() bool {
	if o == nil || o.MembersCanForkPrivateRepos == nil {
		return false
	}
	return *o.MembersCanForkPrivateRepos
}

// GetMembersURL returns the MembersURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetMembersURL() string {
	if o == nil || o.MembersURL == nil {
		return ""
	}
	return *o.MembersURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (o *Organization) GetName() string {
	if o == nil || o.Name == nil {
		return ""
	}
	return *o.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (o *Organization) GetNodeID() string {
	if o == nil || o.NodeID == nil {
		return ""
	}
	return *o.NodeID
}

// GetOwnedPrivateRepos returns the OwnedPrivateRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetOwnedPrivateRepos() int64 {
	if o == nil || o.OwnedPrivateRepos == nil {
		return 0
	}
	return *o.OwnedPrivateRepos
}

// GetPlan returns the Plan field.
func (o *Organization) GetPlan() *Plan {
	if o == nil {
		return nil
	}
	return o.Plan
}

// GetPrivateGists returns the PrivateGists field if it's non-nil, zero value otherwise.
func (o *Organization) GetPrivateGists() int {
	if o == nil || o.PrivateGists == nil {
		return 0
	}
	return *o.PrivateGists
}

// GetPublicGists returns the PublicGists field if it's non-nil, zero value otherwise.
func (o *Organization) GetPublicGists() int {
	if o == nil || o.PublicGists == nil {
		return 0
	}
	return *o.PublicGists
}

// GetPublicMembersURL returns the PublicMembersURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetPublicMembersURL() string {
	if o == nil || o.PublicMembersURL == nil {
		return ""
	}
	return *o.PublicMembersURL
}

// GetPublicRepos returns the PublicRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetPublicRepos() int {
	if o == nil || o.PublicRepos == nil {
		return 0
	}
	return *o.PublicRepos
}

// GetReposURL returns the ReposURL field if it's non-nil, zero value otherwise.
func (o *Organization) GetReposURL() string {
	if o == nil || o.ReposURL == nil {
		return ""
	}
	return *o.ReposURL
}

// GetSecretScanningEnabledForNewRepos returns the SecretScanningEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetSecretScanningEnabledForNewRepos() bool {
	if o == nil || o.SecretScanningEnabledForNewRepos == nil {
		return false
	}
	return *o.SecretScanningEnabledForNewRepos
}

// GetSecretScanningPushProtectionEnabledForNewRepos returns the SecretScanningPushProtectionEnabledForNewRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetSecretScanningPushProtectionEnabledForNewRepos() bool {
	if o == nil || o.SecretScanningPushProtectionEnabledForNewRepos == nil {
		return false
	}
	return *o.SecretScanningPushProtectionEnabledForNewRepos
}

// GetSecretScanningValidityChecksEnabled returns the SecretScanningValidityChecksEnabled field if it's non-nil, zero value otherwise.
func (o *Organization) GetSecretScanningValidityChecksEnabled() bool {
	if o == nil || o.SecretScanningValidityChecksEnabled == nil {
		return false
	}
	return *o.SecretScanningValidityChecksEnabled
}

// GetTotalPrivateRepos returns the TotalPrivateRepos field if it's non-nil, zero value otherwise.
func (o *Organization) GetTotalPrivateRepos() int64 {
	if o == nil || o.TotalPrivateRepos == nil {
		return 0
	}
	return *o.TotalPrivateRepos
}

// GetTwitterUsername returns the TwitterUsername field if it's non-nil, zero value otherwise.
func (o *Organization) GetTwitterUsername() string {
	if o == nil || o.TwitterUsername == nil {
		return ""
	}
	return *o.TwitterUsername
}

// GetTwoFactorRequirementEnabled returns the TwoFactorRequirementEnabled field if it's non-nil, zero value otherwise.
func (o *Organization) GetTwoFactorRequirementEnabled() bool {
	if o == nil || o.TwoFactorRequirementEnabled == nil {
		return false
	}
	return *o.TwoFactorRequirementEnabled
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (o *Organization) GetType() string {
	if o == nil || o.Type == nil {
		return ""
	}
	return *o.Type
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (o *Organization) GetUpdatedAt() Timestamp {
	if o == nil || o.UpdatedAt == nil {
		return Timestamp{}
	}
	return *o.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (o *Organization) GetURL() string {
	if o == nil || o.URL == nil {
		return ""
	}
	return *o.URL
}

// GetWebCommitSignoffRequired returns the WebCommitSignoffRequired field if it's non-nil, zero value otherwise.
func (o *Organization) GetWebCommitSignoffRequired() bool {
	if o == nil || o.WebCommitSignoffRequired == nil {
		return false
	}
	return *o.WebCommitSignoffRequired
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (o *OrganizationCustomRepoRoles) GetTotalCount() int {
	if o == nil || o.TotalCount == nil {
		return 0
	}
	return *o.TotalCount
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (o *OrganizationCustomRoles) GetTotalCount() int {
	if o == nil || o.TotalCount == nil {
		return 0
	}
	return *o.TotalCount
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (o *OrganizationEvent) GetAction() string {
	if o == nil || o.Action == nil {
		return ""
	}
	return *o.Action
}

// GetInstallation returns the Installation field.
func (o *OrganizationEvent) GetInstallation() *Installation {
	if o == nil {
		return nil
	}
	return o.Installation
}

// GetInvitation returns the Invitation field.
func (o *OrganizationEvent) GetInvitation() *Invitation {
	if o == nil {
		return nil
	}
	return o.Invitation
}

// GetMembership returns the Membership field.
func (o *OrganizationEvent) GetMembership() *Membership {
	if o == nil {
		return nil
	}
	return o.Membership
}

// GetOrganization returns the Organization field.
func (o *OrganizationEvent) GetOrganization() *Organization {
	if o == nil {
		return nil
	}
	return o.Organization
}

// GetSender returns the Sender field.
func (o *OrganizationEvent) GetSender() *User {
	if o == nil {
		return nil
	}
	return o.Sender
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (o *OrganizationInstallations) GetTotalCount() int {
	if o == nil || o.TotalCount == nil {
		return 0
	}
	return *o.TotalCount
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (o *OrgBlockEvent) GetAction() string {
	if o == nil || o.Action == nil {
		return ""
	}
	return *o.Action
}

// GetBlockedUser returns the BlockedUser field.
func (o *OrgBlockEvent) GetBlockedUser() *User {
	if o == nil {
		return nil
	}
	return o.BlockedUser
}

// GetInstallation returns the Installation field.
func (o *OrgBlockEvent) GetInstallation() *Installation {
	if o == nil {
		return nil
	}
	return o.Installation
}

// GetOrganization returns the Organization field.
func (o *OrgBlockEvent) GetOrganization() *Organization {
	if o == nil {
		return nil
	}
	return o.Organization
}

// GetSender returns the Sender field.
func (o *OrgBlockEvent) GetSender() *User {
	if o == nil {
		return nil
	}
	return o.Sender
}

// GetDisabledOrgs returns the DisabledOrgs field if it's non-nil, zero value otherwise.
func (o *OrgStats) GetDisabledOrgs() int {
	if o == nil || o.DisabledOrgs == nil {
		return 0
	}
	return *o.DisabledOrgs
}

// GetTotalOrgs returns the TotalOrgs field if it's non-nil, zero value otherwise.
func (o *OrgStats) GetTotalOrgs() int {
	if o == nil || o.TotalOrgs == nil {
		return 0
	}
	return *o.TotalOrgs
}

// GetTotalTeamMembers returns the TotalTeamMembers field if it's non-nil, zero value otherwise.
func (o *OrgStats) GetTotalTeamMembers() int {
	if o == nil || o.TotalTeamMembers == nil {
		return 0
	}
	return *o.TotalTeamMembers
}

// GetTotalTeams returns the TotalTeams field if it's non-nil, zero value otherwise.
func (o *OrgStats) GetTotalTeams() int {
	if o == nil || o.TotalTeams == nil {
		return 0
	}
	return *o.TotalTeams
}

// GetOrg returns the Org field.
func (o *OwnerInfo) GetOrg() *User {
	if o == nil {
		return nil
	}
	return o.Org
}

// GetUser returns the User field.
func (o *OwnerInfo) GetUser() *User {
	if o == nil {
		return nil
	}
	return o.User
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *Package) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *Package) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetEcosystem returns the Ecosystem field if it's non-nil, zero value otherwise.
func (p *Package) GetEcosystem() string {
	if p == nil || p.Ecosystem == nil {
		return ""
	}
	return *p.Ecosystem
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *Package) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *Package) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *Package) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNamespace returns the Namespace field if it's non-nil, zero value otherwise.
func (p *Package) GetNamespace() string {
	if p == nil || p.Namespace == nil {
		return ""
	}
	return *p.Namespace
}

// GetOwner returns the Owner field.
func (p *Package) GetOwner() *User {
	if p == nil {
		return nil
	}
	return p.Owner
}

// GetPackageType returns the PackageType field if it's non-nil, zero value otherwise.
func (p *Package) GetPackageType() string {
	if p == nil || p.PackageType == nil {
		return ""
	}
	return *p.PackageType
}

// GetPackageVersion returns the PackageVersion field.
func (p *Package) GetPackageVersion() *PackageVersion {
	if p == nil {
		return nil
	}
	return p.PackageVersion
}

// GetRegistry returns the Registry field.
func (p *Package) GetRegistry() *PackageRegistry {
	if p == nil {
		return nil
	}
	return p.Registry
}

// GetRepository returns the Repository field.
func (p *Package) GetRepository() *Repository {
	if p == nil {
		return nil
	}
	return p.Repository
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *Package) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *Package) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetVersionCount returns the VersionCount field if it's non-nil, zero value otherwise.
func (p *Package) GetVersionCount() int64 {
	if p == nil || p.VersionCount == nil {
		return 0
	}
	return *p.VersionCount
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (p *Package) GetVisibility() string {
	if p == nil || p.Visibility == nil {
		return ""
	}
	return *p.Visibility
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PackageEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetInstallation returns the Installation field.
func (p *PackageEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PackageEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetPackage returns the Package field.
func (p *PackageEvent) GetPackage() *Package {
	if p == nil {
		return nil
	}
	return p.Package
}

// GetRepo returns the Repo field.
func (p *PackageEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PackageEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetLabels returns the Labels map if it's non-nil, an empty map otherwise.
func (p *PackageEventContainerMetadata) GetLabels() map[string]any {
	if p == nil || p.Labels == nil {
		return map[string]any{}
	}
	return p.Labels
}

// GetManifest returns the Manifest map if it's non-nil, an empty map otherwise.
func (p *PackageEventContainerMetadata) GetManifest() map[string]any {
	if p == nil || p.Manifest == nil {
		return map[string]any{}
	}
	return p.Manifest
}

// GetTag returns the Tag field.
func (p *PackageEventContainerMetadata) GetTag() *PackageEventContainerMetadataTag {
	if p == nil {
		return nil
	}
	return p.Tag
}

// GetDigest returns the Digest field if it's non-nil, zero value otherwise.
func (p *PackageEventContainerMetadataTag) GetDigest() string {
	if p == nil || p.Digest == nil {
		return ""
	}
	return *p.Digest
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageEventContainerMetadataTag) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetAuthor returns the Author field.
func (p *PackageFile) GetAuthor() *User {
	if p == nil {
		return nil
	}
	return p.Author
}

// GetContentType returns the ContentType field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetContentType() string {
	if p == nil || p.ContentType == nil {
		return ""
	}
	return *p.ContentType
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDownloadURL returns the DownloadURL field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetDownloadURL() string {
	if p == nil || p.DownloadURL == nil {
		return ""
	}
	return *p.DownloadURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetMD5 returns the MD5 field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetMD5() string {
	if p == nil || p.MD5 == nil {
		return ""
	}
	return *p.MD5
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetSHA1 returns the SHA1 field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetSHA1() string {
	if p == nil || p.SHA1 == nil {
		return ""
	}
	return *p.SHA1
}

// GetSHA256 returns the SHA256 field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetSHA256() string {
	if p == nil || p.SHA256 == nil {
		return ""
	}
	return *p.SHA256
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetSize() int64 {
	if p == nil || p.Size == nil {
		return 0
	}
	return *p.Size
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PackageFile) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetPackageType returns the PackageType field if it's non-nil, zero value otherwise.
func (p *PackageListOptions) GetPackageType() string {
	if p == nil || p.PackageType == nil {
		return ""
	}
	return *p.PackageType
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *PackageListOptions) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (p *PackageListOptions) GetVisibility() string {
	if p == nil || p.Visibility == nil {
		return ""
	}
	return *p.Visibility
}

// GetContainer returns the Container field.
func (p *PackageMetadata) GetContainer() *PackageContainerMetadata {
	if p == nil {
		return nil
	}
	return p.Container
}

// GetPackageType returns the PackageType field if it's non-nil, zero value otherwise.
func (p *PackageMetadata) GetPackageType() string {
	if p == nil || p.PackageType == nil {
		return ""
	}
	return *p.PackageType
}

// GetAuthor returns the Author map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetAuthor() map[string]string {
	if p == nil || p.Author == nil {
		return map[string]string{}
	}
	return p.Author
}

// GetBin returns the Bin map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetBin() map[string]any {
	if p == nil || p.Bin == nil {
		return map[string]any{}
	}
	return p.Bin
}

// GetBugs returns the Bugs map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetBugs() map[string]string {
	if p == nil || p.Bugs == nil {
		return map[string]string{}
	}
	return p.Bugs
}

// GetCommitOID returns the CommitOID field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetCommitOID() string {
	if p == nil || p.CommitOID == nil {
		return ""
	}
	return *p.CommitOID
}

// GetDeletedByID returns the DeletedByID field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetDeletedByID() int64 {
	if p == nil || p.DeletedByID == nil {
		return 0
	}
	return *p.DeletedByID
}

// GetDependencies returns the Dependencies map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetDependencies() map[string]string {
	if p == nil || p.Dependencies == nil {
		return map[string]string{}
	}
	return p.Dependencies
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetDevDependencies returns the DevDependencies map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetDevDependencies() map[string]string {
	if p == nil || p.DevDependencies == nil {
		return map[string]string{}
	}
	return p.DevDependencies
}

// GetDirectories returns the Directories map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetDirectories() map[string]string {
	if p == nil || p.Directories == nil {
		return map[string]string{}
	}
	return p.Directories
}

// GetDist returns the Dist map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetDist() map[string]string {
	if p == nil || p.Dist == nil {
		return map[string]string{}
	}
	return p.Dist
}

// GetEngines returns the Engines map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetEngines() map[string]string {
	if p == nil || p.Engines == nil {
		return map[string]string{}
	}
	return p.Engines
}

// GetGitHead returns the GitHead field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetGitHead() string {
	if p == nil || p.GitHead == nil {
		return ""
	}
	return *p.GitHead
}

// GetHasShrinkwrap returns the HasShrinkwrap field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetHasShrinkwrap() bool {
	if p == nil || p.HasShrinkwrap == nil {
		return false
	}
	return *p.HasShrinkwrap
}

// GetHomepage returns the Homepage field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetHomepage() string {
	if p == nil || p.Homepage == nil {
		return ""
	}
	return *p.Homepage
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetID() string {
	if p == nil || p.ID == nil {
		return ""
	}
	return *p.ID
}

// GetInstallationCommand returns the InstallationCommand field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetInstallationCommand() string {
	if p == nil || p.InstallationCommand == nil {
		return ""
	}
	return *p.InstallationCommand
}

// GetLicense returns the License field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetLicense() string {
	if p == nil || p.License == nil {
		return ""
	}
	return *p.License
}

// GetMain returns the Main field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetMain() string {
	if p == nil || p.Main == nil {
		return ""
	}
	return *p.Main
}

// GetMan returns the Man map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetMan() map[string]any {
	if p == nil || p.Man == nil {
		return map[string]any{}
	}
	return p.Man
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNodeVersion returns the NodeVersion field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetNodeVersion() string {
	if p == nil || p.NodeVersion == nil {
		return ""
	}
	return *p.NodeVersion
}

// GetNPMUser returns the NPMUser field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetNPMUser() string {
	if p == nil || p.NPMUser == nil {
		return ""
	}
	return *p.NPMUser
}

// GetNPMVersion returns the NPMVersion field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetNPMVersion() string {
	if p == nil || p.NPMVersion == nil {
		return ""
	}
	return *p.NPMVersion
}

// GetOptionalDependencies returns the OptionalDependencies map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetOptionalDependencies() map[string]string {
	if p == nil || p.OptionalDependencies == nil {
		return map[string]string{}
	}
	return p.OptionalDependencies
}

// GetPeerDependencies returns the PeerDependencies map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetPeerDependencies() map[string]string {
	if p == nil || p.PeerDependencies == nil {
		return map[string]string{}
	}
	return p.PeerDependencies
}

// GetPublishedViaActions returns the PublishedViaActions field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetPublishedViaActions() bool {
	if p == nil || p.PublishedViaActions == nil {
		return false
	}
	return *p.PublishedViaActions
}

// GetReadme returns the Readme field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetReadme() string {
	if p == nil || p.Readme == nil {
		return ""
	}
	return *p.Readme
}

// GetReleaseID returns the ReleaseID field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetReleaseID() int64 {
	if p == nil || p.ReleaseID == nil {
		return 0
	}
	return *p.ReleaseID
}

// GetRepository returns the Repository map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetRepository() map[string]string {
	if p == nil || p.Repository == nil {
		return map[string]string{}
	}
	return p.Repository
}

// GetScripts returns the Scripts map if it's non-nil, an empty map otherwise.
func (p *PackageNPMMetadata) GetScripts() map[string]any {
	if p == nil || p.Scripts == nil {
		return map[string]any{}
	}
	return p.Scripts
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (p *PackageNPMMetadata) GetVersion() string {
	if p == nil || p.Version == nil {
		return ""
	}
	return *p.Version
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageNugetMetadata) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetAboutURL returns the AboutURL field if it's non-nil, zero value otherwise.
func (p *PackageRegistry) GetAboutURL() string {
	if p == nil || p.AboutURL == nil {
		return ""
	}
	return *p.AboutURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageRegistry) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (p *PackageRegistry) GetType() string {
	if p == nil || p.Type == nil {
		return ""
	}
	return *p.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PackageRegistry) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetVendor returns the Vendor field if it's non-nil, zero value otherwise.
func (p *PackageRegistry) GetVendor() string {
	if p == nil || p.Vendor == nil {
		return ""
	}
	return *p.Vendor
}

// GetAuthor returns the Author field.
func (p *PackageRelease) GetAuthor() *User {
	if p == nil {
		return nil
	}
	return p.Author
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetDraft() bool {
	if p == nil || p.Draft == nil {
		return false
	}
	return *p.Draft
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetPrerelease returns the Prerelease field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetPrerelease() bool {
	if p == nil || p.Prerelease == nil {
		return false
	}
	return *p.Prerelease
}

// GetPublishedAt returns the PublishedAt field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetPublishedAt() Timestamp {
	if p == nil || p.PublishedAt == nil {
		return Timestamp{}
	}
	return *p.PublishedAt
}

// GetTagName returns the TagName field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetTagName() string {
	if p == nil || p.TagName == nil {
		return ""
	}
	return *p.TagName
}

// GetTargetCommitish returns the TargetCommitish field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetTargetCommitish() string {
	if p == nil || p.TargetCommitish == nil {
		return ""
	}
	return *p.TargetCommitish
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PackageRelease) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetAuthor returns the Author field.
func (p *PackageVersion) GetAuthor() *User {
	if p == nil {
		return nil
	}
	return p.Author
}

// GetBodyHTML returns the BodyHTML field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetBodyHTML() string {
	if p == nil || p.BodyHTML == nil {
		return ""
	}
	return *p.BodyHTML
}

// GetContainerMetadata returns the ContainerMetadata field.
func (p *PackageVersion) GetContainerMetadata() *PackageEventContainerMetadata {
	if p == nil {
		return nil
	}
	return p.ContainerMetadata
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDeletedAt returns the DeletedAt field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetDeletedAt() Timestamp {
	if p == nil || p.DeletedAt == nil {
		return Timestamp{}
	}
	return *p.DeletedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetDraft() bool {
	if p == nil || p.Draft == nil {
		return false
	}
	return *p.Draft
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetInstallationCommand returns the InstallationCommand field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetInstallationCommand() string {
	if p == nil || p.InstallationCommand == nil {
		return ""
	}
	return *p.InstallationCommand
}

// GetLicense returns the License field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetLicense() string {
	if p == nil || p.License == nil {
		return ""
	}
	return *p.License
}

// GetManifest returns the Manifest field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetManifest() string {
	if p == nil || p.Manifest == nil {
		return ""
	}
	return *p.Manifest
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNPMMetadata returns the NPMMetadata field.
func (p *PackageVersion) GetNPMMetadata() *PackageNPMMetadata {
	if p == nil {
		return nil
	}
	return p.NPMMetadata
}

// GetPackageHTMLURL returns the PackageHTMLURL field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetPackageHTMLURL() string {
	if p == nil || p.PackageHTMLURL == nil {
		return ""
	}
	return *p.PackageHTMLURL
}

// GetPackageURL returns the PackageURL field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetPackageURL() string {
	if p == nil || p.PackageURL == nil {
		return ""
	}
	return *p.PackageURL
}

// GetPrerelease returns the Prerelease field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetPrerelease() bool {
	if p == nil || p.Prerelease == nil {
		return false
	}
	return *p.Prerelease
}

// GetRelease returns the Release field.
func (p *PackageVersion) GetRelease() *PackageRelease {
	if p == nil {
		return nil
	}
	return p.Release
}

// GetRubyMetadata returns the RubyMetadata map if it's non-nil, an empty map otherwise.
func (p *PackageVersion) GetRubyMetadata() map[string]any {
	if p == nil || p.RubyMetadata == nil {
		return map[string]any{}
	}
	return p.RubyMetadata
}

// GetSourceURL returns the SourceURL field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetSourceURL() string {
	if p == nil || p.SourceURL == nil {
		return ""
	}
	return *p.SourceURL
}

// GetSummary returns the Summary field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetSummary() string {
	if p == nil || p.Summary == nil {
		return ""
	}
	return *p.Summary
}

// GetTagName returns the TagName field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetTagName() string {
	if p == nil || p.TagName == nil {
		return ""
	}
	return *p.TagName
}

// GetTargetCommitish returns the TargetCommitish field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetTargetCommitish() string {
	if p == nil || p.TargetCommitish == nil {
		return ""
	}
	return *p.TargetCommitish
}

// GetTargetOID returns the TargetOID field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetTargetOID() string {
	if p == nil || p.TargetOID == nil {
		return ""
	}
	return *p.TargetOID
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (p *PackageVersion) GetVersion() string {
	if p == nil || p.Version == nil {
		return ""
	}
	return *p.Version
}

// GetInfo returns the Info field.
func (p *PackageVersionBody) GetInfo() *PackageVersionBodyInfo {
	if p == nil {
		return nil
	}
	return p.Info
}

// GetRepo returns the Repo field.
func (p *PackageVersionBody) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetCollection returns the Collection field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetCollection() bool {
	if p == nil || p.Collection == nil {
		return false
	}
	return *p.Collection
}

// GetMode returns the Mode field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetMode() int64 {
	if p == nil || p.Mode == nil {
		return 0
	}
	return *p.Mode
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetOID returns the OID field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetOID() string {
	if p == nil || p.OID == nil {
		return ""
	}
	return *p.OID
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetPath() string {
	if p == nil || p.Path == nil {
		return ""
	}
	return *p.Path
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetSize() int64 {
	if p == nil || p.Size == nil {
		return 0
	}
	return *p.Size
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (p *PackageVersionBodyInfo) GetType() string {
	if p == nil || p.Type == nil {
		return ""
	}
	return *p.Type
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *Page) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *Page) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetPageName returns the PageName field if it's non-nil, zero value otherwise.
func (p *Page) GetPageName() string {
	if p == nil || p.PageName == nil {
		return ""
	}
	return *p.PageName
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (p *Page) GetSHA() string {
	if p == nil || p.SHA == nil {
		return ""
	}
	return *p.SHA
}

// GetSummary returns the Summary field if it's non-nil, zero value otherwise.
func (p *Page) GetSummary() string {
	if p == nil || p.Summary == nil {
		return ""
	}
	return *p.Summary
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (p *Page) GetTitle() string {
	if p == nil || p.Title == nil {
		return ""
	}
	return *p.Title
}

// GetBuild returns the Build field.
func (p *PageBuildEvent) GetBuild() *PagesBuild {
	if p == nil {
		return nil
	}
	return p.Build
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PageBuildEvent) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetInstallation returns the Installation field.
func (p *PageBuildEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PageBuildEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetRepo returns the Repo field.
func (p *PageBuildEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PageBuildEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetBuildType returns the BuildType field if it's non-nil, zero value otherwise.
func (p *Pages) GetBuildType() string {
	if p == nil || p.BuildType == nil {
		return ""
	}
	return *p.BuildType
}

// GetCNAME returns the CNAME field if it's non-nil, zero value otherwise.
func (p *Pages) GetCNAME() string {
	if p == nil || p.CNAME == nil {
		return ""
	}
	return *p.CNAME
}

// GetCustom404 returns the Custom404 field if it's non-nil, zero value otherwise.
func (p *Pages) GetCustom404() bool {
	if p == nil || p.Custom404 == nil {
		return false
	}
	return *p.Custom404
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *Pages) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetHTTPSCertificate returns the HTTPSCertificate field.
func (p *Pages) GetHTTPSCertificate() *PagesHTTPSCertificate {
	if p == nil {
		return nil
	}
	return p.HTTPSCertificate
}

// GetHTTPSEnforced returns the HTTPSEnforced field if it's non-nil, zero value otherwise.
func (p *Pages) GetHTTPSEnforced() bool {
	if p == nil || p.HTTPSEnforced == nil {
		return false
	}
	return *p.HTTPSEnforced
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (p *Pages) GetPublic() bool {
	if p == nil || p.Public == nil {
		return false
	}
	return *p.Public
}

// GetSource returns the Source field.
func (p *Pages) GetSource() *PagesSource {
	if p == nil {
		return nil
	}
	return p.Source
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (p *Pages) GetStatus() string {
	if p == nil || p.Status == nil {
		return ""
	}
	return *p.Status
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *Pages) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetCommit returns the Commit field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetCommit() string {
	if p == nil || p.Commit == nil {
		return ""
	}
	return *p.Commit
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDuration returns the Duration field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetDuration() int {
	if p == nil || p.Duration == nil {
		return 0
	}
	return *p.Duration
}

// GetError returns the Error field.
func (p *PagesBuild) GetError() *PagesError {
	if p == nil {
		return nil
	}
	return p.Error
}

// GetPusher returns the Pusher field.
func (p *PagesBuild) GetPusher() *User {
	if p == nil {
		return nil
	}
	return p.Pusher
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetStatus() string {
	if p == nil || p.Status == nil {
		return ""
	}
	return *p.Status
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PagesBuild) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetCAAError returns the CAAError field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetCAAError() string {
	if p == nil || p.CAAError == nil {
		return ""
	}
	return *p.CAAError
}

// GetDNSResolves returns the DNSResolves field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetDNSResolves() bool {
	if p == nil || p.DNSResolves == nil {
		return false
	}
	return *p.DNSResolves
}

// GetEnforcesHTTPS returns the EnforcesHTTPS field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetEnforcesHTTPS() bool {
	if p == nil || p.EnforcesHTTPS == nil {
		return false
	}
	return *p.EnforcesHTTPS
}

// GetHasCNAMERecord returns the HasCNAMERecord field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetHasCNAMERecord() bool {
	if p == nil || p.HasCNAMERecord == nil {
		return false
	}
	return *p.HasCNAMERecord
}

// GetHasMXRecordsPresent returns the HasMXRecordsPresent field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetHasMXRecordsPresent() bool {
	if p == nil || p.HasMXRecordsPresent == nil {
		return false
	}
	return *p.HasMXRecordsPresent
}

// GetHost returns the Host field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetHost() string {
	if p == nil || p.Host == nil {
		return ""
	}
	return *p.Host
}

// GetHTTPSError returns the HTTPSError field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetHTTPSError() string {
	if p == nil || p.HTTPSError == nil {
		return ""
	}
	return *p.HTTPSError
}

// GetIsApexDomain returns the IsApexDomain field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsApexDomain() bool {
	if p == nil || p.IsApexDomain == nil {
		return false
	}
	return *p.IsApexDomain
}

// GetIsARecord returns the IsARecord field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsARecord() bool {
	if p == nil || p.IsARecord == nil {
		return false
	}
	return *p.IsARecord
}

// GetIsCloudflareIP returns the IsCloudflareIP field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsCloudflareIP() bool {
	if p == nil || p.IsCloudflareIP == nil {
		return false
	}
	return *p.IsCloudflareIP
}

// GetIsCNAMEToFastly returns the IsCNAMEToFastly field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsCNAMEToFastly() bool {
	if p == nil || p.IsCNAMEToFastly == nil {
		return false
	}
	return *p.IsCNAMEToFastly
}

// GetIsCNAMEToGithubUserDomain returns the IsCNAMEToGithubUserDomain field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsCNAMEToGithubUserDomain() bool {
	if p == nil || p.IsCNAMEToGithubUserDomain == nil {
		return false
	}
	return *p.IsCNAMEToGithubUserDomain
}

// GetIsCNAMEToPagesDotGithubDotCom returns the IsCNAMEToPagesDotGithubDotCom field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsCNAMEToPagesDotGithubDotCom() bool {
	if p == nil || p.IsCNAMEToPagesDotGithubDotCom == nil {
		return false
	}
	return *p.IsCNAMEToPagesDotGithubDotCom
}

// GetIsFastlyIP returns the IsFastlyIP field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsFastlyIP() bool {
	if p == nil || p.IsFastlyIP == nil {
		return false
	}
	return *p.IsFastlyIP
}

// GetIsHTTPSEligible returns the IsHTTPSEligible field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsHTTPSEligible() bool {
	if p == nil || p.IsHTTPSEligible == nil {
		return false
	}
	return *p.IsHTTPSEligible
}

// GetIsNonGithubPagesIPPresent returns the IsNonGithubPagesIPPresent field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsNonGithubPagesIPPresent() bool {
	if p == nil || p.IsNonGithubPagesIPPresent == nil {
		return false
	}
	return *p.IsNonGithubPagesIPPresent
}

// GetIsOldIPAddress returns the IsOldIPAddress field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsOldIPAddress() bool {
	if p == nil || p.IsOldIPAddress == nil {
		return false
	}
	return *p.IsOldIPAddress
}

// GetIsPagesDomain returns the IsPagesDomain field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsPagesDomain() bool {
	if p == nil || p.IsPagesDomain == nil {
		return false
	}
	return *p.IsPagesDomain
}

// GetIsPointedToGithubPagesIP returns the IsPointedToGithubPagesIP field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsPointedToGithubPagesIP() bool {
	if p == nil || p.IsPointedToGithubPagesIP == nil {
		return false
	}
	return *p.IsPointedToGithubPagesIP
}

// GetIsProxied returns the IsProxied field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsProxied() bool {
	if p == nil || p.IsProxied == nil {
		return false
	}
	return *p.IsProxied
}

// GetIsServedByPages returns the IsServedByPages field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsServedByPages() bool {
	if p == nil || p.IsServedByPages == nil {
		return false
	}
	return *p.IsServedByPages
}

// GetIsValid returns the IsValid field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsValid() bool {
	if p == nil || p.IsValid == nil {
		return false
	}
	return *p.IsValid
}

// GetIsValidDomain returns the IsValidDomain field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetIsValidDomain() bool {
	if p == nil || p.IsValidDomain == nil {
		return false
	}
	return *p.IsValidDomain
}

// GetNameservers returns the Nameservers field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetNameservers() string {
	if p == nil || p.Nameservers == nil {
		return ""
	}
	return *p.Nameservers
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetReason() string {
	if p == nil || p.Reason == nil {
		return ""
	}
	return *p.Reason
}

// GetRespondsToHTTPS returns the RespondsToHTTPS field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetRespondsToHTTPS() bool {
	if p == nil || p.RespondsToHTTPS == nil {
		return false
	}
	return *p.RespondsToHTTPS
}

// GetShouldBeARecord returns the ShouldBeARecord field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetShouldBeARecord() bool {
	if p == nil || p.ShouldBeARecord == nil {
		return false
	}
	return *p.ShouldBeARecord
}

// GetURI returns the URI field if it's non-nil, zero value otherwise.
func (p *PagesDomain) GetURI() string {
	if p == nil || p.URI == nil {
		return ""
	}
	return *p.URI
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (p *PagesError) GetMessage() string {
	if p == nil || p.Message == nil {
		return ""
	}
	return *p.Message
}

// GetAltDomain returns the AltDomain field.
func (p *PagesHealthCheckResponse) GetAltDomain() *PagesDomain {
	if p == nil {
		return nil
	}
	return p.AltDomain
}

// GetDomain returns the Domain field.
func (p *PagesHealthCheckResponse) GetDomain() *PagesDomain {
	if p == nil {
		return nil
	}
	return p.Domain
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *PagesHTTPSCertificate) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (p *PagesHTTPSCertificate) GetExpiresAt() string {
	if p == nil || p.ExpiresAt == nil {
		return ""
	}
	return *p.ExpiresAt
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *PagesHTTPSCertificate) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetBranch returns the Branch field if it's non-nil, zero value otherwise.
func (p *PagesSource) GetBranch() string {
	if p == nil || p.Branch == nil {
		return ""
	}
	return *p.Branch
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (p *PagesSource) GetPath() string {
	if p == nil || p.Path == nil {
		return ""
	}
	return *p.Path
}

// GetTotalPages returns the TotalPages field if it's non-nil, zero value otherwise.
func (p *PageStats) GetTotalPages() int {
	if p == nil || p.TotalPages == nil {
		return 0
	}
	return *p.TotalPages
}

// GetBuildType returns the BuildType field if it's non-nil, zero value otherwise.
func (p *PagesUpdate) GetBuildType() string {
	if p == nil || p.BuildType == nil {
		return ""
	}
	return *p.BuildType
}

// GetCNAME returns the CNAME field if it's non-nil, zero value otherwise.
func (p *PagesUpdate) GetCNAME() string {
	if p == nil || p.CNAME == nil {
		return ""
	}
	return *p.CNAME
}

// GetHTTPSEnforced returns the HTTPSEnforced field if it's non-nil, zero value otherwise.
func (p *PagesUpdate) GetHTTPSEnforced() bool {
	if p == nil || p.HTTPSEnforced == nil {
		return false
	}
	return *p.HTTPSEnforced
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (p *PagesUpdate) GetPublic() bool {
	if p == nil || p.Public == nil {
		return false
	}
	return *p.Public
}

// GetSource returns the Source field.
func (p *PagesUpdate) GetSource() *PagesSource {
	if p == nil {
		return nil
	}
	return p.Source
}

// GetBuildType returns the BuildType field if it's non-nil, zero value otherwise.
func (p *PagesUpdateWithoutCNAME) GetBuildType() string {
	if p == nil || p.BuildType == nil {
		return ""
	}
	return *p.BuildType
}

// GetHTTPSEnforced returns the HTTPSEnforced field if it's non-nil, zero value otherwise.
func (p *PagesUpdateWithoutCNAME) GetHTTPSEnforced() bool {
	if p == nil || p.HTTPSEnforced == nil {
		return false
	}
	return *p.HTTPSEnforced
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (p *PagesUpdateWithoutCNAME) GetPublic() bool {
	if p == nil || p.Public == nil {
		return false
	}
	return *p.Public
}

// GetSource returns the Source field.
func (p *PagesUpdateWithoutCNAME) GetSource() *PagesSource {
	if p == nil {
		return nil
	}
	return p.Source
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PatternRuleParameters) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNegate returns the Negate field if it's non-nil, zero value otherwise.
func (p *PatternRuleParameters) GetNegate() bool {
	if p == nil || p.Negate == nil {
		return false
	}
	return *p.Negate
}

// GetCurrentUserCanApprove returns the CurrentUserCanApprove field if it's non-nil, zero value otherwise.
func (p *PendingDeployment) GetCurrentUserCanApprove() bool {
	if p == nil || p.CurrentUserCanApprove == nil {
		return false
	}
	return *p.CurrentUserCanApprove
}

// GetEnvironment returns the Environment field.
func (p *PendingDeployment) GetEnvironment() *PendingDeploymentEnvironment {
	if p == nil {
		return nil
	}
	return p.Environment
}

// GetWaitTimer returns the WaitTimer field if it's non-nil, zero value otherwise.
func (p *PendingDeployment) GetWaitTimer() int64 {
	if p == nil || p.WaitTimer == nil {
		return 0
	}
	return *p.WaitTimer
}

// GetWaitTimerStartedAt returns the WaitTimerStartedAt field if it's non-nil, zero value otherwise.
func (p *PendingDeployment) GetWaitTimerStartedAt() Timestamp {
	if p == nil || p.WaitTimerStartedAt == nil {
		return Timestamp{}
	}
	return *p.WaitTimerStartedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PendingDeploymentEnvironment) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PendingDeploymentEnvironment) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PendingDeploymentEnvironment) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PendingDeploymentEnvironment) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PendingDeploymentEnvironment) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetAccessGrantedAt returns the AccessGrantedAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetAccessGrantedAt() Timestamp {
	if p == nil || p.AccessGrantedAt == nil {
		return Timestamp{}
	}
	return *p.AccessGrantedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetOwner returns the Owner field.
func (p *PersonalAccessToken) GetOwner() *User {
	if p == nil {
		return nil
	}
	return p.Owner
}

// GetPermissions returns the Permissions field.
func (p *PersonalAccessToken) GetPermissions() *PersonalAccessTokenPermissions {
	if p == nil {
		return nil
	}
	return p.Permissions
}

// GetRepositoriesURL returns the RepositoriesURL field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetRepositoriesURL() string {
	if p == nil || p.RepositoriesURL == nil {
		return ""
	}
	return *p.RepositoriesURL
}

// GetRepositorySelection returns the RepositorySelection field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetRepositorySelection() string {
	if p == nil || p.RepositorySelection == nil {
		return ""
	}
	return *p.RepositorySelection
}

// GetTokenExpired returns the TokenExpired field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetTokenExpired() bool {
	if p == nil || p.TokenExpired == nil {
		return false
	}
	return *p.TokenExpired
}

// GetTokenExpiresAt returns the TokenExpiresAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetTokenExpiresAt() Timestamp {
	if p == nil || p.TokenExpiresAt == nil {
		return Timestamp{}
	}
	return *p.TokenExpiresAt
}

// GetTokenID returns the TokenID field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetTokenID() int64 {
	if p == nil || p.TokenID == nil {
		return 0
	}
	return *p.TokenID
}

// GetTokenLastUsedAt returns the TokenLastUsedAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetTokenLastUsedAt() Timestamp {
	if p == nil || p.TokenLastUsedAt == nil {
		return Timestamp{}
	}
	return *p.TokenLastUsedAt
}

// GetTokenName returns the TokenName field if it's non-nil, zero value otherwise.
func (p *PersonalAccessToken) GetTokenName() string {
	if p == nil || p.TokenName == nil {
		return ""
	}
	return *p.TokenName
}

// GetOrg returns the Org map if it's non-nil, an empty map otherwise.
func (p *PersonalAccessTokenPermissions) GetOrg() map[string]string {
	if p == nil || p.Org == nil {
		return map[string]string{}
	}
	return p.Org
}

// GetOther returns the Other map if it's non-nil, an empty map otherwise.
func (p *PersonalAccessTokenPermissions) GetOther() map[string]string {
	if p == nil || p.Other == nil {
		return map[string]string{}
	}
	return p.Other
}

// GetRepo returns the Repo map if it's non-nil, an empty map otherwise.
func (p *PersonalAccessTokenPermissions) GetRepo() map[string]string {
	if p == nil || p.Repo == nil {
		return map[string]string{}
	}
	return p.Repo
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetOrg returns the Org field.
func (p *PersonalAccessTokenRequest) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetOwner returns the Owner field.
func (p *PersonalAccessTokenRequest) GetOwner() *User {
	if p == nil {
		return nil
	}
	return p.Owner
}

// GetPermissionsAdded returns the PermissionsAdded field.
func (p *PersonalAccessTokenRequest) GetPermissionsAdded() *PersonalAccessTokenPermissions {
	if p == nil {
		return nil
	}
	return p.PermissionsAdded
}

// GetPermissionsResult returns the PermissionsResult field.
func (p *PersonalAccessTokenRequest) GetPermissionsResult() *PersonalAccessTokenPermissions {
	if p == nil {
		return nil
	}
	return p.PermissionsResult
}

// GetPermissionsUpgraded returns the PermissionsUpgraded field.
func (p *PersonalAccessTokenRequest) GetPermissionsUpgraded() *PersonalAccessTokenPermissions {
	if p == nil {
		return nil
	}
	return p.PermissionsUpgraded
}

// GetRepositoryCount returns the RepositoryCount field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetRepositoryCount() int64 {
	if p == nil || p.RepositoryCount == nil {
		return 0
	}
	return *p.RepositoryCount
}

// GetRepositorySelection returns the RepositorySelection field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetRepositorySelection() string {
	if p == nil || p.RepositorySelection == nil {
		return ""
	}
	return *p.RepositorySelection
}

// GetTokenExpired returns the TokenExpired field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetTokenExpired() bool {
	if p == nil || p.TokenExpired == nil {
		return false
	}
	return *p.TokenExpired
}

// GetTokenExpiresAt returns the TokenExpiresAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetTokenExpiresAt() Timestamp {
	if p == nil || p.TokenExpiresAt == nil {
		return Timestamp{}
	}
	return *p.TokenExpiresAt
}

// GetTokenLastUsedAt returns the TokenLastUsedAt field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequest) GetTokenLastUsedAt() Timestamp {
	if p == nil || p.TokenLastUsedAt == nil {
		return Timestamp{}
	}
	return *p.TokenLastUsedAt
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PersonalAccessTokenRequestEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetInstallation returns the Installation field.
func (p *PersonalAccessTokenRequestEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PersonalAccessTokenRequestEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetPersonalAccessTokenRequest returns the PersonalAccessTokenRequest field.
func (p *PersonalAccessTokenRequestEvent) GetPersonalAccessTokenRequest() *PersonalAccessTokenRequest {
	if p == nil {
		return nil
	}
	return p.PersonalAccessTokenRequest
}

// GetSender returns the Sender field.
func (p *PersonalAccessTokenRequestEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetHook returns the Hook field.
func (p *PingEvent) GetHook() *Hook {
	if p == nil {
		return nil
	}
	return p.Hook
}

// GetHookID returns the HookID field if it's non-nil, zero value otherwise.
func (p *PingEvent) GetHookID() int64 {
	if p == nil || p.HookID == nil {
		return 0
	}
	return *p.HookID
}

// GetInstallation returns the Installation field.
func (p *PingEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PingEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetRepo returns the Repo field.
func (p *PingEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PingEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetZen returns the Zen field if it's non-nil, zero value otherwise.
func (p *PingEvent) GetZen() string {
	if p == nil || p.Zen == nil {
		return ""
	}
	return *p.Zen
}

// GetCollaborators returns the Collaborators field if it's non-nil, zero value otherwise.
func (p *Plan) GetCollaborators() int {
	if p == nil || p.Collaborators == nil {
		return 0
	}
	return *p.Collaborators
}

// GetFilledSeats returns the FilledSeats field if it's non-nil, zero value otherwise.
func (p *Plan) GetFilledSeats() int {
	if p == nil || p.FilledSeats == nil {
		return 0
	}
	return *p.FilledSeats
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *Plan) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetPrivateRepos returns the PrivateRepos field if it's non-nil, zero value otherwise.
func (p *Plan) GetPrivateRepos() int64 {
	if p == nil || p.PrivateRepos == nil {
		return 0
	}
	return *p.PrivateRepos
}

// GetSeats returns the Seats field if it's non-nil, zero value otherwise.
func (p *Plan) GetSeats() int {
	if p == nil || p.Seats == nil {
		return 0
	}
	return *p.Seats
}

// GetSpace returns the Space field if it's non-nil, zero value otherwise.
func (p *Plan) GetSpace() int {
	if p == nil || p.Space == nil {
		return 0
	}
	return *p.Space
}

// GetConfigURL returns the ConfigURL field if it's non-nil, zero value otherwise.
func (p *PreReceiveHook) GetConfigURL() string {
	if p == nil || p.ConfigURL == nil {
		return ""
	}
	return *p.ConfigURL
}

// GetEnforcement returns the Enforcement field if it's non-nil, zero value otherwise.
func (p *PreReceiveHook) GetEnforcement() string {
	if p == nil || p.Enforcement == nil {
		return ""
	}
	return *p.Enforcement
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PreReceiveHook) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PreReceiveHook) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetHRef returns the HRef field if it's non-nil, zero value otherwise.
func (p *PRLink) GetHRef() string {
	if p == nil || p.HRef == nil {
		return ""
	}
	return *p.HRef
}

// GetComments returns the Comments field.
func (p *PRLinks) GetComments() *PRLink {
	if p == nil {
		return nil
	}
	return p.Comments
}

// GetCommits returns the Commits field.
func (p *PRLinks) GetCommits() *PRLink {
	if p == nil {
		return nil
	}
	return p.Commits
}

// GetHTML returns the HTML field.
func (p *PRLinks) GetHTML() *PRLink {
	if p == nil {
		return nil
	}
	return p.HTML
}

// GetIssue returns the Issue field.
func (p *PRLinks) GetIssue() *PRLink {
	if p == nil {
		return nil
	}
	return p.Issue
}

// GetReviewComment returns the ReviewComment field.
func (p *PRLinks) GetReviewComment() *PRLink {
	if p == nil {
		return nil
	}
	return p.ReviewComment
}

// GetReviewComments returns the ReviewComments field.
func (p *PRLinks) GetReviewComments() *PRLink {
	if p == nil {
		return nil
	}
	return p.ReviewComments
}

// GetSelf returns the Self field.
func (p *PRLinks) GetSelf() *PRLink {
	if p == nil {
		return nil
	}
	return p.Self
}

// GetStatuses returns the Statuses field.
func (p *PRLinks) GetStatuses() *PRLink {
	if p == nil {
		return nil
	}
	return p.Statuses
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (p *ProjectBody) GetFrom() string {
	if p == nil || p.From == nil {
		return ""
	}
	return *p.From
}

// GetNote returns the Note field.
func (p *ProjectCardChange) GetNote() *ProjectCardNote {
	if p == nil {
		return nil
	}
	return p.Note
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (p *ProjectCardNote) GetFrom() string {
	if p == nil || p.From == nil {
		return ""
	}
	return *p.From
}

// GetBody returns the Body field.
func (p *ProjectChange) GetBody() *ProjectBody {
	if p == nil {
		return nil
	}
	return p.Body
}

// GetName returns the Name field.
func (p *ProjectChange) GetName() *ProjectName {
	if p == nil {
		return nil
	}
	return p.Name
}

// GetName returns the Name field.
func (p *ProjectColumnChange) GetName() *ProjectColumnName {
	if p == nil {
		return nil
	}
	return p.Name
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (p *ProjectColumnName) GetFrom() string {
	if p == nil || p.From == nil {
		return ""
	}
	return *p.From
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (p *ProjectName) GetFrom() string {
	if p == nil || p.From == nil {
		return ""
	}
	return *p.From
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetBody() string {
	if p == nil || p.Body == nil {
		return ""
	}
	return *p.Body
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetClosedAt() Timestamp {
	if p == nil || p.ClosedAt == nil {
		return Timestamp{}
	}
	return *p.ClosedAt
}

// GetColumnsURL returns the ColumnsURL field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetColumnsURL() string {
	if p == nil || p.ColumnsURL == nil {
		return ""
	}
	return *p.ColumnsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetCreator returns the Creator field.
func (p *ProjectV2) GetCreator() *User {
	if p == nil {
		return nil
	}
	return p.Creator
}

// GetDeletedAt returns the DeletedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetDeletedAt() Timestamp {
	if p == nil || p.DeletedAt == nil {
		return Timestamp{}
	}
	return *p.DeletedAt
}

// GetDeletedBy returns the DeletedBy field.
func (p *ProjectV2) GetDeletedBy() *User {
	if p == nil {
		return nil
	}
	return p.DeletedBy
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetNumber() int {
	if p == nil || p.Number == nil {
		return 0
	}
	return *p.Number
}

// GetOrganizationPermission returns the OrganizationPermission field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetOrganizationPermission() string {
	if p == nil || p.OrganizationPermission == nil {
		return ""
	}
	return *p.OrganizationPermission
}

// GetOwner returns the Owner field.
func (p *ProjectV2) GetOwner() *User {
	if p == nil {
		return nil
	}
	return p.Owner
}

// GetOwnerURL returns the OwnerURL field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetOwnerURL() string {
	if p == nil || p.OwnerURL == nil {
		return ""
	}
	return *p.OwnerURL
}

// GetPrivate returns the Private field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetPrivate() bool {
	if p == nil || p.Private == nil {
		return false
	}
	return *p.Private
}

// GetPublic returns the Public field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetPublic() bool {
	if p == nil || p.Public == nil {
		return false
	}
	return *p.Public
}

// GetShortDescription returns the ShortDescription field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetShortDescription() string {
	if p == nil || p.ShortDescription == nil {
		return ""
	}
	return *p.ShortDescription
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetTitle() string {
	if p == nil || p.Title == nil {
		return ""
	}
	return *p.Title
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *ProjectV2) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *ProjectV2Event) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetInstallation returns the Installation field.
func (p *ProjectV2Event) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *ProjectV2Event) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetProjectsV2 returns the ProjectsV2 field.
func (p *ProjectV2Event) GetProjectsV2() *ProjectV2 {
	if p == nil {
		return nil
	}
	return p.ProjectsV2
}

// GetSender returns the Sender field.
func (p *ProjectV2Event) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetArchivedAt returns the ArchivedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetArchivedAt() Timestamp {
	if p == nil || p.ArchivedAt == nil {
		return Timestamp{}
	}
	return *p.ArchivedAt
}

// GetContentNodeID returns the ContentNodeID field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetContentNodeID() string {
	if p == nil || p.ContentNodeID == nil {
		return ""
	}
	return *p.ContentNodeID
}

// GetContentType returns the ContentType field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetContentType() string {
	if p == nil || p.ContentType == nil {
		return ""
	}
	return *p.ContentType
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetCreator returns the Creator field.
func (p *ProjectV2Item) GetCreator() *User {
	if p == nil {
		return nil
	}
	return p.Creator
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetProjectNodeID returns the ProjectNodeID field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetProjectNodeID() string {
	if p == nil || p.ProjectNodeID == nil {
		return ""
	}
	return *p.ProjectNodeID
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *ProjectV2Item) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetArchivedAt returns the ArchivedAt field.
func (p *ProjectV2ItemChange) GetArchivedAt() *ArchivedAt {
	if p == nil {
		return nil
	}
	return p.ArchivedAt
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *ProjectV2ItemEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetChanges returns the Changes field.
func (p *ProjectV2ItemEvent) GetChanges() *ProjectV2ItemChange {
	if p == nil {
		return nil
	}
	return p.Changes
}

// GetInstallation returns the Installation field.
func (p *ProjectV2ItemEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *ProjectV2ItemEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetProjectV2Item returns the ProjectV2Item field.
func (p *ProjectV2ItemEvent) GetProjectV2Item() *ProjectV2Item {
	if p == nil {
		return nil
	}
	return p.ProjectV2Item
}

// GetSender returns the Sender field.
func (p *ProjectV2ItemEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetAllowDeletions returns the AllowDeletions field.
func (p *Protection) GetAllowDeletions() *AllowDeletions {
	if p == nil {
		return nil
	}
	return p.AllowDeletions
}

// GetAllowForcePushes returns the AllowForcePushes field.
func (p *Protection) GetAllowForcePushes() *AllowForcePushes {
	if p == nil {
		return nil
	}
	return p.AllowForcePushes
}

// GetAllowForkSyncing returns the AllowForkSyncing field.
func (p *Protection) GetAllowForkSyncing() *AllowForkSyncing {
	if p == nil {
		return nil
	}
	return p.AllowForkSyncing
}

// GetBlockCreations returns the BlockCreations field.
func (p *Protection) GetBlockCreations() *BlockCreations {
	if p == nil {
		return nil
	}
	return p.BlockCreations
}

// GetEnforceAdmins returns the EnforceAdmins field.
func (p *Protection) GetEnforceAdmins() *AdminEnforcement {
	if p == nil {
		return nil
	}
	return p.EnforceAdmins
}

// GetLockBranch returns the LockBranch field.
func (p *Protection) GetLockBranch() *LockBranch {
	if p == nil {
		return nil
	}
	return p.LockBranch
}

// GetRequiredConversationResolution returns the RequiredConversationResolution field.
func (p *Protection) GetRequiredConversationResolution() *RequiredConversationResolution {
	if p == nil {
		return nil
	}
	return p.RequiredConversationResolution
}

// GetRequiredPullRequestReviews returns the RequiredPullRequestReviews field.
func (p *Protection) GetRequiredPullRequestReviews() *PullRequestReviewsEnforcement {
	if p == nil {
		return nil
	}
	return p.RequiredPullRequestReviews
}

// GetRequiredSignatures returns the RequiredSignatures field.
func (p *Protection) GetRequiredSignatures() *SignaturesProtectedBranch {
	if p == nil {
		return nil
	}
	return p.RequiredSignatures
}

// GetRequiredStatusChecks returns the RequiredStatusChecks field.
func (p *Protection) GetRequiredStatusChecks() *RequiredStatusChecks {
	if p == nil {
		return nil
	}
	return p.RequiredStatusChecks
}

// GetRequireLinearHistory returns the RequireLinearHistory field.
func (p *Protection) GetRequireLinearHistory() *RequireLinearHistory {
	if p == nil {
		return nil
	}
	return p.RequireLinearHistory
}

// GetRestrictions returns the Restrictions field.
func (p *Protection) GetRestrictions() *BranchRestrictions {
	if p == nil {
		return nil
	}
	return p.Restrictions
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *Protection) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetAdminEnforced returns the AdminEnforced field.
func (p *ProtectionChanges) GetAdminEnforced() *AdminEnforcedChanges {
	if p == nil {
		return nil
	}
	return p.AdminEnforced
}

// GetAllowDeletionsEnforcementLevel returns the AllowDeletionsEnforcementLevel field.
func (p *ProtectionChanges) GetAllowDeletionsEnforcementLevel() *AllowDeletionsEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.AllowDeletionsEnforcementLevel
}

// GetAuthorizedActorNames returns the AuthorizedActorNames field.
func (p *ProtectionChanges) GetAuthorizedActorNames() *AuthorizedActorNames {
	if p == nil {
		return nil
	}
	return p.AuthorizedActorNames
}

// GetAuthorizedActorsOnly returns the AuthorizedActorsOnly field.
func (p *ProtectionChanges) GetAuthorizedActorsOnly() *AuthorizedActorsOnly {
	if p == nil {
		return nil
	}
	return p.AuthorizedActorsOnly
}

// GetAuthorizedDismissalActorsOnly returns the AuthorizedDismissalActorsOnly field.
func (p *ProtectionChanges) GetAuthorizedDismissalActorsOnly() *AuthorizedDismissalActorsOnlyChanges {
	if p == nil {
		return nil
	}
	return p.AuthorizedDismissalActorsOnly
}

// GetCreateProtected returns the CreateProtected field.
func (p *ProtectionChanges) GetCreateProtected() *CreateProtectedChanges {
	if p == nil {
		return nil
	}
	return p.CreateProtected
}

// GetDismissStaleReviewsOnPush returns the DismissStaleReviewsOnPush field.
func (p *ProtectionChanges) GetDismissStaleReviewsOnPush() *DismissStaleReviewsOnPushChanges {
	if p == nil {
		return nil
	}
	return p.DismissStaleReviewsOnPush
}

// GetLinearHistoryRequirementEnforcementLevel returns the LinearHistoryRequirementEnforcementLevel field.
func (p *ProtectionChanges) GetLinearHistoryRequirementEnforcementLevel() *LinearHistoryRequirementEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.LinearHistoryRequirementEnforcementLevel
}

// GetPullRequestReviewsEnforcementLevel returns the PullRequestReviewsEnforcementLevel field.
func (p *ProtectionChanges) GetPullRequestReviewsEnforcementLevel() *PullRequestReviewsEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.PullRequestReviewsEnforcementLevel
}

// GetRequireCodeOwnerReview returns the RequireCodeOwnerReview field.
func (p *ProtectionChanges) GetRequireCodeOwnerReview() *RequireCodeOwnerReviewChanges {
	if p == nil {
		return nil
	}
	return p.RequireCodeOwnerReview
}

// GetRequiredConversationResolutionLevel returns the RequiredConversationResolutionLevel field.
func (p *ProtectionChanges) GetRequiredConversationResolutionLevel() *RequiredConversationResolutionLevelChanges {
	if p == nil {
		return nil
	}
	return p.RequiredConversationResolutionLevel
}

// GetRequiredDeploymentsEnforcementLevel returns the RequiredDeploymentsEnforcementLevel field.
func (p *ProtectionChanges) GetRequiredDeploymentsEnforcementLevel() *RequiredDeploymentsEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.RequiredDeploymentsEnforcementLevel
}

// GetRequiredStatusChecks returns the RequiredStatusChecks field.
func (p *ProtectionChanges) GetRequiredStatusChecks() *RequiredStatusChecksChanges {
	if p == nil {
		return nil
	}
	return p.RequiredStatusChecks
}

// GetRequiredStatusChecksEnforcementLevel returns the RequiredStatusChecksEnforcementLevel field.
func (p *ProtectionChanges) GetRequiredStatusChecksEnforcementLevel() *RequiredStatusChecksEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.RequiredStatusChecksEnforcementLevel
}

// GetSignatureRequirementEnforcementLevel returns the SignatureRequirementEnforcementLevel field.
func (p *ProtectionChanges) GetSignatureRequirementEnforcementLevel() *SignatureRequirementEnforcementLevelChanges {
	if p == nil {
		return nil
	}
	return p.SignatureRequirementEnforcementLevel
}

// GetAllowDeletions returns the AllowDeletions field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetAllowDeletions() bool {
	if p == nil || p.AllowDeletions == nil {
		return false
	}
	return *p.AllowDeletions
}

// GetAllowForcePushes returns the AllowForcePushes field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetAllowForcePushes() bool {
	if p == nil || p.AllowForcePushes == nil {
		return false
	}
	return *p.AllowForcePushes
}

// GetAllowForkSyncing returns the AllowForkSyncing field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetAllowForkSyncing() bool {
	if p == nil || p.AllowForkSyncing == nil {
		return false
	}
	return *p.AllowForkSyncing
}

// GetBlockCreations returns the BlockCreations field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetBlockCreations() bool {
	if p == nil || p.BlockCreations == nil {
		return false
	}
	return *p.BlockCreations
}

// GetLockBranch returns the LockBranch field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetLockBranch() bool {
	if p == nil || p.LockBranch == nil {
		return false
	}
	return *p.LockBranch
}

// GetRequiredConversationResolution returns the RequiredConversationResolution field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetRequiredConversationResolution() bool {
	if p == nil || p.RequiredConversationResolution == nil {
		return false
	}
	return *p.RequiredConversationResolution
}

// GetRequiredPullRequestReviews returns the RequiredPullRequestReviews field.
func (p *ProtectionRequest) GetRequiredPullRequestReviews() *PullRequestReviewsEnforcementRequest {
	if p == nil {
		return nil
	}
	return p.RequiredPullRequestReviews
}

// GetRequiredStatusChecks returns the RequiredStatusChecks field.
func (p *ProtectionRequest) GetRequiredStatusChecks() *RequiredStatusChecks {
	if p == nil {
		return nil
	}
	return p.RequiredStatusChecks
}

// GetRequireLinearHistory returns the RequireLinearHistory field if it's non-nil, zero value otherwise.
func (p *ProtectionRequest) GetRequireLinearHistory() bool {
	if p == nil || p.RequireLinearHistory == nil {
		return false
	}
	return *p.RequireLinearHistory
}

// GetRestrictions returns the Restrictions field.
func (p *ProtectionRequest) GetRestrictions() *BranchRestrictionsRequest {
	if p == nil {
		return nil
	}
	return p.Restrictions
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *ProtectionRule) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *ProtectionRule) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetPreventSelfReview returns the PreventSelfReview field if it's non-nil, zero value otherwise.
func (p *ProtectionRule) GetPreventSelfReview() bool {
	if p == nil || p.PreventSelfReview == nil {
		return false
	}
	return *p.PreventSelfReview
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (p *ProtectionRule) GetType() string {
	if p == nil || p.Type == nil {
		return ""
	}
	return *p.Type
}

// GetWaitTimer returns the WaitTimer field if it's non-nil, zero value otherwise.
func (p *ProtectionRule) GetWaitTimer() int {
	if p == nil || p.WaitTimer == nil {
		return 0
	}
	return *p.WaitTimer
}

// GetInstallation returns the Installation field.
func (p *PublicEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PublicEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetRepo returns the Repo field.
func (p *PublicEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PublicEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (p *PublicKey) GetKey() string {
	if p == nil || p.Key == nil {
		return ""
	}
	return *p.Key
}

// GetKeyID returns the KeyID field if it's non-nil, zero value otherwise.
func (p *PublicKey) GetKeyID() string {
	if p == nil || p.KeyID == nil {
		return ""
	}
	return *p.KeyID
}

// GetActiveLockReason returns the ActiveLockReason field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetActiveLockReason() string {
	if p == nil || p.ActiveLockReason == nil {
		return ""
	}
	return *p.ActiveLockReason
}

// GetAdditions returns the Additions field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetAdditions() int {
	if p == nil || p.Additions == nil {
		return 0
	}
	return *p.Additions
}

// GetAssignee returns the Assignee field.
func (p *PullRequest) GetAssignee() *User {
	if p == nil {
		return nil
	}
	return p.Assignee
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetAuthorAssociation() string {
	if p == nil || p.AuthorAssociation == nil {
		return ""
	}
	return *p.AuthorAssociation
}

// GetAutoMerge returns the AutoMerge field.
func (p *PullRequest) GetAutoMerge() *PullRequestAutoMerge {
	if p == nil {
		return nil
	}
	return p.AutoMerge
}

// GetBase returns the Base field.
func (p *PullRequest) GetBase() *PullRequestBranch {
	if p == nil {
		return nil
	}
	return p.Base
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetBody() string {
	if p == nil || p.Body == nil {
		return ""
	}
	return *p.Body
}

// GetChangedFiles returns the ChangedFiles field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetChangedFiles() int {
	if p == nil || p.ChangedFiles == nil {
		return 0
	}
	return *p.ChangedFiles
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetClosedAt() Timestamp {
	if p == nil || p.ClosedAt == nil {
		return Timestamp{}
	}
	return *p.ClosedAt
}

// GetComments returns the Comments field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetComments() int {
	if p == nil || p.Comments == nil {
		return 0
	}
	return *p.Comments
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetCommentsURL() string {
	if p == nil || p.CommentsURL == nil {
		return ""
	}
	return *p.CommentsURL
}

// GetCommits returns the Commits field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetCommits() int {
	if p == nil || p.Commits == nil {
		return 0
	}
	return *p.Commits
}

// GetCommitsURL returns the CommitsURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetCommitsURL() string {
	if p == nil || p.CommitsURL == nil {
		return ""
	}
	return *p.CommitsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDeletions returns the Deletions field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetDeletions() int {
	if p == nil || p.Deletions == nil {
		return 0
	}
	return *p.Deletions
}

// GetDiffURL returns the DiffURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetDiffURL() string {
	if p == nil || p.DiffURL == nil {
		return ""
	}
	return *p.DiffURL
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetDraft() bool {
	if p == nil || p.Draft == nil {
		return false
	}
	return *p.Draft
}

// GetHead returns the Head field.
func (p *PullRequest) GetHead() *PullRequestBranch {
	if p == nil {
		return nil
	}
	return p.Head
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetIssueURL returns the IssueURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetIssueURL() string {
	if p == nil || p.IssueURL == nil {
		return ""
	}
	return *p.IssueURL
}

// GetLinks returns the Links field.
func (p *PullRequest) GetLinks() *PRLinks {
	if p == nil {
		return nil
	}
	return p.Links
}

// GetLocked returns the Locked field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetLocked() bool {
	if p == nil || p.Locked == nil {
		return false
	}
	return *p.Locked
}

// GetMaintainerCanModify returns the MaintainerCanModify field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMaintainerCanModify() bool {
	if p == nil || p.MaintainerCanModify == nil {
		return false
	}
	return *p.MaintainerCanModify
}

// GetMergeable returns the Mergeable field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMergeable() bool {
	if p == nil || p.Mergeable == nil {
		return false
	}
	return *p.Mergeable
}

// GetMergeableState returns the MergeableState field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMergeableState() string {
	if p == nil || p.MergeableState == nil {
		return ""
	}
	return *p.MergeableState
}

// GetMergeCommitSHA returns the MergeCommitSHA field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMergeCommitSHA() string {
	if p == nil || p.MergeCommitSHA == nil {
		return ""
	}
	return *p.MergeCommitSHA
}

// GetMerged returns the Merged field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMerged() bool {
	if p == nil || p.Merged == nil {
		return false
	}
	return *p.Merged
}

// GetMergedAt returns the MergedAt field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetMergedAt() Timestamp {
	if p == nil || p.MergedAt == nil {
		return Timestamp{}
	}
	return *p.MergedAt
}

// GetMergedBy returns the MergedBy field.
func (p *PullRequest) GetMergedBy() *User {
	if p == nil {
		return nil
	}
	return p.MergedBy
}

// GetMilestone returns the Milestone field.
func (p *PullRequest) GetMilestone() *Milestone {
	if p == nil {
		return nil
	}
	return p.Milestone
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetNumber() int {
	if p == nil || p.Number == nil {
		return 0
	}
	return *p.Number
}

// GetPatchURL returns the PatchURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetPatchURL() string {
	if p == nil || p.PatchURL == nil {
		return ""
	}
	return *p.PatchURL
}

// GetRebaseable returns the Rebaseable field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetRebaseable() bool {
	if p == nil || p.Rebaseable == nil {
		return false
	}
	return *p.Rebaseable
}

// GetReviewComments returns the ReviewComments field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetReviewComments() int {
	if p == nil || p.ReviewComments == nil {
		return 0
	}
	return *p.ReviewComments
}

// GetReviewCommentsURL returns the ReviewCommentsURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetReviewCommentsURL() string {
	if p == nil || p.ReviewCommentsURL == nil {
		return ""
	}
	return *p.ReviewCommentsURL
}

// GetReviewCommentURL returns the ReviewCommentURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetReviewCommentURL() string {
	if p == nil || p.ReviewCommentURL == nil {
		return ""
	}
	return *p.ReviewCommentURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetStatusesURL returns the StatusesURL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetStatusesURL() string {
	if p == nil || p.StatusesURL == nil {
		return ""
	}
	return *p.StatusesURL
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetTitle() string {
	if p == nil || p.Title == nil {
		return ""
	}
	return *p.Title
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PullRequest) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetUser returns the User field.
func (p *PullRequest) GetUser() *User {
	if p == nil {
		return nil
	}
	return p.User
}

// GetCommitMessage returns the CommitMessage field if it's non-nil, zero value otherwise.
func (p *PullRequestAutoMerge) GetCommitMessage() string {
	if p == nil || p.CommitMessage == nil {
		return ""
	}
	return *p.CommitMessage
}

// GetCommitTitle returns the CommitTitle field if it's non-nil, zero value otherwise.
func (p *PullRequestAutoMerge) GetCommitTitle() string {
	if p == nil || p.CommitTitle == nil {
		return ""
	}
	return *p.CommitTitle
}

// GetEnabledBy returns the EnabledBy field.
func (p *PullRequestAutoMerge) GetEnabledBy() *User {
	if p == nil {
		return nil
	}
	return p.EnabledBy
}

// GetMergeMethod returns the MergeMethod field if it's non-nil, zero value otherwise.
func (p *PullRequestAutoMerge) GetMergeMethod() string {
	if p == nil || p.MergeMethod == nil {
		return ""
	}
	return *p.MergeMethod
}

// GetLabel returns the Label field if it's non-nil, zero value otherwise.
func (p *PullRequestBranch) GetLabel() string {
	if p == nil || p.Label == nil {
		return ""
	}
	return *p.Label
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (p *PullRequestBranch) GetRef() string {
	if p == nil || p.Ref == nil {
		return ""
	}
	return *p.Ref
}

// GetRepo returns the Repo field.
func (p *PullRequestBranch) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (p *PullRequestBranch) GetSHA() string {
	if p == nil || p.SHA == nil {
		return ""
	}
	return *p.SHA
}

// GetUser returns the User field.
func (p *PullRequestBranch) GetUser() *User {
	if p == nil {
		return nil
	}
	return p.User
}

// GetExpectedHeadSHA returns the ExpectedHeadSHA field if it's non-nil, zero value otherwise.
func (p *PullRequestBranchUpdateOptions) GetExpectedHeadSHA() string {
	if p == nil || p.ExpectedHeadSHA == nil {
		return ""
	}
	return *p.ExpectedHeadSHA
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (p *PullRequestBranchUpdateResponse) GetMessage() string {
	if p == nil || p.Message == nil {
		return ""
	}
	return *p.Message
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PullRequestBranchUpdateResponse) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetAuthorAssociation() string {
	if p == nil || p.AuthorAssociation == nil {
		return ""
	}
	return *p.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetBody() string {
	if p == nil || p.Body == nil {
		return ""
	}
	return *p.Body
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetCommitID() string {
	if p == nil || p.CommitID == nil {
		return ""
	}
	return *p.CommitID
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDiffHunk returns the DiffHunk field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetDiffHunk() string {
	if p == nil || p.DiffHunk == nil {
		return ""
	}
	return *p.DiffHunk
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetInReplyTo returns the InReplyTo field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetInReplyTo() int64 {
	if p == nil || p.InReplyTo == nil {
		return 0
	}
	return *p.InReplyTo
}

// GetLine returns the Line field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetLine() int {
	if p == nil || p.Line == nil {
		return 0
	}
	return *p.Line
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetOriginalCommitID returns the OriginalCommitID field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetOriginalCommitID() string {
	if p == nil || p.OriginalCommitID == nil {
		return ""
	}
	return *p.OriginalCommitID
}

// GetOriginalLine returns the OriginalLine field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetOriginalLine() int {
	if p == nil || p.OriginalLine == nil {
		return 0
	}
	return *p.OriginalLine
}

// GetOriginalPosition returns the OriginalPosition field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetOriginalPosition() int {
	if p == nil || p.OriginalPosition == nil {
		return 0
	}
	return *p.OriginalPosition
}

// GetOriginalStartLine returns the OriginalStartLine field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetOriginalStartLine() int {
	if p == nil || p.OriginalStartLine == nil {
		return 0
	}
	return *p.OriginalStartLine
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetPath() string {
	if p == nil || p.Path == nil {
		return ""
	}
	return *p.Path
}

// GetPosition returns the Position field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetPosition() int {
	if p == nil || p.Position == nil {
		return 0
	}
	return *p.Position
}

// GetPullRequestReviewID returns the PullRequestReviewID field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetPullRequestReviewID() int64 {
	if p == nil || p.PullRequestReviewID == nil {
		return 0
	}
	return *p.PullRequestReviewID
}

// GetPullRequestURL returns the PullRequestURL field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetPullRequestURL() string {
	if p == nil || p.PullRequestURL == nil {
		return ""
	}
	return *p.PullRequestURL
}

// GetReactions returns the Reactions field.
func (p *PullRequestComment) GetReactions() *Reactions {
	if p == nil {
		return nil
	}
	return p.Reactions
}

// GetSide returns the Side field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetSide() string {
	if p == nil || p.Side == nil {
		return ""
	}
	return *p.Side
}

// GetStartLine returns the StartLine field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetStartLine() int {
	if p == nil || p.StartLine == nil {
		return 0
	}
	return *p.StartLine
}

// GetStartSide returns the StartSide field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetStartSide() string {
	if p == nil || p.StartSide == nil {
		return ""
	}
	return *p.StartSide
}

// GetSubjectType returns the SubjectType field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetSubjectType() string {
	if p == nil || p.SubjectType == nil {
		return ""
	}
	return *p.SubjectType
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PullRequestComment) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetUser returns the User field.
func (p *PullRequestComment) GetUser() *User {
	if p == nil {
		return nil
	}
	return p.User
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PullRequestEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetAfter returns the After field if it's non-nil, zero value otherwise.
func (p *PullRequestEvent) GetAfter() string {
	if p == nil || p.After == nil {
		return ""
	}
	return *p.After
}

// GetAssignee returns the Assignee field.
func (p *PullRequestEvent) GetAssignee() *User {
	if p == nil {
		return nil
	}
	return p.Assignee
}

// GetBefore returns the Before field if it's non-nil, zero value otherwise.
func (p *PullRequestEvent) GetBefore() string {
	if p == nil || p.Before == nil {
		return ""
	}
	return *p.Before
}

// GetChanges returns the Changes field.
func (p *PullRequestEvent) GetChanges() *EditChange {
	if p == nil {
		return nil
	}
	return p.Changes
}

// GetInstallation returns the Installation field.
func (p *PullRequestEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetLabel returns the Label field.
func (p *PullRequestEvent) GetLabel() *Label {
	if p == nil {
		return nil
	}
	return p.Label
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (p *PullRequestEvent) GetNumber() int {
	if p == nil || p.Number == nil {
		return 0
	}
	return *p.Number
}

// GetOrganization returns the Organization field.
func (p *PullRequestEvent) GetOrganization() *Organization {
	if p == nil {
		return nil
	}
	return p.Organization
}

// GetPerformedViaGithubApp returns the PerformedViaGithubApp field.
func (p *PullRequestEvent) GetPerformedViaGithubApp() *App {
	if p == nil {
		return nil
	}
	return p.PerformedViaGithubApp
}

// GetPullRequest returns the PullRequest field.
func (p *PullRequestEvent) GetPullRequest() *PullRequest {
	if p == nil {
		return nil
	}
	return p.PullRequest
}

// GetRepo returns the Repo field.
func (p *PullRequestEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetRequestedReviewer returns the RequestedReviewer field.
func (p *PullRequestEvent) GetRequestedReviewer() *User {
	if p == nil {
		return nil
	}
	return p.RequestedReviewer
}

// GetRequestedTeam returns the RequestedTeam field.
func (p *PullRequestEvent) GetRequestedTeam() *Team {
	if p == nil {
		return nil
	}
	return p.RequestedTeam
}

// GetSender returns the Sender field.
func (p *PullRequestEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetDiffURL returns the DiffURL field if it's non-nil, zero value otherwise.
func (p *PullRequestLinks) GetDiffURL() string {
	if p == nil || p.DiffURL == nil {
		return ""
	}
	return *p.DiffURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PullRequestLinks) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetMergedAt returns the MergedAt field if it's non-nil, zero value otherwise.
func (p *PullRequestLinks) GetMergedAt() Timestamp {
	if p == nil || p.MergedAt == nil {
		return Timestamp{}
	}
	return *p.MergedAt
}

// GetPatchURL returns the PatchURL field if it's non-nil, zero value otherwise.
func (p *PullRequestLinks) GetPatchURL() string {
	if p == nil || p.PatchURL == nil {
		return ""
	}
	return *p.PatchURL
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PullRequestLinks) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetMerged returns the Merged field if it's non-nil, zero value otherwise.
func (p *PullRequestMergeResult) GetMerged() bool {
	if p == nil || p.Merged == nil {
		return false
	}
	return *p.Merged
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (p *PullRequestMergeResult) GetMessage() string {
	if p == nil || p.Message == nil {
		return ""
	}
	return *p.Message
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (p *PullRequestMergeResult) GetSHA() string {
	if p == nil || p.SHA == nil {
		return ""
	}
	return *p.SHA
}

// GetAuthorAssociation returns the AuthorAssociation field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetAuthorAssociation() string {
	if p == nil || p.AuthorAssociation == nil {
		return ""
	}
	return *p.AuthorAssociation
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetBody() string {
	if p == nil || p.Body == nil {
		return ""
	}
	return *p.Body
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetCommitID() string {
	if p == nil || p.CommitID == nil {
		return ""
	}
	return *p.CommitID
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetPullRequestURL returns the PullRequestURL field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetPullRequestURL() string {
	if p == nil || p.PullRequestURL == nil {
		return ""
	}
	return *p.PullRequestURL
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetState() string {
	if p == nil || p.State == nil {
		return ""
	}
	return *p.State
}

// GetSubmittedAt returns the SubmittedAt field if it's non-nil, zero value otherwise.
func (p *PullRequestReview) GetSubmittedAt() Timestamp {
	if p == nil || p.SubmittedAt == nil {
		return Timestamp{}
	}
	return *p.SubmittedAt
}

// GetUser returns the User field.
func (p *PullRequestReview) GetUser() *User {
	if p == nil {
		return nil
	}
	return p.User
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewCommentEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetChanges returns the Changes field.
func (p *PullRequestReviewCommentEvent) GetChanges() *EditChange {
	if p == nil {
		return nil
	}
	return p.Changes
}

// GetComment returns the Comment field.
func (p *PullRequestReviewCommentEvent) GetComment() *PullRequestComment {
	if p == nil {
		return nil
	}
	return p.Comment
}

// GetInstallation returns the Installation field.
func (p *PullRequestReviewCommentEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PullRequestReviewCommentEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetPullRequest returns the PullRequest field.
func (p *PullRequestReviewCommentEvent) GetPullRequest() *PullRequest {
	if p == nil {
		return nil
	}
	return p.PullRequest
}

// GetRepo returns the Repo field.
func (p *PullRequestReviewCommentEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PullRequestReviewCommentEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewDismissalRequest) GetMessage() string {
	if p == nil || p.Message == nil {
		return ""
	}
	return *p.Message
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetInstallation returns the Installation field.
func (p *PullRequestReviewEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrganization returns the Organization field.
func (p *PullRequestReviewEvent) GetOrganization() *Organization {
	if p == nil {
		return nil
	}
	return p.Organization
}

// GetPullRequest returns the PullRequest field.
func (p *PullRequestReviewEvent) GetPullRequest() *PullRequest {
	if p == nil {
		return nil
	}
	return p.PullRequest
}

// GetRepo returns the Repo field.
func (p *PullRequestReviewEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetReview returns the Review field.
func (p *PullRequestReviewEvent) GetReview() *PullRequestReview {
	if p == nil {
		return nil
	}
	return p.Review
}

// GetSender returns the Sender field.
func (p *PullRequestReviewEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewRequest) GetBody() string {
	if p == nil || p.Body == nil {
		return ""
	}
	return *p.Body
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewRequest) GetCommitID() string {
	if p == nil || p.CommitID == nil {
		return ""
	}
	return *p.CommitID
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewRequest) GetEvent() string {
	if p == nil || p.Event == nil {
		return ""
	}
	return *p.Event
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewRequest) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetBypassPullRequestAllowances returns the BypassPullRequestAllowances field.
func (p *PullRequestReviewsEnforcement) GetBypassPullRequestAllowances() *BypassPullRequestAllowances {
	if p == nil {
		return nil
	}
	return p.BypassPullRequestAllowances
}

// GetDismissalRestrictions returns the DismissalRestrictions field.
func (p *PullRequestReviewsEnforcement) GetDismissalRestrictions() *DismissalRestrictions {
	if p == nil {
		return nil
	}
	return p.DismissalRestrictions
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewsEnforcementLevelChanges) GetFrom() string {
	if p == nil || p.From == nil {
		return ""
	}
	return *p.From
}

// GetBypassPullRequestAllowancesRequest returns the BypassPullRequestAllowancesRequest field.
func (p *PullRequestReviewsEnforcementRequest) GetBypassPullRequestAllowancesRequest() *BypassPullRequestAllowancesRequest {
	if p == nil {
		return nil
	}
	return p.BypassPullRequestAllowancesRequest
}

// GetDismissalRestrictionsRequest returns the DismissalRestrictionsRequest field.
func (p *PullRequestReviewsEnforcementRequest) GetDismissalRestrictionsRequest() *DismissalRestrictionsRequest {
	if p == nil {
		return nil
	}
	return p.DismissalRestrictionsRequest
}

// GetRequireLastPushApproval returns the RequireLastPushApproval field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewsEnforcementRequest) GetRequireLastPushApproval() bool {
	if p == nil || p.RequireLastPushApproval == nil {
		return false
	}
	return *p.RequireLastPushApproval
}

// GetBypassPullRequestAllowancesRequest returns the BypassPullRequestAllowancesRequest field.
func (p *PullRequestReviewsEnforcementUpdate) GetBypassPullRequestAllowancesRequest() *BypassPullRequestAllowancesRequest {
	if p == nil {
		return nil
	}
	return p.BypassPullRequestAllowancesRequest
}

// GetDismissalRestrictionsRequest returns the DismissalRestrictionsRequest field.
func (p *PullRequestReviewsEnforcementUpdate) GetDismissalRestrictionsRequest() *DismissalRestrictionsRequest {
	if p == nil {
		return nil
	}
	return p.DismissalRestrictionsRequest
}

// GetDismissStaleReviews returns the DismissStaleReviews field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewsEnforcementUpdate) GetDismissStaleReviews() bool {
	if p == nil || p.DismissStaleReviews == nil {
		return false
	}
	return *p.DismissStaleReviews
}

// GetRequireCodeOwnerReviews returns the RequireCodeOwnerReviews field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewsEnforcementUpdate) GetRequireCodeOwnerReviews() bool {
	if p == nil || p.RequireCodeOwnerReviews == nil {
		return false
	}
	return *p.RequireCodeOwnerReviews
}

// GetRequireLastPushApproval returns the RequireLastPushApproval field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewsEnforcementUpdate) GetRequireLastPushApproval() bool {
	if p == nil || p.RequireLastPushApproval == nil {
		return false
	}
	return *p.RequireLastPushApproval
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PullRequestReviewThreadEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetInstallation returns the Installation field.
func (p *PullRequestReviewThreadEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrg returns the Org field.
func (p *PullRequestReviewThreadEvent) GetOrg() *Organization {
	if p == nil {
		return nil
	}
	return p.Org
}

// GetPullRequest returns the PullRequest field.
func (p *PullRequestReviewThreadEvent) GetPullRequest() *PullRequest {
	if p == nil {
		return nil
	}
	return p.PullRequest
}

// GetRepo returns the Repo field.
func (p *PullRequestReviewThreadEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PullRequestReviewThreadEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetThread returns the Thread field.
func (p *PullRequestReviewThreadEvent) GetThread() *PullRequestThread {
	if p == nil {
		return nil
	}
	return p.Thread
}

// GetAutomaticCopilotCodeReviewEnabled returns the AutomaticCopilotCodeReviewEnabled field if it's non-nil, zero value otherwise.
func (p *PullRequestRuleParameters) GetAutomaticCopilotCodeReviewEnabled() bool {
	if p == nil || p.AutomaticCopilotCodeReviewEnabled == nil {
		return false
	}
	return *p.AutomaticCopilotCodeReviewEnabled
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PullRequestTargetEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetAfter returns the After field if it's non-nil, zero value otherwise.
func (p *PullRequestTargetEvent) GetAfter() string {
	if p == nil || p.After == nil {
		return ""
	}
	return *p.After
}

// GetAssignee returns the Assignee field.
func (p *PullRequestTargetEvent) GetAssignee() *User {
	if p == nil {
		return nil
	}
	return p.Assignee
}

// GetBefore returns the Before field if it's non-nil, zero value otherwise.
func (p *PullRequestTargetEvent) GetBefore() string {
	if p == nil || p.Before == nil {
		return ""
	}
	return *p.Before
}

// GetChanges returns the Changes field.
func (p *PullRequestTargetEvent) GetChanges() *EditChange {
	if p == nil {
		return nil
	}
	return p.Changes
}

// GetInstallation returns the Installation field.
func (p *PullRequestTargetEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetLabel returns the Label field.
func (p *PullRequestTargetEvent) GetLabel() *Label {
	if p == nil {
		return nil
	}
	return p.Label
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (p *PullRequestTargetEvent) GetNumber() int {
	if p == nil || p.Number == nil {
		return 0
	}
	return *p.Number
}

// GetOrganization returns the Organization field.
func (p *PullRequestTargetEvent) GetOrganization() *Organization {
	if p == nil {
		return nil
	}
	return p.Organization
}

// GetPerformedViaGithubApp returns the PerformedViaGithubApp field.
func (p *PullRequestTargetEvent) GetPerformedViaGithubApp() *App {
	if p == nil {
		return nil
	}
	return p.PerformedViaGithubApp
}

// GetPullRequest returns the PullRequest field.
func (p *PullRequestTargetEvent) GetPullRequest() *PullRequest {
	if p == nil {
		return nil
	}
	return p.PullRequest
}

// GetRepo returns the Repo field.
func (p *PullRequestTargetEvent) GetRepo() *Repository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetRequestedReviewer returns the RequestedReviewer field.
func (p *PullRequestTargetEvent) GetRequestedReviewer() *User {
	if p == nil {
		return nil
	}
	return p.RequestedReviewer
}

// GetRequestedTeam returns the RequestedTeam field.
func (p *PullRequestTargetEvent) GetRequestedTeam() *Team {
	if p == nil {
		return nil
	}
	return p.RequestedTeam
}

// GetSender returns the Sender field.
func (p *PullRequestTargetEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PullRequestThread) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PullRequestThread) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetMergeablePulls returns the MergeablePulls field if it's non-nil, zero value otherwise.
func (p *PullStats) GetMergeablePulls() int {
	if p == nil || p.MergeablePulls == nil {
		return 0
	}
	return *p.MergeablePulls
}

// GetMergedPulls returns the MergedPulls field if it's non-nil, zero value otherwise.
func (p *PullStats) GetMergedPulls() int {
	if p == nil || p.MergedPulls == nil {
		return 0
	}
	return *p.MergedPulls
}

// GetTotalPulls returns the TotalPulls field if it's non-nil, zero value otherwise.
func (p *PullStats) GetTotalPulls() int {
	if p == nil || p.TotalPulls == nil {
		return 0
	}
	return *p.TotalPulls
}

// GetUnmergeablePulls returns the UnmergeablePulls field if it's non-nil, zero value otherwise.
func (p *PullStats) GetUnmergeablePulls() int {
	if p == nil || p.UnmergeablePulls == nil {
		return 0
	}
	return *p.UnmergeablePulls
}

// GetCommits returns the Commits field if it's non-nil, zero value otherwise.
func (p *PunchCard) GetCommits() int {
	if p == nil || p.Commits == nil {
		return 0
	}
	return *p.Commits
}

// GetDay returns the Day field if it's non-nil, zero value otherwise.
func (p *PunchCard) GetDay() int {
	if p == nil || p.Day == nil {
		return 0
	}
	return *p.Day
}

// GetHour returns the Hour field if it's non-nil, zero value otherwise.
func (p *PunchCard) GetHour() int {
	if p == nil || p.Hour == nil {
		return 0
	}
	return *p.Hour
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetAction() string {
	if p == nil || p.Action == nil {
		return ""
	}
	return *p.Action
}

// GetAfter returns the After field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetAfter() string {
	if p == nil || p.After == nil {
		return ""
	}
	return *p.After
}

// GetBaseRef returns the BaseRef field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetBaseRef() string {
	if p == nil || p.BaseRef == nil {
		return ""
	}
	return *p.BaseRef
}

// GetBefore returns the Before field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetBefore() string {
	if p == nil || p.Before == nil {
		return ""
	}
	return *p.Before
}

// GetCommits returns the Commits slice if it's non-nil, nil otherwise.
func (p *PushEvent) GetCommits() []*HeadCommit {
	if p == nil || p.Commits == nil {
		return nil
	}
	return p.Commits
}

// GetCompare returns the Compare field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetCompare() string {
	if p == nil || p.Compare == nil {
		return ""
	}
	return *p.Compare
}

// GetCreated returns the Created field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetCreated() bool {
	if p == nil || p.Created == nil {
		return false
	}
	return *p.Created
}

// GetDeleted returns the Deleted field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetDeleted() bool {
	if p == nil || p.Deleted == nil {
		return false
	}
	return *p.Deleted
}

// GetDistinctSize returns the DistinctSize field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetDistinctSize() int {
	if p == nil || p.DistinctSize == nil {
		return 0
	}
	return *p.DistinctSize
}

// GetForced returns the Forced field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetForced() bool {
	if p == nil || p.Forced == nil {
		return false
	}
	return *p.Forced
}

// GetHead returns the Head field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetHead() string {
	if p == nil || p.Head == nil {
		return ""
	}
	return *p.Head
}

// GetHeadCommit returns the HeadCommit field.
func (p *PushEvent) GetHeadCommit() *HeadCommit {
	if p == nil {
		return nil
	}
	return p.HeadCommit
}

// GetInstallation returns the Installation field.
func (p *PushEvent) GetInstallation() *Installation {
	if p == nil {
		return nil
	}
	return p.Installation
}

// GetOrganization returns the Organization field.
func (p *PushEvent) GetOrganization() *Organization {
	if p == nil {
		return nil
	}
	return p.Organization
}

// GetPusher returns the Pusher field.
func (p *PushEvent) GetPusher() *CommitAuthor {
	if p == nil {
		return nil
	}
	return p.Pusher
}

// GetPushID returns the PushID field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetPushID() int64 {
	if p == nil || p.PushID == nil {
		return 0
	}
	return *p.PushID
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetRef() string {
	if p == nil || p.Ref == nil {
		return ""
	}
	return *p.Ref
}

// GetRepo returns the Repo field.
func (p *PushEvent) GetRepo() *PushEventRepository {
	if p == nil {
		return nil
	}
	return p.Repo
}

// GetSender returns the Sender field.
func (p *PushEvent) GetSender() *User {
	if p == nil {
		return nil
	}
	return p.Sender
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (p *PushEvent) GetSize() int {
	if p == nil || p.Size == nil {
		return 0
	}
	return *p.Size
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (p *PushEventRepoOwner) GetEmail() string {
	if p == nil || p.Email == nil {
		return ""
	}
	return *p.Email
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PushEventRepoOwner) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetArchived returns the Archived field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetArchived() bool {
	if p == nil || p.Archived == nil {
		return false
	}
	return *p.Archived
}

// GetArchiveURL returns the ArchiveURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetArchiveURL() string {
	if p == nil || p.ArchiveURL == nil {
		return ""
	}
	return *p.ArchiveURL
}

// GetCloneURL returns the CloneURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetCloneURL() string {
	if p == nil || p.CloneURL == nil {
		return ""
	}
	return *p.CloneURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetCreatedAt() Timestamp {
	if p == nil || p.CreatedAt == nil {
		return Timestamp{}
	}
	return *p.CreatedAt
}

// GetDefaultBranch returns the DefaultBranch field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetDefaultBranch() string {
	if p == nil || p.DefaultBranch == nil {
		return ""
	}
	return *p.DefaultBranch
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetDescription() string {
	if p == nil || p.Description == nil {
		return ""
	}
	return *p.Description
}

// GetDisabled returns the Disabled field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetDisabled() bool {
	if p == nil || p.Disabled == nil {
		return false
	}
	return *p.Disabled
}

// GetFork returns the Fork field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetFork() bool {
	if p == nil || p.Fork == nil {
		return false
	}
	return *p.Fork
}

// GetForksCount returns the ForksCount field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetForksCount() int {
	if p == nil || p.ForksCount == nil {
		return 0
	}
	return *p.ForksCount
}

// GetFullName returns the FullName field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetFullName() string {
	if p == nil || p.FullName == nil {
		return ""
	}
	return *p.FullName
}

// GetGitURL returns the GitURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetGitURL() string {
	if p == nil || p.GitURL == nil {
		return ""
	}
	return *p.GitURL
}

// GetHasDownloads returns the HasDownloads field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHasDownloads() bool {
	if p == nil || p.HasDownloads == nil {
		return false
	}
	return *p.HasDownloads
}

// GetHasIssues returns the HasIssues field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHasIssues() bool {
	if p == nil || p.HasIssues == nil {
		return false
	}
	return *p.HasIssues
}

// GetHasPages returns the HasPages field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHasPages() bool {
	if p == nil || p.HasPages == nil {
		return false
	}
	return *p.HasPages
}

// GetHasWiki returns the HasWiki field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHasWiki() bool {
	if p == nil || p.HasWiki == nil {
		return false
	}
	return *p.HasWiki
}

// GetHomepage returns the Homepage field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHomepage() string {
	if p == nil || p.Homepage == nil {
		return ""
	}
	return *p.Homepage
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetHTMLURL() string {
	if p == nil || p.HTMLURL == nil {
		return ""
	}
	return *p.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetID() int64 {
	if p == nil || p.ID == nil {
		return 0
	}
	return *p.ID
}

// GetLanguage returns the Language field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetLanguage() string {
	if p == nil || p.Language == nil {
		return ""
	}
	return *p.Language
}

// GetMasterBranch returns the MasterBranch field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetMasterBranch() string {
	if p == nil || p.MasterBranch == nil {
		return ""
	}
	return *p.MasterBranch
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetName() string {
	if p == nil || p.Name == nil {
		return ""
	}
	return *p.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetNodeID() string {
	if p == nil || p.NodeID == nil {
		return ""
	}
	return *p.NodeID
}

// GetOpenIssuesCount returns the OpenIssuesCount field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetOpenIssuesCount() int {
	if p == nil || p.OpenIssuesCount == nil {
		return 0
	}
	return *p.OpenIssuesCount
}

// GetOrganization returns the Organization field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetOrganization() string {
	if p == nil || p.Organization == nil {
		return ""
	}
	return *p.Organization
}

// GetOwner returns the Owner field.
func (p *PushEventRepository) GetOwner() *User {
	if p == nil {
		return nil
	}
	return p.Owner
}

// GetPrivate returns the Private field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetPrivate() bool {
	if p == nil || p.Private == nil {
		return false
	}
	return *p.Private
}

// GetPullsURL returns the PullsURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetPullsURL() string {
	if p == nil || p.PullsURL == nil {
		return ""
	}
	return *p.PullsURL
}

// GetPushedAt returns the PushedAt field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetPushedAt() Timestamp {
	if p == nil || p.PushedAt == nil {
		return Timestamp{}
	}
	return *p.PushedAt
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetSize() int {
	if p == nil || p.Size == nil {
		return 0
	}
	return *p.Size
}

// GetSSHURL returns the SSHURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetSSHURL() string {
	if p == nil || p.SSHURL == nil {
		return ""
	}
	return *p.SSHURL
}

// GetStargazersCount returns the StargazersCount field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetStargazersCount() int {
	if p == nil || p.StargazersCount == nil {
		return 0
	}
	return *p.StargazersCount
}

// GetStatusesURL returns the StatusesURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetStatusesURL() string {
	if p == nil || p.StatusesURL == nil {
		return ""
	}
	return *p.StatusesURL
}

// GetSVNURL returns the SVNURL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetSVNURL() string {
	if p == nil || p.SVNURL == nil {
		return ""
	}
	return *p.SVNURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetUpdatedAt() Timestamp {
	if p == nil || p.UpdatedAt == nil {
		return Timestamp{}
	}
	return *p.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetURL() string {
	if p == nil || p.URL == nil {
		return ""
	}
	return *p.URL
}

// GetWatchersCount returns the WatchersCount field if it's non-nil, zero value otherwise.
func (p *PushEventRepository) GetWatchersCount() int {
	if p == nil || p.WatchersCount == nil {
		return 0
	}
	return *p.WatchersCount
}

// GetActionsRunnerRegistration returns the ActionsRunnerRegistration field.
func (r *RateLimits) GetActionsRunnerRegistration() *Rate {
	if r == nil {
		return nil
	}
	return r.ActionsRunnerRegistration
}

// GetAuditLog returns the AuditLog field.
func (r *RateLimits) GetAuditLog() *Rate {
	if r == nil {
		return nil
	}
	return r.AuditLog
}

// GetCodeScanningUpload returns the CodeScanningUpload field.
func (r *RateLimits) GetCodeScanningUpload() *Rate {
	if r == nil {
		return nil
	}
	return r.CodeScanningUpload
}

// GetCodeSearch returns the CodeSearch field.
func (r *RateLimits) GetCodeSearch() *Rate {
	if r == nil {
		return nil
	}
	return r.CodeSearch
}

// GetCore returns the Core field.
func (r *RateLimits) GetCore() *Rate {
	if r == nil {
		return nil
	}
	return r.Core
}

// GetDependencySnapshots returns the DependencySnapshots field.
func (r *RateLimits) GetDependencySnapshots() *Rate {
	if r == nil {
		return nil
	}
	return r.DependencySnapshots
}

// GetGraphQL returns the GraphQL field.
func (r *RateLimits) GetGraphQL() *Rate {
	if r == nil {
		return nil
	}
	return r.GraphQL
}

// GetIntegrationManifest returns the IntegrationManifest field.
func (r *RateLimits) GetIntegrationManifest() *Rate {
	if r == nil {
		return nil
	}
	return r.IntegrationManifest
}

// GetSCIM returns the SCIM field.
func (r *RateLimits) GetSCIM() *Rate {
	if r == nil {
		return nil
	}
	return r.SCIM
}

// GetSearch returns the Search field.
func (r *RateLimits) GetSearch() *Rate {
	if r == nil {
		return nil
	}
	return r.Search
}

// GetSourceImport returns the SourceImport field.
func (r *RateLimits) GetSourceImport() *Rate {
	if r == nil {
		return nil
	}
	return r.SourceImport
}

// GetContent returns the Content field if it's non-nil, zero value otherwise.
func (r *Reaction) GetContent() string {
	if r == nil || r.Content == nil {
		return ""
	}
	return *r.Content
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *Reaction) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *Reaction) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *Reaction) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetUser returns the User field.
func (r *Reaction) GetUser() *User {
	if r == nil {
		return nil
	}
	return r.User
}

// GetConfused returns the Confused field if it's non-nil, zero value otherwise.
func (r *Reactions) GetConfused() int {
	if r == nil || r.Confused == nil {
		return 0
	}
	return *r.Confused
}

// GetEyes returns the Eyes field if it's non-nil, zero value otherwise.
func (r *Reactions) GetEyes() int {
	if r == nil || r.Eyes == nil {
		return 0
	}
	return *r.Eyes
}

// GetHeart returns the Heart field if it's non-nil, zero value otherwise.
func (r *Reactions) GetHeart() int {
	if r == nil || r.Heart == nil {
		return 0
	}
	return *r.Heart
}

// GetHooray returns the Hooray field if it's non-nil, zero value otherwise.
func (r *Reactions) GetHooray() int {
	if r == nil || r.Hooray == nil {
		return 0
	}
	return *r.Hooray
}

// GetLaugh returns the Laugh field if it's non-nil, zero value otherwise.
func (r *Reactions) GetLaugh() int {
	if r == nil || r.Laugh == nil {
		return 0
	}
	return *r.Laugh
}

// GetMinusOne returns the MinusOne field if it's non-nil, zero value otherwise.
func (r *Reactions) GetMinusOne() int {
	if r == nil || r.MinusOne == nil {
		return 0
	}
	return *r.MinusOne
}

// GetPlusOne returns the PlusOne field if it's non-nil, zero value otherwise.
func (r *Reactions) GetPlusOne() int {
	if r == nil || r.PlusOne == nil {
		return 0
	}
	return *r.PlusOne
}

// GetRocket returns the Rocket field if it's non-nil, zero value otherwise.
func (r *Reactions) GetRocket() int {
	if r == nil || r.Rocket == nil {
		return 0
	}
	return *r.Rocket
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (r *Reactions) GetTotalCount() int {
	if r == nil || r.TotalCount == nil {
		return 0
	}
	return *r.TotalCount
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *Reactions) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *Reference) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetObject returns the Object field.
func (r *Reference) GetObject() *GitObject {
	if r == nil {
		return nil
	}
	return r.Object
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (r *Reference) GetRef() string {
	if r == nil || r.Ref == nil {
		return ""
	}
	return *r.Ref
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *Reference) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (r *ReferencedWorkflow) GetPath() string {
	if r == nil || r.Path == nil {
		return ""
	}
	return *r.Path
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (r *ReferencedWorkflow) GetRef() string {
	if r == nil || r.Ref == nil {
		return ""
	}
	return *r.Ref
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *ReferencedWorkflow) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (r *RegistrationToken) GetExpiresAt() Timestamp {
	if r == nil || r.ExpiresAt == nil {
		return Timestamp{}
	}
	return *r.ExpiresAt
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (r *RegistrationToken) GetToken() string {
	if r == nil || r.Token == nil {
		return ""
	}
	return *r.Token
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *RegistryPackageEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetEnterprise returns the Enterprise field.
func (r *RegistryPackageEvent) GetEnterprise() *Enterprise {
	if r == nil {
		return nil
	}
	return r.Enterprise
}

// GetInstallation returns the Installation field.
func (r *RegistryPackageEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrganization returns the Organization field.
func (r *RegistryPackageEvent) GetOrganization() *Organization {
	if r == nil {
		return nil
	}
	return r.Organization
}

// GetRegistryPackage returns the RegistryPackage field.
func (r *RegistryPackageEvent) GetRegistryPackage() *Package {
	if r == nil {
		return nil
	}
	return r.RegistryPackage
}

// GetRepository returns the Repository field.
func (r *RegistryPackageEvent) GetRepository() *Repository {
	if r == nil {
		return nil
	}
	return r.Repository
}

// GetSender returns the Sender field.
func (r *RegistryPackageEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetBrowserDownloadURL returns the BrowserDownloadURL field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetBrowserDownloadURL() string {
	if r == nil || r.BrowserDownloadURL == nil {
		return ""
	}
	return *r.BrowserDownloadURL
}

// GetContentType returns the ContentType field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetContentType() string {
	if r == nil || r.ContentType == nil {
		return ""
	}
	return *r.ContentType
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetDownloadCount returns the DownloadCount field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetDownloadCount() int {
	if r == nil || r.DownloadCount == nil {
		return 0
	}
	return *r.DownloadCount
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetLabel returns the Label field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetLabel() string {
	if r == nil || r.Label == nil {
		return ""
	}
	return *r.Label
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetSize() int {
	if r == nil || r.Size == nil {
		return 0
	}
	return *r.Size
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetState() string {
	if r == nil || r.State == nil {
		return ""
	}
	return *r.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetUpdatedAt() Timestamp {
	if r == nil || r.UpdatedAt == nil {
		return Timestamp{}
	}
	return *r.UpdatedAt
}

// GetUploader returns the Uploader field.
func (r *ReleaseAsset) GetUploader() *User {
	if r == nil {
		return nil
	}
	return r.Uploader
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *ReleaseAsset) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *ReleaseEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetInstallation returns the Installation field.
func (r *ReleaseEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrg returns the Org field.
func (r *ReleaseEvent) GetOrg() *Organization {
	if r == nil {
		return nil
	}
	return r.Org
}

// GetRelease returns the Release field.
func (r *ReleaseEvent) GetRelease() *RepositoryRelease {
	if r == nil {
		return nil
	}
	return r.Release
}

// GetRepo returns the Repo field.
func (r *ReleaseEvent) GetRepo() *Repository {
	if r == nil {
		return nil
	}
	return r.Repo
}

// GetSender returns the Sender field.
func (r *ReleaseEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetBuildDate returns the BuildDate field if it's non-nil, zero value otherwise.
func (r *ReleaseVersion) GetBuildDate() string {
	if r == nil || r.BuildDate == nil {
		return ""
	}
	return *r.BuildDate
}

// GetBuildID returns the BuildID field if it's non-nil, zero value otherwise.
func (r *ReleaseVersion) GetBuildID() string {
	if r == nil || r.BuildID == nil {
		return ""
	}
	return *r.BuildID
}

// GetPlatform returns the Platform field if it's non-nil, zero value otherwise.
func (r *ReleaseVersion) GetPlatform() string {
	if r == nil || r.Platform == nil {
		return ""
	}
	return *r.Platform
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (r *ReleaseVersion) GetVersion() string {
	if r == nil || r.Version == nil {
		return ""
	}
	return *r.Version
}

// GetExpiresAt returns the ExpiresAt field if it's non-nil, zero value otherwise.
func (r *RemoveToken) GetExpiresAt() Timestamp {
	if r == nil || r.ExpiresAt == nil {
		return Timestamp{}
	}
	return *r.ExpiresAt
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (r *RemoveToken) GetToken() string {
	if r == nil || r.Token == nil {
		return ""
	}
	return *r.Token
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *Rename) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetTo returns the To field if it's non-nil, zero value otherwise.
func (r *Rename) GetTo() string {
	if r == nil || r.To == nil {
		return ""
	}
	return *r.To
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (r *RenameOrgResponse) GetMessage() string {
	if r == nil || r.Message == nil {
		return ""
	}
	return *r.Message
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RenameOrgResponse) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (r *RepoAdvisoryCredit) GetLogin() string {
	if r == nil || r.Login == nil {
		return ""
	}
	return *r.Login
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RepoAdvisoryCredit) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (r *RepoAdvisoryCreditDetailed) GetState() string {
	if r == nil || r.State == nil {
		return ""
	}
	return *r.State
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RepoAdvisoryCreditDetailed) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetUser returns the User field.
func (r *RepoAdvisoryCreditDetailed) GetUser() *User {
	if r == nil {
		return nil
	}
	return r.User
}

// GetDownloadLocation returns the DownloadLocation field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetDownloadLocation() string {
	if r == nil || r.DownloadLocation == nil {
		return ""
	}
	return *r.DownloadLocation
}

// GetFilesAnalyzed returns the FilesAnalyzed field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetFilesAnalyzed() bool {
	if r == nil || r.FilesAnalyzed == nil {
		return false
	}
	return *r.FilesAnalyzed
}

// GetLicenseConcluded returns the LicenseConcluded field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetLicenseConcluded() string {
	if r == nil || r.LicenseConcluded == nil {
		return ""
	}
	return *r.LicenseConcluded
}

// GetLicenseDeclared returns the LicenseDeclared field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetLicenseDeclared() string {
	if r == nil || r.LicenseDeclared == nil {
		return ""
	}
	return *r.LicenseDeclared
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetSPDXID returns the SPDXID field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetSPDXID() string {
	if r == nil || r.SPDXID == nil {
		return ""
	}
	return *r.SPDXID
}

// GetVersionInfo returns the VersionInfo field if it's non-nil, zero value otherwise.
func (r *RepoDependencies) GetVersionInfo() string {
	if r == nil || r.VersionInfo == nil {
		return ""
	}
	return *r.VersionInfo
}

// GetBranch returns the Branch field if it's non-nil, zero value otherwise.
func (r *RepoMergeUpstreamRequest) GetBranch() string {
	if r == nil || r.Branch == nil {
		return ""
	}
	return *r.Branch
}

// GetBaseBranch returns the BaseBranch field if it's non-nil, zero value otherwise.
func (r *RepoMergeUpstreamResult) GetBaseBranch() string {
	if r == nil || r.BaseBranch == nil {
		return ""
	}
	return *r.BaseBranch
}

// GetMergeType returns the MergeType field if it's non-nil, zero value otherwise.
func (r *RepoMergeUpstreamResult) GetMergeType() string {
	if r == nil || r.MergeType == nil {
		return ""
	}
	return *r.MergeType
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (r *RepoMergeUpstreamResult) GetMessage() string {
	if r == nil || r.Message == nil {
		return ""
	}
	return *r.Message
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RepoName) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (r *RepositoriesSearchResult) GetIncompleteResults() bool {
	if r == nil || r.IncompleteResults == nil {
		return false
	}
	return *r.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (r *RepositoriesSearchResult) GetTotal() int {
	if r == nil || r.Total == nil {
		return 0
	}
	return *r.Total
}

// GetAllowAutoMerge returns the AllowAutoMerge field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowAutoMerge() bool {
	if r == nil || r.AllowAutoMerge == nil {
		return false
	}
	return *r.AllowAutoMerge
}

// GetAllowForking returns the AllowForking field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowForking() bool {
	if r == nil || r.AllowForking == nil {
		return false
	}
	return *r.AllowForking
}

// GetAllowMergeCommit returns the AllowMergeCommit field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowMergeCommit() bool {
	if r == nil || r.AllowMergeCommit == nil {
		return false
	}
	return *r.AllowMergeCommit
}

// GetAllowRebaseMerge returns the AllowRebaseMerge field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowRebaseMerge() bool {
	if r == nil || r.AllowRebaseMerge == nil {
		return false
	}
	return *r.AllowRebaseMerge
}

// GetAllowSquashMerge returns the AllowSquashMerge field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowSquashMerge() bool {
	if r == nil || r.AllowSquashMerge == nil {
		return false
	}
	return *r.AllowSquashMerge
}

// GetAllowUpdateBranch returns the AllowUpdateBranch field if it's non-nil, zero value otherwise.
func (r *Repository) GetAllowUpdateBranch() bool {
	if r == nil || r.AllowUpdateBranch == nil {
		return false
	}
	return *r.AllowUpdateBranch
}

// GetArchived returns the Archived field if it's non-nil, zero value otherwise.
func (r *Repository) GetArchived() bool {
	if r == nil || r.Archived == nil {
		return false
	}
	return *r.Archived
}

// GetArchiveURL returns the ArchiveURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetArchiveURL() string {
	if r == nil || r.ArchiveURL == nil {
		return ""
	}
	return *r.ArchiveURL
}

// GetAssigneesURL returns the AssigneesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetAssigneesURL() string {
	if r == nil || r.AssigneesURL == nil {
		return ""
	}
	return *r.AssigneesURL
}

// GetAutoInit returns the AutoInit field if it's non-nil, zero value otherwise.
func (r *Repository) GetAutoInit() bool {
	if r == nil || r.AutoInit == nil {
		return false
	}
	return *r.AutoInit
}

// GetBlobsURL returns the BlobsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetBlobsURL() string {
	if r == nil || r.BlobsURL == nil {
		return ""
	}
	return *r.BlobsURL
}

// GetBranchesURL returns the BranchesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetBranchesURL() string {
	if r == nil || r.BranchesURL == nil {
		return ""
	}
	return *r.BranchesURL
}

// GetCloneURL returns the CloneURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetCloneURL() string {
	if r == nil || r.CloneURL == nil {
		return ""
	}
	return *r.CloneURL
}

// GetCodeOfConduct returns the CodeOfConduct field.
func (r *Repository) GetCodeOfConduct() *CodeOfConduct {
	if r == nil {
		return nil
	}
	return r.CodeOfConduct
}

// GetCollaboratorsURL returns the CollaboratorsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetCollaboratorsURL() string {
	if r == nil || r.CollaboratorsURL == nil {
		return ""
	}
	return *r.CollaboratorsURL
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetCommentsURL() string {
	if r == nil || r.CommentsURL == nil {
		return ""
	}
	return *r.CommentsURL
}

// GetCommitsURL returns the CommitsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetCommitsURL() string {
	if r == nil || r.CommitsURL == nil {
		return ""
	}
	return *r.CommitsURL
}

// GetCompareURL returns the CompareURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetCompareURL() string {
	if r == nil || r.CompareURL == nil {
		return ""
	}
	return *r.CompareURL
}

// GetContentsURL returns the ContentsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetContentsURL() string {
	if r == nil || r.ContentsURL == nil {
		return ""
	}
	return *r.ContentsURL
}

// GetContributorsURL returns the ContributorsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetContributorsURL() string {
	if r == nil || r.ContributorsURL == nil {
		return ""
	}
	return *r.ContributorsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *Repository) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetDefaultBranch returns the DefaultBranch field if it's non-nil, zero value otherwise.
func (r *Repository) GetDefaultBranch() string {
	if r == nil || r.DefaultBranch == nil {
		return ""
	}
	return *r.DefaultBranch
}

// GetDeleteBranchOnMerge returns the DeleteBranchOnMerge field if it's non-nil, zero value otherwise.
func (r *Repository) GetDeleteBranchOnMerge() bool {
	if r == nil || r.DeleteBranchOnMerge == nil {
		return false
	}
	return *r.DeleteBranchOnMerge
}

// GetDeploymentsURL returns the DeploymentsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetDeploymentsURL() string {
	if r == nil || r.DeploymentsURL == nil {
		return ""
	}
	return *r.DeploymentsURL
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (r *Repository) GetDescription() string {
	if r == nil || r.Description == nil {
		return ""
	}
	return *r.Description
}

// GetDisabled returns the Disabled field if it's non-nil, zero value otherwise.
func (r *Repository) GetDisabled() bool {
	if r == nil || r.Disabled == nil {
		return false
	}
	return *r.Disabled
}

// GetDownloadsURL returns the DownloadsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetDownloadsURL() string {
	if r == nil || r.DownloadsURL == nil {
		return ""
	}
	return *r.DownloadsURL
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetEventsURL() string {
	if r == nil || r.EventsURL == nil {
		return ""
	}
	return *r.EventsURL
}

// GetFork returns the Fork field if it's non-nil, zero value otherwise.
func (r *Repository) GetFork() bool {
	if r == nil || r.Fork == nil {
		return false
	}
	return *r.Fork
}

// GetForksCount returns the ForksCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetForksCount() int {
	if r == nil || r.ForksCount == nil {
		return 0
	}
	return *r.ForksCount
}

// GetForksURL returns the ForksURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetForksURL() string {
	if r == nil || r.ForksURL == nil {
		return ""
	}
	return *r.ForksURL
}

// GetFullName returns the FullName field if it's non-nil, zero value otherwise.
func (r *Repository) GetFullName() string {
	if r == nil || r.FullName == nil {
		return ""
	}
	return *r.FullName
}

// GetGitCommitsURL returns the GitCommitsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetGitCommitsURL() string {
	if r == nil || r.GitCommitsURL == nil {
		return ""
	}
	return *r.GitCommitsURL
}

// GetGitignoreTemplate returns the GitignoreTemplate field if it's non-nil, zero value otherwise.
func (r *Repository) GetGitignoreTemplate() string {
	if r == nil || r.GitignoreTemplate == nil {
		return ""
	}
	return *r.GitignoreTemplate
}

// GetGitRefsURL returns the GitRefsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetGitRefsURL() string {
	if r == nil || r.GitRefsURL == nil {
		return ""
	}
	return *r.GitRefsURL
}

// GetGitTagsURL returns the GitTagsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetGitTagsURL() string {
	if r == nil || r.GitTagsURL == nil {
		return ""
	}
	return *r.GitTagsURL
}

// GetGitURL returns the GitURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetGitURL() string {
	if r == nil || r.GitURL == nil {
		return ""
	}
	return *r.GitURL
}

// GetHasDiscussions returns the HasDiscussions field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasDiscussions() bool {
	if r == nil || r.HasDiscussions == nil {
		return false
	}
	return *r.HasDiscussions
}

// GetHasDownloads returns the HasDownloads field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasDownloads() bool {
	if r == nil || r.HasDownloads == nil {
		return false
	}
	return *r.HasDownloads
}

// GetHasIssues returns the HasIssues field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasIssues() bool {
	if r == nil || r.HasIssues == nil {
		return false
	}
	return *r.HasIssues
}

// GetHasPages returns the HasPages field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasPages() bool {
	if r == nil || r.HasPages == nil {
		return false
	}
	return *r.HasPages
}

// GetHasProjects returns the HasProjects field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasProjects() bool {
	if r == nil || r.HasProjects == nil {
		return false
	}
	return *r.HasProjects
}

// GetHasWiki returns the HasWiki field if it's non-nil, zero value otherwise.
func (r *Repository) GetHasWiki() bool {
	if r == nil || r.HasWiki == nil {
		return false
	}
	return *r.HasWiki
}

// GetHomepage returns the Homepage field if it's non-nil, zero value otherwise.
func (r *Repository) GetHomepage() string {
	if r == nil || r.Homepage == nil {
		return ""
	}
	return *r.Homepage
}

// GetHooksURL returns the HooksURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetHooksURL() string {
	if r == nil || r.HooksURL == nil {
		return ""
	}
	return *r.HooksURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *Repository) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetIssueCommentURL returns the IssueCommentURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetIssueCommentURL() string {
	if r == nil || r.IssueCommentURL == nil {
		return ""
	}
	return *r.IssueCommentURL
}

// GetIssueEventsURL returns the IssueEventsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetIssueEventsURL() string {
	if r == nil || r.IssueEventsURL == nil {
		return ""
	}
	return *r.IssueEventsURL
}

// GetIssuesURL returns the IssuesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetIssuesURL() string {
	if r == nil || r.IssuesURL == nil {
		return ""
	}
	return *r.IssuesURL
}

// GetIsTemplate returns the IsTemplate field if it's non-nil, zero value otherwise.
func (r *Repository) GetIsTemplate() bool {
	if r == nil || r.IsTemplate == nil {
		return false
	}
	return *r.IsTemplate
}

// GetKeysURL returns the KeysURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetKeysURL() string {
	if r == nil || r.KeysURL == nil {
		return ""
	}
	return *r.KeysURL
}

// GetLabelsURL returns the LabelsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetLabelsURL() string {
	if r == nil || r.LabelsURL == nil {
		return ""
	}
	return *r.LabelsURL
}

// GetLanguage returns the Language field if it's non-nil, zero value otherwise.
func (r *Repository) GetLanguage() string {
	if r == nil || r.Language == nil {
		return ""
	}
	return *r.Language
}

// GetLanguagesURL returns the LanguagesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetLanguagesURL() string {
	if r == nil || r.LanguagesURL == nil {
		return ""
	}
	return *r.LanguagesURL
}

// GetLicense returns the License field.
func (r *Repository) GetLicense() *License {
	if r == nil {
		return nil
	}
	return r.License
}

// GetLicenseTemplate returns the LicenseTemplate field if it's non-nil, zero value otherwise.
func (r *Repository) GetLicenseTemplate() string {
	if r == nil || r.LicenseTemplate == nil {
		return ""
	}
	return *r.LicenseTemplate
}

// GetMasterBranch returns the MasterBranch field if it's non-nil, zero value otherwise.
func (r *Repository) GetMasterBranch() string {
	if r == nil || r.MasterBranch == nil {
		return ""
	}
	return *r.MasterBranch
}

// GetMergeCommitMessage returns the MergeCommitMessage field if it's non-nil, zero value otherwise.
func (r *Repository) GetMergeCommitMessage() string {
	if r == nil || r.MergeCommitMessage == nil {
		return ""
	}
	return *r.MergeCommitMessage
}

// GetMergeCommitTitle returns the MergeCommitTitle field if it's non-nil, zero value otherwise.
func (r *Repository) GetMergeCommitTitle() string {
	if r == nil || r.MergeCommitTitle == nil {
		return ""
	}
	return *r.MergeCommitTitle
}

// GetMergesURL returns the MergesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetMergesURL() string {
	if r == nil || r.MergesURL == nil {
		return ""
	}
	return *r.MergesURL
}

// GetMilestonesURL returns the MilestonesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetMilestonesURL() string {
	if r == nil || r.MilestonesURL == nil {
		return ""
	}
	return *r.MilestonesURL
}

// GetMirrorURL returns the MirrorURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetMirrorURL() string {
	if r == nil || r.MirrorURL == nil {
		return ""
	}
	return *r.MirrorURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *Repository) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetNetworkCount returns the NetworkCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetNetworkCount() int {
	if r == nil || r.NetworkCount == nil {
		return 0
	}
	return *r.NetworkCount
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *Repository) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetNotificationsURL returns the NotificationsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetNotificationsURL() string {
	if r == nil || r.NotificationsURL == nil {
		return ""
	}
	return *r.NotificationsURL
}

// GetOpenIssues returns the OpenIssues field if it's non-nil, zero value otherwise.
func (r *Repository) GetOpenIssues() int {
	if r == nil || r.OpenIssues == nil {
		return 0
	}
	return *r.OpenIssues
}

// GetOpenIssuesCount returns the OpenIssuesCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetOpenIssuesCount() int {
	if r == nil || r.OpenIssuesCount == nil {
		return 0
	}
	return *r.OpenIssuesCount
}

// GetOrganization returns the Organization field.
func (r *Repository) GetOrganization() *Organization {
	if r == nil {
		return nil
	}
	return r.Organization
}

// GetOwner returns the Owner field.
func (r *Repository) GetOwner() *User {
	if r == nil {
		return nil
	}
	return r.Owner
}

// GetParent returns the Parent field.
func (r *Repository) GetParent() *Repository {
	if r == nil {
		return nil
	}
	return r.Parent
}

// GetPermissions returns the Permissions map if it's non-nil, an empty map otherwise.
func (r *Repository) GetPermissions() map[string]bool {
	if r == nil || r.Permissions == nil {
		return map[string]bool{}
	}
	return r.Permissions
}

// GetPrivate returns the Private field if it's non-nil, zero value otherwise.
func (r *Repository) GetPrivate() bool {
	if r == nil || r.Private == nil {
		return false
	}
	return *r.Private
}

// GetPullsURL returns the PullsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetPullsURL() string {
	if r == nil || r.PullsURL == nil {
		return ""
	}
	return *r.PullsURL
}

// GetPushedAt returns the PushedAt field if it's non-nil, zero value otherwise.
func (r *Repository) GetPushedAt() Timestamp {
	if r == nil || r.PushedAt == nil {
		return Timestamp{}
	}
	return *r.PushedAt
}

// GetReleasesURL returns the ReleasesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetReleasesURL() string {
	if r == nil || r.ReleasesURL == nil {
		return ""
	}
	return *r.ReleasesURL
}

// GetRoleName returns the RoleName field if it's non-nil, zero value otherwise.
func (r *Repository) GetRoleName() string {
	if r == nil || r.RoleName == nil {
		return ""
	}
	return *r.RoleName
}

// GetSecurityAndAnalysis returns the SecurityAndAnalysis field.
func (r *Repository) GetSecurityAndAnalysis() *SecurityAndAnalysis {
	if r == nil {
		return nil
	}
	return r.SecurityAndAnalysis
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (r *Repository) GetSize() int {
	if r == nil || r.Size == nil {
		return 0
	}
	return *r.Size
}

// GetSource returns the Source field.
func (r *Repository) GetSource() *Repository {
	if r == nil {
		return nil
	}
	return r.Source
}

// GetSquashMergeCommitMessage returns the SquashMergeCommitMessage field if it's non-nil, zero value otherwise.
func (r *Repository) GetSquashMergeCommitMessage() string {
	if r == nil || r.SquashMergeCommitMessage == nil {
		return ""
	}
	return *r.SquashMergeCommitMessage
}

// GetSquashMergeCommitTitle returns the SquashMergeCommitTitle field if it's non-nil, zero value otherwise.
func (r *Repository) GetSquashMergeCommitTitle() string {
	if r == nil || r.SquashMergeCommitTitle == nil {
		return ""
	}
	return *r.SquashMergeCommitTitle
}

// GetSSHURL returns the SSHURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetSSHURL() string {
	if r == nil || r.SSHURL == nil {
		return ""
	}
	return *r.SSHURL
}

// GetStargazersCount returns the StargazersCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetStargazersCount() int {
	if r == nil || r.StargazersCount == nil {
		return 0
	}
	return *r.StargazersCount
}

// GetStargazersURL returns the StargazersURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetStargazersURL() string {
	if r == nil || r.StargazersURL == nil {
		return ""
	}
	return *r.StargazersURL
}

// GetStatusesURL returns the StatusesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetStatusesURL() string {
	if r == nil || r.StatusesURL == nil {
		return ""
	}
	return *r.StatusesURL
}

// GetSubscribersCount returns the SubscribersCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetSubscribersCount() int {
	if r == nil || r.SubscribersCount == nil {
		return 0
	}
	return *r.SubscribersCount
}

// GetSubscribersURL returns the SubscribersURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetSubscribersURL() string {
	if r == nil || r.SubscribersURL == nil {
		return ""
	}
	return *r.SubscribersURL
}

// GetSubscriptionURL returns the SubscriptionURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetSubscriptionURL() string {
	if r == nil || r.SubscriptionURL == nil {
		return ""
	}
	return *r.SubscriptionURL
}

// GetSVNURL returns the SVNURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetSVNURL() string {
	if r == nil || r.SVNURL == nil {
		return ""
	}
	return *r.SVNURL
}

// GetTagsURL returns the TagsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetTagsURL() string {
	if r == nil || r.TagsURL == nil {
		return ""
	}
	return *r.TagsURL
}

// GetTeamID returns the TeamID field if it's non-nil, zero value otherwise.
func (r *Repository) GetTeamID() int64 {
	if r == nil || r.TeamID == nil {
		return 0
	}
	return *r.TeamID
}

// GetTeamsURL returns the TeamsURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetTeamsURL() string {
	if r == nil || r.TeamsURL == nil {
		return ""
	}
	return *r.TeamsURL
}

// GetTemplateRepository returns the TemplateRepository field.
func (r *Repository) GetTemplateRepository() *Repository {
	if r == nil {
		return nil
	}
	return r.TemplateRepository
}

// GetTreesURL returns the TreesURL field if it's non-nil, zero value otherwise.
func (r *Repository) GetTreesURL() string {
	if r == nil || r.TreesURL == nil {
		return ""
	}
	return *r.TreesURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (r *Repository) GetUpdatedAt() Timestamp {
	if r == nil || r.UpdatedAt == nil {
		return Timestamp{}
	}
	return *r.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *Repository) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetUseSquashPRTitleAsDefault returns the UseSquashPRTitleAsDefault field if it's non-nil, zero value otherwise.
func (r *Repository) GetUseSquashPRTitleAsDefault() bool {
	if r == nil || r.UseSquashPRTitleAsDefault == nil {
		return false
	}
	return *r.UseSquashPRTitleAsDefault
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (r *Repository) GetVisibility() string {
	if r == nil || r.Visibility == nil {
		return ""
	}
	return *r.Visibility
}

// GetWatchers returns the Watchers field if it's non-nil, zero value otherwise.
func (r *Repository) GetWatchers() int {
	if r == nil || r.Watchers == nil {
		return 0
	}
	return *r.Watchers
}

// GetWatchersCount returns the WatchersCount field if it's non-nil, zero value otherwise.
func (r *Repository) GetWatchersCount() int {
	if r == nil || r.WatchersCount == nil {
		return 0
	}
	return *r.WatchersCount
}

// GetWebCommitSignoffRequired returns the WebCommitSignoffRequired field if it's non-nil, zero value otherwise.
func (r *Repository) GetWebCommitSignoffRequired() bool {
	if r == nil || r.WebCommitSignoffRequired == nil {
		return false
	}
	return *r.WebCommitSignoffRequired
}

// GetAccessLevel returns the AccessLevel field if it's non-nil, zero value otherwise.
func (r *RepositoryActionsAccessLevel) GetAccessLevel() string {
	if r == nil || r.AccessLevel == nil {
		return ""
	}
	return *r.AccessLevel
}

// GetAdvancedSecurityCommitters returns the AdvancedSecurityCommitters field if it's non-nil, zero value otherwise.
func (r *RepositoryActiveCommitters) GetAdvancedSecurityCommitters() int {
	if r == nil || r.AdvancedSecurityCommitters == nil {
		return 0
	}
	return *r.AdvancedSecurityCommitters
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepositoryActiveCommitters) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetConfiguration returns the Configuration field.
func (r *RepositoryCodeSecurityConfiguration) GetConfiguration() *CodeSecurityConfiguration {
	if r == nil {
		return nil
	}
	return r.Configuration
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (r *RepositoryCodeSecurityConfiguration) GetState() string {
	if r == nil || r.State == nil {
		return ""
	}
	return *r.State
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetBody() string {
	if r == nil || r.Body == nil {
		return ""
	}
	return *r.Body
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetCommitID() string {
	if r == nil || r.CommitID == nil {
		return ""
	}
	return *r.CommitID
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetPath() string {
	if r == nil || r.Path == nil {
		return ""
	}
	return *r.Path
}

// GetPosition returns the Position field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetPosition() int {
	if r == nil || r.Position == nil {
		return 0
	}
	return *r.Position
}

// GetReactions returns the Reactions field.
func (r *RepositoryComment) GetReactions() *Reactions {
	if r == nil {
		return nil
	}
	return r.Reactions
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetUpdatedAt() Timestamp {
	if r == nil || r.UpdatedAt == nil {
		return Timestamp{}
	}
	return *r.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryComment) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetUser returns the User field.
func (r *RepositoryComment) GetUser() *User {
	if r == nil {
		return nil
	}
	return r.User
}

// GetAuthor returns the Author field.
func (r *RepositoryCommit) GetAuthor() *User {
	if r == nil {
		return nil
	}
	return r.Author
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (r *RepositoryCommit) GetCommentsURL() string {
	if r == nil || r.CommentsURL == nil {
		return ""
	}
	return *r.CommentsURL
}

// GetCommit returns the Commit field.
func (r *RepositoryCommit) GetCommit() *Commit {
	if r == nil {
		return nil
	}
	return r.Commit
}

// GetCommitter returns the Committer field.
func (r *RepositoryCommit) GetCommitter() *User {
	if r == nil {
		return nil
	}
	return r.Committer
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryCommit) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *RepositoryCommit) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *RepositoryCommit) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetStats returns the Stats field.
func (r *RepositoryCommit) GetStats() *CommitStats {
	if r == nil {
		return nil
	}
	return r.Stats
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryCommit) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetDownloadURL returns the DownloadURL field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetDownloadURL() string {
	if r == nil || r.DownloadURL == nil {
		return ""
	}
	return *r.DownloadURL
}

// GetEncoding returns the Encoding field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetEncoding() string {
	if r == nil || r.Encoding == nil {
		return ""
	}
	return *r.Encoding
}

// GetGitURL returns the GitURL field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetGitURL() string {
	if r == nil || r.GitURL == nil {
		return ""
	}
	return *r.GitURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetPath() string {
	if r == nil || r.Path == nil {
		return ""
	}
	return *r.Path
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetSize() int {
	if r == nil || r.Size == nil {
		return 0
	}
	return *r.Size
}

// GetSubmoduleGitURL returns the SubmoduleGitURL field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetSubmoduleGitURL() string {
	if r == nil || r.SubmoduleGitURL == nil {
		return ""
	}
	return *r.SubmoduleGitURL
}

// GetTarget returns the Target field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetTarget() string {
	if r == nil || r.Target == nil {
		return ""
	}
	return *r.Target
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryContent) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetAuthor returns the Author field.
func (r *RepositoryContentFileOptions) GetAuthor() *CommitAuthor {
	if r == nil {
		return nil
	}
	return r.Author
}

// GetBranch returns the Branch field if it's non-nil, zero value otherwise.
func (r *RepositoryContentFileOptions) GetBranch() string {
	if r == nil || r.Branch == nil {
		return ""
	}
	return *r.Branch
}

// GetCommitter returns the Committer field.
func (r *RepositoryContentFileOptions) GetCommitter() *CommitAuthor {
	if r == nil {
		return nil
	}
	return r.Committer
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (r *RepositoryContentFileOptions) GetMessage() string {
	if r == nil || r.Message == nil {
		return ""
	}
	return *r.Message
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *RepositoryContentFileOptions) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetContent returns the Content field.
func (r *RepositoryContentResponse) GetContent() *RepositoryContent {
	if r == nil {
		return nil
	}
	return r.Content
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *RepositoryDispatchEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetBranch returns the Branch field if it's non-nil, zero value otherwise.
func (r *RepositoryDispatchEvent) GetBranch() string {
	if r == nil || r.Branch == nil {
		return ""
	}
	return *r.Branch
}

// GetInstallation returns the Installation field.
func (r *RepositoryDispatchEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrg returns the Org field.
func (r *RepositoryDispatchEvent) GetOrg() *Organization {
	if r == nil {
		return nil
	}
	return r.Org
}

// GetRepo returns the Repo field.
func (r *RepositoryDispatchEvent) GetRepo() *Repository {
	if r == nil {
		return nil
	}
	return r.Repo
}

// GetSender returns the Sender field.
func (r *RepositoryDispatchEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *RepositoryEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetChanges returns the Changes field.
func (r *RepositoryEvent) GetChanges() *EditChange {
	if r == nil {
		return nil
	}
	return r.Changes
}

// GetInstallation returns the Installation field.
func (r *RepositoryEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrg returns the Org field.
func (r *RepositoryEvent) GetOrg() *Organization {
	if r == nil {
		return nil
	}
	return r.Org
}

// GetRepo returns the Repo field.
func (r *RepositoryEvent) GetRepo() *Repository {
	if r == nil {
		return nil
	}
	return r.Repo
}

// GetSender returns the Sender field.
func (r *RepositoryEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetOrg returns the Org field.
func (r *RepositoryImportEvent) GetOrg() *Organization {
	if r == nil {
		return nil
	}
	return r.Org
}

// GetRepo returns the Repo field.
func (r *RepositoryImportEvent) GetRepo() *Repository {
	if r == nil {
		return nil
	}
	return r.Repo
}

// GetSender returns the Sender field.
func (r *RepositoryImportEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (r *RepositoryImportEvent) GetStatus() string {
	if r == nil || r.Status == nil {
		return ""
	}
	return *r.Status
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetExpired returns the Expired field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetExpired() bool {
	if r == nil || r.Expired == nil {
		return false
	}
	return *r.Expired
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetInvitee returns the Invitee field.
func (r *RepositoryInvitation) GetInvitee() *User {
	if r == nil {
		return nil
	}
	return r.Invitee
}

// GetInviter returns the Inviter field.
func (r *RepositoryInvitation) GetInviter() *User {
	if r == nil {
		return nil
	}
	return r.Inviter
}

// GetPermissions returns the Permissions field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetPermissions() string {
	if r == nil || r.Permissions == nil {
		return ""
	}
	return *r.Permissions
}

// GetRepo returns the Repo field.
func (r *RepositoryInvitation) GetRepo() *Repository {
	if r == nil {
		return nil
	}
	return r.Repo
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryInvitation) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetContent returns the Content field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetContent() string {
	if r == nil || r.Content == nil {
		return ""
	}
	return *r.Content
}

// GetDownloadURL returns the DownloadURL field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetDownloadURL() string {
	if r == nil || r.DownloadURL == nil {
		return ""
	}
	return *r.DownloadURL
}

// GetEncoding returns the Encoding field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetEncoding() string {
	if r == nil || r.Encoding == nil {
		return ""
	}
	return *r.Encoding
}

// GetGitURL returns the GitURL field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetGitURL() string {
	if r == nil || r.GitURL == nil {
		return ""
	}
	return *r.GitURL
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetLicense returns the License field.
func (r *RepositoryLicense) GetLicense() *License {
	if r == nil {
		return nil
	}
	return r.License
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetPath() string {
	if r == nil || r.Path == nil {
		return ""
	}
	return *r.Path
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetSize() int {
	if r == nil || r.Size == nil {
		return 0
	}
	return *r.Size
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryLicense) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetIncludesParents returns the IncludesParents field if it's non-nil, zero value otherwise.
func (r *RepositoryListRulesetsOptions) GetIncludesParents() bool {
	if r == nil || r.IncludesParents == nil {
		return false
	}
	return *r.IncludesParents
}

// GetBase returns the Base field if it's non-nil, zero value otherwise.
func (r *RepositoryMergeRequest) GetBase() string {
	if r == nil || r.Base == nil {
		return ""
	}
	return *r.Base
}

// GetCommitMessage returns the CommitMessage field if it's non-nil, zero value otherwise.
func (r *RepositoryMergeRequest) GetCommitMessage() string {
	if r == nil || r.CommitMessage == nil {
		return ""
	}
	return *r.CommitMessage
}

// GetHead returns the Head field if it's non-nil, zero value otherwise.
func (r *RepositoryMergeRequest) GetHead() string {
	if r == nil || r.Head == nil {
		return ""
	}
	return *r.Head
}

// GetPermission returns the Permission field if it's non-nil, zero value otherwise.
func (r *RepositoryPermissionLevel) GetPermission() string {
	if r == nil || r.Permission == nil {
		return ""
	}
	return *r.Permission
}

// GetRoleName returns the RoleName field if it's non-nil, zero value otherwise.
func (r *RepositoryPermissionLevel) GetRoleName() string {
	if r == nil || r.RoleName == nil {
		return ""
	}
	return *r.RoleName
}

// GetUser returns the User field.
func (r *RepositoryPermissionLevel) GetUser() *User {
	if r == nil {
		return nil
	}
	return r.User
}

// GetAssetsURL returns the AssetsURL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetAssetsURL() string {
	if r == nil || r.AssetsURL == nil {
		return ""
	}
	return *r.AssetsURL
}

// GetAuthor returns the Author field.
func (r *RepositoryRelease) GetAuthor() *User {
	if r == nil {
		return nil
	}
	return r.Author
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetBody() string {
	if r == nil || r.Body == nil {
		return ""
	}
	return *r.Body
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetDiscussionCategoryName returns the DiscussionCategoryName field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetDiscussionCategoryName() string {
	if r == nil || r.DiscussionCategoryName == nil {
		return ""
	}
	return *r.DiscussionCategoryName
}

// GetDraft returns the Draft field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetDraft() bool {
	if r == nil || r.Draft == nil {
		return false
	}
	return *r.Draft
}

// GetGenerateReleaseNotes returns the GenerateReleaseNotes field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetGenerateReleaseNotes() bool {
	if r == nil || r.GenerateReleaseNotes == nil {
		return false
	}
	return *r.GenerateReleaseNotes
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetHTMLURL() string {
	if r == nil || r.HTMLURL == nil {
		return ""
	}
	return *r.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetMakeLatest returns the MakeLatest field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetMakeLatest() string {
	if r == nil || r.MakeLatest == nil {
		return ""
	}
	return *r.MakeLatest
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetPrerelease returns the Prerelease field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetPrerelease() bool {
	if r == nil || r.Prerelease == nil {
		return false
	}
	return *r.Prerelease
}

// GetPublishedAt returns the PublishedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetPublishedAt() Timestamp {
	if r == nil || r.PublishedAt == nil {
		return Timestamp{}
	}
	return *r.PublishedAt
}

// GetTagName returns the TagName field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetTagName() string {
	if r == nil || r.TagName == nil {
		return ""
	}
	return *r.TagName
}

// GetTarballURL returns the TarballURL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetTarballURL() string {
	if r == nil || r.TarballURL == nil {
		return ""
	}
	return *r.TarballURL
}

// GetTargetCommitish returns the TargetCommitish field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetTargetCommitish() string {
	if r == nil || r.TargetCommitish == nil {
		return ""
	}
	return *r.TargetCommitish
}

// GetUploadURL returns the UploadURL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetUploadURL() string {
	if r == nil || r.UploadURL == nil {
		return ""
	}
	return *r.UploadURL
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetZipballURL returns the ZipballURL field if it's non-nil, zero value otherwise.
func (r *RepositoryRelease) GetZipballURL() string {
	if r == nil || r.ZipballURL == nil {
		return ""
	}
	return *r.ZipballURL
}

// GetConditions returns the Conditions field.
func (r *RepositoryRuleset) GetConditions() *RepositoryRulesetConditions {
	if r == nil {
		return nil
	}
	return r.Conditions
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryRuleset) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetCurrentUserCanBypass returns the CurrentUserCanBypass field.
func (r *RepositoryRuleset) GetCurrentUserCanBypass() *BypassMode {
	if r == nil {
		return nil
	}
	return r.CurrentUserCanBypass
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepositoryRuleset) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetLinks returns the Links field.
func (r *RepositoryRuleset) GetLinks() *RepositoryRulesetLinks {
	if r == nil {
		return nil
	}
	return r.Links
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *RepositoryRuleset) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetRules returns the Rules field.
func (r *RepositoryRuleset) GetRules() *RepositoryRulesetRules {
	if r == nil {
		return nil
	}
	return r.Rules
}

// GetSourceType returns the SourceType field.
func (r *RepositoryRuleset) GetSourceType() *RulesetSourceType {
	if r == nil {
		return nil
	}
	return r.SourceType
}

// GetTarget returns the Target field.
func (r *RepositoryRuleset) GetTarget() *RulesetTarget {
	if r == nil {
		return nil
	}
	return r.Target
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryRuleset) GetUpdatedAt() Timestamp {
	if r == nil || r.UpdatedAt == nil {
		return Timestamp{}
	}
	return *r.UpdatedAt
}

// GetConfiguration returns the Configuration field.
func (r *RepositoryRulesetChangedRule) GetConfiguration() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.Configuration
}

// GetPattern returns the Pattern field.
func (r *RepositoryRulesetChangedRule) GetPattern() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.Pattern
}

// GetRuleType returns the RuleType field.
func (r *RepositoryRulesetChangedRule) GetRuleType() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.RuleType
}

// GetConditions returns the Conditions field.
func (r *RepositoryRulesetChanges) GetConditions() *RepositoryRulesetChangedConditions {
	if r == nil {
		return nil
	}
	return r.Conditions
}

// GetEnforcement returns the Enforcement field.
func (r *RepositoryRulesetChanges) GetEnforcement() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.Enforcement
}

// GetName returns the Name field.
func (r *RepositoryRulesetChanges) GetName() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.Name
}

// GetRules returns the Rules field.
func (r *RepositoryRulesetChanges) GetRules() *RepositoryRulesetChangedRules {
	if r == nil {
		return nil
	}
	return r.Rules
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RepositoryRulesetChangeSource) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetOrganizationID returns the OrganizationID field.
func (r *RepositoryRulesetConditions) GetOrganizationID() *RepositoryRulesetOrganizationIDsConditionParameters {
	if r == nil {
		return nil
	}
	return r.OrganizationID
}

// GetOrganizationName returns the OrganizationName field.
func (r *RepositoryRulesetConditions) GetOrganizationName() *RepositoryRulesetOrganizationNamesConditionParameters {
	if r == nil {
		return nil
	}
	return r.OrganizationName
}

// GetRefName returns the RefName field.
func (r *RepositoryRulesetConditions) GetRefName() *RepositoryRulesetRefConditionParameters {
	if r == nil {
		return nil
	}
	return r.RefName
}

// GetRepositoryID returns the RepositoryID field.
func (r *RepositoryRulesetConditions) GetRepositoryID() *RepositoryRulesetRepositoryIDsConditionParameters {
	if r == nil {
		return nil
	}
	return r.RepositoryID
}

// GetRepositoryName returns the RepositoryName field.
func (r *RepositoryRulesetConditions) GetRepositoryName() *RepositoryRulesetRepositoryNamesConditionParameters {
	if r == nil {
		return nil
	}
	return r.RepositoryName
}

// GetRepositoryProperty returns the RepositoryProperty field.
func (r *RepositoryRulesetConditions) GetRepositoryProperty() *RepositoryRulesetRepositoryPropertyConditionParameters {
	if r == nil {
		return nil
	}
	return r.RepositoryProperty
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *RepositoryRulesetEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetChanges returns the Changes field.
func (r *RepositoryRulesetEvent) GetChanges() *RepositoryRulesetChanges {
	if r == nil {
		return nil
	}
	return r.Changes
}

// GetEnterprise returns the Enterprise field.
func (r *RepositoryRulesetEvent) GetEnterprise() *Enterprise {
	if r == nil {
		return nil
	}
	return r.Enterprise
}

// GetInstallation returns the Installation field.
func (r *RepositoryRulesetEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrganization returns the Organization field.
func (r *RepositoryRulesetEvent) GetOrganization() *Organization {
	if r == nil {
		return nil
	}
	return r.Organization
}

// GetRepository returns the Repository field.
func (r *RepositoryRulesetEvent) GetRepository() *Repository {
	if r == nil {
		return nil
	}
	return r.Repository
}

// GetRepositoryRuleset returns the RepositoryRuleset field.
func (r *RepositoryRulesetEvent) GetRepositoryRuleset() *RepositoryRuleset {
	if r == nil {
		return nil
	}
	return r.RepositoryRuleset
}

// GetSender returns the Sender field.
func (r *RepositoryRulesetEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetHRef returns the HRef field if it's non-nil, zero value otherwise.
func (r *RepositoryRulesetLink) GetHRef() string {
	if r == nil || r.HRef == nil {
		return ""
	}
	return *r.HRef
}

// GetHTML returns the HTML field.
func (r *RepositoryRulesetLinks) GetHTML() *RepositoryRulesetLink {
	if r == nil {
		return nil
	}
	return r.HTML
}

// GetSelf returns the Self field.
func (r *RepositoryRulesetLinks) GetSelf() *RepositoryRulesetLink {
	if r == nil {
		return nil
	}
	return r.Self
}

// GetProtected returns the Protected field if it's non-nil, zero value otherwise.
func (r *RepositoryRulesetRepositoryNamesConditionParameters) GetProtected() bool {
	if r == nil || r.Protected == nil {
		return false
	}
	return *r.Protected
}

// GetSource returns the Source field if it's non-nil, zero value otherwise.
func (r *RepositoryRulesetRepositoryPropertyTargetParameters) GetSource() string {
	if r == nil || r.Source == nil {
		return ""
	}
	return *r.Source
}

// GetBranchNamePattern returns the BranchNamePattern field.
func (r *RepositoryRulesetRules) GetBranchNamePattern() *PatternRuleParameters {
	if r == nil {
		return nil
	}
	return r.BranchNamePattern
}

// GetCodeScanning returns the CodeScanning field.
func (r *RepositoryRulesetRules) GetCodeScanning() *CodeScanningRuleParameters {
	if r == nil {
		return nil
	}
	return r.CodeScanning
}

// GetCommitAuthorEmailPattern returns the CommitAuthorEmailPattern field.
func (r *RepositoryRulesetRules) GetCommitAuthorEmailPattern() *PatternRuleParameters {
	if r == nil {
		return nil
	}
	return r.CommitAuthorEmailPattern
}

// GetCommitMessagePattern returns the CommitMessagePattern field.
func (r *RepositoryRulesetRules) GetCommitMessagePattern() *PatternRuleParameters {
	if r == nil {
		return nil
	}
	return r.CommitMessagePattern
}

// GetCommitterEmailPattern returns the CommitterEmailPattern field.
func (r *RepositoryRulesetRules) GetCommitterEmailPattern() *PatternRuleParameters {
	if r == nil {
		return nil
	}
	return r.CommitterEmailPattern
}

// GetCreation returns the Creation field.
func (r *RepositoryRulesetRules) GetCreation() *EmptyRuleParameters {
	if r == nil {
		return nil
	}
	return r.Creation
}

// GetDeletion returns the Deletion field.
func (r *RepositoryRulesetRules) GetDeletion() *EmptyRuleParameters {
	if r == nil {
		return nil
	}
	return r.Deletion
}

// GetFileExtensionRestriction returns the FileExtensionRestriction field.
func (r *RepositoryRulesetRules) GetFileExtensionRestriction() *FileExtensionRestrictionRuleParameters {
	if r == nil {
		return nil
	}
	return r.FileExtensionRestriction
}

// GetFilePathRestriction returns the FilePathRestriction field.
func (r *RepositoryRulesetRules) GetFilePathRestriction() *FilePathRestrictionRuleParameters {
	if r == nil {
		return nil
	}
	return r.FilePathRestriction
}

// GetMaxFilePathLength returns the MaxFilePathLength field.
func (r *RepositoryRulesetRules) GetMaxFilePathLength() *MaxFilePathLengthRuleParameters {
	if r == nil {
		return nil
	}
	return r.MaxFilePathLength
}

// GetMaxFileSize returns the MaxFileSize field.
func (r *RepositoryRulesetRules) GetMaxFileSize() *MaxFileSizeRuleParameters {
	if r == nil {
		return nil
	}
	return r.MaxFileSize
}

// GetMergeQueue returns the MergeQueue field.
func (r *RepositoryRulesetRules) GetMergeQueue() *MergeQueueRuleParameters {
	if r == nil {
		return nil
	}
	return r.MergeQueue
}

// GetNonFastForward returns the NonFastForward field.
func (r *RepositoryRulesetRules) GetNonFastForward() *EmptyRuleParameters {
	if r == nil {
		return nil
	}
	return r.NonFastForward
}

// GetPullRequest returns the PullRequest field.
func (r *RepositoryRulesetRules) GetPullRequest() *PullRequestRuleParameters {
	if r == nil {
		return nil
	}
	return r.PullRequest
}

// GetRequiredDeployments returns the RequiredDeployments field.
func (r *RepositoryRulesetRules) GetRequiredDeployments() *RequiredDeploymentsRuleParameters {
	if r == nil {
		return nil
	}
	return r.RequiredDeployments
}

// GetRequiredLinearHistory returns the RequiredLinearHistory field.
func (r *RepositoryRulesetRules) GetRequiredLinearHistory() *EmptyRuleParameters {
	if r == nil {
		return nil
	}
	return r.RequiredLinearHistory
}

// GetRequiredSignatures returns the RequiredSignatures field.
func (r *RepositoryRulesetRules) GetRequiredSignatures() *EmptyRuleParameters {
	if r == nil {
		return nil
	}
	return r.RequiredSignatures
}

// GetRequiredStatusChecks returns the RequiredStatusChecks field.
func (r *RepositoryRulesetRules) GetRequiredStatusChecks() *RequiredStatusChecksRuleParameters {
	if r == nil {
		return nil
	}
	return r.RequiredStatusChecks
}

// GetTagNamePattern returns the TagNamePattern field.
func (r *RepositoryRulesetRules) GetTagNamePattern() *PatternRuleParameters {
	if r == nil {
		return nil
	}
	return r.TagNamePattern
}

// GetUpdate returns the Update field.
func (r *RepositoryRulesetRules) GetUpdate() *UpdateRuleParameters {
	if r == nil {
		return nil
	}
	return r.Update
}

// GetWorkflows returns the Workflows field.
func (r *RepositoryRulesetRules) GetWorkflows() *WorkflowsRuleParameters {
	if r == nil {
		return nil
	}
	return r.Workflows
}

// GetConditionType returns the ConditionType field.
func (r *RepositoryRulesetUpdatedCondition) GetConditionType() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.ConditionType
}

// GetExclude returns the Exclude field.
func (r *RepositoryRulesetUpdatedCondition) GetExclude() *RepositoryRulesetChangeSources {
	if r == nil {
		return nil
	}
	return r.Exclude
}

// GetInclude returns the Include field.
func (r *RepositoryRulesetUpdatedCondition) GetInclude() *RepositoryRulesetChangeSources {
	if r == nil {
		return nil
	}
	return r.Include
}

// GetTarget returns the Target field.
func (r *RepositoryRulesetUpdatedCondition) GetTarget() *RepositoryRulesetChangeSource {
	if r == nil {
		return nil
	}
	return r.Target
}

// GetChanges returns the Changes field.
func (r *RepositoryRulesetUpdatedConditions) GetChanges() *RepositoryRulesetUpdatedCondition {
	if r == nil {
		return nil
	}
	return r.Changes
}

// GetCondition returns the Condition field.
func (r *RepositoryRulesetUpdatedConditions) GetCondition() *RepositoryRulesetConditions {
	if r == nil {
		return nil
	}
	return r.Condition
}

// GetChanges returns the Changes field.
func (r *RepositoryRulesetUpdatedRules) GetChanges() *RepositoryRulesetChangedRule {
	if r == nil {
		return nil
	}
	return r.Changes
}

// GetRule returns the Rule field.
func (r *RepositoryRulesetUpdatedRules) GetRule() *RepositoryRule {
	if r == nil {
		return nil
	}
	return r.Rule
}

// GetCommit returns the Commit field.
func (r *RepositoryTag) GetCommit() *Commit {
	if r == nil {
		return nil
	}
	return r.Commit
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RepositoryTag) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetTarballURL returns the TarballURL field if it's non-nil, zero value otherwise.
func (r *RepositoryTag) GetTarballURL() string {
	if r == nil || r.TarballURL == nil {
		return ""
	}
	return *r.TarballURL
}

// GetZipballURL returns the ZipballURL field if it's non-nil, zero value otherwise.
func (r *RepositoryTag) GetZipballURL() string {
	if r == nil || r.ZipballURL == nil {
		return ""
	}
	return *r.ZipballURL
}

// GetAffectedPackageName returns the AffectedPackageName field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetAffectedPackageName() string {
	if r == nil || r.AffectedPackageName == nil {
		return ""
	}
	return *r.AffectedPackageName
}

// GetAffectedRange returns the AffectedRange field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetAffectedRange() string {
	if r == nil || r.AffectedRange == nil {
		return ""
	}
	return *r.AffectedRange
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetDismissedAt returns the DismissedAt field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetDismissedAt() Timestamp {
	if r == nil || r.DismissedAt == nil {
		return Timestamp{}
	}
	return *r.DismissedAt
}

// GetDismisser returns the Dismisser field.
func (r *RepositoryVulnerabilityAlert) GetDismisser() *User {
	if r == nil {
		return nil
	}
	return r.Dismisser
}

// GetDismissReason returns the DismissReason field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetDismissReason() string {
	if r == nil || r.DismissReason == nil {
		return ""
	}
	return *r.DismissReason
}

// GetExternalIdentifier returns the ExternalIdentifier field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetExternalIdentifier() string {
	if r == nil || r.ExternalIdentifier == nil {
		return ""
	}
	return *r.ExternalIdentifier
}

// GetExternalReference returns the ExternalReference field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetExternalReference() string {
	if r == nil || r.ExternalReference == nil {
		return ""
	}
	return *r.ExternalReference
}

// GetFixedIn returns the FixedIn field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetFixedIn() string {
	if r == nil || r.FixedIn == nil {
		return ""
	}
	return *r.FixedIn
}

// GetGitHubSecurityAdvisoryID returns the GitHubSecurityAdvisoryID field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetGitHubSecurityAdvisoryID() string {
	if r == nil || r.GitHubSecurityAdvisoryID == nil {
		return ""
	}
	return *r.GitHubSecurityAdvisoryID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlert) GetSeverity() string {
	if r == nil || r.Severity == nil {
		return ""
	}
	return *r.Severity
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (r *RepositoryVulnerabilityAlertEvent) GetAction() string {
	if r == nil || r.Action == nil {
		return ""
	}
	return *r.Action
}

// GetAlert returns the Alert field.
func (r *RepositoryVulnerabilityAlertEvent) GetAlert() *RepositoryVulnerabilityAlert {
	if r == nil {
		return nil
	}
	return r.Alert
}

// GetInstallation returns the Installation field.
func (r *RepositoryVulnerabilityAlertEvent) GetInstallation() *Installation {
	if r == nil {
		return nil
	}
	return r.Installation
}

// GetOrg returns the Org field.
func (r *RepositoryVulnerabilityAlertEvent) GetOrg() *Organization {
	if r == nil {
		return nil
	}
	return r.Org
}

// GetRepository returns the Repository field.
func (r *RepositoryVulnerabilityAlertEvent) GetRepository() *Repository {
	if r == nil {
		return nil
	}
	return r.Repository
}

// GetSender returns the Sender field.
func (r *RepositoryVulnerabilityAlertEvent) GetSender() *User {
	if r == nil {
		return nil
	}
	return r.Sender
}

// GetForkRepos returns the ForkRepos field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetForkRepos() int {
	if r == nil || r.ForkRepos == nil {
		return 0
	}
	return *r.ForkRepos
}

// GetOrgRepos returns the OrgRepos field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetOrgRepos() int {
	if r == nil || r.OrgRepos == nil {
		return 0
	}
	return *r.OrgRepos
}

// GetRootRepos returns the RootRepos field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetRootRepos() int {
	if r == nil || r.RootRepos == nil {
		return 0
	}
	return *r.RootRepos
}

// GetTotalPushes returns the TotalPushes field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetTotalPushes() int {
	if r == nil || r.TotalPushes == nil {
		return 0
	}
	return *r.TotalPushes
}

// GetTotalRepos returns the TotalRepos field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetTotalRepos() int {
	if r == nil || r.TotalRepos == nil {
		return 0
	}
	return *r.TotalRepos
}

// GetTotalWikis returns the TotalWikis field if it's non-nil, zero value otherwise.
func (r *RepoStats) GetTotalWikis() int {
	if r == nil || r.TotalWikis == nil {
		return 0
	}
	return *r.TotalWikis
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetAvatarURL() string {
	if r == nil || r.AvatarURL == nil {
		return ""
	}
	return *r.AvatarURL
}

// GetContext returns the Context field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetContext() string {
	if r == nil || r.Context == nil {
		return ""
	}
	return *r.Context
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetCreatedAt() Timestamp {
	if r == nil || r.CreatedAt == nil {
		return Timestamp{}
	}
	return *r.CreatedAt
}

// GetCreator returns the Creator field.
func (r *RepoStatus) GetCreator() *User {
	if r == nil {
		return nil
	}
	return r.Creator
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetDescription() string {
	if r == nil || r.Description == nil {
		return ""
	}
	return *r.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetState() string {
	if r == nil || r.State == nil {
		return ""
	}
	return *r.State
}

// GetTargetURL returns the TargetURL field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetTargetURL() string {
	if r == nil || r.TargetURL == nil {
		return ""
	}
	return *r.TargetURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetUpdatedAt() Timestamp {
	if r == nil || r.UpdatedAt == nil {
		return Timestamp{}
	}
	return *r.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RepoStatus) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RequireCodeOwnerReviewChanges) GetFrom() bool {
	if r == nil || r.From == nil {
		return false
	}
	return *r.From
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RequiredConversationResolutionLevelChanges) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RequiredDeploymentsEnforcementLevelChanges) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RequiredReviewer) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetAppID returns the AppID field if it's non-nil, zero value otherwise.
func (r *RequiredStatusCheck) GetAppID() int64 {
	if r == nil || r.AppID == nil {
		return 0
	}
	return *r.AppID
}

// GetChecks returns the Checks field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecks) GetChecks() []*RequiredStatusCheck {
	if r == nil || r.Checks == nil {
		return nil
	}
	return *r.Checks
}

// GetContexts returns the Contexts field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecks) GetContexts() []string {
	if r == nil || r.Contexts == nil {
		return nil
	}
	return *r.Contexts
}

// GetContextsURL returns the ContextsURL field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecks) GetContextsURL() string {
	if r == nil || r.ContextsURL == nil {
		return ""
	}
	return *r.ContextsURL
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecks) GetURL() string {
	if r == nil || r.URL == nil {
		return ""
	}
	return *r.URL
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecksEnforcementLevelChanges) GetFrom() string {
	if r == nil || r.From == nil {
		return ""
	}
	return *r.From
}

// GetStrict returns the Strict field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecksRequest) GetStrict() bool {
	if r == nil || r.Strict == nil {
		return false
	}
	return *r.Strict
}

// GetDoNotEnforceOnCreate returns the DoNotEnforceOnCreate field if it's non-nil, zero value otherwise.
func (r *RequiredStatusChecksRuleParameters) GetDoNotEnforceOnCreate() bool {
	if r == nil || r.DoNotEnforceOnCreate == nil {
		return false
	}
	return *r.DoNotEnforceOnCreate
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (r *ReviewersRequest) GetNodeID() string {
	if r == nil || r.NodeID == nil {
		return ""
	}
	return *r.NodeID
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (r *ReviewPersonalAccessTokenRequestOptions) GetReason() string {
	if r == nil || r.Reason == nil {
		return ""
	}
	return *r.Reason
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (r *Rule) GetDescription() string {
	if r == nil || r.Description == nil {
		return ""
	}
	return *r.Description
}

// GetFullDescription returns the FullDescription field if it's non-nil, zero value otherwise.
func (r *Rule) GetFullDescription() string {
	if r == nil || r.FullDescription == nil {
		return ""
	}
	return *r.FullDescription
}

// GetHelp returns the Help field if it's non-nil, zero value otherwise.
func (r *Rule) GetHelp() string {
	if r == nil || r.Help == nil {
		return ""
	}
	return *r.Help
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *Rule) GetID() string {
	if r == nil || r.ID == nil {
		return ""
	}
	return *r.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *Rule) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetSecuritySeverityLevel returns the SecuritySeverityLevel field if it's non-nil, zero value otherwise.
func (r *Rule) GetSecuritySeverityLevel() string {
	if r == nil || r.SecuritySeverityLevel == nil {
		return ""
	}
	return *r.SecuritySeverityLevel
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (r *Rule) GetSeverity() string {
	if r == nil || r.Severity == nil {
		return ""
	}
	return *r.Severity
}

// GetIntegrationID returns the IntegrationID field if it's non-nil, zero value otherwise.
func (r *RuleStatusCheck) GetIntegrationID() int64 {
	if r == nil || r.IntegrationID == nil {
		return 0
	}
	return *r.IntegrationID
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (r *RuleWorkflow) GetRef() string {
	if r == nil || r.Ref == nil {
		return ""
	}
	return *r.Ref
}

// GetRepositoryID returns the RepositoryID field if it's non-nil, zero value otherwise.
func (r *RuleWorkflow) GetRepositoryID() int64 {
	if r == nil || r.RepositoryID == nil {
		return 0
	}
	return *r.RepositoryID
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (r *RuleWorkflow) GetSHA() string {
	if r == nil || r.SHA == nil {
		return ""
	}
	return *r.SHA
}

// GetBusy returns the Busy field if it's non-nil, zero value otherwise.
func (r *Runner) GetBusy() bool {
	if r == nil || r.Busy == nil {
		return false
	}
	return *r.Busy
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *Runner) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *Runner) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetOS returns the OS field if it's non-nil, zero value otherwise.
func (r *Runner) GetOS() string {
	if r == nil || r.OS == nil {
		return ""
	}
	return *r.OS
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (r *Runner) GetStatus() string {
	if r == nil || r.Status == nil {
		return ""
	}
	return *r.Status
}

// GetArchitecture returns the Architecture field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetArchitecture() string {
	if r == nil || r.Architecture == nil {
		return ""
	}
	return *r.Architecture
}

// GetDownloadURL returns the DownloadURL field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetDownloadURL() string {
	if r == nil || r.DownloadURL == nil {
		return ""
	}
	return *r.DownloadURL
}

// GetFilename returns the Filename field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetFilename() string {
	if r == nil || r.Filename == nil {
		return ""
	}
	return *r.Filename
}

// GetOS returns the OS field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetOS() string {
	if r == nil || r.OS == nil {
		return ""
	}
	return *r.OS
}

// GetSHA256Checksum returns the SHA256Checksum field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetSHA256Checksum() string {
	if r == nil || r.SHA256Checksum == nil {
		return ""
	}
	return *r.SHA256Checksum
}

// GetTempDownloadToken returns the TempDownloadToken field if it's non-nil, zero value otherwise.
func (r *RunnerApplicationDownload) GetTempDownloadToken() string {
	if r == nil || r.TempDownloadToken == nil {
		return ""
	}
	return *r.TempDownloadToken
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetAllowsPublicRepositories() bool {
	if r == nil || r.AllowsPublicRepositories == nil {
		return false
	}
	return *r.AllowsPublicRepositories
}

// GetDefault returns the Default field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetDefault() bool {
	if r == nil || r.Default == nil {
		return false
	}
	return *r.Default
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetInherited returns the Inherited field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetInherited() bool {
	if r == nil || r.Inherited == nil {
		return false
	}
	return *r.Inherited
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetRestrictedToWorkflows() bool {
	if r == nil || r.RestrictedToWorkflows == nil {
		return false
	}
	return *r.RestrictedToWorkflows
}

// GetRunnersURL returns the RunnersURL field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetRunnersURL() string {
	if r == nil || r.RunnersURL == nil {
		return ""
	}
	return *r.RunnersURL
}

// GetSelectedRepositoriesURL returns the SelectedRepositoriesURL field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetSelectedRepositoriesURL() string {
	if r == nil || r.SelectedRepositoriesURL == nil {
		return ""
	}
	return *r.SelectedRepositoriesURL
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetVisibility() string {
	if r == nil || r.Visibility == nil {
		return ""
	}
	return *r.Visibility
}

// GetWorkflowRestrictionsReadOnly returns the WorkflowRestrictionsReadOnly field if it's non-nil, zero value otherwise.
func (r *RunnerGroup) GetWorkflowRestrictionsReadOnly() bool {
	if r == nil || r.WorkflowRestrictionsReadOnly == nil {
		return false
	}
	return *r.WorkflowRestrictionsReadOnly
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (r *RunnerLabels) GetID() int64 {
	if r == nil || r.ID == nil {
		return 0
	}
	return *r.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (r *RunnerLabels) GetName() string {
	if r == nil || r.Name == nil {
		return ""
	}
	return *r.Name
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (r *RunnerLabels) GetType() string {
	if r == nil || r.Type == nil {
		return ""
	}
	return *r.Type
}

// GetCheckoutURI returns the CheckoutURI field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetCheckoutURI() string {
	if s == nil || s.CheckoutURI == nil {
		return ""
	}
	return *s.CheckoutURI
}

// GetCommitSHA returns the CommitSHA field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetCommitSHA() string {
	if s == nil || s.CommitSHA == nil {
		return ""
	}
	return *s.CommitSHA
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetRef() string {
	if s == nil || s.Ref == nil {
		return ""
	}
	return *s.Ref
}

// GetSarif returns the Sarif field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetSarif() string {
	if s == nil || s.Sarif == nil {
		return ""
	}
	return *s.Sarif
}

// GetStartedAt returns the StartedAt field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetStartedAt() Timestamp {
	if s == nil || s.StartedAt == nil {
		return Timestamp{}
	}
	return *s.StartedAt
}

// GetToolName returns the ToolName field if it's non-nil, zero value otherwise.
func (s *SarifAnalysis) GetToolName() string {
	if s == nil || s.ToolName == nil {
		return ""
	}
	return *s.ToolName
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *SarifID) GetID() string {
	if s == nil || s.ID == nil {
		return ""
	}
	return *s.ID
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *SarifID) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetAnalysesURL returns the AnalysesURL field if it's non-nil, zero value otherwise.
func (s *SARIFUpload) GetAnalysesURL() string {
	if s == nil || s.AnalysesURL == nil {
		return ""
	}
	return *s.AnalysesURL
}

// GetProcessingStatus returns the ProcessingStatus field if it's non-nil, zero value otherwise.
func (s *SARIFUpload) GetProcessingStatus() string {
	if s == nil || s.ProcessingStatus == nil {
		return ""
	}
	return *s.ProcessingStatus
}

// GetSBOM returns the SBOM field.
func (s *SBOM) GetSBOM() *SBOMInfo {
	if s == nil {
		return nil
	}
	return s.SBOM
}

// GetCreationInfo returns the CreationInfo field.
func (s *SBOMInfo) GetCreationInfo() *CreationInfo {
	if s == nil {
		return nil
	}
	return s.CreationInfo
}

// GetDataLicense returns the DataLicense field if it's non-nil, zero value otherwise.
func (s *SBOMInfo) GetDataLicense() string {
	if s == nil || s.DataLicense == nil {
		return ""
	}
	return *s.DataLicense
}

// GetDocumentNamespace returns the DocumentNamespace field if it's non-nil, zero value otherwise.
func (s *SBOMInfo) GetDocumentNamespace() string {
	if s == nil || s.DocumentNamespace == nil {
		return ""
	}
	return *s.DocumentNamespace
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (s *SBOMInfo) GetName() string {
	if s == nil || s.Name == nil {
		return ""
	}
	return *s.Name
}

// GetSPDXID returns the SPDXID field if it's non-nil, zero value otherwise.
func (s *SBOMInfo) GetSPDXID() string {
	if s == nil || s.SPDXID == nil {
		return ""
	}
	return *s.SPDXID
}

// GetSPDXVersion returns the SPDXVersion field if it's non-nil, zero value otherwise.
func (s *SBOMInfo) GetSPDXVersion() string {
	if s == nil || s.SPDXVersion == nil {
		return ""
	}
	return *s.SPDXVersion
}

// GetAnalysisKey returns the AnalysisKey field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetAnalysisKey() string {
	if s == nil || s.AnalysisKey == nil {
		return ""
	}
	return *s.AnalysisKey
}

// GetCategory returns the Category field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetCategory() string {
	if s == nil || s.Category == nil {
		return ""
	}
	return *s.Category
}

// GetCommitSHA returns the CommitSHA field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetCommitSHA() string {
	if s == nil || s.CommitSHA == nil {
		return ""
	}
	return *s.CommitSHA
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetDeletable returns the Deletable field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetDeletable() bool {
	if s == nil || s.Deletable == nil {
		return false
	}
	return *s.Deletable
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetEnvironment() string {
	if s == nil || s.Environment == nil {
		return ""
	}
	return *s.Environment
}

// GetError returns the Error field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetError() string {
	if s == nil || s.Error == nil {
		return ""
	}
	return *s.Error
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetID() int64 {
	if s == nil || s.ID == nil {
		return 0
	}
	return *s.ID
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetRef() string {
	if s == nil || s.Ref == nil {
		return ""
	}
	return *s.Ref
}

// GetResultsCount returns the ResultsCount field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetResultsCount() int {
	if s == nil || s.ResultsCount == nil {
		return 0
	}
	return *s.ResultsCount
}

// GetRulesCount returns the RulesCount field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetRulesCount() int {
	if s == nil || s.RulesCount == nil {
		return 0
	}
	return *s.RulesCount
}

// GetSarifID returns the SarifID field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetSarifID() string {
	if s == nil || s.SarifID == nil {
		return ""
	}
	return *s.SarifID
}

// GetTool returns the Tool field.
func (s *ScanningAnalysis) GetTool() *Tool {
	if s == nil {
		return nil
	}
	return s.Tool
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetWarning returns the Warning field if it's non-nil, zero value otherwise.
func (s *ScanningAnalysis) GetWarning() string {
	if s == nil || s.Warning == nil {
		return ""
	}
	return *s.Warning
}

// GetDisplay returns the Display field if it's non-nil, zero value otherwise.
func (s *SCIMDisplayReference) GetDisplay() string {
	if s == nil || s.Display == nil {
		return ""
	}
	return *s.Display
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (s *SCIMGroupAttributes) GetDisplayName() string {
	if s == nil || s.DisplayName == nil {
		return ""
	}
	return *s.DisplayName
}

// GetExternalID returns the ExternalID field if it's non-nil, zero value otherwise.
func (s *SCIMGroupAttributes) GetExternalID() string {
	if s == nil || s.ExternalID == nil {
		return ""
	}
	return *s.ExternalID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *SCIMGroupAttributes) GetID() string {
	if s == nil || s.ID == nil {
		return ""
	}
	return *s.ID
}

// GetMeta returns the Meta field.
func (s *SCIMGroupAttributes) GetMeta() *SCIMMeta {
	if s == nil {
		return nil
	}
	return s.Meta
}

// GetCreated returns the Created field if it's non-nil, zero value otherwise.
func (s *SCIMMeta) GetCreated() Timestamp {
	if s == nil || s.Created == nil {
		return Timestamp{}
	}
	return *s.Created
}

// GetLastModified returns the LastModified field if it's non-nil, zero value otherwise.
func (s *SCIMMeta) GetLastModified() Timestamp {
	if s == nil || s.LastModified == nil {
		return Timestamp{}
	}
	return *s.LastModified
}

// GetLocation returns the Location field if it's non-nil, zero value otherwise.
func (s *SCIMMeta) GetLocation() string {
	if s == nil || s.Location == nil {
		return ""
	}
	return *s.Location
}

// GetResourceType returns the ResourceType field if it's non-nil, zero value otherwise.
func (s *SCIMMeta) GetResourceType() string {
	if s == nil || s.ResourceType == nil {
		return ""
	}
	return *s.ResourceType
}

// GetItemsPerPage returns the ItemsPerPage field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedGroups) GetItemsPerPage() int {
	if s == nil || s.ItemsPerPage == nil {
		return 0
	}
	return *s.ItemsPerPage
}

// GetStartIndex returns the StartIndex field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedGroups) GetStartIndex() int {
	if s == nil || s.StartIndex == nil {
		return 0
	}
	return *s.StartIndex
}

// GetTotalResults returns the TotalResults field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedGroups) GetTotalResults() int {
	if s == nil || s.TotalResults == nil {
		return 0
	}
	return *s.TotalResults
}

// GetItemsPerPage returns the ItemsPerPage field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedIdentities) GetItemsPerPage() int {
	if s == nil || s.ItemsPerPage == nil {
		return 0
	}
	return *s.ItemsPerPage
}

// GetStartIndex returns the StartIndex field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedIdentities) GetStartIndex() int {
	if s == nil || s.StartIndex == nil {
		return 0
	}
	return *s.StartIndex
}

// GetTotalResults returns the TotalResults field if it's non-nil, zero value otherwise.
func (s *SCIMProvisionedIdentities) GetTotalResults() int {
	if s == nil || s.TotalResults == nil {
		return 0
	}
	return *s.TotalResults
}

// GetActive returns the Active field if it's non-nil, zero value otherwise.
func (s *SCIMUserAttributes) GetActive() bool {
	if s == nil || s.Active == nil {
		return false
	}
	return *s.Active
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (s *SCIMUserAttributes) GetDisplayName() string {
	if s == nil || s.DisplayName == nil {
		return ""
	}
	return *s.DisplayName
}

// GetExternalID returns the ExternalID field if it's non-nil, zero value otherwise.
func (s *SCIMUserAttributes) GetExternalID() string {
	if s == nil || s.ExternalID == nil {
		return ""
	}
	return *s.ExternalID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *SCIMUserAttributes) GetID() string {
	if s == nil || s.ID == nil {
		return ""
	}
	return *s.ID
}

// GetMeta returns the Meta field.
func (s *SCIMUserAttributes) GetMeta() *SCIMMeta {
	if s == nil {
		return nil
	}
	return s.Meta
}

// GetPrimary returns the Primary field if it's non-nil, zero value otherwise.
func (s *SCIMUserEmail) GetPrimary() bool {
	if s == nil || s.Primary == nil {
		return false
	}
	return *s.Primary
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (s *SCIMUserEmail) GetType() string {
	if s == nil || s.Type == nil {
		return ""
	}
	return *s.Type
}

// GetFormatted returns the Formatted field if it's non-nil, zero value otherwise.
func (s *SCIMUserName) GetFormatted() string {
	if s == nil || s.Formatted == nil {
		return ""
	}
	return *s.Formatted
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SecretScanning) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetHTMLURL() string {
	if s == nil || s.HTMLURL == nil {
		return ""
	}
	return *s.HTMLURL
}

// GetIsBase64Encoded returns the IsBase64Encoded field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetIsBase64Encoded() bool {
	if s == nil || s.IsBase64Encoded == nil {
		return false
	}
	return *s.IsBase64Encoded
}

// GetLocationsURL returns the LocationsURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetLocationsURL() string {
	if s == nil || s.LocationsURL == nil {
		return ""
	}
	return *s.LocationsURL
}

// GetMultiRepo returns the MultiRepo field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetMultiRepo() bool {
	if s == nil || s.MultiRepo == nil {
		return false
	}
	return *s.MultiRepo
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetNumber() int {
	if s == nil || s.Number == nil {
		return 0
	}
	return *s.Number
}

// GetPubliclyLeaked returns the PubliclyLeaked field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPubliclyLeaked() bool {
	if s == nil || s.PubliclyLeaked == nil {
		return false
	}
	return *s.PubliclyLeaked
}

// GetPushProtectionBypassed returns the PushProtectionBypassed field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPushProtectionBypassed() bool {
	if s == nil || s.PushProtectionBypassed == nil {
		return false
	}
	return *s.PushProtectionBypassed
}

// GetPushProtectionBypassedAt returns the PushProtectionBypassedAt field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPushProtectionBypassedAt() Timestamp {
	if s == nil || s.PushProtectionBypassedAt == nil {
		return Timestamp{}
	}
	return *s.PushProtectionBypassedAt
}

// GetPushProtectionBypassedBy returns the PushProtectionBypassedBy field.
func (s *SecretScanningAlert) GetPushProtectionBypassedBy() *User {
	if s == nil {
		return nil
	}
	return s.PushProtectionBypassedBy
}

// GetPushProtectionBypassRequestComment returns the PushProtectionBypassRequestComment field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPushProtectionBypassRequestComment() string {
	if s == nil || s.PushProtectionBypassRequestComment == nil {
		return ""
	}
	return *s.PushProtectionBypassRequestComment
}

// GetPushProtectionBypassRequestHTMLURL returns the PushProtectionBypassRequestHTMLURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPushProtectionBypassRequestHTMLURL() string {
	if s == nil || s.PushProtectionBypassRequestHTMLURL == nil {
		return ""
	}
	return *s.PushProtectionBypassRequestHTMLURL
}

// GetPushProtectionBypassRequestReviewer returns the PushProtectionBypassRequestReviewer field.
func (s *SecretScanningAlert) GetPushProtectionBypassRequestReviewer() *User {
	if s == nil {
		return nil
	}
	return s.PushProtectionBypassRequestReviewer
}

// GetPushProtectionBypassRequestReviewerComment returns the PushProtectionBypassRequestReviewerComment field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetPushProtectionBypassRequestReviewerComment() string {
	if s == nil || s.PushProtectionBypassRequestReviewerComment == nil {
		return ""
	}
	return *s.PushProtectionBypassRequestReviewerComment
}

// GetRepository returns the Repository field.
func (s *SecretScanningAlert) GetRepository() *Repository {
	if s == nil {
		return nil
	}
	return s.Repository
}

// GetResolution returns the Resolution field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetResolution() string {
	if s == nil || s.Resolution == nil {
		return ""
	}
	return *s.Resolution
}

// GetResolutionComment returns the ResolutionComment field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetResolutionComment() string {
	if s == nil || s.ResolutionComment == nil {
		return ""
	}
	return *s.ResolutionComment
}

// GetResolvedAt returns the ResolvedAt field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetResolvedAt() Timestamp {
	if s == nil || s.ResolvedAt == nil {
		return Timestamp{}
	}
	return *s.ResolvedAt
}

// GetResolvedBy returns the ResolvedBy field.
func (s *SecretScanningAlert) GetResolvedBy() *User {
	if s == nil {
		return nil
	}
	return s.ResolvedBy
}

// GetSecret returns the Secret field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetSecret() string {
	if s == nil || s.Secret == nil {
		return ""
	}
	return *s.Secret
}

// GetSecretType returns the SecretType field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetSecretType() string {
	if s == nil || s.SecretType == nil {
		return ""
	}
	return *s.SecretType
}

// GetSecretTypeDisplayName returns the SecretTypeDisplayName field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetSecretTypeDisplayName() string {
	if s == nil || s.SecretTypeDisplayName == nil {
		return ""
	}
	return *s.SecretTypeDisplayName
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetState() string {
	if s == nil || s.State == nil {
		return ""
	}
	return *s.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetUpdatedAt() Timestamp {
	if s == nil || s.UpdatedAt == nil {
		return Timestamp{}
	}
	return *s.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetValidity returns the Validity field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlert) GetValidity() string {
	if s == nil || s.Validity == nil {
		return ""
	}
	return *s.Validity
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertEvent) GetAction() string {
	if s == nil || s.Action == nil {
		return ""
	}
	return *s.Action
}

// GetAlert returns the Alert field.
func (s *SecretScanningAlertEvent) GetAlert() *SecretScanningAlert {
	if s == nil {
		return nil
	}
	return s.Alert
}

// GetEnterprise returns the Enterprise field.
func (s *SecretScanningAlertEvent) GetEnterprise() *Enterprise {
	if s == nil {
		return nil
	}
	return s.Enterprise
}

// GetInstallation returns the Installation field.
func (s *SecretScanningAlertEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetOrganization returns the Organization field.
func (s *SecretScanningAlertEvent) GetOrganization() *Organization {
	if s == nil {
		return nil
	}
	return s.Organization
}

// GetRepo returns the Repo field.
func (s *SecretScanningAlertEvent) GetRepo() *Repository {
	if s == nil {
		return nil
	}
	return s.Repo
}

// GetSender returns the Sender field.
func (s *SecretScanningAlertEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetDetails returns the Details field.
func (s *SecretScanningAlertLocation) GetDetails() *SecretScanningAlertLocationDetails {
	if s == nil {
		return nil
	}
	return s.Details
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocation) GetType() string {
	if s == nil || s.Type == nil {
		return ""
	}
	return *s.Type
}

// GetBlobSHA returns the BlobSHA field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetBlobSHA() string {
	if s == nil || s.BlobSHA == nil {
		return ""
	}
	return *s.BlobSHA
}

// GetBlobURL returns the BlobURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetBlobURL() string {
	if s == nil || s.BlobURL == nil {
		return ""
	}
	return *s.BlobURL
}

// GetCommitSHA returns the CommitSHA field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetCommitSHA() string {
	if s == nil || s.CommitSHA == nil {
		return ""
	}
	return *s.CommitSHA
}

// GetCommitURL returns the CommitURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetCommitURL() string {
	if s == nil || s.CommitURL == nil {
		return ""
	}
	return *s.CommitURL
}

// GetEndColumn returns the EndColumn field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetEndColumn() int {
	if s == nil || s.EndColumn == nil {
		return 0
	}
	return *s.EndColumn
}

// GetEndLine returns the EndLine field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetEndLine() int {
	if s == nil || s.EndLine == nil {
		return 0
	}
	return *s.EndLine
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetPath() string {
	if s == nil || s.Path == nil {
		return ""
	}
	return *s.Path
}

// GetPullRequestCommentURL returns the PullRequestCommentURL field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetPullRequestCommentURL() string {
	if s == nil || s.PullRequestCommentURL == nil {
		return ""
	}
	return *s.PullRequestCommentURL
}

// GetStartColumn returns the StartColumn field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetStartColumn() int {
	if s == nil || s.StartColumn == nil {
		return 0
	}
	return *s.StartColumn
}

// GetStartline returns the Startline field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationDetails) GetStartline() int {
	if s == nil || s.Startline == nil {
		return 0
	}
	return *s.Startline
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertLocationEvent) GetAction() string {
	if s == nil || s.Action == nil {
		return ""
	}
	return *s.Action
}

// GetAlert returns the Alert field.
func (s *SecretScanningAlertLocationEvent) GetAlert() *SecretScanningAlert {
	if s == nil {
		return nil
	}
	return s.Alert
}

// GetInstallation returns the Installation field.
func (s *SecretScanningAlertLocationEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetLocation returns the Location field.
func (s *SecretScanningAlertLocationEvent) GetLocation() *SecretScanningAlertLocation {
	if s == nil {
		return nil
	}
	return s.Location
}

// GetOrganization returns the Organization field.
func (s *SecretScanningAlertLocationEvent) GetOrganization() *Organization {
	if s == nil {
		return nil
	}
	return s.Organization
}

// GetRepo returns the Repo field.
func (s *SecretScanningAlertLocationEvent) GetRepo() *Repository {
	if s == nil {
		return nil
	}
	return s.Repo
}

// GetSender returns the Sender field.
func (s *SecretScanningAlertLocationEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetResolution returns the Resolution field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertUpdateOptions) GetResolution() string {
	if s == nil || s.Resolution == nil {
		return ""
	}
	return *s.Resolution
}

// GetResolutionComment returns the ResolutionComment field if it's non-nil, zero value otherwise.
func (s *SecretScanningAlertUpdateOptions) GetResolutionComment() string {
	if s == nil || s.ResolutionComment == nil {
		return ""
	}
	return *s.ResolutionComment
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SecretScanningPushProtection) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SecretScanningValidityChecks) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetAuthor returns the Author field.
func (s *SecurityAdvisory) GetAuthor() *User {
	if s == nil {
		return nil
	}
	return s.Author
}

// GetClosedAt returns the ClosedAt field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetClosedAt() Timestamp {
	if s == nil || s.ClosedAt == nil {
		return Timestamp{}
	}
	return *s.ClosedAt
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetCVEID returns the CVEID field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetCVEID() string {
	if s == nil || s.CVEID == nil {
		return ""
	}
	return *s.CVEID
}

// GetCVSS returns the CVSS field.
func (s *SecurityAdvisory) GetCVSS() *AdvisoryCVSS {
	if s == nil {
		return nil
	}
	return s.CVSS
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetDescription() string {
	if s == nil || s.Description == nil {
		return ""
	}
	return *s.Description
}

// GetGHSAID returns the GHSAID field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetGHSAID() string {
	if s == nil || s.GHSAID == nil {
		return ""
	}
	return *s.GHSAID
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetHTMLURL() string {
	if s == nil || s.HTMLURL == nil {
		return ""
	}
	return *s.HTMLURL
}

// GetPrivateFork returns the PrivateFork field.
func (s *SecurityAdvisory) GetPrivateFork() *Repository {
	if s == nil {
		return nil
	}
	return s.PrivateFork
}

// GetPublishedAt returns the PublishedAt field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetPublishedAt() Timestamp {
	if s == nil || s.PublishedAt == nil {
		return Timestamp{}
	}
	return *s.PublishedAt
}

// GetPublisher returns the Publisher field.
func (s *SecurityAdvisory) GetPublisher() *User {
	if s == nil {
		return nil
	}
	return s.Publisher
}

// GetSeverity returns the Severity field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetSeverity() string {
	if s == nil || s.Severity == nil {
		return ""
	}
	return *s.Severity
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetState() string {
	if s == nil || s.State == nil {
		return ""
	}
	return *s.State
}

// GetSubmission returns the Submission field.
func (s *SecurityAdvisory) GetSubmission() *SecurityAdvisorySubmission {
	if s == nil {
		return nil
	}
	return s.Submission
}

// GetSummary returns the Summary field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetSummary() string {
	if s == nil || s.Summary == nil {
		return ""
	}
	return *s.Summary
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetUpdatedAt() Timestamp {
	if s == nil || s.UpdatedAt == nil {
		return Timestamp{}
	}
	return *s.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetWithdrawnAt returns the WithdrawnAt field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisory) GetWithdrawnAt() Timestamp {
	if s == nil || s.WithdrawnAt == nil {
		return Timestamp{}
	}
	return *s.WithdrawnAt
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisoryEvent) GetAction() string {
	if s == nil || s.Action == nil {
		return ""
	}
	return *s.Action
}

// GetEnterprise returns the Enterprise field.
func (s *SecurityAdvisoryEvent) GetEnterprise() *Enterprise {
	if s == nil {
		return nil
	}
	return s.Enterprise
}

// GetInstallation returns the Installation field.
func (s *SecurityAdvisoryEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetOrganization returns the Organization field.
func (s *SecurityAdvisoryEvent) GetOrganization() *Organization {
	if s == nil {
		return nil
	}
	return s.Organization
}

// GetRepository returns the Repository field.
func (s *SecurityAdvisoryEvent) GetRepository() *Repository {
	if s == nil {
		return nil
	}
	return s.Repository
}

// GetSecurityAdvisory returns the SecurityAdvisory field.
func (s *SecurityAdvisoryEvent) GetSecurityAdvisory() *SecurityAdvisory {
	if s == nil {
		return nil
	}
	return s.SecurityAdvisory
}

// GetSender returns the Sender field.
func (s *SecurityAdvisoryEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetAccepted returns the Accepted field if it's non-nil, zero value otherwise.
func (s *SecurityAdvisorySubmission) GetAccepted() bool {
	if s == nil || s.Accepted == nil {
		return false
	}
	return *s.Accepted
}

// GetAdvancedSecurity returns the AdvancedSecurity field.
func (s *SecurityAndAnalysis) GetAdvancedSecurity() *AdvancedSecurity {
	if s == nil {
		return nil
	}
	return s.AdvancedSecurity
}

// GetDependabotSecurityUpdates returns the DependabotSecurityUpdates field.
func (s *SecurityAndAnalysis) GetDependabotSecurityUpdates() *DependabotSecurityUpdates {
	if s == nil {
		return nil
	}
	return s.DependabotSecurityUpdates
}

// GetSecretScanning returns the SecretScanning field.
func (s *SecurityAndAnalysis) GetSecretScanning() *SecretScanning {
	if s == nil {
		return nil
	}
	return s.SecretScanning
}

// GetSecretScanningPushProtection returns the SecretScanningPushProtection field.
func (s *SecurityAndAnalysis) GetSecretScanningPushProtection() *SecretScanningPushProtection {
	if s == nil {
		return nil
	}
	return s.SecretScanningPushProtection
}

// GetSecretScanningValidityChecks returns the SecretScanningValidityChecks field.
func (s *SecurityAndAnalysis) GetSecretScanningValidityChecks() *SecretScanningValidityChecks {
	if s == nil {
		return nil
	}
	return s.SecretScanningValidityChecks
}

// GetFrom returns the From field.
func (s *SecurityAndAnalysisChange) GetFrom() *SecurityAndAnalysisChangeFrom {
	if s == nil {
		return nil
	}
	return s.From
}

// GetSecurityAndAnalysis returns the SecurityAndAnalysis field.
func (s *SecurityAndAnalysisChangeFrom) GetSecurityAndAnalysis() *SecurityAndAnalysis {
	if s == nil {
		return nil
	}
	return s.SecurityAndAnalysis
}

// GetChanges returns the Changes field.
func (s *SecurityAndAnalysisEvent) GetChanges() *SecurityAndAnalysisChange {
	if s == nil {
		return nil
	}
	return s.Changes
}

// GetEnterprise returns the Enterprise field.
func (s *SecurityAndAnalysisEvent) GetEnterprise() *Enterprise {
	if s == nil {
		return nil
	}
	return s.Enterprise
}

// GetInstallation returns the Installation field.
func (s *SecurityAndAnalysisEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetOrganization returns the Organization field.
func (s *SecurityAndAnalysisEvent) GetOrganization() *Organization {
	if s == nil {
		return nil
	}
	return s.Organization
}

// GetRepository returns the Repository field.
func (s *SecurityAndAnalysisEvent) GetRepository() *Repository {
	if s == nil {
		return nil
	}
	return s.Repository
}

// GetSender returns the Sender field.
func (s *SecurityAndAnalysisEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (s *SelectedReposList) GetTotalCount() int {
	if s == nil || s.TotalCount == nil {
		return 0
	}
	return *s.TotalCount
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (s *SignatureRequirementEnforcementLevelChanges) GetFrom() string {
	if s == nil || s.From == nil {
		return ""
	}
	return *s.From
}

// GetEnabled returns the Enabled field if it's non-nil, zero value otherwise.
func (s *SignaturesProtectedBranch) GetEnabled() bool {
	if s == nil || s.Enabled == nil {
		return false
	}
	return *s.Enabled
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *SignaturesProtectedBranch) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetPayload returns the Payload field if it's non-nil, zero value otherwise.
func (s *SignatureVerification) GetPayload() string {
	if s == nil || s.Payload == nil {
		return ""
	}
	return *s.Payload
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (s *SignatureVerification) GetReason() string {
	if s == nil || s.Reason == nil {
		return ""
	}
	return *s.Reason
}

// GetSignature returns the Signature field if it's non-nil, zero value otherwise.
func (s *SignatureVerification) GetSignature() string {
	if s == nil || s.Signature == nil {
		return ""
	}
	return *s.Signature
}

// GetVerified returns the Verified field if it's non-nil, zero value otherwise.
func (s *SignatureVerification) GetVerified() bool {
	if s == nil || s.Verified == nil {
		return false
	}
	return *s.Verified
}

// GetActor returns the Actor field.
func (s *Source) GetActor() *User {
	if s == nil {
		return nil
	}
	return s.Actor
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *Source) GetID() int64 {
	if s == nil || s.ID == nil {
		return 0
	}
	return *s.ID
}

// GetIssue returns the Issue field.
func (s *Source) GetIssue() *Issue {
	if s == nil {
		return nil
	}
	return s.Issue
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (s *Source) GetType() string {
	if s == nil || s.Type == nil {
		return ""
	}
	return *s.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *Source) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetEmail() string {
	if s == nil || s.Email == nil {
		return ""
	}
	return *s.Email
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetID() int64 {
	if s == nil || s.ID == nil {
		return 0
	}
	return *s.ID
}

// GetImportURL returns the ImportURL field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetImportURL() string {
	if s == nil || s.ImportURL == nil {
		return ""
	}
	return *s.ImportURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetName() string {
	if s == nil || s.Name == nil {
		return ""
	}
	return *s.Name
}

// GetRemoteID returns the RemoteID field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetRemoteID() string {
	if s == nil || s.RemoteID == nil {
		return ""
	}
	return *s.RemoteID
}

// GetRemoteName returns the RemoteName field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetRemoteName() string {
	if s == nil || s.RemoteName == nil {
		return ""
	}
	return *s.RemoteName
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *SourceImportAuthor) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetPrivacyLevel returns the PrivacyLevel field if it's non-nil, zero value otherwise.
func (s *SponsorshipChanges) GetPrivacyLevel() string {
	if s == nil || s.PrivacyLevel == nil {
		return ""
	}
	return *s.PrivacyLevel
}

// GetTier returns the Tier field.
func (s *SponsorshipChanges) GetTier() *SponsorshipTier {
	if s == nil {
		return nil
	}
	return s.Tier
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (s *SponsorshipEvent) GetAction() string {
	if s == nil || s.Action == nil {
		return ""
	}
	return *s.Action
}

// GetChanges returns the Changes field.
func (s *SponsorshipEvent) GetChanges() *SponsorshipChanges {
	if s == nil {
		return nil
	}
	return s.Changes
}

// GetEffectiveDate returns the EffectiveDate field if it's non-nil, zero value otherwise.
func (s *SponsorshipEvent) GetEffectiveDate() string {
	if s == nil || s.EffectiveDate == nil {
		return ""
	}
	return *s.EffectiveDate
}

// GetInstallation returns the Installation field.
func (s *SponsorshipEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetOrganization returns the Organization field.
func (s *SponsorshipEvent) GetOrganization() *Organization {
	if s == nil {
		return nil
	}
	return s.Organization
}

// GetRepository returns the Repository field.
func (s *SponsorshipEvent) GetRepository() *Repository {
	if s == nil {
		return nil
	}
	return s.Repository
}

// GetSender returns the Sender field.
func (s *SponsorshipEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (s *SponsorshipTier) GetFrom() string {
	if s == nil || s.From == nil {
		return ""
	}
	return *s.From
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (s *SSHKeyStatus) GetHostname() string {
	if s == nil || s.Hostname == nil {
		return ""
	}
	return *s.Hostname
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (s *SSHKeyStatus) GetMessage() string {
	if s == nil || s.Message == nil {
		return ""
	}
	return *s.Message
}

// GetModified returns the Modified field if it's non-nil, zero value otherwise.
func (s *SSHKeyStatus) GetModified() bool {
	if s == nil || s.Modified == nil {
		return false
	}
	return *s.Modified
}

// GetUUID returns the UUID field if it's non-nil, zero value otherwise.
func (s *SSHKeyStatus) GetUUID() string {
	if s == nil || s.UUID == nil {
		return ""
	}
	return *s.UUID
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *SSHSigningKey) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *SSHSigningKey) GetID() int64 {
	if s == nil || s.ID == nil {
		return 0
	}
	return *s.ID
}

// GetKey returns the Key field if it's non-nil, zero value otherwise.
func (s *SSHSigningKey) GetKey() string {
	if s == nil || s.Key == nil {
		return ""
	}
	return *s.Key
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (s *SSHSigningKey) GetTitle() string {
	if s == nil || s.Title == nil {
		return ""
	}
	return *s.Title
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (s *StarEvent) GetAction() string {
	if s == nil || s.Action == nil {
		return ""
	}
	return *s.Action
}

// GetInstallation returns the Installation field.
func (s *StarEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetOrg returns the Org field.
func (s *StarEvent) GetOrg() *Organization {
	if s == nil {
		return nil
	}
	return s.Org
}

// GetRepo returns the Repo field.
func (s *StarEvent) GetRepo() *Repository {
	if s == nil {
		return nil
	}
	return s.Repo
}

// GetSender returns the Sender field.
func (s *StarEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetStarredAt returns the StarredAt field if it's non-nil, zero value otherwise.
func (s *StarEvent) GetStarredAt() Timestamp {
	if s == nil || s.StarredAt == nil {
		return Timestamp{}
	}
	return *s.StarredAt
}

// GetStarredAt returns the StarredAt field if it's non-nil, zero value otherwise.
func (s *Stargazer) GetStarredAt() Timestamp {
	if s == nil || s.StarredAt == nil {
		return Timestamp{}
	}
	return *s.StarredAt
}

// GetUser returns the User field.
func (s *Stargazer) GetUser() *User {
	if s == nil {
		return nil
	}
	return s.User
}

// GetRepository returns the Repository field.
func (s *StarredRepository) GetRepository() *Repository {
	if s == nil {
		return nil
	}
	return s.Repository
}

// GetStarredAt returns the StarredAt field if it's non-nil, zero value otherwise.
func (s *StarredRepository) GetStarredAt() Timestamp {
	if s == nil || s.StarredAt == nil {
		return Timestamp{}
	}
	return *s.StarredAt
}

// GetCommit returns the Commit field.
func (s *StatusEvent) GetCommit() *RepositoryCommit {
	if s == nil {
		return nil
	}
	return s.Commit
}

// GetContext returns the Context field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetContext() string {
	if s == nil || s.Context == nil {
		return ""
	}
	return *s.Context
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetDescription() string {
	if s == nil || s.Description == nil {
		return ""
	}
	return *s.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetID() int64 {
	if s == nil || s.ID == nil {
		return 0
	}
	return *s.ID
}

// GetInstallation returns the Installation field.
func (s *StatusEvent) GetInstallation() *Installation {
	if s == nil {
		return nil
	}
	return s.Installation
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetName() string {
	if s == nil || s.Name == nil {
		return ""
	}
	return *s.Name
}

// GetOrg returns the Org field.
func (s *StatusEvent) GetOrg() *Organization {
	if s == nil {
		return nil
	}
	return s.Org
}

// GetRepo returns the Repo field.
func (s *StatusEvent) GetRepo() *Repository {
	if s == nil {
		return nil
	}
	return s.Repo
}

// GetSender returns the Sender field.
func (s *StatusEvent) GetSender() *User {
	if s == nil {
		return nil
	}
	return s.Sender
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetSHA() string {
	if s == nil || s.SHA == nil {
		return ""
	}
	return *s.SHA
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetState() string {
	if s == nil || s.State == nil {
		return ""
	}
	return *s.State
}

// GetTargetURL returns the TargetURL field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetTargetURL() string {
	if s == nil || s.TargetURL == nil {
		return ""
	}
	return *s.TargetURL
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (s *StatusEvent) GetUpdatedAt() Timestamp {
	if s == nil || s.UpdatedAt == nil {
		return Timestamp{}
	}
	return *s.UpdatedAt
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (s *Subscription) GetCreatedAt() Timestamp {
	if s == nil || s.CreatedAt == nil {
		return Timestamp{}
	}
	return *s.CreatedAt
}

// GetIgnored returns the Ignored field if it's non-nil, zero value otherwise.
func (s *Subscription) GetIgnored() bool {
	if s == nil || s.Ignored == nil {
		return false
	}
	return *s.Ignored
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (s *Subscription) GetReason() string {
	if s == nil || s.Reason == nil {
		return ""
	}
	return *s.Reason
}

// GetRepositoryURL returns the RepositoryURL field if it's non-nil, zero value otherwise.
func (s *Subscription) GetRepositoryURL() string {
	if s == nil || s.RepositoryURL == nil {
		return ""
	}
	return *s.RepositoryURL
}

// GetSubscribed returns the Subscribed field if it's non-nil, zero value otherwise.
func (s *Subscription) GetSubscribed() bool {
	if s == nil || s.Subscribed == nil {
		return false
	}
	return *s.Subscribed
}

// GetThreadURL returns the ThreadURL field if it's non-nil, zero value otherwise.
func (s *Subscription) GetThreadURL() string {
	if s == nil || s.ThreadURL == nil {
		return ""
	}
	return *s.ThreadURL
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (s *Subscription) GetURL() string {
	if s == nil || s.URL == nil {
		return ""
	}
	return *s.URL
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SystemRequirements) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetHostname returns the Hostname field if it's non-nil, zero value otherwise.
func (s *SystemRequirementsNode) GetHostname() string {
	if s == nil || s.Hostname == nil {
		return ""
	}
	return *s.Hostname
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SystemRequirementsNode) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetRole returns the Role field if it's non-nil, zero value otherwise.
func (s *SystemRequirementsNodeRoleStatus) GetRole() string {
	if s == nil || s.Role == nil {
		return ""
	}
	return *s.Role
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (s *SystemRequirementsNodeRoleStatus) GetStatus() string {
	if s == nil || s.Status == nil {
		return ""
	}
	return *s.Status
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (t *Tag) GetMessage() string {
	if t == nil || t.Message == nil {
		return ""
	}
	return *t.Message
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (t *Tag) GetNodeID() string {
	if t == nil || t.NodeID == nil {
		return ""
	}
	return *t.NodeID
}

// GetObject returns the Object field.
func (t *Tag) GetObject() *GitObject {
	if t == nil {
		return nil
	}
	return t.Object
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (t *Tag) GetSHA() string {
	if t == nil || t.SHA == nil {
		return ""
	}
	return *t.SHA
}

// GetTag returns the Tag field if it's non-nil, zero value otherwise.
func (t *Tag) GetTag() string {
	if t == nil || t.Tag == nil {
		return ""
	}
	return *t.Tag
}

// GetTagger returns the Tagger field.
func (t *Tag) GetTagger() *CommitAuthor {
	if t == nil {
		return nil
	}
	return t.Tagger
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *Tag) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetVerification returns the Verification field.
func (t *Tag) GetVerification() *SignatureVerification {
	if t == nil {
		return nil
	}
	return t.Verification
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (t *TagProtection) GetID() int64 {
	if t == nil || t.ID == nil {
		return 0
	}
	return *t.ID
}

// GetPattern returns the Pattern field if it's non-nil, zero value otherwise.
func (t *TagProtection) GetPattern() string {
	if t == nil || t.Pattern == nil {
		return ""
	}
	return *t.Pattern
}

// GetCompletedAt returns the CompletedAt field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetCompletedAt() Timestamp {
	if t == nil || t.CompletedAt == nil {
		return Timestamp{}
	}
	return *t.CompletedAt
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetConclusion() string {
	if t == nil || t.Conclusion == nil {
		return ""
	}
	return *t.Conclusion
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetNumber() int64 {
	if t == nil || t.Number == nil {
		return 0
	}
	return *t.Number
}

// GetStartedAt returns the StartedAt field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetStartedAt() Timestamp {
	if t == nil || t.StartedAt == nil {
		return Timestamp{}
	}
	return *t.StartedAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (t *TaskStep) GetStatus() string {
	if t == nil || t.Status == nil {
		return ""
	}
	return *t.Status
}

// GetAssignment returns the Assignment field if it's non-nil, zero value otherwise.
func (t *Team) GetAssignment() string {
	if t == nil || t.Assignment == nil {
		return ""
	}
	return *t.Assignment
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (t *Team) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (t *Team) GetHTMLURL() string {
	if t == nil || t.HTMLURL == nil {
		return ""
	}
	return *t.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (t *Team) GetID() int64 {
	if t == nil || t.ID == nil {
		return 0
	}
	return *t.ID
}

// GetLDAPDN returns the LDAPDN field if it's non-nil, zero value otherwise.
func (t *Team) GetLDAPDN() string {
	if t == nil || t.LDAPDN == nil {
		return ""
	}
	return *t.LDAPDN
}

// GetMembersCount returns the MembersCount field if it's non-nil, zero value otherwise.
func (t *Team) GetMembersCount() int {
	if t == nil || t.MembersCount == nil {
		return 0
	}
	return *t.MembersCount
}

// GetMembersURL returns the MembersURL field if it's non-nil, zero value otherwise.
func (t *Team) GetMembersURL() string {
	if t == nil || t.MembersURL == nil {
		return ""
	}
	return *t.MembersURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *Team) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (t *Team) GetNodeID() string {
	if t == nil || t.NodeID == nil {
		return ""
	}
	return *t.NodeID
}

// GetNotificationSetting returns the NotificationSetting field if it's non-nil, zero value otherwise.
func (t *Team) GetNotificationSetting() string {
	if t == nil || t.NotificationSetting == nil {
		return ""
	}
	return *t.NotificationSetting
}

// GetOrganization returns the Organization field.
func (t *Team) GetOrganization() *Organization {
	if t == nil {
		return nil
	}
	return t.Organization
}

// GetParent returns the Parent field.
func (t *Team) GetParent() *Team {
	if t == nil {
		return nil
	}
	return t.Parent
}

// GetPermission returns the Permission field if it's non-nil, zero value otherwise.
func (t *Team) GetPermission() string {
	if t == nil || t.Permission == nil {
		return ""
	}
	return *t.Permission
}

// GetPermissions returns the Permissions map if it's non-nil, an empty map otherwise.
func (t *Team) GetPermissions() map[string]bool {
	if t == nil || t.Permissions == nil {
		return map[string]bool{}
	}
	return t.Permissions
}

// GetPrivacy returns the Privacy field if it's non-nil, zero value otherwise.
func (t *Team) GetPrivacy() string {
	if t == nil || t.Privacy == nil {
		return ""
	}
	return *t.Privacy
}

// GetReposCount returns the ReposCount field if it's non-nil, zero value otherwise.
func (t *Team) GetReposCount() int {
	if t == nil || t.ReposCount == nil {
		return 0
	}
	return *t.ReposCount
}

// GetRepositoriesURL returns the RepositoriesURL field if it's non-nil, zero value otherwise.
func (t *Team) GetRepositoriesURL() string {
	if t == nil || t.RepositoriesURL == nil {
		return ""
	}
	return *t.RepositoriesURL
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (t *Team) GetSlug() string {
	if t == nil || t.Slug == nil {
		return ""
	}
	return *t.Slug
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *Team) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetInstallation returns the Installation field.
func (t *TeamAddEvent) GetInstallation() *Installation {
	if t == nil {
		return nil
	}
	return t.Installation
}

// GetOrg returns the Org field.
func (t *TeamAddEvent) GetOrg() *Organization {
	if t == nil {
		return nil
	}
	return t.Org
}

// GetRepo returns the Repo field.
func (t *TeamAddEvent) GetRepo() *Repository {
	if t == nil {
		return nil
	}
	return t.Repo
}

// GetSender returns the Sender field.
func (t *TeamAddEvent) GetSender() *User {
	if t == nil {
		return nil
	}
	return t.Sender
}

// GetTeam returns the Team field.
func (t *TeamAddEvent) GetTeam() *Team {
	if t == nil {
		return nil
	}
	return t.Team
}

// GetDescription returns the Description field.
func (t *TeamChange) GetDescription() *TeamDescription {
	if t == nil {
		return nil
	}
	return t.Description
}

// GetName returns the Name field.
func (t *TeamChange) GetName() *TeamName {
	if t == nil {
		return nil
	}
	return t.Name
}

// GetPrivacy returns the Privacy field.
func (t *TeamChange) GetPrivacy() *TeamPrivacy {
	if t == nil {
		return nil
	}
	return t.Privacy
}

// GetRepository returns the Repository field.
func (t *TeamChange) GetRepository() *TeamRepository {
	if t == nil {
		return nil
	}
	return t.Repository
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (t *TeamDescription) GetFrom() string {
	if t == nil || t.From == nil {
		return ""
	}
	return *t.From
}

// GetAuthor returns the Author field.
func (t *TeamDiscussion) GetAuthor() *User {
	if t == nil {
		return nil
	}
	return t.Author
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetBody() string {
	if t == nil || t.Body == nil {
		return ""
	}
	return *t.Body
}

// GetBodyHTML returns the BodyHTML field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetBodyHTML() string {
	if t == nil || t.BodyHTML == nil {
		return ""
	}
	return *t.BodyHTML
}

// GetBodyVersion returns the BodyVersion field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetBodyVersion() string {
	if t == nil || t.BodyVersion == nil {
		return ""
	}
	return *t.BodyVersion
}

// GetCommentsCount returns the CommentsCount field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetCommentsCount() int {
	if t == nil || t.CommentsCount == nil {
		return 0
	}
	return *t.CommentsCount
}

// GetCommentsURL returns the CommentsURL field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetCommentsURL() string {
	if t == nil || t.CommentsURL == nil {
		return ""
	}
	return *t.CommentsURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetCreatedAt() Timestamp {
	if t == nil || t.CreatedAt == nil {
		return Timestamp{}
	}
	return *t.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetHTMLURL() string {
	if t == nil || t.HTMLURL == nil {
		return ""
	}
	return *t.HTMLURL
}

// GetLastEditedAt returns the LastEditedAt field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetLastEditedAt() Timestamp {
	if t == nil || t.LastEditedAt == nil {
		return Timestamp{}
	}
	return *t.LastEditedAt
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetNodeID() string {
	if t == nil || t.NodeID == nil {
		return ""
	}
	return *t.NodeID
}

// GetNumber returns the Number field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetNumber() int {
	if t == nil || t.Number == nil {
		return 0
	}
	return *t.Number
}

// GetPinned returns the Pinned field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetPinned() bool {
	if t == nil || t.Pinned == nil {
		return false
	}
	return *t.Pinned
}

// GetPrivate returns the Private field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetPrivate() bool {
	if t == nil || t.Private == nil {
		return false
	}
	return *t.Private
}

// GetReactions returns the Reactions field.
func (t *TeamDiscussion) GetReactions() *Reactions {
	if t == nil {
		return nil
	}
	return t.Reactions
}

// GetTeamURL returns the TeamURL field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetTeamURL() string {
	if t == nil || t.TeamURL == nil {
		return ""
	}
	return *t.TeamURL
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetTitle() string {
	if t == nil || t.Title == nil {
		return ""
	}
	return *t.Title
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetUpdatedAt() Timestamp {
	if t == nil || t.UpdatedAt == nil {
		return Timestamp{}
	}
	return *t.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *TeamDiscussion) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (t *TeamEvent) GetAction() string {
	if t == nil || t.Action == nil {
		return ""
	}
	return *t.Action
}

// GetChanges returns the Changes field.
func (t *TeamEvent) GetChanges() *TeamChange {
	if t == nil {
		return nil
	}
	return t.Changes
}

// GetInstallation returns the Installation field.
func (t *TeamEvent) GetInstallation() *Installation {
	if t == nil {
		return nil
	}
	return t.Installation
}

// GetOrg returns the Org field.
func (t *TeamEvent) GetOrg() *Organization {
	if t == nil {
		return nil
	}
	return t.Org
}

// GetRepo returns the Repo field.
func (t *TeamEvent) GetRepo() *Repository {
	if t == nil {
		return nil
	}
	return t.Repo
}

// GetSender returns the Sender field.
func (t *TeamEvent) GetSender() *User {
	if t == nil {
		return nil
	}
	return t.Sender
}

// GetTeam returns the Team field.
func (t *TeamEvent) GetTeam() *Team {
	if t == nil {
		return nil
	}
	return t.Team
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetID() int64 {
	if t == nil || t.ID == nil {
		return 0
	}
	return *t.ID
}

// GetLDAPDN returns the LDAPDN field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetLDAPDN() string {
	if t == nil || t.LDAPDN == nil {
		return ""
	}
	return *t.LDAPDN
}

// GetMembersURL returns the MembersURL field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetMembersURL() string {
	if t == nil || t.MembersURL == nil {
		return ""
	}
	return *t.MembersURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetPermission returns the Permission field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetPermission() string {
	if t == nil || t.Permission == nil {
		return ""
	}
	return *t.Permission
}

// GetPrivacy returns the Privacy field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetPrivacy() string {
	if t == nil || t.Privacy == nil {
		return ""
	}
	return *t.Privacy
}

// GetRepositoriesURL returns the RepositoriesURL field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetRepositoriesURL() string {
	if t == nil || t.RepositoriesURL == nil {
		return ""
	}
	return *t.RepositoriesURL
}

// GetSlug returns the Slug field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetSlug() string {
	if t == nil || t.Slug == nil {
		return ""
	}
	return *t.Slug
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *TeamLDAPMapping) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (t *TeamName) GetFrom() string {
	if t == nil || t.From == nil {
		return ""
	}
	return *t.From
}

// GetFrom returns the From field.
func (t *TeamPermissions) GetFrom() *TeamPermissionsFrom {
	if t == nil {
		return nil
	}
	return t.From
}

// GetAdmin returns the Admin field if it's non-nil, zero value otherwise.
func (t *TeamPermissionsFrom) GetAdmin() bool {
	if t == nil || t.Admin == nil {
		return false
	}
	return *t.Admin
}

// GetPull returns the Pull field if it's non-nil, zero value otherwise.
func (t *TeamPermissionsFrom) GetPull() bool {
	if t == nil || t.Pull == nil {
		return false
	}
	return *t.Pull
}

// GetPush returns the Push field if it's non-nil, zero value otherwise.
func (t *TeamPermissionsFrom) GetPush() bool {
	if t == nil || t.Push == nil {
		return false
	}
	return *t.Push
}

// GetFrom returns the From field if it's non-nil, zero value otherwise.
func (t *TeamPrivacy) GetFrom() string {
	if t == nil || t.From == nil {
		return ""
	}
	return *t.From
}

// GetPermission returns the Permission field if it's non-nil, zero value otherwise.
func (t *TeamProjectOptions) GetPermission() string {
	if t == nil || t.Permission == nil {
		return ""
	}
	return *t.Permission
}

// GetPermissions returns the Permissions field.
func (t *TeamRepository) GetPermissions() *TeamPermissions {
	if t == nil {
		return nil
	}
	return t.Permissions
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (t *TemplateRepoRequest) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetIncludeAllBranches returns the IncludeAllBranches field if it's non-nil, zero value otherwise.
func (t *TemplateRepoRequest) GetIncludeAllBranches() bool {
	if t == nil || t.IncludeAllBranches == nil {
		return false
	}
	return *t.IncludeAllBranches
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *TemplateRepoRequest) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetOwner returns the Owner field if it's non-nil, zero value otherwise.
func (t *TemplateRepoRequest) GetOwner() string {
	if t == nil || t.Owner == nil {
		return ""
	}
	return *t.Owner
}

// GetPrivate returns the Private field if it's non-nil, zero value otherwise.
func (t *TemplateRepoRequest) GetPrivate() bool {
	if t == nil || t.Private == nil {
		return false
	}
	return *t.Private
}

// GetFragment returns the Fragment field if it's non-nil, zero value otherwise.
func (t *TextMatch) GetFragment() string {
	if t == nil || t.Fragment == nil {
		return ""
	}
	return *t.Fragment
}

// GetObjectType returns the ObjectType field if it's non-nil, zero value otherwise.
func (t *TextMatch) GetObjectType() string {
	if t == nil || t.ObjectType == nil {
		return ""
	}
	return *t.ObjectType
}

// GetObjectURL returns the ObjectURL field if it's non-nil, zero value otherwise.
func (t *TextMatch) GetObjectURL() string {
	if t == nil || t.ObjectURL == nil {
		return ""
	}
	return *t.ObjectURL
}

// GetProperty returns the Property field if it's non-nil, zero value otherwise.
func (t *TextMatch) GetProperty() string {
	if t == nil || t.Property == nil {
		return ""
	}
	return *t.Property
}

// GetActor returns the Actor field.
func (t *Timeline) GetActor() *User {
	if t == nil {
		return nil
	}
	return t.Actor
}

// GetAssignee returns the Assignee field.
func (t *Timeline) GetAssignee() *User {
	if t == nil {
		return nil
	}
	return t.Assignee
}

// GetAssigner returns the Assigner field.
func (t *Timeline) GetAssigner() *User {
	if t == nil {
		return nil
	}
	return t.Assigner
}

// GetAuthor returns the Author field.
func (t *Timeline) GetAuthor() *CommitAuthor {
	if t == nil {
		return nil
	}
	return t.Author
}

// GetBody returns the Body field if it's non-nil, zero value otherwise.
func (t *Timeline) GetBody() string {
	if t == nil || t.Body == nil {
		return ""
	}
	return *t.Body
}

// GetCommitID returns the CommitID field if it's non-nil, zero value otherwise.
func (t *Timeline) GetCommitID() string {
	if t == nil || t.CommitID == nil {
		return ""
	}
	return *t.CommitID
}

// GetCommitter returns the Committer field.
func (t *Timeline) GetCommitter() *CommitAuthor {
	if t == nil {
		return nil
	}
	return t.Committer
}

// GetCommitURL returns the CommitURL field if it's non-nil, zero value otherwise.
func (t *Timeline) GetCommitURL() string {
	if t == nil || t.CommitURL == nil {
		return ""
	}
	return *t.CommitURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (t *Timeline) GetCreatedAt() Timestamp {
	if t == nil || t.CreatedAt == nil {
		return Timestamp{}
	}
	return *t.CreatedAt
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (t *Timeline) GetEvent() string {
	if t == nil || t.Event == nil {
		return ""
	}
	return *t.Event
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (t *Timeline) GetID() int64 {
	if t == nil || t.ID == nil {
		return 0
	}
	return *t.ID
}

// GetLabel returns the Label field.
func (t *Timeline) GetLabel() *Label {
	if t == nil {
		return nil
	}
	return t.Label
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (t *Timeline) GetMessage() string {
	if t == nil || t.Message == nil {
		return ""
	}
	return *t.Message
}

// GetMilestone returns the Milestone field.
func (t *Timeline) GetMilestone() *Milestone {
	if t == nil {
		return nil
	}
	return t.Milestone
}

// GetPerformedViaGithubApp returns the PerformedViaGithubApp field.
func (t *Timeline) GetPerformedViaGithubApp() *App {
	if t == nil {
		return nil
	}
	return t.PerformedViaGithubApp
}

// GetRename returns the Rename field.
func (t *Timeline) GetRename() *Rename {
	if t == nil {
		return nil
	}
	return t.Rename
}

// GetRequestedTeam returns the RequestedTeam field.
func (t *Timeline) GetRequestedTeam() *Team {
	if t == nil {
		return nil
	}
	return t.RequestedTeam
}

// GetRequester returns the Requester field.
func (t *Timeline) GetRequester() *User {
	if t == nil {
		return nil
	}
	return t.Requester
}

// GetReviewer returns the Reviewer field.
func (t *Timeline) GetReviewer() *User {
	if t == nil {
		return nil
	}
	return t.Reviewer
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (t *Timeline) GetSHA() string {
	if t == nil || t.SHA == nil {
		return ""
	}
	return *t.SHA
}

// GetSource returns the Source field.
func (t *Timeline) GetSource() *Source {
	if t == nil {
		return nil
	}
	return t.Source
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (t *Timeline) GetState() string {
	if t == nil || t.State == nil {
		return ""
	}
	return *t.State
}

// GetSubmittedAt returns the SubmittedAt field if it's non-nil, zero value otherwise.
func (t *Timeline) GetSubmittedAt() Timestamp {
	if t == nil || t.SubmittedAt == nil {
		return Timestamp{}
	}
	return *t.SubmittedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *Timeline) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetUser returns the User field.
func (t *Timeline) GetUser() *User {
	if t == nil {
		return nil
	}
	return t.User
}

// GetGUID returns the GUID field if it's non-nil, zero value otherwise.
func (t *Tool) GetGUID() string {
	if t == nil || t.GUID == nil {
		return ""
	}
	return *t.GUID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *Tool) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetVersion returns the Version field if it's non-nil, zero value otherwise.
func (t *Tool) GetVersion() string {
	if t == nil || t.Version == nil {
		return ""
	}
	return *t.Version
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetCreatedAt() Timestamp {
	if t == nil || t.CreatedAt == nil {
		return Timestamp{}
	}
	return *t.CreatedAt
}

// GetCreatedBy returns the CreatedBy field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetCreatedBy() string {
	if t == nil || t.CreatedBy == nil {
		return ""
	}
	return *t.CreatedBy
}

// GetCurated returns the Curated field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetCurated() bool {
	if t == nil || t.Curated == nil {
		return false
	}
	return *t.Curated
}

// GetDescription returns the Description field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetDescription() string {
	if t == nil || t.Description == nil {
		return ""
	}
	return *t.Description
}

// GetDisplayName returns the DisplayName field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetDisplayName() string {
	if t == nil || t.DisplayName == nil {
		return ""
	}
	return *t.DisplayName
}

// GetFeatured returns the Featured field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetFeatured() bool {
	if t == nil || t.Featured == nil {
		return false
	}
	return *t.Featured
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetName() string {
	if t == nil || t.Name == nil {
		return ""
	}
	return *t.Name
}

// GetScore returns the Score field.
func (t *TopicResult) GetScore() *float64 {
	if t == nil {
		return nil
	}
	return t.Score
}

// GetShortDescription returns the ShortDescription field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetShortDescription() string {
	if t == nil || t.ShortDescription == nil {
		return ""
	}
	return *t.ShortDescription
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (t *TopicResult) GetUpdatedAt() string {
	if t == nil || t.UpdatedAt == nil {
		return ""
	}
	return *t.UpdatedAt
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (t *TopicsSearchResult) GetIncompleteResults() bool {
	if t == nil || t.IncompleteResults == nil {
		return false
	}
	return *t.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (t *TopicsSearchResult) GetTotal() int {
	if t == nil || t.Total == nil {
		return 0
	}
	return *t.Total
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (t *TrafficClones) GetCount() int {
	if t == nil || t.Count == nil {
		return 0
	}
	return *t.Count
}

// GetUniques returns the Uniques field if it's non-nil, zero value otherwise.
func (t *TrafficClones) GetUniques() int {
	if t == nil || t.Uniques == nil {
		return 0
	}
	return *t.Uniques
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (t *TrafficData) GetCount() int {
	if t == nil || t.Count == nil {
		return 0
	}
	return *t.Count
}

// GetTimestamp returns the Timestamp field if it's non-nil, zero value otherwise.
func (t *TrafficData) GetTimestamp() Timestamp {
	if t == nil || t.Timestamp == nil {
		return Timestamp{}
	}
	return *t.Timestamp
}

// GetUniques returns the Uniques field if it's non-nil, zero value otherwise.
func (t *TrafficData) GetUniques() int {
	if t == nil || t.Uniques == nil {
		return 0
	}
	return *t.Uniques
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (t *TrafficPath) GetCount() int {
	if t == nil || t.Count == nil {
		return 0
	}
	return *t.Count
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (t *TrafficPath) GetPath() string {
	if t == nil || t.Path == nil {
		return ""
	}
	return *t.Path
}

// GetTitle returns the Title field if it's non-nil, zero value otherwise.
func (t *TrafficPath) GetTitle() string {
	if t == nil || t.Title == nil {
		return ""
	}
	return *t.Title
}

// GetUniques returns the Uniques field if it's non-nil, zero value otherwise.
func (t *TrafficPath) GetUniques() int {
	if t == nil || t.Uniques == nil {
		return 0
	}
	return *t.Uniques
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (t *TrafficReferrer) GetCount() int {
	if t == nil || t.Count == nil {
		return 0
	}
	return *t.Count
}

// GetReferrer returns the Referrer field if it's non-nil, zero value otherwise.
func (t *TrafficReferrer) GetReferrer() string {
	if t == nil || t.Referrer == nil {
		return ""
	}
	return *t.Referrer
}

// GetUniques returns the Uniques field if it's non-nil, zero value otherwise.
func (t *TrafficReferrer) GetUniques() int {
	if t == nil || t.Uniques == nil {
		return 0
	}
	return *t.Uniques
}

// GetCount returns the Count field if it's non-nil, zero value otherwise.
func (t *TrafficViews) GetCount() int {
	if t == nil || t.Count == nil {
		return 0
	}
	return *t.Count
}

// GetUniques returns the Uniques field if it's non-nil, zero value otherwise.
func (t *TrafficViews) GetUniques() int {
	if t == nil || t.Uniques == nil {
		return 0
	}
	return *t.Uniques
}

// GetNewName returns the NewName field if it's non-nil, zero value otherwise.
func (t *TransferRequest) GetNewName() string {
	if t == nil || t.NewName == nil {
		return ""
	}
	return *t.NewName
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (t *Tree) GetSHA() string {
	if t == nil || t.SHA == nil {
		return ""
	}
	return *t.SHA
}

// GetTruncated returns the Truncated field if it's non-nil, zero value otherwise.
func (t *Tree) GetTruncated() bool {
	if t == nil || t.Truncated == nil {
		return false
	}
	return *t.Truncated
}

// GetContent returns the Content field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetContent() string {
	if t == nil || t.Content == nil {
		return ""
	}
	return *t.Content
}

// GetMode returns the Mode field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetMode() string {
	if t == nil || t.Mode == nil {
		return ""
	}
	return *t.Mode
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetPath() string {
	if t == nil || t.Path == nil {
		return ""
	}
	return *t.Path
}

// GetSHA returns the SHA field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetSHA() string {
	if t == nil || t.SHA == nil {
		return ""
	}
	return *t.SHA
}

// GetSize returns the Size field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetSize() int {
	if t == nil || t.Size == nil {
		return 0
	}
	return *t.Size
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetType() string {
	if t == nil || t.Type == nil {
		return ""
	}
	return *t.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (t *TreeEntry) GetURL() string {
	if t == nil || t.URL == nil {
		return ""
	}
	return *t.URL
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (u *UpdateAttributeForSCIMUserOperations) GetPath() string {
	if u == nil || u.Path == nil {
		return ""
	}
	return *u.Path
}

// GetCompletedAt returns the CompletedAt field if it's non-nil, zero value otherwise.
func (u *UpdateCheckRunOptions) GetCompletedAt() Timestamp {
	if u == nil || u.CompletedAt == nil {
		return Timestamp{}
	}
	return *u.CompletedAt
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (u *UpdateCheckRunOptions) GetConclusion() string {
	if u == nil || u.Conclusion == nil {
		return ""
	}
	return *u.Conclusion
}

// GetDetailsURL returns the DetailsURL field if it's non-nil, zero value otherwise.
func (u *UpdateCheckRunOptions) GetDetailsURL() string {
	if u == nil || u.DetailsURL == nil {
		return ""
	}
	return *u.DetailsURL
}

// GetExternalID returns the ExternalID field if it's non-nil, zero value otherwise.
func (u *UpdateCheckRunOptions) GetExternalID() string {
	if u == nil || u.ExternalID == nil {
		return ""
	}
	return *u.ExternalID
}

// GetOutput returns the Output field.
func (u *UpdateCheckRunOptions) GetOutput() *CheckRunOutput {
	if u == nil {
		return nil
	}
	return u.Output
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (u *UpdateCheckRunOptions) GetStatus() string {
	if u == nil || u.Status == nil {
		return ""
	}
	return *u.Status
}

// GetQuerySuite returns the QuerySuite field if it's non-nil, zero value otherwise.
func (u *UpdateDefaultSetupConfigurationOptions) GetQuerySuite() string {
	if u == nil || u.QuerySuite == nil {
		return ""
	}
	return *u.QuerySuite
}

// GetRunID returns the RunID field if it's non-nil, zero value otherwise.
func (u *UpdateDefaultSetupConfigurationResponse) GetRunID() int64 {
	if u == nil || u.RunID == nil {
		return 0
	}
	return *u.RunID
}

// GetRunURL returns the RunURL field if it's non-nil, zero value otherwise.
func (u *UpdateDefaultSetupConfigurationResponse) GetRunURL() string {
	if u == nil || u.RunURL == nil {
		return ""
	}
	return *u.RunURL
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (u *UpdateEnterpriseRunnerGroupRequest) GetAllowsPublicRepositories() bool {
	if u == nil || u.AllowsPublicRepositories == nil {
		return false
	}
	return *u.AllowsPublicRepositories
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (u *UpdateEnterpriseRunnerGroupRequest) GetName() string {
	if u == nil || u.Name == nil {
		return ""
	}
	return *u.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (u *UpdateEnterpriseRunnerGroupRequest) GetRestrictedToWorkflows() bool {
	if u == nil || u.RestrictedToWorkflows == nil {
		return false
	}
	return *u.RestrictedToWorkflows
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (u *UpdateEnterpriseRunnerGroupRequest) GetVisibility() string {
	if u == nil || u.Visibility == nil {
		return ""
	}
	return *u.Visibility
}

// GetAllowsPublicRepositories returns the AllowsPublicRepositories field if it's non-nil, zero value otherwise.
func (u *UpdateRunnerGroupRequest) GetAllowsPublicRepositories() bool {
	if u == nil || u.AllowsPublicRepositories == nil {
		return false
	}
	return *u.AllowsPublicRepositories
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (u *UpdateRunnerGroupRequest) GetName() string {
	if u == nil || u.Name == nil {
		return ""
	}
	return *u.Name
}

// GetRestrictedToWorkflows returns the RestrictedToWorkflows field if it's non-nil, zero value otherwise.
func (u *UpdateRunnerGroupRequest) GetRestrictedToWorkflows() bool {
	if u == nil || u.RestrictedToWorkflows == nil {
		return false
	}
	return *u.RestrictedToWorkflows
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (u *UpdateRunnerGroupRequest) GetVisibility() string {
	if u == nil || u.Visibility == nil {
		return ""
	}
	return *u.Visibility
}

// GetAssignment returns the Assignment field if it's non-nil, zero value otherwise.
func (u *User) GetAssignment() string {
	if u == nil || u.Assignment == nil {
		return ""
	}
	return *u.Assignment
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (u *User) GetAvatarURL() string {
	if u == nil || u.AvatarURL == nil {
		return ""
	}
	return *u.AvatarURL
}

// GetBio returns the Bio field if it's non-nil, zero value otherwise.
func (u *User) GetBio() string {
	if u == nil || u.Bio == nil {
		return ""
	}
	return *u.Bio
}

// GetBlog returns the Blog field if it's non-nil, zero value otherwise.
func (u *User) GetBlog() string {
	if u == nil || u.Blog == nil {
		return ""
	}
	return *u.Blog
}

// GetCollaborators returns the Collaborators field if it's non-nil, zero value otherwise.
func (u *User) GetCollaborators() int {
	if u == nil || u.Collaborators == nil {
		return 0
	}
	return *u.Collaborators
}

// GetCompany returns the Company field if it's non-nil, zero value otherwise.
func (u *User) GetCompany() string {
	if u == nil || u.Company == nil {
		return ""
	}
	return *u.Company
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (u *User) GetCreatedAt() Timestamp {
	if u == nil || u.CreatedAt == nil {
		return Timestamp{}
	}
	return *u.CreatedAt
}

// GetDiskUsage returns the DiskUsage field if it's non-nil, zero value otherwise.
func (u *User) GetDiskUsage() int {
	if u == nil || u.DiskUsage == nil {
		return 0
	}
	return *u.DiskUsage
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (u *User) GetEmail() string {
	if u == nil || u.Email == nil {
		return ""
	}
	return *u.Email
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (u *User) GetEventsURL() string {
	if u == nil || u.EventsURL == nil {
		return ""
	}
	return *u.EventsURL
}

// GetFollowers returns the Followers field if it's non-nil, zero value otherwise.
func (u *User) GetFollowers() int {
	if u == nil || u.Followers == nil {
		return 0
	}
	return *u.Followers
}

// GetFollowersURL returns the FollowersURL field if it's non-nil, zero value otherwise.
func (u *User) GetFollowersURL() string {
	if u == nil || u.FollowersURL == nil {
		return ""
	}
	return *u.FollowersURL
}

// GetFollowing returns the Following field if it's non-nil, zero value otherwise.
func (u *User) GetFollowing() int {
	if u == nil || u.Following == nil {
		return 0
	}
	return *u.Following
}

// GetFollowingURL returns the FollowingURL field if it's non-nil, zero value otherwise.
func (u *User) GetFollowingURL() string {
	if u == nil || u.FollowingURL == nil {
		return ""
	}
	return *u.FollowingURL
}

// GetGistsURL returns the GistsURL field if it's non-nil, zero value otherwise.
func (u *User) GetGistsURL() string {
	if u == nil || u.GistsURL == nil {
		return ""
	}
	return *u.GistsURL
}

// GetGravatarID returns the GravatarID field if it's non-nil, zero value otherwise.
func (u *User) GetGravatarID() string {
	if u == nil || u.GravatarID == nil {
		return ""
	}
	return *u.GravatarID
}

// GetHireable returns the Hireable field if it's non-nil, zero value otherwise.
func (u *User) GetHireable() bool {
	if u == nil || u.Hireable == nil {
		return false
	}
	return *u.Hireable
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (u *User) GetHTMLURL() string {
	if u == nil || u.HTMLURL == nil {
		return ""
	}
	return *u.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (u *User) GetID() int64 {
	if u == nil || u.ID == nil {
		return 0
	}
	return *u.ID
}

// GetLdapDn returns the LdapDn field if it's non-nil, zero value otherwise.
func (u *User) GetLdapDn() string {
	if u == nil || u.LdapDn == nil {
		return ""
	}
	return *u.LdapDn
}

// GetLocation returns the Location field if it's non-nil, zero value otherwise.
func (u *User) GetLocation() string {
	if u == nil || u.Location == nil {
		return ""
	}
	return *u.Location
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (u *User) GetLogin() string {
	if u == nil || u.Login == nil {
		return ""
	}
	return *u.Login
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (u *User) GetName() string {
	if u == nil || u.Name == nil {
		return ""
	}
	return *u.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (u *User) GetNodeID() string {
	if u == nil || u.NodeID == nil {
		return ""
	}
	return *u.NodeID
}

// GetOrganizationsURL returns the OrganizationsURL field if it's non-nil, zero value otherwise.
func (u *User) GetOrganizationsURL() string {
	if u == nil || u.OrganizationsURL == nil {
		return ""
	}
	return *u.OrganizationsURL
}

// GetOwnedPrivateRepos returns the OwnedPrivateRepos field if it's non-nil, zero value otherwise.
func (u *User) GetOwnedPrivateRepos() int64 {
	if u == nil || u.OwnedPrivateRepos == nil {
		return 0
	}
	return *u.OwnedPrivateRepos
}

// GetPermissions returns the Permissions map if it's non-nil, an empty map otherwise.
func (u *User) GetPermissions() map[string]bool {
	if u == nil || u.Permissions == nil {
		return map[string]bool{}
	}
	return u.Permissions
}

// GetPlan returns the Plan field.
func (u *User) GetPlan() *Plan {
	if u == nil {
		return nil
	}
	return u.Plan
}

// GetPrivateGists returns the PrivateGists field if it's non-nil, zero value otherwise.
func (u *User) GetPrivateGists() int {
	if u == nil || u.PrivateGists == nil {
		return 0
	}
	return *u.PrivateGists
}

// GetPublicGists returns the PublicGists field if it's non-nil, zero value otherwise.
func (u *User) GetPublicGists() int {
	if u == nil || u.PublicGists == nil {
		return 0
	}
	return *u.PublicGists
}

// GetPublicRepos returns the PublicRepos field if it's non-nil, zero value otherwise.
func (u *User) GetPublicRepos() int {
	if u == nil || u.PublicRepos == nil {
		return 0
	}
	return *u.PublicRepos
}

// GetReceivedEventsURL returns the ReceivedEventsURL field if it's non-nil, zero value otherwise.
func (u *User) GetReceivedEventsURL() string {
	if u == nil || u.ReceivedEventsURL == nil {
		return ""
	}
	return *u.ReceivedEventsURL
}

// GetReposURL returns the ReposURL field if it's non-nil, zero value otherwise.
func (u *User) GetReposURL() string {
	if u == nil || u.ReposURL == nil {
		return ""
	}
	return *u.ReposURL
}

// GetRoleName returns the RoleName field if it's non-nil, zero value otherwise.
func (u *User) GetRoleName() string {
	if u == nil || u.RoleName == nil {
		return ""
	}
	return *u.RoleName
}

// GetSiteAdmin returns the SiteAdmin field if it's non-nil, zero value otherwise.
func (u *User) GetSiteAdmin() bool {
	if u == nil || u.SiteAdmin == nil {
		return false
	}
	return *u.SiteAdmin
}

// GetStarredURL returns the StarredURL field if it's non-nil, zero value otherwise.
func (u *User) GetStarredURL() string {
	if u == nil || u.StarredURL == nil {
		return ""
	}
	return *u.StarredURL
}

// GetSubscriptionsURL returns the SubscriptionsURL field if it's non-nil, zero value otherwise.
func (u *User) GetSubscriptionsURL() string {
	if u == nil || u.SubscriptionsURL == nil {
		return ""
	}
	return *u.SubscriptionsURL
}

// GetSuspendedAt returns the SuspendedAt field if it's non-nil, zero value otherwise.
func (u *User) GetSuspendedAt() Timestamp {
	if u == nil || u.SuspendedAt == nil {
		return Timestamp{}
	}
	return *u.SuspendedAt
}

// GetTotalPrivateRepos returns the TotalPrivateRepos field if it's non-nil, zero value otherwise.
func (u *User) GetTotalPrivateRepos() int64 {
	if u == nil || u.TotalPrivateRepos == nil {
		return 0
	}
	return *u.TotalPrivateRepos
}

// GetTwitterUsername returns the TwitterUsername field if it's non-nil, zero value otherwise.
func (u *User) GetTwitterUsername() string {
	if u == nil || u.TwitterUsername == nil {
		return ""
	}
	return *u.TwitterUsername
}

// GetTwoFactorAuthentication returns the TwoFactorAuthentication field if it's non-nil, zero value otherwise.
func (u *User) GetTwoFactorAuthentication() bool {
	if u == nil || u.TwoFactorAuthentication == nil {
		return false
	}
	return *u.TwoFactorAuthentication
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (u *User) GetType() string {
	if u == nil || u.Type == nil {
		return ""
	}
	return *u.Type
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (u *User) GetUpdatedAt() Timestamp {
	if u == nil || u.UpdatedAt == nil {
		return Timestamp{}
	}
	return *u.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (u *User) GetURL() string {
	if u == nil || u.URL == nil {
		return ""
	}
	return *u.URL
}

// GetApp returns the App field.
func (u *UserAuthorization) GetApp() *OAuthAPP {
	if u == nil {
		return nil
	}
	return u.App
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetCreatedAt() Timestamp {
	if u == nil || u.CreatedAt == nil {
		return Timestamp{}
	}
	return *u.CreatedAt
}

// GetFingerprint returns the Fingerprint field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetFingerprint() string {
	if u == nil || u.Fingerprint == nil {
		return ""
	}
	return *u.Fingerprint
}

// GetHashedToken returns the HashedToken field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetHashedToken() string {
	if u == nil || u.HashedToken == nil {
		return ""
	}
	return *u.HashedToken
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetID() int64 {
	if u == nil || u.ID == nil {
		return 0
	}
	return *u.ID
}

// GetNote returns the Note field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetNote() string {
	if u == nil || u.Note == nil {
		return ""
	}
	return *u.Note
}

// GetNoteURL returns the NoteURL field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetNoteURL() string {
	if u == nil || u.NoteURL == nil {
		return ""
	}
	return *u.NoteURL
}

// GetToken returns the Token field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetToken() string {
	if u == nil || u.Token == nil {
		return ""
	}
	return *u.Token
}

// GetTokenLastEight returns the TokenLastEight field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetTokenLastEight() string {
	if u == nil || u.TokenLastEight == nil {
		return ""
	}
	return *u.TokenLastEight
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetUpdatedAt() Timestamp {
	if u == nil || u.UpdatedAt == nil {
		return Timestamp{}
	}
	return *u.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (u *UserAuthorization) GetURL() string {
	if u == nil || u.URL == nil {
		return ""
	}
	return *u.URL
}

// GetMessage returns the Message field if it's non-nil, zero value otherwise.
func (u *UserContext) GetMessage() string {
	if u == nil || u.Message == nil {
		return ""
	}
	return *u.Message
}

// GetOcticon returns the Octicon field if it's non-nil, zero value otherwise.
func (u *UserContext) GetOcticon() string {
	if u == nil || u.Octicon == nil {
		return ""
	}
	return *u.Octicon
}

// GetEmail returns the Email field if it's non-nil, zero value otherwise.
func (u *UserEmail) GetEmail() string {
	if u == nil || u.Email == nil {
		return ""
	}
	return *u.Email
}

// GetPrimary returns the Primary field if it's non-nil, zero value otherwise.
func (u *UserEmail) GetPrimary() bool {
	if u == nil || u.Primary == nil {
		return false
	}
	return *u.Primary
}

// GetVerified returns the Verified field if it's non-nil, zero value otherwise.
func (u *UserEmail) GetVerified() bool {
	if u == nil || u.Verified == nil {
		return false
	}
	return *u.Verified
}

// GetVisibility returns the Visibility field if it's non-nil, zero value otherwise.
func (u *UserEmail) GetVisibility() string {
	if u == nil || u.Visibility == nil {
		return ""
	}
	return *u.Visibility
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (u *UserEvent) GetAction() string {
	if u == nil || u.Action == nil {
		return ""
	}
	return *u.Action
}

// GetEnterprise returns the Enterprise field.
func (u *UserEvent) GetEnterprise() *Enterprise {
	if u == nil {
		return nil
	}
	return u.Enterprise
}

// GetInstallation returns the Installation field.
func (u *UserEvent) GetInstallation() *Installation {
	if u == nil {
		return nil
	}
	return u.Installation
}

// GetSender returns the Sender field.
func (u *UserEvent) GetSender() *User {
	if u == nil {
		return nil
	}
	return u.Sender
}

// GetUser returns the User field.
func (u *UserEvent) GetUser() *User {
	if u == nil {
		return nil
	}
	return u.User
}

// GetAvatarURL returns the AvatarURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetAvatarURL() string {
	if u == nil || u.AvatarURL == nil {
		return ""
	}
	return *u.AvatarURL
}

// GetEventsURL returns the EventsURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetEventsURL() string {
	if u == nil || u.EventsURL == nil {
		return ""
	}
	return *u.EventsURL
}

// GetFollowersURL returns the FollowersURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetFollowersURL() string {
	if u == nil || u.FollowersURL == nil {
		return ""
	}
	return *u.FollowersURL
}

// GetFollowingURL returns the FollowingURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetFollowingURL() string {
	if u == nil || u.FollowingURL == nil {
		return ""
	}
	return *u.FollowingURL
}

// GetGistsURL returns the GistsURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetGistsURL() string {
	if u == nil || u.GistsURL == nil {
		return ""
	}
	return *u.GistsURL
}

// GetGravatarID returns the GravatarID field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetGravatarID() string {
	if u == nil || u.GravatarID == nil {
		return ""
	}
	return *u.GravatarID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetID() int64 {
	if u == nil || u.ID == nil {
		return 0
	}
	return *u.ID
}

// GetLDAPDN returns the LDAPDN field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetLDAPDN() string {
	if u == nil || u.LDAPDN == nil {
		return ""
	}
	return *u.LDAPDN
}

// GetLogin returns the Login field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetLogin() string {
	if u == nil || u.Login == nil {
		return ""
	}
	return *u.Login
}

// GetOrganizationsURL returns the OrganizationsURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetOrganizationsURL() string {
	if u == nil || u.OrganizationsURL == nil {
		return ""
	}
	return *u.OrganizationsURL
}

// GetReceivedEventsURL returns the ReceivedEventsURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetReceivedEventsURL() string {
	if u == nil || u.ReceivedEventsURL == nil {
		return ""
	}
	return *u.ReceivedEventsURL
}

// GetReposURL returns the ReposURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetReposURL() string {
	if u == nil || u.ReposURL == nil {
		return ""
	}
	return *u.ReposURL
}

// GetSiteAdmin returns the SiteAdmin field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetSiteAdmin() bool {
	if u == nil || u.SiteAdmin == nil {
		return false
	}
	return *u.SiteAdmin
}

// GetStarredURL returns the StarredURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetStarredURL() string {
	if u == nil || u.StarredURL == nil {
		return ""
	}
	return *u.StarredURL
}

// GetSubscriptionsURL returns the SubscriptionsURL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetSubscriptionsURL() string {
	if u == nil || u.SubscriptionsURL == nil {
		return ""
	}
	return *u.SubscriptionsURL
}

// GetType returns the Type field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetType() string {
	if u == nil || u.Type == nil {
		return ""
	}
	return *u.Type
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (u *UserLDAPMapping) GetURL() string {
	if u == nil || u.URL == nil {
		return ""
	}
	return *u.URL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetCreatedAt() string {
	if u == nil || u.CreatedAt == nil {
		return ""
	}
	return *u.CreatedAt
}

// GetExcludeAttachments returns the ExcludeAttachments field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetExcludeAttachments() bool {
	if u == nil || u.ExcludeAttachments == nil {
		return false
	}
	return *u.ExcludeAttachments
}

// GetGUID returns the GUID field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetGUID() string {
	if u == nil || u.GUID == nil {
		return ""
	}
	return *u.GUID
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetID() int64 {
	if u == nil || u.ID == nil {
		return 0
	}
	return *u.ID
}

// GetLockRepositories returns the LockRepositories field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetLockRepositories() bool {
	if u == nil || u.LockRepositories == nil {
		return false
	}
	return *u.LockRepositories
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetState() string {
	if u == nil || u.State == nil {
		return ""
	}
	return *u.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetUpdatedAt() string {
	if u == nil || u.UpdatedAt == nil {
		return ""
	}
	return *u.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (u *UserMigration) GetURL() string {
	if u == nil || u.URL == nil {
		return ""
	}
	return *u.URL
}

// GetIncompleteResults returns the IncompleteResults field if it's non-nil, zero value otherwise.
func (u *UsersSearchResult) GetIncompleteResults() bool {
	if u == nil || u.IncompleteResults == nil {
		return false
	}
	return *u.IncompleteResults
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (u *UsersSearchResult) GetTotal() int {
	if u == nil || u.Total == nil {
		return 0
	}
	return *u.Total
}

// GetAdminUsers returns the AdminUsers field if it's non-nil, zero value otherwise.
func (u *UserStats) GetAdminUsers() int {
	if u == nil || u.AdminUsers == nil {
		return 0
	}
	return *u.AdminUsers
}

// GetSuspendedUsers returns the SuspendedUsers field if it's non-nil, zero value otherwise.
func (u *UserStats) GetSuspendedUsers() int {
	if u == nil || u.SuspendedUsers == nil {
		return 0
	}
	return *u.SuspendedUsers
}

// GetTotalUsers returns the TotalUsers field if it's non-nil, zero value otherwise.
func (u *UserStats) GetTotalUsers() int {
	if u == nil || u.TotalUsers == nil {
		return 0
	}
	return *u.TotalUsers
}

// GetReason returns the Reason field if it's non-nil, zero value otherwise.
func (u *UserSuspendOptions) GetReason() string {
	if u == nil || u.Reason == nil {
		return ""
	}
	return *u.Reason
}

// GetEcosystem returns the Ecosystem field if it's non-nil, zero value otherwise.
func (v *VulnerabilityPackage) GetEcosystem() string {
	if v == nil || v.Ecosystem == nil {
		return ""
	}
	return *v.Ecosystem
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (v *VulnerabilityPackage) GetName() string {
	if v == nil || v.Name == nil {
		return ""
	}
	return *v.Name
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (w *WatchEvent) GetAction() string {
	if w == nil || w.Action == nil {
		return ""
	}
	return *w.Action
}

// GetInstallation returns the Installation field.
func (w *WatchEvent) GetInstallation() *Installation {
	if w == nil {
		return nil
	}
	return w.Installation
}

// GetOrg returns the Org field.
func (w *WatchEvent) GetOrg() *Organization {
	if w == nil {
		return nil
	}
	return w.Org
}

// GetRepo returns the Repo field.
func (w *WatchEvent) GetRepo() *Repository {
	if w == nil {
		return nil
	}
	return w.Repo
}

// GetSender returns the Sender field.
func (w *WatchEvent) GetSender() *User {
	if w == nil {
		return nil
	}
	return w.Sender
}

// GetTotal returns the Total field if it's non-nil, zero value otherwise.
func (w *WeeklyCommitActivity) GetTotal() int {
	if w == nil || w.Total == nil {
		return 0
	}
	return *w.Total
}

// GetWeek returns the Week field if it's non-nil, zero value otherwise.
func (w *WeeklyCommitActivity) GetWeek() Timestamp {
	if w == nil || w.Week == nil {
		return Timestamp{}
	}
	return *w.Week
}

// GetAdditions returns the Additions field if it's non-nil, zero value otherwise.
func (w *WeeklyStats) GetAdditions() int {
	if w == nil || w.Additions == nil {
		return 0
	}
	return *w.Additions
}

// GetCommits returns the Commits field if it's non-nil, zero value otherwise.
func (w *WeeklyStats) GetCommits() int {
	if w == nil || w.Commits == nil {
		return 0
	}
	return *w.Commits
}

// GetDeletions returns the Deletions field if it's non-nil, zero value otherwise.
func (w *WeeklyStats) GetDeletions() int {
	if w == nil || w.Deletions == nil {
		return 0
	}
	return *w.Deletions
}

// GetWeek returns the Week field if it's non-nil, zero value otherwise.
func (w *WeeklyStats) GetWeek() Timestamp {
	if w == nil || w.Week == nil {
		return Timestamp{}
	}
	return *w.Week
}

// GetBadgeURL returns the BadgeURL field if it's non-nil, zero value otherwise.
func (w *Workflow) GetBadgeURL() string {
	if w == nil || w.BadgeURL == nil {
		return ""
	}
	return *w.BadgeURL
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (w *Workflow) GetCreatedAt() Timestamp {
	if w == nil || w.CreatedAt == nil {
		return Timestamp{}
	}
	return *w.CreatedAt
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (w *Workflow) GetHTMLURL() string {
	if w == nil || w.HTMLURL == nil {
		return ""
	}
	return *w.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (w *Workflow) GetID() int64 {
	if w == nil || w.ID == nil {
		return 0
	}
	return *w.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (w *Workflow) GetName() string {
	if w == nil || w.Name == nil {
		return ""
	}
	return *w.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (w *Workflow) GetNodeID() string {
	if w == nil || w.NodeID == nil {
		return ""
	}
	return *w.NodeID
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (w *Workflow) GetPath() string {
	if w == nil || w.Path == nil {
		return ""
	}
	return *w.Path
}

// GetState returns the State field if it's non-nil, zero value otherwise.
func (w *Workflow) GetState() string {
	if w == nil || w.State == nil {
		return ""
	}
	return *w.State
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (w *Workflow) GetUpdatedAt() Timestamp {
	if w == nil || w.UpdatedAt == nil {
		return Timestamp{}
	}
	return *w.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (w *Workflow) GetURL() string {
	if w == nil || w.URL == nil {
		return ""
	}
	return *w.URL
}

// GetTotalMS returns the TotalMS field if it's non-nil, zero value otherwise.
func (w *WorkflowBill) GetTotalMS() int64 {
	if w == nil || w.TotalMS == nil {
		return 0
	}
	return *w.TotalMS
}

// GetInstallation returns the Installation field.
func (w *WorkflowDispatchEvent) GetInstallation() *Installation {
	if w == nil {
		return nil
	}
	return w.Installation
}

// GetOrg returns the Org field.
func (w *WorkflowDispatchEvent) GetOrg() *Organization {
	if w == nil {
		return nil
	}
	return w.Org
}

// GetRef returns the Ref field if it's non-nil, zero value otherwise.
func (w *WorkflowDispatchEvent) GetRef() string {
	if w == nil || w.Ref == nil {
		return ""
	}
	return *w.Ref
}

// GetRepo returns the Repo field.
func (w *WorkflowDispatchEvent) GetRepo() *Repository {
	if w == nil {
		return nil
	}
	return w.Repo
}

// GetSender returns the Sender field.
func (w *WorkflowDispatchEvent) GetSender() *User {
	if w == nil {
		return nil
	}
	return w.Sender
}

// GetWorkflow returns the Workflow field if it's non-nil, zero value otherwise.
func (w *WorkflowDispatchEvent) GetWorkflow() string {
	if w == nil || w.Workflow == nil {
		return ""
	}
	return *w.Workflow
}

// GetCheckRunURL returns the CheckRunURL field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetCheckRunURL() string {
	if w == nil || w.CheckRunURL == nil {
		return ""
	}
	return *w.CheckRunURL
}

// GetCompletedAt returns the CompletedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetCompletedAt() Timestamp {
	if w == nil || w.CompletedAt == nil {
		return Timestamp{}
	}
	return *w.CompletedAt
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetConclusion() string {
	if w == nil || w.Conclusion == nil {
		return ""
	}
	return *w.Conclusion
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetCreatedAt() Timestamp {
	if w == nil || w.CreatedAt == nil {
		return Timestamp{}
	}
	return *w.CreatedAt
}

// GetHeadBranch returns the HeadBranch field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetHeadBranch() string {
	if w == nil || w.HeadBranch == nil {
		return ""
	}
	return *w.HeadBranch
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetHeadSHA() string {
	if w == nil || w.HeadSHA == nil {
		return ""
	}
	return *w.HeadSHA
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetHTMLURL() string {
	if w == nil || w.HTMLURL == nil {
		return ""
	}
	return *w.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetID() int64 {
	if w == nil || w.ID == nil {
		return 0
	}
	return *w.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetName() string {
	if w == nil || w.Name == nil {
		return ""
	}
	return *w.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetNodeID() string {
	if w == nil || w.NodeID == nil {
		return ""
	}
	return *w.NodeID
}

// GetRunAttempt returns the RunAttempt field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunAttempt() int64 {
	if w == nil || w.RunAttempt == nil {
		return 0
	}
	return *w.RunAttempt
}

// GetRunID returns the RunID field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunID() int64 {
	if w == nil || w.RunID == nil {
		return 0
	}
	return *w.RunID
}

// GetRunnerGroupID returns the RunnerGroupID field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunnerGroupID() int64 {
	if w == nil || w.RunnerGroupID == nil {
		return 0
	}
	return *w.RunnerGroupID
}

// GetRunnerGroupName returns the RunnerGroupName field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunnerGroupName() string {
	if w == nil || w.RunnerGroupName == nil {
		return ""
	}
	return *w.RunnerGroupName
}

// GetRunnerID returns the RunnerID field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunnerID() int64 {
	if w == nil || w.RunnerID == nil {
		return 0
	}
	return *w.RunnerID
}

// GetRunnerName returns the RunnerName field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunnerName() string {
	if w == nil || w.RunnerName == nil {
		return ""
	}
	return *w.RunnerName
}

// GetRunURL returns the RunURL field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetRunURL() string {
	if w == nil || w.RunURL == nil {
		return ""
	}
	return *w.RunURL
}

// GetStartedAt returns the StartedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetStartedAt() Timestamp {
	if w == nil || w.StartedAt == nil {
		return Timestamp{}
	}
	return *w.StartedAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetStatus() string {
	if w == nil || w.Status == nil {
		return ""
	}
	return *w.Status
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetURL() string {
	if w == nil || w.URL == nil {
		return ""
	}
	return *w.URL
}

// GetWorkflowName returns the WorkflowName field if it's non-nil, zero value otherwise.
func (w *WorkflowJob) GetWorkflowName() string {
	if w == nil || w.WorkflowName == nil {
		return ""
	}
	return *w.WorkflowName
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (w *WorkflowJobEvent) GetAction() string {
	if w == nil || w.Action == nil {
		return ""
	}
	return *w.Action
}

// GetDeployment returns the Deployment field.
func (w *WorkflowJobEvent) GetDeployment() *Deployment {
	if w == nil {
		return nil
	}
	return w.Deployment
}

// GetInstallation returns the Installation field.
func (w *WorkflowJobEvent) GetInstallation() *Installation {
	if w == nil {
		return nil
	}
	return w.Installation
}

// GetOrg returns the Org field.
func (w *WorkflowJobEvent) GetOrg() *Organization {
	if w == nil {
		return nil
	}
	return w.Org
}

// GetRepo returns the Repo field.
func (w *WorkflowJobEvent) GetRepo() *Repository {
	if w == nil {
		return nil
	}
	return w.Repo
}

// GetSender returns the Sender field.
func (w *WorkflowJobEvent) GetSender() *User {
	if w == nil {
		return nil
	}
	return w.Sender
}

// GetWorkflowJob returns the WorkflowJob field.
func (w *WorkflowJobEvent) GetWorkflowJob() *WorkflowJob {
	if w == nil {
		return nil
	}
	return w.WorkflowJob
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetConclusion() string {
	if w == nil || w.Conclusion == nil {
		return ""
	}
	return *w.Conclusion
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetCreatedAt() Timestamp {
	if w == nil || w.CreatedAt == nil {
		return Timestamp{}
	}
	return *w.CreatedAt
}

// GetEnvironment returns the Environment field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetEnvironment() string {
	if w == nil || w.Environment == nil {
		return ""
	}
	return *w.Environment
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetHTMLURL() string {
	if w == nil || w.HTMLURL == nil {
		return ""
	}
	return *w.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetID() int64 {
	if w == nil || w.ID == nil {
		return 0
	}
	return *w.ID
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetName() string {
	if w == nil || w.Name == nil {
		return ""
	}
	return *w.Name
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetStatus() string {
	if w == nil || w.Status == nil {
		return ""
	}
	return *w.Status
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowJobRun) GetUpdatedAt() Timestamp {
	if w == nil || w.UpdatedAt == nil {
		return Timestamp{}
	}
	return *w.UpdatedAt
}

// GetActor returns the Actor field.
func (w *WorkflowRun) GetActor() *User {
	if w == nil {
		return nil
	}
	return w.Actor
}

// GetArtifactsURL returns the ArtifactsURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetArtifactsURL() string {
	if w == nil || w.ArtifactsURL == nil {
		return ""
	}
	return *w.ArtifactsURL
}

// GetCancelURL returns the CancelURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetCancelURL() string {
	if w == nil || w.CancelURL == nil {
		return ""
	}
	return *w.CancelURL
}

// GetCheckSuiteID returns the CheckSuiteID field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetCheckSuiteID() int64 {
	if w == nil || w.CheckSuiteID == nil {
		return 0
	}
	return *w.CheckSuiteID
}

// GetCheckSuiteNodeID returns the CheckSuiteNodeID field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetCheckSuiteNodeID() string {
	if w == nil || w.CheckSuiteNodeID == nil {
		return ""
	}
	return *w.CheckSuiteNodeID
}

// GetCheckSuiteURL returns the CheckSuiteURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetCheckSuiteURL() string {
	if w == nil || w.CheckSuiteURL == nil {
		return ""
	}
	return *w.CheckSuiteURL
}

// GetConclusion returns the Conclusion field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetConclusion() string {
	if w == nil || w.Conclusion == nil {
		return ""
	}
	return *w.Conclusion
}

// GetCreatedAt returns the CreatedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetCreatedAt() Timestamp {
	if w == nil || w.CreatedAt == nil {
		return Timestamp{}
	}
	return *w.CreatedAt
}

// GetDisplayTitle returns the DisplayTitle field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetDisplayTitle() string {
	if w == nil || w.DisplayTitle == nil {
		return ""
	}
	return *w.DisplayTitle
}

// GetEvent returns the Event field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetEvent() string {
	if w == nil || w.Event == nil {
		return ""
	}
	return *w.Event
}

// GetHeadBranch returns the HeadBranch field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetHeadBranch() string {
	if w == nil || w.HeadBranch == nil {
		return ""
	}
	return *w.HeadBranch
}

// GetHeadCommit returns the HeadCommit field.
func (w *WorkflowRun) GetHeadCommit() *HeadCommit {
	if w == nil {
		return nil
	}
	return w.HeadCommit
}

// GetHeadRepository returns the HeadRepository field.
func (w *WorkflowRun) GetHeadRepository() *Repository {
	if w == nil {
		return nil
	}
	return w.HeadRepository
}

// GetHeadSHA returns the HeadSHA field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetHeadSHA() string {
	if w == nil || w.HeadSHA == nil {
		return ""
	}
	return *w.HeadSHA
}

// GetHTMLURL returns the HTMLURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetHTMLURL() string {
	if w == nil || w.HTMLURL == nil {
		return ""
	}
	return *w.HTMLURL
}

// GetID returns the ID field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetID() int64 {
	if w == nil || w.ID == nil {
		return 0
	}
	return *w.ID
}

// GetJobsURL returns the JobsURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetJobsURL() string {
	if w == nil || w.JobsURL == nil {
		return ""
	}
	return *w.JobsURL
}

// GetLogsURL returns the LogsURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetLogsURL() string {
	if w == nil || w.LogsURL == nil {
		return ""
	}
	return *w.LogsURL
}

// GetName returns the Name field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetName() string {
	if w == nil || w.Name == nil {
		return ""
	}
	return *w.Name
}

// GetNodeID returns the NodeID field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetNodeID() string {
	if w == nil || w.NodeID == nil {
		return ""
	}
	return *w.NodeID
}

// GetPath returns the Path field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetPath() string {
	if w == nil || w.Path == nil {
		return ""
	}
	return *w.Path
}

// GetPreviousAttemptURL returns the PreviousAttemptURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetPreviousAttemptURL() string {
	if w == nil || w.PreviousAttemptURL == nil {
		return ""
	}
	return *w.PreviousAttemptURL
}

// GetRepository returns the Repository field.
func (w *WorkflowRun) GetRepository() *Repository {
	if w == nil {
		return nil
	}
	return w.Repository
}

// GetRerunURL returns the RerunURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetRerunURL() string {
	if w == nil || w.RerunURL == nil {
		return ""
	}
	return *w.RerunURL
}

// GetRunAttempt returns the RunAttempt field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetRunAttempt() int {
	if w == nil || w.RunAttempt == nil {
		return 0
	}
	return *w.RunAttempt
}

// GetRunNumber returns the RunNumber field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetRunNumber() int {
	if w == nil || w.RunNumber == nil {
		return 0
	}
	return *w.RunNumber
}

// GetRunStartedAt returns the RunStartedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetRunStartedAt() Timestamp {
	if w == nil || w.RunStartedAt == nil {
		return Timestamp{}
	}
	return *w.RunStartedAt
}

// GetStatus returns the Status field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetStatus() string {
	if w == nil || w.Status == nil {
		return ""
	}
	return *w.Status
}

// GetTriggeringActor returns the TriggeringActor field.
func (w *WorkflowRun) GetTriggeringActor() *User {
	if w == nil {
		return nil
	}
	return w.TriggeringActor
}

// GetUpdatedAt returns the UpdatedAt field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetUpdatedAt() Timestamp {
	if w == nil || w.UpdatedAt == nil {
		return Timestamp{}
	}
	return *w.UpdatedAt
}

// GetURL returns the URL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetURL() string {
	if w == nil || w.URL == nil {
		return ""
	}
	return *w.URL
}

// GetWorkflowID returns the WorkflowID field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetWorkflowID() int64 {
	if w == nil || w.WorkflowID == nil {
		return 0
	}
	return *w.WorkflowID
}

// GetWorkflowURL returns the WorkflowURL field if it's non-nil, zero value otherwise.
func (w *WorkflowRun) GetWorkflowURL() string {
	if w == nil || w.WorkflowURL == nil {
		return ""
	}
	return *w.WorkflowURL
}

// GetExcludePullRequests returns the ExcludePullRequests field if it's non-nil, zero value otherwise.
func (w *WorkflowRunAttemptOptions) GetExcludePullRequests() bool {
	if w == nil || w.ExcludePullRequests == nil {
		return false
	}
	return *w.ExcludePullRequests
}

// GetJobs returns the Jobs field if it's non-nil, zero value otherwise.
func (w *WorkflowRunBill) GetJobs() int {
	if w == nil || w.Jobs == nil {
		return 0
	}
	return *w.Jobs
}

// GetTotalMS returns the TotalMS field if it's non-nil, zero value otherwise.
func (w *WorkflowRunBill) GetTotalMS() int64 {
	if w == nil || w.TotalMS == nil {
		return 0
	}
	return *w.TotalMS
}

// GetAction returns the Action field if it's non-nil, zero value otherwise.
func (w *WorkflowRunEvent) GetAction() string {
	if w == nil || w.Action == nil {
		return ""
	}
	return *w.Action
}

// GetInstallation returns the Installation field.
func (w *WorkflowRunEvent) GetInstallation() *Installation {
	if w == nil {
		return nil
	}
	return w.Installation
}

// GetOrg returns the Org field.
func (w *WorkflowRunEvent) GetOrg() *Organization {
	if w == nil {
		return nil
	}
	return w.Org
}

// GetRepo returns the Repo field.
func (w *WorkflowRunEvent) GetRepo() *Repository {
	if w == nil {
		return nil
	}
	return w.Repo
}

// GetSender returns the Sender field.
func (w *WorkflowRunEvent) GetSender() *User {
	if w == nil {
		return nil
	}
	return w.Sender
}

// GetWorkflow returns the Workflow field.
func (w *WorkflowRunEvent) GetWorkflow() *Workflow {
	if w == nil {
		return nil
	}
	return w.Workflow
}

// GetWorkflowRun returns the WorkflowRun field.
func (w *WorkflowRunEvent) GetWorkflowRun() *WorkflowRun {
	if w == nil {
		return nil
	}
	return w.WorkflowRun
}

// GetDurationMS returns the DurationMS field if it's non-nil, zero value otherwise.
func (w *WorkflowRunJobRun) GetDurationMS() int64 {
	if w == nil || w.DurationMS == nil {
		return 0
	}
	return *w.DurationMS
}

// GetJobID returns the JobID field if it's non-nil, zero value otherwise.
func (w *WorkflowRunJobRun) GetJobID() int {
	if w == nil || w.JobID == nil {
		return 0
	}
	return *w.JobID
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (w *WorkflowRuns) GetTotalCount() int {
	if w == nil || w.TotalCount == nil {
		return 0
	}
	return *w.TotalCount
}

// GetBillable returns the Billable field.
func (w *WorkflowRunUsage) GetBillable() *WorkflowRunBillMap {
	if w == nil {
		return nil
	}
	return w.Billable
}

// GetRunDurationMS returns the RunDurationMS field if it's non-nil, zero value otherwise.
func (w *WorkflowRunUsage) GetRunDurationMS() int64 {
	if w == nil || w.RunDurationMS == nil {
		return 0
	}
	return *w.RunDurationMS
}

// GetTotalCount returns the TotalCount field if it's non-nil, zero value otherwise.
func (w *Workflows) GetTotalCount() int {
	if w == nil || w.TotalCount == nil {
		return 0
	}
	return *w.TotalCount
}

// GetDoNotEnforceOnCreate returns the DoNotEnforceOnCreate field if it's non-nil, zero value otherwise.
func (w *WorkflowsRuleParameters) GetDoNotEnforceOnCreate() bool {
	if w == nil || w.DoNotEnforceOnCreate == nil {
		return false
	}
	return *w.DoNotEnforceOnCreate
}

// GetBillable returns the Billable field.
func (w *WorkflowUsage) GetBillable() *WorkflowBillMap {
	if w == nil {
		return nil
	}
	return w.Billable
}
