/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* generated from fedora kernel 6.12.9-200.fc41.aarch64 */

#ifndef __VMLINUX_ARM64_H__
#define __VMLINUX_ARM64_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_BUTTON_LID_INIT_IGNORE = 0,
	ACPI_BUTTON_LID_INIT_OPEN = 1,
	ACPI_BUTTON_LID_INIT_METHOD = 2,
	ACPI_BUTTON_LID_INIT_DISABLED = 3,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	AM62A7_EFUSE_M_MPU_OPP = 13,
	AM62A7_EFUSE_N_MPU_OPP = 14,
	AM62A7_EFUSE_O_MPU_OPP = 15,
	AM62A7_EFUSE_P_MPU_OPP = 16,
	AM62A7_EFUSE_Q_MPU_OPP = 17,
	AM62A7_EFUSE_R_MPU_OPP = 18,
	AM62A7_EFUSE_S_MPU_OPP = 19,
	AM62A7_EFUSE_V_MPU_OPP = 20,
	AM62A7_EFUSE_U_MPU_OPP = 21,
	AM62A7_EFUSE_T_MPU_OPP = 22,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_VALUES_DS_TIMEOUT = 13,
	AX25_MAX_VALUES = 14,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BAD_STACK = -1,
	NOT_STACK = 0,
	GOOD_FRAME = 1,
	GOOD_STACK = 2,
};

enum {
	BD718XX_INT_STBY_REQ = 0,
	BD718XX_INT_ON_REQ = 1,
	BD718XX_INT_WDOG = 2,
	BD718XX_INT_PWRBTN = 3,
	BD718XX_INT_PWRBTN_L = 4,
	BD718XX_INT_PWRBTN_S = 5,
	BD718XX_INT_SWRST = 6,
};

enum {
	BD718XX_REG_REV = 0,
	BD718XX_REG_SWRESET = 1,
	BD718XX_REG_I2C_DEV = 2,
	BD718XX_REG_PWRCTRL0 = 3,
	BD718XX_REG_PWRCTRL1 = 4,
	BD718XX_REG_BUCK1_CTRL = 5,
	BD718XX_REG_BUCK2_CTRL = 6,
	BD718XX_REG_1ST_NODVS_BUCK_CTRL = 9,
	BD718XX_REG_2ND_NODVS_BUCK_CTRL = 10,
	BD718XX_REG_3RD_NODVS_BUCK_CTRL = 11,
	BD718XX_REG_4TH_NODVS_BUCK_CTRL = 12,
	BD718XX_REG_BUCK1_VOLT_RUN = 13,
	BD718XX_REG_BUCK1_VOLT_IDLE = 14,
	BD718XX_REG_BUCK1_VOLT_SUSP = 15,
	BD718XX_REG_BUCK2_VOLT_RUN = 16,
	BD718XX_REG_BUCK2_VOLT_IDLE = 17,
	BD718XX_REG_1ST_NODVS_BUCK_VOLT = 20,
	BD718XX_REG_2ND_NODVS_BUCK_VOLT = 21,
	BD718XX_REG_3RD_NODVS_BUCK_VOLT = 22,
	BD718XX_REG_4TH_NODVS_BUCK_VOLT = 23,
	BD718XX_REG_LDO1_VOLT = 24,
	BD718XX_REG_LDO2_VOLT = 25,
	BD718XX_REG_LDO3_VOLT = 26,
	BD718XX_REG_LDO4_VOLT = 27,
	BD718XX_REG_LDO5_VOLT = 28,
	BD718XX_REG_LDO6_VOLT = 29,
	BD718XX_REG_TRANS_COND0 = 31,
	BD718XX_REG_TRANS_COND1 = 32,
	BD718XX_REG_VRFAULTEN = 33,
	BD718XX_REG_MVRFLTMASK0 = 34,
	BD718XX_REG_MVRFLTMASK1 = 35,
	BD718XX_REG_MVRFLTMASK2 = 36,
	BD718XX_REG_RCVCFG = 37,
	BD718XX_REG_RCVNUM = 38,
	BD718XX_REG_PWRONCONFIG0 = 39,
	BD718XX_REG_PWRONCONFIG1 = 40,
	BD718XX_REG_RESETSRC = 41,
	BD718XX_REG_MIRQ = 42,
	BD718XX_REG_IRQ = 43,
	BD718XX_REG_IN_MON = 44,
	BD718XX_REG_POW_STATE = 45,
	BD718XX_REG_OUT32K = 46,
	BD718XX_REG_REGLOCK = 47,
	BD718XX_REG_OTPVER = 255,
	BD718XX_MAX_REGISTER = 256,
};

enum {
	BIAS = 2147483648,
};

enum {
	BINDER_BUFFER_FLAG_HAS_PARENT = 1,
};

enum {
	BINDER_DEBUG_USER_ERROR = 1,
	BINDER_DEBUG_FAILED_TRANSACTION = 2,
	BINDER_DEBUG_DEAD_TRANSACTION = 4,
	BINDER_DEBUG_OPEN_CLOSE = 8,
	BINDER_DEBUG_DEAD_BINDER = 16,
	BINDER_DEBUG_DEATH_NOTIFICATION = 32,
	BINDER_DEBUG_READ_WRITE = 64,
	BINDER_DEBUG_USER_REFS = 128,
	BINDER_DEBUG_THREADS = 256,
	BINDER_DEBUG_TRANSACTION = 512,
	BINDER_DEBUG_TRANSACTION_COMPLETE = 1024,
	BINDER_DEBUG_FREE_BUFFER = 2048,
	BINDER_DEBUG_INTERNAL_REFS = 4096,
	BINDER_DEBUG_PRIORITY_CAP = 8192,
	BINDER_DEBUG_SPINLOCKS = 16384,
};

enum {
	BINDER_DEBUG_USER_ERROR___2 = 1,
	BINDER_DEBUG_OPEN_CLOSE___2 = 2,
	BINDER_DEBUG_BUFFER_ALLOC = 4,
	BINDER_DEBUG_BUFFER_ALLOC_ASYNC = 8,
};

enum {
	BINDER_LOOPER_STATE_REGISTERED = 1,
	BINDER_LOOPER_STATE_ENTERED = 2,
	BINDER_LOOPER_STATE_EXITED = 4,
	BINDER_LOOPER_STATE_INVALID = 8,
	BINDER_LOOPER_STATE_WAITING = 16,
	BINDER_LOOPER_STATE_POLL = 32,
};

enum {
	BINDER_TYPE_BINDER = 1935813253,
	BINDER_TYPE_WEAK_BINDER = 2002922117,
	BINDER_TYPE_HANDLE = 1936206469,
	BINDER_TYPE_WEAK_HANDLE = 2003315333,
	BINDER_TYPE_FD = 1717840517,
	BINDER_TYPE_FDA = 1717854597,
	BINDER_TYPE_PTR = 1886661253,
};

enum {
	BINDER_WRITE_READ = 3224396289,
	BINDER_SET_IDLE_TIMEOUT = 1074291203,
	BINDER_SET_MAX_THREADS = 1074029061,
	BINDER_SET_IDLE_PRIORITY = 1074029062,
	BINDER_SET_CONTEXT_MGR = 1074029063,
	BINDER_THREAD_EXIT = 1074029064,
	BINDER_VERSION = 3221512713,
	BINDER_GET_NODE_DEBUG_INFO = 3222823435,
	BINDER_GET_NODE_INFO_FOR_REF = 3222823436,
	BINDER_SET_CONTEXT_MGR_EXT = 1075339789,
	BINDER_FREEZE = 1074553358,
	BINDER_GET_FROZEN_INFO = 3222037007,
	BINDER_ENABLE_ONEWAY_SPAM_DETECTION = 1074029072,
	BINDER_GET_EXTENDED_ERROR = 3222037009,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_PLUGGING = 12,
	BIO_EMULATES_ZONE_APPEND = 13,
	BIO_FLAG_LAST = 14,
};

enum {
	BLK_MQ_F_SHOULD_MERGE = 1,
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_NO_SCHED = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_ALLOC_POLICY_START_BIT = 7,
	BLK_MQ_F_ALLOC_POLICY_BITS = 1,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLK_TAG_ALLOC_FIFO = 0,
	BLK_TAG_ALLOC_RR = 1,
	BLK_TAG_ALLOC_MAX = 2,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_BPRM_SECUREEXEC = 1,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTRFS_FILE_EXTENT_INLINE = 0,
	BTRFS_FILE_EXTENT_REG = 1,
	BTRFS_FILE_EXTENT_PREALLOC = 2,
	BTRFS_NR_FILE_EXTENT_TYPES = 3,
};

enum {
	BTRFS_FS_CLOSING_START = 0,
	BTRFS_FS_CLOSING_DONE = 1,
	BTRFS_FS_LOG_RECOVERING = 2,
	BTRFS_FS_OPEN = 3,
	BTRFS_FS_QUOTA_ENABLED = 4,
	BTRFS_FS_UPDATE_UUID_TREE_GEN = 5,
	BTRFS_FS_CREATING_FREE_SPACE_TREE = 6,
	BTRFS_FS_BTREE_ERR = 7,
	BTRFS_FS_LOG1_ERR = 8,
	BTRFS_FS_LOG2_ERR = 9,
	BTRFS_FS_QUOTA_OVERRIDE = 10,
	BTRFS_FS_FROZEN = 11,
	BTRFS_FS_BALANCE_RUNNING = 12,
	BTRFS_FS_RELOC_RUNNING = 13,
	BTRFS_FS_CLEANER_RUNNING = 14,
	BTRFS_FS_CSUM_IMPL_FAST = 15,
	BTRFS_FS_DISCARD_RUNNING = 16,
	BTRFS_FS_CLEANUP_SPACE_CACHE_V1 = 17,
	BTRFS_FS_FREE_SPACE_TREE_UNTRUSTED = 18,
	BTRFS_FS_TREE_MOD_LOG_USERS = 19,
	BTRFS_FS_COMMIT_TRANS = 20,
	BTRFS_FS_UNFINISHED_DROPS = 21,
	BTRFS_FS_NEED_ZONE_FINISH = 22,
	BTRFS_FS_NEED_TRANS_COMMIT = 23,
	BTRFS_FS_ACTIVE_ZONE_TRACKING = 24,
	BTRFS_FS_FEATURE_CHANGED = 25,
	BTRFS_FS_UNALIGNED_TREE_BLOCK = 26,
};

enum {
	BTRFS_FS_STATE_REMOUNTING = 0,
	BTRFS_FS_STATE_RO = 1,
	BTRFS_FS_STATE_TRANS_ABORTED = 2,
	BTRFS_FS_STATE_DEV_REPLACING = 3,
	BTRFS_FS_STATE_DUMMY_FS_INFO = 4,
	BTRFS_FS_STATE_NO_DATA_CSUMS = 5,
	BTRFS_FS_STATE_SKIP_META_CSUMS = 6,
	BTRFS_FS_STATE_LOG_CLEANUP_ERROR = 7,
	BTRFS_FS_STATE_COUNT = 8,
};

enum {
	BTRFS_INODE_FLUSH_ON_CLOSE = 0,
	BTRFS_INODE_DUMMY = 1,
	BTRFS_INODE_IN_DEFRAG = 2,
	BTRFS_INODE_HAS_ASYNC_EXTENT = 3,
	BTRFS_INODE_NEEDS_FULL_SYNC = 4,
	BTRFS_INODE_COPY_EVERYTHING = 5,
	BTRFS_INODE_HAS_PROPS = 6,
	BTRFS_INODE_SNAPSHOT_FLUSH = 7,
	BTRFS_INODE_NO_XATTRS = 8,
	BTRFS_INODE_NO_DELALLOC_FLUSH = 9,
	BTRFS_INODE_VERITY_IN_PROGRESS = 10,
	BTRFS_INODE_FREE_SPACE_INODE = 11,
	BTRFS_INODE_NO_CAP_XATTR = 12,
	BTRFS_INODE_COW_WRITE_ERROR = 13,
	BTRFS_INODE_ROOT_STUB = 14,
};

enum {
	BTRFS_MOUNT_NODATASUM = 1ULL,
	BTRFS_MOUNT_NODATACOW = 2ULL,
	BTRFS_MOUNT_NOBARRIER = 4ULL,
	BTRFS_MOUNT_SSD = 8ULL,
	BTRFS_MOUNT_DEGRADED = 16ULL,
	BTRFS_MOUNT_COMPRESS = 32ULL,
	BTRFS_MOUNT_NOTREELOG = 64ULL,
	BTRFS_MOUNT_FLUSHONCOMMIT = 128ULL,
	BTRFS_MOUNT_SSD_SPREAD = 256ULL,
	BTRFS_MOUNT_NOSSD = 512ULL,
	BTRFS_MOUNT_DISCARD_SYNC = 1024ULL,
	BTRFS_MOUNT_FORCE_COMPRESS = 2048ULL,
	BTRFS_MOUNT_SPACE_CACHE = 4096ULL,
	BTRFS_MOUNT_CLEAR_CACHE = 8192ULL,
	BTRFS_MOUNT_USER_SUBVOL_RM_ALLOWED = 16384ULL,
	BTRFS_MOUNT_ENOSPC_DEBUG = 32768ULL,
	BTRFS_MOUNT_AUTO_DEFRAG = 65536ULL,
	BTRFS_MOUNT_USEBACKUPROOT = 131072ULL,
	BTRFS_MOUNT_SKIP_BALANCE = 262144ULL,
	BTRFS_MOUNT_PANIC_ON_FATAL_ERROR = 524288ULL,
	BTRFS_MOUNT_RESCAN_UUID_TREE = 1048576ULL,
	BTRFS_MOUNT_FRAGMENT_DATA = 2097152ULL,
	BTRFS_MOUNT_FRAGMENT_METADATA = 4194304ULL,
	BTRFS_MOUNT_FREE_SPACE_TREE = 8388608ULL,
	BTRFS_MOUNT_NOLOGREPLAY = 16777216ULL,
	BTRFS_MOUNT_REF_VERIFY = 33554432ULL,
	BTRFS_MOUNT_DISCARD_ASYNC = 67108864ULL,
	BTRFS_MOUNT_IGNOREBADROOTS = 134217728ULL,
	BTRFS_MOUNT_IGNOREDATACSUMS = 268435456ULL,
	BTRFS_MOUNT_NODISCARD = 536870912ULL,
	BTRFS_MOUNT_NOSPACECACHE = 1073741824ULL,
	BTRFS_MOUNT_IGNOREMETACSUMS = 2147483648ULL,
	BTRFS_MOUNT_IGNORESUPERFLAGS = 4294967296ULL,
};

enum {
	BTRFS_ORDERED_REGULAR = 0,
	BTRFS_ORDERED_NOCOW = 1,
	BTRFS_ORDERED_PREALLOC = 2,
	BTRFS_ORDERED_COMPRESSED = 3,
	BTRFS_ORDERED_DIRECT = 4,
	BTRFS_ORDERED_IO_DONE = 5,
	BTRFS_ORDERED_COMPLETE = 6,
	BTRFS_ORDERED_IOERR = 7,
	BTRFS_ORDERED_TRUNCATED = 8,
	BTRFS_ORDERED_LOGGED = 9,
	BTRFS_ORDERED_LOGGED_CSUM = 10,
	BTRFS_ORDERED_PENDING = 11,
	BTRFS_ORDERED_ENCODED = 12,
};

enum {
	BTRFS_ROOT_IN_TRANS_SETUP = 0,
	BTRFS_ROOT_SHAREABLE = 1,
	BTRFS_ROOT_TRACK_DIRTY = 2,
	BTRFS_ROOT_IN_RADIX = 3,
	BTRFS_ROOT_ORPHAN_ITEM_INSERTED = 4,
	BTRFS_ROOT_DEFRAG_RUNNING = 5,
	BTRFS_ROOT_FORCE_COW = 6,
	BTRFS_ROOT_MULTI_LOG_TASKS = 7,
	BTRFS_ROOT_DIRTY = 8,
	BTRFS_ROOT_DELETING = 9,
	BTRFS_ROOT_DEAD_RELOC_TREE = 10,
	BTRFS_ROOT_DEAD_TREE = 11,
	BTRFS_ROOT_HAS_LOG_TREE = 12,
	BTRFS_ROOT_QGROUP_FLUSHING = 13,
	BTRFS_ROOT_ORPHAN_CLEANUP = 14,
	BTRFS_ROOT_UNFINISHED_DROP = 15,
	BTRFS_ROOT_RESET_LOCKDEP_CLASS = 16,
};

enum {
	BTRFS_SEND_A_UNSPEC = 0,
	BTRFS_SEND_A_UUID = 1,
	BTRFS_SEND_A_CTRANSID = 2,
	BTRFS_SEND_A_INO = 3,
	BTRFS_SEND_A_SIZE = 4,
	BTRFS_SEND_A_MODE = 5,
	BTRFS_SEND_A_UID = 6,
	BTRFS_SEND_A_GID = 7,
	BTRFS_SEND_A_RDEV = 8,
	BTRFS_SEND_A_CTIME = 9,
	BTRFS_SEND_A_MTIME = 10,
	BTRFS_SEND_A_ATIME = 11,
	BTRFS_SEND_A_OTIME = 12,
	BTRFS_SEND_A_XATTR_NAME = 13,
	BTRFS_SEND_A_XATTR_DATA = 14,
	BTRFS_SEND_A_PATH = 15,
	BTRFS_SEND_A_PATH_TO = 16,
	BTRFS_SEND_A_PATH_LINK = 17,
	BTRFS_SEND_A_FILE_OFFSET = 18,
	BTRFS_SEND_A_DATA = 19,
	BTRFS_SEND_A_CLONE_UUID = 20,
	BTRFS_SEND_A_CLONE_CTRANSID = 21,
	BTRFS_SEND_A_CLONE_PATH = 22,
	BTRFS_SEND_A_CLONE_OFFSET = 23,
	BTRFS_SEND_A_CLONE_LEN = 24,
	BTRFS_SEND_A_MAX_V1 = 24,
	BTRFS_SEND_A_FALLOCATE_MODE = 25,
	BTRFS_SEND_A_FILEATTR = 26,
	BTRFS_SEND_A_UNENCODED_FILE_LEN = 27,
	BTRFS_SEND_A_UNENCODED_LEN = 28,
	BTRFS_SEND_A_UNENCODED_OFFSET = 29,
	BTRFS_SEND_A_COMPRESSION = 30,
	BTRFS_SEND_A_ENCRYPTION = 31,
	BTRFS_SEND_A_MAX_V2 = 31,
	BTRFS_SEND_A_VERITY_ALGORITHM = 32,
	BTRFS_SEND_A_VERITY_BLOCK_SIZE = 33,
	BTRFS_SEND_A_VERITY_SALT_DATA = 34,
	BTRFS_SEND_A_VERITY_SIG_DATA = 35,
	BTRFS_SEND_A_MAX_V3 = 35,
	__BTRFS_SEND_A_MAX = 35,
};

enum {
	BTRFS_STAT_CURR = 0,
	BTRFS_STAT_PREV = 1,
	BTRFS_STAT_NR_ENTRIES = 2,
};

enum {
	Blktrace_setup = 1,
	Blktrace_running = 2,
	Blktrace_stopped = 3,
};

enum {
	C0D0U0 = 0,
	C0D0U1 = 1,
	C0D1U0 = 2,
	C0D1U1 = 3,
	C1D0U0 = 4,
	C1D0U1 = 5,
	C1D1U0 = 6,
	C1D1U1 = 7,
	DRAM_CLKTREE_NUM = 8,
};

enum {
	CAP_HWCAP = 1,
	CAP_COMPAT_HWCAP = 2,
	CAP_COMPAT_HWCAP2 = 3,
};

enum {
	CDX_DEV_MSI_CONF = 0,
	CDX_DEV_BUS_MASTER_CONF = 1,
	CDX_DEV_RESET_CONF = 2,
	CDX_DEV_MSI_ENABLE = 3,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
	CGRP_KILL = 4,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CLK_ALPHA_PLL_TYPE_DEFAULT = 0,
	CLK_ALPHA_PLL_TYPE_HUAYRA = 1,
	CLK_ALPHA_PLL_TYPE_HUAYRA_APSS = 2,
	CLK_ALPHA_PLL_TYPE_HUAYRA_2290 = 3,
	CLK_ALPHA_PLL_TYPE_BRAMMO = 4,
	CLK_ALPHA_PLL_TYPE_FABIA = 5,
	CLK_ALPHA_PLL_TYPE_TRION = 6,
	CLK_ALPHA_PLL_TYPE_LUCID = 6,
	CLK_ALPHA_PLL_TYPE_AGERA = 7,
	CLK_ALPHA_PLL_TYPE_ZONDA = 8,
	CLK_ALPHA_PLL_TYPE_REGERA = 8,
	CLK_ALPHA_PLL_TYPE_ZONDA_OLE = 9,
	CLK_ALPHA_PLL_TYPE_LUCID_EVO = 10,
	CLK_ALPHA_PLL_TYPE_LUCID_OLE = 11,
	CLK_ALPHA_PLL_TYPE_RIVIAN_EVO = 12,
	CLK_ALPHA_PLL_TYPE_DEFAULT_EVO = 13,
	CLK_ALPHA_PLL_TYPE_BRAMMO_EVO = 14,
	CLK_ALPHA_PLL_TYPE_STROMER = 15,
	CLK_ALPHA_PLL_TYPE_STROMER_PLUS = 16,
	CLK_ALPHA_PLL_TYPE_NSS_HUAYRA = 17,
	CLK_ALPHA_PLL_TYPE_MAX = 18,
};

enum {
	CMD_CLK_GET_RATE = 1,
	CMD_CLK_SET_RATE = 2,
	CMD_CLK_ROUND_RATE = 3,
	CMD_CLK_GET_PARENT = 4,
	CMD_CLK_SET_PARENT = 5,
	CMD_CLK_IS_ENABLED = 6,
	CMD_CLK_ENABLE = 7,
	CMD_CLK_DISABLE = 8,
	CMD_CLK_PROPERTIES = 9,
	CMD_CLK_POSSIBLE_PARENTS = 10,
	CMD_CLK_NUM_POSSIBLE_PARENTS = 11,
	CMD_CLK_GET_POSSIBLE_PARENT = 12,
	CMD_CLK_RESET_REFCOUNTS = 13,
	CMD_CLK_GET_ALL_INFO = 14,
	CMD_CLK_GET_MAX_CLK_ID = 15,
	CMD_CLK_GET_FMAX_AT_VMIN = 16,
	CMD_CLK_MAX = 17,
};

enum {
	CMD_UPHY_PCIE_LANE_MARGIN_CONTROL = 1,
	CMD_UPHY_PCIE_LANE_MARGIN_STATUS = 2,
	CMD_UPHY_PCIE_EP_CONTROLLER_PLL_INIT = 3,
	CMD_UPHY_PCIE_CONTROLLER_STATE = 4,
	CMD_UPHY_PCIE_EP_CONTROLLER_PLL_OFF = 5,
	CMD_UPHY_DISPLAY_PORT_INIT = 6,
	CMD_UPHY_DISPLAY_PORT_OFF = 7,
	CMD_UPHY_XUSB_DYN_LANES_RESTORE = 8,
	CMD_UPHY_MAX = 9,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CP110_CLK_TYPE_CORE = 0,
	CP110_CLK_TYPE_GATABLE = 1,
};

enum {
	CPER_SEV_RECOVERABLE = 0,
	CPER_SEV_FATAL = 1,
	CPER_SEV_CORRECTED = 2,
	CPER_SEV_INFORMATIONAL = 3,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 1000,
	CRNG_RESEED_INTERVAL = 60000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_AUTHENC_KEYA_UNSPEC = 0,
	CRYPTO_AUTHENC_KEYA_PARAM = 1,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	CXL_MEM_COMMAND_ID_INVALID = 0,
	CXL_MEM_COMMAND_ID_IDENTIFY = 1,
	CXL_MEM_COMMAND_ID_RAW = 2,
	CXL_MEM_COMMAND_ID_GET_SUPPORTED_LOGS = 3,
	CXL_MEM_COMMAND_ID_GET_FW_INFO = 4,
	CXL_MEM_COMMAND_ID_GET_PARTITION_INFO = 5,
	CXL_MEM_COMMAND_ID_GET_LSA = 6,
	CXL_MEM_COMMAND_ID_GET_HEALTH_INFO = 7,
	CXL_MEM_COMMAND_ID_GET_LOG = 8,
	CXL_MEM_COMMAND_ID_SET_PARTITION_INFO = 9,
	CXL_MEM_COMMAND_ID_SET_LSA = 10,
	CXL_MEM_COMMAND_ID_GET_ALERT_CONFIG = 11,
	CXL_MEM_COMMAND_ID_SET_ALERT_CONFIG = 12,
	CXL_MEM_COMMAND_ID_GET_SHUTDOWN_STATE = 13,
	CXL_MEM_COMMAND_ID_SET_SHUTDOWN_STATE = 14,
	CXL_MEM_DEPRECATED_ID_GET_POISON = 15,
	CXL_MEM_DEPRECATED_ID_INJECT_POISON = 16,
	CXL_MEM_DEPRECATED_ID_CLEAR_POISON = 17,
	CXL_MEM_COMMAND_ID_GET_SCAN_MEDIA_CAPS = 18,
	CXL_MEM_DEPRECATED_ID_SCAN_MEDIA = 19,
	CXL_MEM_DEPRECATED_ID_GET_SCAN_MEDIA = 20,
	CXL_MEM_COMMAND_ID_GET_TIMESTAMP = 21,
	CXL_MEM_COMMAND_ID_GET_LOG_CAPS = 22,
	CXL_MEM_COMMAND_ID_CLEAR_LOG = 23,
	CXL_MEM_COMMAND_ID_GET_SUP_LOG_SUBLIST = 24,
	CXL_MEM_COMMAND_ID_MAX = 25,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_MIN = 2,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DM_IO_ACCOUNTED = 0,
	DM_IO_WAS_SPLIT = 1,
	DM_IO_BLK_STAT = 2,
};

enum {
	DM_TIO_INSIDE_DM_IO = 0,
	DM_TIO_IS_DUPLICATE_BIO = 1,
};

enum {
	DM_VERSION_CMD = 0,
	DM_REMOVE_ALL_CMD = 1,
	DM_LIST_DEVICES_CMD = 2,
	DM_DEV_CREATE_CMD = 3,
	DM_DEV_REMOVE_CMD = 4,
	DM_DEV_RENAME_CMD = 5,
	DM_DEV_SUSPEND_CMD = 6,
	DM_DEV_STATUS_CMD = 7,
	DM_DEV_WAIT_CMD = 8,
	DM_TABLE_LOAD_CMD = 9,
	DM_TABLE_CLEAR_CMD = 10,
	DM_TABLE_DEPS_CMD = 11,
	DM_TABLE_STATUS_CMD = 12,
	DM_LIST_VERSIONS_CMD = 13,
	DM_TARGET_MSG_CMD = 14,
	DM_DEV_SET_GEOMETRY_CMD = 15,
	DM_DEV_ARM_POLL_CMD = 16,
	DM_GET_TARGET_VERSION_CMD = 17,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DPLL_NLGRP_MONITOR = 0,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DT_BI_TCXO = 0,
	DT_SLEEP_CLK = 1,
	DT_UFS_PHY_RX_SYMBOL_0_CLK = 2,
	DT_UFS_PHY_RX_SYMBOL_1_CLK = 3,
	DT_UFS_PHY_TX_SYMBOL_0_CLK = 4,
	DT_UFS_CARD_RX_SYMBOL_0_CLK = 5,
	DT_UFS_CARD_RX_SYMBOL_1_CLK = 6,
	DT_UFS_CARD_TX_SYMBOL_0_CLK = 7,
	DT_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 8,
	DT_GCC_USB4_PHY_PIPEGMUX_CLK_SRC = 9,
	DT_GCC_USB4_PHY_DP_GMUX_CLK_SRC = 10,
	DT_GCC_USB4_PHY_SYS_PIPEGMUX_CLK_SRC = 11,
	DT_USB4_PHY_GCC_USB4_PCIE_PIPE_CLK = 12,
	DT_USB4_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 13,
	DT_QUSB4PHY_GCC_USB4_RX0_CLK = 14,
	DT_QUSB4PHY_GCC_USB4_RX1_CLK = 15,
	DT_USB3_UNI_PHY_SEC_GCC_USB30_PIPE_CLK = 16,
	DT_GCC_USB4_1_PHY_PIPEGMUX_CLK_SRC = 17,
	DT_GCC_USB4_1_PHY_DP_GMUX_CLK_SRC = 18,
	DT_GCC_USB4_1_PHY_SYS_PIPEGMUX_CLK_SRC = 19,
	DT_USB4_1_PHY_GCC_USB4_PCIE_PIPE_CLK = 20,
	DT_USB4_1_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 21,
	DT_QUSB4PHY_1_GCC_USB4_RX0_CLK = 22,
	DT_QUSB4PHY_1_GCC_USB4_RX1_CLK = 23,
	DT_USB3_UNI_PHY_MP_GCC_USB30_PIPE_0_CLK = 24,
	DT_USB3_UNI_PHY_MP_GCC_USB30_PIPE_1_CLK = 25,
	DT_PCIE_2A_PIPE_CLK = 26,
	DT_PCIE_2B_PIPE_CLK = 27,
	DT_PCIE_3A_PIPE_CLK = 28,
	DT_PCIE_3B_PIPE_CLK = 29,
	DT_PCIE_4_PIPE_CLK = 30,
	DT_RXC0_REF_CLK = 31,
	DT_RXC1_REF_CLK = 32,
};

enum {
	DT_BI_TCXO___2 = 0,
	DT_SLEEP_CLK___2 = 1,
	DT_PCIE_3_PIPE = 2,
	DT_PCIE_4_PIPE = 3,
	DT_PCIE_5_PIPE = 4,
	DT_PCIE_6A_PIPE = 5,
	DT_PCIE_6B_PIPE = 6,
	DT_USB3_PHY_0_WRAPPER_GCC_USB30_PIPE = 7,
	DT_USB3_PHY_1_WRAPPER_GCC_USB30_PIPE = 8,
	DT_USB3_PHY_2_WRAPPER_GCC_USB30_PIPE = 9,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_FLAGS_QUERY_ENABLED = 0,
	EC_FLAGS_EVENT_HANDLER_INSTALLED = 1,
	EC_FLAGS_EC_HANDLER_INSTALLED = 2,
	EC_FLAGS_EC_REG_CALLED = 3,
	EC_FLAGS_QUERY_METHODS_INSTALLED = 4,
	EC_FLAGS_STARTED = 5,
	EC_FLAGS_STOPPED = 6,
	EC_FLAGS_EVENTS_MASKED = 7,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	__ETHTOOL_A_RINGS_CNT = 17,
	ETHTOOL_A_RINGS_MAX = 16,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	__ETHTOOL_A_TSINFO_CNT = 7,
	ETHTOOL_A_TSINFO_MAX = 6,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	__ETHTOOL_A_TS_STAT_CNT = 4,
	ETHTOOL_A_TS_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	__ETHTOOL_MSG_KERNEL_CNT = 47,
	ETHTOOL_MSG_KERNEL_MAX = 46,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	__ETHTOOL_MSG_USER_CNT = 46,
	ETHTOOL_MSG_USER_MAX = 45,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	__ETHTOOL_STATS_CNT = 4,
};

enum {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

enum {
	EXTENT_BUFFER_UPTODATE = 0,
	EXTENT_BUFFER_DIRTY = 1,
	EXTENT_BUFFER_CORRUPT = 2,
	EXTENT_BUFFER_READAHEAD = 3,
	EXTENT_BUFFER_TREE_REF = 4,
	EXTENT_BUFFER_STALE = 5,
	EXTENT_BUFFER_WRITEBACK = 6,
	EXTENT_BUFFER_READ_ERR = 7,
	EXTENT_BUFFER_UNMAPPED = 8,
	EXTENT_BUFFER_IN_TREE = 9,
	EXTENT_BUFFER_WRITE_ERR = 10,
	EXTENT_BUFFER_ZONED_ZEROOUT = 11,
	EXTENT_BUFFER_READING = 12,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FGRAPH_TYPE_RESERVED = 0,
	FGRAPH_TYPE_BITMAP = 1,
	FGRAPH_TYPE_DATA = 2,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FLAGS_FILL_FULL = 268435456,
	FLAGS_FILL_START = 536870912,
	FLAGS_FILL_END = 805306368,
};

enum {
	FLAT_BINDER_FLAG_PRIORITY_MASK = 255,
	FLAT_BINDER_FLAG_ACCEPTS_FDS = 256,
	FLAT_BINDER_FLAG_TXN_SECURITY_CTX = 4096,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FRACTION_DENOM = 128,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	__FRA_MAX = 26,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FTRACE_FL_ENABLED = 2147483648,
	FTRACE_FL_REGS = 1073741824,
	FTRACE_FL_REGS_EN = 536870912,
	FTRACE_FL_TRAMP = 268435456,
	FTRACE_FL_TRAMP_EN = 134217728,
	FTRACE_FL_IPMODIFY = 67108864,
	FTRACE_FL_DISABLED = 33554432,
	FTRACE_FL_DIRECT = 16777216,
	FTRACE_FL_DIRECT_EN = 8388608,
	FTRACE_FL_CALL_OPS = 4194304,
	FTRACE_FL_CALL_OPS_EN = 2097152,
	FTRACE_FL_TOUCHED = 1048576,
	FTRACE_FL_MODIFIED = 524288,
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum {
	FTRACE_ITER_FILTER = 1,
	FTRACE_ITER_NOTRACE = 2,
	FTRACE_ITER_PRINTALL = 4,
	FTRACE_ITER_DO_PROBES = 8,
	FTRACE_ITER_PROBE = 16,
	FTRACE_ITER_MOD = 32,
	FTRACE_ITER_ENABLED = 64,
	FTRACE_ITER_TOUCHED = 128,
	FTRACE_ITER_ADDRS = 256,
};

enum {
	FTRACE_MODIFY_ENABLE_FL = 1,
	FTRACE_MODIFY_MAY_SLEEP_FL = 2,
};

enum {
	FTRACE_OPS_FL_ENABLED = 1,
	FTRACE_OPS_FL_DYNAMIC = 2,
	FTRACE_OPS_FL_SAVE_REGS = 4,
	FTRACE_OPS_FL_SAVE_REGS_IF_SUPPORTED = 8,
	FTRACE_OPS_FL_RECURSION = 16,
	FTRACE_OPS_FL_STUB = 32,
	FTRACE_OPS_FL_INITIALIZED = 64,
	FTRACE_OPS_FL_DELETED = 128,
	FTRACE_OPS_FL_ADDING = 256,
	FTRACE_OPS_FL_REMOVING = 512,
	FTRACE_OPS_FL_MODIFYING = 1024,
	FTRACE_OPS_FL_ALLOC_TRAMP = 2048,
	FTRACE_OPS_FL_IPMODIFY = 4096,
	FTRACE_OPS_FL_PID = 8192,
	FTRACE_OPS_FL_RCU = 16384,
	FTRACE_OPS_FL_TRACE_ARRAY = 32768,
	FTRACE_OPS_FL_PERMANENT = 65536,
	FTRACE_OPS_FL_DIRECT = 131072,
	FTRACE_OPS_FL_SUBOP = 262144,
};

enum {
	FTRACE_UPDATE_CALLS = 1,
	FTRACE_DISABLE_CALLS = 2,
	FTRACE_UPDATE_TRACE_FUNC = 4,
	FTRACE_START_FUNC_RET = 8,
	FTRACE_STOP_FUNC_RET = 16,
	FTRACE_MAY_SLEEP = 32,
};

enum {
	FTRACE_UPDATE_IGNORE = 0,
	FTRACE_UPDATE_MAKE_CALL = 1,
	FTRACE_UPDATE_MODIFY_CALL = 2,
	FTRACE_UPDATE_MAKE_NOP = 3,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GHES_SEV_NO = 0,
	GHES_SEV_CORRECTED = 1,
	GHES_SEV_RECOVERABLE = 2,
	GHES_SEV_PANIC = 3,
};

enum {
	GPIOLINE_CHANGED_REQUESTED = 1,
	GPIOLINE_CHANGED_RELEASED = 2,
	GPIOLINE_CHANGED_CONFIG = 3,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	GP_LAST = 227,
	PIN_ASEBRK = 228,
	PIN_AVB_MDIO = 229,
	PIN_AVB_RD0 = 230,
	PIN_AVB_RD1 = 231,
	PIN_AVB_RD2 = 232,
	PIN_AVB_RD3 = 233,
	PIN_AVB_RXC = 234,
	PIN_AVB_RX_CTL = 235,
	PIN_AVB_TD0 = 236,
	PIN_AVB_TD1 = 237,
	PIN_AVB_TD2 = 238,
	PIN_AVB_TD3 = 239,
	PIN_AVB_TXC = 240,
	PIN_AVB_TXCREFCLK = 241,
	PIN_AVB_TX_CTL = 242,
	PIN_DU_DOTCLKIN0 = 243,
	PIN_DU_DOTCLKIN1 = 244,
	PIN_DU_DOTCLKIN2 = 245,
	PIN_EXTALR = 246,
	PIN_FSCLKST = 247,
	PIN_MLB_REF = 248,
	PIN_PRESETOUT_N = 249,
	PIN_QSPI0_IO2 = 250,
	PIN_QSPI0_IO3 = 251,
	PIN_QSPI0_MISO_IO1 = 252,
	PIN_QSPI0_MOSI_IO0 = 253,
	PIN_QSPI0_SPCLK = 254,
	PIN_QSPI0_SSL = 255,
	PIN_QSPI1_IO2 = 256,
	PIN_QSPI1_IO3 = 257,
	PIN_QSPI1_MISO_IO1 = 258,
	PIN_QSPI1_MOSI_IO0 = 259,
	PIN_QSPI1_SPCLK = 260,
	PIN_QSPI1_SSL = 261,
	PIN_PRESET_N = 262,
	PIN_RPC_INT_N = 263,
	PIN_RPC_RESET_N = 264,
	PIN_RPC_WP_N = 265,
	PIN_TCK = 266,
	PIN_TDI = 267,
	PIN_TDO = 268,
	PIN_TMS = 269,
	PIN_TRST_N = 270,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HIST_ERR_NONE = 0,
	HIST_ERR_DUPLICATE_VAR = 1,
	HIST_ERR_VAR_NOT_UNIQUE = 2,
	HIST_ERR_TOO_MANY_VARS = 3,
	HIST_ERR_MALFORMED_ASSIGNMENT = 4,
	HIST_ERR_NAMED_MISMATCH = 5,
	HIST_ERR_TRIGGER_EEXIST = 6,
	HIST_ERR_TRIGGER_ENOENT_CLEAR = 7,
	HIST_ERR_SET_CLOCK_FAIL = 8,
	HIST_ERR_BAD_FIELD_MODIFIER = 9,
	HIST_ERR_TOO_MANY_SUBEXPR = 10,
	HIST_ERR_TIMESTAMP_MISMATCH = 11,
	HIST_ERR_TOO_MANY_FIELD_VARS = 12,
	HIST_ERR_EVENT_FILE_NOT_FOUND = 13,
	HIST_ERR_HIST_NOT_FOUND = 14,
	HIST_ERR_HIST_CREATE_FAIL = 15,
	HIST_ERR_SYNTH_VAR_NOT_FOUND = 16,
	HIST_ERR_SYNTH_EVENT_NOT_FOUND = 17,
	HIST_ERR_SYNTH_TYPE_MISMATCH = 18,
	HIST_ERR_SYNTH_COUNT_MISMATCH = 19,
	HIST_ERR_FIELD_VAR_PARSE_FAIL = 20,
	HIST_ERR_VAR_CREATE_FIND_FAIL = 21,
	HIST_ERR_ONX_NOT_VAR = 22,
	HIST_ERR_ONX_VAR_NOT_FOUND = 23,
	HIST_ERR_ONX_VAR_CREATE_FAIL = 24,
	HIST_ERR_FIELD_VAR_CREATE_FAIL = 25,
	HIST_ERR_TOO_MANY_PARAMS = 26,
	HIST_ERR_PARAM_NOT_FOUND = 27,
	HIST_ERR_INVALID_PARAM = 28,
	HIST_ERR_ACTION_NOT_FOUND = 29,
	HIST_ERR_NO_SAVE_PARAMS = 30,
	HIST_ERR_TOO_MANY_SAVE_ACTIONS = 31,
	HIST_ERR_ACTION_MISMATCH = 32,
	HIST_ERR_NO_CLOSING_PAREN = 33,
	HIST_ERR_SUBSYS_NOT_FOUND = 34,
	HIST_ERR_INVALID_SUBSYS_EVENT = 35,
	HIST_ERR_INVALID_REF_KEY = 36,
	HIST_ERR_VAR_NOT_FOUND = 37,
	HIST_ERR_FIELD_NOT_FOUND = 38,
	HIST_ERR_EMPTY_ASSIGNMENT = 39,
	HIST_ERR_INVALID_SORT_MODIFIER = 40,
	HIST_ERR_EMPTY_SORT_FIELD = 41,
	HIST_ERR_TOO_MANY_SORT_FIELDS = 42,
	HIST_ERR_INVALID_SORT_FIELD = 43,
	HIST_ERR_INVALID_STR_OPERAND = 44,
	HIST_ERR_EXPECT_NUMBER = 45,
	HIST_ERR_UNARY_MINUS_SUBEXPR = 46,
	HIST_ERR_DIVISION_BY_ZERO = 47,
	HIST_ERR_NEED_NOHC_VAL = 48,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HMM_NEED_FAULT = 1,
	HMM_NEED_WRITE_FAULT = 2,
	HMM_NEED_ALL_BITS = 3,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HTE_TS_REGISTERED = 0,
	HTE_TS_REQ = 1,
	HTE_TS_DISABLE = 2,
	HTE_TS_QUEUE_WK = 3,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_MCTP_UNSPEC = 0,
	IFLA_MCTP_NET = 1,
	__IFLA_MCTP_MAX = 2,
};

enum {
	IFLA_NETKIT_UNSPEC = 0,
	IFLA_NETKIT_PEER_INFO = 1,
	IFLA_NETKIT_PRIMARY = 2,
	IFLA_NETKIT_POLICY = 3,
	IFLA_NETKIT_PEER_POLICY = 4,
	IFLA_NETKIT_MODE = 5,
	IFLA_NETKIT_SCRUB = 6,
	IFLA_NETKIT_PEER_SCRUB = 7,
	__IFLA_NETKIT_MAX = 8,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	__IFLA_MAX = 66,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_WWAN_UNSPEC = 0,
	IFLA_WWAN_LINK_ID = 1,
	__IFLA_WWAN_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOAM6_IPTUNNEL_UNSPEC = 0,
	IOAM6_IPTUNNEL_MODE = 1,
	IOAM6_IPTUNNEL_DST = 2,
	IOAM6_IPTUNNEL_TRACE = 3,
	IOAM6_IPTUNNEL_FREQ_K = 4,
	IOAM6_IPTUNNEL_FREQ_N = 5,
	IOAM6_IPTUNNEL_SRC = 6,
	__IOAM6_IPTUNNEL_MAX = 7,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_MMAP = 2,
	IOBL_INC = 4,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_REQUEUE = -3072,
	IOU_STOP_MULTISHOT = -125,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_TREE_FS_PINNED_EXTENTS = 0,
	IO_TREE_FS_EXCLUDED_EXTENTS = 1,
	IO_TREE_BTREE_INODE_IO = 2,
	IO_TREE_INODE_IO = 3,
	IO_TREE_RELOC_BLOCKS = 4,
	IO_TREE_TRANS_DIRTY_PAGES = 5,
	IO_TREE_ROOT_DIRTY_LOG_PAGES = 6,
	IO_TREE_INODE_FILE_EXTENT = 7,
	IO_TREE_LOG_CSUM_RANGE = 8,
	IO_TREE_SELFTEST = 9,
	IO_TREE_DEVICE_ALLOC_STATE = 10,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
	IO_WORKER_F_BOUND = 3,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_HOA = 4,
	IPV6_SADDR_RULE_OIF = 5,
	IPV6_SADDR_RULE_LABEL = 6,
	IPV6_SADDR_RULE_PRIVACY = 7,
	IPV6_SADDR_RULE_ORCHID = 8,
	IPV6_SADDR_RULE_PREFIX = 9,
	IPV6_SADDR_RULE_NOT_OPTIMISTIC = 10,
	IPV6_SADDR_RULE_MAX = 11,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_MOVE_PCNTXT = 32768,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_MOVE_PCNTXT = 16384,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KDB_NOT_INITIALIZED = 0,
	KDB_INIT_EARLY = 1,
	KDB_INIT_FULL = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KVM_REG_ARM_STD_BIT_TRNG_V1_0 = 0,
	KVM_REG_ARM_STD_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_STD_HYP_BIT_PV_TIME = 0,
	KVM_REG_ARM_STD_HYP_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_FUNC_FEAT = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_PTP = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_BIT_COUNT = 2,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_BOOT = 30000,
	ATA_TMOUT_BOOT_QUICK = 7000,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_ID_DEV_LOG = 134217728,
	ATA_QUIRK_NO_LOG_DIR = 268435456,
	ATA_QUIRK_NO_FUA = 536870912,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_DELAYEDACKS = 16,
	LINUX_MIB_DELAYEDACKLOCKED = 17,
	LINUX_MIB_DELAYEDACKLOST = 18,
	LINUX_MIB_LISTENOVERFLOWS = 19,
	LINUX_MIB_LISTENDROPS = 20,
	LINUX_MIB_TCPHPHITS = 21,
	LINUX_MIB_TCPPUREACKS = 22,
	LINUX_MIB_TCPHPACKS = 23,
	LINUX_MIB_TCPRENORECOVERY = 24,
	LINUX_MIB_TCPSACKRECOVERY = 25,
	LINUX_MIB_TCPSACKRENEGING = 26,
	LINUX_MIB_TCPSACKREORDER = 27,
	LINUX_MIB_TCPRENOREORDER = 28,
	LINUX_MIB_TCPTSREORDER = 29,
	LINUX_MIB_TCPFULLUNDO = 30,
	LINUX_MIB_TCPPARTIALUNDO = 31,
	LINUX_MIB_TCPDSACKUNDO = 32,
	LINUX_MIB_TCPLOSSUNDO = 33,
	LINUX_MIB_TCPLOSTRETRANSMIT = 34,
	LINUX_MIB_TCPRENOFAILURES = 35,
	LINUX_MIB_TCPSACKFAILURES = 36,
	LINUX_MIB_TCPLOSSFAILURES = 37,
	LINUX_MIB_TCPFASTRETRANS = 38,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 39,
	LINUX_MIB_TCPTIMEOUTS = 40,
	LINUX_MIB_TCPLOSSPROBES = 41,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 42,
	LINUX_MIB_TCPRENORECOVERYFAIL = 43,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 44,
	LINUX_MIB_TCPRCVCOLLAPSED = 45,
	LINUX_MIB_TCPDSACKOLDSENT = 46,
	LINUX_MIB_TCPDSACKOFOSENT = 47,
	LINUX_MIB_TCPDSACKRECV = 48,
	LINUX_MIB_TCPDSACKOFORECV = 49,
	LINUX_MIB_TCPABORTONDATA = 50,
	LINUX_MIB_TCPABORTONCLOSE = 51,
	LINUX_MIB_TCPABORTONMEMORY = 52,
	LINUX_MIB_TCPABORTONTIMEOUT = 53,
	LINUX_MIB_TCPABORTONLINGER = 54,
	LINUX_MIB_TCPABORTFAILED = 55,
	LINUX_MIB_TCPMEMORYPRESSURES = 56,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 57,
	LINUX_MIB_TCPSACKDISCARD = 58,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 59,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 60,
	LINUX_MIB_TCPSPURIOUSRTOS = 61,
	LINUX_MIB_TCPMD5NOTFOUND = 62,
	LINUX_MIB_TCPMD5UNEXPECTED = 63,
	LINUX_MIB_TCPMD5FAILURE = 64,
	LINUX_MIB_SACKSHIFTED = 65,
	LINUX_MIB_SACKMERGED = 66,
	LINUX_MIB_SACKSHIFTFALLBACK = 67,
	LINUX_MIB_TCPBACKLOGDROP = 68,
	LINUX_MIB_PFMEMALLOCDROP = 69,
	LINUX_MIB_TCPMINTTLDROP = 70,
	LINUX_MIB_TCPDEFERACCEPTDROP = 71,
	LINUX_MIB_IPRPFILTER = 72,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 73,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 74,
	LINUX_MIB_TCPREQQFULLDROP = 75,
	LINUX_MIB_TCPRETRANSFAIL = 76,
	LINUX_MIB_TCPRCVCOALESCE = 77,
	LINUX_MIB_TCPBACKLOGCOALESCE = 78,
	LINUX_MIB_TCPOFOQUEUE = 79,
	LINUX_MIB_TCPOFODROP = 80,
	LINUX_MIB_TCPOFOMERGE = 81,
	LINUX_MIB_TCPCHALLENGEACK = 82,
	LINUX_MIB_TCPSYNCHALLENGE = 83,
	LINUX_MIB_TCPFASTOPENACTIVE = 84,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 85,
	LINUX_MIB_TCPFASTOPENPASSIVE = 86,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 87,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 88,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 89,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 90,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 91,
	LINUX_MIB_BUSYPOLLRXPACKETS = 92,
	LINUX_MIB_TCPAUTOCORKING = 93,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 94,
	LINUX_MIB_TCPTOZEROWINDOWADV = 95,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 96,
	LINUX_MIB_TCPSYNRETRANS = 97,
	LINUX_MIB_TCPORIGDATASENT = 98,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 99,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 100,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 101,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 102,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 103,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 104,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 105,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 106,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 107,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 108,
	LINUX_MIB_TCPWINPROBE = 109,
	LINUX_MIB_TCPKEEPALIVE = 110,
	LINUX_MIB_TCPMTUPFAIL = 111,
	LINUX_MIB_TCPMTUPSUCCESS = 112,
	LINUX_MIB_TCPDELIVERED = 113,
	LINUX_MIB_TCPDELIVEREDCE = 114,
	LINUX_MIB_TCPACKCOMPRESSED = 115,
	LINUX_MIB_TCPZEROWINDOWDROP = 116,
	LINUX_MIB_TCPRCVQDROP = 117,
	LINUX_MIB_TCPWQUEUETOOBIG = 118,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 119,
	LINUX_MIB_TCPTIMEOUTREHASH = 120,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 121,
	LINUX_MIB_TCPDSACKRECVSEGS = 122,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 123,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 124,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 125,
	LINUX_MIB_TCPPLBREHASH = 126,
	LINUX_MIB_TCPAOREQUIRED = 127,
	LINUX_MIB_TCPAOBAD = 128,
	LINUX_MIB_TCPAOKEYNOTFOUND = 129,
	LINUX_MIB_TCPAOGOOD = 130,
	LINUX_MIB_TCPAODROPPEDICMPS = 131,
	__LINUX_MIB_MAX = 132,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	__LINUX_MIB_TLSMAX = 13,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	__LINUX_MIB_XFRMMAX = 31,
};

enum {
	LINUX_RAID_PARTITION = 253,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LOG_INODE_ALL = 0,
	LOG_INODE_EXISTS = 1,
};

enum {
	LOG_WALK_PIN_ONLY = 0,
	LOG_WALK_REPLAY_INODES = 1,
	LOG_WALK_REPLAY_DIR_INDEX = 2,
	LOG_WALK_REPLAY_ALL = 3,
};

enum {
	LRU_GEN_ANON = 0,
	LRU_GEN_FILE = 1,
};

enum {
	LRU_GEN_CORE = 0,
	LRU_GEN_MM_WALK = 1,
	LRU_GEN_NONLEAF_YOUNG = 2,
	NR_LRU_GEN_CAPS = 3,
};

enum {
	LSB = 0,
	CSB = 1,
	MSB = 2,
};

enum {
	LTSSM_DETECT_QUIET = 0,
	LTSSM_DETECT_ACTIVE = 1,
	LTSSM_POLLING_ACTIVE = 2,
	LTSSM_POLLING_COMPLIANCE = 3,
	LTSSM_POLLING_CONFIGURATION = 4,
	LTSSM_CONFIG_LINKWIDTH_START = 5,
	LTSSM_CONFIG_LINKWIDTH_ACCEPT = 6,
	LTSSM_CONFIG_LANENUM_ACCEPT = 7,
	LTSSM_CONFIG_LANENUM_WAIT = 8,
	LTSSM_CONFIG_COMPLETE = 9,
	LTSSM_CONFIG_IDLE = 10,
	LTSSM_RECOVERY_RCVR_LOCK = 11,
	LTSSM_RECOVERY_SPEED = 12,
	LTSSM_RECOVERY_RCVR_CFG = 13,
	LTSSM_RECOVERY_IDLE = 14,
	LTSSM_L0 = 16,
	LTSSM_RX_L0S_ENTRY = 17,
	LTSSM_RX_L0S_IDLE = 18,
	LTSSM_RX_L0S_FTS = 19,
	LTSSM_TX_L0S_ENTRY = 20,
	LTSSM_TX_L0S_IDLE = 21,
	LTSSM_TX_L0S_FTS = 22,
	LTSSM_L1_ENTRY = 23,
	LTSSM_L1_IDLE = 24,
	LTSSM_L2_IDLE = 25,
	LTSSM_L2_TRANSMIT_WAKE = 26,
	LTSSM_DISABLED = 32,
	LTSSM_LOOPBACK_ENTRY_MASTER = 33,
	LTSSM_LOOPBACK_ACTIVE_MASTER = 34,
	LTSSM_LOOPBACK_EXIT_MASTER = 35,
	LTSSM_LOOPBACK_ENTRY_SLAVE = 36,
	LTSSM_LOOPBACK_ACTIVE_SLAVE = 37,
	LTSSM_LOOPBACK_EXIT_SLAVE = 38,
	LTSSM_HOT_RESET = 39,
	LTSSM_RECOVERY_EQUALIZATION_PHASE0 = 40,
	LTSSM_RECOVERY_EQUALIZATION_PHASE1 = 41,
	LTSSM_RECOVERY_EQUALIZATION_PHASE2 = 42,
	LTSSM_RECOVERY_EQUALIZATION_PHASE3 = 43,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	LWT_BPF_PROG_UNSPEC = 0,
	LWT_BPF_PROG_FD = 1,
	LWT_BPF_PROG_NAME = 2,
	__LWT_BPF_PROG_MAX = 3,
};

enum {
	LWT_BPF_UNSPEC = 0,
	LWT_BPF_IN = 1,
	LWT_BPF_OUT = 2,
	LWT_BPF_XMIT = 3,
	LWT_BPF_XMIT_HEADROOM = 4,
	__LWT_BPF_MAX = 5,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX77620_GPIO0 = 0,
	MAX77620_GPIO1 = 1,
	MAX77620_GPIO2 = 2,
	MAX77620_GPIO3 = 3,
	MAX77620_GPIO4 = 4,
	MAX77620_GPIO5 = 5,
	MAX77620_GPIO6 = 6,
	MAX77620_GPIO7 = 7,
	MAX77620_GPIO_NR = 8,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAXIMUM_TEST_BUFFER_LEN = 4096,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCTP_TRACE_KEY_TIMEOUT = 0,
	MCTP_TRACE_KEY_REPLIED = 1,
	MCTP_TRACE_KEY_INVALIDATED = 2,
	MCTP_TRACE_KEY_CLOSED = 3,
	MCTP_TRACE_KEY_DROPPED = 4,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MD_RESYNC_NONE = 0,
	MD_RESYNC_YIELDED = 1,
	MD_RESYNC_DELAYED = 2,
	MD_RESYNC_ACTIVE = 3,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMCG_LRU_NOP = 0,
	MEMCG_LRU_HEAD = 1,
	MEMCG_LRU_TAIL = 2,
	MEMCG_LRU_OLD = 3,
	MEMCG_LRU_YOUNG = 4,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_NULL = 1,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLX_MC_RBT_SUPPORT = 1,
	MLX_MC_RBT_AVL = 8,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MM_LEAF_TOTAL = 0,
	MM_LEAF_YOUNG = 1,
	MM_NONLEAF_FOUND = 2,
	MM_NONLEAF_ADDED = 3,
	NR_MM_STATS = 4,
};

enum {
	MODE_NONE = 0,
	MODE_ROUND_ROBIN = 1,
	MODE_PER_CPU = 2,
	MODE_MAX = 3,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
};

enum {
	MTTG_TRAV_INIT = 0,
	MTTG_TRAV_NFP_UNSPEC = 1,
	MTTG_TRAV_NFP_SPEC = 2,
	MTTG_TRAV_DONE = 3,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAMESZ = 12,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum {
	NCSI_CAP_BASE = 0,
	NCSI_CAP_GENERIC = 0,
	NCSI_CAP_BC = 1,
	NCSI_CAP_MC = 2,
	NCSI_CAP_BUFFER = 3,
	NCSI_CAP_AEN = 4,
	NCSI_CAP_VLAN = 5,
	NCSI_CAP_MAX = 6,
};

enum {
	NCSI_CAP_GENERIC_HWA = 1,
	NCSI_CAP_GENERIC_HDS = 2,
	NCSI_CAP_GENERIC_FC = 4,
	NCSI_CAP_GENERIC_FC1 = 8,
	NCSI_CAP_GENERIC_MC = 16,
	NCSI_CAP_GENERIC_HWA_UNKNOWN = 0,
	NCSI_CAP_GENERIC_HWA_SUPPORT = 32,
	NCSI_CAP_GENERIC_HWA_NOT_SUPPORT = 64,
	NCSI_CAP_GENERIC_HWA_RESERVED = 96,
	NCSI_CAP_GENERIC_HWA_MASK = 96,
	NCSI_CAP_GENERIC_MASK = 127,
	NCSI_CAP_BC_ARP = 1,
	NCSI_CAP_BC_DHCPC = 2,
	NCSI_CAP_BC_DHCPS = 4,
	NCSI_CAP_BC_NETBIOS = 8,
	NCSI_CAP_BC_MASK = 15,
	NCSI_CAP_MC_IPV6_NEIGHBOR = 1,
	NCSI_CAP_MC_IPV6_ROUTER = 2,
	NCSI_CAP_MC_DHCPV6_RELAY = 4,
	NCSI_CAP_MC_DHCPV6_WELL_KNOWN = 8,
	NCSI_CAP_MC_IPV6_MLD = 16,
	NCSI_CAP_MC_IPV6_NEIGHBOR_S = 32,
	NCSI_CAP_MC_MASK = 63,
	NCSI_CAP_AEN_LSC = 1,
	NCSI_CAP_AEN_CR = 2,
	NCSI_CAP_AEN_HDS = 4,
	NCSI_CAP_AEN_MASK = 7,
	NCSI_CAP_VLAN_ONLY = 1,
	NCSI_CAP_VLAN_NO = 2,
	NCSI_CAP_VLAN_ANY = 4,
	NCSI_CAP_VLAN_MASK = 7,
};

enum {
	NCSI_MODE_BASE = 0,
	NCSI_MODE_ENABLE = 0,
	NCSI_MODE_TX_ENABLE = 1,
	NCSI_MODE_LINK = 2,
	NCSI_MODE_VLAN = 3,
	NCSI_MODE_BC = 4,
	NCSI_MODE_MC = 5,
	NCSI_MODE_AEN = 6,
	NCSI_MODE_FC = 7,
	NCSI_MODE_MAX = 8,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_DN_TABLE = 2,
	NEIGH_NR_TABLES = 3,
	NEIGH_LINK_TABLE = 3,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	__NETDEV_A_NAPI_MAX = 5,
	NETDEV_A_NAPI_MAX = 4,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	__NETDEV_A_PAGE_POOL_MAX = 8,
	NETDEV_A_PAGE_POOL_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	__NETDEV_A_QUEUE_MAX = 6,
	NETDEV_A_QUEUE_MAX = 5,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	__NETDEV_CMD_MAX = 14,
	NETDEV_CMD_MAX = 13,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	__UNUSED_NETIF_F_37 = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_DIAG_MEMINFO = 0,
	NETLINK_DIAG_GROUPS = 1,
	NETLINK_DIAG_RX_RING = 2,
	NETLINK_DIAG_TX_RING = 3,
	NETLINK_DIAG_FLAGS = 4,
	__NETLINK_DIAG_MAX = 5,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_DM_ATTR_PORT_NETDEV_IFINDEX = 0,
	NET_DM_ATTR_PORT_NETDEV_NAME = 1,
	__NET_DM_ATTR_PORT_MAX = 2,
	NET_DM_ATTR_PORT_MAX = 1,
};

enum {
	NET_DM_ATTR_STATS_DROPPED = 0,
	__NET_DM_ATTR_STATS_MAX = 1,
	NET_DM_ATTR_STATS_MAX = 0,
};

enum {
	NET_DM_CMD_UNSPEC = 0,
	NET_DM_CMD_ALERT = 1,
	NET_DM_CMD_CONFIG = 2,
	NET_DM_CMD_START = 3,
	NET_DM_CMD_STOP = 4,
	NET_DM_CMD_PACKET_ALERT = 5,
	NET_DM_CMD_CONFIG_GET = 6,
	NET_DM_CMD_CONFIG_NEW = 7,
	NET_DM_CMD_STATS_GET = 8,
	NET_DM_CMD_STATS_NEW = 9,
	_NET_DM_CMD_MAX = 10,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLBL_CALIPSO_A_UNSPEC = 0,
	NLBL_CALIPSO_A_DOI = 1,
	NLBL_CALIPSO_A_MTYPE = 2,
	__NLBL_CALIPSO_A_MAX = 3,
};

enum {
	NLBL_CALIPSO_C_UNSPEC = 0,
	NLBL_CALIPSO_C_ADD = 1,
	NLBL_CALIPSO_C_REMOVE = 2,
	NLBL_CALIPSO_C_LIST = 3,
	NLBL_CALIPSO_C_LISTALL = 4,
	__NLBL_CALIPSO_C_MAX = 5,
};

enum {
	NLBL_CIPSOV4_A_UNSPEC = 0,
	NLBL_CIPSOV4_A_DOI = 1,
	NLBL_CIPSOV4_A_MTYPE = 2,
	NLBL_CIPSOV4_A_TAG = 3,
	NLBL_CIPSOV4_A_TAGLST = 4,
	NLBL_CIPSOV4_A_MLSLVLLOC = 5,
	NLBL_CIPSOV4_A_MLSLVLREM = 6,
	NLBL_CIPSOV4_A_MLSLVL = 7,
	NLBL_CIPSOV4_A_MLSLVLLST = 8,
	NLBL_CIPSOV4_A_MLSCATLOC = 9,
	NLBL_CIPSOV4_A_MLSCATREM = 10,
	NLBL_CIPSOV4_A_MLSCAT = 11,
	NLBL_CIPSOV4_A_MLSCATLST = 12,
	__NLBL_CIPSOV4_A_MAX = 13,
};

enum {
	NLBL_CIPSOV4_C_UNSPEC = 0,
	NLBL_CIPSOV4_C_ADD = 1,
	NLBL_CIPSOV4_C_REMOVE = 2,
	NLBL_CIPSOV4_C_LIST = 3,
	NLBL_CIPSOV4_C_LISTALL = 4,
	__NLBL_CIPSOV4_C_MAX = 5,
};

enum {
	NLBL_MGMT_A_UNSPEC = 0,
	NLBL_MGMT_A_DOMAIN = 1,
	NLBL_MGMT_A_PROTOCOL = 2,
	NLBL_MGMT_A_VERSION = 3,
	NLBL_MGMT_A_CV4DOI = 4,
	NLBL_MGMT_A_IPV6ADDR = 5,
	NLBL_MGMT_A_IPV6MASK = 6,
	NLBL_MGMT_A_IPV4ADDR = 7,
	NLBL_MGMT_A_IPV4MASK = 8,
	NLBL_MGMT_A_ADDRSELECTOR = 9,
	NLBL_MGMT_A_SELECTORLIST = 10,
	NLBL_MGMT_A_FAMILY = 11,
	NLBL_MGMT_A_CLPDOI = 12,
	__NLBL_MGMT_A_MAX = 13,
};

enum {
	NLBL_MGMT_C_UNSPEC = 0,
	NLBL_MGMT_C_ADD = 1,
	NLBL_MGMT_C_REMOVE = 2,
	NLBL_MGMT_C_LISTALL = 3,
	NLBL_MGMT_C_ADDDEF = 4,
	NLBL_MGMT_C_REMOVEDEF = 5,
	NLBL_MGMT_C_LISTDEF = 6,
	NLBL_MGMT_C_PROTOCOLS = 7,
	NLBL_MGMT_C_VERSION = 8,
	__NLBL_MGMT_C_MAX = 9,
};

enum {
	NLBL_UNLABEL_A_UNSPEC = 0,
	NLBL_UNLABEL_A_ACPTFLG = 1,
	NLBL_UNLABEL_A_IPV6ADDR = 2,
	NLBL_UNLABEL_A_IPV6MASK = 3,
	NLBL_UNLABEL_A_IPV4ADDR = 4,
	NLBL_UNLABEL_A_IPV4MASK = 5,
	NLBL_UNLABEL_A_IFACE = 6,
	NLBL_UNLABEL_A_SECCTX = 7,
	__NLBL_UNLABEL_A_MAX = 8,
};

enum {
	NLBL_UNLABEL_C_UNSPEC = 0,
	NLBL_UNLABEL_C_ACCEPT = 1,
	NLBL_UNLABEL_C_LIST = 2,
	NLBL_UNLABEL_C_STATICADD = 3,
	NLBL_UNLABEL_C_STATICREMOVE = 4,
	NLBL_UNLABEL_C_STATICLIST = 5,
	NLBL_UNLABEL_C_STATICADDDEF = 6,
	NLBL_UNLABEL_C_STATICREMOVEDEF = 7,
	NLBL_UNLABEL_C_STATICLISTDEF = 8,
	__NLBL_UNLABEL_C_MAX = 9,
};

enum {
	NODE_ACCESS_CLASS_GENPORT_SINK_LOCAL = 2,
	NODE_ACCESS_CLASS_GENPORT_SINK_CPU = 3,
	NODE_ACCESS_CLASS_MAX = 4,
};

enum {
	NORTH = 0,
	SOUTH = 1,
	WEST = 2,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 66,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OUTSIDE_GUEST_MODE = 0,
	IN_GUEST_MODE = 1,
	EXITING_GUEST_MODE = 2,
	READING_SHADOW_PAGE_TABLES = 3,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_acl = 0,
	Opt_clear_cache = 1,
	Opt_commit_interval = 2,
	Opt_compress = 3,
	Opt_compress_force = 4,
	Opt_compress_force_type = 5,
	Opt_compress_type = 6,
	Opt_degraded = 7,
	Opt_device = 8,
	Opt_fatal_errors = 9,
	Opt_flushoncommit = 10,
	Opt_max_inline = 11,
	Opt_barrier = 12,
	Opt_datacow = 13,
	Opt_datasum = 14,
	Opt_defrag = 15,
	Opt_discard = 16,
	Opt_discard_mode = 17,
	Opt_ratio = 18,
	Opt_rescan_uuid_tree = 19,
	Opt_skip_balance = 20,
	Opt_space_cache = 21,
	Opt_space_cache_version = 22,
	Opt_ssd = 23,
	Opt_ssd_spread = 24,
	Opt_subvol = 25,
	Opt_subvol_empty = 26,
	Opt_subvolid = 27,
	Opt_thread_pool = 28,
	Opt_treelog = 29,
	Opt_user_subvol_rm_allowed = 30,
	Opt_norecovery = 31,
	Opt_rescue = 32,
	Opt_usebackuproot = 33,
	Opt_nologreplay = 34,
	Opt_enospc_debug = 35,
	Opt_err = 36,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl___2 = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier___2 = 34,
	Opt_nobarrier = 35,
	Opt_err___2 = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard___2 = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_default = 0,
	Opt_ecryptfs = 1,
	Opt_enc32 = 2,
	Opt_error = 3,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid = 10,
};

enum {
	Opt_discard_sync = 0,
	Opt_discard_async = 1,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_err___4 = 0,
	Opt_new = 1,
	Opt_load = 2,
	Opt_update = 3,
};

enum {
	Opt_err___5 = 0,
	Opt_keyhandle = 1,
	Opt_keyauth = 2,
	Opt_blobauth = 3,
	Opt_pcrinfo = 4,
	Opt_pcrlock = 5,
	Opt_migratable = 6,
	Opt_hash___2 = 7,
	Opt_policydigest = 8,
	Opt_policyhandle = 9,
};

enum {
	Opt_error___2 = -1,
	Opt_context = 0,
	Opt_defcontext = 1,
	Opt_fscontext = 2,
	Opt_rootcontext = 3,
	Opt_seclabel = 4,
};

enum {
	Opt_fatal_errors_panic = 0,
	Opt_fatal_errors_bug = 1,
};

enum {
	Opt_kmsg_bytes = 0,
	Opt_err___6 = 1,
};

enum {
	Opt_new___2 = 0,
	Opt_load___2 = 1,
	Opt_update___2 = 2,
	Opt_err___7 = 3,
};

enum {
	Opt_rescue_usebackuproot = 0,
	Opt_rescue_nologreplay = 1,
	Opt_rescue_ignorebadroots = 2,
	Opt_rescue_ignoredatacsums = 3,
	Opt_rescue_ignoremetacsums = 4,
	Opt_rescue_ignoresuperflags = 5,
	Opt_rescue_parameter_all = 6,
};

enum {
	Opt_space_cache_v1 = 0,
	Opt_space_cache_v2 = 1,
};

enum {
	Opt_uid___2 = 0,
	Opt_gid___2 = 1,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___8 = 6,
};

enum {
	PACKET_DIAG_INFO = 0,
	PACKET_DIAG_MCLIST = 1,
	PACKET_DIAG_RX_RING = 2,
	PACKET_DIAG_TX_RING = 3,
	PACKET_DIAG_FANOUT = 4,
	PACKET_DIAG_UID = 5,
	PACKET_DIAG_MEMINFO = 6,
	PACKET_DIAG_FILTER = 7,
	__PACKET_DIAG_MAX = 8,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PCI_BRIDGE_EMUL_NO_PREFMEM_FORWARD = 1,
	PCI_BRIDGE_EMUL_NO_IO_FORWARD = 2,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_FC_LEVEL = 0,
	PERF_FC_LIMIT = 1,
	PERF_FC_MAX = 2,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PIIX_IOCFG = 84,
	ICH5_PMR = 144,
	ICH5_PCS = 146,
	PIIX_SIDPR_BAR = 5,
	PIIX_SIDPR_LEN = 16,
	PIIX_SIDPR_IDX = 0,
	PIIX_SIDPR_DATA = 4,
	PIIX_FLAG_CHECKINTR = 268435456,
	PIIX_FLAG_SIDPR = 536870912,
	PIIX_PATA_FLAGS = 1,
	PIIX_SATA_FLAGS = 268435458,
	PIIX_FLAG_PIO16 = 1073741824,
	PIIX_80C_PRI = 48,
	PIIX_80C_SEC = 192,
	P0 = 0,
	P1 = 1,
	P2 = 2,
	P3 = 3,
	IDE = -1,
	NA = -2,
	RV = -3,
	PIIX_AHCI_DEVICE = 6,
	PIIX_HOST_BROKEN_SUSPEND = 16777216,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PINMUX_RESERVED = 0,
	PINMUX_DATA_BEGIN = 1,
	GP_0_0_DATA = 2,
	GP_0_1_DATA = 3,
	GP_0_2_DATA = 4,
	GP_0_3_DATA = 5,
	GP_0_4_DATA = 6,
	GP_0_5_DATA = 7,
	GP_0_6_DATA = 8,
	GP_0_7_DATA = 9,
	GP_0_8_DATA = 10,
	GP_0_9_DATA = 11,
	GP_0_10_DATA = 12,
	GP_0_11_DATA = 13,
	GP_0_12_DATA = 14,
	GP_0_13_DATA = 15,
	GP_0_14_DATA = 16,
	GP_0_15_DATA = 17,
	GP_1_0_DATA = 18,
	GP_1_1_DATA = 19,
	GP_1_2_DATA = 20,
	GP_1_3_DATA = 21,
	GP_1_4_DATA = 22,
	GP_1_5_DATA = 23,
	GP_1_6_DATA = 24,
	GP_1_7_DATA = 25,
	GP_1_8_DATA = 26,
	GP_1_9_DATA = 27,
	GP_1_10_DATA = 28,
	GP_1_11_DATA = 29,
	GP_1_12_DATA = 30,
	GP_1_13_DATA = 31,
	GP_1_14_DATA = 32,
	GP_1_15_DATA = 33,
	GP_1_16_DATA = 34,
	GP_1_17_DATA = 35,
	GP_1_18_DATA = 36,
	GP_1_19_DATA = 37,
	GP_1_20_DATA = 38,
	GP_1_21_DATA = 39,
	GP_1_22_DATA = 40,
	GP_1_23_DATA = 41,
	GP_1_24_DATA = 42,
	GP_1_25_DATA = 43,
	GP_1_26_DATA = 44,
	GP_1_27_DATA = 45,
	GP_1_28_DATA = 46,
	GP_2_0_DATA = 47,
	GP_2_1_DATA = 48,
	GP_2_2_DATA = 49,
	GP_2_3_DATA = 50,
	GP_2_4_DATA = 51,
	GP_2_5_DATA = 52,
	GP_2_6_DATA = 53,
	GP_2_7_DATA = 54,
	GP_2_8_DATA = 55,
	GP_2_9_DATA = 56,
	GP_2_10_DATA = 57,
	GP_2_11_DATA = 58,
	GP_2_12_DATA = 59,
	GP_2_13_DATA = 60,
	GP_2_14_DATA = 61,
	GP_3_0_DATA = 62,
	GP_3_1_DATA = 63,
	GP_3_2_DATA = 64,
	GP_3_3_DATA = 65,
	GP_3_4_DATA = 66,
	GP_3_5_DATA = 67,
	GP_3_6_DATA = 68,
	GP_3_7_DATA = 69,
	GP_3_8_DATA = 70,
	GP_3_9_DATA = 71,
	GP_3_10_DATA = 72,
	GP_3_11_DATA = 73,
	GP_3_12_DATA = 74,
	GP_3_13_DATA = 75,
	GP_3_14_DATA = 76,
	GP_3_15_DATA = 77,
	GP_4_0_DATA = 78,
	GP_4_1_DATA = 79,
	GP_4_2_DATA = 80,
	GP_4_3_DATA = 81,
	GP_4_4_DATA = 82,
	GP_4_5_DATA = 83,
	GP_4_6_DATA = 84,
	GP_4_7_DATA = 85,
	GP_4_8_DATA = 86,
	GP_4_9_DATA = 87,
	GP_4_10_DATA = 88,
	GP_4_11_DATA = 89,
	GP_4_12_DATA = 90,
	GP_4_13_DATA = 91,
	GP_4_14_DATA = 92,
	GP_4_15_DATA = 93,
	GP_4_16_DATA = 94,
	GP_4_17_DATA = 95,
	GP_5_0_DATA = 96,
	GP_5_1_DATA = 97,
	GP_5_2_DATA = 98,
	GP_5_3_DATA = 99,
	GP_5_4_DATA = 100,
	GP_5_5_DATA = 101,
	GP_5_6_DATA = 102,
	GP_5_7_DATA = 103,
	GP_5_8_DATA = 104,
	GP_5_9_DATA = 105,
	GP_5_10_DATA = 106,
	GP_5_11_DATA = 107,
	GP_5_12_DATA = 108,
	GP_5_13_DATA = 109,
	GP_5_14_DATA = 110,
	GP_5_15_DATA = 111,
	GP_5_16_DATA = 112,
	GP_5_17_DATA = 113,
	GP_5_18_DATA = 114,
	GP_5_19_DATA = 115,
	GP_5_20_DATA = 116,
	GP_5_21_DATA = 117,
	GP_5_22_DATA = 118,
	GP_5_23_DATA = 119,
	GP_5_24_DATA = 120,
	GP_5_25_DATA = 121,
	GP_6_0_DATA = 122,
	GP_6_1_DATA = 123,
	GP_6_2_DATA = 124,
	GP_6_3_DATA = 125,
	GP_6_4_DATA = 126,
	GP_6_5_DATA = 127,
	GP_6_6_DATA = 128,
	GP_6_7_DATA = 129,
	GP_6_8_DATA = 130,
	GP_6_9_DATA = 131,
	GP_6_10_DATA = 132,
	GP_6_11_DATA = 133,
	GP_6_12_DATA = 134,
	GP_6_13_DATA = 135,
	GP_6_14_DATA = 136,
	GP_6_15_DATA = 137,
	GP_6_16_DATA = 138,
	GP_6_17_DATA = 139,
	GP_6_18_DATA = 140,
	GP_6_19_DATA = 141,
	GP_6_20_DATA = 142,
	GP_6_21_DATA = 143,
	GP_6_22_DATA = 144,
	GP_6_23_DATA = 145,
	GP_6_24_DATA = 146,
	GP_6_25_DATA = 147,
	GP_6_26_DATA = 148,
	GP_6_27_DATA = 149,
	GP_6_28_DATA = 150,
	GP_6_29_DATA = 151,
	GP_6_30_DATA = 152,
	GP_6_31_DATA = 153,
	GP_7_0_DATA = 154,
	GP_7_1_DATA = 155,
	GP_7_2_DATA = 156,
	GP_7_3_DATA = 157,
	PINMUX_DATA_END = 158,
	PINMUX_FUNCTION_BEGIN = 159,
	GP_0_0_FN = 160,
	GP_0_1_FN = 161,
	GP_0_2_FN = 162,
	GP_0_3_FN = 163,
	GP_0_4_FN = 164,
	GP_0_5_FN = 165,
	GP_0_6_FN = 166,
	GP_0_7_FN = 167,
	GP_0_8_FN = 168,
	GP_0_9_FN = 169,
	GP_0_10_FN = 170,
	GP_0_11_FN = 171,
	GP_0_12_FN = 172,
	GP_0_13_FN = 173,
	GP_0_14_FN = 174,
	GP_0_15_FN = 175,
	GP_1_0_FN = 176,
	GP_1_1_FN = 177,
	GP_1_2_FN = 178,
	GP_1_3_FN = 179,
	GP_1_4_FN = 180,
	GP_1_5_FN = 181,
	GP_1_6_FN = 182,
	GP_1_7_FN = 183,
	GP_1_8_FN = 184,
	GP_1_9_FN = 185,
	GP_1_10_FN = 186,
	GP_1_11_FN = 187,
	GP_1_12_FN = 188,
	GP_1_13_FN = 189,
	GP_1_14_FN = 190,
	GP_1_15_FN = 191,
	GP_1_16_FN = 192,
	GP_1_17_FN = 193,
	GP_1_18_FN = 194,
	GP_1_19_FN = 195,
	GP_1_20_FN = 196,
	GP_1_21_FN = 197,
	GP_1_22_FN = 198,
	GP_1_23_FN = 199,
	GP_1_24_FN = 200,
	GP_1_25_FN = 201,
	GP_1_26_FN = 202,
	GP_1_27_FN = 203,
	GP_1_28_FN = 204,
	GP_2_0_FN = 205,
	GP_2_1_FN = 206,
	GP_2_2_FN = 207,
	GP_2_3_FN = 208,
	GP_2_4_FN = 209,
	GP_2_5_FN = 210,
	GP_2_6_FN = 211,
	GP_2_7_FN = 212,
	GP_2_8_FN = 213,
	GP_2_9_FN = 214,
	GP_2_10_FN = 215,
	GP_2_11_FN = 216,
	GP_2_12_FN = 217,
	GP_2_13_FN = 218,
	GP_2_14_FN = 219,
	GP_3_0_FN = 220,
	GP_3_1_FN = 221,
	GP_3_2_FN = 222,
	GP_3_3_FN = 223,
	GP_3_4_FN = 224,
	GP_3_5_FN = 225,
	GP_3_6_FN = 226,
	GP_3_7_FN = 227,
	GP_3_8_FN = 228,
	GP_3_9_FN = 229,
	GP_3_10_FN = 230,
	GP_3_11_FN = 231,
	GP_3_12_FN = 232,
	GP_3_13_FN = 233,
	GP_3_14_FN = 234,
	GP_3_15_FN = 235,
	GP_4_0_FN = 236,
	GP_4_1_FN = 237,
	GP_4_2_FN = 238,
	GP_4_3_FN = 239,
	GP_4_4_FN = 240,
	GP_4_5_FN = 241,
	GP_4_6_FN = 242,
	GP_4_7_FN = 243,
	GP_4_8_FN = 244,
	GP_4_9_FN = 245,
	GP_4_10_FN = 246,
	GP_4_11_FN = 247,
	GP_4_12_FN = 248,
	GP_4_13_FN = 249,
	GP_4_14_FN = 250,
	GP_4_15_FN = 251,
	GP_4_16_FN = 252,
	GP_4_17_FN = 253,
	GP_5_0_FN = 254,
	GP_5_1_FN = 255,
	GP_5_2_FN = 256,
	GP_5_3_FN = 257,
	GP_5_4_FN = 258,
	GP_5_5_FN = 259,
	GP_5_6_FN = 260,
	GP_5_7_FN = 261,
	GP_5_8_FN = 262,
	GP_5_9_FN = 263,
	GP_5_10_FN = 264,
	GP_5_11_FN = 265,
	GP_5_12_FN = 266,
	GP_5_13_FN = 267,
	GP_5_14_FN = 268,
	GP_5_15_FN = 269,
	GP_5_16_FN = 270,
	GP_5_17_FN = 271,
	GP_5_18_FN = 272,
	GP_5_19_FN = 273,
	GP_5_20_FN = 274,
	GP_5_21_FN = 275,
	GP_5_22_FN = 276,
	GP_5_23_FN = 277,
	GP_5_24_FN = 278,
	GP_5_25_FN = 279,
	GP_6_0_FN = 280,
	GP_6_1_FN = 281,
	GP_6_2_FN = 282,
	GP_6_3_FN = 283,
	GP_6_4_FN = 284,
	GP_6_5_FN = 285,
	GP_6_6_FN = 286,
	GP_6_7_FN = 287,
	GP_6_8_FN = 288,
	GP_6_9_FN = 289,
	GP_6_10_FN = 290,
	GP_6_11_FN = 291,
	GP_6_12_FN = 292,
	GP_6_13_FN = 293,
	GP_6_14_FN = 294,
	GP_6_15_FN = 295,
	GP_6_16_FN = 296,
	GP_6_17_FN = 297,
	GP_6_18_FN = 298,
	GP_6_19_FN = 299,
	GP_6_20_FN = 300,
	GP_6_21_FN = 301,
	GP_6_22_FN = 302,
	GP_6_23_FN = 303,
	GP_6_24_FN = 304,
	GP_6_25_FN = 305,
	GP_6_26_FN = 306,
	GP_6_27_FN = 307,
	GP_6_28_FN = 308,
	GP_6_29_FN = 309,
	GP_6_30_FN = 310,
	GP_6_31_FN = 311,
	GP_7_0_FN = 312,
	GP_7_1_FN = 313,
	GP_7_2_FN = 314,
	GP_7_3_FN = 315,
	FN_CLKOUT = 316,
	FN_MSIOF0_RXD = 317,
	FN_MSIOF0_TXD = 318,
	FN_MSIOF0_SCK = 319,
	FN_SSI_SDATA5 = 320,
	FN_SSI_WS5 = 321,
	FN_SSI_SCK5 = 322,
	FN_GP7_03 = 323,
	FN_GP7_02 = 324,
	FN_AVS2 = 325,
	FN_AVS1 = 326,
	FN_IP0_3_0 = 327,
	FN_AVB_MDC = 328,
	FN_MSIOF2_SS2_C = 329,
	FN_IP1_3_0 = 330,
	FN_IRQ2 = 331,
	FN_QCPV_QDE = 332,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE = 333,
	FN_VI4_DATA2_B = 334,
	FN_MSIOF3_SYNC_E = 335,
	FN_PWM3_B = 336,
	FN_IP2_3_0 = 337,
	FN_A1 = 338,
	FN_LCDOUT17 = 339,
	FN_MSIOF3_TXD_B = 340,
	FN_VI4_DATA9 = 341,
	FN_DU_DB1 = 342,
	FN_PWM4_A = 343,
	FN_IP3_3_0 = 344,
	FN_A9 = 345,
	FN_MSIOF2_SCK_A = 346,
	FN_CTS4_N_B = 347,
	FN_VI5_VSYNC_N = 348,
	FN_IP0_7_4 = 349,
	FN_AVB_MAGIC = 350,
	FN_MSIOF2_SS1_C = 351,
	FN_SCK4_A = 352,
	FN_IP1_7_4 = 353,
	FN_IRQ3 = 354,
	FN_QSTVB_QVE = 355,
	FN_DU_DOTCLKOUT1 = 356,
	FN_VI4_DATA3_B = 357,
	FN_MSIOF3_SCK_E = 358,
	FN_PWM4_B = 359,
	FN_IP2_7_4 = 360,
	FN_A2 = 361,
	FN_LCDOUT18 = 362,
	FN_MSIOF3_SCK_B = 363,
	FN_VI4_DATA10 = 364,
	FN_DU_DB2 = 365,
	FN_PWM5_A = 366,
	FN_IP3_7_4 = 367,
	FN_A10 = 368,
	FN_MSIOF2_RXD_A = 369,
	FN_RTS4_N_B = 370,
	FN_VI5_HSYNC_N = 371,
	FN_IP0_11_8 = 372,
	FN_AVB_PHY_INT = 373,
	FN_MSIOF2_SYNC_C = 374,
	FN_RX4_A = 375,
	FN_IP1_11_8 = 376,
	FN_IRQ4 = 377,
	FN_QSTH_QHS = 378,
	FN_DU_EXHSYNC_DU_HSYNC = 379,
	FN_VI4_DATA4_B = 380,
	FN_MSIOF3_RXD_E = 381,
	FN_PWM5_B = 382,
	FN_IP2_11_8 = 383,
	FN_A3 = 384,
	FN_LCDOUT19 = 385,
	FN_MSIOF3_RXD_B = 386,
	FN_VI4_DATA11 = 387,
	FN_DU_DB3 = 388,
	FN_PWM6_A = 389,
	FN_IP3_11_8 = 390,
	FN_A11 = 391,
	FN_TX3_B = 392,
	FN_MSIOF2_TXD_A = 393,
	FN_HTX4_B = 394,
	FN_HSCK4 = 395,
	FN_VI5_FIELD = 396,
	FN_SCL6_A = 397,
	FN_AVB_AVTP_CAPTURE_B = 398,
	FN_PWM2_B = 399,
	FN_IP0_15_12 = 400,
	FN_AVB_LINK = 401,
	FN_MSIOF2_SCK_C = 402,
	FN_TX4_A = 403,
	FN_IP1_15_12 = 404,
	FN_IRQ5 = 405,
	FN_QSTB_QHE = 406,
	FN_DU_EXVSYNC_DU_VSYNC = 407,
	FN_VI4_DATA5_B = 408,
	FN_MSIOF3_TXD_E = 409,
	FN_PWM6_B = 410,
	FN_IP2_15_12 = 411,
	FN_A4 = 412,
	FN_LCDOUT20 = 413,
	FN_MSIOF3_SS1_B = 414,
	FN_VI4_DATA12 = 415,
	FN_VI5_DATA12 = 416,
	FN_DU_DB4 = 417,
	FN_IP3_15_12 = 418,
	FN_A12 = 419,
	FN_LCDOUT12 = 420,
	FN_MSIOF3_SCK_C = 421,
	FN_HRX4_A = 422,
	FN_VI5_DATA8 = 423,
	FN_DU_DG4 = 424,
	FN_IP0_19_16 = 425,
	FN_AVB_AVTP_MATCH_A = 426,
	FN_MSIOF2_RXD_C = 427,
	FN_CTS4_N_A = 428,
	FN_IP1_19_16 = 429,
	FN_PWM0 = 430,
	FN_AVB_AVTP_PPS = 431,
	FN_VI4_DATA6_B = 432,
	FN_IECLK_B = 433,
	FN_IP2_19_16 = 434,
	FN_A5 = 435,
	FN_LCDOUT21 = 436,
	FN_MSIOF3_SS2_B = 437,
	FN_SCK4_B = 438,
	FN_VI4_DATA13 = 439,
	FN_VI5_DATA13 = 440,
	FN_DU_DB5 = 441,
	FN_IP3_19_16 = 442,
	FN_A13 = 443,
	FN_LCDOUT13 = 444,
	FN_MSIOF3_SYNC_C = 445,
	FN_HTX4_A = 446,
	FN_VI5_DATA9 = 447,
	FN_DU_DG5 = 448,
	FN_IP0_23_20 = 449,
	FN_AVB_AVTP_CAPTURE_A = 450,
	FN_MSIOF2_TXD_C = 451,
	FN_RTS4_N_A = 452,
	FN_IP1_23_20 = 453,
	FN_PWM1_A = 454,
	FN_HRX3_D = 455,
	FN_VI4_DATA7_B = 456,
	FN_IERX_B = 457,
	FN_IP2_23_20 = 458,
	FN_A6 = 459,
	FN_LCDOUT22 = 460,
	FN_MSIOF2_SS1_A = 461,
	FN_RX4_B = 462,
	FN_VI4_DATA14 = 463,
	FN_VI5_DATA14 = 464,
	FN_DU_DB6 = 465,
	FN_IP3_23_20 = 466,
	FN_A14 = 467,
	FN_LCDOUT14 = 468,
	FN_MSIOF3_RXD_C = 469,
	FN_HCTS4_N = 470,
	FN_VI5_DATA10 = 471,
	FN_DU_DG6 = 472,
	FN_IP0_27_24 = 473,
	FN_IRQ0 = 474,
	FN_QPOLB = 475,
	FN_DU_CDE = 476,
	FN_VI4_DATA0_B = 477,
	FN_CAN0_TX_B = 478,
	FN_CANFD0_TX_B = 479,
	FN_MSIOF3_SS2_E = 480,
	FN_IP1_27_24 = 481,
	FN_PWM2_A = 482,
	FN_HTX3_D = 483,
	FN_IETX_B = 484,
	FN_IP2_27_24 = 485,
	FN_A7 = 486,
	FN_LCDOUT23 = 487,
	FN_MSIOF2_SS2_A = 488,
	FN_TX4_B = 489,
	FN_VI4_DATA15 = 490,
	FN_VI5_DATA15 = 491,
	FN_DU_DB7 = 492,
	FN_IP3_27_24 = 493,
	FN_A15 = 494,
	FN_LCDOUT15 = 495,
	FN_MSIOF3_TXD_C = 496,
	FN_HRTS4_N = 497,
	FN_VI5_DATA11 = 498,
	FN_DU_DG7 = 499,
	FN_IP0_31_28 = 500,
	FN_IRQ1 = 501,
	FN_QPOLA = 502,
	FN_DU_DISP = 503,
	FN_VI4_DATA1_B = 504,
	FN_CAN0_RX_B = 505,
	FN_CANFD0_RX_B = 506,
	FN_MSIOF3_SS1_E = 507,
	FN_IP1_31_28 = 508,
	FN_A0 = 509,
	FN_LCDOUT16 = 510,
	FN_MSIOF3_SYNC_B = 511,
	FN_VI4_DATA8 = 512,
	FN_DU_DB0 = 513,
	FN_PWM3_A = 514,
	FN_IP2_31_28 = 515,
	FN_A8 = 516,
	FN_RX3_B = 517,
	FN_MSIOF2_SYNC_A = 518,
	FN_HRX4_B = 519,
	FN_SDA6_A = 520,
	FN_AVB_AVTP_MATCH_B = 521,
	FN_PWM1_B = 522,
	FN_IP3_31_28 = 523,
	FN_A16 = 524,
	FN_LCDOUT8 = 525,
	FN_VI4_FIELD = 526,
	FN_DU_DG0 = 527,
	FN_IP4_3_0 = 528,
	FN_A17 = 529,
	FN_LCDOUT9 = 530,
	FN_VI4_VSYNC_N = 531,
	FN_DU_DG1 = 532,
	FN_IP5_3_0 = 533,
	FN_WE0_N = 534,
	FN_MSIOF3_TXD_D = 535,
	FN_CTS3_N = 536,
	FN_HCTS3_N = 537,
	FN_SCL6_B = 538,
	FN_CAN_CLK = 539,
	FN_IECLK_A = 540,
	FN_IP6_3_0 = 541,
	FN_D5 = 542,
	FN_MSIOF2_SYNC_B = 543,
	FN_VI4_DATA21 = 544,
	FN_VI5_DATA5 = 545,
	FN_IP7_3_0 = 546,
	FN_D13 = 547,
	FN_LCDOUT5 = 548,
	FN_MSIOF2_SS2_D = 549,
	FN_TX4_C = 550,
	FN_VI4_DATA5_A = 551,
	FN_DU_DR5 = 552,
	FN_IP4_7_4 = 553,
	FN_A18 = 554,
	FN_LCDOUT10 = 555,
	FN_VI4_HSYNC_N = 556,
	FN_DU_DG2 = 557,
	FN_IP5_7_4 = 558,
	FN_WE1_N = 559,
	FN_MSIOF3_SS1_D = 560,
	FN_RTS3_N = 561,
	FN_HRTS3_N = 562,
	FN_SDA6_B = 563,
	FN_CAN1_RX = 564,
	FN_CANFD1_RX = 565,
	FN_IERX_A = 566,
	FN_IP6_7_4 = 567,
	FN_D6 = 568,
	FN_MSIOF2_RXD_B = 569,
	FN_VI4_DATA22 = 570,
	FN_VI5_DATA6 = 571,
	FN_IP7_7_4 = 572,
	FN_D14 = 573,
	FN_LCDOUT6 = 574,
	FN_MSIOF3_SS1_A = 575,
	FN_HRX3_C = 576,
	FN_VI4_DATA6_A = 577,
	FN_DU_DR6 = 578,
	FN_SCL6_C = 579,
	FN_IP4_11_8 = 580,
	FN_A19 = 581,
	FN_LCDOUT11 = 582,
	FN_VI4_CLKENB = 583,
	FN_DU_DG3 = 584,
	FN_IP5_11_8 = 585,
	FN_EX_WAIT0_A = 586,
	FN_QCLK = 587,
	FN_VI4_CLK = 588,
	FN_DU_DOTCLKOUT0 = 589,
	FN_IP6_11_8 = 590,
	FN_D7 = 591,
	FN_MSIOF2_TXD_B = 592,
	FN_VI4_DATA23 = 593,
	FN_VI5_DATA7 = 594,
	FN_IP7_11_8 = 595,
	FN_D15 = 596,
	FN_LCDOUT7 = 597,
	FN_MSIOF3_SS2_A = 598,
	FN_HTX3_C = 599,
	FN_VI4_DATA7_A = 600,
	FN_DU_DR7 = 601,
	FN_SDA6_C = 602,
	FN_IP4_15_12 = 603,
	FN_CS0_N = 604,
	FN_VI5_CLKENB = 605,
	FN_IP5_15_12 = 606,
	FN_D0 = 607,
	FN_MSIOF2_SS1_B = 608,
	FN_MSIOF3_SCK_A = 609,
	FN_VI4_DATA16 = 610,
	FN_VI5_DATA0 = 611,
	FN_IP6_15_12 = 612,
	FN_D8 = 613,
	FN_LCDOUT0 = 614,
	FN_MSIOF2_SCK_D = 615,
	FN_SCK4_C = 616,
	FN_VI4_DATA0_A = 617,
	FN_DU_DR0 = 618,
	FN_IP4_19_16 = 619,
	FN_CS1_N = 620,
	FN_VI5_CLK = 621,
	FN_EX_WAIT0_B = 622,
	FN_IP5_19_16 = 623,
	FN_D1 = 624,
	FN_MSIOF2_SS2_B = 625,
	FN_MSIOF3_SYNC_A = 626,
	FN_VI4_DATA17 = 627,
	FN_VI5_DATA1 = 628,
	FN_IP6_19_16 = 629,
	FN_D9 = 630,
	FN_LCDOUT1 = 631,
	FN_MSIOF2_SYNC_D = 632,
	FN_VI4_DATA1_A = 633,
	FN_DU_DR1 = 634,
	FN_IP7_19_16 = 635,
	FN_SD0_CLK = 636,
	FN_MSIOF1_SCK_E = 637,
	FN_STP_OPWM_0_B = 638,
	FN_IP4_23_20 = 639,
	FN_BS_N = 640,
	FN_QSTVA_QVS = 641,
	FN_MSIOF3_SCK_D = 642,
	FN_SCK3 = 643,
	FN_HSCK3 = 644,
	FN_CAN1_TX = 645,
	FN_CANFD1_TX = 646,
	FN_IETX_A = 647,
	FN_IP5_23_20 = 648,
	FN_D2 = 649,
	FN_MSIOF3_RXD_A = 650,
	FN_VI4_DATA18 = 651,
	FN_VI5_DATA2 = 652,
	FN_IP6_23_20 = 653,
	FN_D10 = 654,
	FN_LCDOUT2 = 655,
	FN_MSIOF2_RXD_D = 656,
	FN_HRX3_B = 657,
	FN_VI4_DATA2_A = 658,
	FN_CTS4_N_C = 659,
	FN_DU_DR2 = 660,
	FN_IP7_23_20 = 661,
	FN_SD0_CMD = 662,
	FN_MSIOF1_SYNC_E = 663,
	FN_STP_IVCXO27_0_B = 664,
	FN_IP4_27_24 = 665,
	FN_RD_N = 666,
	FN_MSIOF3_SYNC_D = 667,
	FN_RX3_A = 668,
	FN_HRX3_A = 669,
	FN_CAN0_TX_A = 670,
	FN_CANFD0_TX_A = 671,
	FN_IP5_27_24 = 672,
	FN_D3 = 673,
	FN_MSIOF3_TXD_A = 674,
	FN_VI4_DATA19 = 675,
	FN_VI5_DATA3 = 676,
	FN_IP6_27_24 = 677,
	FN_D11 = 678,
	FN_LCDOUT3 = 679,
	FN_MSIOF2_TXD_D = 680,
	FN_HTX3_B = 681,
	FN_VI4_DATA3_A = 682,
	FN_RTS4_N_C = 683,
	FN_DU_DR3 = 684,
	FN_IP7_27_24 = 685,
	FN_SD0_DAT0 = 686,
	FN_MSIOF1_RXD_E = 687,
	FN_TS_SCK0_B = 688,
	FN_STP_ISCLK_0_B = 689,
	FN_IP4_31_28 = 690,
	FN_RD_WR_N = 691,
	FN_MSIOF3_RXD_D = 692,
	FN_TX3_A = 693,
	FN_HTX3_A = 694,
	FN_CAN0_RX_A = 695,
	FN_CANFD0_RX_A = 696,
	FN_IP5_31_28 = 697,
	FN_D4 = 698,
	FN_MSIOF2_SCK_B = 699,
	FN_VI4_DATA20 = 700,
	FN_VI5_DATA4 = 701,
	FN_IP6_31_28 = 702,
	FN_D12 = 703,
	FN_LCDOUT4 = 704,
	FN_MSIOF2_SS1_D = 705,
	FN_RX4_C = 706,
	FN_VI4_DATA4_A = 707,
	FN_DU_DR4 = 708,
	FN_IP7_31_28 = 709,
	FN_SD0_DAT1 = 710,
	FN_MSIOF1_TXD_E = 711,
	FN_TS_SPSYNC0_B = 712,
	FN_STP_ISSYNC_0_B = 713,
	FN_IP8_3_0 = 714,
	FN_SD0_DAT2 = 715,
	FN_MSIOF1_SS1_E = 716,
	FN_TS_SDAT0_B = 717,
	FN_STP_ISD_0_B = 718,
	FN_IP9_3_0 = 719,
	FN_SD2_CLK = 720,
	FN_NFDATA8 = 721,
	FN_IP10_3_0 = 722,
	FN_SD3_CMD = 723,
	FN_NFRE_N = 724,
	FN_IP11_3_0 = 725,
	FN_SD3_DAT7 = 726,
	FN_SD3_WP = 727,
	FN_NFDATA7 = 728,
	FN_IP8_7_4 = 729,
	FN_SD0_DAT3 = 730,
	FN_MSIOF1_SS2_E = 731,
	FN_TS_SDEN0_B = 732,
	FN_STP_ISEN_0_B = 733,
	FN_IP9_7_4 = 734,
	FN_SD2_CMD = 735,
	FN_NFDATA9 = 736,
	FN_IP10_7_4 = 737,
	FN_SD3_DAT0 = 738,
	FN_NFDATA0 = 739,
	FN_IP11_7_4 = 740,
	FN_SD3_DS = 741,
	FN_NFCLE = 742,
	FN_IP8_11_8 = 743,
	FN_SD1_CLK = 744,
	FN_MSIOF1_SCK_G = 745,
	FN_SIM0_CLK_A = 746,
	FN_IP9_11_8 = 747,
	FN_SD2_DAT0 = 748,
	FN_NFDATA10 = 749,
	FN_IP10_11_8 = 750,
	FN_SD3_DAT1 = 751,
	FN_NFDATA1 = 752,
	FN_IP11_11_8 = 753,
	FN_SD0_CD = 754,
	FN_NFDATA14_A = 755,
	FN_SCL2_B = 756,
	FN_SIM0_RST_A = 757,
	FN_IP8_15_12 = 758,
	FN_SD1_CMD = 759,
	FN_MSIOF1_SYNC_G = 760,
	FN_NFCE_N_B = 761,
	FN_SIM0_D_A = 762,
	FN_STP_IVCXO27_1_B = 763,
	FN_IP9_15_12 = 764,
	FN_SD2_DAT1 = 765,
	FN_NFDATA11 = 766,
	FN_IP10_15_12 = 767,
	FN_SD3_DAT2 = 768,
	FN_NFDATA2 = 769,
	FN_IP11_15_12 = 770,
	FN_SD0_WP = 771,
	FN_NFDATA15_A = 772,
	FN_SDA2_B = 773,
	FN_IP8_19_16 = 774,
	FN_SD1_DAT0 = 775,
	FN_SD2_DAT4 = 776,
	FN_MSIOF1_RXD_G = 777,
	FN_NFWP_N_B = 778,
	FN_TS_SCK1_B = 779,
	FN_STP_ISCLK_1_B = 780,
	FN_IP9_19_16 = 781,
	FN_SD2_DAT2 = 782,
	FN_NFDATA12 = 783,
	FN_IP10_19_16 = 784,
	FN_SD3_DAT3 = 785,
	FN_NFDATA3 = 786,
	FN_IP11_19_16 = 787,
	FN_SD1_CD = 788,
	FN_NFRB_N_A = 789,
	FN_SIM0_CLK_B = 790,
	FN_IP8_23_20 = 791,
	FN_SD1_DAT1 = 792,
	FN_SD2_DAT5 = 793,
	FN_MSIOF1_TXD_G = 794,
	FN_NFDATA14_B = 795,
	FN_TS_SPSYNC1_B = 796,
	FN_STP_ISSYNC_1_B = 797,
	FN_IP9_23_20 = 798,
	FN_SD2_DAT3 = 799,
	FN_NFDATA13 = 800,
	FN_IP10_23_20 = 801,
	FN_SD3_DAT4 = 802,
	FN_SD2_CD_A = 803,
	FN_NFDATA4 = 804,
	FN_IP11_23_20 = 805,
	FN_SD1_WP = 806,
	FN_NFCE_N_A = 807,
	FN_SIM0_D_B = 808,
	FN_IP8_27_24 = 809,
	FN_SD1_DAT2 = 810,
	FN_SD2_DAT6 = 811,
	FN_MSIOF1_SS1_G = 812,
	FN_NFDATA15_B = 813,
	FN_TS_SDAT1_B = 814,
	FN_STP_ISD_1_B = 815,
	FN_IP9_27_24 = 816,
	FN_SD2_DS = 817,
	FN_NFALE = 818,
	FN_IP10_27_24 = 819,
	FN_SD3_DAT5 = 820,
	FN_SD2_WP_A = 821,
	FN_NFDATA5 = 822,
	FN_IP11_27_24 = 823,
	FN_SCK0 = 824,
	FN_HSCK1_B = 825,
	FN_MSIOF1_SS2_B = 826,
	FN_AUDIO_CLKC_B = 827,
	FN_SDA2_A = 828,
	FN_SIM0_RST_B = 829,
	FN_STP_OPWM_0_C = 830,
	FN_RIF0_CLK_B = 831,
	FN_ADICHS2 = 832,
	FN_SCK5_B = 833,
	FN_IP8_31_28 = 834,
	FN_SD1_DAT3 = 835,
	FN_SD2_DAT7 = 836,
	FN_MSIOF1_SS2_G = 837,
	FN_NFRB_N_B = 838,
	FN_TS_SDEN1_B = 839,
	FN_STP_ISEN_1_B = 840,
	FN_IP9_31_28 = 841,
	FN_SD3_CLK = 842,
	FN_NFWE_N = 843,
	FN_IP10_31_28 = 844,
	FN_SD3_DAT6 = 845,
	FN_SD3_CD = 846,
	FN_NFDATA6 = 847,
	FN_IP11_31_28 = 848,
	FN_RX0 = 849,
	FN_HRX1_B = 850,
	FN_TS_SCK0_C = 851,
	FN_STP_ISCLK_0_C = 852,
	FN_RIF0_D0_B = 853,
	FN_IP12_3_0 = 854,
	FN_TX0 = 855,
	FN_HTX1_B = 856,
	FN_TS_SPSYNC0_C = 857,
	FN_STP_ISSYNC_0_C = 858,
	FN_RIF0_D1_B = 859,
	FN_IP13_3_0 = 860,
	FN_TX2_A = 861,
	FN_SD2_CD_B = 862,
	FN_SCL1_A = 863,
	FN_FMCLK_A = 864,
	FN_RIF1_D1_C = 865,
	FN_FSO_CFE_0_N = 866,
	FN_IP14_3_0 = 867,
	FN_MSIOF0_SS1 = 868,
	FN_RX5_A = 869,
	FN_NFWP_N_A = 870,
	FN_AUDIO_CLKA_C = 871,
	FN_SSI_SCK2_A = 872,
	FN_STP_IVCXO27_0_C = 873,
	FN_AUDIO_CLKOUT3_A = 874,
	FN_TCLK1_B = 875,
	FN_IP15_3_0 = 876,
	FN_SSI_SDATA1_A = 877,
	FN_IP12_7_4 = 878,
	FN_CTS0_N = 879,
	FN_HCTS1_N_B = 880,
	FN_MSIOF1_SYNC_B = 881,
	FN_TS_SPSYNC1_C = 882,
	FN_STP_ISSYNC_1_C = 883,
	FN_RIF1_SYNC_B = 884,
	FN_AUDIO_CLKOUT_C = 885,
	FN_ADICS_SAMP = 886,
	FN_IP13_7_4 = 887,
	FN_RX2_A = 888,
	FN_SD2_WP_B = 889,
	FN_SDA1_A = 890,
	FN_FMIN_A = 891,
	FN_RIF1_SYNC_C = 892,
	FN_FSO_CFE_1_N = 893,
	FN_IP14_7_4 = 894,
	FN_MSIOF0_SS2 = 895,
	FN_TX5_A = 896,
	FN_MSIOF1_SS2_D = 897,
	FN_AUDIO_CLKC_A = 898,
	FN_SSI_WS2_A = 899,
	FN_STP_OPWM_0_D = 900,
	FN_AUDIO_CLKOUT_D = 901,
	FN_SPEEDIN_B = 902,
	FN_IP15_7_4 = 903,
	FN_SSI_SDATA2_A = 904,
	FN_SSI_SCK1_B = 905,
	FN_IP12_11_8 = 906,
	FN_RTS0_N = 907,
	FN_HRTS1_N_B = 908,
	FN_MSIOF1_SS1_B = 909,
	FN_AUDIO_CLKA_B = 910,
	FN_SCL2_A = 911,
	FN_STP_IVCXO27_1_C = 912,
	FN_RIF0_SYNC_B = 913,
	FN_ADICHS1 = 914,
	FN_IP13_11_8 = 915,
	FN_HSCK0 = 916,
	FN_MSIOF1_SCK_D = 917,
	FN_AUDIO_CLKB_A = 918,
	FN_SSI_SDATA1_B = 919,
	FN_TS_SCK0_D = 920,
	FN_STP_ISCLK_0_D = 921,
	FN_RIF0_CLK_C = 922,
	FN_RX5_B = 923,
	FN_IP14_11_8 = 924,
	FN_MLB_CLK = 925,
	FN_MSIOF1_SCK_F = 926,
	FN_SCL1_B = 927,
	FN_IP15_11_8 = 928,
	FN_SSI_SCK349 = 929,
	FN_MSIOF1_SS1_A = 930,
	FN_STP_OPWM_0_A = 931,
	FN_IP12_15_12 = 932,
	FN_RX1_A = 933,
	FN_HRX1_A = 934,
	FN_TS_SDAT0_C = 935,
	FN_STP_ISD_0_C = 936,
	FN_RIF1_CLK_C = 937,
	FN_IP13_15_12 = 938,
	FN_HRX0 = 939,
	FN_MSIOF1_RXD_D = 940,
	FN_SSI_SDATA2_B = 941,
	FN_TS_SDEN0_D = 942,
	FN_STP_ISEN_0_D = 943,
	FN_RIF0_D0_C = 944,
	FN_IP14_15_12 = 945,
	FN_MLB_SIG = 946,
	FN_RX1_B = 947,
	FN_MSIOF1_SYNC_F = 948,
	FN_SDA1_B = 949,
	FN_IP15_15_12 = 950,
	FN_SSI_WS349 = 951,
	FN_HCTS2_N_A = 952,
	FN_MSIOF1_SS2_A = 953,
	FN_STP_IVCXO27_0_A = 954,
	FN_IP12_19_16 = 955,
	FN_TX1_A = 956,
	FN_HTX1_A = 957,
	FN_TS_SDEN0_C = 958,
	FN_STP_ISEN_0_C = 959,
	FN_RIF1_D0_C = 960,
	FN_IP13_19_16 = 961,
	FN_HTX0 = 962,
	FN_MSIOF1_TXD_D = 963,
	FN_SSI_SDATA9_B = 964,
	FN_TS_SDAT0_D = 965,
	FN_STP_ISD_0_D = 966,
	FN_RIF0_D1_C = 967,
	FN_IP14_19_16 = 968,
	FN_MLB_DAT = 969,
	FN_TX1_B = 970,
	FN_MSIOF1_RXD_F = 971,
	FN_IP15_19_16 = 972,
	FN_SSI_SDATA3 = 973,
	FN_HRTS2_N_A = 974,
	FN_MSIOF1_TXD_A = 975,
	FN_TS_SCK0_A = 976,
	FN_STP_ISCLK_0_A = 977,
	FN_RIF0_D1_A = 978,
	FN_RIF2_D0_A = 979,
	FN_IP12_23_20 = 980,
	FN_CTS1_N = 981,
	FN_HCTS1_N_A = 982,
	FN_MSIOF1_RXD_B = 983,
	FN_TS_SDEN1_C = 984,
	FN_STP_ISEN_1_C = 985,
	FN_RIF1_D0_B = 986,
	FN_ADIDATA = 987,
	FN_IP13_23_20 = 988,
	FN_HCTS0_N = 989,
	FN_RX2_B = 990,
	FN_MSIOF1_SYNC_D = 991,
	FN_SSI_SCK9_A = 992,
	FN_TS_SPSYNC0_D = 993,
	FN_STP_ISSYNC_0_D = 994,
	FN_RIF0_SYNC_C = 995,
	FN_AUDIO_CLKOUT1_A = 996,
	FN_IP14_23_20 = 997,
	FN_SSI_SCK01239 = 998,
	FN_MSIOF1_TXD_F = 999,
	FN_IP15_23_20 = 1000,
	FN_SSI_SCK4 = 1001,
	FN_HRX2_A = 1002,
	FN_MSIOF1_SCK_A = 1003,
	FN_TS_SDAT0_A = 1004,
	FN_STP_ISD_0_A = 1005,
	FN_RIF0_CLK_A = 1006,
	FN_RIF2_CLK_A = 1007,
	FN_IP12_27_24 = 1008,
	FN_RTS1_N = 1009,
	FN_HRTS1_N_A = 1010,
	FN_MSIOF1_TXD_B = 1011,
	FN_TS_SDAT1_C = 1012,
	FN_STP_ISD_1_C = 1013,
	FN_RIF1_D1_B = 1014,
	FN_ADICHS0 = 1015,
	FN_IP13_27_24 = 1016,
	FN_HRTS0_N = 1017,
	FN_TX2_B = 1018,
	FN_MSIOF1_SS1_D = 1019,
	FN_SSI_WS9_A = 1020,
	FN_STP_IVCXO27_0_D = 1021,
	FN_BPFCLK_A = 1022,
	FN_AUDIO_CLKOUT2_A = 1023,
	FN_IP14_27_24 = 1024,
	FN_SSI_WS01239 = 1025,
	FN_MSIOF1_SS1_F = 1026,
	FN_IP15_27_24 = 1027,
	FN_SSI_WS4 = 1028,
	FN_HTX2_A = 1029,
	FN_MSIOF1_SYNC_A = 1030,
	FN_TS_SDEN0_A = 1031,
	FN_STP_ISEN_0_A = 1032,
	FN_RIF0_SYNC_A = 1033,
	FN_RIF2_SYNC_A = 1034,
	FN_IP12_31_28 = 1035,
	FN_SCK2 = 1036,
	FN_SCIF_CLK_B = 1037,
	FN_MSIOF1_SCK_B = 1038,
	FN_TS_SCK1_C = 1039,
	FN_STP_ISCLK_1_C = 1040,
	FN_RIF1_CLK_B = 1041,
	FN_ADICLK = 1042,
	FN_IP13_31_28 = 1043,
	FN_MSIOF0_SYNC = 1044,
	FN_AUDIO_CLKOUT_A = 1045,
	FN_TX5_B = 1046,
	FN_BPFCLK_D = 1047,
	FN_IP14_31_28 = 1048,
	FN_SSI_SDATA0 = 1049,
	FN_MSIOF1_SS2_F = 1050,
	FN_IP15_31_28 = 1051,
	FN_SSI_SDATA4 = 1052,
	FN_HSCK2_A = 1053,
	FN_MSIOF1_RXD_A = 1054,
	FN_TS_SPSYNC0_A = 1055,
	FN_STP_ISSYNC_0_A = 1056,
	FN_RIF0_D0_A = 1057,
	FN_RIF2_D1_A = 1058,
	FN_IP16_3_0 = 1059,
	FN_SSI_SCK6 = 1060,
	FN_SIM0_RST_D = 1061,
	FN_IP17_3_0 = 1062,
	FN_AUDIO_CLKA_A = 1063,
	FN_IP18_3_0 = 1064,
	FN_GP6_30 = 1065,
	FN_AUDIO_CLKOUT2_B = 1066,
	FN_SSI_SCK9_B = 1067,
	FN_TS_SDEN0_E = 1068,
	FN_STP_ISEN_0_E = 1069,
	FN_RIF2_D0_B = 1070,
	FN_TPU0TO2 = 1071,
	FN_FMCLK_C = 1072,
	FN_FMCLK_D = 1073,
	FN_IP16_7_4 = 1074,
	FN_SSI_WS6 = 1075,
	FN_SIM0_D_D = 1076,
	FN_IP17_7_4 = 1077,
	FN_AUDIO_CLKB_B = 1078,
	FN_SCIF_CLK_A = 1079,
	FN_STP_IVCXO27_1_D = 1080,
	FN_REMOCON_A = 1081,
	FN_TCLK1_A = 1082,
	FN_IP18_7_4 = 1083,
	FN_GP6_31 = 1084,
	FN_AUDIO_CLKOUT3_B = 1085,
	FN_SSI_WS9_B = 1086,
	FN_TS_SPSYNC0_E = 1087,
	FN_STP_ISSYNC_0_E = 1088,
	FN_RIF2_D1_B = 1089,
	FN_TPU0TO3 = 1090,
	FN_FMIN_C = 1091,
	FN_FMIN_D = 1092,
	FN_IP16_11_8 = 1093,
	FN_SSI_SDATA6 = 1094,
	FN_SIM0_CLK_D = 1095,
	FN_IP17_11_8 = 1096,
	FN_USB0_PWEN = 1097,
	FN_SIM0_RST_C = 1098,
	FN_TS_SCK1_D = 1099,
	FN_STP_ISCLK_1_D = 1100,
	FN_BPFCLK_B = 1101,
	FN_RIF3_CLK_B = 1102,
	FN_HSCK2_C = 1103,
	FN_IP16_15_12 = 1104,
	FN_SSI_SCK78 = 1105,
	FN_HRX2_B = 1106,
	FN_MSIOF1_SCK_C = 1107,
	FN_TS_SCK1_A = 1108,
	FN_STP_ISCLK_1_A = 1109,
	FN_RIF1_CLK_A = 1110,
	FN_RIF3_CLK_A = 1111,
	FN_IP17_15_12 = 1112,
	FN_USB0_OVC = 1113,
	FN_SIM0_D_C = 1114,
	FN_TS_SDAT1_D = 1115,
	FN_STP_ISD_1_D = 1116,
	FN_RIF3_SYNC_B = 1117,
	FN_HRX2_C = 1118,
	FN_IP16_19_16 = 1119,
	FN_SSI_WS78 = 1120,
	FN_HTX2_B = 1121,
	FN_MSIOF1_SYNC_C = 1122,
	FN_TS_SDAT1_A = 1123,
	FN_STP_ISD_1_A = 1124,
	FN_RIF1_SYNC_A = 1125,
	FN_RIF3_SYNC_A = 1126,
	FN_IP17_19_16 = 1127,
	FN_USB1_PWEN = 1128,
	FN_SIM0_CLK_C = 1129,
	FN_SSI_SCK1_A = 1130,
	FN_TS_SCK0_E = 1131,
	FN_STP_ISCLK_0_E = 1132,
	FN_FMCLK_B = 1133,
	FN_RIF2_CLK_B = 1134,
	FN_SPEEDIN_A = 1135,
	FN_HTX2_C = 1136,
	FN_IP16_23_20 = 1137,
	FN_SSI_SDATA7 = 1138,
	FN_HCTS2_N_B = 1139,
	FN_MSIOF1_RXD_C = 1140,
	FN_TS_SDEN1_A = 1141,
	FN_STP_ISEN_1_A = 1142,
	FN_RIF1_D0_A = 1143,
	FN_RIF3_D0_A = 1144,
	FN_TCLK2_A = 1145,
	FN_IP17_23_20 = 1146,
	FN_USB1_OVC = 1147,
	FN_MSIOF1_SS2_C = 1148,
	FN_SSI_WS1_A = 1149,
	FN_TS_SDAT0_E = 1150,
	FN_STP_ISD_0_E = 1151,
	FN_FMIN_B = 1152,
	FN_RIF2_SYNC_B = 1153,
	FN_REMOCON_B = 1154,
	FN_HCTS2_N_C = 1155,
	FN_IP16_27_24 = 1156,
	FN_SSI_SDATA8 = 1157,
	FN_HRTS2_N_B = 1158,
	FN_MSIOF1_TXD_C = 1159,
	FN_TS_SPSYNC1_A = 1160,
	FN_STP_ISSYNC_1_A = 1161,
	FN_RIF1_D1_A = 1162,
	FN_RIF3_D1_A = 1163,
	FN_IP17_27_24 = 1164,
	FN_USB30_PWEN = 1165,
	FN_AUDIO_CLKOUT_B = 1166,
	FN_SSI_SCK2_B = 1167,
	FN_TS_SDEN1_D = 1168,
	FN_STP_ISEN_1_D = 1169,
	FN_STP_OPWM_0_E = 1170,
	FN_RIF3_D0_B = 1171,
	FN_TCLK2_B = 1172,
	FN_TPU0TO0 = 1173,
	FN_BPFCLK_C = 1174,
	FN_HRTS2_N_C = 1175,
	FN_IP16_31_28 = 1176,
	FN_SSI_SDATA9_A = 1177,
	FN_HSCK2_B = 1178,
	FN_MSIOF1_SS1_C = 1179,
	FN_HSCK1_A = 1180,
	FN_SSI_WS1_B = 1181,
	FN_SCK1 = 1182,
	FN_STP_IVCXO27_1_A = 1183,
	FN_SCK5_A = 1184,
	FN_IP17_31_28 = 1185,
	FN_USB30_OVC = 1186,
	FN_AUDIO_CLKOUT1_B = 1187,
	FN_SSI_WS2_B = 1188,
	FN_TS_SPSYNC1_D = 1189,
	FN_STP_ISSYNC_1_D = 1190,
	FN_STP_IVCXO27_0_E = 1191,
	FN_RIF3_D1_B = 1192,
	FN_FSO_TOE_N = 1193,
	FN_TPU0TO1 = 1194,
	FN_SEL_MSIOF3_0 = 1195,
	FN_SEL_MSIOF3_1 = 1196,
	FN_SEL_MSIOF3_2 = 1197,
	FN_SEL_MSIOF3_3 = 1198,
	FN_SEL_MSIOF3_4 = 1199,
	FN_SEL_TSIF1_0 = 1200,
	FN_SEL_TSIF1_1 = 1201,
	FN_SEL_TSIF1_2 = 1202,
	FN_SEL_TSIF1_3 = 1203,
	FN_I2C_SEL_5_0 = 1204,
	FN_I2C_SEL_5_1 = 1205,
	FN_I2C_SEL_3_0 = 1206,
	FN_I2C_SEL_3_1 = 1207,
	FN_SEL_TSIF0_0 = 1208,
	FN_SEL_TSIF0_1 = 1209,
	FN_SEL_TSIF0_2 = 1210,
	FN_SEL_TSIF0_3 = 1211,
	FN_SEL_TSIF0_4 = 1212,
	FN_I2C_SEL_0_0 = 1213,
	FN_I2C_SEL_0_1 = 1214,
	FN_SEL_MSIOF2_0 = 1215,
	FN_SEL_MSIOF2_1 = 1216,
	FN_SEL_MSIOF2_2 = 1217,
	FN_SEL_MSIOF2_3 = 1218,
	FN_SEL_FM_0 = 1219,
	FN_SEL_FM_1 = 1220,
	FN_SEL_FM_2 = 1221,
	FN_SEL_FM_3 = 1222,
	FN_SEL_MSIOF1_0 = 1223,
	FN_SEL_MSIOF1_1 = 1224,
	FN_SEL_MSIOF1_2 = 1225,
	FN_SEL_MSIOF1_3 = 1226,
	FN_SEL_MSIOF1_4 = 1227,
	FN_SEL_MSIOF1_5 = 1228,
	FN_SEL_MSIOF1_6 = 1229,
	FN_SEL_TIMER_TMU_0 = 1230,
	FN_SEL_TIMER_TMU_1 = 1231,
	FN_SEL_SCIF5_0 = 1232,
	FN_SEL_SCIF5_1 = 1233,
	FN_SEL_SSP1_1_0 = 1234,
	FN_SEL_SSP1_1_1 = 1235,
	FN_SEL_SSP1_1_2 = 1236,
	FN_SEL_SSP1_1_3 = 1237,
	FN_SEL_I2C6_0 = 1238,
	FN_SEL_I2C6_1 = 1239,
	FN_SEL_I2C6_2 = 1240,
	FN_SEL_LBSC_0 = 1241,
	FN_SEL_LBSC_1 = 1242,
	FN_SEL_SSP1_0_0 = 1243,
	FN_SEL_SSP1_0_1 = 1244,
	FN_SEL_SSP1_0_2 = 1245,
	FN_SEL_SSP1_0_3 = 1246,
	FN_SEL_SSP1_0_4 = 1247,
	FN_SEL_IEBUS_0 = 1248,
	FN_SEL_IEBUS_1 = 1249,
	FN_SEL_NDF_0 = 1250,
	FN_SEL_NDF_1 = 1251,
	FN_SEL_I2C2_0 = 1252,
	FN_SEL_I2C2_1 = 1253,
	FN_SEL_SSI2_0 = 1254,
	FN_SEL_SSI2_1 = 1255,
	FN_SEL_I2C1_0 = 1256,
	FN_SEL_I2C1_1 = 1257,
	FN_SEL_SSI1_0 = 1258,
	FN_SEL_SSI1_1 = 1259,
	FN_SEL_SSI9_0 = 1260,
	FN_SEL_SSI9_1 = 1261,
	FN_SEL_HSCIF4_0 = 1262,
	FN_SEL_HSCIF4_1 = 1263,
	FN_SEL_SPEED_PULSE_0 = 1264,
	FN_SEL_SPEED_PULSE_1 = 1265,
	FN_SEL_TIMER_TMU2_0 = 1266,
	FN_SEL_TIMER_TMU2_1 = 1267,
	FN_SEL_HSCIF3_0 = 1268,
	FN_SEL_HSCIF3_1 = 1269,
	FN_SEL_HSCIF3_2 = 1270,
	FN_SEL_HSCIF3_3 = 1271,
	FN_SEL_SIMCARD_0 = 1272,
	FN_SEL_SIMCARD_1 = 1273,
	FN_SEL_SIMCARD_2 = 1274,
	FN_SEL_SIMCARD_3 = 1275,
	FN_SEL_ADGB_0 = 1276,
	FN_SEL_ADGB_1 = 1277,
	FN_SEL_ADGC_0 = 1278,
	FN_SEL_ADGC_1 = 1279,
	FN_SEL_HSCIF1_0 = 1280,
	FN_SEL_HSCIF1_1 = 1281,
	FN_SEL_SDHI2_0 = 1282,
	FN_SEL_SDHI2_1 = 1283,
	FN_SEL_SCIF4_0 = 1284,
	FN_SEL_SCIF4_1 = 1285,
	FN_SEL_SCIF4_2 = 1286,
	FN_SEL_HSCIF2_0 = 1287,
	FN_SEL_HSCIF2_1 = 1288,
	FN_SEL_HSCIF2_2 = 1289,
	FN_SEL_SCIF3_0 = 1290,
	FN_SEL_SCIF3_1 = 1291,
	FN_SEL_ETHERAVB_0 = 1292,
	FN_SEL_ETHERAVB_1 = 1293,
	FN_SEL_SCIF2_0 = 1294,
	FN_SEL_SCIF2_1 = 1295,
	FN_SEL_DRIF3_0 = 1296,
	FN_SEL_DRIF3_1 = 1297,
	FN_SEL_SCIF1_0 = 1298,
	FN_SEL_SCIF1_1 = 1299,
	FN_SEL_DRIF2_0 = 1300,
	FN_SEL_DRIF2_1 = 1301,
	FN_SEL_SCIF_0 = 1302,
	FN_SEL_SCIF_1 = 1303,
	FN_SEL_DRIF1_0 = 1304,
	FN_SEL_DRIF1_1 = 1305,
	FN_SEL_DRIF1_2 = 1306,
	FN_SEL_REMOCON_0 = 1307,
	FN_SEL_REMOCON_1 = 1308,
	FN_SEL_DRIF0_0 = 1309,
	FN_SEL_DRIF0_1 = 1310,
	FN_SEL_DRIF0_2 = 1311,
	FN_SEL_RCAN0_0 = 1312,
	FN_SEL_RCAN0_1 = 1313,
	FN_SEL_CANFD0_0 = 1314,
	FN_SEL_CANFD0_1 = 1315,
	FN_SEL_PWM6_0 = 1316,
	FN_SEL_PWM6_1 = 1317,
	FN_SEL_ADGA_0 = 1318,
	FN_SEL_ADGA_1 = 1319,
	FN_SEL_ADGA_2 = 1320,
	FN_SEL_ADGA_3 = 1321,
	FN_SEL_PWM5_0 = 1322,
	FN_SEL_PWM5_1 = 1323,
	FN_SEL_PWM4_0 = 1324,
	FN_SEL_PWM4_1 = 1325,
	FN_SEL_PWM3_0 = 1326,
	FN_SEL_PWM3_1 = 1327,
	FN_SEL_PWM2_0 = 1328,
	FN_SEL_PWM2_1 = 1329,
	FN_SEL_PWM1_0 = 1330,
	FN_SEL_PWM1_1 = 1331,
	FN_SEL_VIN4_0 = 1332,
	FN_SEL_VIN4_1 = 1333,
	PINMUX_FUNCTION_END = 1334,
	PINMUX_MARK_BEGIN = 1335,
	CLKOUT_MARK = 1336,
	MSIOF0_RXD_MARK = 1337,
	MSIOF0_TXD_MARK = 1338,
	MSIOF0_SCK_MARK = 1339,
	SSI_SDATA5_MARK = 1340,
	SSI_WS5_MARK = 1341,
	SSI_SCK5_MARK = 1342,
	GP7_03_MARK = 1343,
	GP7_02_MARK = 1344,
	AVS2_MARK = 1345,
	AVS1_MARK = 1346,
	IP0_3_0_MARK = 1347,
	AVB_MDC_MARK = 1348,
	MSIOF2_SS2_C_MARK = 1349,
	IP1_3_0_MARK = 1350,
	IRQ2_MARK = 1351,
	QCPV_QDE_MARK = 1352,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK = 1353,
	VI4_DATA2_B_MARK = 1354,
	MSIOF3_SYNC_E_MARK = 1355,
	PWM3_B_MARK = 1356,
	IP2_3_0_MARK = 1357,
	A1_MARK = 1358,
	LCDOUT17_MARK = 1359,
	MSIOF3_TXD_B_MARK = 1360,
	VI4_DATA9_MARK = 1361,
	DU_DB1_MARK = 1362,
	PWM4_A_MARK = 1363,
	IP3_3_0_MARK = 1364,
	A9_MARK = 1365,
	MSIOF2_SCK_A_MARK = 1366,
	CTS4_N_B_MARK = 1367,
	VI5_VSYNC_N_MARK = 1368,
	IP0_7_4_MARK = 1369,
	AVB_MAGIC_MARK = 1370,
	MSIOF2_SS1_C_MARK = 1371,
	SCK4_A_MARK = 1372,
	IP1_7_4_MARK = 1373,
	IRQ3_MARK = 1374,
	QSTVB_QVE_MARK = 1375,
	DU_DOTCLKOUT1_MARK = 1376,
	VI4_DATA3_B_MARK = 1377,
	MSIOF3_SCK_E_MARK = 1378,
	PWM4_B_MARK = 1379,
	IP2_7_4_MARK = 1380,
	A2_MARK = 1381,
	LCDOUT18_MARK = 1382,
	MSIOF3_SCK_B_MARK = 1383,
	VI4_DATA10_MARK = 1384,
	DU_DB2_MARK = 1385,
	PWM5_A_MARK = 1386,
	IP3_7_4_MARK = 1387,
	A10_MARK = 1388,
	MSIOF2_RXD_A_MARK = 1389,
	RTS4_N_B_MARK = 1390,
	VI5_HSYNC_N_MARK = 1391,
	IP0_11_8_MARK = 1392,
	AVB_PHY_INT_MARK = 1393,
	MSIOF2_SYNC_C_MARK = 1394,
	RX4_A_MARK = 1395,
	IP1_11_8_MARK = 1396,
	IRQ4_MARK = 1397,
	QSTH_QHS_MARK = 1398,
	DU_EXHSYNC_DU_HSYNC_MARK = 1399,
	VI4_DATA4_B_MARK = 1400,
	MSIOF3_RXD_E_MARK = 1401,
	PWM5_B_MARK = 1402,
	IP2_11_8_MARK = 1403,
	A3_MARK = 1404,
	LCDOUT19_MARK = 1405,
	MSIOF3_RXD_B_MARK = 1406,
	VI4_DATA11_MARK = 1407,
	DU_DB3_MARK = 1408,
	PWM6_A_MARK = 1409,
	IP3_11_8_MARK = 1410,
	A11_MARK = 1411,
	TX3_B_MARK = 1412,
	MSIOF2_TXD_A_MARK = 1413,
	HTX4_B_MARK = 1414,
	HSCK4_MARK = 1415,
	VI5_FIELD_MARK = 1416,
	SCL6_A_MARK = 1417,
	AVB_AVTP_CAPTURE_B_MARK = 1418,
	PWM2_B_MARK = 1419,
	IP0_15_12_MARK = 1420,
	AVB_LINK_MARK = 1421,
	MSIOF2_SCK_C_MARK = 1422,
	TX4_A_MARK = 1423,
	IP1_15_12_MARK = 1424,
	IRQ5_MARK = 1425,
	QSTB_QHE_MARK = 1426,
	DU_EXVSYNC_DU_VSYNC_MARK = 1427,
	VI4_DATA5_B_MARK = 1428,
	MSIOF3_TXD_E_MARK = 1429,
	PWM6_B_MARK = 1430,
	IP2_15_12_MARK = 1431,
	A4_MARK = 1432,
	LCDOUT20_MARK = 1433,
	MSIOF3_SS1_B_MARK = 1434,
	VI4_DATA12_MARK = 1435,
	VI5_DATA12_MARK = 1436,
	DU_DB4_MARK = 1437,
	IP3_15_12_MARK = 1438,
	A12_MARK = 1439,
	LCDOUT12_MARK = 1440,
	MSIOF3_SCK_C_MARK = 1441,
	HRX4_A_MARK = 1442,
	VI5_DATA8_MARK = 1443,
	DU_DG4_MARK = 1444,
	IP0_19_16_MARK = 1445,
	AVB_AVTP_MATCH_A_MARK = 1446,
	MSIOF2_RXD_C_MARK = 1447,
	CTS4_N_A_MARK = 1448,
	IP1_19_16_MARK = 1449,
	PWM0_MARK = 1450,
	AVB_AVTP_PPS_MARK = 1451,
	VI4_DATA6_B_MARK = 1452,
	IECLK_B_MARK = 1453,
	IP2_19_16_MARK = 1454,
	A5_MARK = 1455,
	LCDOUT21_MARK = 1456,
	MSIOF3_SS2_B_MARK = 1457,
	SCK4_B_MARK = 1458,
	VI4_DATA13_MARK = 1459,
	VI5_DATA13_MARK = 1460,
	DU_DB5_MARK = 1461,
	IP3_19_16_MARK = 1462,
	A13_MARK = 1463,
	LCDOUT13_MARK = 1464,
	MSIOF3_SYNC_C_MARK = 1465,
	HTX4_A_MARK = 1466,
	VI5_DATA9_MARK = 1467,
	DU_DG5_MARK = 1468,
	IP0_23_20_MARK = 1469,
	AVB_AVTP_CAPTURE_A_MARK = 1470,
	MSIOF2_TXD_C_MARK = 1471,
	RTS4_N_A_MARK = 1472,
	IP1_23_20_MARK = 1473,
	PWM1_A_MARK = 1474,
	HRX3_D_MARK = 1475,
	VI4_DATA7_B_MARK = 1476,
	IERX_B_MARK = 1477,
	IP2_23_20_MARK = 1478,
	A6_MARK = 1479,
	LCDOUT22_MARK = 1480,
	MSIOF2_SS1_A_MARK = 1481,
	RX4_B_MARK = 1482,
	VI4_DATA14_MARK = 1483,
	VI5_DATA14_MARK = 1484,
	DU_DB6_MARK = 1485,
	IP3_23_20_MARK = 1486,
	A14_MARK = 1487,
	LCDOUT14_MARK = 1488,
	MSIOF3_RXD_C_MARK = 1489,
	HCTS4_N_MARK = 1490,
	VI5_DATA10_MARK = 1491,
	DU_DG6_MARK = 1492,
	IP0_27_24_MARK = 1493,
	IRQ0_MARK = 1494,
	QPOLB_MARK = 1495,
	DU_CDE_MARK = 1496,
	VI4_DATA0_B_MARK = 1497,
	CAN0_TX_B_MARK = 1498,
	CANFD0_TX_B_MARK = 1499,
	MSIOF3_SS2_E_MARK = 1500,
	IP1_27_24_MARK = 1501,
	PWM2_A_MARK = 1502,
	HTX3_D_MARK = 1503,
	IETX_B_MARK = 1504,
	IP2_27_24_MARK = 1505,
	A7_MARK = 1506,
	LCDOUT23_MARK = 1507,
	MSIOF2_SS2_A_MARK = 1508,
	TX4_B_MARK = 1509,
	VI4_DATA15_MARK = 1510,
	VI5_DATA15_MARK = 1511,
	DU_DB7_MARK = 1512,
	IP3_27_24_MARK = 1513,
	A15_MARK = 1514,
	LCDOUT15_MARK = 1515,
	MSIOF3_TXD_C_MARK = 1516,
	HRTS4_N_MARK = 1517,
	VI5_DATA11_MARK = 1518,
	DU_DG7_MARK = 1519,
	IP0_31_28_MARK = 1520,
	IRQ1_MARK = 1521,
	QPOLA_MARK = 1522,
	DU_DISP_MARK = 1523,
	VI4_DATA1_B_MARK = 1524,
	CAN0_RX_B_MARK = 1525,
	CANFD0_RX_B_MARK = 1526,
	MSIOF3_SS1_E_MARK = 1527,
	IP1_31_28_MARK = 1528,
	A0_MARK = 1529,
	LCDOUT16_MARK = 1530,
	MSIOF3_SYNC_B_MARK = 1531,
	VI4_DATA8_MARK = 1532,
	DU_DB0_MARK = 1533,
	PWM3_A_MARK = 1534,
	IP2_31_28_MARK = 1535,
	A8_MARK = 1536,
	RX3_B_MARK = 1537,
	MSIOF2_SYNC_A_MARK = 1538,
	HRX4_B_MARK = 1539,
	SDA6_A_MARK = 1540,
	AVB_AVTP_MATCH_B_MARK = 1541,
	PWM1_B_MARK = 1542,
	IP3_31_28_MARK = 1543,
	A16_MARK = 1544,
	LCDOUT8_MARK = 1545,
	VI4_FIELD_MARK = 1546,
	DU_DG0_MARK = 1547,
	IP4_3_0_MARK = 1548,
	A17_MARK = 1549,
	LCDOUT9_MARK = 1550,
	VI4_VSYNC_N_MARK = 1551,
	DU_DG1_MARK = 1552,
	IP5_3_0_MARK = 1553,
	WE0_N_MARK = 1554,
	MSIOF3_TXD_D_MARK = 1555,
	CTS3_N_MARK = 1556,
	HCTS3_N_MARK = 1557,
	SCL6_B_MARK = 1558,
	CAN_CLK_MARK = 1559,
	IECLK_A_MARK = 1560,
	IP6_3_0_MARK = 1561,
	D5_MARK = 1562,
	MSIOF2_SYNC_B_MARK = 1563,
	VI4_DATA21_MARK = 1564,
	VI5_DATA5_MARK = 1565,
	IP7_3_0_MARK = 1566,
	D13_MARK = 1567,
	LCDOUT5_MARK = 1568,
	MSIOF2_SS2_D_MARK = 1569,
	TX4_C_MARK = 1570,
	VI4_DATA5_A_MARK = 1571,
	DU_DR5_MARK = 1572,
	IP4_7_4_MARK = 1573,
	A18_MARK = 1574,
	LCDOUT10_MARK = 1575,
	VI4_HSYNC_N_MARK = 1576,
	DU_DG2_MARK = 1577,
	IP5_7_4_MARK = 1578,
	WE1_N_MARK = 1579,
	MSIOF3_SS1_D_MARK = 1580,
	RTS3_N_MARK = 1581,
	HRTS3_N_MARK = 1582,
	SDA6_B_MARK = 1583,
	CAN1_RX_MARK = 1584,
	CANFD1_RX_MARK = 1585,
	IERX_A_MARK = 1586,
	IP6_7_4_MARK = 1587,
	D6_MARK = 1588,
	MSIOF2_RXD_B_MARK = 1589,
	VI4_DATA22_MARK = 1590,
	VI5_DATA6_MARK = 1591,
	IP7_7_4_MARK = 1592,
	D14_MARK = 1593,
	LCDOUT6_MARK = 1594,
	MSIOF3_SS1_A_MARK = 1595,
	HRX3_C_MARK = 1596,
	VI4_DATA6_A_MARK = 1597,
	DU_DR6_MARK = 1598,
	SCL6_C_MARK = 1599,
	IP4_11_8_MARK = 1600,
	A19_MARK = 1601,
	LCDOUT11_MARK = 1602,
	VI4_CLKENB_MARK = 1603,
	DU_DG3_MARK = 1604,
	IP5_11_8_MARK = 1605,
	EX_WAIT0_A_MARK = 1606,
	QCLK_MARK = 1607,
	VI4_CLK_MARK = 1608,
	DU_DOTCLKOUT0_MARK = 1609,
	IP6_11_8_MARK = 1610,
	D7_MARK = 1611,
	MSIOF2_TXD_B_MARK = 1612,
	VI4_DATA23_MARK = 1613,
	VI5_DATA7_MARK = 1614,
	IP7_11_8_MARK = 1615,
	D15_MARK = 1616,
	LCDOUT7_MARK = 1617,
	MSIOF3_SS2_A_MARK = 1618,
	HTX3_C_MARK = 1619,
	VI4_DATA7_A_MARK = 1620,
	DU_DR7_MARK = 1621,
	SDA6_C_MARK = 1622,
	IP4_15_12_MARK = 1623,
	CS0_N_MARK = 1624,
	VI5_CLKENB_MARK = 1625,
	IP5_15_12_MARK = 1626,
	D0_MARK = 1627,
	MSIOF2_SS1_B_MARK = 1628,
	MSIOF3_SCK_A_MARK = 1629,
	VI4_DATA16_MARK = 1630,
	VI5_DATA0_MARK = 1631,
	IP6_15_12_MARK = 1632,
	D8_MARK = 1633,
	LCDOUT0_MARK = 1634,
	MSIOF2_SCK_D_MARK = 1635,
	SCK4_C_MARK = 1636,
	VI4_DATA0_A_MARK = 1637,
	DU_DR0_MARK = 1638,
	IP4_19_16_MARK = 1639,
	CS1_N_MARK = 1640,
	VI5_CLK_MARK = 1641,
	EX_WAIT0_B_MARK = 1642,
	IP5_19_16_MARK = 1643,
	D1_MARK = 1644,
	MSIOF2_SS2_B_MARK = 1645,
	MSIOF3_SYNC_A_MARK = 1646,
	VI4_DATA17_MARK = 1647,
	VI5_DATA1_MARK = 1648,
	IP6_19_16_MARK = 1649,
	D9_MARK = 1650,
	LCDOUT1_MARK = 1651,
	MSIOF2_SYNC_D_MARK = 1652,
	VI4_DATA1_A_MARK = 1653,
	DU_DR1_MARK = 1654,
	IP7_19_16_MARK = 1655,
	SD0_CLK_MARK = 1656,
	MSIOF1_SCK_E_MARK = 1657,
	STP_OPWM_0_B_MARK = 1658,
	IP4_23_20_MARK = 1659,
	BS_N_MARK = 1660,
	QSTVA_QVS_MARK = 1661,
	MSIOF3_SCK_D_MARK = 1662,
	SCK3_MARK = 1663,
	HSCK3_MARK = 1664,
	CAN1_TX_MARK = 1665,
	CANFD1_TX_MARK = 1666,
	IETX_A_MARK = 1667,
	IP5_23_20_MARK = 1668,
	D2_MARK = 1669,
	MSIOF3_RXD_A_MARK = 1670,
	VI4_DATA18_MARK = 1671,
	VI5_DATA2_MARK = 1672,
	IP6_23_20_MARK = 1673,
	D10_MARK = 1674,
	LCDOUT2_MARK = 1675,
	MSIOF2_RXD_D_MARK = 1676,
	HRX3_B_MARK = 1677,
	VI4_DATA2_A_MARK = 1678,
	CTS4_N_C_MARK = 1679,
	DU_DR2_MARK = 1680,
	IP7_23_20_MARK = 1681,
	SD0_CMD_MARK = 1682,
	MSIOF1_SYNC_E_MARK = 1683,
	STP_IVCXO27_0_B_MARK = 1684,
	IP4_27_24_MARK = 1685,
	RD_N_MARK = 1686,
	MSIOF3_SYNC_D_MARK = 1687,
	RX3_A_MARK = 1688,
	HRX3_A_MARK = 1689,
	CAN0_TX_A_MARK = 1690,
	CANFD0_TX_A_MARK = 1691,
	IP5_27_24_MARK = 1692,
	D3_MARK = 1693,
	MSIOF3_TXD_A_MARK = 1694,
	VI4_DATA19_MARK = 1695,
	VI5_DATA3_MARK = 1696,
	IP6_27_24_MARK = 1697,
	D11_MARK = 1698,
	LCDOUT3_MARK = 1699,
	MSIOF2_TXD_D_MARK = 1700,
	HTX3_B_MARK = 1701,
	VI4_DATA3_A_MARK = 1702,
	RTS4_N_C_MARK = 1703,
	DU_DR3_MARK = 1704,
	IP7_27_24_MARK = 1705,
	SD0_DAT0_MARK = 1706,
	MSIOF1_RXD_E_MARK = 1707,
	TS_SCK0_B_MARK = 1708,
	STP_ISCLK_0_B_MARK = 1709,
	IP4_31_28_MARK = 1710,
	RD_WR_N_MARK = 1711,
	MSIOF3_RXD_D_MARK = 1712,
	TX3_A_MARK = 1713,
	HTX3_A_MARK = 1714,
	CAN0_RX_A_MARK = 1715,
	CANFD0_RX_A_MARK = 1716,
	IP5_31_28_MARK = 1717,
	D4_MARK = 1718,
	MSIOF2_SCK_B_MARK = 1719,
	VI4_DATA20_MARK = 1720,
	VI5_DATA4_MARK = 1721,
	IP6_31_28_MARK = 1722,
	D12_MARK = 1723,
	LCDOUT4_MARK = 1724,
	MSIOF2_SS1_D_MARK = 1725,
	RX4_C_MARK = 1726,
	VI4_DATA4_A_MARK = 1727,
	DU_DR4_MARK = 1728,
	IP7_31_28_MARK = 1729,
	SD0_DAT1_MARK = 1730,
	MSIOF1_TXD_E_MARK = 1731,
	TS_SPSYNC0_B_MARK = 1732,
	STP_ISSYNC_0_B_MARK = 1733,
	IP8_3_0_MARK = 1734,
	SD0_DAT2_MARK = 1735,
	MSIOF1_SS1_E_MARK = 1736,
	TS_SDAT0_B_MARK = 1737,
	STP_ISD_0_B_MARK = 1738,
	IP9_3_0_MARK = 1739,
	SD2_CLK_MARK = 1740,
	NFDATA8_MARK = 1741,
	IP10_3_0_MARK = 1742,
	SD3_CMD_MARK = 1743,
	NFRE_N_MARK = 1744,
	IP11_3_0_MARK = 1745,
	SD3_DAT7_MARK = 1746,
	SD3_WP_MARK = 1747,
	NFDATA7_MARK = 1748,
	IP8_7_4_MARK = 1749,
	SD0_DAT3_MARK = 1750,
	MSIOF1_SS2_E_MARK = 1751,
	TS_SDEN0_B_MARK = 1752,
	STP_ISEN_0_B_MARK = 1753,
	IP9_7_4_MARK = 1754,
	SD2_CMD_MARK = 1755,
	NFDATA9_MARK = 1756,
	IP10_7_4_MARK = 1757,
	SD3_DAT0_MARK = 1758,
	NFDATA0_MARK = 1759,
	IP11_7_4_MARK = 1760,
	SD3_DS_MARK = 1761,
	NFCLE_MARK = 1762,
	IP8_11_8_MARK = 1763,
	SD1_CLK_MARK = 1764,
	MSIOF1_SCK_G_MARK = 1765,
	SIM0_CLK_A_MARK = 1766,
	IP9_11_8_MARK = 1767,
	SD2_DAT0_MARK = 1768,
	NFDATA10_MARK = 1769,
	IP10_11_8_MARK = 1770,
	SD3_DAT1_MARK = 1771,
	NFDATA1_MARK = 1772,
	IP11_11_8_MARK = 1773,
	SD0_CD_MARK = 1774,
	NFDATA14_A_MARK = 1775,
	SCL2_B_MARK = 1776,
	SIM0_RST_A_MARK = 1777,
	IP8_15_12_MARK = 1778,
	SD1_CMD_MARK = 1779,
	MSIOF1_SYNC_G_MARK = 1780,
	NFCE_N_B_MARK = 1781,
	SIM0_D_A_MARK = 1782,
	STP_IVCXO27_1_B_MARK = 1783,
	IP9_15_12_MARK = 1784,
	SD2_DAT1_MARK = 1785,
	NFDATA11_MARK = 1786,
	IP10_15_12_MARK = 1787,
	SD3_DAT2_MARK = 1788,
	NFDATA2_MARK = 1789,
	IP11_15_12_MARK = 1790,
	SD0_WP_MARK = 1791,
	NFDATA15_A_MARK = 1792,
	SDA2_B_MARK = 1793,
	IP8_19_16_MARK = 1794,
	SD1_DAT0_MARK = 1795,
	SD2_DAT4_MARK = 1796,
	MSIOF1_RXD_G_MARK = 1797,
	NFWP_N_B_MARK = 1798,
	TS_SCK1_B_MARK = 1799,
	STP_ISCLK_1_B_MARK = 1800,
	IP9_19_16_MARK = 1801,
	SD2_DAT2_MARK = 1802,
	NFDATA12_MARK = 1803,
	IP10_19_16_MARK = 1804,
	SD3_DAT3_MARK = 1805,
	NFDATA3_MARK = 1806,
	IP11_19_16_MARK = 1807,
	SD1_CD_MARK = 1808,
	NFRB_N_A_MARK = 1809,
	SIM0_CLK_B_MARK = 1810,
	IP8_23_20_MARK = 1811,
	SD1_DAT1_MARK = 1812,
	SD2_DAT5_MARK = 1813,
	MSIOF1_TXD_G_MARK = 1814,
	NFDATA14_B_MARK = 1815,
	TS_SPSYNC1_B_MARK = 1816,
	STP_ISSYNC_1_B_MARK = 1817,
	IP9_23_20_MARK = 1818,
	SD2_DAT3_MARK = 1819,
	NFDATA13_MARK = 1820,
	IP10_23_20_MARK = 1821,
	SD3_DAT4_MARK = 1822,
	SD2_CD_A_MARK = 1823,
	NFDATA4_MARK = 1824,
	IP11_23_20_MARK = 1825,
	SD1_WP_MARK = 1826,
	NFCE_N_A_MARK = 1827,
	SIM0_D_B_MARK = 1828,
	IP8_27_24_MARK = 1829,
	SD1_DAT2_MARK = 1830,
	SD2_DAT6_MARK = 1831,
	MSIOF1_SS1_G_MARK = 1832,
	NFDATA15_B_MARK = 1833,
	TS_SDAT1_B_MARK = 1834,
	STP_ISD_1_B_MARK = 1835,
	IP9_27_24_MARK = 1836,
	SD2_DS_MARK = 1837,
	NFALE_MARK = 1838,
	IP10_27_24_MARK = 1839,
	SD3_DAT5_MARK = 1840,
	SD2_WP_A_MARK = 1841,
	NFDATA5_MARK = 1842,
	IP11_27_24_MARK = 1843,
	SCK0_MARK = 1844,
	HSCK1_B_MARK = 1845,
	MSIOF1_SS2_B_MARK = 1846,
	AUDIO_CLKC_B_MARK = 1847,
	SDA2_A_MARK = 1848,
	SIM0_RST_B_MARK = 1849,
	STP_OPWM_0_C_MARK = 1850,
	RIF0_CLK_B_MARK = 1851,
	ADICHS2_MARK = 1852,
	SCK5_B_MARK = 1853,
	IP8_31_28_MARK = 1854,
	SD1_DAT3_MARK = 1855,
	SD2_DAT7_MARK = 1856,
	MSIOF1_SS2_G_MARK = 1857,
	NFRB_N_B_MARK = 1858,
	TS_SDEN1_B_MARK = 1859,
	STP_ISEN_1_B_MARK = 1860,
	IP9_31_28_MARK = 1861,
	SD3_CLK_MARK = 1862,
	NFWE_N_MARK = 1863,
	IP10_31_28_MARK = 1864,
	SD3_DAT6_MARK = 1865,
	SD3_CD_MARK = 1866,
	NFDATA6_MARK = 1867,
	IP11_31_28_MARK = 1868,
	RX0_MARK = 1869,
	HRX1_B_MARK = 1870,
	TS_SCK0_C_MARK = 1871,
	STP_ISCLK_0_C_MARK = 1872,
	RIF0_D0_B_MARK = 1873,
	IP12_3_0_MARK = 1874,
	TX0_MARK = 1875,
	HTX1_B_MARK = 1876,
	TS_SPSYNC0_C_MARK = 1877,
	STP_ISSYNC_0_C_MARK = 1878,
	RIF0_D1_B_MARK = 1879,
	IP13_3_0_MARK = 1880,
	TX2_A_MARK = 1881,
	SD2_CD_B_MARK = 1882,
	SCL1_A_MARK = 1883,
	FMCLK_A_MARK = 1884,
	RIF1_D1_C_MARK = 1885,
	FSO_CFE_0_N_MARK = 1886,
	IP14_3_0_MARK = 1887,
	MSIOF0_SS1_MARK = 1888,
	RX5_A_MARK = 1889,
	NFWP_N_A_MARK = 1890,
	AUDIO_CLKA_C_MARK = 1891,
	SSI_SCK2_A_MARK = 1892,
	STP_IVCXO27_0_C_MARK = 1893,
	AUDIO_CLKOUT3_A_MARK = 1894,
	TCLK1_B_MARK = 1895,
	IP15_3_0_MARK = 1896,
	SSI_SDATA1_A_MARK = 1897,
	IP12_7_4_MARK = 1898,
	CTS0_N_MARK = 1899,
	HCTS1_N_B_MARK = 1900,
	MSIOF1_SYNC_B_MARK = 1901,
	TS_SPSYNC1_C_MARK = 1902,
	STP_ISSYNC_1_C_MARK = 1903,
	RIF1_SYNC_B_MARK = 1904,
	AUDIO_CLKOUT_C_MARK = 1905,
	ADICS_SAMP_MARK = 1906,
	IP13_7_4_MARK = 1907,
	RX2_A_MARK = 1908,
	SD2_WP_B_MARK = 1909,
	SDA1_A_MARK = 1910,
	FMIN_A_MARK = 1911,
	RIF1_SYNC_C_MARK = 1912,
	FSO_CFE_1_N_MARK = 1913,
	IP14_7_4_MARK = 1914,
	MSIOF0_SS2_MARK = 1915,
	TX5_A_MARK = 1916,
	MSIOF1_SS2_D_MARK = 1917,
	AUDIO_CLKC_A_MARK = 1918,
	SSI_WS2_A_MARK = 1919,
	STP_OPWM_0_D_MARK = 1920,
	AUDIO_CLKOUT_D_MARK = 1921,
	SPEEDIN_B_MARK = 1922,
	IP15_7_4_MARK = 1923,
	SSI_SDATA2_A_MARK = 1924,
	SSI_SCK1_B_MARK = 1925,
	IP12_11_8_MARK = 1926,
	RTS0_N_MARK = 1927,
	HRTS1_N_B_MARK = 1928,
	MSIOF1_SS1_B_MARK = 1929,
	AUDIO_CLKA_B_MARK = 1930,
	SCL2_A_MARK = 1931,
	STP_IVCXO27_1_C_MARK = 1932,
	RIF0_SYNC_B_MARK = 1933,
	ADICHS1_MARK = 1934,
	IP13_11_8_MARK = 1935,
	HSCK0_MARK = 1936,
	MSIOF1_SCK_D_MARK = 1937,
	AUDIO_CLKB_A_MARK = 1938,
	SSI_SDATA1_B_MARK = 1939,
	TS_SCK0_D_MARK = 1940,
	STP_ISCLK_0_D_MARK = 1941,
	RIF0_CLK_C_MARK = 1942,
	RX5_B_MARK = 1943,
	IP14_11_8_MARK = 1944,
	MLB_CLK_MARK = 1945,
	MSIOF1_SCK_F_MARK = 1946,
	SCL1_B_MARK = 1947,
	IP15_11_8_MARK = 1948,
	SSI_SCK349_MARK = 1949,
	MSIOF1_SS1_A_MARK = 1950,
	STP_OPWM_0_A_MARK = 1951,
	IP12_15_12_MARK = 1952,
	RX1_A_MARK = 1953,
	HRX1_A_MARK = 1954,
	TS_SDAT0_C_MARK = 1955,
	STP_ISD_0_C_MARK = 1956,
	RIF1_CLK_C_MARK = 1957,
	IP13_15_12_MARK = 1958,
	HRX0_MARK = 1959,
	MSIOF1_RXD_D_MARK = 1960,
	SSI_SDATA2_B_MARK = 1961,
	TS_SDEN0_D_MARK = 1962,
	STP_ISEN_0_D_MARK = 1963,
	RIF0_D0_C_MARK = 1964,
	IP14_15_12_MARK = 1965,
	MLB_SIG_MARK = 1966,
	RX1_B_MARK = 1967,
	MSIOF1_SYNC_F_MARK = 1968,
	SDA1_B_MARK = 1969,
	IP15_15_12_MARK = 1970,
	SSI_WS349_MARK = 1971,
	HCTS2_N_A_MARK = 1972,
	MSIOF1_SS2_A_MARK = 1973,
	STP_IVCXO27_0_A_MARK = 1974,
	IP12_19_16_MARK = 1975,
	TX1_A_MARK = 1976,
	HTX1_A_MARK = 1977,
	TS_SDEN0_C_MARK = 1978,
	STP_ISEN_0_C_MARK = 1979,
	RIF1_D0_C_MARK = 1980,
	IP13_19_16_MARK = 1981,
	HTX0_MARK = 1982,
	MSIOF1_TXD_D_MARK = 1983,
	SSI_SDATA9_B_MARK = 1984,
	TS_SDAT0_D_MARK = 1985,
	STP_ISD_0_D_MARK = 1986,
	RIF0_D1_C_MARK = 1987,
	IP14_19_16_MARK = 1988,
	MLB_DAT_MARK = 1989,
	TX1_B_MARK = 1990,
	MSIOF1_RXD_F_MARK = 1991,
	IP15_19_16_MARK = 1992,
	SSI_SDATA3_MARK = 1993,
	HRTS2_N_A_MARK = 1994,
	MSIOF1_TXD_A_MARK = 1995,
	TS_SCK0_A_MARK = 1996,
	STP_ISCLK_0_A_MARK = 1997,
	RIF0_D1_A_MARK = 1998,
	RIF2_D0_A_MARK = 1999,
	IP12_23_20_MARK = 2000,
	CTS1_N_MARK = 2001,
	HCTS1_N_A_MARK = 2002,
	MSIOF1_RXD_B_MARK = 2003,
	TS_SDEN1_C_MARK = 2004,
	STP_ISEN_1_C_MARK = 2005,
	RIF1_D0_B_MARK = 2006,
	ADIDATA_MARK = 2007,
	IP13_23_20_MARK = 2008,
	HCTS0_N_MARK = 2009,
	RX2_B_MARK = 2010,
	MSIOF1_SYNC_D_MARK = 2011,
	SSI_SCK9_A_MARK = 2012,
	TS_SPSYNC0_D_MARK = 2013,
	STP_ISSYNC_0_D_MARK = 2014,
	RIF0_SYNC_C_MARK = 2015,
	AUDIO_CLKOUT1_A_MARK = 2016,
	IP14_23_20_MARK = 2017,
	SSI_SCK01239_MARK = 2018,
	MSIOF1_TXD_F_MARK = 2019,
	IP15_23_20_MARK = 2020,
	SSI_SCK4_MARK = 2021,
	HRX2_A_MARK = 2022,
	MSIOF1_SCK_A_MARK = 2023,
	TS_SDAT0_A_MARK = 2024,
	STP_ISD_0_A_MARK = 2025,
	RIF0_CLK_A_MARK = 2026,
	RIF2_CLK_A_MARK = 2027,
	IP12_27_24_MARK = 2028,
	RTS1_N_MARK = 2029,
	HRTS1_N_A_MARK = 2030,
	MSIOF1_TXD_B_MARK = 2031,
	TS_SDAT1_C_MARK = 2032,
	STP_ISD_1_C_MARK = 2033,
	RIF1_D1_B_MARK = 2034,
	ADICHS0_MARK = 2035,
	IP13_27_24_MARK = 2036,
	HRTS0_N_MARK = 2037,
	TX2_B_MARK = 2038,
	MSIOF1_SS1_D_MARK = 2039,
	SSI_WS9_A_MARK = 2040,
	STP_IVCXO27_0_D_MARK = 2041,
	BPFCLK_A_MARK = 2042,
	AUDIO_CLKOUT2_A_MARK = 2043,
	IP14_27_24_MARK = 2044,
	SSI_WS01239_MARK = 2045,
	MSIOF1_SS1_F_MARK = 2046,
	IP15_27_24_MARK = 2047,
	SSI_WS4_MARK = 2048,
	HTX2_A_MARK = 2049,
	MSIOF1_SYNC_A_MARK = 2050,
	TS_SDEN0_A_MARK = 2051,
	STP_ISEN_0_A_MARK = 2052,
	RIF0_SYNC_A_MARK = 2053,
	RIF2_SYNC_A_MARK = 2054,
	IP12_31_28_MARK = 2055,
	SCK2_MARK = 2056,
	SCIF_CLK_B_MARK = 2057,
	MSIOF1_SCK_B_MARK = 2058,
	TS_SCK1_C_MARK = 2059,
	STP_ISCLK_1_C_MARK = 2060,
	RIF1_CLK_B_MARK = 2061,
	ADICLK_MARK = 2062,
	IP13_31_28_MARK = 2063,
	MSIOF0_SYNC_MARK = 2064,
	AUDIO_CLKOUT_A_MARK = 2065,
	TX5_B_MARK = 2066,
	BPFCLK_D_MARK = 2067,
	IP14_31_28_MARK = 2068,
	SSI_SDATA0_MARK = 2069,
	MSIOF1_SS2_F_MARK = 2070,
	IP15_31_28_MARK = 2071,
	SSI_SDATA4_MARK = 2072,
	HSCK2_A_MARK = 2073,
	MSIOF1_RXD_A_MARK = 2074,
	TS_SPSYNC0_A_MARK = 2075,
	STP_ISSYNC_0_A_MARK = 2076,
	RIF0_D0_A_MARK = 2077,
	RIF2_D1_A_MARK = 2078,
	IP16_3_0_MARK = 2079,
	SSI_SCK6_MARK = 2080,
	SIM0_RST_D_MARK = 2081,
	IP17_3_0_MARK = 2082,
	AUDIO_CLKA_A_MARK = 2083,
	IP18_3_0_MARK = 2084,
	GP6_30_MARK = 2085,
	AUDIO_CLKOUT2_B_MARK = 2086,
	SSI_SCK9_B_MARK = 2087,
	TS_SDEN0_E_MARK = 2088,
	STP_ISEN_0_E_MARK = 2089,
	RIF2_D0_B_MARK = 2090,
	TPU0TO2_MARK = 2091,
	FMCLK_C_MARK = 2092,
	FMCLK_D_MARK = 2093,
	IP16_7_4_MARK = 2094,
	SSI_WS6_MARK = 2095,
	SIM0_D_D_MARK = 2096,
	IP17_7_4_MARK = 2097,
	AUDIO_CLKB_B_MARK = 2098,
	SCIF_CLK_A_MARK = 2099,
	STP_IVCXO27_1_D_MARK = 2100,
	REMOCON_A_MARK = 2101,
	TCLK1_A_MARK = 2102,
	IP18_7_4_MARK = 2103,
	GP6_31_MARK = 2104,
	AUDIO_CLKOUT3_B_MARK = 2105,
	SSI_WS9_B_MARK = 2106,
	TS_SPSYNC0_E_MARK = 2107,
	STP_ISSYNC_0_E_MARK = 2108,
	RIF2_D1_B_MARK = 2109,
	TPU0TO3_MARK = 2110,
	FMIN_C_MARK = 2111,
	FMIN_D_MARK = 2112,
	IP16_11_8_MARK = 2113,
	SSI_SDATA6_MARK = 2114,
	SIM0_CLK_D_MARK = 2115,
	IP17_11_8_MARK = 2116,
	USB0_PWEN_MARK = 2117,
	SIM0_RST_C_MARK = 2118,
	TS_SCK1_D_MARK = 2119,
	STP_ISCLK_1_D_MARK = 2120,
	BPFCLK_B_MARK = 2121,
	RIF3_CLK_B_MARK = 2122,
	HSCK2_C_MARK = 2123,
	IP16_15_12_MARK = 2124,
	SSI_SCK78_MARK = 2125,
	HRX2_B_MARK = 2126,
	MSIOF1_SCK_C_MARK = 2127,
	TS_SCK1_A_MARK = 2128,
	STP_ISCLK_1_A_MARK = 2129,
	RIF1_CLK_A_MARK = 2130,
	RIF3_CLK_A_MARK = 2131,
	IP17_15_12_MARK = 2132,
	USB0_OVC_MARK = 2133,
	SIM0_D_C_MARK = 2134,
	TS_SDAT1_D_MARK = 2135,
	STP_ISD_1_D_MARK = 2136,
	RIF3_SYNC_B_MARK = 2137,
	HRX2_C_MARK = 2138,
	IP16_19_16_MARK = 2139,
	SSI_WS78_MARK = 2140,
	HTX2_B_MARK = 2141,
	MSIOF1_SYNC_C_MARK = 2142,
	TS_SDAT1_A_MARK = 2143,
	STP_ISD_1_A_MARK = 2144,
	RIF1_SYNC_A_MARK = 2145,
	RIF3_SYNC_A_MARK = 2146,
	IP17_19_16_MARK = 2147,
	USB1_PWEN_MARK = 2148,
	SIM0_CLK_C_MARK = 2149,
	SSI_SCK1_A_MARK = 2150,
	TS_SCK0_E_MARK = 2151,
	STP_ISCLK_0_E_MARK = 2152,
	FMCLK_B_MARK = 2153,
	RIF2_CLK_B_MARK = 2154,
	SPEEDIN_A_MARK = 2155,
	HTX2_C_MARK = 2156,
	IP16_23_20_MARK = 2157,
	SSI_SDATA7_MARK = 2158,
	HCTS2_N_B_MARK = 2159,
	MSIOF1_RXD_C_MARK = 2160,
	TS_SDEN1_A_MARK = 2161,
	STP_ISEN_1_A_MARK = 2162,
	RIF1_D0_A_MARK = 2163,
	RIF3_D0_A_MARK = 2164,
	TCLK2_A_MARK = 2165,
	IP17_23_20_MARK = 2166,
	USB1_OVC_MARK = 2167,
	MSIOF1_SS2_C_MARK = 2168,
	SSI_WS1_A_MARK = 2169,
	TS_SDAT0_E_MARK = 2170,
	STP_ISD_0_E_MARK = 2171,
	FMIN_B_MARK = 2172,
	RIF2_SYNC_B_MARK = 2173,
	REMOCON_B_MARK = 2174,
	HCTS2_N_C_MARK = 2175,
	IP16_27_24_MARK = 2176,
	SSI_SDATA8_MARK = 2177,
	HRTS2_N_B_MARK = 2178,
	MSIOF1_TXD_C_MARK = 2179,
	TS_SPSYNC1_A_MARK = 2180,
	STP_ISSYNC_1_A_MARK = 2181,
	RIF1_D1_A_MARK = 2182,
	RIF3_D1_A_MARK = 2183,
	IP17_27_24_MARK = 2184,
	USB30_PWEN_MARK = 2185,
	AUDIO_CLKOUT_B_MARK = 2186,
	SSI_SCK2_B_MARK = 2187,
	TS_SDEN1_D_MARK = 2188,
	STP_ISEN_1_D_MARK = 2189,
	STP_OPWM_0_E_MARK = 2190,
	RIF3_D0_B_MARK = 2191,
	TCLK2_B_MARK = 2192,
	TPU0TO0_MARK = 2193,
	BPFCLK_C_MARK = 2194,
	HRTS2_N_C_MARK = 2195,
	IP16_31_28_MARK = 2196,
	SSI_SDATA9_A_MARK = 2197,
	HSCK2_B_MARK = 2198,
	MSIOF1_SS1_C_MARK = 2199,
	HSCK1_A_MARK = 2200,
	SSI_WS1_B_MARK = 2201,
	SCK1_MARK = 2202,
	STP_IVCXO27_1_A_MARK = 2203,
	SCK5_A_MARK = 2204,
	IP17_31_28_MARK = 2205,
	USB30_OVC_MARK = 2206,
	AUDIO_CLKOUT1_B_MARK = 2207,
	SSI_WS2_B_MARK = 2208,
	TS_SPSYNC1_D_MARK = 2209,
	STP_ISSYNC_1_D_MARK = 2210,
	STP_IVCXO27_0_E_MARK = 2211,
	RIF3_D1_B_MARK = 2212,
	FSO_TOE_N_MARK = 2213,
	TPU0TO1_MARK = 2214,
	SEL_MSIOF3_0_MARK = 2215,
	SEL_MSIOF3_1_MARK = 2216,
	SEL_MSIOF3_2_MARK = 2217,
	SEL_MSIOF3_3_MARK = 2218,
	SEL_MSIOF3_4_MARK = 2219,
	SEL_TSIF1_0_MARK = 2220,
	SEL_TSIF1_1_MARK = 2221,
	SEL_TSIF1_2_MARK = 2222,
	SEL_TSIF1_3_MARK = 2223,
	I2C_SEL_5_0_MARK = 2224,
	I2C_SEL_5_1_MARK = 2225,
	I2C_SEL_3_0_MARK = 2226,
	I2C_SEL_3_1_MARK = 2227,
	SEL_TSIF0_0_MARK = 2228,
	SEL_TSIF0_1_MARK = 2229,
	SEL_TSIF0_2_MARK = 2230,
	SEL_TSIF0_3_MARK = 2231,
	SEL_TSIF0_4_MARK = 2232,
	I2C_SEL_0_0_MARK = 2233,
	I2C_SEL_0_1_MARK = 2234,
	SEL_MSIOF2_0_MARK = 2235,
	SEL_MSIOF2_1_MARK = 2236,
	SEL_MSIOF2_2_MARK = 2237,
	SEL_MSIOF2_3_MARK = 2238,
	SEL_FM_0_MARK = 2239,
	SEL_FM_1_MARK = 2240,
	SEL_FM_2_MARK = 2241,
	SEL_FM_3_MARK = 2242,
	SEL_MSIOF1_0_MARK = 2243,
	SEL_MSIOF1_1_MARK = 2244,
	SEL_MSIOF1_2_MARK = 2245,
	SEL_MSIOF1_3_MARK = 2246,
	SEL_MSIOF1_4_MARK = 2247,
	SEL_MSIOF1_5_MARK = 2248,
	SEL_MSIOF1_6_MARK = 2249,
	SEL_TIMER_TMU_0_MARK = 2250,
	SEL_TIMER_TMU_1_MARK = 2251,
	SEL_SCIF5_0_MARK = 2252,
	SEL_SCIF5_1_MARK = 2253,
	SEL_SSP1_1_0_MARK = 2254,
	SEL_SSP1_1_1_MARK = 2255,
	SEL_SSP1_1_2_MARK = 2256,
	SEL_SSP1_1_3_MARK = 2257,
	SEL_I2C6_0_MARK = 2258,
	SEL_I2C6_1_MARK = 2259,
	SEL_I2C6_2_MARK = 2260,
	SEL_LBSC_0_MARK = 2261,
	SEL_LBSC_1_MARK = 2262,
	SEL_SSP1_0_0_MARK = 2263,
	SEL_SSP1_0_1_MARK = 2264,
	SEL_SSP1_0_2_MARK = 2265,
	SEL_SSP1_0_3_MARK = 2266,
	SEL_SSP1_0_4_MARK = 2267,
	SEL_IEBUS_0_MARK = 2268,
	SEL_IEBUS_1_MARK = 2269,
	SEL_NDF_0_MARK = 2270,
	SEL_NDF_1_MARK = 2271,
	SEL_I2C2_0_MARK = 2272,
	SEL_I2C2_1_MARK = 2273,
	SEL_SSI2_0_MARK = 2274,
	SEL_SSI2_1_MARK = 2275,
	SEL_I2C1_0_MARK = 2276,
	SEL_I2C1_1_MARK = 2277,
	SEL_SSI1_0_MARK = 2278,
	SEL_SSI1_1_MARK = 2279,
	SEL_SSI9_0_MARK = 2280,
	SEL_SSI9_1_MARK = 2281,
	SEL_HSCIF4_0_MARK = 2282,
	SEL_HSCIF4_1_MARK = 2283,
	SEL_SPEED_PULSE_0_MARK = 2284,
	SEL_SPEED_PULSE_1_MARK = 2285,
	SEL_TIMER_TMU2_0_MARK = 2286,
	SEL_TIMER_TMU2_1_MARK = 2287,
	SEL_HSCIF3_0_MARK = 2288,
	SEL_HSCIF3_1_MARK = 2289,
	SEL_HSCIF3_2_MARK = 2290,
	SEL_HSCIF3_3_MARK = 2291,
	SEL_SIMCARD_0_MARK = 2292,
	SEL_SIMCARD_1_MARK = 2293,
	SEL_SIMCARD_2_MARK = 2294,
	SEL_SIMCARD_3_MARK = 2295,
	SEL_ADGB_0_MARK = 2296,
	SEL_ADGB_1_MARK = 2297,
	SEL_ADGC_0_MARK = 2298,
	SEL_ADGC_1_MARK = 2299,
	SEL_HSCIF1_0_MARK = 2300,
	SEL_HSCIF1_1_MARK = 2301,
	SEL_SDHI2_0_MARK = 2302,
	SEL_SDHI2_1_MARK = 2303,
	SEL_SCIF4_0_MARK = 2304,
	SEL_SCIF4_1_MARK = 2305,
	SEL_SCIF4_2_MARK = 2306,
	SEL_HSCIF2_0_MARK = 2307,
	SEL_HSCIF2_1_MARK = 2308,
	SEL_HSCIF2_2_MARK = 2309,
	SEL_SCIF3_0_MARK = 2310,
	SEL_SCIF3_1_MARK = 2311,
	SEL_ETHERAVB_0_MARK = 2312,
	SEL_ETHERAVB_1_MARK = 2313,
	SEL_SCIF2_0_MARK = 2314,
	SEL_SCIF2_1_MARK = 2315,
	SEL_DRIF3_0_MARK = 2316,
	SEL_DRIF3_1_MARK = 2317,
	SEL_SCIF1_0_MARK = 2318,
	SEL_SCIF1_1_MARK = 2319,
	SEL_DRIF2_0_MARK = 2320,
	SEL_DRIF2_1_MARK = 2321,
	SEL_SCIF_0_MARK = 2322,
	SEL_SCIF_1_MARK = 2323,
	SEL_DRIF1_0_MARK = 2324,
	SEL_DRIF1_1_MARK = 2325,
	SEL_DRIF1_2_MARK = 2326,
	SEL_REMOCON_0_MARK = 2327,
	SEL_REMOCON_1_MARK = 2328,
	SEL_DRIF0_0_MARK = 2329,
	SEL_DRIF0_1_MARK = 2330,
	SEL_DRIF0_2_MARK = 2331,
	SEL_RCAN0_0_MARK = 2332,
	SEL_RCAN0_1_MARK = 2333,
	SEL_CANFD0_0_MARK = 2334,
	SEL_CANFD0_1_MARK = 2335,
	SEL_PWM6_0_MARK = 2336,
	SEL_PWM6_1_MARK = 2337,
	SEL_ADGA_0_MARK = 2338,
	SEL_ADGA_1_MARK = 2339,
	SEL_ADGA_2_MARK = 2340,
	SEL_ADGA_3_MARK = 2341,
	SEL_PWM5_0_MARK = 2342,
	SEL_PWM5_1_MARK = 2343,
	SEL_PWM4_0_MARK = 2344,
	SEL_PWM4_1_MARK = 2345,
	SEL_PWM3_0_MARK = 2346,
	SEL_PWM3_1_MARK = 2347,
	SEL_PWM2_0_MARK = 2348,
	SEL_PWM2_1_MARK = 2349,
	SEL_PWM1_0_MARK = 2350,
	SEL_PWM1_1_MARK = 2351,
	SEL_VIN4_0_MARK = 2352,
	SEL_VIN4_1_MARK = 2353,
	QSPI0_SPCLK_MARK = 2354,
	QSPI0_SSL_MARK = 2355,
	QSPI0_MOSI_IO0_MARK = 2356,
	QSPI0_MISO_IO1_MARK = 2357,
	QSPI0_IO2_MARK = 2358,
	QSPI0_IO3_MARK = 2359,
	QSPI1_SPCLK_MARK = 2360,
	QSPI1_SSL_MARK = 2361,
	QSPI1_MOSI_IO0_MARK = 2362,
	QSPI1_MISO_IO1_MARK = 2363,
	QSPI1_IO2_MARK = 2364,
	QSPI1_IO3_MARK = 2365,
	RPC_INT_MARK = 2366,
	RPC_WP_MARK = 2367,
	RPC_RESET_MARK = 2368,
	AVB_TX_CTL_MARK = 2369,
	AVB_TXC_MARK = 2370,
	AVB_TD0_MARK = 2371,
	AVB_TD1_MARK = 2372,
	AVB_TD2_MARK = 2373,
	AVB_TD3_MARK = 2374,
	AVB_RX_CTL_MARK = 2375,
	AVB_RXC_MARK = 2376,
	AVB_RD0_MARK = 2377,
	AVB_RD1_MARK = 2378,
	AVB_RD2_MARK = 2379,
	AVB_RD3_MARK = 2380,
	AVB_TXCREFCLK_MARK = 2381,
	AVB_MDIO_MARK = 2382,
	PRESETOUT_MARK = 2383,
	DU_DOTCLKIN0_MARK = 2384,
	DU_DOTCLKIN1_MARK = 2385,
	DU_DOTCLKIN2_MARK = 2386,
	TMS_MARK = 2387,
	TDO_MARK = 2388,
	ASEBRK_MARK = 2389,
	MLB_REF_MARK = 2390,
	TDI_MARK = 2391,
	TCK_MARK = 2392,
	TRST_MARK = 2393,
	EXTALR_MARK = 2394,
	SCL0_MARK = 2395,
	SDA0_MARK = 2396,
	SCL3_MARK = 2397,
	SDA3_MARK = 2398,
	SCL5_MARK = 2399,
	SDA5_MARK = 2400,
	PINMUX_MARK_END = 2401,
};

enum {
	PINMUX_TYPE_NONE = 0,
	PINMUX_TYPE_FUNCTION = 1,
	PINMUX_TYPE_GPIO = 2,
	PINMUX_TYPE_OUTPUT = 3,
	PINMUX_TYPE_INPUT = 4,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PLL_OFF_L_VAL = 0,
	PLL_OFF_CAL_L_VAL = 1,
	PLL_OFF_ALPHA_VAL = 2,
	PLL_OFF_ALPHA_VAL_U = 3,
	PLL_OFF_USER_CTL = 4,
	PLL_OFF_USER_CTL_U = 5,
	PLL_OFF_USER_CTL_U1 = 6,
	PLL_OFF_CONFIG_CTL = 7,
	PLL_OFF_CONFIG_CTL_U = 8,
	PLL_OFF_CONFIG_CTL_U1 = 9,
	PLL_OFF_CONFIG_CTL_U2 = 10,
	PLL_OFF_TEST_CTL = 11,
	PLL_OFF_TEST_CTL_U = 12,
	PLL_OFF_TEST_CTL_U1 = 13,
	PLL_OFF_TEST_CTL_U2 = 14,
	PLL_OFF_STATE = 15,
	PLL_OFF_STATUS = 16,
	PLL_OFF_OPMODE = 17,
	PLL_OFF_FRAC = 18,
	PLL_OFF_CAL_VAL = 19,
	PLL_OFF_MAX_REGS = 20,
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	POLICYDB_CAP_USERSPACE_INITIAL_CONTEXT = 8,
	__POLICYDB_CAP_MAX = 9,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWERCAP_FC_CAP = 0,
	POWERCAP_FC_PAI = 1,
	POWERCAP_FC_MAX = 2,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 5,
	POWER_SUPPLY_HEALTH_COLD = 6,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 7,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 9,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 10,
	POWER_SUPPLY_HEALTH_WARM = 11,
	POWER_SUPPLY_HEALTH_COOL = 12,
	POWER_SUPPLY_HEALTH_HOT = 13,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 14,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	P_AUD_REF_CLK = 0,
	P_GPLL0_OUT_MAIN = 1,
	P_GPLL4_OUT_MAIN = 2,
	P_PLL0_EARLY_DIV_CLK_SRC = 3,
	P_SLEEP_CLK = 4,
	P_XO = 5,
};

enum {
	P_BI_TCXO = 0,
	P_AUD_REF_CLK___2 = 1,
	P_GPLL0_OUT_EVEN = 2,
	P_GPLL0_OUT_MAIN___2 = 3,
	P_GPLL7_OUT_MAIN = 4,
	P_GPLL9_OUT_MAIN = 5,
	P_SLEEP_CLK___2 = 6,
};

enum {
	P_BI_TCXO___2 = 0,
	P_GPLL0_OUT_EVEN___2 = 1,
	P_GPLL0_OUT_MAIN___3 = 2,
	P_GPLL1_OUT_MAIN = 3,
	P_GPLL4_OUT_MAIN___2 = 4,
	P_GPLL6_OUT_MAIN = 5,
	P_GPLL7_OUT_MAIN___2 = 6,
	P_SLEEP_CLK___3 = 7,
};

enum {
	P_BI_TCXO___3 = 0,
	P_GCC_GPLL0_OUT_EVEN = 1,
	P_GCC_GPLL0_OUT_MAIN = 2,
	P_GCC_GPLL2_OUT_MAIN = 3,
	P_GCC_GPLL4_OUT_MAIN = 4,
	P_GCC_GPLL7_OUT_MAIN = 5,
	P_GCC_GPLL8_OUT_MAIN = 6,
	P_GCC_GPLL9_OUT_MAIN = 7,
	P_GCC_USB3_PRIM_PHY_PIPE_CLK_SRC = 8,
	P_GCC_USB3_SEC_PHY_PIPE_CLK_SRC = 9,
	P_GCC_USB4_1_PHY_DP_GMUX_CLK_SRC = 10,
	P_GCC_USB4_1_PHY_PCIE_PIPE_CLK_SRC = 11,
	P_GCC_USB4_1_PHY_PCIE_PIPEGMUX_CLK_SRC = 12,
	P_GCC_USB4_1_PHY_PIPEGMUX_CLK_SRC = 13,
	P_GCC_USB4_1_PHY_SYS_PIPEGMUX_CLK_SRC = 14,
	P_GCC_USB4_PHY_DP_GMUX_CLK_SRC = 15,
	P_GCC_USB4_PHY_PCIE_PIPE_CLK_SRC = 16,
	P_GCC_USB4_PHY_PCIE_PIPEGMUX_CLK_SRC = 17,
	P_GCC_USB4_PHY_PIPEGMUX_CLK_SRC = 18,
	P_GCC_USB4_PHY_SYS_PIPEGMUX_CLK_SRC = 19,
	P_QUSB4PHY_1_GCC_USB4_RX0_CLK = 20,
	P_QUSB4PHY_1_GCC_USB4_RX1_CLK = 21,
	P_QUSB4PHY_GCC_USB4_RX0_CLK = 22,
	P_QUSB4PHY_GCC_USB4_RX1_CLK = 23,
	P_RXC0_REF_CLK = 24,
	P_RXC1_REF_CLK = 25,
	P_SLEEP_CLK___4 = 26,
	P_UFS_CARD_RX_SYMBOL_0_CLK = 27,
	P_UFS_CARD_RX_SYMBOL_1_CLK = 28,
	P_UFS_CARD_TX_SYMBOL_0_CLK = 29,
	P_UFS_PHY_RX_SYMBOL_0_CLK = 30,
	P_UFS_PHY_RX_SYMBOL_1_CLK = 31,
	P_UFS_PHY_TX_SYMBOL_0_CLK = 32,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK = 33,
	P_USB3_UNI_PHY_MP_GCC_USB30_PIPE_0_CLK = 34,
	P_USB3_UNI_PHY_MP_GCC_USB30_PIPE_1_CLK = 35,
	P_USB3_UNI_PHY_SEC_GCC_USB30_PIPE_CLK = 36,
	P_USB4_1_PHY_GCC_USB4_PCIE_PIPE_CLK = 37,
	P_USB4_1_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 38,
	P_USB4_PHY_GCC_USB4_PCIE_PIPE_CLK = 39,
	P_USB4_PHY_GCC_USB4RTR_MAX_PIPE_CLK = 40,
};

enum {
	P_BI_TCXO___4 = 0,
	P_GCC_GPLL0_OUT_EVEN___2 = 1,
	P_GCC_GPLL0_OUT_MAIN___2 = 2,
	P_GCC_GPLL0_OUT_ODD = 3,
	P_GCC_GPLL10_OUT_MAIN = 4,
	P_GCC_GPLL4_OUT_MAIN___2 = 5,
	P_GCC_GPLL9_OUT_MAIN___2 = 6,
	P_PCIE_0_PIPE_CLK = 7,
	P_PCIE_1_PIPE_CLK = 8,
	P_SLEEP_CLK___5 = 9,
	P_UFS_PHY_RX_SYMBOL_0_CLK___2 = 10,
	P_UFS_PHY_RX_SYMBOL_1_CLK___2 = 11,
	P_UFS_PHY_TX_SYMBOL_0_CLK___2 = 12,
	P_USB3_PHY_WRAPPER_GCC_USB30_PIPE_CLK___2 = 13,
	P_GCC_MSS_GPLL0_MAIN_DIV_CLK = 14,
};

enum {
	P_BI_TCXO___5 = 0,
	P_GCC_GPLL0_OUT_EVEN___3 = 1,
	P_GCC_GPLL0_OUT_MAIN___3 = 2,
	P_GCC_GPLL4_OUT_MAIN___3 = 3,
	P_GCC_GPLL7_OUT_MAIN___2 = 4,
	P_GCC_GPLL8_OUT_MAIN___2 = 5,
	P_GCC_GPLL9_OUT_MAIN___3 = 6,
	P_SLEEP_CLK___6 = 7,
	P_USB3_PHY_0_WRAPPER_GCC_USB30_PIPE_CLK = 8,
	P_USB3_PHY_1_WRAPPER_GCC_USB30_PIPE_CLK = 9,
	P_USB3_PHY_2_WRAPPER_GCC_USB30_PIPE_CLK = 10,
};

enum {
	P_XO___2 = 0,
	P_GPLL0 = 1,
	P_GPLL0_AUX = 2,
	P_BIMC = 3,
	P_GPLL1 = 4,
	P_GPLL1_AUX = 5,
	P_GPLL2 = 6,
	P_GPLL2_AUX = 7,
	P_SLEEP_CLK___7 = 8,
	P_DSI0_PHYPLL_BYTE = 9,
	P_DSI0_PHYPLL_DSI = 10,
	P_EXT_PRI_I2S = 11,
	P_EXT_SEC_I2S = 12,
	P_EXT_MCLK = 13,
};

enum {
	P_XO___3 = 0,
	P_GPLL0___2 = 1,
	P_GPLL0_EARLY_DIV = 2,
	P_SLEEP_CLK___8 = 3,
	P_GPLL4 = 4,
	P_AUD_REF_CLK___3 = 5,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_MAX = 13,
};

enum {
	QUOTA_NL_A_UNSPEC = 0,
	QUOTA_NL_A_QTYPE = 1,
	QUOTA_NL_A_EXCESS_ID = 2,
	QUOTA_NL_A_WARNING = 3,
	QUOTA_NL_A_DEV_MAJOR = 4,
	QUOTA_NL_A_DEV_MINOR = 5,
	QUOTA_NL_A_CAUSED_ID = 6,
	QUOTA_NL_A_PAD = 7,
	__QUOTA_NL_A_MAX = 8,
};

enum {
	QUOTA_NL_C_UNSPEC = 0,
	QUOTA_NL_C_WARNING = 1,
	__QUOTA_NL_C_MAX = 2,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RANGE_BOUNDARY_WRITTEN_EXTENT = 0,
	RANGE_BOUNDARY_PREALLOC_EXTENT = 1,
	RANGE_BOUNDARY_HOLE = 2,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RCD = 0,
	RCH_DP = 1,
	DEVICE = 2,
	LD = 3,
	FMLD = 4,
	RP = 5,
	DSP = 6,
	USP = 7,
};

enum {
	READA_NONE = 0,
	READA_BACK = 1,
	READA_FORWARD = 2,
	READA_FORWARD_ALWAYS = 3,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REG_RE = 0,
	REG_FE = 1,
	REG_IE = 2,
};

enum {
	REQUEST_ANY = 0,
	REQUEST_BY_ID = 1,
	REQUEST_BY_CAP = 2,
	REQUEST_BY_NODE = 3,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 5000,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_BUFFER_SELECTED = 32768ULL,
	REQ_F_BUFFER_RING = 65536ULL,
	REQ_F_REISSUE = 131072ULL,
	REQ_F_SUPPORT_NOWAIT = 268435456ULL,
	REQ_F_ISREG = 536870912ULL,
	REQ_F_CREDS = 262144ULL,
	REQ_F_REFCOUNT = 524288ULL,
	REQ_F_ARM_LTIMEOUT = 1048576ULL,
	REQ_F_ASYNC_DATA = 2097152ULL,
	REQ_F_SKIP_LINK_CQES = 4194304ULL,
	REQ_F_SINGLE_POLL = 8388608ULL,
	REQ_F_DOUBLE_POLL = 16777216ULL,
	REQ_F_APOLL_MULTISHOT = 33554432ULL,
	REQ_F_CLEAR_POLLIN = 67108864ULL,
	REQ_F_HASH_LOCKED = 134217728ULL,
	REQ_F_POLL_NO_LAZY = 1073741824ULL,
	REQ_F_CAN_POLL = 2147483648ULL,
	REQ_F_BL_EMPTY = 4294967296ULL,
	REQ_F_BL_NO_RECYCLE = 8589934592ULL,
	REQ_F_BUFFERS_COMMIT = 17179869184ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_BUFFER_SELECTED_BIT = 15,
	REQ_F_BUFFER_RING_BIT = 16,
	REQ_F_REISSUE_BIT = 17,
	REQ_F_CREDS_BIT = 18,
	REQ_F_REFCOUNT_BIT = 19,
	REQ_F_ARM_LTIMEOUT_BIT = 20,
	REQ_F_ASYNC_DATA_BIT = 21,
	REQ_F_SKIP_LINK_CQES_BIT = 22,
	REQ_F_SINGLE_POLL_BIT = 23,
	REQ_F_DOUBLE_POLL_BIT = 24,
	REQ_F_APOLL_MULTISHOT_BIT = 25,
	REQ_F_CLEAR_POLLIN_BIT = 26,
	REQ_F_HASH_LOCKED_BIT = 27,
	REQ_F_SUPPORT_NOWAIT_BIT = 28,
	REQ_F_ISREG_BIT = 29,
	REQ_F_POLL_NO_LAZY_BIT = 30,
	REQ_F_CAN_POLL_BIT = 31,
	REQ_F_BL_EMPTY_BIT = 32,
	REQ_F_BL_NO_RECYCLE_BIT = 33,
	REQ_F_BUFFERS_COMMIT_BIT = 34,
	__REQ_F_LAST_BIT = 35,
};

enum {
	RES_USAGE = 0,
	RES_LIMIT = 1,
	RES_MAX_USAGE = 2,
	RES_FAILCNT = 3,
	RES_SOFT_LIMIT = 4,
};

enum {
	RGR1_SW_INIT_1 = 0,
	EXT_CFG_INDEX = 1,
	EXT_CFG_DATA = 2,
	PCIE_HARD_DEBUG = 3,
	PCIE_INTR2_CPU_BASE = 4,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RPL_IPTUNNEL_UNSPEC = 0,
	RPL_IPTUNNEL_SRH = 1,
	__RPL_IPTUNNEL_MAX = 2,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RSC_DRV_TCS_OFFSET = 0,
	RSC_DRV_CMD_OFFSET = 1,
	DRV_SOLVER_CONFIG = 2,
	DRV_PRNT_CHLD_CONFIG = 3,
	RSC_DRV_IRQ_ENABLE = 4,
	RSC_DRV_IRQ_STATUS = 5,
	RSC_DRV_IRQ_CLEAR = 6,
	RSC_DRV_CMD_WAIT_FOR_CMPL = 7,
	RSC_DRV_CONTROL = 8,
	RSC_DRV_STATUS = 9,
	RSC_DRV_CMD_ENABLE = 10,
	RSC_DRV_CMD_MSGID = 11,
	RSC_DRV_CMD_ADDR = 12,
	RSC_DRV_CMD_DATA = 13,
	RSC_DRV_CMD_STATUS = 14,
	RSC_DRV_CMD_RESP_DATA = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_GETMULTICAST = 58,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCIx_ERI_IRQ = 0,
	SCIx_RXI_IRQ = 1,
	SCIx_TXI_IRQ = 2,
	SCIx_BRI_IRQ = 3,
	SCIx_DRI_IRQ = 4,
	SCIx_TEI_IRQ = 5,
	SCIx_NR_IRQS = 6,
	SCIx_MUX_IRQ = 6,
};

enum {
	SCIx_PROBE_REGTYPE = 0,
	SCIx_SCI_REGTYPE = 1,
	SCIx_IRDA_REGTYPE = 2,
	SCIx_SCIFA_REGTYPE = 3,
	SCIx_SCIFB_REGTYPE = 4,
	SCIx_SH2_SCIF_FIFODATA_REGTYPE = 5,
	SCIx_SH3_SCIF_REGTYPE = 6,
	SCIx_SH4_SCIF_REGTYPE = 7,
	SCIx_SH4_SCIF_BRG_REGTYPE = 8,
	SCIx_SH4_SCIF_NO_SCSPTR_REGTYPE = 9,
	SCIx_SH4_SCIF_FIFODATA_REGTYPE = 10,
	SCIx_SH7705_SCIF_REGTYPE = 11,
	SCIx_HSCIF_REGTYPE = 12,
	SCIx_RZ_SCIFA_REGTYPE = 13,
	SCIx_RZV2H_SCIF_REGTYPE = 14,
	SCIx_NR_REGTYPES = 15,
};

enum {
	SCMI_RAW_REPLY_QUEUE = 0,
	SCMI_RAW_NOTIF_QUEUE = 1,
	SCMI_RAW_ERRS_QUEUE = 2,
	SCMI_RAW_MAX_QUEUE = 3,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

enum {
	SCSMR = 0,
	SCBRR = 1,
	SCSCR = 2,
	SCxSR = 3,
	SCFCR = 4,
	SCFDR = 5,
	SCxTDR = 6,
	SCxRDR = 7,
	SCLSR = 8,
	SCTFDR = 9,
	SCRFDR = 10,
	SCSPTR = 11,
	HSSRR = 12,
	SCPCR = 13,
	SCPDR = 14,
	SCDL = 15,
	SCCKS = 16,
	HSRTRGR = 17,
	HSTTRGR = 18,
	SEMR = 19,
	SCIx_NR_REGS = 20,
};

enum {
	SCTP_AUTH_HMAC_ID_RESERVED_0 = 0,
	SCTP_AUTH_HMAC_ID_SHA1 = 1,
	SCTP_AUTH_HMAC_ID_RESERVED_2 = 2,
	SCTP_AUTH_HMAC_ID_SHA256 = 3,
	__SCTP_AUTH_HMAC_MAX = 4,
};

enum {
	SCTP_MAX_DUP_TSNS = 16,
};

enum {
	SCTP_MAX_STREAM = 65535,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SEAL_keytype = 1,
	SRK_keytype = 4,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_TAINT_ZONE_DEVICE_BIT = 4,
	SECTION_MAP_LAST_BIT = 5,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SEG6_HMAC_ALGO_SHA1 = 1,
	SEG6_HMAC_ALGO_SHA256 = 2,
};

enum {
	SEG6_IPTUNNEL_UNSPEC = 0,
	SEG6_IPTUNNEL_SRH = 1,
	__SEG6_IPTUNNEL_MAX = 2,
};

enum {
	SEG6_IPTUN_MODE_INLINE = 0,
	SEG6_IPTUN_MODE_ENCAP = 1,
	SEG6_IPTUN_MODE_L2ENCAP = 2,
	SEG6_IPTUN_MODE_ENCAP_RED = 3,
	SEG6_IPTUN_MODE_L2ENCAP_RED = 4,
};

enum {
	SEG6_LOCAL_ACTION_UNSPEC = 0,
	SEG6_LOCAL_ACTION_END = 1,
	SEG6_LOCAL_ACTION_END_X = 2,
	SEG6_LOCAL_ACTION_END_T = 3,
	SEG6_LOCAL_ACTION_END_DX2 = 4,
	SEG6_LOCAL_ACTION_END_DX6 = 5,
	SEG6_LOCAL_ACTION_END_DX4 = 6,
	SEG6_LOCAL_ACTION_END_DT6 = 7,
	SEG6_LOCAL_ACTION_END_DT4 = 8,
	SEG6_LOCAL_ACTION_END_B6 = 9,
	SEG6_LOCAL_ACTION_END_B6_ENCAP = 10,
	SEG6_LOCAL_ACTION_END_BM = 11,
	SEG6_LOCAL_ACTION_END_S = 12,
	SEG6_LOCAL_ACTION_END_AS = 13,
	SEG6_LOCAL_ACTION_END_AM = 14,
	SEG6_LOCAL_ACTION_END_BPF = 15,
	SEG6_LOCAL_ACTION_END_DT46 = 16,
	__SEG6_LOCAL_ACTION_MAX = 17,
};

enum {
	SEG6_LOCAL_BPF_PROG_UNSPEC = 0,
	SEG6_LOCAL_BPF_PROG = 1,
	SEG6_LOCAL_BPF_PROG_NAME = 2,
	__SEG6_LOCAL_BPF_PROG_MAX = 3,
};

enum {
	SEG6_LOCAL_CNT_UNSPEC = 0,
	SEG6_LOCAL_CNT_PAD = 1,
	SEG6_LOCAL_CNT_PACKETS = 2,
	SEG6_LOCAL_CNT_BYTES = 3,
	SEG6_LOCAL_CNT_ERRORS = 4,
	__SEG6_LOCAL_CNT_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_OP_UNSPEC = 0,
	SEG6_LOCAL_FLV_OP_PSP = 1,
	SEG6_LOCAL_FLV_OP_USP = 2,
	SEG6_LOCAL_FLV_OP_USD = 3,
	SEG6_LOCAL_FLV_OP_NEXT_CSID = 4,
	__SEG6_LOCAL_FLV_OP_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_UNSPEC = 0,
	SEG6_LOCAL_FLV_OPERATION = 1,
	SEG6_LOCAL_FLV_LCBLOCK_BITS = 2,
	SEG6_LOCAL_FLV_LCNODE_FN_BITS = 3,
	__SEG6_LOCAL_FLV_MAX = 4,
};

enum {
	SEG6_LOCAL_UNSPEC = 0,
	SEG6_LOCAL_ACTION = 1,
	SEG6_LOCAL_SRH = 2,
	SEG6_LOCAL_TABLE = 3,
	SEG6_LOCAL_NH4 = 4,
	SEG6_LOCAL_NH6 = 5,
	SEG6_LOCAL_IIF = 6,
	SEG6_LOCAL_OIF = 7,
	SEG6_LOCAL_BPF = 8,
	SEG6_LOCAL_VRFTABLE = 9,
	SEG6_LOCAL_COUNTERS = 10,
	SEG6_LOCAL_FLAVORS = 11,
	__SEG6_LOCAL_MAX = 12,
};

enum {
	SELNL_MSG_SETENFORCE = 16,
	SELNL_MSG_POLICYLOAD = 17,
	SELNL_MSG_MAX = 18,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

enum {
	SKCIPHER_WALK_PHYS = 1,
	SKCIPHER_WALK_SLOW = 2,
	SKCIPHER_WALK_COPY = 4,
	SKCIPHER_WALK_DIFF = 8,
	SKCIPHER_WALK_SLEEP = 16,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SM_EFUSE_READ = 0,
	SM_EFUSE_WRITE = 1,
	SM_EFUSE_USER_MAX = 2,
	SM_GET_CHIP_ID = 3,
	SM_A1_PWRC_SET = 4,
	SM_A1_PWRC_GET = 5,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_LAST = 131072,
	SOF_TIMESTAMPING_MASK = 262143,
};

enum {
	STMPE_IDX_CHIP_ID = 0,
	STMPE_IDX_SYS_CTRL = 1,
	STMPE_IDX_SYS_CTRL2 = 2,
	STMPE_IDX_ICR_LSB = 3,
	STMPE_IDX_IER_LSB = 4,
	STMPE_IDX_IER_MSB = 5,
	STMPE_IDX_ISR_LSB = 6,
	STMPE_IDX_ISR_MSB = 7,
	STMPE_IDX_GPMR_LSB = 8,
	STMPE_IDX_GPMR_CSB = 9,
	STMPE_IDX_GPMR_MSB = 10,
	STMPE_IDX_GPSR_LSB = 11,
	STMPE_IDX_GPSR_CSB = 12,
	STMPE_IDX_GPSR_MSB = 13,
	STMPE_IDX_GPCR_LSB = 14,
	STMPE_IDX_GPCR_CSB = 15,
	STMPE_IDX_GPCR_MSB = 16,
	STMPE_IDX_GPDR_LSB = 17,
	STMPE_IDX_GPDR_CSB = 18,
	STMPE_IDX_GPDR_MSB = 19,
	STMPE_IDX_GPEDR_LSB = 20,
	STMPE_IDX_GPEDR_CSB = 21,
	STMPE_IDX_GPEDR_MSB = 22,
	STMPE_IDX_GPRER_LSB = 23,
	STMPE_IDX_GPRER_CSB = 24,
	STMPE_IDX_GPRER_MSB = 25,
	STMPE_IDX_GPFER_LSB = 26,
	STMPE_IDX_GPFER_CSB = 27,
	STMPE_IDX_GPFER_MSB = 28,
	STMPE_IDX_GPPUR_LSB = 29,
	STMPE_IDX_GPPDR_LSB = 30,
	STMPE_IDX_GPAFR_U_MSB = 31,
	STMPE_IDX_IEGPIOR_LSB = 32,
	STMPE_IDX_IEGPIOR_CSB = 33,
	STMPE_IDX_IEGPIOR_MSB = 34,
	STMPE_IDX_ISGPIOR_LSB = 35,
	STMPE_IDX_ISGPIOR_CSB = 36,
	STMPE_IDX_ISGPIOR_MSB = 37,
	STMPE_IDX_MAX = 38,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SUN_WHOLE_DISK = 5,
	LINUX_RAID_PARTITION___2 = 253,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
	SWP_SCANNING = 16384,
};

enum {
	SYNTH_ERR_BAD_NAME = 0,
	SYNTH_ERR_INVALID_CMD = 1,
	SYNTH_ERR_INVALID_DYN_CMD = 2,
	SYNTH_ERR_EVENT_EXISTS = 3,
	SYNTH_ERR_TOO_MANY_FIELDS = 4,
	SYNTH_ERR_INCOMPLETE_TYPE = 5,
	SYNTH_ERR_INVALID_TYPE = 6,
	SYNTH_ERR_INVALID_FIELD = 7,
	SYNTH_ERR_INVALID_ARRAY_SPEC = 8,
};

enum {
	SYSTAB = 0,
	MMBASE = 1,
	MMSIZE = 2,
	DCSIZE = 3,
	DCVERS = 4,
	PARAMCOUNT = 5,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_CGROUP_UNSPEC = 0,
	TCA_CGROUP_ACT = 1,
	TCA_CGROUP_POLICE = 2,
	TCA_CGROUP_EMATCHES = 3,
	__TCA_CGROUP_MAX = 4,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_FQ_CODEL_UNSPEC = 0,
	TCA_FQ_CODEL_TARGET = 1,
	TCA_FQ_CODEL_LIMIT = 2,
	TCA_FQ_CODEL_INTERVAL = 3,
	TCA_FQ_CODEL_ECN = 4,
	TCA_FQ_CODEL_FLOWS = 5,
	TCA_FQ_CODEL_QUANTUM = 6,
	TCA_FQ_CODEL_CE_THRESHOLD = 7,
	TCA_FQ_CODEL_DROP_BATCH_SIZE = 8,
	TCA_FQ_CODEL_MEMORY_LIMIT = 9,
	TCA_FQ_CODEL_CE_THRESHOLD_SELECTOR = 10,
	TCA_FQ_CODEL_CE_THRESHOLD_MASK = 11,
	__TCA_FQ_CODEL_MAX = 12,
};

enum {
	TCA_FQ_CODEL_XSTATS_QDISC = 0,
	TCA_FQ_CODEL_XSTATS_CLASS = 1,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCG_SECP_00 = 0,
	TCG_SECP_01 = 1,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 15,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TEGRA_PIN_CAN0_DOUT_PAA0 = 0,
	TEGRA_PIN_CAN0_DIN_PAA1 = 1,
	TEGRA_PIN_CAN1_DOUT_PAA2 = 2,
	TEGRA_PIN_CAN1_DIN_PAA3 = 3,
	TEGRA_PIN_CAN0_STB_PAA4 = 4,
	TEGRA_PIN_CAN0_EN_PAA5 = 5,
	TEGRA_PIN_SOC_GPIO49_PAA6 = 6,
	TEGRA_PIN_CAN0_ERR_PAA7 = 7,
	TEGRA_PIN_CAN1_STB_PBB0 = 8,
	TEGRA_PIN_CAN1_EN_PBB1 = 9,
	TEGRA_PIN_SOC_GPIO50_PBB2 = 10,
	TEGRA_PIN_CAN1_ERR_PBB3 = 11,
	TEGRA_PIN_SPI2_SCK_PCC0 = 12,
	TEGRA_PIN_SPI2_MISO_PCC1 = 13,
	TEGRA_PIN_SPI2_MOSI_PCC2 = 14,
	TEGRA_PIN_SPI2_CS0_PCC3 = 15,
	TEGRA_PIN_TOUCH_CLK_PCC4 = 16,
	TEGRA_PIN_UART3_TX_PCC5 = 17,
	TEGRA_PIN_UART3_RX_PCC6 = 18,
	TEGRA_PIN_GEN2_I2C_SCL_PCC7 = 19,
	TEGRA_PIN_GEN2_I2C_SDA_PDD0 = 20,
	TEGRA_PIN_GEN8_I2C_SCL_PDD1 = 21,
	TEGRA_PIN_GEN8_I2C_SDA_PDD2 = 22,
	TEGRA_PIN_SCE_ERROR_PEE0 = 23,
	TEGRA_PIN_VCOMP_ALERT_PEE1 = 24,
	TEGRA_PIN_AO_RETENTION_N_PEE2 = 25,
	TEGRA_PIN_BATT_OC_PEE3 = 26,
	TEGRA_PIN_POWER_ON_PEE4 = 27,
	TEGRA_PIN_SOC_GPIO26_PEE5 = 28,
	TEGRA_PIN_SOC_GPIO27_PEE6 = 29,
	TEGRA_PIN_BOOTV_CTL_N_PEE7 = 30,
	TEGRA_PIN_HDMI_CEC_PGG0 = 31,
};

enum {
	TEGRA_PIN_CAN1_DOUT_PAA0 = 0,
	TEGRA_PIN_CAN1_DIN_PAA1 = 1,
	TEGRA_PIN_CAN0_DOUT_PAA2 = 2,
	TEGRA_PIN_CAN0_DIN_PAA3 = 3,
	TEGRA_PIN_CAN0_STB_PAA4___2 = 4,
	TEGRA_PIN_CAN0_EN_PAA5___2 = 5,
	TEGRA_PIN_CAN0_WAKE_PAA6 = 6,
	TEGRA_PIN_CAN0_ERR_PAA7___2 = 7,
	TEGRA_PIN_CAN1_STB_PBB0___2 = 8,
	TEGRA_PIN_CAN1_EN_PBB1___2 = 9,
	TEGRA_PIN_CAN1_WAKE_PBB2 = 10,
	TEGRA_PIN_CAN1_ERR_PBB3___2 = 11,
	TEGRA_PIN_SPI2_SCK_PCC0___2 = 12,
	TEGRA_PIN_SPI2_MISO_PCC1___2 = 13,
	TEGRA_PIN_SPI2_MOSI_PCC2___2 = 14,
	TEGRA_PIN_SPI2_CS0_PCC3___2 = 15,
	TEGRA_PIN_TOUCH_CLK_PCC4___2 = 16,
	TEGRA_PIN_UART3_TX_PCC5___2 = 17,
	TEGRA_PIN_UART3_RX_PCC6___2 = 18,
	TEGRA_PIN_GEN2_I2C_SCL_PCC7___2 = 19,
	TEGRA_PIN_GEN2_I2C_SDA_PDD0___2 = 20,
	TEGRA_PIN_GEN8_I2C_SCL_PDD1___2 = 21,
	TEGRA_PIN_GEN8_I2C_SDA_PDD2___2 = 22,
	TEGRA_PIN_SAFE_STATE_PEE0 = 23,
	TEGRA_PIN_VCOMP_ALERT_PEE1___2 = 24,
	TEGRA_PIN_AO_RETENTION_N_PEE2___2 = 25,
	TEGRA_PIN_BATT_OC_PEE3___2 = 26,
	TEGRA_PIN_POWER_ON_PEE4___2 = 27,
	TEGRA_PIN_PWR_I2C_SCL_PEE5 = 28,
	TEGRA_PIN_PWR_I2C_SDA_PEE6 = 29,
	TEGRA_PIN_SYS_RESET_N = 30,
	TEGRA_PIN_SHUTDOWN_N = 31,
	TEGRA_PIN_PMU_INT_N = 32,
	TEGRA_PIN_SOC_PWR_REQ = 33,
	TEGRA_PIN_CLK_32K_IN = 34,
};

enum {
	TEGRA_PIN_DAP6_SCLK_PA0 = 0,
	TEGRA_PIN_DAP6_DOUT_PA1 = 1,
	TEGRA_PIN_DAP6_DIN_PA2 = 2,
	TEGRA_PIN_DAP6_FS_PA3 = 3,
	TEGRA_PIN_DAP4_SCLK_PA4 = 4,
	TEGRA_PIN_DAP4_DOUT_PA5 = 5,
	TEGRA_PIN_DAP4_DIN_PA6 = 6,
	TEGRA_PIN_DAP4_FS_PA7 = 7,
	TEGRA_PIN_SOC_GPIO08_PB0 = 8,
	TEGRA_PIN_QSPI0_SCK_PC0 = 9,
	TEGRA_PIN_QSPI0_CS_N_PC1 = 10,
	TEGRA_PIN_QSPI0_IO0_PC2 = 11,
	TEGRA_PIN_QSPI0_IO1_PC3 = 12,
	TEGRA_PIN_QSPI0_IO2_PC4 = 13,
	TEGRA_PIN_QSPI0_IO3_PC5 = 14,
	TEGRA_PIN_QSPI1_SCK_PC6 = 15,
	TEGRA_PIN_QSPI1_CS_N_PC7 = 16,
	TEGRA_PIN_QSPI1_IO0_PD0 = 17,
	TEGRA_PIN_QSPI1_IO1_PD1 = 18,
	TEGRA_PIN_QSPI1_IO2_PD2 = 19,
	TEGRA_PIN_QSPI1_IO3_PD3 = 20,
	TEGRA_PIN_EQOS_TXC_PE0 = 21,
	TEGRA_PIN_EQOS_TD0_PE1 = 22,
	TEGRA_PIN_EQOS_TD1_PE2 = 23,
	TEGRA_PIN_EQOS_TD2_PE3 = 24,
	TEGRA_PIN_EQOS_TD3_PE4 = 25,
	TEGRA_PIN_EQOS_TX_CTL_PE5 = 26,
	TEGRA_PIN_EQOS_RD0_PE6 = 27,
	TEGRA_PIN_EQOS_RD1_PE7 = 28,
	TEGRA_PIN_EQOS_RD2_PF0 = 29,
	TEGRA_PIN_EQOS_RD3_PF1 = 30,
	TEGRA_PIN_EQOS_RX_CTL_PF2 = 31,
	TEGRA_PIN_EQOS_RXC_PF3 = 32,
	TEGRA_PIN_EQOS_SMA_MDIO_PF4 = 33,
	TEGRA_PIN_EQOS_SMA_MDC_PF5 = 34,
	TEGRA_PIN_SOC_GPIO13_PG0 = 35,
	TEGRA_PIN_SOC_GPIO14_PG1 = 36,
	TEGRA_PIN_SOC_GPIO15_PG2 = 37,
	TEGRA_PIN_SOC_GPIO16_PG3 = 38,
	TEGRA_PIN_SOC_GPIO17_PG4 = 39,
	TEGRA_PIN_SOC_GPIO18_PG5 = 40,
	TEGRA_PIN_SOC_GPIO19_PG6 = 41,
	TEGRA_PIN_SOC_GPIO20_PG7 = 42,
	TEGRA_PIN_SOC_GPIO21_PH0 = 43,
	TEGRA_PIN_SOC_GPIO22_PH1 = 44,
	TEGRA_PIN_SOC_GPIO06_PH2 = 45,
	TEGRA_PIN_UART4_TX_PH3 = 46,
	TEGRA_PIN_UART4_RX_PH4 = 47,
	TEGRA_PIN_UART4_RTS_PH5 = 48,
	TEGRA_PIN_UART4_CTS_PH6 = 49,
	TEGRA_PIN_SOC_GPIO41_PH7 = 50,
	TEGRA_PIN_SOC_GPIO42_PI0 = 51,
	TEGRA_PIN_SOC_GPIO43_PI1 = 52,
	TEGRA_PIN_SOC_GPIO44_PI2 = 53,
	TEGRA_PIN_GEN1_I2C_SCL_PI3 = 54,
	TEGRA_PIN_GEN1_I2C_SDA_PI4 = 55,
	TEGRA_PIN_CPU_PWR_REQ_PI5 = 56,
	TEGRA_PIN_SOC_GPIO07_PI6 = 57,
	TEGRA_PIN_SDMMC1_CLK_PJ0 = 58,
	TEGRA_PIN_SDMMC1_CMD_PJ1 = 59,
	TEGRA_PIN_SDMMC1_DAT0_PJ2 = 60,
	TEGRA_PIN_SDMMC1_DAT1_PJ3 = 61,
	TEGRA_PIN_SDMMC1_DAT2_PJ4 = 62,
	TEGRA_PIN_SDMMC1_DAT3_PJ5 = 63,
	TEGRA_PIN_PEX_L0_CLKREQ_N_PK0 = 64,
	TEGRA_PIN_PEX_L0_RST_N_PK1 = 65,
	TEGRA_PIN_PEX_L1_CLKREQ_N_PK2 = 66,
	TEGRA_PIN_PEX_L1_RST_N_PK3 = 67,
	TEGRA_PIN_PEX_L2_CLKREQ_N_PK4 = 68,
	TEGRA_PIN_PEX_L2_RST_N_PK5 = 69,
	TEGRA_PIN_PEX_L3_CLKREQ_N_PK6 = 70,
	TEGRA_PIN_PEX_L3_RST_N_PK7 = 71,
	TEGRA_PIN_PEX_L4_CLKREQ_N_PL0 = 72,
	TEGRA_PIN_PEX_L4_RST_N_PL1 = 73,
	TEGRA_PIN_PEX_WAKE_N_PL2 = 74,
	TEGRA_PIN_SOC_GPIO34_PL3 = 75,
	TEGRA_PIN_DP_AUX_CH0_HPD_PM0 = 76,
	TEGRA_PIN_DP_AUX_CH1_HPD_PM1 = 77,
	TEGRA_PIN_DP_AUX_CH2_HPD_PM2 = 78,
	TEGRA_PIN_DP_AUX_CH3_HPD_PM3 = 79,
	TEGRA_PIN_SOC_GPIO55_PM4 = 80,
	TEGRA_PIN_SOC_GPIO36_PM5 = 81,
	TEGRA_PIN_SOC_GPIO53_PM6 = 82,
	TEGRA_PIN_SOC_GPIO38_PM7 = 83,
	TEGRA_PIN_DP_AUX_CH3_N_PN0 = 84,
	TEGRA_PIN_SOC_GPIO39_PN1 = 85,
	TEGRA_PIN_SOC_GPIO40_PN2 = 86,
	TEGRA_PIN_DP_AUX_CH1_P_PN3 = 87,
	TEGRA_PIN_DP_AUX_CH1_N_PN4 = 88,
	TEGRA_PIN_DP_AUX_CH2_P_PN5 = 89,
	TEGRA_PIN_DP_AUX_CH2_N_PN6 = 90,
	TEGRA_PIN_DP_AUX_CH3_P_PN7 = 91,
	TEGRA_PIN_EXTPERIPH1_CLK_PP0 = 92,
	TEGRA_PIN_EXTPERIPH2_CLK_PP1 = 93,
	TEGRA_PIN_CAM_I2C_SCL_PP2 = 94,
	TEGRA_PIN_CAM_I2C_SDA_PP3 = 95,
	TEGRA_PIN_SOC_GPIO23_PP4 = 96,
	TEGRA_PIN_SOC_GPIO24_PP5 = 97,
	TEGRA_PIN_SOC_GPIO25_PP6 = 98,
	TEGRA_PIN_PWR_I2C_SCL_PP7 = 99,
	TEGRA_PIN_PWR_I2C_SDA_PQ0 = 100,
	TEGRA_PIN_SOC_GPIO28_PQ1 = 101,
	TEGRA_PIN_SOC_GPIO29_PQ2 = 102,
	TEGRA_PIN_SOC_GPIO30_PQ3 = 103,
	TEGRA_PIN_SOC_GPIO31_PQ4 = 104,
	TEGRA_PIN_SOC_GPIO32_PQ5 = 105,
	TEGRA_PIN_SOC_GPIO33_PQ6 = 106,
	TEGRA_PIN_SOC_GPIO35_PQ7 = 107,
	TEGRA_PIN_SOC_GPIO37_PR0 = 108,
	TEGRA_PIN_SOC_GPIO56_PR1 = 109,
	TEGRA_PIN_UART1_TX_PR2 = 110,
	TEGRA_PIN_UART1_RX_PR3 = 111,
	TEGRA_PIN_UART1_RTS_PR4 = 112,
	TEGRA_PIN_UART1_CTS_PR5 = 113,
	TEGRA_PIN_GPU_PWR_REQ_PX0 = 114,
	TEGRA_PIN_CV_PWR_REQ_PX1 = 115,
	TEGRA_PIN_GP_PWM2_PX2 = 116,
	TEGRA_PIN_GP_PWM3_PX3 = 117,
	TEGRA_PIN_UART2_TX_PX4 = 118,
	TEGRA_PIN_UART2_RX_PX5 = 119,
	TEGRA_PIN_UART2_RTS_PX6 = 120,
	TEGRA_PIN_UART2_CTS_PX7 = 121,
	TEGRA_PIN_SPI3_SCK_PY0 = 122,
	TEGRA_PIN_SPI3_MISO_PY1 = 123,
	TEGRA_PIN_SPI3_MOSI_PY2 = 124,
	TEGRA_PIN_SPI3_CS0_PY3 = 125,
	TEGRA_PIN_SPI3_CS1_PY4 = 126,
	TEGRA_PIN_UART5_TX_PY5 = 127,
	TEGRA_PIN_UART5_RX_PY6 = 128,
	TEGRA_PIN_UART5_RTS_PY7 = 129,
	TEGRA_PIN_UART5_CTS_PZ0 = 130,
	TEGRA_PIN_USB_VBUS_EN0_PZ1 = 131,
	TEGRA_PIN_USB_VBUS_EN1_PZ2 = 132,
	TEGRA_PIN_SPI1_SCK_PZ3 = 133,
	TEGRA_PIN_SPI1_MISO_PZ4 = 134,
	TEGRA_PIN_SPI1_MOSI_PZ5 = 135,
	TEGRA_PIN_SPI1_CS0_PZ6 = 136,
	TEGRA_PIN_SPI1_CS1_PZ7 = 137,
	TEGRA_PIN_SPI5_SCK_PAC0 = 138,
	TEGRA_PIN_SPI5_MISO_PAC1 = 139,
	TEGRA_PIN_SPI5_MOSI_PAC2 = 140,
	TEGRA_PIN_SPI5_CS0_PAC3 = 141,
	TEGRA_PIN_SOC_GPIO57_PAC4 = 142,
	TEGRA_PIN_SOC_GPIO58_PAC5 = 143,
	TEGRA_PIN_SOC_GPIO59_PAC6 = 144,
	TEGRA_PIN_SOC_GPIO60_PAC7 = 145,
	TEGRA_PIN_SOC_GPIO45_PAD0 = 146,
	TEGRA_PIN_SOC_GPIO46_PAD1 = 147,
	TEGRA_PIN_SOC_GPIO47_PAD2 = 148,
	TEGRA_PIN_SOC_GPIO48_PAD3 = 149,
	TEGRA_PIN_UFS0_REF_CLK_PAE0 = 150,
	TEGRA_PIN_UFS0_RST_N_PAE1 = 151,
	TEGRA_PIN_PEX_L5_CLKREQ_N_PAF0 = 152,
	TEGRA_PIN_PEX_L5_RST_N_PAF1 = 153,
	TEGRA_PIN_PEX_L6_CLKREQ_N_PAF2 = 154,
	TEGRA_PIN_PEX_L6_RST_N_PAF3 = 155,
	TEGRA_PIN_PEX_L7_CLKREQ_N_PAG0 = 156,
	TEGRA_PIN_PEX_L7_RST_N_PAG1 = 157,
	TEGRA_PIN_PEX_L8_CLKREQ_N_PAG2 = 158,
	TEGRA_PIN_PEX_L8_RST_N_PAG3 = 159,
	TEGRA_PIN_PEX_L9_CLKREQ_N_PAG4 = 160,
	TEGRA_PIN_PEX_L9_RST_N_PAG5 = 161,
	TEGRA_PIN_PEX_L10_CLKREQ_N_PAG6 = 162,
	TEGRA_PIN_PEX_L10_RST_N_PAG7 = 163,
	TEGRA_PIN_EQOS_COMP = 164,
	TEGRA_PIN_QSPI_COMP = 165,
	TEGRA_PIN_SDMMC1_COMP = 166,
};

enum {
	TEGRA_PIN_DAP6_SCLK_PA0___2 = 0,
	TEGRA_PIN_DAP6_DOUT_PA1___2 = 1,
	TEGRA_PIN_DAP6_DIN_PA2___2 = 2,
	TEGRA_PIN_DAP6_FS_PA3___2 = 3,
	TEGRA_PIN_DAP4_SCLK_PA4___2 = 4,
	TEGRA_PIN_DAP4_DOUT_PA5___2 = 5,
	TEGRA_PIN_DAP4_DIN_PA6___2 = 6,
	TEGRA_PIN_DAP4_FS_PA7___2 = 7,
	TEGRA_PIN_CPU_PWR_REQ_0_PB0 = 8,
	TEGRA_PIN_CPU_PWR_REQ_1_PB1 = 9,
	TEGRA_PIN_QSPI0_SCK_PC0___2 = 10,
	TEGRA_PIN_QSPI0_CS_N_PC1___2 = 11,
	TEGRA_PIN_QSPI0_IO0_PC2___2 = 12,
	TEGRA_PIN_QSPI0_IO1_PC3___2 = 13,
	TEGRA_PIN_QSPI0_IO2_PC4___2 = 14,
	TEGRA_PIN_QSPI0_IO3_PC5___2 = 15,
	TEGRA_PIN_QSPI1_SCK_PC6___2 = 16,
	TEGRA_PIN_QSPI1_CS_N_PC7___2 = 17,
	TEGRA_PIN_QSPI1_IO0_PD0___2 = 18,
	TEGRA_PIN_QSPI1_IO1_PD1___2 = 19,
	TEGRA_PIN_QSPI1_IO2_PD2___2 = 20,
	TEGRA_PIN_QSPI1_IO3_PD3___2 = 21,
	TEGRA_PIN_EQOS_TXC_PE0___2 = 22,
	TEGRA_PIN_EQOS_TD0_PE1___2 = 23,
	TEGRA_PIN_EQOS_TD1_PE2___2 = 24,
	TEGRA_PIN_EQOS_TD2_PE3___2 = 25,
	TEGRA_PIN_EQOS_TD3_PE4___2 = 26,
	TEGRA_PIN_EQOS_TX_CTL_PE5___2 = 27,
	TEGRA_PIN_EQOS_RD0_PE6___2 = 28,
	TEGRA_PIN_EQOS_RD1_PE7___2 = 29,
	TEGRA_PIN_EQOS_RD2_PF0___2 = 30,
	TEGRA_PIN_EQOS_RD3_PF1___2 = 31,
	TEGRA_PIN_EQOS_RX_CTL_PF2___2 = 32,
	TEGRA_PIN_EQOS_RXC_PF3___2 = 33,
	TEGRA_PIN_EQOS_SMA_MDIO_PF4___2 = 34,
	TEGRA_PIN_EQOS_SMA_MDC_PF5___2 = 35,
	TEGRA_PIN_SOC_GPIO00_PG0 = 36,
	TEGRA_PIN_SOC_GPIO01_PG1 = 37,
	TEGRA_PIN_SOC_GPIO02_PG2 = 38,
	TEGRA_PIN_SOC_GPIO03_PG3 = 39,
	TEGRA_PIN_SOC_GPIO08_PG4 = 40,
	TEGRA_PIN_SOC_GPIO09_PG5 = 41,
	TEGRA_PIN_SOC_GPIO10_PG6 = 42,
	TEGRA_PIN_SOC_GPIO11_PG7 = 43,
	TEGRA_PIN_SOC_GPIO12_PH0 = 44,
	TEGRA_PIN_SOC_GPIO13_PH1 = 45,
	TEGRA_PIN_SOC_GPIO14_PH2 = 46,
	TEGRA_PIN_UART4_TX_PH3___2 = 47,
	TEGRA_PIN_UART4_RX_PH4___2 = 48,
	TEGRA_PIN_UART4_RTS_PH5___2 = 49,
	TEGRA_PIN_UART4_CTS_PH6___2 = 50,
	TEGRA_PIN_DAP2_SCLK_PH7 = 51,
	TEGRA_PIN_DAP2_DOUT_PI0 = 52,
	TEGRA_PIN_DAP2_DIN_PI1 = 53,
	TEGRA_PIN_DAP2_FS_PI2 = 54,
	TEGRA_PIN_GEN1_I2C_SCL_PI3___2 = 55,
	TEGRA_PIN_GEN1_I2C_SDA_PI4___2 = 56,
	TEGRA_PIN_SDMMC1_CLK_PJ0___2 = 57,
	TEGRA_PIN_SDMMC1_CMD_PJ1___2 = 58,
	TEGRA_PIN_SDMMC1_DAT0_PJ2___2 = 59,
	TEGRA_PIN_SDMMC1_DAT1_PJ3___2 = 60,
	TEGRA_PIN_SDMMC1_DAT2_PJ4___2 = 61,
	TEGRA_PIN_SDMMC1_DAT3_PJ5___2 = 62,
	TEGRA_PIN_PEX_L0_CLKREQ_N_PK0___2 = 63,
	TEGRA_PIN_PEX_L0_RST_N_PK1___2 = 64,
	TEGRA_PIN_PEX_L1_CLKREQ_N_PK2___2 = 65,
	TEGRA_PIN_PEX_L1_RST_N_PK3___2 = 66,
	TEGRA_PIN_PEX_L2_CLKREQ_N_PK4___2 = 67,
	TEGRA_PIN_PEX_L2_RST_N_PK5___2 = 68,
	TEGRA_PIN_PEX_L3_CLKREQ_N_PK6___2 = 69,
	TEGRA_PIN_PEX_L3_RST_N_PK7___2 = 70,
	TEGRA_PIN_PEX_L4_CLKREQ_N_PL0___2 = 71,
	TEGRA_PIN_PEX_L4_RST_N_PL1___2 = 72,
	TEGRA_PIN_PEX_WAKE_N_PL2___2 = 73,
	TEGRA_PIN_SATA_DEV_SLP_PL3 = 74,
	TEGRA_PIN_DP_AUX_CH0_HPD_PM0___2 = 75,
	TEGRA_PIN_DP_AUX_CH1_HPD_PM1___2 = 76,
	TEGRA_PIN_DP_AUX_CH2_HPD_PM2___2 = 77,
	TEGRA_PIN_DP_AUX_CH3_HPD_PM3___2 = 78,
	TEGRA_PIN_HDMI_CEC_PM4 = 79,
	TEGRA_PIN_SOC_GPIO50_PM5 = 80,
	TEGRA_PIN_SOC_GPIO51_PM6 = 81,
	TEGRA_PIN_SOC_GPIO52_PM7 = 82,
	TEGRA_PIN_SOC_GPIO53_PN0 = 83,
	TEGRA_PIN_SOC_GPIO54_PN1 = 84,
	TEGRA_PIN_SOC_GPIO55_PN2 = 85,
	TEGRA_PIN_SDMMC3_CLK_PO0 = 86,
	TEGRA_PIN_SDMMC3_CMD_PO1 = 87,
	TEGRA_PIN_SDMMC3_DAT0_PO2 = 88,
	TEGRA_PIN_SDMMC3_DAT1_PO3 = 89,
	TEGRA_PIN_SDMMC3_DAT2_PO4 = 90,
	TEGRA_PIN_SDMMC3_DAT3_PO5 = 91,
	TEGRA_PIN_EXTPERIPH1_CLK_PP0___2 = 92,
	TEGRA_PIN_EXTPERIPH2_CLK_PP1___2 = 93,
	TEGRA_PIN_CAM_I2C_SCL_PP2___2 = 94,
	TEGRA_PIN_CAM_I2C_SDA_PP3___2 = 95,
	TEGRA_PIN_SOC_GPIO04_PP4 = 96,
	TEGRA_PIN_SOC_GPIO05_PP5 = 97,
	TEGRA_PIN_SOC_GPIO06_PP6 = 98,
	TEGRA_PIN_SOC_GPIO07_PP7 = 99,
	TEGRA_PIN_SOC_GPIO20_PQ0 = 100,
	TEGRA_PIN_SOC_GPIO21_PQ1 = 101,
	TEGRA_PIN_SOC_GPIO22_PQ2 = 102,
	TEGRA_PIN_SOC_GPIO23_PQ3 = 103,
	TEGRA_PIN_SOC_GPIO40_PQ4 = 104,
	TEGRA_PIN_SOC_GPIO41_PQ5 = 105,
	TEGRA_PIN_SOC_GPIO42_PQ6 = 106,
	TEGRA_PIN_SOC_GPIO43_PQ7 = 107,
	TEGRA_PIN_SOC_GPIO44_PR0 = 108,
	TEGRA_PIN_SOC_GPIO45_PR1 = 109,
	TEGRA_PIN_UART1_TX_PR2___2 = 110,
	TEGRA_PIN_UART1_RX_PR3___2 = 111,
	TEGRA_PIN_UART1_RTS_PR4___2 = 112,
	TEGRA_PIN_UART1_CTS_PR5___2 = 113,
	TEGRA_PIN_DAP1_SCLK_PS0 = 114,
	TEGRA_PIN_DAP1_DOUT_PS1 = 115,
	TEGRA_PIN_DAP1_DIN_PS2 = 116,
	TEGRA_PIN_DAP1_FS_PS3 = 117,
	TEGRA_PIN_AUD_MCLK_PS4 = 118,
	TEGRA_PIN_SOC_GPIO30_PS5 = 119,
	TEGRA_PIN_SOC_GPIO31_PS6 = 120,
	TEGRA_PIN_SOC_GPIO32_PS7 = 121,
	TEGRA_PIN_SOC_GPIO33_PT0 = 122,
	TEGRA_PIN_DAP3_SCLK_PT1 = 123,
	TEGRA_PIN_DAP3_DOUT_PT2 = 124,
	TEGRA_PIN_DAP3_DIN_PT3 = 125,
	TEGRA_PIN_DAP3_FS_PT4 = 126,
	TEGRA_PIN_DAP5_SCLK_PT5 = 127,
	TEGRA_PIN_DAP5_DOUT_PT6 = 128,
	TEGRA_PIN_DAP5_DIN_PT7 = 129,
	TEGRA_PIN_DAP5_FS_PU0 = 130,
	TEGRA_PIN_DIRECTDC1_CLK_PV0 = 131,
	TEGRA_PIN_DIRECTDC1_IN_PV1 = 132,
	TEGRA_PIN_DIRECTDC1_OUT0_PV2 = 133,
	TEGRA_PIN_DIRECTDC1_OUT1_PV3 = 134,
	TEGRA_PIN_DIRECTDC1_OUT2_PV4 = 135,
	TEGRA_PIN_DIRECTDC1_OUT3_PV5 = 136,
	TEGRA_PIN_DIRECTDC1_OUT4_PV6 = 137,
	TEGRA_PIN_DIRECTDC1_OUT5_PV7 = 138,
	TEGRA_PIN_DIRECTDC1_OUT6_PW0 = 139,
	TEGRA_PIN_DIRECTDC1_OUT7_PW1 = 140,
	TEGRA_PIN_GPU_PWR_REQ_PX0___2 = 141,
	TEGRA_PIN_CV_PWR_REQ_PX1___2 = 142,
	TEGRA_PIN_GP_PWM2_PX2___2 = 143,
	TEGRA_PIN_GP_PWM3_PX3___2 = 144,
	TEGRA_PIN_UART2_TX_PX4___2 = 145,
	TEGRA_PIN_UART2_RX_PX5___2 = 146,
	TEGRA_PIN_UART2_RTS_PX6___2 = 147,
	TEGRA_PIN_UART2_CTS_PX7___2 = 148,
	TEGRA_PIN_SPI3_SCK_PY0___2 = 149,
	TEGRA_PIN_SPI3_MISO_PY1___2 = 150,
	TEGRA_PIN_SPI3_MOSI_PY2___2 = 151,
	TEGRA_PIN_SPI3_CS0_PY3___2 = 152,
	TEGRA_PIN_SPI3_CS1_PY4___2 = 153,
	TEGRA_PIN_UART5_TX_PY5___2 = 154,
	TEGRA_PIN_UART5_RX_PY6___2 = 155,
	TEGRA_PIN_UART5_RTS_PY7___2 = 156,
	TEGRA_PIN_UART5_CTS_PZ0___2 = 157,
	TEGRA_PIN_USB_VBUS_EN0_PZ1___2 = 158,
	TEGRA_PIN_USB_VBUS_EN1_PZ2___2 = 159,
	TEGRA_PIN_SPI1_SCK_PZ3___2 = 160,
	TEGRA_PIN_SPI1_MISO_PZ4___2 = 161,
	TEGRA_PIN_SPI1_MOSI_PZ5___2 = 162,
	TEGRA_PIN_SPI1_CS0_PZ6___2 = 163,
	TEGRA_PIN_SPI1_CS1_PZ7___2 = 164,
	TEGRA_PIN_UFS0_REF_CLK_PFF0 = 165,
	TEGRA_PIN_UFS0_RST_PFF1 = 166,
	TEGRA_PIN_PEX_L5_CLKREQ_N_PGG0 = 167,
	TEGRA_PIN_PEX_L5_RST_N_PGG1 = 168,
	TEGRA_PIN_DIRECTDC_COMP = 169,
	TEGRA_PIN_SDMMC4_CLK = 170,
	TEGRA_PIN_SDMMC4_CMD = 171,
	TEGRA_PIN_SDMMC4_DQS = 172,
	TEGRA_PIN_SDMMC4_DAT7 = 173,
	TEGRA_PIN_SDMMC4_DAT6 = 174,
	TEGRA_PIN_SDMMC4_DAT5 = 175,
	TEGRA_PIN_SDMMC4_DAT4 = 176,
	TEGRA_PIN_SDMMC4_DAT3 = 177,
	TEGRA_PIN_SDMMC4_DAT2 = 178,
	TEGRA_PIN_SDMMC4_DAT1 = 179,
	TEGRA_PIN_SDMMC4_DAT0 = 180,
	TEGRA_PIN_SDMMC1_COMP___2 = 181,
	TEGRA_PIN_SDMMC1_HV_TRIM = 182,
	TEGRA_PIN_SDMMC3_COMP = 183,
	TEGRA_PIN_SDMMC3_HV_TRIM = 184,
	TEGRA_PIN_EQOS_COMP___2 = 185,
	TEGRA_PIN_QSPI_COMP___2 = 186,
};

enum {
	TEST_ALIGNMENT = 16,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	THRESHOLD_INDEX_0 = 0,
	THRESHOLD_INDEX_1 = 1,
	THRESHOLD_INDEX_COUNT = 2,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_ADDR_SUFFIX = 13,
	TP_ERR_NO_GROUP_NAME = 14,
	TP_ERR_GROUP_TOO_LONG = 15,
	TP_ERR_BAD_GROUP_NAME = 16,
	TP_ERR_NO_EVENT_NAME = 17,
	TP_ERR_EVENT_TOO_LONG = 18,
	TP_ERR_BAD_EVENT_NAME = 19,
	TP_ERR_EVENT_EXIST = 20,
	TP_ERR_RETVAL_ON_PROBE = 21,
	TP_ERR_NO_RETVAL = 22,
	TP_ERR_BAD_STACK_NUM = 23,
	TP_ERR_BAD_ARG_NUM = 24,
	TP_ERR_BAD_VAR = 25,
	TP_ERR_BAD_REG_NAME = 26,
	TP_ERR_BAD_MEM_ADDR = 27,
	TP_ERR_BAD_IMM = 28,
	TP_ERR_IMMSTR_NO_CLOSE = 29,
	TP_ERR_FILE_ON_KPROBE = 30,
	TP_ERR_BAD_FILE_OFFS = 31,
	TP_ERR_SYM_ON_UPROBE = 32,
	TP_ERR_TOO_MANY_OPS = 33,
	TP_ERR_DEREF_NEED_BRACE = 34,
	TP_ERR_BAD_DEREF_OFFS = 35,
	TP_ERR_DEREF_OPEN_BRACE = 36,
	TP_ERR_COMM_CANT_DEREF = 37,
	TP_ERR_BAD_FETCH_ARG = 38,
	TP_ERR_ARRAY_NO_CLOSE = 39,
	TP_ERR_BAD_ARRAY_SUFFIX = 40,
	TP_ERR_BAD_ARRAY_NUM = 41,
	TP_ERR_ARRAY_TOO_BIG = 42,
	TP_ERR_BAD_TYPE = 43,
	TP_ERR_BAD_STRING = 44,
	TP_ERR_BAD_SYMSTRING = 45,
	TP_ERR_BAD_BITFIELD = 46,
	TP_ERR_ARG_NAME_TOO_LONG = 47,
	TP_ERR_NO_ARG_NAME = 48,
	TP_ERR_BAD_ARG_NAME = 49,
	TP_ERR_USED_ARG_NAME = 50,
	TP_ERR_ARG_TOO_LONG = 51,
	TP_ERR_NO_ARG_BODY = 52,
	TP_ERR_BAD_INSN_BNDRY = 53,
	TP_ERR_FAIL_REG_PROBE = 54,
	TP_ERR_DIFF_PROBE_TYPE = 55,
	TP_ERR_DIFF_ARG_TYPE = 56,
	TP_ERR_SAME_PROBE = 57,
	TP_ERR_NO_EVENT_INFO = 58,
	TP_ERR_BAD_ATTACH_EVENT = 59,
	TP_ERR_BAD_ATTACH_ARG = 60,
	TP_ERR_NO_EP_FILTER = 61,
	TP_ERR_NOSUP_BTFARG = 62,
	TP_ERR_NO_BTFARG = 63,
	TP_ERR_NO_BTF_ENTRY = 64,
	TP_ERR_BAD_VAR_ARGS = 65,
	TP_ERR_NOFENTRY_ARGS = 66,
	TP_ERR_DOUBLE_ARGS = 67,
	TP_ERR_ARGS_2LONG = 68,
	TP_ERR_ARGIDX_2BIG = 69,
	TP_ERR_NO_PTR_STRCT = 70,
	TP_ERR_NOSUP_DAT_ARG = 71,
	TP_ERR_BAD_HYPHEN = 72,
	TP_ERR_NO_BTF_FIELD = 73,
	TP_ERR_BAD_BTF_TID = 74,
	TP_ERR_BAD_TYPE4STR = 75,
	TP_ERR_NEED_STRING_TYPE = 76,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

enum {
	TRACE_EVENT_FL_FILTERED = 1,
	TRACE_EVENT_FL_CAP_ANY = 2,
	TRACE_EVENT_FL_NO_SET_FILTER = 4,
	TRACE_EVENT_FL_IGNORE_ENABLE = 8,
	TRACE_EVENT_FL_TRACEPOINT = 16,
	TRACE_EVENT_FL_DYNAMIC = 32,
	TRACE_EVENT_FL_KPROBE = 64,
	TRACE_EVENT_FL_UPROBE = 128,
	TRACE_EVENT_FL_EPROBE = 256,
	TRACE_EVENT_FL_FPROBE = 512,
	TRACE_EVENT_FL_CUSTOM = 1024,
	TRACE_EVENT_FL_TEST_STR = 2048,
};

enum {
	TRACE_EVENT_FL_FILTERED_BIT = 0,
	TRACE_EVENT_FL_CAP_ANY_BIT = 1,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 3,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 4,
	TRACE_EVENT_FL_DYNAMIC_BIT = 5,
	TRACE_EVENT_FL_KPROBE_BIT = 6,
	TRACE_EVENT_FL_UPROBE_BIT = 7,
	TRACE_EVENT_FL_EPROBE_BIT = 8,
	TRACE_EVENT_FL_FPROBE_BIT = 9,
	TRACE_EVENT_FL_CUSTOM_BIT = 10,
	TRACE_EVENT_FL_TEST_STR_BIT = 11,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_RECORD_RECURSION_BIT = 12,
};

enum {
	TRACE_FUNC_NO_OPTS = 0,
	TRACE_FUNC_OPT_STACK = 1,
	TRACE_FUNC_OPT_NO_REPEATS = 2,
	TRACE_FUNC_OPT_HIGHEST_BIT = 4,
};

enum {
	TRACE_GRAPH_FL = 1,
	TRACE_GRAPH_DEPTH_START_BIT = 2,
	TRACE_GRAPH_DEPTH_END_BIT = 3,
	TRACE_GRAPH_NOTRACE_BIT = 4,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	UARTDM_1P1 = 1,
	UARTDM_1P2 = 2,
	UARTDM_1P3 = 3,
	UARTDM_1P4 = 4,
};

enum {
	UART_IRQ_SUM = 0,
	UART_RX_IRQ = 0,
	UART_TX_IRQ = 1,
	UART_IRQ_COUNT = 2,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNIX_DIAG_NAME = 0,
	UNIX_DIAG_VFS = 1,
	UNIX_DIAG_PEER = 2,
	UNIX_DIAG_ICONS = 3,
	UNIX_DIAG_RQLEN = 4,
	UNIX_DIAG_MEMINFO = 5,
	UNIX_DIAG_SHUTDOWN = 6,
	UNIX_DIAG_UID = 7,
	__UNIX_DIAG_MAX = 8,
};

enum {
	VMGENID_SIZE = 16,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	V_ARMADA_7K = 1,
	V_ARMADA_8K_CPM = 2,
	V_ARMADA_8K_CPS = 4,
	V_CP115_STANDALONE = 8,
	V_ARMADA_7K_8K_CPM = 3,
	V_ARMADA_7K_8K_CPS = 5,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	WORK_DONE_BIT = 0,
	WORK_ORDER_DONE_BIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDOMAIN_STATE_INIT = 0,
	XDOMAIN_STATE_UUID = 1,
	XDOMAIN_STATE_LINK_STATUS = 2,
	XDOMAIN_STATE_LINK_STATE_CHANGE = 3,
	XDOMAIN_STATE_LINK_STATUS2 = 4,
	XDOMAIN_STATE_BONDING_UUID_LOW = 5,
	XDOMAIN_STATE_BONDING_UUID_HIGH = 6,
	XDOMAIN_STATE_PROPERTIES = 7,
	XDOMAIN_STATE_ENUMERATED = 8,
	XDOMAIN_STATE_ERROR = 9,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_SHARE_ANY = 0,
	XFRM_SHARE_SESSION = 1,
	XFRM_SHARE_USER = 2,
	XFRM_SHARE_UNIQUE = 3,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_MOVE_PCNTXT = 16384,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2096911,
};

enum {
	__EXTENT_DIRTY_BIT = 0,
	EXTENT_DIRTY = 1,
	__EXTENT_DIRTY_SEQ = 0,
	__EXTENT_UPTODATE_BIT = 1,
	EXTENT_UPTODATE = 2,
	__EXTENT_UPTODATE_SEQ = 1,
	__EXTENT_LOCKED_BIT = 2,
	EXTENT_LOCKED = 4,
	__EXTENT_LOCKED_SEQ = 2,
	__EXTENT_DIO_LOCKED_BIT = 3,
	EXTENT_DIO_LOCKED = 8,
	__EXTENT_DIO_LOCKED_SEQ = 3,
	__EXTENT_NEW_BIT = 4,
	EXTENT_NEW = 16,
	__EXTENT_NEW_SEQ = 4,
	__EXTENT_DELALLOC_BIT = 5,
	EXTENT_DELALLOC = 32,
	__EXTENT_DELALLOC_SEQ = 5,
	__EXTENT_DEFRAG_BIT = 6,
	EXTENT_DEFRAG = 64,
	__EXTENT_DEFRAG_SEQ = 6,
	__EXTENT_BOUNDARY_BIT = 7,
	EXTENT_BOUNDARY = 128,
	__EXTENT_BOUNDARY_SEQ = 7,
	__EXTENT_NODATASUM_BIT = 8,
	EXTENT_NODATASUM = 256,
	__EXTENT_NODATASUM_SEQ = 8,
	__EXTENT_CLEAR_META_RESV_BIT = 9,
	EXTENT_CLEAR_META_RESV = 512,
	__EXTENT_CLEAR_META_RESV_SEQ = 9,
	__EXTENT_NEED_WAIT_BIT = 10,
	EXTENT_NEED_WAIT = 1024,
	__EXTENT_NEED_WAIT_SEQ = 10,
	__EXTENT_NORESERVE_BIT = 11,
	EXTENT_NORESERVE = 2048,
	__EXTENT_NORESERVE_SEQ = 11,
	__EXTENT_QGROUP_RESERVED_BIT = 12,
	EXTENT_QGROUP_RESERVED = 4096,
	__EXTENT_QGROUP_RESERVED_SEQ = 12,
	__EXTENT_CLEAR_DATA_RESV_BIT = 13,
	EXTENT_CLEAR_DATA_RESV = 8192,
	__EXTENT_CLEAR_DATA_RESV_SEQ = 13,
	__EXTENT_DELALLOC_NEW_BIT = 14,
	EXTENT_DELALLOC_NEW = 16384,
	__EXTENT_DELALLOC_NEW_SEQ = 14,
	__EXTENT_ADD_INODE_BYTES_BIT = 15,
	EXTENT_ADD_INODE_BYTES = 32768,
	__EXTENT_ADD_INODE_BYTES_SEQ = 15,
	__EXTENT_CLEAR_ALL_BITS_BIT = 16,
	EXTENT_CLEAR_ALL_BITS = 65536,
	__EXTENT_CLEAR_ALL_BITS_SEQ = 16,
	__EXTENT_NOWAIT_BIT = 17,
	EXTENT_NOWAIT = 131072,
	__EXTENT_NOWAIT_SEQ = 17,
};

enum {
	__EXTENT_FLAG_PINNED_BIT = 0,
	EXTENT_FLAG_PINNED = 1,
	__EXTENT_FLAG_PINNED_SEQ = 0,
	__EXTENT_FLAG_COMPRESS_ZLIB_BIT = 1,
	EXTENT_FLAG_COMPRESS_ZLIB = 2,
	__EXTENT_FLAG_COMPRESS_ZLIB_SEQ = 1,
	__EXTENT_FLAG_COMPRESS_LZO_BIT = 2,
	EXTENT_FLAG_COMPRESS_LZO = 4,
	__EXTENT_FLAG_COMPRESS_LZO_SEQ = 2,
	__EXTENT_FLAG_COMPRESS_ZSTD_BIT = 3,
	EXTENT_FLAG_COMPRESS_ZSTD = 8,
	__EXTENT_FLAG_COMPRESS_ZSTD_SEQ = 3,
	__EXTENT_FLAG_PREALLOC_BIT = 4,
	EXTENT_FLAG_PREALLOC = 16,
	__EXTENT_FLAG_PREALLOC_SEQ = 4,
	__EXTENT_FLAG_LOGGING_BIT = 5,
	EXTENT_FLAG_LOGGING = 32,
	__EXTENT_FLAG_LOGGING_SEQ = 5,
	__EXTENT_FLAG_MERGED_BIT = 6,
	EXTENT_FLAG_MERGED = 64,
	__EXTENT_FLAG_MERGED_SEQ = 6,
};

enum {
	__IOAM6_IPTUNNEL_MODE_MIN = 0,
	IOAM6_IPTUNNEL_MODE_INLINE = 1,
	IOAM6_IPTUNNEL_MODE_ENCAP = 2,
	IOAM6_IPTUNNEL_MODE_AUTO = 3,
	__IOAM6_IPTUNNEL_MODE_MAX = 4,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PAGE_UNLOCK_BIT = 0,
	PAGE_UNLOCK = 1,
	__PAGE_UNLOCK_SEQ = 0,
	__PAGE_START_WRITEBACK_BIT = 1,
	PAGE_START_WRITEBACK = 2,
	__PAGE_START_WRITEBACK_SEQ = 1,
	__PAGE_END_WRITEBACK_BIT = 2,
	PAGE_END_WRITEBACK = 4,
	__PAGE_END_WRITEBACK_SEQ = 2,
	__PAGE_SET_ORDERED_BIT = 3,
	PAGE_SET_ORDERED = 8,
	__PAGE_SET_ORDERED_SEQ = 3,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__QGROUP_RESERVE_BIT = 0,
	QGROUP_RESERVE = 1,
	__QGROUP_RESERVE_SEQ = 0,
	__QGROUP_RELEASE_BIT = 1,
	QGROUP_RELEASE = 2,
	__QGROUP_RELEASE_SEQ = 1,
	__QGROUP_FREE_BIT = 2,
	QGROUP_FREE = 4,
	__QGROUP_FREE_SEQ = 2,
};

enum {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 6,
	__SCHED_FEAT_DELAY_DEQUEUE = 7,
	__SCHED_FEAT_DELAY_ZERO = 8,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 9,
	__SCHED_FEAT_HRTICK = 10,
	__SCHED_FEAT_HRTICK_DL = 11,
	__SCHED_FEAT_DOUBLE_TICK = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	____TRANS_FREEZABLE_BIT = 0,
	__TRANS_FREEZABLE = 1,
	____TRANS_FREEZABLE_SEQ = 0,
	____TRANS_START_BIT = 1,
	__TRANS_START = 2,
	____TRANS_START_SEQ = 1,
	____TRANS_ATTACH_BIT = 2,
	__TRANS_ATTACH = 4,
	____TRANS_ATTACH_SEQ = 2,
	____TRANS_JOIN_BIT = 3,
	__TRANS_JOIN = 8,
	____TRANS_JOIN_SEQ = 3,
	____TRANS_JOIN_NOLOCK_BIT = 4,
	__TRANS_JOIN_NOLOCK = 16,
	____TRANS_JOIN_NOLOCK_SEQ = 4,
	____TRANS_DUMMY_BIT = 5,
	__TRANS_DUMMY = 32,
	____TRANS_DUMMY_SEQ = 5,
	____TRANS_JOIN_NOSTART_BIT = 6,
	__TRANS_JOIN_NOSTART = 64,
	____TRANS_JOIN_NOSTART_SEQ = 6,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_LIRC_MODE2 = 24,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 25,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 26,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 27,
	__ctx_convertBPF_PROG_TYPE_EXT = 28,
	__ctx_convertBPF_PROG_TYPE_LSM = 29,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 30,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 31,
	__ctx_convert_unused = 32,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	btrfs_bitmap_nr_uptodate = 0,
	btrfs_bitmap_nr_dirty = 1,
	btrfs_bitmap_nr_writeback = 2,
	btrfs_bitmap_nr_ordered = 3,
	btrfs_bitmap_nr_checked = 4,
	btrfs_bitmap_nr_locked = 5,
	btrfs_bitmap_nr_max = 6,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	false = 0,
	true = 1,
};

enum {
	kvm_ioeventfd_flag_nr_datamatch = 0,
	kvm_ioeventfd_flag_nr_pio = 1,
	kvm_ioeventfd_flag_nr_deassign = 2,
	kvm_ioeventfd_flag_nr_virtio_ccw_notify = 3,
	kvm_ioeventfd_flag_nr_fast_mmio = 4,
	kvm_ioeventfd_flag_nr_max = 5,
};

enum {
	mask_exec = 0,
	mask_write = 1,
	mask_read = 2,
	mask_append = 3,
};

enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5,
};

enum {
	ncsi_dev_state_major = 65280,
	ncsi_dev_state_minor = 255,
	ncsi_dev_state_probe_deselect = 513,
	ncsi_dev_state_probe_package = 514,
	ncsi_dev_state_probe_channel = 515,
	ncsi_dev_state_probe_mlx_gma = 516,
	ncsi_dev_state_probe_mlx_smaf = 517,
	ncsi_dev_state_probe_cis = 518,
	ncsi_dev_state_probe_keep_phy = 519,
	ncsi_dev_state_probe_gvi = 520,
	ncsi_dev_state_probe_gc = 521,
	ncsi_dev_state_probe_gls = 522,
	ncsi_dev_state_probe_dp = 523,
	ncsi_dev_state_config_sp = 769,
	ncsi_dev_state_config_cis = 770,
	ncsi_dev_state_config_oem_gma = 771,
	ncsi_dev_state_config_clear_vids = 772,
	ncsi_dev_state_config_svf = 773,
	ncsi_dev_state_config_ev = 774,
	ncsi_dev_state_config_sma = 775,
	ncsi_dev_state_config_ebf = 776,
	ncsi_dev_state_config_dgmf = 777,
	ncsi_dev_state_config_ecnt = 778,
	ncsi_dev_state_config_ec = 779,
	ncsi_dev_state_config_ae = 780,
	ncsi_dev_state_config_gls = 781,
	ncsi_dev_state_config_done = 782,
	ncsi_dev_state_suspend_select = 1025,
	ncsi_dev_state_suspend_gls = 1026,
	ncsi_dev_state_suspend_dcnt = 1027,
	ncsi_dev_state_suspend_dc = 1028,
	ncsi_dev_state_suspend_deselect = 1029,
	ncsi_dev_state_suspend_done = 1030,
};

enum {
	ncsi_dev_state_registered = 0,
	ncsi_dev_state_functional = 256,
	ncsi_dev_state_probe = 512,
	ncsi_dev_state_config = 768,
	ncsi_dev_state_suspend = 1024,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	preempt_dynamic_undefined = -1,
	preempt_dynamic_none = 0,
	preempt_dynamic_voluntary = 1,
	preempt_dynamic_full = 2,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	sysctl_hung_task_timeout_secs = 0,
};

enum {
	type_kind_int = 0,
	type_kind_float = 1,
	type_unknown = 65535,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	EfiPciIoWidthUint8 = 0,
	EfiPciIoWidthUint16 = 1,
	EfiPciIoWidthUint32 = 2,
	EfiPciIoWidthUint64 = 3,
	EfiPciIoWidthFifoUint8 = 4,
	EfiPciIoWidthFifoUint16 = 5,
	EfiPciIoWidthFifoUint32 = 6,
	EfiPciIoWidthFifoUint64 = 7,
	EfiPciIoWidthFillUint8 = 8,
	EfiPciIoWidthFillUint16 = 9,
	EfiPciIoWidthFillUint32 = 10,
	EfiPciIoWidthFillUint64 = 11,
	EfiPciIoWidthMaximum = 12,
} EFI_PCI_IO_PROTOCOL_WIDTH;

typedef enum {
	EfiTimerCancel = 0,
	EfiTimerPeriodic = 1,
	EfiTimerRelative = 2,
} EFI_TIMER_DELAY;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_cParamMode_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam6 = 1003,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_buffers = 1,
	ZSTD_cwksp_alloc_aligned = 2,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_defaultPolicy_e;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_paramSwitch_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_sequenceFormat_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PCI_BRIDGE_EMUL_HANDLED = 0,
	PCI_BRIDGE_EMUL_NOT_HANDLED = 1,
} pci_bridge_emul_read_status_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	STATUSTYPE_INFO = 0,
	STATUSTYPE_TABLE = 1,
	STATUSTYPE_IMA = 2,
} status_type_t;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} symbolEncodingType_e;

typedef ZSTD_ErrorCode zstd_error_code;

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum DTPM_NODE_TYPE {
	DTPM_NODE_VIRTUAL = 0,
	DTPM_NODE_DT = 1,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum SCI_CLKS {
	SCI_FCK = 0,
	SCI_SCK = 1,
	SCI_BRG_INT = 2,
	SCI_SCIF_CLK = 3,
	SCI_NUM_CLKS = 4,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum __kvm_host_smccc_func {
	__KVM_HOST_SMCCC_FUNC___kvm_get_mdcr_el2 = 1,
	__KVM_HOST_SMCCC_FUNC___pkvm_init = 2,
	__KVM_HOST_SMCCC_FUNC___pkvm_create_private_mapping = 3,
	__KVM_HOST_SMCCC_FUNC___pkvm_cpu_set_vector = 4,
	__KVM_HOST_SMCCC_FUNC___kvm_enable_ssbs = 5,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_init_lrs = 6,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_get_gic_config = 7,
	__KVM_HOST_SMCCC_FUNC___pkvm_prot_finalize = 8,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_hyp = 9,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_hyp = 10,
	__KVM_HOST_SMCCC_FUNC___kvm_adjust_pc = 11,
	__KVM_HOST_SMCCC_FUNC___kvm_vcpu_run = 12,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_vm_context = 13,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa = 14,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa_nsh = 15,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid = 16,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_range = 17,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_cpu_context = 18,
	__KVM_HOST_SMCCC_FUNC___kvm_timer_set_cntvoff = 19,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_save_vmcr_aprs = 20,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_restore_vmcr_aprs = 21,
	__KVM_HOST_SMCCC_FUNC___pkvm_vcpu_init_traps = 22,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vm = 23,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vcpu = 24,
	__KVM_HOST_SMCCC_FUNC___pkvm_teardown_vm = 25,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_SKIP_KFENCE = 15,
	_SLAB_RECLAIM_ACCOUNT = 16,
	_SLAB_OBJECT_POISON = 17,
	_SLAB_CMPXCHG_DOUBLE = 18,
	_SLAB_NO_OBJ_EXT = 19,
	_SLAB_FLAGS_LAST_BIT = 20,
};

enum aarch32_map {
	AA32_MAP_VECTORS = 0,
	AA32_MAP_SIGPAGE = 1,
	AA32_MAP_VVAR = 2,
	AA32_MAP_VDSO = 3,
};

enum aarch64_insn_adr_type {
	AARCH64_INSN_ADR_TYPE_ADRP = 0,
	AARCH64_INSN_ADR_TYPE_ADR = 1,
};

enum aarch64_insn_adsb_type {
	AARCH64_INSN_ADSB_ADD = 0,
	AARCH64_INSN_ADSB_SUB = 1,
	AARCH64_INSN_ADSB_ADD_SETFLAGS = 2,
	AARCH64_INSN_ADSB_SUB_SETFLAGS = 3,
};

enum aarch64_insn_bitfield_type {
	AARCH64_INSN_BITFIELD_MOVE = 0,
	AARCH64_INSN_BITFIELD_MOVE_UNSIGNED = 1,
	AARCH64_INSN_BITFIELD_MOVE_SIGNED = 2,
};

enum aarch64_insn_branch_type {
	AARCH64_INSN_BRANCH_NOLINK = 0,
	AARCH64_INSN_BRANCH_LINK = 1,
	AARCH64_INSN_BRANCH_RETURN = 2,
	AARCH64_INSN_BRANCH_COMP_ZERO = 3,
	AARCH64_INSN_BRANCH_COMP_NONZERO = 4,
};

enum aarch64_insn_condition {
	AARCH64_INSN_COND_EQ = 0,
	AARCH64_INSN_COND_NE = 1,
	AARCH64_INSN_COND_CS = 2,
	AARCH64_INSN_COND_CC = 3,
	AARCH64_INSN_COND_MI = 4,
	AARCH64_INSN_COND_PL = 5,
	AARCH64_INSN_COND_VS = 6,
	AARCH64_INSN_COND_VC = 7,
	AARCH64_INSN_COND_HI = 8,
	AARCH64_INSN_COND_LS = 9,
	AARCH64_INSN_COND_GE = 10,
	AARCH64_INSN_COND_LT = 11,
	AARCH64_INSN_COND_GT = 12,
	AARCH64_INSN_COND_LE = 13,
	AARCH64_INSN_COND_AL = 14,
};

enum aarch64_insn_data1_type {
	AARCH64_INSN_DATA1_REVERSE_16 = 0,
	AARCH64_INSN_DATA1_REVERSE_32 = 1,
	AARCH64_INSN_DATA1_REVERSE_64 = 2,
};

enum aarch64_insn_data2_type {
	AARCH64_INSN_DATA2_UDIV = 0,
	AARCH64_INSN_DATA2_SDIV = 1,
	AARCH64_INSN_DATA2_LSLV = 2,
	AARCH64_INSN_DATA2_LSRV = 3,
	AARCH64_INSN_DATA2_ASRV = 4,
	AARCH64_INSN_DATA2_RORV = 5,
};

enum aarch64_insn_data3_type {
	AARCH64_INSN_DATA3_MADD = 0,
	AARCH64_INSN_DATA3_MSUB = 1,
};

enum aarch64_insn_hint_cr_op {
	AARCH64_INSN_HINT_NOP = 0,
	AARCH64_INSN_HINT_YIELD = 32,
	AARCH64_INSN_HINT_WFE = 64,
	AARCH64_INSN_HINT_WFI = 96,
	AARCH64_INSN_HINT_SEV = 128,
	AARCH64_INSN_HINT_SEVL = 160,
	AARCH64_INSN_HINT_XPACLRI = 224,
	AARCH64_INSN_HINT_PACIA_1716 = 256,
	AARCH64_INSN_HINT_PACIB_1716 = 320,
	AARCH64_INSN_HINT_AUTIA_1716 = 384,
	AARCH64_INSN_HINT_AUTIB_1716 = 448,
	AARCH64_INSN_HINT_PACIAZ = 768,
	AARCH64_INSN_HINT_PACIASP = 800,
	AARCH64_INSN_HINT_PACIBZ = 832,
	AARCH64_INSN_HINT_PACIBSP = 864,
	AARCH64_INSN_HINT_AUTIAZ = 896,
	AARCH64_INSN_HINT_AUTIASP = 928,
	AARCH64_INSN_HINT_AUTIBZ = 960,
	AARCH64_INSN_HINT_AUTIBSP = 992,
	AARCH64_INSN_HINT_ESB = 512,
	AARCH64_INSN_HINT_PSB = 544,
	AARCH64_INSN_HINT_TSB = 576,
	AARCH64_INSN_HINT_CSDB = 640,
	AARCH64_INSN_HINT_CLEARBHB = 704,
	AARCH64_INSN_HINT_BTI = 1024,
	AARCH64_INSN_HINT_BTIC = 1088,
	AARCH64_INSN_HINT_BTIJ = 1152,
	AARCH64_INSN_HINT_BTIJC = 1216,
};

enum aarch64_insn_imm_type {
	AARCH64_INSN_IMM_ADR = 0,
	AARCH64_INSN_IMM_26 = 1,
	AARCH64_INSN_IMM_19 = 2,
	AARCH64_INSN_IMM_16 = 3,
	AARCH64_INSN_IMM_14 = 4,
	AARCH64_INSN_IMM_12 = 5,
	AARCH64_INSN_IMM_9 = 6,
	AARCH64_INSN_IMM_7 = 7,
	AARCH64_INSN_IMM_6 = 8,
	AARCH64_INSN_IMM_S = 9,
	AARCH64_INSN_IMM_R = 10,
	AARCH64_INSN_IMM_N = 11,
	AARCH64_INSN_IMM_MAX = 12,
};

enum aarch64_insn_ldst_type {
	AARCH64_INSN_LDST_LOAD_REG_OFFSET = 0,
	AARCH64_INSN_LDST_STORE_REG_OFFSET = 1,
	AARCH64_INSN_LDST_LOAD_IMM_OFFSET = 2,
	AARCH64_INSN_LDST_STORE_IMM_OFFSET = 3,
	AARCH64_INSN_LDST_LOAD_PAIR_PRE_INDEX = 4,
	AARCH64_INSN_LDST_STORE_PAIR_PRE_INDEX = 5,
	AARCH64_INSN_LDST_LOAD_PAIR_POST_INDEX = 6,
	AARCH64_INSN_LDST_STORE_PAIR_POST_INDEX = 7,
	AARCH64_INSN_LDST_LOAD_EX = 8,
	AARCH64_INSN_LDST_LOAD_ACQ_EX = 9,
	AARCH64_INSN_LDST_STORE_EX = 10,
	AARCH64_INSN_LDST_STORE_REL_EX = 11,
	AARCH64_INSN_LDST_SIGNED_LOAD_IMM_OFFSET = 12,
	AARCH64_INSN_LDST_SIGNED_LOAD_REG_OFFSET = 13,
};

enum aarch64_insn_logic_type {
	AARCH64_INSN_LOGIC_AND = 0,
	AARCH64_INSN_LOGIC_BIC = 1,
	AARCH64_INSN_LOGIC_ORR = 2,
	AARCH64_INSN_LOGIC_ORN = 3,
	AARCH64_INSN_LOGIC_EOR = 4,
	AARCH64_INSN_LOGIC_EON = 5,
	AARCH64_INSN_LOGIC_AND_SETFLAGS = 6,
	AARCH64_INSN_LOGIC_BIC_SETFLAGS = 7,
};

enum aarch64_insn_mb_type {
	AARCH64_INSN_MB_SY = 0,
	AARCH64_INSN_MB_ST = 1,
	AARCH64_INSN_MB_LD = 2,
	AARCH64_INSN_MB_ISH = 3,
	AARCH64_INSN_MB_ISHST = 4,
	AARCH64_INSN_MB_ISHLD = 5,
	AARCH64_INSN_MB_NSH = 6,
	AARCH64_INSN_MB_NSHST = 7,
	AARCH64_INSN_MB_NSHLD = 8,
	AARCH64_INSN_MB_OSH = 9,
	AARCH64_INSN_MB_OSHST = 10,
	AARCH64_INSN_MB_OSHLD = 11,
};

enum aarch64_insn_mem_atomic_op {
	AARCH64_INSN_MEM_ATOMIC_ADD = 0,
	AARCH64_INSN_MEM_ATOMIC_CLR = 1,
	AARCH64_INSN_MEM_ATOMIC_EOR = 2,
	AARCH64_INSN_MEM_ATOMIC_SET = 3,
	AARCH64_INSN_MEM_ATOMIC_SWP = 4,
};

enum aarch64_insn_mem_order_type {
	AARCH64_INSN_MEM_ORDER_NONE = 0,
	AARCH64_INSN_MEM_ORDER_ACQ = 1,
	AARCH64_INSN_MEM_ORDER_REL = 2,
	AARCH64_INSN_MEM_ORDER_ACQREL = 3,
};

enum aarch64_insn_movewide_type {
	AARCH64_INSN_MOVEWIDE_ZERO = 0,
	AARCH64_INSN_MOVEWIDE_KEEP = 1,
	AARCH64_INSN_MOVEWIDE_INVERSE = 2,
};

enum aarch64_insn_movw_imm_type {
	AARCH64_INSN_IMM_MOVNZ = 0,
	AARCH64_INSN_IMM_MOVKZ = 1,
};

enum aarch64_insn_register {
	AARCH64_INSN_REG_0 = 0,
	AARCH64_INSN_REG_1 = 1,
	AARCH64_INSN_REG_2 = 2,
	AARCH64_INSN_REG_3 = 3,
	AARCH64_INSN_REG_4 = 4,
	AARCH64_INSN_REG_5 = 5,
	AARCH64_INSN_REG_6 = 6,
	AARCH64_INSN_REG_7 = 7,
	AARCH64_INSN_REG_8 = 8,
	AARCH64_INSN_REG_9 = 9,
	AARCH64_INSN_REG_10 = 10,
	AARCH64_INSN_REG_11 = 11,
	AARCH64_INSN_REG_12 = 12,
	AARCH64_INSN_REG_13 = 13,
	AARCH64_INSN_REG_14 = 14,
	AARCH64_INSN_REG_15 = 15,
	AARCH64_INSN_REG_16 = 16,
	AARCH64_INSN_REG_17 = 17,
	AARCH64_INSN_REG_18 = 18,
	AARCH64_INSN_REG_19 = 19,
	AARCH64_INSN_REG_20 = 20,
	AARCH64_INSN_REG_21 = 21,
	AARCH64_INSN_REG_22 = 22,
	AARCH64_INSN_REG_23 = 23,
	AARCH64_INSN_REG_24 = 24,
	AARCH64_INSN_REG_25 = 25,
	AARCH64_INSN_REG_26 = 26,
	AARCH64_INSN_REG_27 = 27,
	AARCH64_INSN_REG_28 = 28,
	AARCH64_INSN_REG_29 = 29,
	AARCH64_INSN_REG_FP = 29,
	AARCH64_INSN_REG_30 = 30,
	AARCH64_INSN_REG_LR = 30,
	AARCH64_INSN_REG_ZR = 31,
	AARCH64_INSN_REG_SP = 31,
};

enum aarch64_insn_register_type {
	AARCH64_INSN_REGTYPE_RT = 0,
	AARCH64_INSN_REGTYPE_RN = 1,
	AARCH64_INSN_REGTYPE_RT2 = 2,
	AARCH64_INSN_REGTYPE_RM = 3,
	AARCH64_INSN_REGTYPE_RD = 4,
	AARCH64_INSN_REGTYPE_RA = 5,
	AARCH64_INSN_REGTYPE_RS = 6,
};

enum aarch64_insn_size_type {
	AARCH64_INSN_SIZE_8 = 0,
	AARCH64_INSN_SIZE_16 = 1,
	AARCH64_INSN_SIZE_32 = 2,
	AARCH64_INSN_SIZE_64 = 3,
};

enum aarch64_insn_special_register {
	AARCH64_INSN_SPCLREG_SPSR_EL1 = 49664,
	AARCH64_INSN_SPCLREG_ELR_EL1 = 49665,
	AARCH64_INSN_SPCLREG_SP_EL0 = 49672,
	AARCH64_INSN_SPCLREG_SPSEL = 49680,
	AARCH64_INSN_SPCLREG_CURRENTEL = 49682,
	AARCH64_INSN_SPCLREG_DAIF = 55825,
	AARCH64_INSN_SPCLREG_NZCV = 55824,
	AARCH64_INSN_SPCLREG_FPCR = 55840,
	AARCH64_INSN_SPCLREG_DSPSR_EL0 = 55848,
	AARCH64_INSN_SPCLREG_DLR_EL0 = 55849,
	AARCH64_INSN_SPCLREG_SPSR_EL2 = 57856,
	AARCH64_INSN_SPCLREG_ELR_EL2 = 57857,
	AARCH64_INSN_SPCLREG_SP_EL1 = 57864,
	AARCH64_INSN_SPCLREG_SPSR_INQ = 57880,
	AARCH64_INSN_SPCLREG_SPSR_ABT = 57881,
	AARCH64_INSN_SPCLREG_SPSR_UND = 57882,
	AARCH64_INSN_SPCLREG_SPSR_FIQ = 57883,
	AARCH64_INSN_SPCLREG_SPSR_EL3 = 61952,
	AARCH64_INSN_SPCLREG_ELR_EL3 = 61953,
	AARCH64_INSN_SPCLREG_SP_EL2 = 61968,
};

enum aarch64_insn_system_register {
	AARCH64_INSN_SYSREG_TPIDR_EL1 = 18052,
	AARCH64_INSN_SYSREG_TPIDR_EL2 = 26242,
	AARCH64_INSN_SYSREG_SP_EL0 = 16904,
};

enum aarch64_insn_variant {
	AARCH64_INSN_VARIANT_32BIT = 0,
	AARCH64_INSN_VARIANT_64BIT = 1,
};

enum aarch64_map {
	AA64_MAP_VVAR = 0,
	AA64_MAP_VDSO = 1,
};

enum aarch64_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_TLS = 2,
	REGSET_HW_BREAK = 3,
	REGSET_HW_WATCH = 4,
	REGSET_FPMR = 5,
	REGSET_SYSTEM_CALL = 6,
	REGSET_SVE = 7,
	REGSET_PAC_MASK = 8,
	REGSET_PAC_ENABLED_KEYS = 9,
	REGSET_PACA_KEYS = 10,
	REGSET_PACG_KEYS = 11,
	REGSET_TAGGED_ADDR_CTRL = 12,
	REGSET_POE = 13,
};

enum aarch64_reloc_op {
	RELOC_OP_NONE = 0,
	RELOC_OP_ABS = 1,
	RELOC_OP_PREL = 2,
	RELOC_OP_PAGE = 3,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_ec_event_state {
	EC_EVENT_READY = 0,
	EC_EVENT_IN_PROGRESS = 1,
	EC_EVENT_COMPLETE = 2,
};

enum acpi_erst_actions {
	ACPI_ERST_BEGIN_WRITE = 0,
	ACPI_ERST_BEGIN_READ = 1,
	ACPI_ERST_BEGIN_CLEAR = 2,
	ACPI_ERST_END = 3,
	ACPI_ERST_SET_RECORD_OFFSET = 4,
	ACPI_ERST_EXECUTE_OPERATION = 5,
	ACPI_ERST_CHECK_BUSY_STATUS = 6,
	ACPI_ERST_GET_COMMAND_STATUS = 7,
	ACPI_ERST_GET_RECORD_ID = 8,
	ACPI_ERST_SET_RECORD_ID = 9,
	ACPI_ERST_GET_RECORD_COUNT = 10,
	ACPI_ERST_BEGIN_DUMMY_WRIITE = 11,
	ACPI_ERST_NOT_USED = 12,
	ACPI_ERST_GET_ERROR_RANGE = 13,
	ACPI_ERST_GET_ERROR_LENGTH = 14,
	ACPI_ERST_GET_ERROR_ATTRIBUTES = 15,
	ACPI_ERST_EXECUTE_TIMINGS = 16,
	ACPI_ERST_ACTION_RESERVED = 17,
};

enum acpi_erst_instructions {
	ACPI_ERST_READ_REGISTER = 0,
	ACPI_ERST_READ_REGISTER_VALUE = 1,
	ACPI_ERST_WRITE_REGISTER = 2,
	ACPI_ERST_WRITE_REGISTER_VALUE = 3,
	ACPI_ERST_NOOP = 4,
	ACPI_ERST_LOAD_VAR1 = 5,
	ACPI_ERST_LOAD_VAR2 = 6,
	ACPI_ERST_STORE_VAR1 = 7,
	ACPI_ERST_ADD = 8,
	ACPI_ERST_SUBTRACT = 9,
	ACPI_ERST_ADD_VALUE = 10,
	ACPI_ERST_SUBTRACT_VALUE = 11,
	ACPI_ERST_STALL = 12,
	ACPI_ERST_STALL_WHILE_TRUE = 13,
	ACPI_ERST_SKIP_NEXT_IF_TRUE = 14,
	ACPI_ERST_GOTO = 15,
	ACPI_ERST_SET_SRC_ADDRESS_BASE = 16,
	ACPI_ERST_SET_DST_ADDRESS_BASE = 17,
	ACPI_ERST_MOVE_DATA = 18,
	ACPI_ERST_INSTRUCTION_RESERVED = 19,
};

enum acpi_gtdt_type {
	ACPI_GTDT_TYPE_TIMER_BLOCK = 0,
	ACPI_GTDT_TYPE_WATCHDOG = 1,
	ACPI_GTDT_TYPE_RESERVED = 2,
};

enum acpi_hest_notify_types {
	ACPI_HEST_NOTIFY_POLLED = 0,
	ACPI_HEST_NOTIFY_EXTERNAL = 1,
	ACPI_HEST_NOTIFY_LOCAL = 2,
	ACPI_HEST_NOTIFY_SCI = 3,
	ACPI_HEST_NOTIFY_NMI = 4,
	ACPI_HEST_NOTIFY_CMCI = 5,
	ACPI_HEST_NOTIFY_MCE = 6,
	ACPI_HEST_NOTIFY_GPIO = 7,
	ACPI_HEST_NOTIFY_SEA = 8,
	ACPI_HEST_NOTIFY_SEI = 9,
	ACPI_HEST_NOTIFY_GSIV = 10,
	ACPI_HEST_NOTIFY_SOFTWARE_DELEGATED = 11,
	ACPI_HEST_NOTIFY_RESERVED = 12,
};

enum acpi_hest_types {
	ACPI_HEST_TYPE_IA32_CHECK = 0,
	ACPI_HEST_TYPE_IA32_CORRECTED_CHECK = 1,
	ACPI_HEST_TYPE_IA32_NMI = 2,
	ACPI_HEST_TYPE_NOT_USED3 = 3,
	ACPI_HEST_TYPE_NOT_USED4 = 4,
	ACPI_HEST_TYPE_NOT_USED5 = 5,
	ACPI_HEST_TYPE_AER_ROOT_PORT = 6,
	ACPI_HEST_TYPE_AER_ENDPOINT = 7,
	ACPI_HEST_TYPE_AER_BRIDGE = 8,
	ACPI_HEST_TYPE_GENERIC_ERROR = 9,
	ACPI_HEST_TYPE_GENERIC_ERROR_V2 = 10,
	ACPI_HEST_TYPE_IA32_DEFERRED_CHECK = 11,
	ACPI_HEST_TYPE_RESERVED = 12,
};

enum acpi_hmat_type {
	ACPI_HMAT_TYPE_PROXIMITY = 0,
	ACPI_HMAT_TYPE_LOCALITY = 1,
	ACPI_HMAT_TYPE_CACHE = 2,
	ACPI_HMAT_TYPE_RESERVED = 3,
};

enum acpi_iort_node_type {
	ACPI_IORT_NODE_ITS_GROUP = 0,
	ACPI_IORT_NODE_NAMED_COMPONENT = 1,
	ACPI_IORT_NODE_PCI_ROOT_COMPLEX = 2,
	ACPI_IORT_NODE_SMMU = 3,
	ACPI_IORT_NODE_SMMU_V3 = 4,
	ACPI_IORT_NODE_PMCG = 5,
	ACPI_IORT_NODE_RMR = 6,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_gic_version {
	ACPI_MADT_GIC_VERSION_NONE = 0,
	ACPI_MADT_GIC_VERSION_V1 = 1,
	ACPI_MADT_GIC_VERSION_V2 = 2,
	ACPI_MADT_GIC_VERSION_V3 = 3,
	ACPI_MADT_GIC_VERSION_V4 = 4,
	ACPI_MADT_GIC_VERSION_RESERVED = 5,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_pptt_type {
	ACPI_PPTT_TYPE_PROCESSOR = 0,
	ACPI_PPTT_TYPE_CACHE = 1,
	ACPI_PPTT_TYPE_ID = 2,
	ACPI_PPTT_TYPE_RESERVED = 3,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum acpi_viot_node_type {
	ACPI_VIOT_NODE_PCI_RANGE = 1,
	ACPI_VIOT_NODE_MMIO = 2,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_PCI = 3,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_MMIO = 4,
	ACPI_VIOT_RESERVED = 5,
};

enum action_id {
	ACTION_SAVE = 1,
	ACTION_TRACE = 2,
	ACTION_SNAPSHOT = 3,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum al_fic_state {
	AL_FIC_UNCONFIGURED = 0,
	AL_FIC_CONFIGURED_LEVEL = 1,
	AL_FIC_CONFIGURED_RISING_EDGE = 2,
};

enum alarmtimer_restart {
	ALARMTIMER_NORESTART = 0,
	ALARMTIMER_RESTART = 1,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum amd_chipset_gen {
	NOT_AMD_CHIPSET = 0,
	AMD_CHIPSET_SB600 = 1,
	AMD_CHIPSET_SB700 = 2,
	AMD_CHIPSET_SB800 = 3,
	AMD_CHIPSET_HUDSON2 = 4,
	AMD_CHIPSET_BOLTON = 5,
	AMD_CHIPSET_YANGTZE = 6,
	AMD_CHIPSET_TAISHAN = 7,
	AMD_CHIPSET_UNKNOWN = 8,
};

enum amd_functions {
	IMX_F0_GPIO0 = 0,
	IMX_F1_GPIO0 = 1,
	IMX_F2_GPIO0 = 2,
	IMX_F3_GPIO0 = 3,
	IMX_F0_GPIO1 = 4,
	IMX_F1_GPIO1 = 5,
	IMX_F2_GPIO1 = 6,
	IMX_F3_GPIO1 = 7,
	IMX_F0_GPIO2 = 8,
	IMX_F1_GPIO2 = 9,
	IMX_F2_GPIO2 = 10,
	IMX_F3_GPIO2 = 11,
	IMX_F0_GPIO3 = 12,
	IMX_F1_GPIO3 = 13,
	IMX_F2_GPIO3 = 14,
	IMX_F3_GPIO3 = 15,
	IMX_F0_GPIO4 = 16,
	IMX_F1_GPIO4 = 17,
	IMX_F2_GPIO4 = 18,
	IMX_F3_GPIO4 = 19,
	IMX_F0_GPIO5 = 20,
	IMX_F1_GPIO5 = 21,
	IMX_F2_GPIO5 = 22,
	IMX_F3_GPIO5 = 23,
	IMX_F0_GPIO6 = 24,
	IMX_F1_GPIO6 = 25,
	IMX_F2_GPIO6 = 26,
	IMX_F3_GPIO6 = 27,
	IMX_F0_GPIO7 = 28,
	IMX_F1_GPIO7 = 29,
	IMX_F2_GPIO7 = 30,
	IMX_F3_GPIO7 = 31,
	IMX_F0_GPIO8 = 32,
	IMX_F1_GPIO8 = 33,
	IMX_F2_GPIO8 = 34,
	IMX_F3_GPIO8 = 35,
	IMX_F0_GPIO9 = 36,
	IMX_F1_GPIO9 = 37,
	IMX_F2_GPIO9 = 38,
	IMX_F3_GPIO9 = 39,
	IMX_F0_GPIO10 = 40,
	IMX_F1_GPIO10 = 41,
	IMX_F2_GPIO10 = 42,
	IMX_F3_GPIO10 = 43,
	IMX_F0_GPIO11 = 44,
	IMX_F1_GPIO11 = 45,
	IMX_F2_GPIO11 = 46,
	IMX_F3_GPIO11 = 47,
	IMX_F0_GPIO12 = 48,
	IMX_F1_GPIO12 = 49,
	IMX_F2_GPIO12 = 50,
	IMX_F3_GPIO12 = 51,
	IMX_F0_GPIO13 = 52,
	IMX_F1_GPIO13 = 53,
	IMX_F2_GPIO13 = 54,
	IMX_F3_GPIO13 = 55,
	IMX_F0_GPIO14 = 56,
	IMX_F1_GPIO14 = 57,
	IMX_F2_GPIO14 = 58,
	IMX_F3_GPIO14 = 59,
	IMX_F0_GPIO15 = 60,
	IMX_F1_GPIO15 = 61,
	IMX_F2_GPIO15 = 62,
	IMX_F3_GPIO15 = 63,
	IMX_F0_GPIO16 = 64,
	IMX_F1_GPIO16 = 65,
	IMX_F2_GPIO16 = 66,
	IMX_F3_GPIO16 = 67,
	IMX_F0_GPIO17 = 68,
	IMX_F1_GPIO17 = 69,
	IMX_F2_GPIO17 = 70,
	IMX_F3_GPIO17 = 71,
	IMX_F0_GPIO18 = 72,
	IMX_F1_GPIO18 = 73,
	IMX_F2_GPIO18 = 74,
	IMX_F3_GPIO18 = 75,
	IMX_F0_GPIO19 = 76,
	IMX_F1_GPIO19 = 77,
	IMX_F2_GPIO19 = 78,
	IMX_F3_GPIO19 = 79,
	IMX_F0_GPIO20 = 80,
	IMX_F1_GPIO20 = 81,
	IMX_F2_GPIO20 = 82,
	IMX_F3_GPIO20 = 83,
	IMX_F0_GPIO21 = 84,
	IMX_F1_GPIO21 = 85,
	IMX_F2_GPIO21 = 86,
	IMX_F3_GPIO21 = 87,
	IMX_F0_GPIO22 = 88,
	IMX_F1_GPIO22 = 89,
	IMX_F2_GPIO22 = 90,
	IMX_F3_GPIO22 = 91,
	IMX_F0_GPIO23 = 92,
	IMX_F1_GPIO23 = 93,
	IMX_F2_GPIO23 = 94,
	IMX_F3_GPIO23 = 95,
	IMX_F0_GPIO24 = 96,
	IMX_F1_GPIO24 = 97,
	IMX_F2_GPIO24 = 98,
	IMX_F3_GPIO24 = 99,
	IMX_F0_GPIO25 = 100,
	IMX_F1_GPIO25 = 101,
	IMX_F2_GPIO25 = 102,
	IMX_F3_GPIO25 = 103,
	IMX_F0_GPIO26 = 104,
	IMX_F1_GPIO26 = 105,
	IMX_F2_GPIO26 = 106,
	IMX_F3_GPIO26 = 107,
	IMX_F0_GPIO27 = 108,
	IMX_F1_GPIO27 = 109,
	IMX_F2_GPIO27 = 110,
	IMX_F3_GPIO27 = 111,
	IMX_F0_GPIO28 = 112,
	IMX_F1_GPIO28 = 113,
	IMX_F2_GPIO28 = 114,
	IMX_F3_GPIO28 = 115,
	IMX_F0_GPIO29 = 116,
	IMX_F1_GPIO29 = 117,
	IMX_F2_GPIO29 = 118,
	IMX_F3_GPIO29 = 119,
	IMX_F0_GPIO30 = 120,
	IMX_F1_GPIO30 = 121,
	IMX_F2_GPIO30 = 122,
	IMX_F3_GPIO30 = 123,
	IMX_F0_GPIO31 = 124,
	IMX_F1_GPIO31 = 125,
	IMX_F2_GPIO31 = 126,
	IMX_F3_GPIO31 = 127,
	IMX_F0_GPIO32 = 128,
	IMX_F1_GPIO32 = 129,
	IMX_F2_GPIO32 = 130,
	IMX_F3_GPIO32 = 131,
	IMX_F0_GPIO33 = 132,
	IMX_F1_GPIO33 = 133,
	IMX_F2_GPIO33 = 134,
	IMX_F3_GPIO33 = 135,
	IMX_F0_GPIO34 = 136,
	IMX_F1_GPIO34 = 137,
	IMX_F2_GPIO34 = 138,
	IMX_F3_GPIO34 = 139,
	IMX_F0_GPIO35 = 140,
	IMX_F1_GPIO35 = 141,
	IMX_F2_GPIO35 = 142,
	IMX_F3_GPIO35 = 143,
	IMX_F0_GPIO36 = 144,
	IMX_F1_GPIO36 = 145,
	IMX_F2_GPIO36 = 146,
	IMX_F3_GPIO36 = 147,
	IMX_F0_GPIO37 = 148,
	IMX_F1_GPIO37 = 149,
	IMX_F2_GPIO37 = 150,
	IMX_F3_GPIO37 = 151,
	IMX_F0_GPIO38 = 152,
	IMX_F1_GPIO38 = 153,
	IMX_F2_GPIO38 = 154,
	IMX_F3_GPIO38 = 155,
	IMX_F0_GPIO39 = 156,
	IMX_F1_GPIO39 = 157,
	IMX_F2_GPIO39 = 158,
	IMX_F3_GPIO39 = 159,
	IMX_F0_GPIO40 = 160,
	IMX_F1_GPIO40 = 161,
	IMX_F2_GPIO40 = 162,
	IMX_F3_GPIO40 = 163,
	IMX_F0_GPIO41 = 164,
	IMX_F1_GPIO41 = 165,
	IMX_F2_GPIO41 = 166,
	IMX_F3_GPIO41 = 167,
	IMX_F0_GPIO42 = 168,
	IMX_F1_GPIO42 = 169,
	IMX_F2_GPIO42 = 170,
	IMX_F3_GPIO42 = 171,
	IMX_F0_GPIO43 = 172,
	IMX_F1_GPIO43 = 173,
	IMX_F2_GPIO43 = 174,
	IMX_F3_GPIO43 = 175,
	IMX_F0_GPIO44 = 176,
	IMX_F1_GPIO44 = 177,
	IMX_F2_GPIO44 = 178,
	IMX_F3_GPIO44 = 179,
	IMX_F0_GPIO45 = 180,
	IMX_F1_GPIO45 = 181,
	IMX_F2_GPIO45 = 182,
	IMX_F3_GPIO45 = 183,
	IMX_F0_GPIO46 = 184,
	IMX_F1_GPIO46 = 185,
	IMX_F2_GPIO46 = 186,
	IMX_F3_GPIO46 = 187,
	IMX_F0_GPIO47 = 188,
	IMX_F1_GPIO47 = 189,
	IMX_F2_GPIO47 = 190,
	IMX_F3_GPIO47 = 191,
	IMX_F0_GPIO48 = 192,
	IMX_F1_GPIO48 = 193,
	IMX_F2_GPIO48 = 194,
	IMX_F3_GPIO48 = 195,
	IMX_F0_GPIO49 = 196,
	IMX_F1_GPIO49 = 197,
	IMX_F2_GPIO49 = 198,
	IMX_F3_GPIO49 = 199,
	IMX_F0_GPIO50 = 200,
	IMX_F1_GPIO50 = 201,
	IMX_F2_GPIO50 = 202,
	IMX_F3_GPIO50 = 203,
	IMX_F0_GPIO51 = 204,
	IMX_F1_GPIO51 = 205,
	IMX_F2_GPIO51 = 206,
	IMX_F3_GPIO51 = 207,
	IMX_F0_GPIO52 = 208,
	IMX_F1_GPIO52 = 209,
	IMX_F2_GPIO52 = 210,
	IMX_F3_GPIO52 = 211,
	IMX_F0_GPIO53 = 212,
	IMX_F1_GPIO53 = 213,
	IMX_F2_GPIO53 = 214,
	IMX_F3_GPIO53 = 215,
	IMX_F0_GPIO54 = 216,
	IMX_F1_GPIO54 = 217,
	IMX_F2_GPIO54 = 218,
	IMX_F3_GPIO54 = 219,
	IMX_F0_GPIO55 = 220,
	IMX_F1_GPIO55 = 221,
	IMX_F2_GPIO55 = 222,
	IMX_F3_GPIO55 = 223,
	IMX_F0_GPIO56 = 224,
	IMX_F1_GPIO56 = 225,
	IMX_F2_GPIO56 = 226,
	IMX_F3_GPIO56 = 227,
	IMX_F0_GPIO57 = 228,
	IMX_F1_GPIO57 = 229,
	IMX_F2_GPIO57 = 230,
	IMX_F3_GPIO57 = 231,
	IMX_F0_GPIO58 = 232,
	IMX_F1_GPIO58 = 233,
	IMX_F2_GPIO58 = 234,
	IMX_F3_GPIO58 = 235,
	IMX_F0_GPIO59 = 236,
	IMX_F1_GPIO59 = 237,
	IMX_F2_GPIO59 = 238,
	IMX_F3_GPIO59 = 239,
	IMX_F0_GPIO60 = 240,
	IMX_F1_GPIO60 = 241,
	IMX_F2_GPIO60 = 242,
	IMX_F3_GPIO60 = 243,
	IMX_F0_GPIO61 = 244,
	IMX_F1_GPIO61 = 245,
	IMX_F2_GPIO61 = 246,
	IMX_F3_GPIO61 = 247,
	IMX_F0_GPIO62 = 248,
	IMX_F1_GPIO62 = 249,
	IMX_F2_GPIO62 = 250,
	IMX_F3_GPIO62 = 251,
	IMX_F0_GPIO64 = 252,
	IMX_F1_GPIO64 = 253,
	IMX_F2_GPIO64 = 254,
	IMX_F3_GPIO64 = 255,
	IMX_F0_GPIO65 = 256,
	IMX_F1_GPIO65 = 257,
	IMX_F2_GPIO65 = 258,
	IMX_F3_GPIO65 = 259,
	IMX_F0_GPIO66 = 260,
	IMX_F1_GPIO66 = 261,
	IMX_F2_GPIO66 = 262,
	IMX_F3_GPIO66 = 263,
	IMX_F0_GPIO67 = 264,
	IMX_F1_GPIO67 = 265,
	IMX_F2_GPIO67 = 266,
	IMX_F3_GPIO67 = 267,
	IMX_F0_GPIO68 = 268,
	IMX_F1_GPIO68 = 269,
	IMX_F2_GPIO68 = 270,
	IMX_F3_GPIO68 = 271,
	IMX_F0_GPIO69 = 272,
	IMX_F1_GPIO69 = 273,
	IMX_F2_GPIO69 = 274,
	IMX_F3_GPIO69 = 275,
	IMX_F0_GPIO70 = 276,
	IMX_F1_GPIO70 = 277,
	IMX_F2_GPIO70 = 278,
	IMX_F3_GPIO70 = 279,
	IMX_F0_GPIO71 = 280,
	IMX_F1_GPIO71 = 281,
	IMX_F2_GPIO71 = 282,
	IMX_F3_GPIO71 = 283,
	IMX_F0_GPIO72 = 284,
	IMX_F1_GPIO72 = 285,
	IMX_F2_GPIO72 = 286,
	IMX_F3_GPIO72 = 287,
	IMX_F0_GPIO73 = 288,
	IMX_F1_GPIO73 = 289,
	IMX_F2_GPIO73 = 290,
	IMX_F3_GPIO73 = 291,
	IMX_F0_GPIO74 = 292,
	IMX_F1_GPIO74 = 293,
	IMX_F2_GPIO74 = 294,
	IMX_F3_GPIO74 = 295,
	IMX_F0_GPIO75 = 296,
	IMX_F1_GPIO75 = 297,
	IMX_F2_GPIO75 = 298,
	IMX_F3_GPIO75 = 299,
	IMX_F0_GPIO76 = 300,
	IMX_F1_GPIO76 = 301,
	IMX_F2_GPIO76 = 302,
	IMX_F3_GPIO76 = 303,
	IMX_F0_GPIO77 = 304,
	IMX_F1_GPIO77 = 305,
	IMX_F2_GPIO77 = 306,
	IMX_F3_GPIO77 = 307,
	IMX_F0_GPIO78 = 308,
	IMX_F1_GPIO78 = 309,
	IMX_F2_GPIO78 = 310,
	IMX_F3_GPIO78 = 311,
	IMX_F0_GPIO79 = 312,
	IMX_F1_GPIO79 = 313,
	IMX_F2_GPIO79 = 314,
	IMX_F3_GPIO79 = 315,
	IMX_F0_GPIO80 = 316,
	IMX_F1_GPIO80 = 317,
	IMX_F2_GPIO80 = 318,
	IMX_F3_GPIO80 = 319,
	IMX_F0_GPIO81 = 320,
	IMX_F1_GPIO81 = 321,
	IMX_F2_GPIO81 = 322,
	IMX_F3_GPIO81 = 323,
	IMX_F0_GPIO82 = 324,
	IMX_F1_GPIO82 = 325,
	IMX_F2_GPIO82 = 326,
	IMX_F3_GPIO82 = 327,
	IMX_F0_GPIO83 = 328,
	IMX_F1_GPIO83 = 329,
	IMX_F2_GPIO83 = 330,
	IMX_F3_GPIO83 = 331,
	IMX_F0_GPIO84 = 332,
	IMX_F1_GPIO84 = 333,
	IMX_F2_GPIO84 = 334,
	IMX_F3_GPIO84 = 335,
	IMX_F0_GPIO85 = 336,
	IMX_F1_GPIO85 = 337,
	IMX_F2_GPIO85 = 338,
	IMX_F3_GPIO85 = 339,
	IMX_F0_GPIO86 = 340,
	IMX_F1_GPIO86 = 341,
	IMX_F2_GPIO86 = 342,
	IMX_F3_GPIO86 = 343,
	IMX_F0_GPIO87 = 344,
	IMX_F1_GPIO87 = 345,
	IMX_F2_GPIO87 = 346,
	IMX_F3_GPIO87 = 347,
	IMX_F0_GPIO88 = 348,
	IMX_F1_GPIO88 = 349,
	IMX_F2_GPIO88 = 350,
	IMX_F3_GPIO88 = 351,
	IMX_F0_GPIO89 = 352,
	IMX_F1_GPIO89 = 353,
	IMX_F2_GPIO89 = 354,
	IMX_F3_GPIO89 = 355,
	IMX_F0_GPIO90 = 356,
	IMX_F1_GPIO90 = 357,
	IMX_F2_GPIO90 = 358,
	IMX_F3_GPIO90 = 359,
	IMX_F0_GPIO91 = 360,
	IMX_F1_GPIO91 = 361,
	IMX_F2_GPIO91 = 362,
	IMX_F3_GPIO91 = 363,
	IMX_F0_GPIO92 = 364,
	IMX_F1_GPIO92 = 365,
	IMX_F2_GPIO92 = 366,
	IMX_F3_GPIO92 = 367,
	IMX_F0_GPIO93 = 368,
	IMX_F1_GPIO93 = 369,
	IMX_F2_GPIO93 = 370,
	IMX_F3_GPIO93 = 371,
	IMX_F0_GPIO94 = 372,
	IMX_F1_GPIO94 = 373,
	IMX_F2_GPIO94 = 374,
	IMX_F3_GPIO94 = 375,
	IMX_F0_GPIO95 = 376,
	IMX_F1_GPIO95 = 377,
	IMX_F2_GPIO95 = 378,
	IMX_F3_GPIO95 = 379,
	IMX_F0_GPIO96 = 380,
	IMX_F1_GPIO96 = 381,
	IMX_F2_GPIO96 = 382,
	IMX_F3_GPIO96 = 383,
	IMX_F0_GPIO97 = 384,
	IMX_F1_GPIO97 = 385,
	IMX_F2_GPIO97 = 386,
	IMX_F3_GPIO97 = 387,
	IMX_F0_GPIO98 = 388,
	IMX_F1_GPIO98 = 389,
	IMX_F2_GPIO98 = 390,
	IMX_F3_GPIO98 = 391,
	IMX_F0_GPIO99 = 392,
	IMX_F1_GPIO99 = 393,
	IMX_F2_GPIO99 = 394,
	IMX_F3_GPIO99 = 395,
	IMX_F0_GPIO100 = 396,
	IMX_F1_GPIO100 = 397,
	IMX_F2_GPIO100 = 398,
	IMX_F3_GPIO100 = 399,
	IMX_F0_GPIO101 = 400,
	IMX_F1_GPIO101 = 401,
	IMX_F2_GPIO101 = 402,
	IMX_F3_GPIO101 = 403,
	IMX_F0_GPIO102 = 404,
	IMX_F1_GPIO102 = 405,
	IMX_F2_GPIO102 = 406,
	IMX_F3_GPIO102 = 407,
	IMX_F0_GPIO103 = 408,
	IMX_F1_GPIO103 = 409,
	IMX_F2_GPIO103 = 410,
	IMX_F3_GPIO103 = 411,
	IMX_F0_GPIO104 = 412,
	IMX_F1_GPIO104 = 413,
	IMX_F2_GPIO104 = 414,
	IMX_F3_GPIO104 = 415,
	IMX_F0_GPIO105 = 416,
	IMX_F1_GPIO105 = 417,
	IMX_F2_GPIO105 = 418,
	IMX_F3_GPIO105 = 419,
	IMX_F0_GPIO106 = 420,
	IMX_F1_GPIO106 = 421,
	IMX_F2_GPIO106 = 422,
	IMX_F3_GPIO106 = 423,
	IMX_F0_GPIO107 = 424,
	IMX_F1_GPIO107 = 425,
	IMX_F2_GPIO107 = 426,
	IMX_F3_GPIO107 = 427,
	IMX_F0_GPIO108 = 428,
	IMX_F1_GPIO108 = 429,
	IMX_F2_GPIO108 = 430,
	IMX_F3_GPIO108 = 431,
	IMX_F0_GPIO109 = 432,
	IMX_F1_GPIO109 = 433,
	IMX_F2_GPIO109 = 434,
	IMX_F3_GPIO109 = 435,
	IMX_F0_GPIO110 = 436,
	IMX_F1_GPIO110 = 437,
	IMX_F2_GPIO110 = 438,
	IMX_F3_GPIO110 = 439,
	IMX_F0_GPIO111 = 440,
	IMX_F1_GPIO111 = 441,
	IMX_F2_GPIO111 = 442,
	IMX_F3_GPIO111 = 443,
	IMX_F0_GPIO112 = 444,
	IMX_F1_GPIO112 = 445,
	IMX_F2_GPIO112 = 446,
	IMX_F3_GPIO112 = 447,
	IMX_F0_GPIO113 = 448,
	IMX_F1_GPIO113 = 449,
	IMX_F2_GPIO113 = 450,
	IMX_F3_GPIO113 = 451,
	IMX_F0_GPIO114 = 452,
	IMX_F1_GPIO114 = 453,
	IMX_F2_GPIO114 = 454,
	IMX_F3_GPIO114 = 455,
	IMX_F0_GPIO115 = 456,
	IMX_F1_GPIO115 = 457,
	IMX_F2_GPIO115 = 458,
	IMX_F3_GPIO115 = 459,
	IMX_F0_GPIO116 = 460,
	IMX_F1_GPIO116 = 461,
	IMX_F2_GPIO116 = 462,
	IMX_F3_GPIO116 = 463,
	IMX_F0_GPIO117 = 464,
	IMX_F1_GPIO117 = 465,
	IMX_F2_GPIO117 = 466,
	IMX_F3_GPIO117 = 467,
	IMX_F0_GPIO118 = 468,
	IMX_F1_GPIO118 = 469,
	IMX_F2_GPIO118 = 470,
	IMX_F3_GPIO118 = 471,
	IMX_F0_GPIO119 = 472,
	IMX_F1_GPIO119 = 473,
	IMX_F2_GPIO119 = 474,
	IMX_F3_GPIO119 = 475,
	IMX_F0_GPIO120 = 476,
	IMX_F1_GPIO120 = 477,
	IMX_F2_GPIO120 = 478,
	IMX_F3_GPIO120 = 479,
	IMX_F0_GPIO121 = 480,
	IMX_F1_GPIO121 = 481,
	IMX_F2_GPIO121 = 482,
	IMX_F3_GPIO121 = 483,
	IMX_F0_GPIO122 = 484,
	IMX_F1_GPIO122 = 485,
	IMX_F2_GPIO122 = 486,
	IMX_F3_GPIO122 = 487,
	IMX_F0_GPIO123 = 488,
	IMX_F1_GPIO123 = 489,
	IMX_F2_GPIO123 = 490,
	IMX_F3_GPIO123 = 491,
	IMX_F0_GPIO124 = 492,
	IMX_F1_GPIO124 = 493,
	IMX_F2_GPIO124 = 494,
	IMX_F3_GPIO124 = 495,
	IMX_F0_GPIO125 = 496,
	IMX_F1_GPIO125 = 497,
	IMX_F2_GPIO125 = 498,
	IMX_F3_GPIO125 = 499,
	IMX_F0_GPIO126 = 500,
	IMX_F1_GPIO126 = 501,
	IMX_F2_GPIO126 = 502,
	IMX_F3_GPIO126 = 503,
	IMX_F0_GPIO127 = 504,
	IMX_F1_GPIO127 = 505,
	IMX_F2_GPIO127 = 506,
	IMX_F3_GPIO127 = 507,
	IMX_F0_GPIO128 = 508,
	IMX_F1_GPIO128 = 509,
	IMX_F2_GPIO128 = 510,
	IMX_F3_GPIO128 = 511,
	IMX_F0_GPIO129 = 512,
	IMX_F1_GPIO129 = 513,
	IMX_F2_GPIO129 = 514,
	IMX_F3_GPIO129 = 515,
	IMX_F0_GPIO130 = 516,
	IMX_F1_GPIO130 = 517,
	IMX_F2_GPIO130 = 518,
	IMX_F3_GPIO130 = 519,
	IMX_F0_GPIO131 = 520,
	IMX_F1_GPIO131 = 521,
	IMX_F2_GPIO131 = 522,
	IMX_F3_GPIO131 = 523,
	IMX_F0_GPIO132 = 524,
	IMX_F1_GPIO132 = 525,
	IMX_F2_GPIO132 = 526,
	IMX_F3_GPIO132 = 527,
	IMX_F0_GPIO133 = 528,
	IMX_F1_GPIO133 = 529,
	IMX_F2_GPIO133 = 530,
	IMX_F3_GPIO133 = 531,
	IMX_F0_GPIO134 = 532,
	IMX_F1_GPIO134 = 533,
	IMX_F2_GPIO134 = 534,
	IMX_F3_GPIO134 = 535,
	IMX_F0_GPIO135 = 536,
	IMX_F1_GPIO135 = 537,
	IMX_F2_GPIO135 = 538,
	IMX_F3_GPIO135 = 539,
	IMX_F0_GPIO136 = 540,
	IMX_F1_GPIO136 = 541,
	IMX_F2_GPIO136 = 542,
	IMX_F3_GPIO136 = 543,
	IMX_F0_GPIO137 = 544,
	IMX_F1_GPIO137 = 545,
	IMX_F2_GPIO137 = 546,
	IMX_F3_GPIO137 = 547,
	IMX_F0_GPIO138 = 548,
	IMX_F1_GPIO138 = 549,
	IMX_F2_GPIO138 = 550,
	IMX_F3_GPIO138 = 551,
	IMX_F0_GPIO139 = 552,
	IMX_F1_GPIO139 = 553,
	IMX_F2_GPIO139 = 554,
	IMX_F3_GPIO139 = 555,
	IMX_F0_GPIO140 = 556,
	IMX_F1_GPIO140 = 557,
	IMX_F2_GPIO140 = 558,
	IMX_F3_GPIO140 = 559,
	IMX_F0_GPIO141 = 560,
	IMX_F1_GPIO141 = 561,
	IMX_F2_GPIO141 = 562,
	IMX_F3_GPIO141 = 563,
	IMX_F0_GPIO142 = 564,
	IMX_F1_GPIO142 = 565,
	IMX_F2_GPIO142 = 566,
	IMX_F3_GPIO142 = 567,
	IMX_F0_GPIO143 = 568,
	IMX_F1_GPIO143 = 569,
	IMX_F2_GPIO143 = 570,
	IMX_F3_GPIO143 = 571,
	IMX_F0_GPIO144 = 572,
	IMX_F1_GPIO144 = 573,
	IMX_F2_GPIO144 = 574,
	IMX_F3_GPIO144 = 575,
};

enum amd_spi_speed {
	F_66_66MHz = 0,
	F_33_33MHz = 1,
	F_22_22MHz = 2,
	F_16_66MHz = 3,
	F_100MHz = 4,
	F_800KHz = 5,
	SPI_SPD7 = 7,
	F_50MHz = 4,
	F_4MHz = 50,
	F_3_17MHz = 63,
};

enum amd_spi_versions {
	AMD_SPI_V1 = 1,
	AMD_SPI_V2 = 2,
};

enum arch_timer_erratum_match_type {
	ate_match_dt = 0,
	ate_match_local_cap_id = 1,
	ate_match_acpi_oem_info = 2,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arch_timer_spi_nr {
	ARCH_TIMER_PHYS_SPI = 0,
	ARCH_TIMER_VIRT_SPI = 1,
	ARCH_TIMER_MAX_TIMER_SPI = 2,
};

enum arm64_bp_harden_el1_vectors {
	EL1_VECTOR_BHB_LOOP = 0,
	EL1_VECTOR_BHB_FW = 1,
	EL1_VECTOR_BHB_CLEAR_INSN = 2,
	EL1_VECTOR_KPTI = 3,
};

enum arm64_hyp_spectre_vector {
	HYP_VECTOR_DIRECT = 0,
	HYP_VECTOR_SPECTRE_DIRECT = 1,
	HYP_VECTOR_INDIRECT = 2,
	HYP_VECTOR_SPECTRE_INDIRECT = 3,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum arm_smmu_arch_version {
	ARM_SMMU_V1 = 0,
	ARM_SMMU_V1_64K = 1,
	ARM_SMMU_V2 = 2,
};

enum arm_smmu_cbar_type {
	CBAR_TYPE_S2_TRANS = 0,
	CBAR_TYPE_S1_TRANS_S2_BYPASS = 1,
	CBAR_TYPE_S1_TRANS_S2_FAULT = 2,
	CBAR_TYPE_S1_TRANS_S2_TRANS = 3,
};

enum arm_smmu_context_fmt {
	ARM_SMMU_CTX_FMT_NONE = 0,
	ARM_SMMU_CTX_FMT_AARCH64 = 1,
	ARM_SMMU_CTX_FMT_AARCH32_L = 2,
	ARM_SMMU_CTX_FMT_AARCH32_S = 3,
};

enum arm_smmu_domain_stage {
	ARM_SMMU_DOMAIN_S1 = 0,
	ARM_SMMU_DOMAIN_S2 = 1,
};

enum arm_smmu_domain_stage___2 {
	ARM_SMMU_DOMAIN_S1___2 = 0,
	ARM_SMMU_DOMAIN_S2___2 = 1,
	ARM_SMMU_DOMAIN_NESTED = 2,
};

enum arm_smmu_implementation {
	GENERIC_SMMU = 0,
	ARM_MMU500 = 1,
	CAVIUM_SMMUV2 = 2,
	QCOM_SMMUV2 = 3,
};

enum arm_smmu_msi_index {
	EVTQ_MSI_INDEX = 0,
	GERROR_MSI_INDEX = 1,
	PRIQ_MSI_INDEX = 2,
	ARM_SMMU_MAX_MSIS = 3,
};

enum arm_smmu_s2cr_privcfg {
	S2CR_PRIVCFG_DEFAULT = 0,
	S2CR_PRIVCFG_DIPAN = 1,
	S2CR_PRIVCFG_UNPRIV = 2,
	S2CR_PRIVCFG_PRIV = 3,
};

enum arm_smmu_s2cr_type {
	S2CR_TYPE_TRANS = 0,
	S2CR_TYPE_BYPASS = 1,
	S2CR_TYPE_FAULT = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum array_state {
	clear = 0,
	inactive = 1,
	suspended = 2,
	readonly = 3,
	read_auto = 4,
	clean = 5,
	active = 6,
	write_pending = 7,
	active_idle = 8,
	broken = 9,
	bad_word = 10,
};

enum as3722_irq {
	AS3722_IRQ_LID = 0,
	AS3722_IRQ_ACOK = 1,
	AS3722_IRQ_ENABLE1 = 2,
	AS3722_IRQ_OCCUR_ALARM_SD0 = 3,
	AS3722_IRQ_ONKEY_LONG_PRESS = 4,
	AS3722_IRQ_ONKEY = 5,
	AS3722_IRQ_OVTMP = 6,
	AS3722_IRQ_LOWBAT = 7,
	AS3722_IRQ_SD0_LV = 8,
	AS3722_IRQ_SD1_LV = 9,
	AS3722_IRQ_SD2_LV = 10,
	AS3722_IRQ_PWM1_OV_PROT = 11,
	AS3722_IRQ_PWM2_OV_PROT = 12,
	AS3722_IRQ_ENABLE2 = 13,
	AS3722_IRQ_SD6_LV = 14,
	AS3722_IRQ_RTC_REP = 15,
	AS3722_IRQ_RTC_ALARM = 16,
	AS3722_IRQ_GPIO1 = 17,
	AS3722_IRQ_GPIO2 = 18,
	AS3722_IRQ_GPIO3 = 19,
	AS3722_IRQ_GPIO4 = 20,
	AS3722_IRQ_GPIO5 = 21,
	AS3722_IRQ_WATCHDOG = 22,
	AS3722_IRQ_ENABLE3 = 23,
	AS3722_IRQ_TEMP_SD0_SHUTDOWN = 24,
	AS3722_IRQ_TEMP_SD1_SHUTDOWN = 25,
	AS3722_IRQ_TEMP_SD2_SHUTDOWN = 26,
	AS3722_IRQ_TEMP_SD0_ALARM = 27,
	AS3722_IRQ_TEMP_SD1_ALARM = 28,
	AS3722_IRQ_TEMP_SD6_ALARM = 29,
	AS3722_IRQ_OCCUR_ALARM_SD6 = 30,
	AS3722_IRQ_ADC = 31,
	AS3722_IRQ_MAX = 32,
};

enum as3722_pinmux_option {
	AS3722_PINMUX_GPIO = 0,
	AS3722_PINMUX_INTERRUPT_OUT = 1,
	AS3722_PINMUX_VSUB_VBAT_UNDEB_LOW_OUT = 2,
	AS3722_PINMUX_GPIO_INTERRUPT = 3,
	AS3722_PINMUX_PWM_INPUT = 4,
	AS3722_PINMUX_VOLTAGE_IN_STBY = 5,
	AS3722_PINMUX_OC_PG_SD0 = 6,
	AS3722_PINMUX_PG_OUT = 7,
	AS3722_PINMUX_CLK32K_OUT = 8,
	AS3722_PINMUX_WATCHDOG_INPUT = 9,
	AS3722_PINMUX_SOFT_RESET_IN = 11,
	AS3722_PINMUX_PWM_OUTPUT = 12,
	AS3722_PINMUX_VSUB_VBAT_LOW_DEB_OUT = 13,
	AS3722_PINMUX_OC_PG_SD6 = 14,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_ID_DEV_LOG = 27,
	__ATA_QUIRK_NO_LOG_DIR = 28,
	__ATA_QUIRK_NO_FUA = 29,
	__ATA_QUIRK_MAX = 30,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP717_ID = 8,
	AXP803_ID = 9,
	AXP806_ID = 10,
	AXP809_ID = 11,
	AXP813_ID = 12,
	AXP15060_ID = 13,
	NR_AXP20X_VARIANTS = 14,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum backlight_notification {
	BACKLIGHT_REGISTERED = 0,
	BACKLIGHT_UNREGISTERED = 1,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum backlight_update_reason {
	BACKLIGHT_UPDATE_HOTKEY = 0,
	BACKLIGHT_UPDATE_SYSFS = 1,
};

enum bam_reg {
	BAM_CTRL = 0,
	BAM_REVISION = 1,
	BAM_NUM_PIPES = 2,
	BAM_DESC_CNT_TRSHLD = 3,
	BAM_IRQ_SRCS = 4,
	BAM_IRQ_SRCS_MSK = 5,
	BAM_IRQ_SRCS_UNMASKED = 6,
	BAM_IRQ_STTS = 7,
	BAM_IRQ_CLR = 8,
	BAM_IRQ_EN = 9,
	BAM_CNFG_BITS = 10,
	BAM_IRQ_SRCS_EE = 11,
	BAM_IRQ_SRCS_MSK_EE = 12,
	BAM_P_CTRL = 13,
	BAM_P_RST = 14,
	BAM_P_HALT = 15,
	BAM_P_IRQ_STTS = 16,
	BAM_P_IRQ_CLR = 17,
	BAM_P_IRQ_EN = 18,
	BAM_P_EVNT_DEST_ADDR = 19,
	BAM_P_EVNT_REG = 20,
	BAM_P_SW_OFSTS = 21,
	BAM_P_DATA_FIFO_ADDR = 22,
	BAM_P_DESC_FIFO_ADDR = 23,
	BAM_P_EVNT_GEN_TRSHLD = 24,
	BAM_P_FIFO_SIZES = 25,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

enum bhb_mitigation_bits {
	BHB_LOOP = 0,
	BHB_FW = 1,
	BHB_HW = 2,
	BHB_INSN = 3,
};

enum binder_deferred_state {
	BINDER_DEFERRED_FLUSH = 1,
	BINDER_DEFERRED_RELEASE = 2,
};

enum binder_driver_command_protocol {
	BC_TRANSACTION = 1077961472,
	BC_REPLY = 1077961473,
	BC_ACQUIRE_RESULT = 1074029314,
	BC_FREE_BUFFER = 1074291459,
	BC_INCREFS = 1074029316,
	BC_ACQUIRE = 1074029317,
	BC_RELEASE = 1074029318,
	BC_DECREFS = 1074029319,
	BC_INCREFS_DONE = 1074815752,
	BC_ACQUIRE_DONE = 1074815753,
	BC_ATTEMPT_ACQUIRE = 1074291466,
	BC_REGISTER_LOOPER = 25355,
	BC_ENTER_LOOPER = 25356,
	BC_EXIT_LOOPER = 25357,
	BC_REQUEST_DEATH_NOTIFICATION = 1074553614,
	BC_CLEAR_DEATH_NOTIFICATION = 1074553615,
	BC_DEAD_BINDER_DONE = 1074291472,
	BC_TRANSACTION_SG = 1078485777,
	BC_REPLY_SG = 1078485778,
	BC_REQUEST_FREEZE_NOTIFICATION = 1074553619,
	BC_CLEAR_FREEZE_NOTIFICATION = 1074553620,
	BC_FREEZE_NOTIFICATION_DONE = 1074291477,
};

enum binder_driver_return_protocol {
	BR_ERROR = 2147774976,
	BR_OK = 29185,
	BR_TRANSACTION_SEC_CTX = 2152231426,
	BR_TRANSACTION = 2151707138,
	BR_REPLY = 2151707139,
	BR_ACQUIRE_RESULT = 2147774980,
	BR_DEAD_REPLY = 29189,
	BR_TRANSACTION_COMPLETE = 29190,
	BR_INCREFS = 2148561415,
	BR_ACQUIRE = 2148561416,
	BR_RELEASE = 2148561417,
	BR_DECREFS = 2148561418,
	BR_ATTEMPT_ACQUIRE = 2149085707,
	BR_NOOP = 29196,
	BR_SPAWN_LOOPER = 29197,
	BR_FINISHED = 29198,
	BR_DEAD_BINDER = 2148037135,
	BR_CLEAR_DEATH_NOTIFICATION_DONE = 2148037136,
	BR_FAILED_REPLY = 29201,
	BR_FROZEN_REPLY = 29202,
	BR_ONEWAY_SPAM_SUSPECT = 29203,
	BR_TRANSACTION_PENDING_FROZEN = 29204,
	BR_FROZEN_BINDER = 2148561429,
	BR_CLEAR_FREEZE_NOTIFICATION_DONE = 2148037142,
};

enum binder_stat_types {
	BINDER_STAT_PROC = 0,
	BINDER_STAT_THREAD = 1,
	BINDER_STAT_NODE = 2,
	BINDER_STAT_REF = 3,
	BINDER_STAT_DEATH = 4,
	BINDER_STAT_TRANSACTION = 5,
	BINDER_STAT_TRANSACTION_COMPLETE = 6,
	BINDER_STAT_FREEZE = 7,
	BINDER_STAT_COUNT = 8,
};

enum binder_work_type {
	BINDER_WORK_TRANSACTION = 1,
	BINDER_WORK_TRANSACTION_COMPLETE = 2,
	BINDER_WORK_TRANSACTION_PENDING = 3,
	BINDER_WORK_TRANSACTION_ONEWAY_SPAM_SUSPECT = 4,
	BINDER_WORK_RETURN_ERROR = 5,
	BINDER_WORK_NODE = 6,
	BINDER_WORK_DEAD_BINDER = 7,
	BINDER_WORK_DEAD_BINDER_AND_CLEAR = 8,
	BINDER_WORK_CLEAR_DEATH_NOTIFICATION = 9,
	BINDER_WORK_FROZEN_BINDER = 10,
	BINDER_WORK_CLEAR_FREEZE_NOTIFICATION = 11,
};

enum binderfs_param {
	Opt_max___2 = 0,
	Opt_stats_mode = 1,
};

enum binderfs_stats_mode {
	binderfs_stats_mode_unset = 0,
	binderfs_stats_mode_global = 1,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bios_platform_class {
	BIOS_CLIENT = 0,
	BIOS_SERVER = 1,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_CTRL_NOCHECK = 4,
	BIP_DISK_NOCHECK = 8,
	BIP_IP_CHECKSUM = 16,
	BIP_COPY_USER = 32,
};

enum bitmap_page_attr {
	BITMAP_PAGE_DIRTY = 0,
	BITMAP_PAGE_PENDING = 1,
	BITMAP_PAGE_NEEDWRITE = 2,
};

enum bitmap_state {
	BITMAP_STALE = 1,
	BITMAP_WRITE_ERROR = 2,
	BITMAP_HOSTENDIAN = 15,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2b_iv {
	BLAKE2B_IV0 = 7640891576956012808ULL,
	BLAKE2B_IV1 = 13503953896175478587ULL,
	BLAKE2B_IV2 = 4354685564936845355ULL,
	BLAKE2B_IV3 = 11912009170470909681ULL,
	BLAKE2B_IV4 = 5840696475078001361ULL,
	BLAKE2B_IV5 = 11170449401992604703ULL,
	BLAKE2B_IV6 = 2270897969802886507ULL,
	BLAKE2B_IV7 = 6620516959819538809ULL,
};

enum blake2b_lengths {
	BLAKE2B_BLOCK_SIZE = 128,
	BLAKE2B_HASH_SIZE = 64,
	BLAKE2B_KEY_SIZE = 64,
	BLAKE2B_160_HASH_SIZE = 20,
	BLAKE2B_256_HASH_SIZE = 32,
	BLAKE2B_384_HASH_SIZE = 48,
	BLAKE2B_512_HASH_SIZE = 64,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum blktrace_cat {
	BLK_TC_READ = 1,
	BLK_TC_WRITE = 2,
	BLK_TC_FLUSH = 4,
	BLK_TC_SYNC = 8,
	BLK_TC_SYNCIO = 8,
	BLK_TC_QUEUE = 16,
	BLK_TC_REQUEUE = 32,
	BLK_TC_ISSUE = 64,
	BLK_TC_COMPLETE = 128,
	BLK_TC_FS = 256,
	BLK_TC_PC = 512,
	BLK_TC_NOTIFY = 1024,
	BLK_TC_AHEAD = 2048,
	BLK_TC_META = 4096,
	BLK_TC_DISCARD = 8192,
	BLK_TC_DRV_DATA = 16384,
	BLK_TC_FUA = 32768,
	BLK_TC_END = 32768,
};

enum blktrace_notify {
	__BLK_TN_PROCESS = 0,
	__BLK_TN_TIMESTAMP = 1,
	__BLK_TN_MESSAGE = 2,
	__BLK_TN_CGROUP = 256,
};

enum bm_rcr_cmode {
	bm_rcr_cci = 0,
	bm_rcr_cce = 1,
};

enum bm_rcr_pmode {
	bm_rcr_pci = 0,
	bm_rcr_pce = 1,
	bm_rcr_pvb = 2,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_al = 9,
	board_ahci_avn = 10,
	board_ahci_mcp65 = 11,
	board_ahci_mcp77 = 12,
	board_ahci_mcp89 = 13,
	board_ahci_mv = 14,
	board_ahci_sb600 = 15,
	board_ahci_sb700 = 16,
	board_ahci_vt8251 = 17,
	board_ahci_mcp_linux = 11,
	board_ahci_mcp67 = 11,
	board_ahci_mcp73 = 11,
	board_ahci_mcp79 = 12,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	__MAX_BPF_ATTACH_TYPE = 57,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_lwt_encap_mode {
	BPF_LWT_ENCAP_SEG6 = 0,
	BPF_LWT_ENCAP_SEG6_INLINE = 1,
	BPF_LWT_ENCAP_IP = 2,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum btrfs_block_group_flags {
	BLOCK_GROUP_FLAG_IREF = 0,
	BLOCK_GROUP_FLAG_REMOVED = 1,
	BLOCK_GROUP_FLAG_TO_COPY = 2,
	BLOCK_GROUP_FLAG_RELOCATING_REPAIR = 3,
	BLOCK_GROUP_FLAG_CHUNK_ITEM_INSERTED = 4,
	BLOCK_GROUP_FLAG_ZONE_IS_ACTIVE = 5,
	BLOCK_GROUP_FLAG_ZONED_DATA_RELOC = 6,
	BLOCK_GROUP_FLAG_NEEDS_FREE_SPACE = 7,
	BLOCK_GROUP_FLAG_SEQUENTIAL_ZONE = 8,
	BLOCK_GROUP_FLAG_NEW = 9,
};

enum btrfs_block_group_size_class {
	BTRFS_BG_SZ_NONE = 0,
	BTRFS_BG_SZ_SMALL = 1,
	BTRFS_BG_SZ_MEDIUM = 2,
	BTRFS_BG_SZ_LARGE = 3,
};

enum btrfs_caching_type {
	BTRFS_CACHE_NO = 0,
	BTRFS_CACHE_STARTED = 1,
	BTRFS_CACHE_FINISHED = 2,
	BTRFS_CACHE_ERROR = 3,
};

enum btrfs_chunk_alloc_enum {
	CHUNK_ALLOC_NO_FORCE = 0,
	CHUNK_ALLOC_LIMITED = 1,
	CHUNK_ALLOC_FORCE = 2,
	CHUNK_ALLOC_FORCE_FOR_EXTENT = 3,
};

enum btrfs_chunk_allocation_policy {
	BTRFS_CHUNK_ALLOC_REGULAR = 0,
	BTRFS_CHUNK_ALLOC_ZONED = 1,
};

enum btrfs_compare_tree_result {
	BTRFS_COMPARE_TREE_NEW = 0,
	BTRFS_COMPARE_TREE_DELETED = 1,
	BTRFS_COMPARE_TREE_CHANGED = 2,
	BTRFS_COMPARE_TREE_SAME = 3,
};

enum btrfs_compression_type {
	BTRFS_COMPRESS_NONE = 0,
	BTRFS_COMPRESS_ZLIB = 1,
	BTRFS_COMPRESS_LZO = 2,
	BTRFS_COMPRESS_ZSTD = 3,
	BTRFS_NR_COMPRESS_TYPES = 4,
};

enum btrfs_csum_type {
	BTRFS_CSUM_TYPE_CRC32 = 0,
	BTRFS_CSUM_TYPE_XXHASH = 1,
	BTRFS_CSUM_TYPE_SHA256 = 2,
	BTRFS_CSUM_TYPE_BLAKE2 = 3,
};

enum btrfs_delayed_item_type {
	BTRFS_DELAYED_INSERTION_ITEM = 0,
	BTRFS_DELAYED_DELETION_ITEM = 1,
};

enum btrfs_delayed_ref_action {
	BTRFS_ADD_DELAYED_REF = 1,
	BTRFS_DROP_DELAYED_REF = 2,
	BTRFS_ADD_DELAYED_EXTENT = 3,
	BTRFS_UPDATE_DELAYED_HEAD = 4,
} __attribute__((mode(byte)));

enum btrfs_delayed_ref_flags {
	BTRFS_DELAYED_REFS_FLUSHING = 0,
};

enum btrfs_dev_stat_values {
	BTRFS_DEV_STAT_WRITE_ERRS = 0,
	BTRFS_DEV_STAT_READ_ERRS = 1,
	BTRFS_DEV_STAT_FLUSH_ERRS = 2,
	BTRFS_DEV_STAT_CORRUPTION_ERRS = 3,
	BTRFS_DEV_STAT_GENERATION_ERRS = 4,
	BTRFS_DEV_STAT_VALUES_MAX = 5,
};

enum btrfs_discard_state {
	BTRFS_DISCARD_EXTENTS = 0,
	BTRFS_DISCARD_BITMAPS = 1,
	BTRFS_DISCARD_RESET_CURSOR = 2,
};

enum btrfs_disk_cache_state {
	BTRFS_DC_WRITTEN = 0,
	BTRFS_DC_ERROR = 1,
	BTRFS_DC_CLEAR = 2,
	BTRFS_DC_SETUP = 3,
};

enum btrfs_err_code {
	BTRFS_ERROR_DEV_RAID1_MIN_NOT_MET = 1,
	BTRFS_ERROR_DEV_RAID10_MIN_NOT_MET = 2,
	BTRFS_ERROR_DEV_RAID5_MIN_NOT_MET = 3,
	BTRFS_ERROR_DEV_RAID6_MIN_NOT_MET = 4,
	BTRFS_ERROR_DEV_TGT_REPLACE = 5,
	BTRFS_ERROR_DEV_MISSING_NOT_FOUND = 6,
	BTRFS_ERROR_DEV_ONLY_WRITABLE = 7,
	BTRFS_ERROR_DEV_EXCL_RUN_IN_PROGRESS = 8,
	BTRFS_ERROR_DEV_RAID1C3_MIN_NOT_MET = 9,
	BTRFS_ERROR_DEV_RAID1C4_MIN_NOT_MET = 10,
};

enum btrfs_exclusive_operation {
	BTRFS_EXCLOP_NONE = 0,
	BTRFS_EXCLOP_BALANCE_PAUSED = 1,
	BTRFS_EXCLOP_BALANCE = 2,
	BTRFS_EXCLOP_DEV_ADD = 3,
	BTRFS_EXCLOP_DEV_REMOVE = 4,
	BTRFS_EXCLOP_DEV_REPLACE = 5,
	BTRFS_EXCLOP_RESIZE = 6,
	BTRFS_EXCLOP_SWAP_ACTIVATE = 7,
};

enum btrfs_extent_allocation_policy {
	BTRFS_EXTENT_ALLOC_CLUSTERED = 0,
	BTRFS_EXTENT_ALLOC_ZONED = 1,
};

enum btrfs_feature_set {
	FEAT_COMPAT = 0,
	FEAT_COMPAT_RO = 1,
	FEAT_INCOMPAT = 2,
	FEAT_MAX = 3,
};

enum btrfs_flush_state {
	FLUSH_DELAYED_ITEMS_NR = 1,
	FLUSH_DELAYED_ITEMS = 2,
	FLUSH_DELAYED_REFS_NR = 3,
	FLUSH_DELAYED_REFS = 4,
	FLUSH_DELALLOC = 5,
	FLUSH_DELALLOC_WAIT = 6,
	FLUSH_DELALLOC_FULL = 7,
	ALLOC_CHUNK = 8,
	ALLOC_CHUNK_FORCE = 9,
	RUN_DELAYED_IPUTS = 10,
	COMMIT_TRANS = 11,
};

enum btrfs_ilock_type {
	__BTRFS_ILOCK_SHARED_BIT = 0,
	BTRFS_ILOCK_SHARED = 1,
	__BTRFS_ILOCK_SHARED_SEQ = 0,
	__BTRFS_ILOCK_TRY_BIT = 1,
	BTRFS_ILOCK_TRY = 2,
	__BTRFS_ILOCK_TRY_SEQ = 1,
	__BTRFS_ILOCK_MMAP_BIT = 2,
	BTRFS_ILOCK_MMAP = 4,
	__BTRFS_ILOCK_MMAP_SEQ = 2,
};

enum btrfs_inline_ref_type {
	BTRFS_REF_TYPE_INVALID = 0,
	BTRFS_REF_TYPE_BLOCK = 1,
	BTRFS_REF_TYPE_DATA = 2,
	BTRFS_REF_TYPE_ANY = 3,
};

enum btrfs_lock_nesting {
	BTRFS_NESTING_NORMAL = 0,
	BTRFS_NESTING_COW = 1,
	BTRFS_NESTING_LEFT = 2,
	BTRFS_NESTING_RIGHT = 3,
	BTRFS_NESTING_LEFT_COW = 4,
	BTRFS_NESTING_RIGHT_COW = 5,
	BTRFS_NESTING_SPLIT = 6,
	BTRFS_NESTING_NEW_ROOT = 7,
	BTRFS_NESTING_MAX = 8,
};

enum btrfs_loop_type {
	LOOP_CACHING_NOWAIT = 0,
	LOOP_CACHING_WAIT = 1,
	LOOP_UNSET_SIZE_CLASS = 2,
	LOOP_ALLOC_CHUNK = 3,
	LOOP_WRONG_SIZE_CLASS = 4,
	LOOP_NO_EMPTY_SIZE = 5,
};

enum btrfs_map_op {
	BTRFS_MAP_READ = 0,
	BTRFS_MAP_WRITE = 1,
	BTRFS_MAP_GET_READ_MIRRORS = 2,
};

enum btrfs_mod_log_op {
	BTRFS_MOD_LOG_KEY_REPLACE = 0,
	BTRFS_MOD_LOG_KEY_ADD = 1,
	BTRFS_MOD_LOG_KEY_REMOVE = 2,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_FREEING = 3,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_MOVING = 4,
	BTRFS_MOD_LOG_MOVE_KEYS = 5,
	BTRFS_MOD_LOG_ROOT_REPLACE = 6,
};

enum btrfs_qgroup_mode {
	BTRFS_QGROUP_MODE_DISABLED = 0,
	BTRFS_QGROUP_MODE_FULL = 1,
	BTRFS_QGROUP_MODE_SIMPLE = 2,
};

enum btrfs_qgroup_rsv_type {
	BTRFS_QGROUP_RSV_DATA = 0,
	BTRFS_QGROUP_RSV_META_PERTRANS = 1,
	BTRFS_QGROUP_RSV_META_PREALLOC = 2,
	BTRFS_QGROUP_RSV_LAST = 3,
};

enum btrfs_raid_types {
	BTRFS_RAID_SINGLE = 0,
	BTRFS_RAID_RAID0 = 1,
	BTRFS_RAID_RAID1 = 2,
	BTRFS_RAID_DUP = 3,
	BTRFS_RAID_RAID10 = 4,
	BTRFS_RAID_RAID5 = 5,
	BTRFS_RAID_RAID6 = 6,
	BTRFS_RAID_RAID1C3 = 7,
	BTRFS_RAID_RAID1C4 = 8,
	BTRFS_NR_RAID_TYPES = 9,
};

enum btrfs_rbio_ops {
	BTRFS_RBIO_WRITE = 0,
	BTRFS_RBIO_READ_REBUILD = 1,
	BTRFS_RBIO_PARITY_SCRUB = 2,
};

enum btrfs_read_policy {
	BTRFS_READ_POLICY_PID = 0,
	BTRFS_NR_READ_POLICY = 1,
};

enum btrfs_ref_type {
	BTRFS_REF_NOT_SET = 0,
	BTRFS_REF_DATA = 1,
	BTRFS_REF_METADATA = 2,
	BTRFS_REF_LAST = 3,
} __attribute__((mode(byte)));

enum btrfs_reserve_flush_enum {
	BTRFS_RESERVE_NO_FLUSH = 0,
	BTRFS_RESERVE_FLUSH_LIMIT = 1,
	BTRFS_RESERVE_FLUSH_EVICT = 2,
	BTRFS_RESERVE_FLUSH_DATA = 3,
	BTRFS_RESERVE_FLUSH_FREE_SPACE_INODE = 4,
	BTRFS_RESERVE_FLUSH_ALL = 5,
	BTRFS_RESERVE_FLUSH_ALL_STEAL = 6,
	BTRFS_RESERVE_FLUSH_EMERGENCY = 7,
};

enum btrfs_rsv_type {
	BTRFS_BLOCK_RSV_GLOBAL = 0,
	BTRFS_BLOCK_RSV_DELALLOC = 1,
	BTRFS_BLOCK_RSV_TRANS = 2,
	BTRFS_BLOCK_RSV_CHUNK = 3,
	BTRFS_BLOCK_RSV_DELOPS = 4,
	BTRFS_BLOCK_RSV_DELREFS = 5,
	BTRFS_BLOCK_RSV_EMPTY = 6,
	BTRFS_BLOCK_RSV_TEMP = 7,
};

enum btrfs_send_cmd {
	BTRFS_SEND_C_UNSPEC = 0,
	BTRFS_SEND_C_SUBVOL = 1,
	BTRFS_SEND_C_SNAPSHOT = 2,
	BTRFS_SEND_C_MKFILE = 3,
	BTRFS_SEND_C_MKDIR = 4,
	BTRFS_SEND_C_MKNOD = 5,
	BTRFS_SEND_C_MKFIFO = 6,
	BTRFS_SEND_C_MKSOCK = 7,
	BTRFS_SEND_C_SYMLINK = 8,
	BTRFS_SEND_C_RENAME = 9,
	BTRFS_SEND_C_LINK = 10,
	BTRFS_SEND_C_UNLINK = 11,
	BTRFS_SEND_C_RMDIR = 12,
	BTRFS_SEND_C_SET_XATTR = 13,
	BTRFS_SEND_C_REMOVE_XATTR = 14,
	BTRFS_SEND_C_WRITE = 15,
	BTRFS_SEND_C_CLONE = 16,
	BTRFS_SEND_C_TRUNCATE = 17,
	BTRFS_SEND_C_CHMOD = 18,
	BTRFS_SEND_C_CHOWN = 19,
	BTRFS_SEND_C_UTIMES = 20,
	BTRFS_SEND_C_END = 21,
	BTRFS_SEND_C_UPDATE_EXTENT = 22,
	BTRFS_SEND_C_MAX_V1 = 22,
	BTRFS_SEND_C_FALLOCATE = 23,
	BTRFS_SEND_C_FILEATTR = 24,
	BTRFS_SEND_C_ENCODED_WRITE = 25,
	BTRFS_SEND_C_MAX_V2 = 25,
	BTRFS_SEND_C_ENABLE_VERITY = 26,
	BTRFS_SEND_C_MAX_V3 = 26,
	BTRFS_SEND_C_MAX = 26,
};

enum btrfs_subpage_type {
	BTRFS_SUBPAGE_METADATA = 0,
	BTRFS_SUBPAGE_DATA = 1,
};

enum btrfs_trans_state {
	TRANS_STATE_RUNNING = 0,
	TRANS_STATE_COMMIT_PREP = 1,
	TRANS_STATE_COMMIT_START = 2,
	TRANS_STATE_COMMIT_DOING = 3,
	TRANS_STATE_UNBLOCKED = 4,
	TRANS_STATE_SUPER_COMMITTED = 5,
	TRANS_STATE_COMPLETED = 6,
	TRANS_STATE_MAX = 7,
};

enum btrfs_tree_block_status {
	BTRFS_TREE_BLOCK_CLEAN = 0,
	BTRFS_TREE_BLOCK_INVALID_NRITEMS = 1,
	BTRFS_TREE_BLOCK_INVALID_PARENT_KEY = 2,
	BTRFS_TREE_BLOCK_BAD_KEY_ORDER = 3,
	BTRFS_TREE_BLOCK_INVALID_LEVEL = 4,
	BTRFS_TREE_BLOCK_INVALID_FREE_SPACE = 5,
	BTRFS_TREE_BLOCK_INVALID_OFFSETS = 6,
	BTRFS_TREE_BLOCK_INVALID_BLOCKPTR = 7,
	BTRFS_TREE_BLOCK_INVALID_ITEM = 8,
	BTRFS_TREE_BLOCK_INVALID_OWNER = 9,
	BTRFS_TREE_BLOCK_WRITTEN_NOT_SET = 10,
};

enum btrfs_trim_state {
	BTRFS_TRIM_STATE_UNTRIMMED = 0,
	BTRFS_TRIM_STATE_TRIMMED = 1,
	BTRFS_TRIM_STATE_TRIMMING = 2,
};

enum buddy {
	FIRST = 0,
	LAST = 1,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum cache_indexing {
	NODE_CACHE_DIRECT_MAP = 0,
	NODE_CACHE_INDEXED = 1,
	NODE_CACHE_OTHER = 2,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cache_write_policy {
	NODE_CACHE_WRITE_BACK = 0,
	NODE_CACHE_WRITE_THROUGH = 1,
	NODE_CACHE_WRITE_OTHER = 2,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_HOST_SEV_SNP = 6,
};

enum cdns_pcie_rp_bar {
	RP_BAR_UNDEFINED = -1,
	RP_BAR0 = 0,
	RP_BAR1 = 1,
	RP_NO_BAR = 2,
};

enum cdrom_print_option {
	CTL_NAME = 0,
	CTL_SPEED = 1,
	CTL_SLOTS = 2,
	CTL_CAPABILITY = 3,
};

enum cee_attrs {
	DCB_ATTR_CEE_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_PG = 1,
	DCB_ATTR_CEE_PEER_PFC = 2,
	DCB_ATTR_CEE_PEER_APP_TABLE = 3,
	DCB_ATTR_CEE_TX_PG = 4,
	DCB_ATTR_CEE_RX_PG = 5,
	DCB_ATTR_CEE_PFC = 6,
	DCB_ATTR_CEE_APP_TABLE = 7,
	DCB_ATTR_CEE_FEAT = 8,
	__DCB_ATTR_CEE_MAX = 9,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 37,
	MAX_CGROUP_BPF_ATTACH_TYPE = 38,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	pids_cgrp_id = 10,
	rdma_cgrp_id = 11,
	misc_cgrp_id = 12,
	CGROUP_SUBSYS_COUNT = 13,
};

enum cgt_group_id {
	__RESERVED__ = 0,
	CGT_HCR_TID1 = 1,
	CGT_HCR_TID2 = 2,
	CGT_HCR_TID3 = 3,
	CGT_HCR_IMO = 4,
	CGT_HCR_FMO = 5,
	CGT_HCR_TIDCP = 6,
	CGT_HCR_TACR = 7,
	CGT_HCR_TSW = 8,
	CGT_HCR_TPC = 9,
	CGT_HCR_TPU = 10,
	CGT_HCR_TTLB = 11,
	CGT_HCR_TVM = 12,
	CGT_HCR_TDZ = 13,
	CGT_HCR_TRVM = 14,
	CGT_HCR_TLOR = 15,
	CGT_HCR_TERR = 16,
	CGT_HCR_APK = 17,
	CGT_HCR_NV = 18,
	CGT_HCR_NV_nNV2 = 19,
	CGT_HCR_NV1_nNV2 = 20,
	CGT_HCR_AT = 21,
	CGT_HCR_nFIEN = 22,
	CGT_HCR_TID4 = 23,
	CGT_HCR_TICAB = 24,
	CGT_HCR_TOCU = 25,
	CGT_HCR_ENSCXT = 26,
	CGT_HCR_TTLBIS = 27,
	CGT_HCR_TTLBOS = 28,
	CGT_MDCR_TPMCR = 29,
	CGT_MDCR_TPM = 30,
	CGT_MDCR_TDE = 31,
	CGT_MDCR_TDA = 32,
	CGT_MDCR_TDOSA = 33,
	CGT_MDCR_TDRA = 34,
	CGT_MDCR_E2PB = 35,
	CGT_MDCR_TPMS = 36,
	CGT_MDCR_TTRF = 37,
	CGT_MDCR_E2TB = 38,
	CGT_MDCR_TDCC = 39,
	CGT_CPACR_E0POE = 40,
	CGT_CPTR_TAM = 41,
	CGT_CPTR_TCPAC = 42,
	CGT_HCRX_EnFPM = 43,
	CGT_HCRX_TCR2En = 44,
	CGT_ICH_HCR_TC = 45,
	CGT_ICH_HCR_TALL0 = 46,
	CGT_ICH_HCR_TALL1 = 47,
	CGT_ICH_HCR_TDIR = 48,
	__MULTIPLE_CONTROL_BITS__ = 49,
	CGT_HCR_IMO_FMO_ICH_HCR_TC = 49,
	CGT_HCR_TID2_TID4 = 50,
	CGT_HCR_TTLB_TTLBIS = 51,
	CGT_HCR_TTLB_TTLBOS = 52,
	CGT_HCR_TVM_TRVM = 53,
	CGT_HCR_TVM_TRVM_HCRX_TCR2En = 54,
	CGT_HCR_TPU_TICAB = 55,
	CGT_HCR_TPU_TOCU = 56,
	CGT_HCR_NV1_nNV2_ENSCXT = 57,
	CGT_MDCR_TPM_TPMCR = 58,
	CGT_MDCR_TDE_TDA = 59,
	CGT_MDCR_TDE_TDOSA = 60,
	CGT_MDCR_TDE_TDRA = 61,
	CGT_MDCR_TDCC_TDE_TDA = 62,
	CGT_ICH_HCR_TC_TDIR = 63,
	__COMPLEX_CONDITIONS__ = 64,
	CGT_CNTHCTL_EL1PCTEN = 64,
	CGT_CNTHCTL_EL1PTEN = 65,
	CGT_CPTR_TTA = 66,
	__NR_CGT_GROUP_IDS__ = 67,
};

enum chacha20poly1305_lengths {
	XCHACHA20POLY1305_NONCE_SIZE = 24,
	CHACHA20POLY1305_KEY_SIZE = 32,
	CHACHA20POLY1305_AUTHTAG_SIZE = 16,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_ids {
	LAST_DT_CORE_CLK = 18,
	CLK_EXTAL = 19,
	CLK_OSC_DIV1000 = 20,
	CLK_PLL1 = 21,
	CLK_PLL2 = 22,
	CLK_PLL2_DIV2 = 23,
	CLK_PLL2_DIV2_8 = 24,
	CLK_PLL2_DIV2_10 = 25,
	CLK_PLL3 = 26,
	CLK_PLL3_400 = 27,
	CLK_PLL3_533 = 28,
	CLK_PLL3_DIV2 = 29,
	CLK_PLL3_DIV2_4 = 30,
	CLK_PLL3_DIV2_4_2 = 31,
	CLK_SEL_PLL3_3 = 32,
	CLK_DIV_PLL3_C = 33,
	CLK_M2_DIV2 = 34,
	CLK_PLL5 = 35,
	CLK_PLL5_500 = 36,
	CLK_PLL5_250 = 37,
	CLK_PLL5_FOUTPOSTDIV = 38,
	CLK_DSI_DIV = 39,
	CLK_PLL6 = 40,
	CLK_PLL6_250 = 41,
	CLK_P1_DIV2 = 42,
	CLK_PLL2_800 = 43,
	CLK_PLL2_SDHI_533 = 44,
	CLK_PLL2_SDHI_400 = 45,
	CLK_PLL2_SDHI_266 = 46,
	CLK_SD0_DIV4 = 47,
	CLK_SD1_DIV4 = 48,
	MOD_CLK_BASE = 49,
};

enum clk_ids___2 {
	LAST_DT_CORE_CLK___2 = 25,
	CLK_EXTAL___2 = 26,
	CLK_OSC_DIV1000___2 = 27,
	CLK_PLL1___2 = 28,
	CLK_PLL2___2 = 29,
	CLK_PLL2_DIV2___2 = 30,
	CLK_PLL2_DIV2_8___2 = 31,
	CLK_PLL2_DIV2_10___2 = 32,
	CLK_PLL3___2 = 33,
	CLK_PLL3_400___2 = 34,
	CLK_PLL3_533___2 = 35,
	CLK_M2_DIV2___2 = 36,
	CLK_PLL3_DIV2___2 = 37,
	CLK_PLL3_DIV2_2 = 38,
	CLK_PLL3_DIV2_4___2 = 39,
	CLK_PLL3_DIV2_4_2___2 = 40,
	CLK_SEL_PLL3_3___2 = 41,
	CLK_DIV_PLL3_C___2 = 42,
	CLK_PLL4 = 43,
	CLK_PLL5___2 = 44,
	CLK_PLL5_FOUTPOSTDIV___2 = 45,
	CLK_PLL5_FOUT1PH0 = 46,
	CLK_PLL5_FOUT3 = 47,
	CLK_PLL5_250___2 = 48,
	CLK_PLL6___2 = 49,
	CLK_PLL6_250___2 = 50,
	CLK_P1_DIV2___2 = 51,
	CLK_PLL2_800___2 = 52,
	CLK_PLL2_SDHI_533___2 = 53,
	CLK_PLL2_SDHI_400___2 = 54,
	CLK_PLL2_SDHI_266___2 = 55,
	CLK_SD0_DIV4___2 = 56,
	CLK_SD1_DIV4___2 = 57,
	CLK_SEL_GPU2 = 58,
	CLK_SEL_PLL5_4 = 59,
	CLK_DSI_DIV___2 = 60,
	CLK_PLL2_533 = 61,
	CLK_PLL2_533_DIV2 = 62,
	CLK_DIV_DSI_LPCLK = 63,
	MOD_CLK_BASE___2 = 64,
};

enum clk_ids___3 {
	LAST_DT_CORE_CLK___3 = 8,
	CLK_AUDIO_EXTAL = 9,
	CLK_RTXIN = 10,
	CLK_QEXTAL = 11,
	CLK_PLLCM33 = 12,
	CLK_PLLCLN = 13,
	CLK_PLLDTY = 14,
	CLK_PLLCA55 = 15,
	CLK_PLLCM33_DIV16 = 16,
	CLK_PLLCLN_DIV2 = 17,
	CLK_PLLCLN_DIV8 = 18,
	CLK_PLLCLN_DIV16 = 19,
	CLK_PLLDTY_ACPU = 20,
	CLK_PLLDTY_ACPU_DIV4 = 21,
	MOD_CLK_BASE___3 = 22,
};

enum clk_ids___4 {
	LAST_DT_CORE_CLK___4 = 24,
	CLK_EXTAL___3 = 25,
	CLK_OSC_DIV1000___3 = 26,
	CLK_PLL1___3 = 27,
	CLK_PLL2___3 = 28,
	CLK_PLL2_DIV2___3 = 29,
	CLK_PLL2_DIV2_8___3 = 30,
	CLK_PLL2_DIV6 = 31,
	CLK_PLL3___3 = 32,
	CLK_PLL3_DIV2___3 = 33,
	CLK_PLL3_DIV2_4___3 = 34,
	CLK_PLL3_DIV2_8 = 35,
	CLK_PLL3_DIV6 = 36,
	CLK_PLL4___2 = 37,
	CLK_PLL6___3 = 38,
	CLK_PLL6_DIV2 = 39,
	CLK_SEL_SDHI0 = 40,
	CLK_SEL_SDHI1 = 41,
	CLK_SEL_SDHI2 = 42,
	CLK_SEL_PLL4 = 43,
	CLK_P1_DIV2___3 = 44,
	CLK_P3_DIV2 = 45,
	CLK_SD0_DIV4___3 = 46,
	CLK_SD1_DIV4___3 = 47,
	CLK_SD2_DIV4 = 48,
	MOD_CLK_BASE___4 = 49,
};

enum clk_ids___5 {
	LAST_DT_CORE_CLK___5 = 0,
	CLK_EXTAL___4 = 1,
	CLK_MAIN = 2,
	CLK_MAIN_24 = 3,
	CLK_MAIN_2 = 4,
	CLK_PLL1___4 = 5,
	CLK_PLL2___4 = 6,
	CLK_PLL2_800___3 = 7,
	CLK_PLL2_400 = 8,
	CLK_PLL2_200 = 9,
	CLK_PLL2_100 = 10,
	CLK_PLL4___3 = 11,
	CLK_DIV_A = 12,
	CLK_DIV_B = 13,
	CLK_DIV_D = 14,
	CLK_DIV_E = 15,
	CLK_DIV_W = 16,
	CLK_SEL_B = 17,
	CLK_SEL_B_D2 = 18,
	CLK_SEL_CSI0 = 19,
	CLK_SEL_CSI4 = 20,
	CLK_SEL_D = 21,
	CLK_SEL_E = 22,
	CLK_SEL_SDI = 23,
	CLK_SEL_W0 = 24,
	MOD_CLK_BASE___5 = 25,
};

enum clk_ids___6 {
	LAST_DT_CORE_CLK___6 = 46,
	CLK_EXTAL___5 = 47,
	CLK_EXTALR = 48,
	CLK_MAIN___2 = 49,
	CLK_PLL0 = 50,
	CLK_PLL1___5 = 51,
	CLK_PLL2___5 = 52,
	CLK_PLL3___4 = 53,
	CLK_PLL4___4 = 54,
	CLK_PLL1_DIV2 = 55,
	CLK_PLL1_DIV4 = 56,
	CLK_S0 = 57,
	CLK_S1 = 58,
	CLK_S2 = 59,
	CLK_S3 = 60,
	CLK_SDSRC = 61,
	CLK_RPCSRC = 62,
	CLK_RINT = 63,
	MOD_CLK_BASE___6 = 64,
};

enum clk_reg_layout {
	CLK_REG_LAYOUT_RCAR_GEN2_AND_GEN3 = 0,
	CLK_REG_LAYOUT_RZ_A = 1,
	CLK_REG_LAYOUT_RCAR_GEN4 = 2,
};

enum clk_sel {
	LOW_SPEED_IO_SEL = 0,
	NON_IO_SEL = 1,
	FAST_SEL = 2,
	AUDIO_SEL = 3,
	VIDEO_SEL = 4,
	TPM_SEL = 5,
	CKO1_SEL = 6,
	CKO2_SEL = 7,
	MISC_SEL = 8,
	MAX_SEL = 9,
};

enum clk_state {
	CLK_STATE_DISABLE = 0,
	CLK_STATE_ENABLE = 1,
	CLK_STATE_RESERVED = 2,
	CLK_STATE_UNCHANGED = 3,
};

enum clk_type {
	CLK_TYPE_OUTPUT = 0,
	CLK_TYPE_EXTERNAL = 1,
};

enum clk_type_t {
	CLK_EXT_DIFF = 0,
	CLK_INT_DIFF = 1,
	CLK_INT_SING = 2,
};

enum clk_types {
	CLK_TYPE_IN = 0,
	CLK_TYPE_FF = 1,
	CLK_TYPE_PLL = 2,
	CLK_TYPE_DDIV = 3,
};

enum clk_types___2 {
	CLK_TYPE_IN___2 = 0,
	CLK_TYPE_FF___2 = 1,
	CLK_TYPE_SAM_PLL = 2,
	CLK_TYPE_G3S_PLL = 3,
	CLK_TYPE_DIV = 4,
	CLK_TYPE_G3S_DIV = 5,
	CLK_TYPE_MUX = 6,
	CLK_TYPE_SD_MUX = 7,
	CLK_TYPE_SIPLL5 = 8,
	CLK_TYPE_PLL5_4_MUX = 9,
	CLK_TYPE_DSI_DIV = 10,
};

enum clk_types___3 {
	CLK_TYPE_IN___3 = 0,
	CLK_TYPE_FF___3 = 1,
	CLK_TYPE_DIV6P1 = 2,
	CLK_TYPE_DIV6_RO = 3,
	CLK_TYPE_FR = 4,
	CLK_TYPE_CUSTOM = 5,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_X86_TSC_EARLY = 2,
	CSID_X86_TSC = 3,
	CSID_X86_KVM_CLK = 4,
	CSID_X86_ART = 5,
	CSID_MAX = 6,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum cmd_db_hw_type {
	CMD_DB_HW_INVALID = 0,
	CMD_DB_HW_MIN = 3,
	CMD_DB_HW_ARC = 3,
	CMD_DB_HW_VRM = 4,
	CMD_DB_HW_BCM = 5,
	CMD_DB_HW_MAX = 5,
	CMD_DB_HW_ALL = 255,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum cmu_type_t {
	REF_CMU = 0,
	PHY_CMU = 1,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum compat_regset {
	REGSET_COMPAT_GPR = 0,
	REGSET_COMPAT_VFP = 1,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_MCE_DEAD = 8,
	CPUHP_VIRT_NET_DEAD = 9,
	CPUHP_IBMVNIC_DEAD = 10,
	CPUHP_SLUB_DEAD = 11,
	CPUHP_DEBUG_OBJ_DEAD = 12,
	CPUHP_MM_WRITEBACK_DEAD = 13,
	CPUHP_MM_VMSTAT_DEAD = 14,
	CPUHP_SOFTIRQ_DEAD = 15,
	CPUHP_NET_MVNETA_DEAD = 16,
	CPUHP_CPUIDLE_DEAD = 17,
	CPUHP_ARM64_FPSIMD_DEAD = 18,
	CPUHP_ARM_OMAP_WAKE_DEAD = 19,
	CPUHP_IRQ_POLL_DEAD = 20,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 21,
	CPUHP_BIO_DEAD = 22,
	CPUHP_ACPI_CPUDRV_DEAD = 23,
	CPUHP_S390_PFAULT_DEAD = 24,
	CPUHP_BLK_MQ_DEAD = 25,
	CPUHP_FS_BUFF_DEAD = 26,
	CPUHP_PRINTK_DEAD = 27,
	CPUHP_MM_MEMCQ_DEAD = 28,
	CPUHP_PERCPU_CNT_DEAD = 29,
	CPUHP_RADIX_DEAD = 30,
	CPUHP_PAGE_ALLOC = 31,
	CPUHP_NET_DEV_DEAD = 32,
	CPUHP_PCI_XGENE_DEAD = 33,
	CPUHP_IOMMU_IOVA_DEAD = 34,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 35,
	CPUHP_PADATA_DEAD = 36,
	CPUHP_AP_DTPM_CPU_DEAD = 37,
	CPUHP_RANDOM_PREPARE = 38,
	CPUHP_WORKQUEUE_PREP = 39,
	CPUHP_POWER_NUMA_PREPARE = 40,
	CPUHP_HRTIMERS_PREPARE = 41,
	CPUHP_X2APIC_PREPARE = 42,
	CPUHP_SMPCFD_PREPARE = 43,
	CPUHP_RELAY_PREPARE = 44,
	CPUHP_MD_RAID5_PREPARE = 45,
	CPUHP_RCUTREE_PREP = 46,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 47,
	CPUHP_POWERPC_PMAC_PREPARE = 48,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 49,
	CPUHP_XEN_PREPARE = 50,
	CPUHP_XEN_EVTCHN_PREPARE = 51,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 52,
	CPUHP_SH_SH3X_PREPARE = 53,
	CPUHP_TOPOLOGY_PREPARE = 54,
	CPUHP_NET_IUCV_PREPARE = 55,
	CPUHP_ARM_BL_PREPARE = 56,
	CPUHP_TRACE_RB_PREPARE = 57,
	CPUHP_MM_ZS_PREPARE = 58,
	CPUHP_MM_ZSWP_POOL_PREPARE = 59,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 60,
	CPUHP_ZCOMP_PREPARE = 61,
	CPUHP_TIMERS_PREPARE = 62,
	CPUHP_TMIGR_PREPARE = 63,
	CPUHP_MIPS_SOC_PREPARE = 64,
	CPUHP_BP_PREPARE_DYN = 65,
	CPUHP_BP_PREPARE_DYN_END = 85,
	CPUHP_BP_KICK_AP = 86,
	CPUHP_BRINGUP_CPU = 87,
	CPUHP_AP_IDLE_DEAD = 88,
	CPUHP_AP_OFFLINE = 89,
	CPUHP_AP_CACHECTRL_STARTING = 90,
	CPUHP_AP_SCHED_STARTING = 91,
	CPUHP_AP_RCUTREE_DYING = 92,
	CPUHP_AP_CPU_PM_STARTING = 93,
	CPUHP_AP_IRQ_GIC_STARTING = 94,
	CPUHP_AP_IRQ_HIP04_STARTING = 95,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 96,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 97,
	CPUHP_AP_IRQ_BCM2836_STARTING = 98,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 99,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 100,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 101,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 102,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 103,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 104,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 105,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 106,
	CPUHP_AP_PERF_X86_STARTING = 107,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 108,
	CPUHP_AP_PERF_XTENSA_STARTING = 109,
	CPUHP_AP_ARM_VFP_STARTING = 110,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 111,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 112,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 113,
	CPUHP_AP_PERF_ARM_STARTING = 114,
	CPUHP_AP_PERF_RISCV_STARTING = 115,
	CPUHP_AP_ARM_L2X0_STARTING = 116,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 117,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 118,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 119,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 120,
	CPUHP_AP_JCORE_TIMER_STARTING = 121,
	CPUHP_AP_ARM_TWD_STARTING = 122,
	CPUHP_AP_QCOM_TIMER_STARTING = 123,
	CPUHP_AP_TEGRA_TIMER_STARTING = 124,
	CPUHP_AP_ARMADA_TIMER_STARTING = 125,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 126,
	CPUHP_AP_ARC_TIMER_STARTING = 127,
	CPUHP_AP_REALTEK_TIMER_STARTING = 128,
	CPUHP_AP_RISCV_TIMER_STARTING = 129,
	CPUHP_AP_CLINT_TIMER_STARTING = 130,
	CPUHP_AP_CSKY_TIMER_STARTING = 131,
	CPUHP_AP_TI_GP_TIMER_STARTING = 132,
	CPUHP_AP_HYPERV_TIMER_STARTING = 133,
	CPUHP_AP_DUMMY_TIMER_STARTING = 134,
	CPUHP_AP_ARM_XEN_STARTING = 135,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 137,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 138,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 139,
	CPUHP_AP_SMPCFD_DYING = 140,
	CPUHP_AP_HRTIMERS_DYING = 141,
	CPUHP_AP_TICK_DYING = 142,
	CPUHP_AP_X86_TBOOT_DYING = 143,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 144,
	CPUHP_AP_ONLINE = 145,
	CPUHP_TEARDOWN_CPU = 146,
	CPUHP_AP_ONLINE_IDLE = 147,
	CPUHP_AP_HYPERV_ONLINE = 148,
	CPUHP_AP_KVM_ONLINE = 149,
	CPUHP_AP_SCHED_WAIT_EMPTY = 150,
	CPUHP_AP_SMPBOOT_THREADS = 151,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 152,
	CPUHP_AP_BLK_MQ_ONLINE = 153,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 154,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 155,
	CPUHP_AP_PERF_ONLINE = 156,
	CPUHP_AP_PERF_X86_ONLINE = 157,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 159,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 160,
	CPUHP_AP_PERF_X86_RAPL_ONLINE = 161,
	CPUHP_AP_PERF_S390_CF_ONLINE = 162,
	CPUHP_AP_PERF_S390_SF_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 164,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 173,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 175,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 176,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 185,
	CPUHP_AP_PERF_CSKY_ONLINE = 186,
	CPUHP_AP_TMIGR_ONLINE = 187,
	CPUHP_AP_WATCHDOG_ONLINE = 188,
	CPUHP_AP_WORKQUEUE_ONLINE = 189,
	CPUHP_AP_RANDOM_ONLINE = 190,
	CPUHP_AP_RCUTREE_ONLINE = 191,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 192,
	CPUHP_AP_ONLINE_DYN = 193,
	CPUHP_AP_ONLINE_DYN_END = 233,
	CPUHP_AP_X86_HPET_ONLINE = 234,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 235,
	CPUHP_AP_ACTIVE = 236,
	CPUHP_ONLINE = 237,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum crb_cancel {
	CRB_CANCEL_INVOKE = 1,
};

enum crb_ctrl_req {
	CRB_CTRL_REQ_CMD_READY = 1,
	CRB_CTRL_REQ_GO_IDLE = 2,
};

enum crb_ctrl_sts {
	CRB_CTRL_STS_ERROR = 1,
	CRB_CTRL_STS_TPM_IDLE = 2,
};

enum crb_defaults {
	CRB_ACPI_START_REVISION_ID = 1,
	CRB_ACPI_START_INDEX = 1,
};

enum crb_loc_ctrl {
	CRB_LOC_CTRL_REQUEST_ACCESS = 1,
	CRB_LOC_CTRL_RELINQUISH = 2,
};

enum crb_loc_state {
	CRB_LOC_STATE_LOC_ASSIGNED = 2,
	CRB_LOC_STATE_TPM_REG_VALID_STS = 128,
};

enum crb_start {
	CRB_START_INVOKE = 1,
};

enum crb_status {
	CRB_DRV_STS_COMPLETE = 1,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	__CRYPTOCFGA_MAX = 22,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cxl_event_type {
	CXL_CPER_EVENT_GENERIC = 0,
	CXL_CPER_EVENT_GEN_MEDIA = 1,
	CXL_CPER_EVENT_DRAM = 2,
	CXL_CPER_EVENT_MEM_MODULE = 3,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum damon_ops_id {
	DAMON_OPS_VADDR = 0,
	DAMON_OPS_FVADDR = 1,
	DAMON_OPS_PADDR = 2,
	NR_DAMON_OPS = 3,
};

enum damon_sysfs_cmd {
	DAMON_SYSFS_CMD_ON = 0,
	DAMON_SYSFS_CMD_OFF = 1,
	DAMON_SYSFS_CMD_COMMIT = 2,
	DAMON_SYSFS_CMD_COMMIT_SCHEMES_QUOTA_GOALS = 3,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_STATS = 4,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_BYTES = 5,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_REGIONS = 6,
	DAMON_SYSFS_CMD_CLEAR_SCHEMES_TRIED_REGIONS = 7,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_EFFECTIVE_QUOTAS = 8,
	NR_DAMON_SYSFS_CMDS = 9,
};

enum damos_action {
	DAMOS_WILLNEED = 0,
	DAMOS_COLD = 1,
	DAMOS_PAGEOUT = 2,
	DAMOS_HUGEPAGE = 3,
	DAMOS_NOHUGEPAGE = 4,
	DAMOS_LRU_PRIO = 5,
	DAMOS_LRU_DEPRIO = 6,
	DAMOS_MIGRATE_HOT = 7,
	DAMOS_MIGRATE_COLD = 8,
	DAMOS_STAT = 9,
	NR_DAMOS_ACTIONS = 10,
};

enum damos_filter_type {
	DAMOS_FILTER_TYPE_ANON = 0,
	DAMOS_FILTER_TYPE_MEMCG = 1,
	DAMOS_FILTER_TYPE_YOUNG = 2,
	DAMOS_FILTER_TYPE_ADDR = 3,
	DAMOS_FILTER_TYPE_TARGET = 4,
	NR_DAMOS_FILTER_TYPES = 5,
};

enum damos_quota_goal_metric {
	DAMOS_QUOTA_USER_INPUT = 0,
	DAMOS_QUOTA_SOME_MEM_PSI_US = 1,
	NR_DAMOS_QUOTA_GOAL_METRICS = 2,
};

enum damos_sysfs_regions_upd_status {
	DAMOS_TRIED_REGIONS_UPD_IDLE = 0,
	DAMOS_TRIED_REGIONS_UPD_STARTED = 1,
	DAMOS_TRIED_REGIONS_UPD_FINISHED = 2,
};

enum damos_wmark_metric {
	DAMOS_WMARK_NONE = 0,
	DAMOS_WMARK_FREE_MEM_RATE = 1,
	NR_DAMOS_WMARK_METRICS = 2,
};

enum data_formats {
	DATA_FMT_DIGEST = 0,
	DATA_FMT_DIGEST_WITH_ALGO = 1,
	DATA_FMT_DIGEST_WITH_TYPE_AND_ALGO = 2,
	DATA_FMT_STRING = 3,
	DATA_FMT_HEX = 4,
	DATA_FMT_UINT = 5,
};

enum data_mode {
	DATA_MODE_SLAB = 0,
	DATA_MODE_GET_FREE_PAGES = 1,
	DATA_MODE_VMALLOC = 2,
	DATA_MODE_LIMIT = 3,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dax_device_flags {
	DAXDEV_ALIVE = 0,
	DAXDEV_WRITE_CACHE = 1,
	DAXDEV_SYNC = 2,
	DAXDEV_NOCACHE = 3,
	DAXDEV_NOMC = 4,
};

enum dax_driver_type {
	DAXDRV_KMEM_TYPE = 0,
	DAXDRV_DEVICE_TYPE = 1,
};

enum dax_wake_mode {
	WAKE_ALL = 0,
	WAKE_NEXT = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbg_active_el {
	DBG_ACTIVE_EL0 = 0,
	DBG_ACTIVE_EL1 = 1,
};

enum dcb_general_attr_values {
	DCB_ATTR_VALUE_UNDEFINED = 255,
};

enum dcbevent_notif_type {
	DCB_APP_EVENT = 1,
};

enum dcbnl_app_attrs {
	DCB_APP_ATTR_UNDEFINED = 0,
	DCB_APP_ATTR_IDTYPE = 1,
	DCB_APP_ATTR_ID = 2,
	DCB_APP_ATTR_PRIORITY = 3,
	__DCB_APP_ATTR_ENUM_MAX = 4,
	DCB_APP_ATTR_MAX = 3,
};

enum dcbnl_attrs {
	DCB_ATTR_UNDEFINED = 0,
	DCB_ATTR_IFNAME = 1,
	DCB_ATTR_STATE = 2,
	DCB_ATTR_PFC_STATE = 3,
	DCB_ATTR_PFC_CFG = 4,
	DCB_ATTR_NUM_TC = 5,
	DCB_ATTR_PG_CFG = 6,
	DCB_ATTR_SET_ALL = 7,
	DCB_ATTR_PERM_HWADDR = 8,
	DCB_ATTR_CAP = 9,
	DCB_ATTR_NUMTCS = 10,
	DCB_ATTR_BCN = 11,
	DCB_ATTR_APP = 12,
	DCB_ATTR_IEEE = 13,
	DCB_ATTR_DCBX = 14,
	DCB_ATTR_FEATCFG = 15,
	DCB_ATTR_CEE = 16,
	__DCB_ATTR_ENUM_MAX = 17,
	DCB_ATTR_MAX = 16,
};

enum dcbnl_bcn_attrs {
	DCB_BCN_ATTR_UNDEFINED = 0,
	DCB_BCN_ATTR_RP_0 = 1,
	DCB_BCN_ATTR_RP_1 = 2,
	DCB_BCN_ATTR_RP_2 = 3,
	DCB_BCN_ATTR_RP_3 = 4,
	DCB_BCN_ATTR_RP_4 = 5,
	DCB_BCN_ATTR_RP_5 = 6,
	DCB_BCN_ATTR_RP_6 = 7,
	DCB_BCN_ATTR_RP_7 = 8,
	DCB_BCN_ATTR_RP_ALL = 9,
	DCB_BCN_ATTR_BCNA_0 = 10,
	DCB_BCN_ATTR_BCNA_1 = 11,
	DCB_BCN_ATTR_ALPHA = 12,
	DCB_BCN_ATTR_BETA = 13,
	DCB_BCN_ATTR_GD = 14,
	DCB_BCN_ATTR_GI = 15,
	DCB_BCN_ATTR_TMAX = 16,
	DCB_BCN_ATTR_TD = 17,
	DCB_BCN_ATTR_RMIN = 18,
	DCB_BCN_ATTR_W = 19,
	DCB_BCN_ATTR_RD = 20,
	DCB_BCN_ATTR_RU = 21,
	DCB_BCN_ATTR_WRTT = 22,
	DCB_BCN_ATTR_RI = 23,
	DCB_BCN_ATTR_C = 24,
	DCB_BCN_ATTR_ALL = 25,
	__DCB_BCN_ATTR_ENUM_MAX = 26,
	DCB_BCN_ATTR_MAX = 25,
};

enum dcbnl_cap_attrs {
	DCB_CAP_ATTR_UNDEFINED = 0,
	DCB_CAP_ATTR_ALL = 1,
	DCB_CAP_ATTR_PG = 2,
	DCB_CAP_ATTR_PFC = 3,
	DCB_CAP_ATTR_UP2TC = 4,
	DCB_CAP_ATTR_PG_TCS = 5,
	DCB_CAP_ATTR_PFC_TCS = 6,
	DCB_CAP_ATTR_GSP = 7,
	DCB_CAP_ATTR_BCN = 8,
	DCB_CAP_ATTR_DCBX = 9,
	__DCB_CAP_ATTR_ENUM_MAX = 10,
	DCB_CAP_ATTR_MAX = 9,
};

enum dcbnl_commands {
	DCB_CMD_UNDEFINED = 0,
	DCB_CMD_GSTATE = 1,
	DCB_CMD_SSTATE = 2,
	DCB_CMD_PGTX_GCFG = 3,
	DCB_CMD_PGTX_SCFG = 4,
	DCB_CMD_PGRX_GCFG = 5,
	DCB_CMD_PGRX_SCFG = 6,
	DCB_CMD_PFC_GCFG = 7,
	DCB_CMD_PFC_SCFG = 8,
	DCB_CMD_SET_ALL = 9,
	DCB_CMD_GPERM_HWADDR = 10,
	DCB_CMD_GCAP = 11,
	DCB_CMD_GNUMTCS = 12,
	DCB_CMD_SNUMTCS = 13,
	DCB_CMD_PFC_GSTATE = 14,
	DCB_CMD_PFC_SSTATE = 15,
	DCB_CMD_BCN_GCFG = 16,
	DCB_CMD_BCN_SCFG = 17,
	DCB_CMD_GAPP = 18,
	DCB_CMD_SAPP = 19,
	DCB_CMD_IEEE_SET = 20,
	DCB_CMD_IEEE_GET = 21,
	DCB_CMD_GDCBX = 22,
	DCB_CMD_SDCBX = 23,
	DCB_CMD_GFEATCFG = 24,
	DCB_CMD_SFEATCFG = 25,
	DCB_CMD_CEE_GET = 26,
	DCB_CMD_IEEE_DEL = 27,
	__DCB_CMD_ENUM_MAX = 28,
	DCB_CMD_MAX = 27,
};

enum dcbnl_featcfg_attrs {
	DCB_FEATCFG_ATTR_UNDEFINED = 0,
	DCB_FEATCFG_ATTR_ALL = 1,
	DCB_FEATCFG_ATTR_PG = 2,
	DCB_FEATCFG_ATTR_PFC = 3,
	DCB_FEATCFG_ATTR_APP = 4,
	__DCB_FEATCFG_ATTR_ENUM_MAX = 5,
	DCB_FEATCFG_ATTR_MAX = 4,
};

enum dcbnl_numtcs_attrs {
	DCB_NUMTCS_ATTR_UNDEFINED = 0,
	DCB_NUMTCS_ATTR_ALL = 1,
	DCB_NUMTCS_ATTR_PG = 2,
	DCB_NUMTCS_ATTR_PFC = 3,
	__DCB_NUMTCS_ATTR_ENUM_MAX = 4,
	DCB_NUMTCS_ATTR_MAX = 3,
};

enum dcbnl_pfc_up_attrs {
	DCB_PFC_UP_ATTR_UNDEFINED = 0,
	DCB_PFC_UP_ATTR_0 = 1,
	DCB_PFC_UP_ATTR_1 = 2,
	DCB_PFC_UP_ATTR_2 = 3,
	DCB_PFC_UP_ATTR_3 = 4,
	DCB_PFC_UP_ATTR_4 = 5,
	DCB_PFC_UP_ATTR_5 = 6,
	DCB_PFC_UP_ATTR_6 = 7,
	DCB_PFC_UP_ATTR_7 = 8,
	DCB_PFC_UP_ATTR_ALL = 9,
	__DCB_PFC_UP_ATTR_ENUM_MAX = 10,
	DCB_PFC_UP_ATTR_MAX = 9,
};

enum dcbnl_pg_attrs {
	DCB_PG_ATTR_UNDEFINED = 0,
	DCB_PG_ATTR_TC_0 = 1,
	DCB_PG_ATTR_TC_1 = 2,
	DCB_PG_ATTR_TC_2 = 3,
	DCB_PG_ATTR_TC_3 = 4,
	DCB_PG_ATTR_TC_4 = 5,
	DCB_PG_ATTR_TC_5 = 6,
	DCB_PG_ATTR_TC_6 = 7,
	DCB_PG_ATTR_TC_7 = 8,
	DCB_PG_ATTR_TC_MAX = 9,
	DCB_PG_ATTR_TC_ALL = 10,
	DCB_PG_ATTR_BW_ID_0 = 11,
	DCB_PG_ATTR_BW_ID_1 = 12,
	DCB_PG_ATTR_BW_ID_2 = 13,
	DCB_PG_ATTR_BW_ID_3 = 14,
	DCB_PG_ATTR_BW_ID_4 = 15,
	DCB_PG_ATTR_BW_ID_5 = 16,
	DCB_PG_ATTR_BW_ID_6 = 17,
	DCB_PG_ATTR_BW_ID_7 = 18,
	DCB_PG_ATTR_BW_ID_MAX = 19,
	DCB_PG_ATTR_BW_ID_ALL = 20,
	__DCB_PG_ATTR_ENUM_MAX = 21,
	DCB_PG_ATTR_MAX = 20,
};

enum dcbnl_tc_attrs {
	DCB_TC_ATTR_PARAM_UNDEFINED = 0,
	DCB_TC_ATTR_PARAM_PGID = 1,
	DCB_TC_ATTR_PARAM_UP_MAPPING = 2,
	DCB_TC_ATTR_PARAM_STRICT_PRIO = 3,
	DCB_TC_ATTR_PARAM_BW_PCT = 4,
	DCB_TC_ATTR_PARAM_ALL = 5,
	__DCB_TC_ATTR_PARAM_ENUM_MAX = 6,
	DCB_TC_ATTR_PARAM_MAX = 5,
};

enum dccp_state {
	DCCP_OPEN = 1,
	DCCP_REQUESTING = 2,
	DCCP_LISTEN = 10,
	DCCP_RESPOND = 3,
	DCCP_ACTIVE_CLOSEREQ = 4,
	DCCP_PASSIVE_CLOSE = 8,
	DCCP_CLOSING = 11,
	DCCP_TIME_WAIT = 6,
	DCCP_CLOSED = 7,
	DCCP_NEW_SYN_RECV = 12,
	DCCP_PARTOPEN = 14,
	DCCP_PASSIVE_CLOSEREQ = 15,
	DCCP_MAX_STATES = 16,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum debug_counters {
	SENT_OK = 0,
	SENT_FAIL = 1,
	SENT_FAIL_POLLING_UNSUPPORTED = 2,
	SENT_FAIL_CHANNEL_NOT_FOUND = 3,
	RESPONSE_OK = 4,
	NOTIFICATION_OK = 5,
	DELAYED_RESPONSE_OK = 6,
	XFERS_RESPONSE_TIMEOUT = 7,
	XFERS_RESPONSE_POLLED_TIMEOUT = 8,
	RESPONSE_POLLED_OK = 9,
	ERR_MSG_UNEXPECTED = 10,
	ERR_MSG_INVALID = 11,
	ERR_MSG_NOMEM = 12,
	ERR_PROTOCOL = 13,
	SCMI_DEBUG_COUNTERS_LAST = 14,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum derived_key_type {
	ENC_KEY = 0,
	AUTH_KEY = 1,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 0,
	DEVLINK_PARAM_TYPE_U16 = 1,
	DEVLINK_PARAM_TYPE_U32 = 2,
	DEVLINK_PARAM_TYPE_STRING = 3,
	DEVLINK_PARAM_TYPE_BOOL = 4,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dfll_ctrl_mode {
	DFLL_UNINITIALIZED = 0,
	DFLL_DISABLED = 1,
	DFLL_OPEN_LOOP = 2,
	DFLL_CLOSED_LOOP = 3,
};

enum dfll_tune_range {
	DFLL_TUNE_UNINITIALIZED = 0,
	DFLL_TUNE_LOW = 1,
};

enum die_val {
	DIE_UNUSED = 0,
	DIE_OOPS = 1,
};

enum digest_type {
	DIGEST_TYPE_IMA = 0,
	DIGEST_TYPE_VERITY = 1,
	DIGEST_TYPE__LAST = 2,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_check_overflow = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dm_io_mem_type {
	DM_IO_PAGE_LIST = 0,
	DM_IO_BIO = 1,
	DM_IO_VMA = 2,
	DM_IO_KMEM = 3,
};

enum dm_queue_mode {
	DM_TYPE_NONE = 0,
	DM_TYPE_BIO_BASED = 1,
	DM_TYPE_REQUEST_BASED = 2,
	DM_TYPE_DAX_BIO_BASED = 3,
};

enum dm_raid1_error {
	DM_RAID1_WRITE_ERROR = 0,
	DM_RAID1_FLUSH_ERROR = 1,
	DM_RAID1_SYNC_ERROR = 2,
	DM_RAID1_READ_ERROR = 3,
};

enum dm_rh_region_states {
	DM_RH_CLEAN = 1,
	DM_RH_DIRTY = 2,
	DM_RH_NOSYNC = 4,
	DM_RH_RECOVERING = 8,
};

enum dm_uevent_type {
	DM_UEVENT_PATH_FAILED = 0,
	DM_UEVENT_PATH_REINSTATED = 1,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dock_callback_type {
	DOCK_CALL_HANDLER = 0,
	DOCK_CALL_FIXUP = 1,
	DOCK_CALL_UEVENT = 2,
};

enum dpll_a {
	DPLL_A_ID = 1,
	DPLL_A_MODULE_NAME = 2,
	DPLL_A_PAD = 3,
	DPLL_A_CLOCK_ID = 4,
	DPLL_A_MODE = 5,
	DPLL_A_MODE_SUPPORTED = 6,
	DPLL_A_LOCK_STATUS = 7,
	DPLL_A_TEMP = 8,
	DPLL_A_TYPE = 9,
	DPLL_A_LOCK_STATUS_ERROR = 10,
	__DPLL_A_MAX = 11,
	DPLL_A_MAX = 10,
};

enum dpll_a_pin {
	DPLL_A_PIN_ID = 1,
	DPLL_A_PIN_PARENT_ID = 2,
	DPLL_A_PIN_MODULE_NAME = 3,
	DPLL_A_PIN_PAD = 4,
	DPLL_A_PIN_CLOCK_ID = 5,
	DPLL_A_PIN_BOARD_LABEL = 6,
	DPLL_A_PIN_PANEL_LABEL = 7,
	DPLL_A_PIN_PACKAGE_LABEL = 8,
	DPLL_A_PIN_TYPE = 9,
	DPLL_A_PIN_DIRECTION = 10,
	DPLL_A_PIN_FREQUENCY = 11,
	DPLL_A_PIN_FREQUENCY_SUPPORTED = 12,
	DPLL_A_PIN_FREQUENCY_MIN = 13,
	DPLL_A_PIN_FREQUENCY_MAX = 14,
	DPLL_A_PIN_PRIO = 15,
	DPLL_A_PIN_STATE = 16,
	DPLL_A_PIN_CAPABILITIES = 17,
	DPLL_A_PIN_PARENT_DEVICE = 18,
	DPLL_A_PIN_PARENT_PIN = 19,
	DPLL_A_PIN_PHASE_ADJUST_MIN = 20,
	DPLL_A_PIN_PHASE_ADJUST_MAX = 21,
	DPLL_A_PIN_PHASE_ADJUST = 22,
	DPLL_A_PIN_PHASE_OFFSET = 23,
	DPLL_A_PIN_FRACTIONAL_FREQUENCY_OFFSET = 24,
	DPLL_A_PIN_ESYNC_FREQUENCY = 25,
	DPLL_A_PIN_ESYNC_FREQUENCY_SUPPORTED = 26,
	DPLL_A_PIN_ESYNC_PULSE = 27,
	__DPLL_A_PIN_MAX = 28,
	DPLL_A_PIN_MAX = 27,
};

enum dpll_cmd {
	DPLL_CMD_DEVICE_ID_GET = 1,
	DPLL_CMD_DEVICE_GET = 2,
	DPLL_CMD_DEVICE_SET = 3,
	DPLL_CMD_DEVICE_CREATE_NTF = 4,
	DPLL_CMD_DEVICE_DELETE_NTF = 5,
	DPLL_CMD_DEVICE_CHANGE_NTF = 6,
	DPLL_CMD_PIN_ID_GET = 7,
	DPLL_CMD_PIN_GET = 8,
	DPLL_CMD_PIN_SET = 9,
	DPLL_CMD_PIN_CREATE_NTF = 10,
	DPLL_CMD_PIN_DELETE_NTF = 11,
	DPLL_CMD_PIN_CHANGE_NTF = 12,
	__DPLL_CMD_MAX = 13,
	DPLL_CMD_MAX = 12,
};

enum dpll_lock_status {
	DPLL_LOCK_STATUS_UNLOCKED = 1,
	DPLL_LOCK_STATUS_LOCKED = 2,
	DPLL_LOCK_STATUS_LOCKED_HO_ACQ = 3,
	DPLL_LOCK_STATUS_HOLDOVER = 4,
	__DPLL_LOCK_STATUS_MAX = 5,
	DPLL_LOCK_STATUS_MAX = 4,
};

enum dpll_lock_status_error {
	DPLL_LOCK_STATUS_ERROR_NONE = 1,
	DPLL_LOCK_STATUS_ERROR_UNDEFINED = 2,
	DPLL_LOCK_STATUS_ERROR_MEDIA_DOWN = 3,
	DPLL_LOCK_STATUS_ERROR_FRACTIONAL_FREQUENCY_OFFSET_TOO_HIGH = 4,
	__DPLL_LOCK_STATUS_ERROR_MAX = 5,
	DPLL_LOCK_STATUS_ERROR_MAX = 4,
};

enum dpll_mode {
	DPLL_MODE_MANUAL = 1,
	DPLL_MODE_AUTOMATIC = 2,
	__DPLL_MODE_MAX = 3,
	DPLL_MODE_MAX = 2,
};

enum dpll_pin_capabilities {
	DPLL_PIN_CAPABILITIES_DIRECTION_CAN_CHANGE = 1,
	DPLL_PIN_CAPABILITIES_PRIORITY_CAN_CHANGE = 2,
	DPLL_PIN_CAPABILITIES_STATE_CAN_CHANGE = 4,
};

enum dpll_pin_direction {
	DPLL_PIN_DIRECTION_INPUT = 1,
	DPLL_PIN_DIRECTION_OUTPUT = 2,
	__DPLL_PIN_DIRECTION_MAX = 3,
	DPLL_PIN_DIRECTION_MAX = 2,
};

enum dpll_pin_state {
	DPLL_PIN_STATE_CONNECTED = 1,
	DPLL_PIN_STATE_DISCONNECTED = 2,
	DPLL_PIN_STATE_SELECTABLE = 3,
	__DPLL_PIN_STATE_MAX = 4,
	DPLL_PIN_STATE_MAX = 3,
};

enum dpll_pin_type {
	DPLL_PIN_TYPE_MUX = 1,
	DPLL_PIN_TYPE_EXT = 2,
	DPLL_PIN_TYPE_SYNCE_ETH_PORT = 3,
	DPLL_PIN_TYPE_INT_OSCILLATOR = 4,
	DPLL_PIN_TYPE_GNSS = 5,
	__DPLL_PIN_TYPE_MAX = 6,
	DPLL_PIN_TYPE_MAX = 5,
};

enum dpll_type {
	DPLL_TYPE_PPS = 1,
	DPLL_TYPE_EEC = 2,
	__DPLL_TYPE_MAX = 3,
	DPLL_TYPE_MAX = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum dprc_region_type {
	DPRC_REGION_TYPE_MC_PORTAL = 0,
	DPRC_REGION_TYPE_QBMAN_PORTAL = 1,
	DPRC_REGION_TYPE_QBMAN_MEM_BACKED_PORTAL = 2,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_bridge_attach_flags {
	DRM_BRIDGE_ATTACH_NO_CONNECTOR = 1,
};

enum drm_bridge_ops {
	DRM_BRIDGE_OP_DETECT = 1,
	DRM_BRIDGE_OP_EDID = 2,
	DRM_BRIDGE_OP_HPD = 4,
	DRM_BRIDGE_OP_MODES = 8,
	DRM_BRIDGE_OP_HDMI = 16,
};

enum drm_bus_flags {
	DRM_BUS_FLAG_DE_LOW = 1,
	DRM_BUS_FLAG_DE_HIGH = 2,
	DRM_BUS_FLAG_PIXDATA_DRIVE_POSEDGE = 4,
	DRM_BUS_FLAG_PIXDATA_DRIVE_NEGEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_POSEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_NEGEDGE = 4,
	DRM_BUS_FLAG_DATA_MSB_TO_LSB = 16,
	DRM_BUS_FLAG_DATA_LSB_TO_MSB = 32,
	DRM_BUS_FLAG_SYNC_DRIVE_POSEDGE = 64,
	DRM_BUS_FLAG_SYNC_DRIVE_NEGEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_POSEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_NEGEDGE = 64,
	DRM_BUS_FLAG_SHARP_SIGNALS = 256,
};

enum drm_color_encoding {
	DRM_COLOR_YCBCR_BT601 = 0,
	DRM_COLOR_YCBCR_BT709 = 1,
	DRM_COLOR_YCBCR_BT2020 = 2,
	DRM_COLOR_ENCODING_MAX = 3,
};

enum drm_color_lut_tests {
	DRM_COLOR_LUT_EQUAL_CHANNELS = 1,
	DRM_COLOR_LUT_NON_DECREASING = 2,
};

enum drm_color_range {
	DRM_COLOR_YCBCR_LIMITED_RANGE = 0,
	DRM_COLOR_YCBCR_FULL_RANGE = 1,
	DRM_COLOR_RANGE_MAX = 2,
};

enum drm_colorspace {
	DRM_MODE_COLORIMETRY_DEFAULT = 0,
	DRM_MODE_COLORIMETRY_NO_DATA = 0,
	DRM_MODE_COLORIMETRY_SMPTE_170M_YCC = 1,
	DRM_MODE_COLORIMETRY_BT709_YCC = 2,
	DRM_MODE_COLORIMETRY_XVYCC_601 = 3,
	DRM_MODE_COLORIMETRY_XVYCC_709 = 4,
	DRM_MODE_COLORIMETRY_SYCC_601 = 5,
	DRM_MODE_COLORIMETRY_OPYCC_601 = 6,
	DRM_MODE_COLORIMETRY_OPRGB = 7,
	DRM_MODE_COLORIMETRY_BT2020_CYCC = 8,
	DRM_MODE_COLORIMETRY_BT2020_RGB = 9,
	DRM_MODE_COLORIMETRY_BT2020_YCC = 10,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_D65 = 11,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_THEATER = 12,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FIXED = 13,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FLOAT = 14,
	DRM_MODE_COLORIMETRY_BT601_YCC = 15,
	DRM_MODE_COLORIMETRY_COUNT = 16,
};

enum drm_connector_force {
	DRM_FORCE_UNSPECIFIED = 0,
	DRM_FORCE_OFF = 1,
	DRM_FORCE_ON = 2,
	DRM_FORCE_ON_DIGITAL = 3,
};

enum drm_connector_registration_state {
	DRM_CONNECTOR_INITIALIZING = 0,
	DRM_CONNECTOR_REGISTERED = 1,
	DRM_CONNECTOR_UNREGISTERED = 2,
};

enum drm_connector_status {
	connector_status_connected = 1,
	connector_status_disconnected = 2,
	connector_status_unknown = 3,
};

enum drm_connector_tv_mode {
	DRM_MODE_TV_MODE_NTSC = 0,
	DRM_MODE_TV_MODE_NTSC_443 = 1,
	DRM_MODE_TV_MODE_NTSC_J = 2,
	DRM_MODE_TV_MODE_PAL = 3,
	DRM_MODE_TV_MODE_PAL_M = 4,
	DRM_MODE_TV_MODE_PAL_N = 5,
	DRM_MODE_TV_MODE_SECAM = 6,
	DRM_MODE_TV_MODE_MONOCHROME = 7,
	DRM_MODE_TV_MODE_MAX = 8,
};

enum drm_debug_category {
	DRM_UT_CORE = 0,
	DRM_UT_DRIVER = 1,
	DRM_UT_KMS = 2,
	DRM_UT_PRIME = 3,
	DRM_UT_ATOMIC = 4,
	DRM_UT_VBL = 5,
	DRM_UT_STATE = 6,
	DRM_UT_LEASE = 7,
	DRM_UT_DP = 8,
	DRM_UT_DRMRES = 9,
};

enum drm_driver_feature {
	DRIVER_GEM = 1,
	DRIVER_MODESET = 2,
	DRIVER_RENDER = 8,
	DRIVER_ATOMIC = 16,
	DRIVER_SYNCOBJ = 32,
	DRIVER_SYNCOBJ_TIMELINE = 64,
	DRIVER_COMPUTE_ACCEL = 128,
	DRIVER_GEM_GPUVA = 256,
	DRIVER_CURSOR_HOTSPOT = 512,
	DRIVER_USE_AGP = 33554432,
	DRIVER_LEGACY = 67108864,
	DRIVER_PCI_DMA = 134217728,
	DRIVER_SG = 268435456,
	DRIVER_HAVE_DMA = 536870912,
	DRIVER_HAVE_IRQ = 1073741824,
};

enum drm_gem_object_status {
	DRM_GEM_OBJECT_RESIDENT = 1,
	DRM_GEM_OBJECT_PURGEABLE = 2,
};

enum drm_gpuva_flags {
	DRM_GPUVA_INVALIDATED = 1,
	DRM_GPUVA_SPARSE = 2,
	DRM_GPUVA_USERBITS = 4,
};

enum drm_gpuva_op_type {
	DRM_GPUVA_OP_MAP = 0,
	DRM_GPUVA_OP_REMAP = 1,
	DRM_GPUVA_OP_UNMAP = 2,
	DRM_GPUVA_OP_PREFETCH = 3,
};

enum drm_gpuvm_flags {
	DRM_GPUVM_RESV_PROTECTED = 1,
	DRM_GPUVM_USERBITS = 2,
};

enum drm_hdmi_broadcast_rgb {
	DRM_HDMI_BROADCAST_RGB_AUTO = 0,
	DRM_HDMI_BROADCAST_RGB_FULL = 1,
	DRM_HDMI_BROADCAST_RGB_LIMITED = 2,
};

enum drm_ioctl_flags {
	DRM_AUTH = 1,
	DRM_MASTER = 2,
	DRM_ROOT_ONLY = 4,
	DRM_RENDER_ALLOW = 32,
};

enum drm_link_status {
	DRM_LINK_STATUS_GOOD = 0,
	DRM_LINK_STATUS_BAD = 1,
};

enum drm_lvds_dual_link_pixels {
	DRM_LVDS_DUAL_LINK_EVEN_ODD_PIXELS = 0,
	DRM_LVDS_DUAL_LINK_ODD_EVEN_PIXELS = 1,
};

enum drm_minor_type {
	DRM_MINOR_PRIMARY = 0,
	DRM_MINOR_CONTROL = 1,
	DRM_MINOR_RENDER = 2,
	DRM_MINOR_ACCEL = 32,
};

enum drm_mm_insert_mode {
	DRM_MM_INSERT_BEST = 0,
	DRM_MM_INSERT_LOW = 1,
	DRM_MM_INSERT_HIGH = 2,
	DRM_MM_INSERT_EVICT = 3,
	DRM_MM_INSERT_ONCE = 2147483648,
	DRM_MM_INSERT_HIGHEST = 2147483650,
	DRM_MM_INSERT_LOWEST = 2147483649,
};

enum drm_mode_analog {
	DRM_MODE_ANALOG_NTSC = 0,
	DRM_MODE_ANALOG_PAL = 1,
};

enum drm_mode_status {
	MODE_OK = 0,
	MODE_HSYNC = 1,
	MODE_VSYNC = 2,
	MODE_H_ILLEGAL = 3,
	MODE_V_ILLEGAL = 4,
	MODE_BAD_WIDTH = 5,
	MODE_NOMODE = 6,
	MODE_NO_INTERLACE = 7,
	MODE_NO_DBLESCAN = 8,
	MODE_NO_VSCAN = 9,
	MODE_MEM = 10,
	MODE_VIRTUAL_X = 11,
	MODE_VIRTUAL_Y = 12,
	MODE_MEM_VIRT = 13,
	MODE_NOCLOCK = 14,
	MODE_CLOCK_HIGH = 15,
	MODE_CLOCK_LOW = 16,
	MODE_CLOCK_RANGE = 17,
	MODE_BAD_HVALUE = 18,
	MODE_BAD_VVALUE = 19,
	MODE_BAD_VSCAN = 20,
	MODE_HSYNC_NARROW = 21,
	MODE_HSYNC_WIDE = 22,
	MODE_HBLANK_NARROW = 23,
	MODE_HBLANK_WIDE = 24,
	MODE_VSYNC_NARROW = 25,
	MODE_VSYNC_WIDE = 26,
	MODE_VBLANK_NARROW = 27,
	MODE_VBLANK_WIDE = 28,
	MODE_PANEL = 29,
	MODE_INTERLACE_WIDTH = 30,
	MODE_ONE_WIDTH = 31,
	MODE_ONE_HEIGHT = 32,
	MODE_ONE_SIZE = 33,
	MODE_NO_REDUCED = 34,
	MODE_NO_STEREO = 35,
	MODE_NO_420 = 36,
	MODE_STALE = -3,
	MODE_BAD = -2,
	MODE_ERROR = -1,
};

enum drm_mode_subconnector {
	DRM_MODE_SUBCONNECTOR_Automatic = 0,
	DRM_MODE_SUBCONNECTOR_Unknown = 0,
	DRM_MODE_SUBCONNECTOR_VGA = 1,
	DRM_MODE_SUBCONNECTOR_DVID = 3,
	DRM_MODE_SUBCONNECTOR_DVIA = 4,
	DRM_MODE_SUBCONNECTOR_Composite = 5,
	DRM_MODE_SUBCONNECTOR_SVIDEO = 6,
	DRM_MODE_SUBCONNECTOR_Component = 8,
	DRM_MODE_SUBCONNECTOR_SCART = 9,
	DRM_MODE_SUBCONNECTOR_DisplayPort = 10,
	DRM_MODE_SUBCONNECTOR_HDMIA = 11,
	DRM_MODE_SUBCONNECTOR_Native = 15,
	DRM_MODE_SUBCONNECTOR_Wireless = 18,
};

enum drm_of_lvds_pixels {
	DRM_OF_LVDS_EVEN = 1,
	DRM_OF_LVDS_ODD = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drm_plane_type {
	DRM_PLANE_TYPE_OVERLAY = 0,
	DRM_PLANE_TYPE_PRIMARY = 1,
	DRM_PLANE_TYPE_CURSOR = 2,
};

enum drm_privacy_screen_status {
	PRIVACY_SCREEN_DISABLED = 0,
	PRIVACY_SCREEN_ENABLED = 1,
	PRIVACY_SCREEN_DISABLED_LOCKED = 2,
	PRIVACY_SCREEN_ENABLED_LOCKED = 3,
};

enum drm_scaling_filter {
	DRM_SCALING_FILTER_DEFAULT = 0,
	DRM_SCALING_FILTER_NEAREST_NEIGHBOR = 1,
};

enum drm_stat_type {
	_DRM_STAT_LOCK = 0,
	_DRM_STAT_OPENS = 1,
	_DRM_STAT_CLOSES = 2,
	_DRM_STAT_IOCTLS = 3,
	_DRM_STAT_LOCKS = 4,
	_DRM_STAT_UNLOCKS = 5,
	_DRM_STAT_VALUE = 6,
	_DRM_STAT_BYTE = 7,
	_DRM_STAT_COUNT = 8,
	_DRM_STAT_IRQ = 9,
	_DRM_STAT_PRIMARY = 10,
	_DRM_STAT_SECONDARY = 11,
	_DRM_STAT_DMA = 12,
	_DRM_STAT_SPECIAL = 13,
	_DRM_STAT_MISSED = 14,
};

enum drm_vblank_seq_type {
	_DRM_VBLANK_ABSOLUTE = 0,
	_DRM_VBLANK_RELATIVE = 1,
	_DRM_VBLANK_HIGH_CRTC_MASK = 62,
	_DRM_VBLANK_EVENT = 67108864,
	_DRM_VBLANK_FLIP = 134217728,
	_DRM_VBLANK_NEXTONMISS = 268435456,
	_DRM_VBLANK_SECONDARY = 536870912,
	_DRM_VBLANK_SIGNAL = 1073741824,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum ec_command {
	ACPI_EC_COMMAND_READ = 128,
	ACPI_EC_COMMAND_WRITE = 129,
	ACPI_EC_BURST_ENABLE = 130,
	ACPI_EC_BURST_DISABLE = 131,
	ACPI_EC_COMMAND_QUERY = 132,
};

enum ec_comms_status {
	EC_COMMS_STATUS_PROCESSING = 1,
};

enum ec_led_colors {
	EC_LED_COLOR_RED = 0,
	EC_LED_COLOR_GREEN = 1,
	EC_LED_COLOR_BLUE = 2,
	EC_LED_COLOR_YELLOW = 3,
	EC_LED_COLOR_WHITE = 4,
	EC_LED_COLOR_AMBER = 5,
	EC_LED_COLOR_COUNT = 6,
};

enum ec_mkbp_event {
	EC_MKBP_EVENT_KEY_MATRIX = 0,
	EC_MKBP_EVENT_HOST_EVENT = 1,
	EC_MKBP_EVENT_SENSOR_FIFO = 2,
	EC_MKBP_EVENT_BUTTON = 3,
	EC_MKBP_EVENT_SWITCH = 4,
	EC_MKBP_EVENT_FINGERPRINT = 5,
	EC_MKBP_EVENT_SYSRQ = 6,
	EC_MKBP_EVENT_HOST_EVENT64 = 7,
	EC_MKBP_EVENT_CEC_EVENT = 8,
	EC_MKBP_EVENT_CEC_MESSAGE = 9,
	EC_MKBP_EVENT_PCHG = 12,
	EC_MKBP_EVENT_COUNT = 13,
};

enum ec_status {
	EC_RES_SUCCESS = 0,
	EC_RES_INVALID_COMMAND = 1,
	EC_RES_ERROR = 2,
	EC_RES_INVALID_PARAM = 3,
	EC_RES_ACCESS_DENIED = 4,
	EC_RES_INVALID_RESPONSE = 5,
	EC_RES_INVALID_VERSION = 6,
	EC_RES_INVALID_CHECKSUM = 7,
	EC_RES_IN_PROGRESS = 8,
	EC_RES_UNAVAILABLE = 9,
	EC_RES_TIMEOUT = 10,
	EC_RES_OVERFLOW = 11,
	EC_RES_INVALID_HEADER = 12,
	EC_RES_REQUEST_TRUNCATED = 13,
	EC_RES_RESPONSE_TOO_BIG = 14,
	EC_RES_BUS_ERROR = 15,
	EC_RES_BUSY = 16,
	EC_RES_INVALID_HEADER_VERSION = 17,
	EC_RES_INVALID_HEADER_CRC = 18,
	EC_RES_INVALID_DATA_CRC = 19,
	EC_RES_DUP_UNAVAILABLE = 20,
};

enum ec_temp_thresholds {
	EC_TEMP_THRESH_WARN = 0,
	EC_TEMP_THRESH_HIGH = 1,
	EC_TEMP_THRESH_HALT = 2,
	EC_TEMP_THRESH_COUNT = 3,
};

enum ecdsasignature_actions {
	ACT_ecdsa_get_signature_r = 0,
	ACT_ecdsa_get_signature_s = 1,
	NR__ecdsasignature_actions = 2,
};

enum ecryptfs_token_types {
	ECRYPTFS_PASSWORD = 0,
	ECRYPTFS_PRIVATE_KEY = 1,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum edid_block_status {
	EDID_BLOCK_OK = 0,
	EDID_BLOCK_READ_FAIL = 1,
	EDID_BLOCK_NULL = 2,
	EDID_BLOCK_ZERO = 3,
	EDID_BLOCK_HEADER_CORRUPT = 4,
	EDID_BLOCK_HEADER_REPAIR = 5,
	EDID_BLOCK_HEADER_FIXED = 6,
	EDID_BLOCK_CHECKSUM = 7,
	EDID_BLOCK_VERSION = 8,
};

enum efi_cmdline_option {
	EFI_CMDLINE_NONE = 0,
	EFI_CMDLINE_MODE_NUM = 1,
	EFI_CMDLINE_RES = 2,
	EFI_CMDLINE_AUTO = 3,
	EFI_CMDLINE_LIST = 4,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum efistub_event_type {
	EFISTUB_EVT_INITRD = 0,
	EFISTUB_EVT_LOAD_OPTIONS = 1,
	EFISTUB_EVT_COUNT = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 103,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_COUNT = 21,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum events_wwnr {
	switch_in_wwnr = 0,
	switch_out_wwnr = 1,
	wakeup_wwnr = 2,
	event_max_wwnr = 3,
};

enum evict_result {
	ER_EVICT = 0,
	ER_DONT_EVICT = 1,
	ER_STOP = 2,
};

enum evm_ima_xattr_type {
	IMA_XATTR_DIGEST = 1,
	EVM_XATTR_HMAC = 2,
	EVM_IMA_XATTR_DIGSIG = 3,
	IMA_XATTR_DIGEST_NG = 4,
	EVM_XATTR_PORTABLE_DIGSIG = 5,
	IMA_VERITY_DIGSIG = 6,
	IMA_XATTR_LAST = 7,
};

enum evtreturn {
	EVT_ERR = -1,
	EVT_DONE = 0,
	EVT_GSER = 1,
	EVT_DISC = 2,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception_type {
	except_type_sync = 0,
	except_type_irq = 128,
	except_type_fiq = 256,
	except_type_serror = 384,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	__FANOTIFY_EVENT_TYPE_NUM = 6,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fg_filter_id {
	__NO_FGF__ = 0,
	HCRX_FGTnXS = 1,
	__NR_FG_FILTER_IDS__ = 2,
};

enum fgt_group_id {
	__NO_FGT_GROUP__ = 0,
	HFGxTR_GROUP = 1,
	HDFGRTR_GROUP = 2,
	HDFGWTR_GROUP = 2,
	HFGITR_GROUP = 3,
	HAFGRTR_GROUP = 4,
	__NR_FGT_GROUP_IDS__ = 5,
};

enum fib6_walk_state {
	FWS_S = 0,
	FWS_L = 1,
	FWS_R = 2,
	FWS_C = 3,
	FWS_U = 4,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum field_op_id {
	FIELD_OP_NONE = 0,
	FIELD_OP_PLUS = 1,
	FIELD_OP_MINUS = 2,
	FIELD_OP_UNARY_MINUS = 3,
	FIELD_OP_DIV = 4,
	FIELD_OP_MULT = 5,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum finalization_type {
	FINALIZATION_TYPE_FINAL = 0,
	FINALIZATION_TYPE_FINUP = 1,
	FINALIZATION_TYPE_DIGEST = 2,
};

enum fiq_hwirq {
	AIC_TMR_EL0_PHYS = 0,
	AIC_TMR_EL0_VIRT = 1,
	AIC_TMR_EL02_PHYS = 2,
	AIC_TMR_EL02_VIRT = 3,
	AIC_CPU_PMU_Effi = 4,
	AIC_CPU_PMU_Perf = 5,
	AIC_VGIC_MI = 6,
	AIC_NR_FIQ = 7,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	FIX_FDT_END = 1,
	FIX_FDT = 514,
	FIX_EARLYCON_MEM_BASE = 515,
	FIX_TEXT_POKE0 = 516,
	FIX_APEI_GHES_IRQ = 517,
	FIX_APEI_GHES_SEA = 518,
	FIX_APEI_GHES_SDEI_NORMAL = 519,
	FIX_APEI_GHES_SDEI_CRITICAL = 520,
	FIX_ENTRY_TRAMP_TEXT4 = 521,
	FIX_ENTRY_TRAMP_TEXT3 = 522,
	FIX_ENTRY_TRAMP_TEXT2 = 523,
	FIX_ENTRY_TRAMP_TEXT1 = 524,
	__end_of_permanent_fixed_addresses = 525,
	FIX_BTMAP_END = 525,
	FIX_BTMAP_BEGIN = 972,
	FIX_PTE = 973,
	FIX_PMD = 974,
	FIX_PUD = 975,
	FIX_P4D = 976,
	FIX_PGD = 977,
	__end_of_fixed_addresses = 978,
};

enum flag_bits {
	Faulty = 0,
	In_sync = 1,
	Bitmap_sync = 2,
	WriteMostly = 3,
	AutoDetected = 4,
	Blocked = 5,
	WriteErrorSeen = 6,
	FaultRecorded = 7,
	BlockedBadBlocks = 8,
	WantReplacement = 9,
	Replacement = 10,
	Candidate = 11,
	Journal = 12,
	ClusterRemove = 13,
	ExternalBbl = 14,
	FailFast = 15,
	LastDev = 16,
	CollisionCheck = 17,
	Nonrot = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum flush_type {
	FLUSH_TYPE_NONE = 0,
	FLUSH_TYPE_FLUSH = 1,
	FLUSH_TYPE_REIMPORT = 2,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_type {
	FORMAT_TYPE_NONE = 0,
	FORMAT_TYPE_WIDTH = 1,
	FORMAT_TYPE_PRECISION = 2,
	FORMAT_TYPE_CHAR = 3,
	FORMAT_TYPE_STR = 4,
	FORMAT_TYPE_PTR = 5,
	FORMAT_TYPE_PERCENT_CHAR = 6,
	FORMAT_TYPE_INVALID = 7,
	FORMAT_TYPE_LONG_LONG = 8,
	FORMAT_TYPE_ULONG = 9,
	FORMAT_TYPE_LONG = 10,
	FORMAT_TYPE_UBYTE = 11,
	FORMAT_TYPE_BYTE = 12,
	FORMAT_TYPE_USHORT = 13,
	FORMAT_TYPE_SHORT = 14,
	FORMAT_TYPE_UINT = 15,
	FORMAT_TYPE_INT = 16,
	FORMAT_TYPE_SIZE_T = 17,
	FORMAT_TYPE_PTRDIFF = 18,
};

enum fortify_func {
	FORTIFY_FUNC_strncpy = 0,
	FORTIFY_FUNC_strnlen = 1,
	FORTIFY_FUNC_strlen = 2,
	FORTIFY_FUNC_strscpy = 3,
	FORTIFY_FUNC_strlcat = 4,
	FORTIFY_FUNC_strcat = 5,
	FORTIFY_FUNC_strncat = 6,
	FORTIFY_FUNC_memset = 7,
	FORTIFY_FUNC_memcpy = 8,
	FORTIFY_FUNC_memmove = 9,
	FORTIFY_FUNC_memscan = 10,
	FORTIFY_FUNC_memcmp = 11,
	FORTIFY_FUNC_memchr = 12,
	FORTIFY_FUNC_memchr_inv = 13,
	FORTIFY_FUNC_kmemdup = 14,
	FORTIFY_FUNC_strcpy = 15,
	FORTIFY_FUNC_UNKNOWN = 16,
};

enum fp_type {
	FP_STATE_CURRENT = 0,
	FP_STATE_FPSIMD = 1,
	FP_STATE_SVE = 2,
};

enum fpdt_record_type {
	RECORD_S3_RESUME = 0,
	RECORD_S3_SUSPEND = 1,
	RECORD_BOOT = 2,
};

enum fpdt_subtable_type {
	SUBTABLE_FBPT = 0,
	SUBTABLE_S3PT = 1,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_policy {
	FLOOR = 0,
	CEIL = 1,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_mc_cmd_index {
	DPDBG_DUMP = 0,
	DPDBG_SET = 1,
	DPRC_GET_CONTAINER_ID = 2,
	DPRC_CREATE_CONT = 3,
	DPRC_DESTROY_CONT = 4,
	DPRC_ASSIGN = 5,
	DPRC_UNASSIGN = 6,
	DPRC_GET_OBJ_COUNT = 7,
	DPRC_GET_OBJ = 8,
	DPRC_GET_RES_COUNT = 9,
	DPRC_GET_RES_IDS = 10,
	DPRC_SET_OBJ_LABEL = 11,
	DPRC_SET_LOCKED = 12,
	DPRC_CONNECT = 13,
	DPRC_DISCONNECT = 14,
	DPRC_GET_POOL = 15,
	DPRC_GET_POOL_COUNT = 16,
	DPRC_GET_CONNECTION = 17,
	DPCI_GET_LINK_STATE = 18,
	DPCI_GET_PEER_ATTR = 19,
	DPAIOP_GET_SL_VERSION = 20,
	DPAIOP_GET_STATE = 21,
	DPMNG_GET_VERSION = 22,
	DPSECI_GET_TX_QUEUE = 23,
	DPMAC_GET_COUNTER = 24,
	DPMAC_GET_MAC_ADDR = 25,
	DPNI_SET_PRIM_MAC = 26,
	DPNI_GET_PRIM_MAC = 27,
	DPNI_GET_STATISTICS = 28,
	DPNI_GET_LINK_STATE = 29,
	DPNI_GET_MAX_FRAME_LENGTH = 30,
	DPSW_GET_TAILDROP = 31,
	DPSW_SET_TAILDROP = 32,
	DPSW_IF_GET_COUNTER = 33,
	DPSW_IF_GET_MAX_FRAME_LENGTH = 34,
	DPDMUX_GET_COUNTER = 35,
	DPDMUX_IF_GET_MAX_FRAME_LENGTH = 36,
	GET_ATTR = 37,
	GET_IRQ_MASK = 38,
	GET_IRQ_STATUS = 39,
	CLOSE = 40,
	OPEN = 41,
	GET_API_VERSION = 42,
	DESTROY = 43,
	CREATE = 44,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_PATH = 1,
	FSNOTIFY_EVENT_INODE = 2,
	FSNOTIFY_EVENT_DENTRY = 3,
	FSNOTIFY_EVENT_ERROR = 4,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

enum ftr_type {
	FTR_EXACT = 0,
	FTR_LOWER_SAFE = 1,
	FTR_HIGHER_SAFE = 2,
	FTR_HIGHER_OR_ZERO_SAFE = 3,
};

enum ftrace_bug_type {
	FTRACE_BUG_UNKNOWN = 0,
	FTRACE_BUG_INIT = 1,
	FTRACE_BUG_NOP = 2,
	FTRACE_BUG_CALL = 3,
	FTRACE_BUG_UPDATE = 4,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum gdsc_status {
	GDSC_OFF = 0,
	GDSC_ON = 1,
};

enum geni_icc_path_index {
	GENI_TO_CORE = 0,
	CPU_TO_GENI = 1,
	GENI_TO_DDR = 2,
};

enum geni_se_protocol_type {
	GENI_SE_NONE = 0,
	GENI_SE_SPI = 1,
	GENI_SE_UART = 2,
	GENI_SE_I2C = 3,
	GENI_SE_I3C = 4,
	GENI_SE_SPI_SLAVE = 5,
};

enum geni_se_xfer_mode {
	GENI_SE_INVALID = 0,
	GENI_SE_FIFO = 1,
	GENI_SE_DMA = 2,
	GENI_GPI_DMA = 3,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum gic_intid_range {
	SGI_RANGE = 0,
	PPI_RANGE = 1,
	SPI_RANGE = 2,
	EPPI_RANGE = 3,
	ESPI_RANGE = 4,
	LPI_RANGE = 5,
	__INVALID_RANGE__ = 6,
};

enum gic_type {
	GIC_V2 = 0,
	GIC_V3 = 1,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum gpmc_clk_domain {
	GPMC_CD_FCLK = 0,
	GPMC_CD_CLK = 1,
};

enum graph_filter_type {
	GRAPH_FILTER_NOTRACE = 0,
	GRAPH_FILTER_FUNCTION = 1,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handler_id {
	HANDLER_ONMATCH = 1,
	HANDLER_ONMAX = 2,
	HANDLER_ONCHANGE = 3,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum header_fields {
	HDR_PCR = 0,
	HDR_DIGEST = 1,
	HDR_TEMPLATE_NAME = 2,
	HDR_TEMPLATE_DATA = 3,
	HDR__LAST = 4,
};

enum header_opt {
	IPE_HEADER_POLICY_NAME = 0,
	IPE_HEADER_POLICY_VERSION = 1,
	__IPE_HEADER_MAX = 2,
};

enum hest_status {
	HEST_ENABLED = 0,
	HEST_DISABLED = 1,
	HEST_NOT_FOUND = 2,
};

enum hid_battery_status {
	HID_BATTERY_UNKNOWN = 0,
	HID_BATTERY_QUERIED = 1,
	HID_BATTERY_REPORTED = 2,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hist_field_flags {
	HIST_FIELD_FL_HITCOUNT = 1,
	HIST_FIELD_FL_KEY = 2,
	HIST_FIELD_FL_STRING = 4,
	HIST_FIELD_FL_HEX = 8,
	HIST_FIELD_FL_SYM = 16,
	HIST_FIELD_FL_SYM_OFFSET = 32,
	HIST_FIELD_FL_EXECNAME = 64,
	HIST_FIELD_FL_SYSCALL = 128,
	HIST_FIELD_FL_STACKTRACE = 256,
	HIST_FIELD_FL_LOG2 = 512,
	HIST_FIELD_FL_TIMESTAMP = 1024,
	HIST_FIELD_FL_TIMESTAMP_USECS = 2048,
	HIST_FIELD_FL_VAR = 4096,
	HIST_FIELD_FL_EXPR = 8192,
	HIST_FIELD_FL_VAR_REF = 16384,
	HIST_FIELD_FL_CPU = 32768,
	HIST_FIELD_FL_ALIAS = 65536,
	HIST_FIELD_FL_BUCKET = 131072,
	HIST_FIELD_FL_CONST = 262144,
	HIST_FIELD_FL_PERCENT = 524288,
	HIST_FIELD_FL_GRAPH = 1048576,
};

enum hist_field_fn {
	HIST_FIELD_FN_NOP = 0,
	HIST_FIELD_FN_VAR_REF = 1,
	HIST_FIELD_FN_COUNTER = 2,
	HIST_FIELD_FN_CONST = 3,
	HIST_FIELD_FN_LOG2 = 4,
	HIST_FIELD_FN_BUCKET = 5,
	HIST_FIELD_FN_TIMESTAMP = 6,
	HIST_FIELD_FN_CPU = 7,
	HIST_FIELD_FN_STRING = 8,
	HIST_FIELD_FN_DYNSTRING = 9,
	HIST_FIELD_FN_RELDYNSTRING = 10,
	HIST_FIELD_FN_PSTRING = 11,
	HIST_FIELD_FN_S64 = 12,
	HIST_FIELD_FN_U64 = 13,
	HIST_FIELD_FN_S32 = 14,
	HIST_FIELD_FN_U32 = 15,
	HIST_FIELD_FN_S16 = 16,
	HIST_FIELD_FN_U16 = 17,
	HIST_FIELD_FN_S8 = 18,
	HIST_FIELD_FN_U8 = 19,
	HIST_FIELD_FN_UMINUS = 20,
	HIST_FIELD_FN_MINUS = 21,
	HIST_FIELD_FN_PLUS = 22,
	HIST_FIELD_FN_DIV = 23,
	HIST_FIELD_FN_MULT = 24,
	HIST_FIELD_FN_DIV_POWER2 = 25,
	HIST_FIELD_FN_DIV_NOT_POWER2 = 26,
	HIST_FIELD_FN_DIV_MULT_SHIFT = 27,
	HIST_FIELD_FN_EXECNAME = 28,
	HIST_FIELD_FN_STACK = 29,
};

enum hk_flags {
	HK_FLAG_TIMER = 1,
	HK_FLAG_RCU = 2,
	HK_FLAG_MISC = 4,
	HK_FLAG_SCHED = 8,
	HK_FLAG_TICK = 16,
	HK_FLAG_DOMAIN = 32,
	HK_FLAG_WQ = 64,
	HK_FLAG_MANAGED_IRQ = 128,
	HK_FLAG_KTHREAD = 256,
};

enum hk_type {
	HK_TYPE_TIMER = 0,
	HK_TYPE_RCU = 1,
	HK_TYPE_MISC = 2,
	HK_TYPE_SCHED = 3,
	HK_TYPE_TICK = 4,
	HK_TYPE_DOMAIN = 5,
	HK_TYPE_WQ = 6,
	HK_TYPE_MANAGED_IRQ = 7,
	HK_TYPE_KTHREAD = 8,
	HK_TYPE_MAX = 9,
};

enum hmm_pfn_flags {
	HMM_PFN_VALID = 9223372036854775808ULL,
	HMM_PFN_WRITE = 4611686018427387904ULL,
	HMM_PFN_ERROR = 2305843009213693952ULL,
	HMM_PFN_ORDER_SHIFT = 56ULL,
	HMM_PFN_REQ_FAULT = 9223372036854775808ULL,
	HMM_PFN_REQ_WRITE = 4611686018427387904ULL,
	HMM_PFN_FLAGS = 18374686479671623680ULL,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum host_event_code {
	EC_HOST_EVENT_LID_CLOSED = 1,
	EC_HOST_EVENT_LID_OPEN = 2,
	EC_HOST_EVENT_POWER_BUTTON = 3,
	EC_HOST_EVENT_AC_CONNECTED = 4,
	EC_HOST_EVENT_AC_DISCONNECTED = 5,
	EC_HOST_EVENT_BATTERY_LOW = 6,
	EC_HOST_EVENT_BATTERY_CRITICAL = 7,
	EC_HOST_EVENT_BATTERY = 8,
	EC_HOST_EVENT_THERMAL_THRESHOLD = 9,
	EC_HOST_EVENT_DEVICE = 10,
	EC_HOST_EVENT_THERMAL = 11,
	EC_HOST_EVENT_USB_CHARGER = 12,
	EC_HOST_EVENT_KEY_PRESSED = 13,
	EC_HOST_EVENT_INTERFACE_READY = 14,
	EC_HOST_EVENT_KEYBOARD_RECOVERY = 15,
	EC_HOST_EVENT_THERMAL_SHUTDOWN = 16,
	EC_HOST_EVENT_BATTERY_SHUTDOWN = 17,
	EC_HOST_EVENT_THROTTLE_START = 18,
	EC_HOST_EVENT_THROTTLE_STOP = 19,
	EC_HOST_EVENT_HANG_DETECT = 20,
	EC_HOST_EVENT_HANG_REBOOT = 21,
	EC_HOST_EVENT_PD_MCU = 22,
	EC_HOST_EVENT_BATTERY_STATUS = 23,
	EC_HOST_EVENT_PANIC = 24,
	EC_HOST_EVENT_KEYBOARD_FASTBOOT = 25,
	EC_HOST_EVENT_RTC = 26,
	EC_HOST_EVENT_MKBP = 27,
	EC_HOST_EVENT_USB_MUX = 28,
	EC_HOST_EVENT_MODE_CHANGE = 29,
	EC_HOST_EVENT_KEYBOARD_RECOVERY_HW_REINIT = 30,
	EC_HOST_EVENT_WOV = 31,
	EC_HOST_EVENT_INVALID = 32,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_dev_type {
	HPX_TYPE_ENDPOINT = 1,
	HPX_TYPE_LEG_END = 2,
	HPX_TYPE_RC_END = 4,
	HPX_TYPE_RC_EC = 8,
	HPX_TYPE_ROOT_PORT = 16,
	HPX_TYPE_UPSTREAM = 32,
	HPX_TYPE_DOWNSTREAM = 64,
	HPX_TYPE_PCI_BRIDGE = 128,
	HPX_TYPE_PCIE_BRIDGE = 256,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hte_edge {
	HTE_EDGE_NO_SETUP = 1,
	HTE_RISING_EDGE_TS = 2,
	HTE_FALLING_EDGE_TS = 4,
};

enum hte_return {
	HTE_CB_HANDLED = 0,
	HTE_RUN_SECOND_CB = 1,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

enum hugetlb_param {
	Opt_gid___6 = 0,
	Opt_min_size = 1,
	Opt_mode___4 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___6 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hw_breakpoint_ops {
	HW_BREAKPOINT_INSTALL = 0,
	HW_BREAKPOINT_UNINSTALL = 1,
	HW_BREAKPOINT_RESTORE = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_UNSPEC = 0,
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum icl_lc_mailbox_cmd {
	ICL_LC_GO2SX = 2,
	ICL_LC_GO2SX_NO_WAKE = 3,
	ICL_LC_PREPARE_FOR_RESET = 33,
};

enum icm_event_code {
	ICM_EVENT_DEVICE_CONNECTED = 3,
	ICM_EVENT_DEVICE_DISCONNECTED = 4,
	ICM_EVENT_XDOMAIN_CONNECTED = 6,
	ICM_EVENT_XDOMAIN_DISCONNECTED = 7,
	ICM_EVENT_RTD3_VETO = 10,
};

enum icm_pkg_code {
	ICM_GET_TOPOLOGY = 1,
	ICM_DRIVER_READY = 3,
	ICM_APPROVE_DEVICE = 4,
	ICM_CHALLENGE_DEVICE = 5,
	ICM_ADD_DEVICE_KEY = 6,
	ICM_GET_ROUTE = 10,
	ICM_APPROVE_XDOMAIN = 16,
	ICM_DISCONNECT_XDOMAIN = 17,
	ICM_PREBOOT_ACL = 24,
	ICM_USB4_SWITCH_OP = 32,
};

enum icst_control_type {
	ICST_VERSATILE = 0,
	ICST_INTEGRATOR_AP_CM = 1,
	ICST_INTEGRATOR_AP_SYS = 2,
	ICST_INTEGRATOR_AP_PCI = 3,
	ICST_INTEGRATOR_CP_CM_CORE = 4,
	ICST_INTEGRATOR_CP_CM_MEM = 5,
	ICST_INTEGRATOR_IM_PD1 = 6,
};

enum id_action {
	ID_REMOVE = 0,
	ID_ADD = 1,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee802154_filtering_level {
	IEEE802154_FILTERING_NONE = 0,
	IEEE802154_FILTERING_1_FCS = 1,
	IEEE802154_FILTERING_2_PROMISCUOUS = 2,
	IEEE802154_FILTERING_3_SCAN = 3,
	IEEE802154_FILTERING_4_FRAME_FIELDS = 4,
};

enum ieee_attrs {
	DCB_ATTR_IEEE_UNSPEC = 0,
	DCB_ATTR_IEEE_ETS = 1,
	DCB_ATTR_IEEE_PFC = 2,
	DCB_ATTR_IEEE_APP_TABLE = 3,
	DCB_ATTR_IEEE_PEER_ETS = 4,
	DCB_ATTR_IEEE_PEER_PFC = 5,
	DCB_ATTR_IEEE_PEER_APP = 6,
	DCB_ATTR_IEEE_MAXRATE = 7,
	DCB_ATTR_IEEE_QCN = 8,
	DCB_ATTR_IEEE_QCN_STATS = 9,
	DCB_ATTR_DCB_BUFFER = 10,
	DCB_ATTR_DCB_APP_TRUST_TABLE = 11,
	DCB_ATTR_DCB_REWR_TABLE = 12,
	__DCB_ATTR_IEEE_MAX = 13,
};

enum ieee_attrs_app {
	DCB_ATTR_IEEE_APP_UNSPEC = 0,
	DCB_ATTR_IEEE_APP = 1,
	DCB_ATTR_DCB_APP = 2,
	__DCB_ATTR_IEEE_APP_MAX = 3,
};

enum ima_fs_flags {
	IMA_FS_BUSY = 0,
};

enum ima_hooks {
	NONE = 0,
	FILE_CHECK = 1,
	MMAP_CHECK = 2,
	MMAP_CHECK_REQPROT = 3,
	BPRM_CHECK = 4,
	CREDS_CHECK = 5,
	POST_SETATTR = 6,
	MODULE_CHECK = 7,
	FIRMWARE_CHECK = 8,
	KEXEC_KERNEL_CHECK = 9,
	KEXEC_INITRAMFS_CHECK = 10,
	POLICY_CHECK = 11,
	KEXEC_CMDLINE = 12,
	KEY_CHECK = 13,
	CRITICAL_DATA = 14,
	SETXATTR_CHECK = 15,
	MAX_CHECK = 16,
};

enum ima_show_type {
	IMA_SHOW_BINARY = 0,
	IMA_SHOW_BINARY_NO_FIELD_LEN = 1,
	IMA_SHOW_BINARY_OLD_STRING_FMT = 2,
	IMA_SHOW_ASCII = 3,
};

enum imx7_src_registers {
	SRC_A7RCR0 = 4,
	SRC_M4RCR = 12,
	SRC_ERCR = 20,
	SRC_HSICPHY_RCR = 28,
	SRC_USBOPHY1_RCR = 32,
	SRC_USBOPHY2_RCR = 36,
	SRC_MIPIPHY_RCR = 40,
	SRC_PCIEPHY_RCR = 44,
	SRC_DDRC_RCR = 4096,
};

enum imx8_pcie_phy_type {
	IMX8MM = 0,
	IMX8MP = 1,
};

enum imx8mm_pads {
	MX8MM_PAD_RESERVE0 = 0,
	MX8MM_PAD_RESERVE1 = 1,
	MX8MM_PAD_RESERVE2 = 2,
	MX8MM_PAD_RESERVE3 = 3,
	MX8MM_PAD_RESERVE4 = 4,
	MX8MM_PAD_RESERVE5 = 5,
	MX8MM_PAD_RESERVE6 = 6,
	MX8MM_PAD_RESERVE7 = 7,
	MX8MM_PAD_RESERVE8 = 8,
	MX8MM_PAD_RESERVE9 = 9,
	MX8MM_IOMUXC_GPIO1_IO00 = 10,
	MX8MM_IOMUXC_GPIO1_IO01 = 11,
	MX8MM_IOMUXC_GPIO1_IO02 = 12,
	MX8MM_IOMUXC_GPIO1_IO03 = 13,
	MX8MM_IOMUXC_GPIO1_IO04 = 14,
	MX8MM_IOMUXC_GPIO1_IO05 = 15,
	MX8MM_IOMUXC_GPIO1_IO06 = 16,
	MX8MM_IOMUXC_GPIO1_IO07 = 17,
	MX8MM_IOMUXC_GPIO1_IO08 = 18,
	MX8MM_IOMUXC_GPIO1_IO09 = 19,
	MX8MM_IOMUXC_GPIO1_IO10 = 20,
	MX8MM_IOMUXC_GPIO1_IO11 = 21,
	MX8MM_IOMUXC_GPIO1_IO12 = 22,
	MX8MM_IOMUXC_GPIO1_IO13 = 23,
	MX8MM_IOMUXC_GPIO1_IO14 = 24,
	MX8MM_IOMUXC_GPIO1_IO15 = 25,
	MX8MM_IOMUXC_ENET_MDC = 26,
	MX8MM_IOMUXC_ENET_MDIO = 27,
	MX8MM_IOMUXC_ENET_TD3 = 28,
	MX8MM_IOMUXC_ENET_TD2 = 29,
	MX8MM_IOMUXC_ENET_TD1 = 30,
	MX8MM_IOMUXC_ENET_TD0 = 31,
	MX8MM_IOMUXC_ENET_TX_CTL = 32,
	MX8MM_IOMUXC_ENET_TXC = 33,
	MX8MM_IOMUXC_ENET_RX_CTL = 34,
	MX8MM_IOMUXC_ENET_RXC = 35,
	MX8MM_IOMUXC_ENET_RD0 = 36,
	MX8MM_IOMUXC_ENET_RD1 = 37,
	MX8MM_IOMUXC_ENET_RD2 = 38,
	MX8MM_IOMUXC_ENET_RD3 = 39,
	MX8MM_IOMUXC_SD1_CLK = 40,
	MX8MM_IOMUXC_SD1_CMD = 41,
	MX8MM_IOMUXC_SD1_DATA0 = 42,
	MX8MM_IOMUXC_SD1_DATA1 = 43,
	MX8MM_IOMUXC_SD1_DATA2 = 44,
	MX8MM_IOMUXC_SD1_DATA3 = 45,
	MX8MM_IOMUXC_SD1_DATA4 = 46,
	MX8MM_IOMUXC_SD1_DATA5 = 47,
	MX8MM_IOMUXC_SD1_DATA6 = 48,
	MX8MM_IOMUXC_SD1_DATA7 = 49,
	MX8MM_IOMUXC_SD1_RESET_B = 50,
	MX8MM_IOMUXC_SD1_STROBE = 51,
	MX8MM_IOMUXC_SD2_CD_B = 52,
	MX8MM_IOMUXC_SD2_CLK = 53,
	MX8MM_IOMUXC_SD2_CMD = 54,
	MX8MM_IOMUXC_SD2_DATA0 = 55,
	MX8MM_IOMUXC_SD2_DATA1 = 56,
	MX8MM_IOMUXC_SD2_DATA2 = 57,
	MX8MM_IOMUXC_SD2_DATA3 = 58,
	MX8MM_IOMUXC_SD2_RESET_B = 59,
	MX8MM_IOMUXC_SD2_WP = 60,
	MX8MM_IOMUXC_NAND_ALE = 61,
	MX8MM_IOMUXC_NAND_CE0 = 62,
	MX8MM_IOMUXC_NAND_CE1 = 63,
	MX8MM_IOMUXC_NAND_CE2 = 64,
	MX8MM_IOMUXC_NAND_CE3 = 65,
	MX8MM_IOMUXC_NAND_CLE = 66,
	MX8MM_IOMUXC_NAND_DATA00 = 67,
	MX8MM_IOMUXC_NAND_DATA01 = 68,
	MX8MM_IOMUXC_NAND_DATA02 = 69,
	MX8MM_IOMUXC_NAND_DATA03 = 70,
	MX8MM_IOMUXC_NAND_DATA04 = 71,
	MX8MM_IOMUXC_NAND_DATA05 = 72,
	MX8MM_IOMUXC_NAND_DATA06 = 73,
	MX8MM_IOMUXC_NAND_DATA07 = 74,
	MX8MM_IOMUXC_NAND_DQS = 75,
	MX8MM_IOMUXC_NAND_RE_B = 76,
	MX8MM_IOMUXC_NAND_READY_B = 77,
	MX8MM_IOMUXC_NAND_WE_B = 78,
	MX8MM_IOMUXC_NAND_WP_B = 79,
	MX8MM_IOMUXC_SAI5_RXFS = 80,
	MX8MM_IOMUXC_SAI5_RXC = 81,
	MX8MM_IOMUXC_SAI5_RXD0 = 82,
	MX8MM_IOMUXC_SAI5_RXD1 = 83,
	MX8MM_IOMUXC_SAI5_RXD2 = 84,
	MX8MM_IOMUXC_SAI5_RXD3 = 85,
	MX8MM_IOMUXC_SAI5_MCLK = 86,
	MX8MM_IOMUXC_SAI1_RXFS = 87,
	MX8MM_IOMUXC_SAI1_RXC = 88,
	MX8MM_IOMUXC_SAI1_RXD0 = 89,
	MX8MM_IOMUXC_SAI1_RXD1 = 90,
	MX8MM_IOMUXC_SAI1_RXD2 = 91,
	MX8MM_IOMUXC_SAI1_RXD3 = 92,
	MX8MM_IOMUXC_SAI1_RXD4 = 93,
	MX8MM_IOMUXC_SAI1_RXD5 = 94,
	MX8MM_IOMUXC_SAI1_RXD6 = 95,
	MX8MM_IOMUXC_SAI1_RXD7 = 96,
	MX8MM_IOMUXC_SAI1_TXFS = 97,
	MX8MM_IOMUXC_SAI1_TXC = 98,
	MX8MM_IOMUXC_SAI1_TXD0 = 99,
	MX8MM_IOMUXC_SAI1_TXD1 = 100,
	MX8MM_IOMUXC_SAI1_TXD2 = 101,
	MX8MM_IOMUXC_SAI1_TXD3 = 102,
	MX8MM_IOMUXC_SAI1_TXD4 = 103,
	MX8MM_IOMUXC_SAI1_TXD5 = 104,
	MX8MM_IOMUXC_SAI1_TXD6 = 105,
	MX8MM_IOMUXC_SAI1_TXD7 = 106,
	MX8MM_IOMUXC_SAI1_MCLK = 107,
	MX8MM_IOMUXC_SAI2_RXFS = 108,
	MX8MM_IOMUXC_SAI2_RXC = 109,
	MX8MM_IOMUXC_SAI2_RXD0 = 110,
	MX8MM_IOMUXC_SAI2_TXFS = 111,
	MX8MM_IOMUXC_SAI2_TXC = 112,
	MX8MM_IOMUXC_SAI2_TXD0 = 113,
	MX8MM_IOMUXC_SAI2_MCLK = 114,
	MX8MM_IOMUXC_SAI3_RXFS = 115,
	MX8MM_IOMUXC_SAI3_RXC = 116,
	MX8MM_IOMUXC_SAI3_RXD = 117,
	MX8MM_IOMUXC_SAI3_TXFS = 118,
	MX8MM_IOMUXC_SAI3_TXC = 119,
	MX8MM_IOMUXC_SAI3_TXD = 120,
	MX8MM_IOMUXC_SAI3_MCLK = 121,
	MX8MM_IOMUXC_SPDIF_TX = 122,
	MX8MM_IOMUXC_SPDIF_RX = 123,
	MX8MM_IOMUXC_SPDIF_EXT_CLK = 124,
	MX8MM_IOMUXC_ECSPI1_SCLK = 125,
	MX8MM_IOMUXC_ECSPI1_MOSI = 126,
	MX8MM_IOMUXC_ECSPI1_MISO = 127,
	MX8MM_IOMUXC_ECSPI1_SS0 = 128,
	MX8MM_IOMUXC_ECSPI2_SCLK = 129,
	MX8MM_IOMUXC_ECSPI2_MOSI = 130,
	MX8MM_IOMUXC_ECSPI2_MISO = 131,
	MX8MM_IOMUXC_ECSPI2_SS0 = 132,
	MX8MM_IOMUXC_I2C1_SCL = 133,
	MX8MM_IOMUXC_I2C1_SDA = 134,
	MX8MM_IOMUXC_I2C2_SCL = 135,
	MX8MM_IOMUXC_I2C2_SDA = 136,
	MX8MM_IOMUXC_I2C3_SCL = 137,
	MX8MM_IOMUXC_I2C3_SDA = 138,
	MX8MM_IOMUXC_I2C4_SCL = 139,
	MX8MM_IOMUXC_I2C4_SDA = 140,
	MX8MM_IOMUXC_UART1_RXD = 141,
	MX8MM_IOMUXC_UART1_TXD = 142,
	MX8MM_IOMUXC_UART2_RXD = 143,
	MX8MM_IOMUXC_UART2_TXD = 144,
	MX8MM_IOMUXC_UART3_RXD = 145,
	MX8MM_IOMUXC_UART3_TXD = 146,
	MX8MM_IOMUXC_UART4_RXD = 147,
	MX8MM_IOMUXC_UART4_TXD = 148,
};

enum imx8mn_pads {
	MX8MN_PAD_RESERVE0 = 0,
	MX8MN_PAD_RESERVE1 = 1,
	MX8MN_PAD_RESERVE2 = 2,
	MX8MN_PAD_RESERVE3 = 3,
	MX8MN_PAD_RESERVE4 = 4,
	MX8MN_PAD_RESERVE5 = 5,
	MX8MN_PAD_RESERVE6 = 6,
	MX8MN_PAD_RESERVE7 = 7,
	MX8MN_IOMUXC_BOOT_MODE2 = 8,
	MX8MN_IOMUXC_BOOT_MODE3 = 9,
	MX8MN_IOMUXC_GPIO1_IO00 = 10,
	MX8MN_IOMUXC_GPIO1_IO01 = 11,
	MX8MN_IOMUXC_GPIO1_IO02 = 12,
	MX8MN_IOMUXC_GPIO1_IO03 = 13,
	MX8MN_IOMUXC_GPIO1_IO04 = 14,
	MX8MN_IOMUXC_GPIO1_IO05 = 15,
	MX8MN_IOMUXC_GPIO1_IO06 = 16,
	MX8MN_IOMUXC_GPIO1_IO07 = 17,
	MX8MN_IOMUXC_GPIO1_IO08 = 18,
	MX8MN_IOMUXC_GPIO1_IO09 = 19,
	MX8MN_IOMUXC_GPIO1_IO10 = 20,
	MX8MN_IOMUXC_GPIO1_IO11 = 21,
	MX8MN_IOMUXC_GPIO1_IO12 = 22,
	MX8MN_IOMUXC_GPIO1_IO13 = 23,
	MX8MN_IOMUXC_GPIO1_IO14 = 24,
	MX8MN_IOMUXC_GPIO1_IO15 = 25,
	MX8MN_IOMUXC_ENET_MDC = 26,
	MX8MN_IOMUXC_ENET_MDIO = 27,
	MX8MN_IOMUXC_ENET_TD3 = 28,
	MX8MN_IOMUXC_ENET_TD2 = 29,
	MX8MN_IOMUXC_ENET_TD1 = 30,
	MX8MN_IOMUXC_ENET_TD0 = 31,
	MX8MN_IOMUXC_ENET_TX_CTL = 32,
	MX8MN_IOMUXC_ENET_TXC = 33,
	MX8MN_IOMUXC_ENET_RX_CTL = 34,
	MX8MN_IOMUXC_ENET_RXC = 35,
	MX8MN_IOMUXC_ENET_RD0 = 36,
	MX8MN_IOMUXC_ENET_RD1 = 37,
	MX8MN_IOMUXC_ENET_RD2 = 38,
	MX8MN_IOMUXC_ENET_RD3 = 39,
	MX8MN_IOMUXC_SD1_CLK = 40,
	MX8MN_IOMUXC_SD1_CMD = 41,
	MX8MN_IOMUXC_SD1_DATA0 = 42,
	MX8MN_IOMUXC_SD1_DATA1 = 43,
	MX8MN_IOMUXC_SD1_DATA2 = 44,
	MX8MN_IOMUXC_SD1_DATA3 = 45,
	MX8MN_IOMUXC_SD1_DATA4 = 46,
	MX8MN_IOMUXC_SD1_DATA5 = 47,
	MX8MN_IOMUXC_SD1_DATA6 = 48,
	MX8MN_IOMUXC_SD1_DATA7 = 49,
	MX8MN_IOMUXC_SD1_RESET_B = 50,
	MX8MN_IOMUXC_SD1_STROBE = 51,
	MX8MN_IOMUXC_SD2_CD_B = 52,
	MX8MN_IOMUXC_SD2_CLK = 53,
	MX8MN_IOMUXC_SD2_CMD = 54,
	MX8MN_IOMUXC_SD2_DATA0 = 55,
	MX8MN_IOMUXC_SD2_DATA1 = 56,
	MX8MN_IOMUXC_SD2_DATA2 = 57,
	MX8MN_IOMUXC_SD2_DATA3 = 58,
	MX8MN_IOMUXC_SD2_RESET_B = 59,
	MX8MN_IOMUXC_SD2_WP = 60,
	MX8MN_IOMUXC_NAND_ALE = 61,
	MX8MN_IOMUXC_NAND_CE0 = 62,
	MX8MN_IOMUXC_NAND_CE1 = 63,
	MX8MN_IOMUXC_NAND_CE2 = 64,
	MX8MN_IOMUXC_NAND_CE3 = 65,
	MX8MN_IOMUXC_NAND_CLE = 66,
	MX8MN_IOMUXC_NAND_DATA00 = 67,
	MX8MN_IOMUXC_NAND_DATA01 = 68,
	MX8MN_IOMUXC_NAND_DATA02 = 69,
	MX8MN_IOMUXC_NAND_DATA03 = 70,
	MX8MN_IOMUXC_NAND_DATA04 = 71,
	MX8MN_IOMUXC_NAND_DATA05 = 72,
	MX8MN_IOMUXC_NAND_DATA06 = 73,
	MX8MN_IOMUXC_NAND_DATA07 = 74,
	MX8MN_IOMUXC_NAND_DQS = 75,
	MX8MN_IOMUXC_NAND_RE_B = 76,
	MX8MN_IOMUXC_NAND_READY_B = 77,
	MX8MN_IOMUXC_NAND_WE_B = 78,
	MX8MN_IOMUXC_NAND_WP_B = 79,
	MX8MN_IOMUXC_SAI5_RXFS = 80,
	MX8MN_IOMUXC_SAI5_RXC = 81,
	MX8MN_IOMUXC_SAI5_RXD0 = 82,
	MX8MN_IOMUXC_SAI5_RXD1 = 83,
	MX8MN_IOMUXC_SAI5_RXD2 = 84,
	MX8MN_IOMUXC_SAI5_RXD3 = 85,
	MX8MN_IOMUXC_SAI5_MCLK = 86,
	MX8MN_IOMUXC_SAI1_RXFS = 87,
	MX8MN_IOMUXC_SAI1_RXC = 88,
	MX8MN_IOMUXC_SAI1_RXD0 = 89,
	MX8MN_IOMUXC_SAI1_RXD1 = 90,
	MX8MN_IOMUXC_SAI1_RXD2 = 91,
	MX8MN_IOMUXC_SAI1_RXD3 = 92,
	MX8MN_IOMUXC_SAI1_RXD4 = 93,
	MX8MN_IOMUXC_SAI1_RXD5 = 94,
	MX8MN_IOMUXC_SAI1_RXD6 = 95,
	MX8MN_IOMUXC_SAI1_RXD7 = 96,
	MX8MN_IOMUXC_SAI1_TXFS = 97,
	MX8MN_IOMUXC_SAI1_TXC = 98,
	MX8MN_IOMUXC_SAI1_TXD0 = 99,
	MX8MN_IOMUXC_SAI1_TXD1 = 100,
	MX8MN_IOMUXC_SAI1_TXD2 = 101,
	MX8MN_IOMUXC_SAI1_TXD3 = 102,
	MX8MN_IOMUXC_SAI1_TXD4 = 103,
	MX8MN_IOMUXC_SAI1_TXD5 = 104,
	MX8MN_IOMUXC_SAI1_TXD6 = 105,
	MX8MN_IOMUXC_SAI1_TXD7 = 106,
	MX8MN_IOMUXC_SAI1_MCLK = 107,
	MX8MN_IOMUXC_SAI2_RXFS = 108,
	MX8MN_IOMUXC_SAI2_RXC = 109,
	MX8MN_IOMUXC_SAI2_RXD0 = 110,
	MX8MN_IOMUXC_SAI2_TXFS = 111,
	MX8MN_IOMUXC_SAI2_TXC = 112,
	MX8MN_IOMUXC_SAI2_TXD0 = 113,
	MX8MN_IOMUXC_SAI2_MCLK = 114,
	MX8MN_IOMUXC_SAI3_RXFS = 115,
	MX8MN_IOMUXC_SAI3_RXC = 116,
	MX8MN_IOMUXC_SAI3_RXD = 117,
	MX8MN_IOMUXC_SAI3_TXFS = 118,
	MX8MN_IOMUXC_SAI3_TXC = 119,
	MX8MN_IOMUXC_SAI3_TXD = 120,
	MX8MN_IOMUXC_SAI3_MCLK = 121,
	MX8MN_IOMUXC_SPDIF_TX = 122,
	MX8MN_IOMUXC_SPDIF_RX = 123,
	MX8MN_IOMUXC_SPDIF_EXT_CLK = 124,
	MX8MN_IOMUXC_ECSPI1_SCLK = 125,
	MX8MN_IOMUXC_ECSPI1_MOSI = 126,
	MX8MN_IOMUXC_ECSPI1_MISO = 127,
	MX8MN_IOMUXC_ECSPI1_SS0 = 128,
	MX8MN_IOMUXC_ECSPI2_SCLK = 129,
	MX8MN_IOMUXC_ECSPI2_MOSI = 130,
	MX8MN_IOMUXC_ECSPI2_MISO = 131,
	MX8MN_IOMUXC_ECSPI2_SS0 = 132,
	MX8MN_IOMUXC_I2C1_SCL = 133,
	MX8MN_IOMUXC_I2C1_SDA = 134,
	MX8MN_IOMUXC_I2C2_SCL = 135,
	MX8MN_IOMUXC_I2C2_SDA = 136,
	MX8MN_IOMUXC_I2C3_SCL = 137,
	MX8MN_IOMUXC_I2C3_SDA = 138,
	MX8MN_IOMUXC_I2C4_SCL = 139,
	MX8MN_IOMUXC_I2C4_SDA = 140,
	MX8MN_IOMUXC_UART1_RXD = 141,
	MX8MN_IOMUXC_UART1_TXD = 142,
	MX8MN_IOMUXC_UART2_RXD = 143,
	MX8MN_IOMUXC_UART2_TXD = 144,
	MX8MN_IOMUXC_UART3_RXD = 145,
	MX8MN_IOMUXC_UART3_TXD = 146,
	MX8MN_IOMUXC_UART4_RXD = 147,
	MX8MN_IOMUXC_UART4_TXD = 148,
};

enum imx8mp_pads {
	MX8MP_IOMUXC_RESERVE0 = 0,
	MX8MP_IOMUXC_RESERVE1 = 1,
	MX8MP_IOMUXC_RESERVE2 = 2,
	MX8MP_IOMUXC_RESERVE3 = 3,
	MX8MP_IOMUXC_RESERVE4 = 4,
	MX8MP_IOMUXC_GPIO1_IO00 = 5,
	MX8MP_IOMUXC_GPIO1_IO01 = 6,
	MX8MP_IOMUXC_GPIO1_IO02 = 7,
	MX8MP_IOMUXC_GPIO1_IO03 = 8,
	MX8MP_IOMUXC_GPIO1_IO04 = 9,
	MX8MP_IOMUXC_GPIO1_IO05 = 10,
	MX8MP_IOMUXC_GPIO1_IO06 = 11,
	MX8MP_IOMUXC_GPIO1_IO07 = 12,
	MX8MP_IOMUXC_GPIO1_IO08 = 13,
	MX8MP_IOMUXC_GPIO1_IO09 = 14,
	MX8MP_IOMUXC_GPIO1_IO10 = 15,
	MX8MP_IOMUXC_GPIO1_IO11 = 16,
	MX8MP_IOMUXC_GPIO1_IO12 = 17,
	MX8MP_IOMUXC_GPIO1_IO13 = 18,
	MX8MP_IOMUXC_GPIO1_IO14 = 19,
	MX8MP_IOMUXC_GPIO1_IO15 = 20,
	MX8MP_IOMUXC_ENET_MDC = 21,
	MX8MP_IOMUXC_ENET_MDIO = 22,
	MX8MP_IOMUXC_ENET_TD3 = 23,
	MX8MP_IOMUXC_ENET_TD2 = 24,
	MX8MP_IOMUXC_ENET_TD1 = 25,
	MX8MP_IOMUXC_ENET_TD0 = 26,
	MX8MP_IOMUXC_ENET_TX_CTL = 27,
	MX8MP_IOMUXC_ENET_TXC = 28,
	MX8MP_IOMUXC_ENET_RX_CTL = 29,
	MX8MP_IOMUXC_ENET_RXC = 30,
	MX8MP_IOMUXC_ENET_RD0 = 31,
	MX8MP_IOMUXC_ENET_RD1 = 32,
	MX8MP_IOMUXC_ENET_RD2 = 33,
	MX8MP_IOMUXC_ENET_RD3 = 34,
	MX8MP_IOMUXC_SD1_CLK = 35,
	MX8MP_IOMUXC_SD1_CMD = 36,
	MX8MP_IOMUXC_SD1_DATA0 = 37,
	MX8MP_IOMUXC_SD1_DATA1 = 38,
	MX8MP_IOMUXC_SD1_DATA2 = 39,
	MX8MP_IOMUXC_SD1_DATA3 = 40,
	MX8MP_IOMUXC_SD1_DATA4 = 41,
	MX8MP_IOMUXC_SD1_DATA5 = 42,
	MX8MP_IOMUXC_SD1_DATA6 = 43,
	MX8MP_IOMUXC_SD1_DATA7 = 44,
	MX8MP_IOMUXC_SD1_RESET_B = 45,
	MX8MP_IOMUXC_SD1_STROBE = 46,
	MX8MP_IOMUXC_SD2_CD_B = 47,
	MX8MP_IOMUXC_SD2_CLK = 48,
	MX8MP_IOMUXC_SD2_CMD = 49,
	MX8MP_IOMUXC_SD2_DATA0 = 50,
	MX8MP_IOMUXC_SD2_DATA1 = 51,
	MX8MP_IOMUXC_SD2_DATA2 = 52,
	MX8MP_IOMUXC_SD2_DATA3 = 53,
	MX8MP_IOMUXC_SD2_RESET_B = 54,
	MX8MP_IOMUXC_SD2_WP = 55,
	MX8MP_IOMUXC_NAND_ALE = 56,
	MX8MP_IOMUXC_NAND_CE0_B = 57,
	MX8MP_IOMUXC_NAND_CE1_B = 58,
	MX8MP_IOMUXC_NAND_CE2_B = 59,
	MX8MP_IOMUXC_NAND_CE3_B = 60,
	MX8MP_IOMUXC_NAND_CLE = 61,
	MX8MP_IOMUXC_NAND_DATA00 = 62,
	MX8MP_IOMUXC_NAND_DATA01 = 63,
	MX8MP_IOMUXC_NAND_DATA02 = 64,
	MX8MP_IOMUXC_NAND_DATA03 = 65,
	MX8MP_IOMUXC_NAND_DATA04 = 66,
	MX8MP_IOMUXC_NAND_DATA05 = 67,
	MX8MP_IOMUXC_NAND_DATA06 = 68,
	MX8MP_IOMUXC_NAND_DATA07 = 69,
	MX8MP_IOMUXC_NAND_DQS = 70,
	MX8MP_IOMUXC_NAND_RE_B = 71,
	MX8MP_IOMUXC_NAND_READY_B = 72,
	MX8MP_IOMUXC_NAND_WE_B = 73,
	MX8MP_IOMUXC_NAND_WP_B = 74,
	MX8MP_IOMUXC_SAI5_RXFS = 75,
	MX8MP_IOMUXC_SAI5_RXC = 76,
	MX8MP_IOMUXC_SAI5_RXD0 = 77,
	MX8MP_IOMUXC_SAI5_RXD1 = 78,
	MX8MP_IOMUXC_SAI5_RXD2 = 79,
	MX8MP_IOMUXC_SAI5_RXD3 = 80,
	MX8MP_IOMUXC_SAI5_MCLK = 81,
	MX8MP_IOMUXC_SAI1_RXFS = 82,
	MX8MP_IOMUXC_SAI1_RXC = 83,
	MX8MP_IOMUXC_SAI1_RXD0 = 84,
	MX8MP_IOMUXC_SAI1_RXD1 = 85,
	MX8MP_IOMUXC_SAI1_RXD2 = 86,
	MX8MP_IOMUXC_SAI1_RXD3 = 87,
	MX8MP_IOMUXC_SAI1_RXD4 = 88,
	MX8MP_IOMUXC_SAI1_RXD5 = 89,
	MX8MP_IOMUXC_SAI1_RXD6 = 90,
	MX8MP_IOMUXC_SAI1_RXD7 = 91,
	MX8MP_IOMUXC_SAI1_TXFS = 92,
	MX8MP_IOMUXC_SAI1_TXC = 93,
	MX8MP_IOMUXC_SAI1_TXD0 = 94,
	MX8MP_IOMUXC_SAI1_TXD1 = 95,
	MX8MP_IOMUXC_SAI1_TXD2 = 96,
	MX8MP_IOMUXC_SAI1_TXD3 = 97,
	MX8MP_IOMUXC_SAI1_TXD4 = 98,
	MX8MP_IOMUXC_SAI1_TXD5 = 99,
	MX8MP_IOMUXC_SAI1_TXD6 = 100,
	MX8MP_IOMUXC_SAI1_TXD7 = 101,
	MX8MP_IOMUXC_SAI1_MCLK = 102,
	MX8MP_IOMUXC_SAI2_RXFS = 103,
	MX8MP_IOMUXC_SAI2_RXC = 104,
	MX8MP_IOMUXC_SAI2_RXD0 = 105,
	MX8MP_IOMUXC_SAI2_TXFS = 106,
	MX8MP_IOMUXC_SAI2_TXC = 107,
	MX8MP_IOMUXC_SAI2_TXD0 = 108,
	MX8MP_IOMUXC_SAI2_MCLK = 109,
	MX8MP_IOMUXC_SAI3_RXFS = 110,
	MX8MP_IOMUXC_SAI3_RXC = 111,
	MX8MP_IOMUXC_SAI3_RXD = 112,
	MX8MP_IOMUXC_SAI3_TXFS = 113,
	MX8MP_IOMUXC_SAI3_TXC = 114,
	MX8MP_IOMUXC_SAI3_TXD = 115,
	MX8MP_IOMUXC_SAI3_MCLK = 116,
	MX8MP_IOMUXC_SPDIF_TX = 117,
	MX8MP_IOMUXC_SPDIF_RX = 118,
	MX8MP_IOMUXC_SPDIF_EXT_CLK = 119,
	MX8MP_IOMUXC_ECSPI1_SCLK = 120,
	MX8MP_IOMUXC_ECSPI1_MOSI = 121,
	MX8MP_IOMUXC_ECSPI1_MISO = 122,
	MX8MP_IOMUXC_ECSPI1_SS0 = 123,
	MX8MP_IOMUXC_ECSPI2_SCLK = 124,
	MX8MP_IOMUXC_ECSPI2_MOSI = 125,
	MX8MP_IOMUXC_ECSPI2_MISO = 126,
	MX8MP_IOMUXC_ECSPI2_SS0 = 127,
	MX8MP_IOMUXC_I2C1_SCL = 128,
	MX8MP_IOMUXC_I2C1_SDA = 129,
	MX8MP_IOMUXC_I2C2_SCL = 130,
	MX8MP_IOMUXC_I2C2_SDA = 131,
	MX8MP_IOMUXC_I2C3_SCL = 132,
	MX8MP_IOMUXC_I2C3_SDA = 133,
	MX8MP_IOMUXC_I2C4_SCL = 134,
	MX8MP_IOMUXC_I2C4_SDA = 135,
	MX8MP_IOMUXC_UART1_RXD = 136,
	MX8MP_IOMUXC_UART1_TXD = 137,
	MX8MP_IOMUXC_UART2_RXD = 138,
	MX8MP_IOMUXC_UART2_TXD = 139,
	MX8MP_IOMUXC_UART3_RXD = 140,
	MX8MP_IOMUXC_UART3_TXD = 141,
	MX8MP_IOMUXC_UART4_RXD = 142,
	MX8MP_IOMUXC_UART4_TXD = 143,
	MX8MP_IOMUXC_HDMI_DDC_SCL = 144,
	MX8MP_IOMUXC_HDMI_DDC_SDA = 145,
	MX8MP_IOMUXC_HDMI_CEC = 146,
	MX8MP_IOMUXC_HDMI_HPD = 147,
};

enum imx8mp_src_registers {
	SRC_SUPERMIX_RCR = 24,
	SRC_AUDIOMIX_RCR = 28,
	SRC_MLMIX_RCR = 40,
	SRC_GPU2D_RCR = 56,
	SRC_GPU3D_RCR = 60,
	SRC_VPU_G1_RCR = 72,
	SRC_VPU_G2_RCR = 76,
	SRC_VPUVC8KE_RCR = 80,
	SRC_NOC_RCR = 84,
};

enum imx8mq_pads {
	MX8MQ_PAD_RESERVE0 = 0,
	MX8MQ_PAD_RESERVE1 = 1,
	MX8MQ_PAD_RESERVE2 = 2,
	MX8MQ_PAD_RESERVE3 = 3,
	MX8MQ_PAD_RESERVE4 = 4,
	MX8MQ_IOMUXC_PMIC_STBY_REQ_CCMSRCGPCMIX = 5,
	MX8MQ_IOMUXC_PMIC_ON_REQ_SNVSMIX = 6,
	MX8MQ_IOMUXC_ONOFF_SNVSMIX = 7,
	MX8MQ_IOMUXC_POR_B_SNVSMIX = 8,
	MX8MQ_IOMUXC_RTC_RESET_B_SNVSMIX = 9,
	MX8MQ_IOMUXC_GPIO1_IO00 = 10,
	MX8MQ_IOMUXC_GPIO1_IO01 = 11,
	MX8MQ_IOMUXC_GPIO1_IO02 = 12,
	MX8MQ_IOMUXC_GPIO1_IO03 = 13,
	MX8MQ_IOMUXC_GPIO1_IO04 = 14,
	MX8MQ_IOMUXC_GPIO1_IO05 = 15,
	MX8MQ_IOMUXC_GPIO1_IO06 = 16,
	MX8MQ_IOMUXC_GPIO1_IO07 = 17,
	MX8MQ_IOMUXC_GPIO1_IO08 = 18,
	MX8MQ_IOMUXC_GPIO1_IO09 = 19,
	MX8MQ_IOMUXC_GPIO1_IO10 = 20,
	MX8MQ_IOMUXC_GPIO1_IO11 = 21,
	MX8MQ_IOMUXC_GPIO1_IO12 = 22,
	MX8MQ_IOMUXC_GPIO1_IO13 = 23,
	MX8MQ_IOMUXC_GPIO1_IO14 = 24,
	MX8MQ_IOMUXC_GPIO1_IO15 = 25,
	MX8MQ_IOMUXC_ENET_MDC = 26,
	MX8MQ_IOMUXC_ENET_MDIO = 27,
	MX8MQ_IOMUXC_ENET_TD3 = 28,
	MX8MQ_IOMUXC_ENET_TD2 = 29,
	MX8MQ_IOMUXC_ENET_TD1 = 30,
	MX8MQ_IOMUXC_ENET_TD0 = 31,
	MX8MQ_IOMUXC_ENET_TX_CTL = 32,
	MX8MQ_IOMUXC_ENET_TXC = 33,
	MX8MQ_IOMUXC_ENET_RX_CTL = 34,
	MX8MQ_IOMUXC_ENET_RXC = 35,
	MX8MQ_IOMUXC_ENET_RD0 = 36,
	MX8MQ_IOMUXC_ENET_RD1 = 37,
	MX8MQ_IOMUXC_ENET_RD2 = 38,
	MX8MQ_IOMUXC_ENET_RD3 = 39,
	MX8MQ_IOMUXC_SD1_CLK = 40,
	MX8MQ_IOMUXC_SD1_CMD = 41,
	MX8MQ_IOMUXC_SD1_DATA0 = 42,
	MX8MQ_IOMUXC_SD1_DATA1 = 43,
	MX8MQ_IOMUXC_SD1_DATA2 = 44,
	MX8MQ_IOMUXC_SD1_DATA3 = 45,
	MX8MQ_IOMUXC_SD1_DATA4 = 46,
	MX8MQ_IOMUXC_SD1_DATA5 = 47,
	MX8MQ_IOMUXC_SD1_DATA6 = 48,
	MX8MQ_IOMUXC_SD1_DATA7 = 49,
	MX8MQ_IOMUXC_SD1_RESET_B = 50,
	MX8MQ_IOMUXC_SD1_STROBE = 51,
	MX8MQ_IOMUXC_SD2_CD_B = 52,
	MX8MQ_IOMUXC_SD2_CLK = 53,
	MX8MQ_IOMUXC_SD2_CMD = 54,
	MX8MQ_IOMUXC_SD2_DATA0 = 55,
	MX8MQ_IOMUXC_SD2_DATA1 = 56,
	MX8MQ_IOMUXC_SD2_DATA2 = 57,
	MX8MQ_IOMUXC_SD2_DATA3 = 58,
	MX8MQ_IOMUXC_SD2_RESET_B = 59,
	MX8MQ_IOMUXC_SD2_WP = 60,
	MX8MQ_IOMUXC_NAND_ALE = 61,
	MX8MQ_IOMUXC_NAND_CE0_B = 62,
	MX8MQ_IOMUXC_NAND_CE1_B = 63,
	MX8MQ_IOMUXC_NAND_CE2_B = 64,
	MX8MQ_IOMUXC_NAND_CE3_B = 65,
	MX8MQ_IOMUXC_NAND_CLE = 66,
	MX8MQ_IOMUXC_NAND_DATA00 = 67,
	MX8MQ_IOMUXC_NAND_DATA01 = 68,
	MX8MQ_IOMUXC_NAND_DATA02 = 69,
	MX8MQ_IOMUXC_NAND_DATA03 = 70,
	MX8MQ_IOMUXC_NAND_DATA04 = 71,
	MX8MQ_IOMUXC_NAND_DATA05 = 72,
	MX8MQ_IOMUXC_NAND_DATA06 = 73,
	MX8MQ_IOMUXC_NAND_DATA07 = 74,
	MX8MQ_IOMUXC_NAND_DQS = 75,
	MX8MQ_IOMUXC_NAND_RE_B = 76,
	MX8MQ_IOMUXC_NAND_READY_B = 77,
	MX8MQ_IOMUXC_NAND_WE_B = 78,
	MX8MQ_IOMUXC_NAND_WP_B = 79,
	MX8MQ_IOMUXC_SAI5_RXFS = 80,
	MX8MQ_IOMUXC_SAI5_RXC = 81,
	MX8MQ_IOMUXC_SAI5_RXD0 = 82,
	MX8MQ_IOMUXC_SAI5_RXD1 = 83,
	MX8MQ_IOMUXC_SAI5_RXD2 = 84,
	MX8MQ_IOMUXC_SAI5_RXD3 = 85,
	MX8MQ_IOMUXC_SAI5_MCLK = 86,
	MX8MQ_IOMUXC_SAI1_RXFS = 87,
	MX8MQ_IOMUXC_SAI1_RXC = 88,
	MX8MQ_IOMUXC_SAI1_RXD0 = 89,
	MX8MQ_IOMUXC_SAI1_RXD1 = 90,
	MX8MQ_IOMUXC_SAI1_RXD2 = 91,
	MX8MQ_IOMUXC_SAI1_RXD3 = 92,
	MX8MQ_IOMUXC_SAI1_RXD4 = 93,
	MX8MQ_IOMUXC_SAI1_RXD5 = 94,
	MX8MQ_IOMUXC_SAI1_RXD6 = 95,
	MX8MQ_IOMUXC_SAI1_RXD7 = 96,
	MX8MQ_IOMUXC_SAI1_TXFS = 97,
	MX8MQ_IOMUXC_SAI1_TXC = 98,
	MX8MQ_IOMUXC_SAI1_TXD0 = 99,
	MX8MQ_IOMUXC_SAI1_TXD1 = 100,
	MX8MQ_IOMUXC_SAI1_TXD2 = 101,
	MX8MQ_IOMUXC_SAI1_TXD3 = 102,
	MX8MQ_IOMUXC_SAI1_TXD4 = 103,
	MX8MQ_IOMUXC_SAI1_TXD5 = 104,
	MX8MQ_IOMUXC_SAI1_TXD6 = 105,
	MX8MQ_IOMUXC_SAI1_TXD7 = 106,
	MX8MQ_IOMUXC_SAI1_MCLK = 107,
	MX8MQ_IOMUXC_SAI2_RXFS = 108,
	MX8MQ_IOMUXC_SAI2_RXC = 109,
	MX8MQ_IOMUXC_SAI2_RXD0 = 110,
	MX8MQ_IOMUXC_SAI2_TXFS = 111,
	MX8MQ_IOMUXC_SAI2_TXC = 112,
	MX8MQ_IOMUXC_SAI2_TXD0 = 113,
	MX8MQ_IOMUXC_SAI2_MCLK = 114,
	MX8MQ_IOMUXC_SAI3_RXFS = 115,
	MX8MQ_IOMUXC_SAI3_RXC = 116,
	MX8MQ_IOMUXC_SAI3_RXD = 117,
	MX8MQ_IOMUXC_SAI3_TXFS = 118,
	MX8MQ_IOMUXC_SAI3_TXC = 119,
	MX8MQ_IOMUXC_SAI3_TXD = 120,
	MX8MQ_IOMUXC_SAI3_MCLK = 121,
	MX8MQ_IOMUXC_SPDIF_TX = 122,
	MX8MQ_IOMUXC_SPDIF_RX = 123,
	MX8MQ_IOMUXC_SPDIF_EXT_CLK = 124,
	MX8MQ_IOMUXC_ECSPI1_SCLK = 125,
	MX8MQ_IOMUXC_ECSPI1_MOSI = 126,
	MX8MQ_IOMUXC_ECSPI1_MISO = 127,
	MX8MQ_IOMUXC_ECSPI1_SS0 = 128,
	MX8MQ_IOMUXC_ECSPI2_SCLK = 129,
	MX8MQ_IOMUXC_ECSPI2_MOSI = 130,
	MX8MQ_IOMUXC_ECSPI2_MISO = 131,
	MX8MQ_IOMUXC_ECSPI2_SS0 = 132,
	MX8MQ_IOMUXC_I2C1_SCL = 133,
	MX8MQ_IOMUXC_I2C1_SDA = 134,
	MX8MQ_IOMUXC_I2C2_SCL = 135,
	MX8MQ_IOMUXC_I2C2_SDA = 136,
	MX8MQ_IOMUXC_I2C3_SCL = 137,
	MX8MQ_IOMUXC_I2C3_SDA = 138,
	MX8MQ_IOMUXC_I2C4_SCL = 139,
	MX8MQ_IOMUXC_I2C4_SDA = 140,
	MX8MQ_IOMUXC_UART1_RXD = 141,
	MX8MQ_IOMUXC_UART1_TXD = 142,
	MX8MQ_IOMUXC_UART2_RXD = 143,
	MX8MQ_IOMUXC_UART2_TXD = 144,
	MX8MQ_IOMUXC_UART3_RXD = 145,
	MX8MQ_IOMUXC_UART3_TXD = 146,
	MX8MQ_IOMUXC_UART4_RXD = 147,
	MX8MQ_IOMUXC_UART4_TXD = 148,
};

enum imx8mq_src_registers {
	SRC_A53RCR0 = 4,
	SRC_HDMI_RCR = 48,
	SRC_DISP_RCR = 52,
	SRC_GPU_RCR = 64,
	SRC_VPU_RCR = 68,
	SRC_PCIE2_RCR = 72,
	SRC_MIPIPHY1_RCR = 76,
	SRC_MIPIPHY2_RCR = 80,
	SRC_DDRC2_RCR = 4100,
};

enum imx8ulp_pads {
	IMX8ULP_PAD_PTD0 = 0,
	IMX8ULP_PAD_PTD1 = 1,
	IMX8ULP_PAD_PTD2 = 2,
	IMX8ULP_PAD_PTD3 = 3,
	IMX8ULP_PAD_PTD4 = 4,
	IMX8ULP_PAD_PTD5 = 5,
	IMX8ULP_PAD_PTD6 = 6,
	IMX8ULP_PAD_PTD7 = 7,
	IMX8ULP_PAD_PTD8 = 8,
	IMX8ULP_PAD_PTD9 = 9,
	IMX8ULP_PAD_PTD10 = 10,
	IMX8ULP_PAD_PTD11 = 11,
	IMX8ULP_PAD_PTD12 = 12,
	IMX8ULP_PAD_PTD13 = 13,
	IMX8ULP_PAD_PTD14 = 14,
	IMX8ULP_PAD_PTD15 = 15,
	IMX8ULP_PAD_PTD16 = 16,
	IMX8ULP_PAD_PTD17 = 17,
	IMX8ULP_PAD_PTD18 = 18,
	IMX8ULP_PAD_PTD19 = 19,
	IMX8ULP_PAD_PTD20 = 20,
	IMX8ULP_PAD_PTD21 = 21,
	IMX8ULP_PAD_PTD22 = 22,
	IMX8ULP_PAD_PTD23 = 23,
	IMX8ULP_PAD_RESERVE0 = 24,
	IMX8ULP_PAD_RESERVE1 = 25,
	IMX8ULP_PAD_RESERVE2 = 26,
	IMX8ULP_PAD_RESERVE3 = 27,
	IMX8ULP_PAD_RESERVE4 = 28,
	IMX8ULP_PAD_RESERVE5 = 29,
	IMX8ULP_PAD_RESERVE6 = 30,
	IMX8ULP_PAD_RESERVE7 = 31,
	IMX8ULP_PAD_PTE0 = 32,
	IMX8ULP_PAD_PTE1 = 33,
	IMX8ULP_PAD_PTE2 = 34,
	IMX8ULP_PAD_PTE3 = 35,
	IMX8ULP_PAD_PTE4 = 36,
	IMX8ULP_PAD_PTE5 = 37,
	IMX8ULP_PAD_PTE6 = 38,
	IMX8ULP_PAD_PTE7 = 39,
	IMX8ULP_PAD_PTE8 = 40,
	IMX8ULP_PAD_PTE9 = 41,
	IMX8ULP_PAD_PTE10 = 42,
	IMX8ULP_PAD_PTE11 = 43,
	IMX8ULP_PAD_PTE12 = 44,
	IMX8ULP_PAD_PTE13 = 45,
	IMX8ULP_PAD_PTE14 = 46,
	IMX8ULP_PAD_PTE15 = 47,
	IMX8ULP_PAD_PTE16 = 48,
	IMX8ULP_PAD_PTE17 = 49,
	IMX8ULP_PAD_PTE18 = 50,
	IMX8ULP_PAD_PTE19 = 51,
	IMX8ULP_PAD_PTE20 = 52,
	IMX8ULP_PAD_PTE21 = 53,
	IMX8ULP_PAD_PTE22 = 54,
	IMX8ULP_PAD_PTE23 = 55,
	IMX8ULP_PAD_RESERVE8 = 56,
	IMX8ULP_PAD_RESERVE9 = 57,
	IMX8ULP_PAD_RESERVE10 = 58,
	IMX8ULP_PAD_RESERVE11 = 59,
	IMX8ULP_PAD_RESERVE12 = 60,
	IMX8ULP_PAD_RESERVE13 = 61,
	IMX8ULP_PAD_RESERVE14 = 62,
	IMX8ULP_PAD_RESERVE15 = 63,
	IMX8ULP_PAD_PTF0 = 64,
	IMX8ULP_PAD_PTF1 = 65,
	IMX8ULP_PAD_PTF2 = 66,
	IMX8ULP_PAD_PTF3 = 67,
	IMX8ULP_PAD_PTF4 = 68,
	IMX8ULP_PAD_PTF5 = 69,
	IMX8ULP_PAD_PTF6 = 70,
	IMX8ULP_PAD_PTF7 = 71,
	IMX8ULP_PAD_PTF8 = 72,
	IMX8ULP_PAD_PTF9 = 73,
	IMX8ULP_PAD_PTF10 = 74,
	IMX8ULP_PAD_PTF11 = 75,
	IMX8ULP_PAD_PTF12 = 76,
	IMX8ULP_PAD_PTF13 = 77,
	IMX8ULP_PAD_PTF14 = 78,
	IMX8ULP_PAD_PTF15 = 79,
	IMX8ULP_PAD_PTF16 = 80,
	IMX8ULP_PAD_PTF17 = 81,
	IMX8ULP_PAD_PTF18 = 82,
	IMX8ULP_PAD_PTF19 = 83,
	IMX8ULP_PAD_PTF20 = 84,
	IMX8ULP_PAD_PTF21 = 85,
	IMX8ULP_PAD_PTF22 = 86,
	IMX8ULP_PAD_PTF23 = 87,
	IMX8ULP_PAD_PTF24 = 88,
	IMX8ULP_PAD_PTF25 = 89,
	IMX8ULP_PAD_PTF26 = 90,
	IMX8ULP_PAD_PTF27 = 91,
	IMX8ULP_PAD_PTF28 = 92,
	IMX8ULP_PAD_PTF29 = 93,
	IMX8ULP_PAD_PTF30 = 94,
	IMX8ULP_PAD_PTF31 = 95,
};

enum imx91_pads {
	IMX91_PAD_DAP_TDI = 0,
	IMX91_PAD_DAP_TMS_SWDIO = 1,
	IMX91_PAD_DAP_TCLK_SWCLK = 2,
	IMX91_PAD_DAP_TDO_TRACESWO = 3,
	IMX91_PAD_GPIO_IO00 = 4,
	IMX91_PAD_GPIO_IO01 = 5,
	IMX91_PAD_GPIO_IO02 = 6,
	IMX91_PAD_GPIO_IO03 = 7,
	IMX91_PAD_GPIO_IO04 = 8,
	IMX91_PAD_GPIO_IO05 = 9,
	IMX91_PAD_GPIO_IO06 = 10,
	IMX91_PAD_GPIO_IO07 = 11,
	IMX91_PAD_GPIO_IO08 = 12,
	IMX91_PAD_GPIO_IO09 = 13,
	IMX91_PAD_GPIO_IO10 = 14,
	IMX91_PAD_GPIO_IO11 = 15,
	IMX91_PAD_GPIO_IO12 = 16,
	IMX91_PAD_GPIO_IO13 = 17,
	IMX91_PAD_GPIO_IO14 = 18,
	IMX91_PAD_GPIO_IO15 = 19,
	IMX91_PAD_GPIO_IO16 = 20,
	IMX91_PAD_GPIO_IO17 = 21,
	IMX91_PAD_GPIO_IO18 = 22,
	IMX91_PAD_GPIO_IO19 = 23,
	IMX91_PAD_GPIO_IO20 = 24,
	IMX91_PAD_GPIO_IO21 = 25,
	IMX91_PAD_GPIO_IO22 = 26,
	IMX91_PAD_GPIO_IO23 = 27,
	IMX91_PAD_GPIO_IO24 = 28,
	IMX91_PAD_GPIO_IO25 = 29,
	IMX91_PAD_GPIO_IO26 = 30,
	IMX91_PAD_GPIO_IO27 = 31,
	IMX91_PAD_GPIO_IO28 = 32,
	IMX91_PAD_GPIO_IO29 = 33,
	IMX91_PAD_CCM_CLKO1 = 34,
	IMX91_PAD_CCM_CLKO2 = 35,
	IMX91_PAD_CCM_CLKO3 = 36,
	IMX91_PAD_CCM_CLKO4 = 37,
	IMX91_PAD_ENET1_MDC = 38,
	IMX91_PAD_ENET1_MDIO = 39,
	IMX91_PAD_ENET1_TD3 = 40,
	IMX91_PAD_ENET1_TD2 = 41,
	IMX91_PAD_ENET1_TD1 = 42,
	IMX91_PAD_ENET1_TD0 = 43,
	IMX91_PAD_ENET1_TX_CTL = 44,
	IMX91_PAD_ENET1_TXC = 45,
	IMX91_PAD_ENET1_RX_CTL = 46,
	IMX91_PAD_ENET1_RXC = 47,
	IMX91_PAD_ENET1_RD0 = 48,
	IMX91_PAD_ENET1_RD1 = 49,
	IMX91_PAD_ENET1_RD2 = 50,
	IMX91_PAD_ENET1_RD3 = 51,
	IMX91_PAD_ENET2_MDC = 52,
	IMX91_PAD_ENET2_MDIO = 53,
	IMX91_PAD_ENET2_TD3 = 54,
	IMX91_PAD_ENET2_TD2 = 55,
	IMX91_PAD_ENET2_TD1 = 56,
	IMX91_PAD_ENET2_TD0 = 57,
	IMX91_PAD_ENET2_TX_CTL = 58,
	IMX91_PAD_ENET2_TXC = 59,
	IMX91_PAD_ENET2_RX_CTL = 60,
	IMX91_PAD_ENET2_RXC = 61,
	IMX91_PAD_ENET2_RD0 = 62,
	IMX91_PAD_ENET2_RD1 = 63,
	IMX91_PAD_ENET2_RD2 = 64,
	IMX91_PAD_ENET2_RD3 = 65,
	IMX91_PAD_SD1_CLK = 66,
	IMX91_PAD_SD1_CMD = 67,
	IMX91_PAD_SD1_DATA0 = 68,
	IMX91_PAD_SD1_DATA1 = 69,
	IMX91_PAD_SD1_DATA2 = 70,
	IMX91_PAD_SD1_DATA3 = 71,
	IMX91_PAD_SD1_DATA4 = 72,
	IMX91_PAD_SD1_DATA5 = 73,
	IMX91_PAD_SD1_DATA6 = 74,
	IMX91_PAD_SD1_DATA7 = 75,
	IMX91_PAD_SD1_STROBE = 76,
	IMX91_PAD_SD2_VSELECT = 77,
	IMX91_PAD_SD3_CLK = 78,
	IMX91_PAD_SD3_CMD = 79,
	IMX91_PAD_SD3_DATA0 = 80,
	IMX91_PAD_SD3_DATA1 = 81,
	IMX91_PAD_SD3_DATA2 = 82,
	IMX91_PAD_SD3_DATA3 = 83,
	IMX91_PAD_SD2_CD_B = 84,
	IMX91_PAD_SD2_CLK = 85,
	IMX91_PAD_SD2_CMD = 86,
	IMX91_PAD_SD2_DATA0 = 87,
	IMX91_PAD_SD2_DATA1 = 88,
	IMX91_PAD_SD2_DATA2 = 89,
	IMX91_PAD_SD2_DATA3 = 90,
	IMX91_PAD_SD2_RESET_B = 91,
	IMX91_PAD_I2C1_SCL = 92,
	IMX91_PAD_I2C1_SDA = 93,
	IMX91_PAD_I2C2_SCL = 94,
	IMX91_PAD_I2C2_SDA = 95,
	IMX91_PAD_UART1_RXD = 96,
	IMX91_PAD_UART1_TXD = 97,
	IMX91_PAD_UART2_RXD = 98,
	IMX91_PAD_UART2_TXD = 99,
	IMX91_PAD_PDM_CLK = 100,
	IMX91_PAD_PDM_BIT_STREAM0 = 101,
	IMX91_PAD_PDM_BIT_STREAM1 = 102,
	IMX91_PAD_SAI1_TXFS = 103,
	IMX91_PAD_SAI1_TXC = 104,
	IMX91_PAD_SAI1_TXD0 = 105,
	IMX91_PAD_SAI1_RXD0 = 106,
	IMX91_PAD_WDOG_ANY = 107,
};

enum imx93_pads {
	IMX93_IOMUXC_DAP_TDI = 0,
	IMX93_IOMUXC_DAP_TMS_SWDIO = 1,
	IMX93_IOMUXC_DAP_TCLK_SWCLK = 2,
	IMX93_IOMUXC_DAP_TDO_TRACESWO = 3,
	IMX93_IOMUXC_GPIO_IO00 = 4,
	IMX93_IOMUXC_GPIO_IO01 = 5,
	IMX93_IOMUXC_GPIO_IO02 = 6,
	IMX93_IOMUXC_GPIO_IO03 = 7,
	IMX93_IOMUXC_GPIO_IO04 = 8,
	IMX93_IOMUXC_GPIO_IO05 = 9,
	IMX93_IOMUXC_GPIO_IO06 = 10,
	IMX93_IOMUXC_GPIO_IO07 = 11,
	IMX93_IOMUXC_GPIO_IO08 = 12,
	IMX93_IOMUXC_GPIO_IO09 = 13,
	IMX93_IOMUXC_GPIO_IO10 = 14,
	IMX93_IOMUXC_GPIO_IO11 = 15,
	IMX93_IOMUXC_GPIO_IO12 = 16,
	IMX93_IOMUXC_GPIO_IO13 = 17,
	IMX93_IOMUXC_GPIO_IO14 = 18,
	IMX93_IOMUXC_GPIO_IO15 = 19,
	IMX93_IOMUXC_GPIO_IO16 = 20,
	IMX93_IOMUXC_GPIO_IO17 = 21,
	IMX93_IOMUXC_GPIO_IO18 = 22,
	IMX93_IOMUXC_GPIO_IO19 = 23,
	IMX93_IOMUXC_GPIO_IO20 = 24,
	IMX93_IOMUXC_GPIO_IO21 = 25,
	IMX93_IOMUXC_GPIO_IO22 = 26,
	IMX93_IOMUXC_GPIO_IO23 = 27,
	IMX93_IOMUXC_GPIO_IO24 = 28,
	IMX93_IOMUXC_GPIO_IO25 = 29,
	IMX93_IOMUXC_GPIO_IO26 = 30,
	IMX93_IOMUXC_GPIO_IO27 = 31,
	IMX93_IOMUXC_GPIO_IO28 = 32,
	IMX93_IOMUXC_GPIO_IO29 = 33,
	IMX93_IOMUXC_CCM_CLKO1 = 34,
	IMX93_IOMUXC_CCM_CLKO2 = 35,
	IMX93_IOMUXC_CCM_CLKO3 = 36,
	IMX93_IOMUXC_CCM_CLKO4 = 37,
	IMX93_IOMUXC_ENET1_MDC = 38,
	IMX93_IOMUXC_ENET1_MDIO = 39,
	IMX93_IOMUXC_ENET1_TD3 = 40,
	IMX93_IOMUXC_ENET1_TD2 = 41,
	IMX93_IOMUXC_ENET1_TD1 = 42,
	IMX93_IOMUXC_ENET1_TD0 = 43,
	IMX93_IOMUXC_ENET1_TX_CTL = 44,
	IMX93_IOMUXC_ENET1_TXC = 45,
	IMX93_IOMUXC_ENET1_RX_CTL = 46,
	IMX93_IOMUXC_ENET1_RXC = 47,
	IMX93_IOMUXC_ENET1_RD0 = 48,
	IMX93_IOMUXC_ENET1_RD1 = 49,
	IMX93_IOMUXC_ENET1_RD2 = 50,
	IMX93_IOMUXC_ENET1_RD3 = 51,
	IMX93_IOMUXC_ENET2_MDC = 52,
	IMX93_IOMUXC_ENET2_MDIO = 53,
	IMX93_IOMUXC_ENET2_TD3 = 54,
	IMX93_IOMUXC_ENET2_TD2 = 55,
	IMX93_IOMUXC_ENET2_TD1 = 56,
	IMX93_IOMUXC_ENET2_TD0 = 57,
	IMX93_IOMUXC_ENET2_TX_CTL = 58,
	IMX93_IOMUXC_ENET2_TXC = 59,
	IMX93_IOMUXC_ENET2_RX_CTL = 60,
	IMX93_IOMUXC_ENET2_RXC = 61,
	IMX93_IOMUXC_ENET2_RD0 = 62,
	IMX93_IOMUXC_ENET2_RD1 = 63,
	IMX93_IOMUXC_ENET2_RD2 = 64,
	IMX93_IOMUXC_ENET2_RD3 = 65,
	IMX93_IOMUXC_SD1_CLK = 66,
	IMX93_IOMUXC_SD1_CMD = 67,
	IMX93_IOMUXC_SD1_DATA0 = 68,
	IMX93_IOMUXC_SD1_DATA1 = 69,
	IMX93_IOMUXC_SD1_DATA2 = 70,
	IMX93_IOMUXC_SD1_DATA3 = 71,
	IMX93_IOMUXC_SD1_DATA4 = 72,
	IMX93_IOMUXC_SD1_DATA5 = 73,
	IMX93_IOMUXC_SD1_DATA6 = 74,
	IMX93_IOMUXC_SD1_DATA7 = 75,
	IMX93_IOMUXC_SD1_STROBE = 76,
	IMX93_IOMUXC_SD2_VSELECT = 77,
	IMX93_IOMUXC_SD3_CLK = 78,
	IMX93_IOMUXC_SD3_CMD = 79,
	IMX93_IOMUXC_SD3_DATA0 = 80,
	IMX93_IOMUXC_SD3_DATA1 = 81,
	IMX93_IOMUXC_SD3_DATA2 = 82,
	IMX93_IOMUXC_SD3_DATA3 = 83,
	IMX93_IOMUXC_SD2_CD_B = 84,
	IMX93_IOMUXC_SD2_CLK = 85,
	IMX93_IOMUXC_SD2_CMD = 86,
	IMX93_IOMUXC_SD2_DATA0 = 87,
	IMX93_IOMUXC_SD2_DATA1 = 88,
	IMX93_IOMUXC_SD2_DATA2 = 89,
	IMX93_IOMUXC_SD2_DATA3 = 90,
	IMX93_IOMUXC_SD2_RESET_B = 91,
	IMX93_IOMUXC_I2C1_SCL = 92,
	IMX93_IOMUXC_I2C1_SDA = 93,
	IMX93_IOMUXC_I2C2_SCL = 94,
	IMX93_IOMUXC_I2C2_SDA = 95,
	IMX93_IOMUXC_UART1_RXD = 96,
	IMX93_IOMUXC_UART1_TXD = 97,
	IMX93_IOMUXC_UART2_RXD = 98,
	IMX93_IOMUXC_UART2_TXD = 99,
	IMX93_IOMUXC_PDM_CLK = 100,
	IMX93_IOMUXC_PDM_BIT_STREAM0 = 101,
	IMX93_IOMUXC_PDM_BIT_STREAM1 = 102,
	IMX93_IOMUXC_SAI1_TXFS = 103,
	IMX93_IOMUXC_SAI1_TXC = 104,
	IMX93_IOMUXC_SAI1_TXD0 = 105,
	IMX93_IOMUXC_SAI1_RXD0 = 106,
	IMX93_IOMUXC_WDOG_ANY = 107,
};

enum imx_misc_func {
	IMX_SC_MISC_FUNC_UNKNOWN = 0,
	IMX_SC_MISC_FUNC_SET_CONTROL = 1,
	IMX_SC_MISC_FUNC_GET_CONTROL = 2,
	IMX_SC_MISC_FUNC_SET_MAX_DMA_GROUP = 4,
	IMX_SC_MISC_FUNC_SET_DMA_GROUP = 5,
	IMX_SC_MISC_FUNC_SECO_IMAGE_LOAD = 8,
	IMX_SC_MISC_FUNC_SECO_AUTHENTICATE = 9,
	IMX_SC_MISC_FUNC_DEBUG_OUT = 10,
	IMX_SC_MISC_FUNC_WAVEFORM_CAPTURE = 6,
	IMX_SC_MISC_FUNC_BUILD_INFO = 15,
	IMX_SC_MISC_FUNC_UNIQUE_ID = 19,
	IMX_SC_MISC_FUNC_SET_ARI = 3,
	IMX_SC_MISC_FUNC_BOOT_STATUS = 7,
	IMX_SC_MISC_FUNC_BOOT_DONE = 14,
	IMX_SC_MISC_FUNC_OTP_FUSE_READ = 11,
	IMX_SC_MISC_FUNC_OTP_FUSE_WRITE = 17,
	IMX_SC_MISC_FUNC_SET_TEMP = 12,
	IMX_SC_MISC_FUNC_GET_TEMP = 13,
	IMX_SC_MISC_FUNC_GET_BOOT_DEV = 16,
	IMX_SC_MISC_FUNC_GET_BUTTON_STATUS = 18,
};

enum imx_pcie_variants {
	IMX6Q = 0,
	IMX6SX = 1,
	IMX6QP = 2,
	IMX7D = 3,
	IMX8MQ = 4,
	IMX8MM___2 = 5,
	IMX8MP___2 = 6,
	IMX8Q = 7,
	IMX95 = 8,
	IMX8MQ_EP = 9,
	IMX8MM_EP = 10,
	IMX8MP_EP = 11,
	IMX95_EP = 12,
};

enum imx_pfdv2_type {
	IMX_PFDV2_IMX7ULP = 0,
	IMX_PFDV2_IMX8ULP = 1,
};

enum imx_pll14xx_type {
	PLL_1416X = 0,
	PLL_1443X = 1,
};

enum imx_pllv1_type {
	IMX_PLLV1_IMX1 = 0,
	IMX_PLLV1_IMX21 = 1,
	IMX_PLLV1_IMX25 = 2,
	IMX_PLLV1_IMX27 = 3,
	IMX_PLLV1_IMX31 = 4,
	IMX_PLLV1_IMX35 = 5,
};

enum imx_pllv3_type {
	IMX_PLLV3_GENERIC = 0,
	IMX_PLLV3_SYS = 1,
	IMX_PLLV3_USB = 2,
	IMX_PLLV3_USB_VF610 = 3,
	IMX_PLLV3_AV = 4,
	IMX_PLLV3_ENET = 5,
	IMX_PLLV3_ENET_IMX7 = 6,
	IMX_PLLV3_SYS_VF610 = 7,
	IMX_PLLV3_DDR_IMX7 = 8,
	IMX_PLLV3_AV_IMX7 = 9,
};

enum imx_pllv4_type {
	IMX_PLLV4_IMX7ULP = 0,
	IMX_PLLV4_IMX8ULP = 1,
	IMX_PLLV4_IMX8ULP_1GHZ = 2,
};

enum imx_sc_error_codes {
	IMX_SC_ERR_NONE = 0,
	IMX_SC_ERR_VERSION = 1,
	IMX_SC_ERR_CONFIG = 2,
	IMX_SC_ERR_PARM = 3,
	IMX_SC_ERR_NOACCESS = 4,
	IMX_SC_ERR_LOCKED = 5,
	IMX_SC_ERR_UNAVAILABLE = 6,
	IMX_SC_ERR_NOTFOUND = 7,
	IMX_SC_ERR_NOPOWER = 8,
	IMX_SC_ERR_IPC = 9,
	IMX_SC_ERR_BUSY = 10,
	IMX_SC_ERR_FAIL = 11,
	IMX_SC_ERR_LAST = 12,
};

enum imx_sc_pm_func {
	IMX_SC_PM_FUNC_UNKNOWN = 0,
	IMX_SC_PM_FUNC_SET_SYS_POWER_MODE = 19,
	IMX_SC_PM_FUNC_SET_PARTITION_POWER_MODE = 1,
	IMX_SC_PM_FUNC_GET_SYS_POWER_MODE = 2,
	IMX_SC_PM_FUNC_SET_RESOURCE_POWER_MODE = 3,
	IMX_SC_PM_FUNC_GET_RESOURCE_POWER_MODE = 4,
	IMX_SC_PM_FUNC_REQ_LOW_POWER_MODE = 16,
	IMX_SC_PM_FUNC_SET_CPU_RESUME_ADDR = 17,
	IMX_SC_PM_FUNC_REQ_SYS_IF_POWER_MODE = 18,
	IMX_SC_PM_FUNC_SET_CLOCK_RATE = 5,
	IMX_SC_PM_FUNC_GET_CLOCK_RATE = 6,
	IMX_SC_PM_FUNC_CLOCK_ENABLE = 7,
	IMX_SC_PM_FUNC_SET_CLOCK_PARENT = 14,
	IMX_SC_PM_FUNC_GET_CLOCK_PARENT = 15,
	IMX_SC_PM_FUNC_RESET = 13,
	IMX_SC_PM_FUNC_RESET_REASON = 10,
	IMX_SC_PM_FUNC_BOOT = 8,
	IMX_SC_PM_FUNC_REBOOT = 9,
	IMX_SC_PM_FUNC_REBOOT_PARTITION = 12,
	IMX_SC_PM_FUNC_CPU_START = 11,
};

enum imx_sc_rm_func {
	IMX_SC_RM_FUNC_UNKNOWN = 0,
	IMX_SC_RM_FUNC_PARTITION_ALLOC = 1,
	IMX_SC_RM_FUNC_SET_CONFIDENTIAL = 31,
	IMX_SC_RM_FUNC_PARTITION_FREE = 2,
	IMX_SC_RM_FUNC_GET_DID = 26,
	IMX_SC_RM_FUNC_PARTITION_STATIC = 3,
	IMX_SC_RM_FUNC_PARTITION_LOCK = 4,
	IMX_SC_RM_FUNC_GET_PARTITION = 5,
	IMX_SC_RM_FUNC_SET_PARENT = 6,
	IMX_SC_RM_FUNC_MOVE_ALL = 7,
	IMX_SC_RM_FUNC_ASSIGN_RESOURCE = 8,
	IMX_SC_RM_FUNC_SET_RESOURCE_MOVABLE = 9,
	IMX_SC_RM_FUNC_SET_SUBSYS_RSRC_MOVABLE = 28,
	IMX_SC_RM_FUNC_SET_MASTER_ATTRIBUTES = 10,
	IMX_SC_RM_FUNC_SET_MASTER_SID = 11,
	IMX_SC_RM_FUNC_SET_PERIPHERAL_PERMISSIONS = 12,
	IMX_SC_RM_FUNC_IS_RESOURCE_OWNED = 13,
	IMX_SC_RM_FUNC_GET_RESOURCE_OWNER = 33,
	IMX_SC_RM_FUNC_IS_RESOURCE_MASTER = 14,
	IMX_SC_RM_FUNC_IS_RESOURCE_PERIPHERAL = 15,
	IMX_SC_RM_FUNC_GET_RESOURCE_INFO = 16,
	IMX_SC_RM_FUNC_MEMREG_ALLOC = 17,
	IMX_SC_RM_FUNC_MEMREG_SPLIT = 29,
	IMX_SC_RM_FUNC_MEMREG_FRAG = 32,
	IMX_SC_RM_FUNC_MEMREG_FREE = 18,
	IMX_SC_RM_FUNC_FIND_MEMREG = 30,
	IMX_SC_RM_FUNC_ASSIGN_MEMREG = 19,
	IMX_SC_RM_FUNC_SET_MEMREG_PERMISSIONS = 20,
	IMX_SC_RM_FUNC_IS_MEMREG_OWNED = 21,
	IMX_SC_RM_FUNC_GET_MEMREG_INFO = 22,
	IMX_SC_RM_FUNC_ASSIGN_PAD = 23,
	IMX_SC_RM_FUNC_SET_PAD_MOVABLE = 24,
	IMX_SC_RM_FUNC_IS_PAD_OWNED = 25,
	IMX_SC_RM_FUNC_DUMP = 27,
};

enum imx_sc_rpc_svc {
	IMX_SC_RPC_SVC_UNKNOWN = 0,
	IMX_SC_RPC_SVC_RETURN = 1,
	IMX_SC_RPC_SVC_PM = 2,
	IMX_SC_RPC_SVC_RM = 3,
	IMX_SC_RPC_SVC_TIMER = 5,
	IMX_SC_RPC_SVC_PAD = 6,
	IMX_SC_RPC_SVC_MISC = 7,
	IMX_SC_RPC_SVC_IRQ = 8,
};

enum imx_tx_state {
	OFF = 0,
	WAIT_AFTER_RTS = 1,
	SEND = 2,
	WAIT_AFTER_SEND = 3,
};

enum imx_uart_type {
	IMX1_UART = 0,
	IMX21_UART = 1,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inode_state {
	inode_state_no_change = 0,
	inode_state_will_create = 1,
	inode_state_did_create = 2,
	inode_state_will_delete = 3,
	inode_state_did_delete = 4,
};

enum inplace_mode {
	OUT_OF_PLACE = 0,
	INPLACE_ONE_SGLIST = 1,
	INPLACE_TWO_SGLISTS = 2,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum insn_emulation_mode {
	INSN_UNDEF = 0,
	INSN_EMULATE = 1,
	INSN_HW = 2,
};

enum integrity_status {
	INTEGRITY_PASS = 0,
	INTEGRITY_PASS_IMMUTABLE = 1,
	INTEGRITY_FAIL = 2,
	INTEGRITY_FAIL_IMMUTABLE = 3,
	INTEGRITY_NOLABEL = 4,
	INTEGRITY_NOXATTRS = 5,
	INTEGRITY_UNKNOWN = 6,
};

enum io_pgtable_caps {
	IO_PGTABLE_CAP_CUSTOM_ALLOCATOR = 1,
};

enum io_pgtable_fmt {
	ARM_32_LPAE_S1 = 0,
	ARM_32_LPAE_S2 = 1,
	ARM_64_LPAE_S1 = 2,
	ARM_64_LPAE_S2 = 3,
	ARM_V7S = 4,
	ARM_MALI_LPAE = 5,
	AMD_IOMMU_V1 = 6,
	AMD_IOMMU_V2 = 7,
	APPLE_DART = 8,
	APPLE_DART2 = 9,
	IO_PGTABLE_NUM_FMTS = 10,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_LAST = 58,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_LAST = 31,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum ioctrl_regs {
	POCCTRL = 0,
	TDSELCTRL = 1,
};

enum iodev_type {
	IODEV_CPUIF = 0,
	IODEV_DIST = 1,
	IODEV_REDIST = 2,
	IODEV_ITS = 3,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

enum iommu_dma_cookie_type {
	IOMMU_DMA_IOVA_COOKIE = 0,
	IOMMU_DMA_MSI_COOKIE = 1,
};

enum iommu_dma_queue_type {
	IOMMU_DMA_OPTS_PER_CPU_QUEUE = 0,
	IOMMU_DMA_OPTS_SINGLE_QUEUE = 1,
};

enum iommu_fault_type {
	IOMMU_FAULT_PAGE_REQ = 1,
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipe_action_type {
	IPE_ACTION_ALLOW = 0,
	IPE_ACTION_DENY = 1,
	__IPE_ACTION_MAX = 2,
};

enum ipe_hook_type {
	IPE_HOOK_BPRM_CHECK = 0,
	IPE_HOOK_MMAP = 1,
	IPE_HOOK_MPROTECT = 2,
	IPE_HOOK_KERNEL_READ = 3,
	IPE_HOOK_KERNEL_LOAD = 4,
	__IPE_HOOK_MAX = 5,
};

enum ipe_match {
	IPE_MATCH_RULE = 0,
	IPE_MATCH_TABLE = 1,
	IPE_MATCH_GLOBAL = 2,
	__IPE_MATCH_MAX = 3,
};

enum ipe_op_type {
	IPE_OP_EXEC = 0,
	IPE_OP_FIRMWARE = 1,
	IPE_OP_KERNEL_MODULE = 2,
	IPE_OP_KEXEC_IMAGE = 3,
	IPE_OP_KEXEC_INITRAMFS = 4,
	IPE_OP_POLICY = 5,
	IPE_OP_X509 = 6,
	__IPE_OP_MAX = 7,
};

enum ipe_prop_type {
	IPE_PROP_BOOT_VERIFIED_FALSE = 0,
	IPE_PROP_BOOT_VERIFIED_TRUE = 1,
	IPE_PROP_DMV_ROOTHASH = 2,
	IPE_PROP_DMV_SIG_FALSE = 3,
	IPE_PROP_DMV_SIG_TRUE = 4,
	IPE_PROP_FSV_DIGEST = 5,
	IPE_PROP_FSV_SIG_FALSE = 6,
	IPE_PROP_FSV_SIG_TRUE = 7,
	__IPE_PROP_MAX = 8,
};

enum ipi_msg_type {
	IPI_RESCHEDULE = 0,
	IPI_CALL_FUNC = 1,
	IPI_CPU_STOP = 2,
	IPI_CPU_STOP_NMI = 3,
	IPI_TIMER = 4,
	IPI_IRQ_WORK = 5,
	NR_IPI = 6,
	IPI_CPU_BACKTRACE = 6,
	IPI_KGDB_ROUNDUP = 7,
	MAX_IPI = 8,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum it_action {
	IT_NEXT = 0,
	IT_COMPLETE = 1,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum its_vcpu_info_cmd_type {
	MAP_VLPI = 0,
	GET_VLPI = 1,
	PROP_UPDATE_VLPI = 2,
	PROP_UPDATE_AND_INV_VLPI = 3,
	SCHEDULE_VPE = 4,
	DESCHEDULE_VPE = 5,
	COMMIT_VPE = 6,
	INVALL_VPE = 7,
	PROP_UPDATE_VSGI = 8,
};

enum j721e_pcie_mode {
	PCI_MODE_RC = 0,
	PCI_MODE_EP = 1,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum k3_ring_mode {
	K3_RINGACC_RING_MODE_RING = 0,
	K3_RINGACC_RING_MODE_MESSAGE = 1,
	K3_RINGACC_RING_MODE_CREDENTIALS = 2,
	K3_RINGACC_RING_MODE_INVALID = 3,
};

enum k3_ring_size {
	K3_RINGACC_RING_ELSIZE_4 = 0,
	K3_RINGACC_RING_ELSIZE_8 = 1,
	K3_RINGACC_RING_ELSIZE_16 = 2,
	K3_RINGACC_RING_ELSIZE_32 = 3,
	K3_RINGACC_RING_ELSIZE_64 = 4,
	K3_RINGACC_RING_ELSIZE_128 = 5,
	K3_RINGACC_RING_ELSIZE_256 = 6,
	K3_RINGACC_RING_ELSIZE_INVALID = 7,
};

enum k3_ringacc_access_mode {
	K3_RINGACC_ACCESS_MODE_PUSH_HEAD = 0,
	K3_RINGACC_ACCESS_MODE_POP_HEAD = 1,
	K3_RINGACC_ACCESS_MODE_PUSH_TAIL = 2,
	K3_RINGACC_ACCESS_MODE_POP_TAIL = 3,
	K3_RINGACC_ACCESS_MODE_PEEK_HEAD = 4,
	K3_RINGACC_ACCESS_MODE_PEEK_TAIL = 5,
};

enum k3_ringacc_proxy_access_mode {
	PROXY_ACCESS_MODE_HEAD = 0,
	PROXY_ACCESS_MODE_TAIL = 1,
	PROXY_ACCESS_MODE_PEEK_HEAD = 2,
	PROXY_ACCESS_MODE_PEEK_TAIL = 3,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfence_counter_id {
	KFENCE_COUNTER_ALLOCATED = 0,
	KFENCE_COUNTER_ALLOCS = 1,
	KFENCE_COUNTER_FREES = 2,
	KFENCE_COUNTER_ZOMBIES = 3,
	KFENCE_COUNTER_BUGS = 4,
	KFENCE_COUNTER_SKIP_INCOMPAT = 5,
	KFENCE_COUNTER_SKIP_CAPACITY = 6,
	KFENCE_COUNTER_SKIP_COVERED = 7,
	KFENCE_COUNTER_COUNT = 8,
};

enum kfence_error_type {
	KFENCE_ERROR_OOB = 0,
	KFENCE_ERROR_UAF = 1,
	KFENCE_ERROR_CORRUPTION = 2,
	KFENCE_ERROR_INVALID = 3,
	KFENCE_ERROR_INVALID_FREE = 4,
};

enum kfence_object_state {
	KFENCE_OBJECT_UNUSED = 0,
	KFENCE_OBJECT_ALLOCATED = 1,
	KFENCE_OBJECT_RCU_FREEING = 2,
	KFENCE_OBJECT_FREED = 3,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
};

enum kgdb_bpstate {
	BP_UNDEFINED = 0,
	BP_REMOVED = 1,
	BP_SET = 2,
	BP_ACTIVE = 3,
};

enum kgdb_bptype {
	BP_BREAKPOINT = 0,
	BP_HARDWARE_BREAKPOINT = 1,
	BP_WRITE_WATCHPOINT = 2,
	BP_READ_WATCHPOINT = 3,
	BP_ACCESS_WATCHPOINT = 4,
	BP_POKE_BREAKPOINT = 5,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 15,
	KMALLOC_RECLAIM = 16,
	KMALLOC_DMA = 17,
	KMALLOC_CGROUP = 18,
	NR_KMALLOC_TYPES = 19,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kunit_speed {
	KUNIT_SPEED_UNSET = 0,
	KUNIT_SPEED_VERY_SLOW = 1,
	KUNIT_SPEED_SLOW = 2,
	KUNIT_SPEED_NORMAL = 3,
	KUNIT_SPEED_MAX = 3,
};

enum kunit_status {
	KUNIT_SUCCESS = 0,
	KUNIT_FAILURE = 1,
	KUNIT_SKIPPED = 2,
};

enum kvm_arch_timer_regs {
	TIMER_REG_CNT = 0,
	TIMER_REG_CVAL = 1,
	TIMER_REG_TVAL = 2,
	TIMER_REG_CTL = 3,
	TIMER_REG_VOFF = 4,
};

enum kvm_arch_timers {
	TIMER_PTIMER = 0,
	TIMER_VTIMER = 1,
	NR_KVM_EL0_TIMERS = 2,
	TIMER_HVTIMER = 2,
	TIMER_HPTIMER = 3,
	NR_KVM_TIMERS = 4,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_NR_BUSES = 4,
};

enum kvm_device_type {
	KVM_DEV_TYPE_FSL_MPIC_20 = 1,
	KVM_DEV_TYPE_FSL_MPIC_42 = 2,
	KVM_DEV_TYPE_XICS = 3,
	KVM_DEV_TYPE_VFIO = 4,
	KVM_DEV_TYPE_ARM_VGIC_V2 = 5,
	KVM_DEV_TYPE_FLIC = 6,
	KVM_DEV_TYPE_ARM_VGIC_V3 = 7,
	KVM_DEV_TYPE_ARM_VGIC_ITS = 8,
	KVM_DEV_TYPE_XIVE = 9,
	KVM_DEV_TYPE_ARM_PV_TIME = 10,
	KVM_DEV_TYPE_RISCV_AIA = 11,
	KVM_DEV_TYPE_MAX = 12,
};

enum kvm_mode {
	KVM_MODE_DEFAULT = 0,
	KVM_MODE_PROTECTED = 1,
	KVM_MODE_NV = 2,
	KVM_MODE_NONE = 3,
};

enum kvm_mr_change {
	KVM_MR_CREATE = 0,
	KVM_MR_DELETE = 1,
	KVM_MR_MOVE = 2,
	KVM_MR_FLAGS_ONLY = 3,
};

enum kvm_pgtable_prot {
	KVM_PGTABLE_PROT_X = 1ULL,
	KVM_PGTABLE_PROT_W = 2ULL,
	KVM_PGTABLE_PROT_R = 4ULL,
	KVM_PGTABLE_PROT_DEVICE = 8ULL,
	KVM_PGTABLE_PROT_NORMAL_NC = 16ULL,
	KVM_PGTABLE_PROT_SW0 = 36028797018963968ULL,
	KVM_PGTABLE_PROT_SW1 = 72057594037927936ULL,
	KVM_PGTABLE_PROT_SW2 = 144115188075855872ULL,
	KVM_PGTABLE_PROT_SW3 = 288230376151711744ULL,
};

enum kvm_pgtable_stage2_flags {
	KVM_PGTABLE_S2_NOFWB = 1,
	KVM_PGTABLE_S2_IDMAP = 2,
};

enum kvm_pgtable_walk_flags {
	KVM_PGTABLE_WALK_LEAF = 1,
	KVM_PGTABLE_WALK_TABLE_PRE = 2,
	KVM_PGTABLE_WALK_TABLE_POST = 4,
	KVM_PGTABLE_WALK_SHARED = 8,
	KVM_PGTABLE_WALK_HANDLE_FAULT = 16,
	KVM_PGTABLE_WALK_SKIP_BBM_TLBI = 32,
	KVM_PGTABLE_WALK_SKIP_CMO = 64,
};

enum kvm_smccc_filter_action {
	KVM_SMCCC_FILTER_HANDLE = 0,
	KVM_SMCCC_FILTER_DENY = 1,
	KVM_SMCCC_FILTER_FWD_TO_USER = 2,
	NR_SMCCC_FILTER_ACTIONS = 3,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum kvm_wfx_trap_policy {
	KVM_WFX_NOTRAP_SINGLE_TASK = 0,
	KVM_WFX_NOTRAP = 1,
	KVM_WFX_TRAP = 2,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum label_initialized {
	LABEL_INVALID = 0,
	LABEL_INITIALIZED = 1,
	LABEL_PENDING = 2,
};

enum landlock_key_type {
	LANDLOCK_KEY_INODE = 1,
	LANDLOCK_KEY_NET_PORT = 2,
};

enum landlock_rule_type {
	LANDLOCK_RULE_PATH_BENEATH = 1,
	LANDLOCK_RULE_NET_PORT = 2,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum legacy_insn_status {
	INSN_DEPRECATED = 0,
	INSN_OBSOLETE = 1,
	INSN_UNAVAILABLE = 2,
};

enum link_status {
	NO_RECEIVERS_DETECTED = 0,
	LINK_TRAINING_IN_PROGRESS = 1,
	LINK_UP_DL_IN_PROGRESS = 2,
	LINK_UP_DL_COMPLETED = 3,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_MPCAPABLEACTIVEDROP = 7,
	MPTCP_MIB_MPCAPABLEACTIVEDISABLED = 8,
	MPTCP_MIB_MPCAPABLEENDPATTEMPT = 9,
	MPTCP_MIB_TOKENFALLBACKINIT = 10,
	MPTCP_MIB_RETRANSSEGS = 11,
	MPTCP_MIB_JOINNOTOKEN = 12,
	MPTCP_MIB_JOINSYNRX = 13,
	MPTCP_MIB_JOINSYNBACKUPRX = 14,
	MPTCP_MIB_JOINSYNACKRX = 15,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 16,
	MPTCP_MIB_JOINSYNACKMAC = 17,
	MPTCP_MIB_JOINACKRX = 18,
	MPTCP_MIB_JOINACKMAC = 19,
	MPTCP_MIB_JOINSYNTX = 20,
	MPTCP_MIB_JOINSYNTXCREATSKERR = 21,
	MPTCP_MIB_JOINSYNTXBINDERR = 22,
	MPTCP_MIB_JOINSYNTXCONNECTERR = 23,
	MPTCP_MIB_DSSNOMATCH = 24,
	MPTCP_MIB_DSSCORRUPTIONFALLBACK = 25,
	MPTCP_MIB_DSSCORRUPTIONRESET = 26,
	MPTCP_MIB_INFINITEMAPTX = 27,
	MPTCP_MIB_INFINITEMAPRX = 28,
	MPTCP_MIB_DSSTCPMISMATCH = 29,
	MPTCP_MIB_DATACSUMERR = 30,
	MPTCP_MIB_OFOQUEUETAIL = 31,
	MPTCP_MIB_OFOQUEUE = 32,
	MPTCP_MIB_OFOMERGE = 33,
	MPTCP_MIB_NODSSWINDOW = 34,
	MPTCP_MIB_DUPDATA = 35,
	MPTCP_MIB_ADDADDR = 36,
	MPTCP_MIB_ADDADDRTX = 37,
	MPTCP_MIB_ADDADDRTXDROP = 38,
	MPTCP_MIB_ECHOADD = 39,
	MPTCP_MIB_ECHOADDTX = 40,
	MPTCP_MIB_ECHOADDTXDROP = 41,
	MPTCP_MIB_PORTADD = 42,
	MPTCP_MIB_ADDADDRDROP = 43,
	MPTCP_MIB_JOINPORTSYNRX = 44,
	MPTCP_MIB_JOINPORTSYNACKRX = 45,
	MPTCP_MIB_JOINPORTACKRX = 46,
	MPTCP_MIB_MISMATCHPORTSYNRX = 47,
	MPTCP_MIB_MISMATCHPORTACKRX = 48,
	MPTCP_MIB_RMADDR = 49,
	MPTCP_MIB_RMADDRDROP = 50,
	MPTCP_MIB_RMADDRTX = 51,
	MPTCP_MIB_RMADDRTXDROP = 52,
	MPTCP_MIB_RMSUBFLOW = 53,
	MPTCP_MIB_MPPRIOTX = 54,
	MPTCP_MIB_MPPRIORX = 55,
	MPTCP_MIB_MPFAILTX = 56,
	MPTCP_MIB_MPFAILRX = 57,
	MPTCP_MIB_MPFASTCLOSETX = 58,
	MPTCP_MIB_MPFASTCLOSERX = 59,
	MPTCP_MIB_MPRSTTX = 60,
	MPTCP_MIB_MPRSTRX = 61,
	MPTCP_MIB_RCVPRUNED = 62,
	MPTCP_MIB_SUBFLOWSTALE = 63,
	MPTCP_MIB_SUBFLOWRECOVER = 64,
	MPTCP_MIB_SNDWNDSHARED = 65,
	MPTCP_MIB_RCVWNDSHARED = 66,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 67,
	MPTCP_MIB_RCVWNDCONFLICT = 68,
	MPTCP_MIB_CURRESTAB = 69,
	MPTCP_MIB_BLACKHOLE = 70,
	__MPTCP_MIB_MAX = 71,
};

enum locality_types {
	WRITE_LATENCY = 0,
	READ_LATENCY = 1,
	WRITE_BANDWIDTH = 2,
	READ_BANDWIDTH = 3,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum lpuart_type {
	VF610_LPUART = 0,
	LS1021A_LPUART = 1,
	LS1028A_LPUART = 2,
	IMX7ULP_LPUART = 3,
	IMX8ULP_LPUART = 4,
	IMX8QXP_LPUART = 5,
	IMXRT1050_LPUART = 6,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lsm_rule_types {
	LSM_OBJ_USER = 0,
	LSM_OBJ_ROLE = 1,
	LSM_OBJ_TYPE = 2,
	LSM_SUBJ_USER = 3,
	LSM_SUBJ_ROLE = 4,
	LSM_SUBJ_TYPE = 5,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum m1_pmu_events {
	M1_PMU_PERFCTR_RETIRE_UOP = 1,
	M1_PMU_PERFCTR_CORE_ACTIVE_CYCLE = 2,
	M1_PMU_PERFCTR_L1I_TLB_FILL = 4,
	M1_PMU_PERFCTR_L1D_TLB_FILL = 5,
	M1_PMU_PERFCTR_MMU_TABLE_WALK_INSTRUCTION = 7,
	M1_PMU_PERFCTR_MMU_TABLE_WALK_DATA = 8,
	M1_PMU_PERFCTR_L2_TLB_MISS_INSTRUCTION = 10,
	M1_PMU_PERFCTR_L2_TLB_MISS_DATA = 11,
	M1_PMU_PERFCTR_MMU_VIRTUAL_MEMORY_FAULT_NONSPEC = 13,
	M1_PMU_PERFCTR_SCHEDULE_UOP = 82,
	M1_PMU_PERFCTR_INTERRUPT_PENDING = 108,
	M1_PMU_PERFCTR_MAP_STALL_DISPATCH = 112,
	M1_PMU_PERFCTR_MAP_REWIND = 117,
	M1_PMU_PERFCTR_MAP_STALL = 118,
	M1_PMU_PERFCTR_MAP_INT_UOP = 124,
	M1_PMU_PERFCTR_MAP_LDST_UOP = 125,
	M1_PMU_PERFCTR_MAP_SIMD_UOP = 126,
	M1_PMU_PERFCTR_FLUSH_RESTART_OTHER_NONSPEC = 132,
	M1_PMU_PERFCTR_INST_ALL = 140,
	M1_PMU_PERFCTR_INST_BRANCH = 141,
	M1_PMU_PERFCTR_INST_BRANCH_CALL = 142,
	M1_PMU_PERFCTR_INST_BRANCH_RET = 143,
	M1_PMU_PERFCTR_INST_BRANCH_TAKEN = 144,
	M1_PMU_PERFCTR_INST_BRANCH_INDIR = 147,
	M1_PMU_PERFCTR_INST_BRANCH_COND = 148,
	M1_PMU_PERFCTR_INST_INT_LD = 149,
	M1_PMU_PERFCTR_INST_INT_ST = 150,
	M1_PMU_PERFCTR_INST_INT_ALU = 151,
	M1_PMU_PERFCTR_INST_SIMD_LD = 152,
	M1_PMU_PERFCTR_INST_SIMD_ST = 153,
	M1_PMU_PERFCTR_INST_SIMD_ALU = 154,
	M1_PMU_PERFCTR_INST_LDST = 155,
	M1_PMU_PERFCTR_INST_BARRIER = 156,
	M1_PMU_PERFCTR_UNKNOWN_9f = 159,
	M1_PMU_PERFCTR_L1D_TLB_ACCESS = 160,
	M1_PMU_PERFCTR_L1D_TLB_MISS = 161,
	M1_PMU_PERFCTR_L1D_CACHE_MISS_ST = 162,
	M1_PMU_PERFCTR_L1D_CACHE_MISS_LD = 163,
	M1_PMU_PERFCTR_LD_UNIT_UOP = 166,
	M1_PMU_PERFCTR_ST_UNIT_UOP = 167,
	M1_PMU_PERFCTR_L1D_CACHE_WRITEBACK = 168,
	M1_PMU_PERFCTR_LDST_X64_UOP = 177,
	M1_PMU_PERFCTR_LDST_XPG_UOP = 178,
	M1_PMU_PERFCTR_ATOMIC_OR_EXCLUSIVE_SUCC = 179,
	M1_PMU_PERFCTR_ATOMIC_OR_EXCLUSIVE_FAIL = 180,
	M1_PMU_PERFCTR_L1D_CACHE_MISS_LD_NONSPEC = 191,
	M1_PMU_PERFCTR_L1D_CACHE_MISS_ST_NONSPEC = 192,
	M1_PMU_PERFCTR_L1D_TLB_MISS_NONSPEC = 193,
	M1_PMU_PERFCTR_ST_MEMORY_ORDER_VIOLATION_NONSPEC = 196,
	M1_PMU_PERFCTR_BRANCH_COND_MISPRED_NONSPEC = 197,
	M1_PMU_PERFCTR_BRANCH_INDIR_MISPRED_NONSPEC = 198,
	M1_PMU_PERFCTR_BRANCH_RET_INDIR_MISPRED_NONSPEC = 200,
	M1_PMU_PERFCTR_BRANCH_CALL_INDIR_MISPRED_NONSPEC = 202,
	M1_PMU_PERFCTR_BRANCH_MISPRED_NONSPEC = 203,
	M1_PMU_PERFCTR_L1I_TLB_MISS_DEMAND = 212,
	M1_PMU_PERFCTR_MAP_DISPATCH_BUBBLE = 214,
	M1_PMU_PERFCTR_L1I_CACHE_MISS_DEMAND = 219,
	M1_PMU_PERFCTR_FETCH_RESTART = 222,
	M1_PMU_PERFCTR_ST_NT_UOP = 229,
	M1_PMU_PERFCTR_LD_NT_UOP = 230,
	M1_PMU_PERFCTR_UNKNOWN_f5 = 245,
	M1_PMU_PERFCTR_UNKNOWN_f6 = 246,
	M1_PMU_PERFCTR_UNKNOWN_f7 = 247,
	M1_PMU_PERFCTR_UNKNOWN_f8 = 248,
	M1_PMU_PERFCTR_UNKNOWN_fd = 253,
	M1_PMU_PERFCTR_LAST = 255,
	M1_PMU_CFG_COUNT_USER = 256,
	M1_PMU_CFG_COUNT_KERNEL = 512,
};

enum macsec_offload {
	MACSEC_OFFLOAD_OFF = 0,
	MACSEC_OFFLOAD_PHY = 1,
	MACSEC_OFFLOAD_MAC = 2,
	__MACSEC_OFFLOAD_END = 3,
	MACSEC_OFFLOAD_MAX = 2,
};

enum macsec_validation_type {
	MACSEC_VALIDATE_DISABLED = 0,
	MACSEC_VALIDATE_CHECK = 1,
	MACSEC_VALIDATE_STRICT = 2,
	__MACSEC_VALIDATE_END = 3,
	MACSEC_VALIDATE_MAX = 2,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
};

enum max77620_alternate_pinmux_option {
	MAX77620_PINMUX_GPIO = 0,
	MAX77620_PINMUX_LOW_POWER_MODE_CONTROL_IN = 1,
	MAX77620_PINMUX_FLEXIBLE_POWER_SEQUENCER_OUT = 2,
	MAX77620_PINMUX_32K_OUT1 = 3,
	MAX77620_PINMUX_SD0_DYNAMIC_VOLTAGE_SCALING_IN = 4,
	MAX77620_PINMUX_SD1_DYNAMIC_VOLTAGE_SCALING_IN = 5,
	MAX77620_PINMUX_REFERENCE_OUT = 6,
};

enum max77620_chip_id {
	MAX77620 = 0,
	MAX20024 = 1,
	MAX77663 = 2,
};

enum max77620_fps_src {
	MAX77620_FPS_SRC_0 = 0,
	MAX77620_FPS_SRC_1 = 1,
	MAX77620_FPS_SRC_2 = 2,
	MAX77620_FPS_SRC_NONE = 3,
	MAX77620_FPS_SRC_DEF = 4,
};

enum max77620_pin_ppdrv {
	MAX77620_PIN_UNCONFIG_DRV = 0,
	MAX77620_PIN_OD_DRV = 1,
	MAX77620_PIN_PP_DRV = 2,
};

enum max77620_regulator_type {
	MAX77620_REGULATOR_TYPE_SD = 0,
	MAX77620_REGULATOR_TYPE_LDO_N = 1,
	MAX77620_REGULATOR_TYPE_LDO_P = 2,
};

enum max77620_regulators {
	MAX77620_REGULATOR_ID_SD0 = 0,
	MAX77620_REGULATOR_ID_SD1 = 1,
	MAX77620_REGULATOR_ID_SD2 = 2,
	MAX77620_REGULATOR_ID_SD3 = 3,
	MAX77620_REGULATOR_ID_SD4 = 4,
	MAX77620_REGULATOR_ID_LDO0 = 5,
	MAX77620_REGULATOR_ID_LDO1 = 6,
	MAX77620_REGULATOR_ID_LDO2 = 7,
	MAX77620_REGULATOR_ID_LDO3 = 8,
	MAX77620_REGULATOR_ID_LDO4 = 9,
	MAX77620_REGULATOR_ID_LDO5 = 10,
	MAX77620_REGULATOR_ID_LDO6 = 11,
	MAX77620_REGULATOR_ID_LDO7 = 12,
	MAX77620_REGULATOR_ID_LDO8 = 13,
	MAX77620_NUM_REGS = 14,
};

enum max77686_chip_name {
	CHIP_MAX77686 = 0,
	CHIP_MAX77802 = 1,
	CHIP_MAX77620 = 2,
};

enum max77686_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	RTC_INT = 2,
	MAX77686_IRQ_GROUP_NR = 3,
};

enum max77686_pmic_reg {
	MAX77686_REG_DEVICE_ID = 0,
	MAX77686_REG_INTSRC = 1,
	MAX77686_REG_INT1 = 2,
	MAX77686_REG_INT2 = 3,
	MAX77686_REG_INT1MSK = 4,
	MAX77686_REG_INT2MSK = 5,
	MAX77686_REG_STATUS1 = 6,
	MAX77686_REG_STATUS2 = 7,
	MAX77686_REG_PWRON = 8,
	MAX77686_REG_ONOFF_DELAY = 9,
	MAX77686_REG_MRSTB = 10,
	MAX77686_REG_BUCK1CTRL = 16,
	MAX77686_REG_BUCK1OUT = 17,
	MAX77686_REG_BUCK2CTRL1 = 18,
	MAX77686_REG_BUCK234FREQ = 19,
	MAX77686_REG_BUCK2DVS1 = 20,
	MAX77686_REG_BUCK2DVS2 = 21,
	MAX77686_REG_BUCK2DVS3 = 22,
	MAX77686_REG_BUCK2DVS4 = 23,
	MAX77686_REG_BUCK2DVS5 = 24,
	MAX77686_REG_BUCK2DVS6 = 25,
	MAX77686_REG_BUCK2DVS7 = 26,
	MAX77686_REG_BUCK2DVS8 = 27,
	MAX77686_REG_BUCK3CTRL1 = 28,
	MAX77686_REG_BUCK3DVS1 = 30,
	MAX77686_REG_BUCK3DVS2 = 31,
	MAX77686_REG_BUCK3DVS3 = 32,
	MAX77686_REG_BUCK3DVS4 = 33,
	MAX77686_REG_BUCK3DVS5 = 34,
	MAX77686_REG_BUCK3DVS6 = 35,
	MAX77686_REG_BUCK3DVS7 = 36,
	MAX77686_REG_BUCK3DVS8 = 37,
	MAX77686_REG_BUCK4CTRL1 = 38,
	MAX77686_REG_BUCK4DVS1 = 40,
	MAX77686_REG_BUCK4DVS2 = 41,
	MAX77686_REG_BUCK4DVS3 = 42,
	MAX77686_REG_BUCK4DVS4 = 43,
	MAX77686_REG_BUCK4DVS5 = 44,
	MAX77686_REG_BUCK4DVS6 = 45,
	MAX77686_REG_BUCK4DVS7 = 46,
	MAX77686_REG_BUCK4DVS8 = 47,
	MAX77686_REG_BUCK5CTRL = 48,
	MAX77686_REG_BUCK5OUT = 49,
	MAX77686_REG_BUCK6CTRL = 50,
	MAX77686_REG_BUCK6OUT = 51,
	MAX77686_REG_BUCK7CTRL = 52,
	MAX77686_REG_BUCK7OUT = 53,
	MAX77686_REG_BUCK8CTRL = 54,
	MAX77686_REG_BUCK8OUT = 55,
	MAX77686_REG_BUCK9CTRL = 56,
	MAX77686_REG_BUCK9OUT = 57,
	MAX77686_REG_LDO1CTRL1 = 64,
	MAX77686_REG_LDO2CTRL1 = 65,
	MAX77686_REG_LDO3CTRL1 = 66,
	MAX77686_REG_LDO4CTRL1 = 67,
	MAX77686_REG_LDO5CTRL1 = 68,
	MAX77686_REG_LDO6CTRL1 = 69,
	MAX77686_REG_LDO7CTRL1 = 70,
	MAX77686_REG_LDO8CTRL1 = 71,
	MAX77686_REG_LDO9CTRL1 = 72,
	MAX77686_REG_LDO10CTRL1 = 73,
	MAX77686_REG_LDO11CTRL1 = 74,
	MAX77686_REG_LDO12CTRL1 = 75,
	MAX77686_REG_LDO13CTRL1 = 76,
	MAX77686_REG_LDO14CTRL1 = 77,
	MAX77686_REG_LDO15CTRL1 = 78,
	MAX77686_REG_LDO16CTRL1 = 79,
	MAX77686_REG_LDO17CTRL1 = 80,
	MAX77686_REG_LDO18CTRL1 = 81,
	MAX77686_REG_LDO19CTRL1 = 82,
	MAX77686_REG_LDO20CTRL1 = 83,
	MAX77686_REG_LDO21CTRL1 = 84,
	MAX77686_REG_LDO22CTRL1 = 85,
	MAX77686_REG_LDO23CTRL1 = 86,
	MAX77686_REG_LDO24CTRL1 = 87,
	MAX77686_REG_LDO25CTRL1 = 88,
	MAX77686_REG_LDO26CTRL1 = 89,
	MAX77686_REG_LDO1CTRL2 = 96,
	MAX77686_REG_LDO2CTRL2 = 97,
	MAX77686_REG_LDO3CTRL2 = 98,
	MAX77686_REG_LDO4CTRL2 = 99,
	MAX77686_REG_LDO5CTRL2 = 100,
	MAX77686_REG_LDO6CTRL2 = 101,
	MAX77686_REG_LDO7CTRL2 = 102,
	MAX77686_REG_LDO8CTRL2 = 103,
	MAX77686_REG_LDO9CTRL2 = 104,
	MAX77686_REG_LDO10CTRL2 = 105,
	MAX77686_REG_LDO11CTRL2 = 106,
	MAX77686_REG_LDO12CTRL2 = 107,
	MAX77686_REG_LDO13CTRL2 = 108,
	MAX77686_REG_LDO14CTRL2 = 109,
	MAX77686_REG_LDO15CTRL2 = 110,
	MAX77686_REG_LDO16CTRL2 = 111,
	MAX77686_REG_LDO17CTRL2 = 112,
	MAX77686_REG_LDO18CTRL2 = 113,
	MAX77686_REG_LDO19CTRL2 = 114,
	MAX77686_REG_LDO20CTRL2 = 115,
	MAX77686_REG_LDO21CTRL2 = 116,
	MAX77686_REG_LDO22CTRL2 = 117,
	MAX77686_REG_LDO23CTRL2 = 118,
	MAX77686_REG_LDO24CTRL2 = 119,
	MAX77686_REG_LDO25CTRL2 = 120,
	MAX77686_REG_LDO26CTRL2 = 121,
	MAX77686_REG_BBAT_CHG = 126,
	MAX77686_REG_32KHZ = 127,
	MAX77686_REG_PMIC_END = 128,
};

enum max77686_types {
	TYPE_MAX77686 = 0,
	TYPE_MAX77802 = 1,
};

enum max77802_pmic_reg {
	MAX77802_REG_DEVICE_ID = 0,
	MAX77802_REG_INTSRC = 1,
	MAX77802_REG_INT1 = 2,
	MAX77802_REG_INT2 = 3,
	MAX77802_REG_INT1MSK = 4,
	MAX77802_REG_INT2MSK = 5,
	MAX77802_REG_STATUS1 = 6,
	MAX77802_REG_STATUS2 = 7,
	MAX77802_REG_PWRON = 8,
	MAX77802_REG_MRSTB = 10,
	MAX77802_REG_EPWRHOLD = 11,
	MAX77802_REG_BOOSTCTRL = 14,
	MAX77802_REG_BOOSTOUT = 15,
	MAX77802_REG_BUCK1CTRL = 16,
	MAX77802_REG_BUCK1DVS1 = 17,
	MAX77802_REG_BUCK1DVS2 = 18,
	MAX77802_REG_BUCK1DVS3 = 19,
	MAX77802_REG_BUCK1DVS4 = 20,
	MAX77802_REG_BUCK1DVS5 = 21,
	MAX77802_REG_BUCK1DVS6 = 22,
	MAX77802_REG_BUCK1DVS7 = 23,
	MAX77802_REG_BUCK1DVS8 = 24,
	MAX77802_REG_BUCK2CTRL1 = 26,
	MAX77802_REG_BUCK2CTRL2 = 27,
	MAX77802_REG_BUCK2PHTRAN = 28,
	MAX77802_REG_BUCK2DVS1 = 29,
	MAX77802_REG_BUCK2DVS2 = 30,
	MAX77802_REG_BUCK2DVS3 = 31,
	MAX77802_REG_BUCK2DVS4 = 32,
	MAX77802_REG_BUCK2DVS5 = 33,
	MAX77802_REG_BUCK2DVS6 = 34,
	MAX77802_REG_BUCK2DVS7 = 35,
	MAX77802_REG_BUCK2DVS8 = 36,
	MAX77802_REG_BUCK3CTRL1 = 39,
	MAX77802_REG_BUCK3DVS1 = 40,
	MAX77802_REG_BUCK3DVS2 = 41,
	MAX77802_REG_BUCK3DVS3 = 42,
	MAX77802_REG_BUCK3DVS4 = 43,
	MAX77802_REG_BUCK3DVS5 = 44,
	MAX77802_REG_BUCK3DVS6 = 45,
	MAX77802_REG_BUCK3DVS7 = 46,
	MAX77802_REG_BUCK3DVS8 = 47,
	MAX77802_REG_BUCK4CTRL1 = 55,
	MAX77802_REG_BUCK4DVS1 = 56,
	MAX77802_REG_BUCK4DVS2 = 57,
	MAX77802_REG_BUCK4DVS3 = 58,
	MAX77802_REG_BUCK4DVS4 = 59,
	MAX77802_REG_BUCK4DVS5 = 60,
	MAX77802_REG_BUCK4DVS6 = 61,
	MAX77802_REG_BUCK4DVS7 = 62,
	MAX77802_REG_BUCK4DVS8 = 63,
	MAX77802_REG_BUCK5CTRL = 65,
	MAX77802_REG_BUCK5OUT = 66,
	MAX77802_REG_BUCK6CTRL = 68,
	MAX77802_REG_BUCK6DVS1 = 69,
	MAX77802_REG_BUCK6DVS2 = 70,
	MAX77802_REG_BUCK6DVS3 = 71,
	MAX77802_REG_BUCK6DVS4 = 72,
	MAX77802_REG_BUCK6DVS5 = 73,
	MAX77802_REG_BUCK6DVS6 = 74,
	MAX77802_REG_BUCK6DVS7 = 75,
	MAX77802_REG_BUCK6DVS8 = 76,
	MAX77802_REG_BUCK7CTRL = 78,
	MAX77802_REG_BUCK7OUT = 79,
	MAX77802_REG_BUCK8CTRL = 81,
	MAX77802_REG_BUCK8OUT = 82,
	MAX77802_REG_BUCK9CTRL = 84,
	MAX77802_REG_BUCK9OUT = 85,
	MAX77802_REG_BUCK10CTRL = 87,
	MAX77802_REG_BUCK10OUT = 88,
	MAX77802_REG_LDO1CTRL1 = 96,
	MAX77802_REG_LDO2CTRL1 = 97,
	MAX77802_REG_LDO3CTRL1 = 98,
	MAX77802_REG_LDO4CTRL1 = 99,
	MAX77802_REG_LDO5CTRL1 = 100,
	MAX77802_REG_LDO6CTRL1 = 101,
	MAX77802_REG_LDO7CTRL1 = 102,
	MAX77802_REG_LDO8CTRL1 = 103,
	MAX77802_REG_LDO9CTRL1 = 104,
	MAX77802_REG_LDO10CTRL1 = 105,
	MAX77802_REG_LDO11CTRL1 = 106,
	MAX77802_REG_LDO12CTRL1 = 107,
	MAX77802_REG_LDO13CTRL1 = 108,
	MAX77802_REG_LDO14CTRL1 = 109,
	MAX77802_REG_LDO15CTRL1 = 110,
	MAX77802_REG_LDO17CTRL1 = 112,
	MAX77802_REG_LDO18CTRL1 = 113,
	MAX77802_REG_LDO19CTRL1 = 114,
	MAX77802_REG_LDO20CTRL1 = 115,
	MAX77802_REG_LDO21CTRL1 = 116,
	MAX77802_REG_LDO22CTRL1 = 117,
	MAX77802_REG_LDO23CTRL1 = 118,
	MAX77802_REG_LDO24CTRL1 = 119,
	MAX77802_REG_LDO25CTRL1 = 120,
	MAX77802_REG_LDO26CTRL1 = 121,
	MAX77802_REG_LDO27CTRL1 = 122,
	MAX77802_REG_LDO28CTRL1 = 123,
	MAX77802_REG_LDO29CTRL1 = 124,
	MAX77802_REG_LDO30CTRL1 = 125,
	MAX77802_REG_LDO32CTRL1 = 127,
	MAX77802_REG_LDO33CTRL1 = 128,
	MAX77802_REG_LDO34CTRL1 = 129,
	MAX77802_REG_LDO35CTRL1 = 130,
	MAX77802_REG_LDO1CTRL2 = 144,
	MAX77802_REG_LDO2CTRL2 = 145,
	MAX77802_REG_LDO3CTRL2 = 146,
	MAX77802_REG_LDO4CTRL2 = 147,
	MAX77802_REG_LDO5CTRL2 = 148,
	MAX77802_REG_LDO6CTRL2 = 149,
	MAX77802_REG_LDO7CTRL2 = 150,
	MAX77802_REG_LDO8CTRL2 = 151,
	MAX77802_REG_LDO9CTRL2 = 152,
	MAX77802_REG_LDO10CTRL2 = 153,
	MAX77802_REG_LDO11CTRL2 = 154,
	MAX77802_REG_LDO12CTRL2 = 155,
	MAX77802_REG_LDO13CTRL2 = 156,
	MAX77802_REG_LDO14CTRL2 = 157,
	MAX77802_REG_LDO15CTRL2 = 158,
	MAX77802_REG_LDO17CTRL2 = 160,
	MAX77802_REG_LDO18CTRL2 = 161,
	MAX77802_REG_LDO19CTRL2 = 162,
	MAX77802_REG_LDO20CTRL2 = 163,
	MAX77802_REG_LDO21CTRL2 = 164,
	MAX77802_REG_LDO22CTRL2 = 165,
	MAX77802_REG_LDO23CTRL2 = 166,
	MAX77802_REG_LDO24CTRL2 = 167,
	MAX77802_REG_LDO25CTRL2 = 168,
	MAX77802_REG_LDO26CTRL2 = 169,
	MAX77802_REG_LDO27CTRL2 = 170,
	MAX77802_REG_LDO28CTRL2 = 171,
	MAX77802_REG_LDO29CTRL2 = 172,
	MAX77802_REG_LDO30CTRL2 = 173,
	MAX77802_REG_LDO32CTRL2 = 175,
	MAX77802_REG_LDO33CTRL2 = 176,
	MAX77802_REG_LDO34CTRL2 = 177,
	MAX77802_REG_LDO35CTRL2 = 178,
	MAX77802_REG_BBAT_CHG = 180,
	MAX77802_REG_32KHZ = 181,
	MAX77802_REG_PMIC_END = 182,
};

enum max77802_rtc_reg {
	MAX77802_RTC_INT = 192,
	MAX77802_RTC_INTM = 193,
	MAX77802_RTC_CONTROLM = 194,
	MAX77802_RTC_CONTROL = 195,
	MAX77802_RTC_UPDATE0 = 196,
	MAX77802_RTC_UPDATE1 = 197,
	MAX77802_WTSR_SMPL_CNTL = 198,
	MAX77802_RTC_SEC = 199,
	MAX77802_RTC_MIN = 200,
	MAX77802_RTC_HOUR = 201,
	MAX77802_RTC_WEEKDAY = 202,
	MAX77802_RTC_MONTH = 203,
	MAX77802_RTC_YEAR = 204,
	MAX77802_RTC_MONTHDAY = 205,
	MAX77802_RTC_AE1 = 206,
	MAX77802_ALARM1_SEC = 207,
	MAX77802_ALARM1_MIN = 208,
	MAX77802_ALARM1_HOUR = 209,
	MAX77802_ALARM1_WEEKDAY = 210,
	MAX77802_ALARM1_MONTH = 211,
	MAX77802_ALARM1_YEAR = 212,
	MAX77802_ALARM1_DATE = 213,
	MAX77802_RTC_AE2 = 214,
	MAX77802_ALARM2_SEC = 215,
	MAX77802_ALARM2_MIN = 216,
	MAX77802_ALARM2_HOUR = 217,
	MAX77802_ALARM2_WEEKDAY = 218,
	MAX77802_ALARM2_MONTH = 219,
	MAX77802_ALARM2_YEAR = 220,
	MAX77802_ALARM2_DATE = 221,
	MAX77802_RTC_END = 223,
};

enum mc_cmd_status {
	MC_CMD_STATUS_OK = 0,
	MC_CMD_STATUS_READY = 1,
	MC_CMD_STATUS_AUTH_ERR = 3,
	MC_CMD_STATUS_NO_PRIVILEGE = 4,
	MC_CMD_STATUS_DMA_ERR = 5,
	MC_CMD_STATUS_CONFIG_ERR = 6,
	MC_CMD_STATUS_TIMEOUT = 7,
	MC_CMD_STATUS_NO_RESOURCE = 8,
	MC_CMD_STATUS_NO_MEMORY = 9,
	MC_CMD_STATUS_BUSY = 10,
	MC_CMD_STATUS_UNSUPPORTED_OP = 11,
	MC_CMD_STATUS_INVALID_STATE = 12,
};

enum mc_target_type {
	MC_TARGET_NONE = 0,
	MC_TARGET_PAGE = 1,
	MC_TARGET_SWAP = 2,
	MC_TARGET_DEVICE = 3,
};

enum mctp_neigh_source {
	MCTP_NEIGH_STATIC = 0,
	MCTP_NEIGH_DISCOVER = 1,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum md_ro_state {
	MD_RDWR = 0,
	MD_RDONLY = 1,
	MD_AUTO_READ = 2,
	MD_MAX_STATE = 3,
};

enum mddev_flags {
	MD_ARRAY_FIRST_USE = 0,
	MD_CLOSING = 1,
	MD_JOURNAL_CLEAN = 2,
	MD_HAS_JOURNAL = 3,
	MD_CLUSTER_RESYNC_LOCKED = 4,
	MD_FAILFAST_SUPPORTED = 5,
	MD_HAS_PPL = 6,
	MD_HAS_MULTIPLE_PPLS = 7,
	MD_NOT_READY = 8,
	MD_BROKEN = 9,
	MD_DELETED = 10,
};

enum mddev_sb_flags {
	MD_SB_CHANGE_DEVS = 0,
	MD_SB_CHANGE_CLEAN = 1,
	MD_SB_CHANGE_PENDING = 2,
	MD_SB_NEED_REWRITE = 3,
};

enum mem_cgroup_events_target {
	MEM_CGROUP_TARGET_THRESH = 0,
	MEM_CGROUP_TARGET_SOFTLIMIT = 1,
	MEM_CGROUP_NTARGETS = 2,
};

enum mem_type {
	MEM_EMPTY = 0,
	MEM_RESERVED = 1,
	MEM_UNKNOWN = 2,
	MEM_FPM = 3,
	MEM_EDO = 4,
	MEM_BEDO = 5,
	MEM_SDR = 6,
	MEM_RDR = 7,
	MEM_DDR = 8,
	MEM_RDDR = 9,
	MEM_RMBS = 10,
	MEM_DDR2 = 11,
	MEM_FB_DDR2 = 12,
	MEM_RDDR2 = 13,
	MEM_XDR = 14,
	MEM_DDR3 = 15,
	MEM_RDDR3 = 16,
	MEM_LRDDR3 = 17,
	MEM_LPDDR3 = 18,
	MEM_DDR4 = 19,
	MEM_RDDR4 = 20,
	MEM_LRDDR4 = 21,
	MEM_LPDDR4 = 22,
	MEM_DDR5 = 23,
	MEM_RDDR5 = 24,
	MEM_LRDDR5 = 25,
	MEM_NVDIMM = 26,
	MEM_WIO2 = 27,
	MEM_HBM2 = 28,
	MEM_HBM3 = 29,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 47,
	MEMCG_SOCK = 48,
	MEMCG_PERCPU_B = 49,
	MEMCG_VMALLOC = 50,
	MEMCG_KMEM = 51,
	MEMCG_ZSWAP_B = 52,
	MEMCG_ZSWAPPED = 53,
	MEMCG_NR_STAT = 54,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum meson_pinconf_drv {
	MESON_PINCONF_DRV_500UA = 0,
	MESON_PINCONF_DRV_2500UA = 1,
	MESON_PINCONF_DRV_3000UA = 2,
	MESON_PINCONF_DRV_4000UA = 3,
};

enum meson_reg_type {
	MESON_REG_PULLEN = 0,
	MESON_REG_PULL = 1,
	MESON_REG_DIR = 2,
	MESON_REG_OUT = 3,
	MESON_REG_IN = 4,
	MESON_REG_DS = 5,
	MESON_NUM_REG = 6,
};

enum meson_soc_id {
	MESON_SOC_G12A = 0,
	MESON_SOC_A1 = 1,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_DIFFERENT_COMPOUND = 2,
	MF_MSG_HUGE = 3,
	MF_MSG_FREE_HUGE = 4,
	MF_MSG_GET_HWPOISON = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_ALREADY_POISONED = 19,
	MF_MSG_UNKNOWN = 20,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migrate_vma_direction {
	MIGRATE_VMA_SELECT_SYSTEM = 1,
	MIGRATE_VMA_SELECT_DEVICE_PRIVATE = 2,
	MIGRATE_VMA_SELECT_DEVICE_COHERENT = 4,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum misc_res_type {
	MISC_CG_RES_TYPES = 0,
};

enum mitigation_state {
	SPECTRE_UNAFFECTED = 0,
	SPECTRE_MITIGATED = 1,
	SPECTRE_VULNERABLE = 2,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum mode_set_atomic {
	LEAVE_ATOMIC_MODE_SET = 0,
	ENTER_ATOMIC_MODE_SET = 1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum motionsense_command {
	MOTIONSENSE_CMD_DUMP = 0,
	MOTIONSENSE_CMD_INFO = 1,
	MOTIONSENSE_CMD_EC_RATE = 2,
	MOTIONSENSE_CMD_SENSOR_ODR = 3,
	MOTIONSENSE_CMD_SENSOR_RANGE = 4,
	MOTIONSENSE_CMD_KB_WAKE_ANGLE = 5,
	MOTIONSENSE_CMD_DATA = 6,
	MOTIONSENSE_CMD_FIFO_INFO = 7,
	MOTIONSENSE_CMD_FIFO_FLUSH = 8,
	MOTIONSENSE_CMD_FIFO_READ = 9,
	MOTIONSENSE_CMD_PERFORM_CALIB = 10,
	MOTIONSENSE_CMD_SENSOR_OFFSET = 11,
	MOTIONSENSE_CMD_LIST_ACTIVITIES = 12,
	MOTIONSENSE_CMD_SET_ACTIVITY = 13,
	MOTIONSENSE_CMD_LID_ANGLE = 14,
	MOTIONSENSE_CMD_FIFO_INT_ENABLE = 15,
	MOTIONSENSE_CMD_SPOOF = 16,
	MOTIONSENSE_CMD_TABLET_MODE_LID_ANGLE = 17,
	MOTIONSENSE_CMD_SENSOR_SCALE = 18,
	MOTIONSENSE_NUM_CMDS = 19,
};

enum mousedev_emul {
	MOUSEDEV_EMUL_PS2 = 0,
	MOUSEDEV_EMUL_IMPS = 1,
	MOUSEDEV_EMUL_EXPS = 2,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mrq_bwmgr_int_cmd {
	CMD_BWMGR_INT_QUERY_ABI = 1,
	CMD_BWMGR_INT_CALC_AND_SET = 2,
	CMD_BWMGR_INT_CAP_SET = 3,
};

enum mrq_debug_commands {
	CMD_DEBUG_OPEN_RO = 0,
	CMD_DEBUG_OPEN_WO = 1,
	CMD_DEBUG_READ = 2,
	CMD_DEBUG_WRITE = 3,
	CMD_DEBUG_CLOSE = 4,
	CMD_DEBUG_MAX = 5,
};

enum mrq_debugfs_commands {
	CMD_DEBUGFS_READ = 1,
	CMD_DEBUGFS_WRITE = 2,
	CMD_DEBUGFS_DUMPDIR = 3,
	CMD_DEBUGFS_MAX = 4,
};

enum mrq_pg_cmd {
	CMD_PG_QUERY_ABI = 0,
	CMD_PG_SET_STATE = 1,
	CMD_PG_GET_STATE = 2,
	CMD_PG_GET_NAME = 3,
	CMD_PG_GET_MAX_ID = 4,
};

enum mrq_reset_commands {
	CMD_RESET_ASSERT = 1,
	CMD_RESET_DEASSERT = 2,
	CMD_RESET_MODULE = 3,
	CMD_RESET_GET_MAX_ID = 4,
	CMD_RESET_MAX = 5,
};

enum mscode_actions {
	ACT_mscode_note_content_type = 0,
	ACT_mscode_note_digest = 1,
	ACT_mscode_note_digest_algo = 2,
	NR__mscode_actions = 3,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION___3 = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_SWPOUT = 3,
	MTHP_STAT_SWPOUT_FALLBACK = 4,
	MTHP_STAT_SHMEM_ALLOC = 5,
	MTHP_STAT_SHMEM_FALLBACK = 6,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 7,
	MTHP_STAT_SPLIT = 8,
	MTHP_STAT_SPLIT_FAILED = 9,
	MTHP_STAT_SPLIT_DEFERRED = 10,
	MTHP_STAT_NR_ANON = 11,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 12,
	__MTHP_STAT_COUNT = 13,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum mv_xor_mode {
	XOR_MODE_IN_REG = 0,
	XOR_MODE_IN_DESC = 1,
};

enum mv_xor_type {
	XOR_ORION = 0,
	XOR_ARMADA_38X = 1,
	XOR_ARMADA_37XX = 2,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum ncsi_nl_attrs {
	NCSI_ATTR_UNSPEC = 0,
	NCSI_ATTR_IFINDEX = 1,
	NCSI_ATTR_PACKAGE_LIST = 2,
	NCSI_ATTR_PACKAGE_ID = 3,
	NCSI_ATTR_CHANNEL_ID = 4,
	NCSI_ATTR_DATA = 5,
	NCSI_ATTR_MULTI_FLAG = 6,
	NCSI_ATTR_PACKAGE_MASK = 7,
	NCSI_ATTR_CHANNEL_MASK = 8,
	__NCSI_ATTR_AFTER_LAST = 9,
	NCSI_ATTR_MAX = 8,
};

enum ncsi_nl_channel_attrs {
	NCSI_CHANNEL_ATTR_UNSPEC = 0,
	NCSI_CHANNEL_ATTR = 1,
	NCSI_CHANNEL_ATTR_ID = 2,
	NCSI_CHANNEL_ATTR_VERSION_MAJOR = 3,
	NCSI_CHANNEL_ATTR_VERSION_MINOR = 4,
	NCSI_CHANNEL_ATTR_VERSION_STR = 5,
	NCSI_CHANNEL_ATTR_LINK_STATE = 6,
	NCSI_CHANNEL_ATTR_ACTIVE = 7,
	NCSI_CHANNEL_ATTR_FORCED = 8,
	NCSI_CHANNEL_ATTR_VLAN_LIST = 9,
	NCSI_CHANNEL_ATTR_VLAN_ID = 10,
	__NCSI_CHANNEL_ATTR_AFTER_LAST = 11,
	NCSI_CHANNEL_ATTR_MAX = 10,
};

enum ncsi_nl_commands {
	NCSI_CMD_UNSPEC = 0,
	NCSI_CMD_PKG_INFO = 1,
	NCSI_CMD_SET_INTERFACE = 2,
	NCSI_CMD_CLEAR_INTERFACE = 3,
	NCSI_CMD_SEND_CMD = 4,
	NCSI_CMD_SET_PACKAGE_MASK = 5,
	NCSI_CMD_SET_CHANNEL_MASK = 6,
	__NCSI_CMD_AFTER_LAST = 7,
	NCSI_CMD_MAX = 6,
};

enum ncsi_nl_pkg_attrs {
	NCSI_PKG_ATTR_UNSPEC = 0,
	NCSI_PKG_ATTR = 1,
	NCSI_PKG_ATTR_ID = 2,
	NCSI_PKG_ATTR_FORCED = 3,
	NCSI_PKG_ATTR_CHANNEL_LIST = 4,
	__NCSI_PKG_ATTR_AFTER_LAST = 5,
	NCSI_PKG_ATTR_MAX = 4,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_dm_alert_mode {
	NET_DM_ALERT_MODE_SUMMARY = 0,
	NET_DM_ALERT_MODE_PACKET = 1,
};

enum net_dm_attr {
	NET_DM_ATTR_UNSPEC = 0,
	NET_DM_ATTR_ALERT_MODE = 1,
	NET_DM_ATTR_PC = 2,
	NET_DM_ATTR_SYMBOL = 3,
	NET_DM_ATTR_IN_PORT = 4,
	NET_DM_ATTR_TIMESTAMP = 5,
	NET_DM_ATTR_PROTO = 6,
	NET_DM_ATTR_PAYLOAD = 7,
	NET_DM_ATTR_PAD = 8,
	NET_DM_ATTR_TRUNC_LEN = 9,
	NET_DM_ATTR_ORIG_LEN = 10,
	NET_DM_ATTR_QUEUE_LEN = 11,
	NET_DM_ATTR_STATS = 12,
	NET_DM_ATTR_HW_STATS = 13,
	NET_DM_ATTR_ORIGIN = 14,
	NET_DM_ATTR_HW_TRAP_GROUP_NAME = 15,
	NET_DM_ATTR_HW_TRAP_NAME = 16,
	NET_DM_ATTR_HW_ENTRIES = 17,
	NET_DM_ATTR_HW_ENTRY = 18,
	NET_DM_ATTR_HW_TRAP_COUNT = 19,
	NET_DM_ATTR_SW_DROPS = 20,
	NET_DM_ATTR_HW_DROPS = 21,
	NET_DM_ATTR_FLOW_ACTION_COOKIE = 22,
	NET_DM_ATTR_REASON = 23,
	__NET_DM_ATTR_MAX = 24,
	NET_DM_ATTR_MAX = 23,
};

enum net_dm_origin {
	NET_DM_ORIGIN_SW = 0,
	NET_DM_ORIGIN_HW = 1,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netkit_action {
	NETKIT_NEXT = -1,
	NETKIT_PASS = 0,
	NETKIT_DROP = 2,
	NETKIT_REDIRECT = 7,
};

enum netkit_mode {
	NETKIT_L2 = 0,
	NETKIT_L3 = 1,
};

enum netkit_scrub {
	NETKIT_SCRUB_NONE = 0,
	NETKIT_SCRUB_DEFAULT = 1,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum new_flag {
	NF_FRESH = 0,
	NF_READ = 1,
	NF_GET = 2,
	NF_PREFETCH = 3,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_TSTAMP = 5,
	NF_CT_EXT_LABELS = 6,
	NF_CT_EXT_SYNPROXY = 7,
	NF_CT_EXT_ACT_CT = 8,
	NF_CT_EXT_NUM = 9,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip6_hook_priorities {
	NF_IP6_PRI_FIRST = -2147483648,
	NF_IP6_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP6_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP6_PRI_RAW = -300,
	NF_IP6_PRI_SELINUX_FIRST = -225,
	NF_IP6_PRI_CONNTRACK = -200,
	NF_IP6_PRI_MANGLE = -150,
	NF_IP6_PRI_NAT_DST = -100,
	NF_IP6_PRI_FILTER = 0,
	NF_IP6_PRI_SECURITY = 50,
	NF_IP6_PRI_NAT_SRC = 100,
	NF_IP6_PRI_SELINUX_LAST = 225,
	NF_IP6_PRI_CONNTRACK_HELPER = 300,
	NF_IP6_PRI_LAST = 2147483647,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nhi_fw_mode {
	NHI_FW_SAFE_MODE = 0,
	NHI_FW_AUTH_MODE = 1,
	NHI_FW_EP_MODE = 2,
	NHI_FW_CM_MODE = 3,
};

enum nhi_mailbox_cmd {
	NHI_MAILBOX_SAVE_DEVS = 5,
	NHI_MAILBOX_DISCONNECT_PCIE_PATHS = 6,
	NHI_MAILBOX_DRV_UNLOADS = 7,
	NHI_MAILBOX_DISCONNECT_PA = 16,
	NHI_MAILBOX_DISCONNECT_PB = 17,
	NHI_MAILBOX_ALLOW_ALL_DEVS = 35,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_ext_feature_index {
	NL80211_EXT_FEATURE_VHT_IBSS = 0,
	NL80211_EXT_FEATURE_RRM = 1,
	NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER = 2,
	NL80211_EXT_FEATURE_SCAN_START_TIME = 3,
	NL80211_EXT_FEATURE_BSS_PARENT_TSF = 4,
	NL80211_EXT_FEATURE_SET_SCAN_DWELL = 5,
	NL80211_EXT_FEATURE_BEACON_RATE_LEGACY = 6,
	NL80211_EXT_FEATURE_BEACON_RATE_HT = 7,
	NL80211_EXT_FEATURE_BEACON_RATE_VHT = 8,
	NL80211_EXT_FEATURE_FILS_STA = 9,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA = 10,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED = 11,
	NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI = 12,
	NL80211_EXT_FEATURE_CQM_RSSI_LIST = 13,
	NL80211_EXT_FEATURE_FILS_SK_OFFLOAD = 14,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK = 15,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X = 16,
	NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME = 17,
	NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP = 18,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE = 19,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 20,
	NL80211_EXT_FEATURE_MFP_OPTIONAL = 21,
	NL80211_EXT_FEATURE_LOW_SPAN_SCAN = 22,
	NL80211_EXT_FEATURE_LOW_POWER_SCAN = 23,
	NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN = 24,
	NL80211_EXT_FEATURE_DFS_OFFLOAD = 25,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211 = 26,
	NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_TXQS = 28,
	NL80211_EXT_FEATURE_SCAN_RANDOM_SN = 29,
	NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT = 30,
	NL80211_EXT_FEATURE_CAN_REPLACE_PTK0 = 31,
	NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER = 32,
	NL80211_EXT_FEATURE_AIRTIME_FAIRNESS = 33,
	NL80211_EXT_FEATURE_AP_PMKSA_CACHING = 34,
	NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD = 35,
	NL80211_EXT_FEATURE_EXT_KEY_ID = 36,
	NL80211_EXT_FEATURE_STA_TX_PWR = 37,
	NL80211_EXT_FEATURE_SAE_OFFLOAD = 38,
	NL80211_EXT_FEATURE_VLAN_OFFLOAD = 39,
	NL80211_EXT_FEATURE_AQL = 40,
	NL80211_EXT_FEATURE_BEACON_PROTECTION = 41,
	NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH = 42,
	NL80211_EXT_FEATURE_PROTECTED_TWT = 43,
	NL80211_EXT_FEATURE_DEL_IBSS_STA = 44,
	NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS = 45,
	NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT = 46,
	NL80211_EXT_FEATURE_SCAN_FREQ_KHZ = 47,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS = 48,
	NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION = 49,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK = 50,
	NL80211_EXT_FEATURE_SAE_OFFLOAD_AP = 51,
	NL80211_EXT_FEATURE_FILS_DISCOVERY = 52,
	NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP = 53,
	NL80211_EXT_FEATURE_BEACON_RATE_HE = 54,
	NL80211_EXT_FEATURE_SECURE_LTF = 55,
	NL80211_EXT_FEATURE_SECURE_RTT = 56,
	NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE = 57,
	NL80211_EXT_FEATURE_BSS_COLOR = 58,
	NL80211_EXT_FEATURE_FILS_CRYPTO_OFFLOAD = 59,
	NL80211_EXT_FEATURE_RADAR_BACKGROUND = 60,
	NL80211_EXT_FEATURE_POWERED_ADDR_CHANGE = 61,
	NL80211_EXT_FEATURE_PUNCT = 62,
	NL80211_EXT_FEATURE_SECURE_NAN = 63,
	NL80211_EXT_FEATURE_AUTH_AND_DEAUTH_RANDOM_TA = 64,
	NL80211_EXT_FEATURE_OWE_OFFLOAD = 65,
	NL80211_EXT_FEATURE_OWE_OFFLOAD_AP = 66,
	NL80211_EXT_FEATURE_DFS_CONCURRENT = 67,
	NL80211_EXT_FEATURE_SPP_AMSDU_SUPPORT = 68,
	NUM_NL80211_EXT_FEATURES = 69,
	MAX_NL80211_EXT_FEATURES = 68,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_mntr_flags {
	__NL80211_MNTR_FLAG_INVALID = 0,
	NL80211_MNTR_FLAG_FCSFAIL = 1,
	NL80211_MNTR_FLAG_PLCPFAIL = 2,
	NL80211_MNTR_FLAG_CONTROL = 3,
	NL80211_MNTR_FLAG_OTHER_BSS = 4,
	NL80211_MNTR_FLAG_COOK_FRAMES = 5,
	NL80211_MNTR_FLAG_ACTIVE = 6,
	__NL80211_MNTR_FLAG_AFTER_LAST = 7,
	NL80211_MNTR_FLAG_MAX = 6,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl802154_cca_modes {
	__NL802154_CCA_INVALID = 0,
	NL802154_CCA_ENERGY = 1,
	NL802154_CCA_CARRIER = 2,
	NL802154_CCA_ENERGY_CARRIER = 3,
	NL802154_CCA_ALOHA = 4,
	NL802154_CCA_UWB_SHR = 5,
	NL802154_CCA_UWB_MULTIPLEXED = 6,
	__NL802154_CCA_ATTR_AFTER_LAST = 7,
	NL802154_CCA_ATTR_MAX = 6,
};

enum nl802154_cca_opts {
	NL802154_CCA_OPT_ENERGY_CARRIER_AND = 0,
	NL802154_CCA_OPT_ENERGY_CARRIER_OR = 1,
	__NL802154_CCA_OPT_ATTR_AFTER_LAST = 2,
	NL802154_CCA_OPT_ATTR_MAX = 1,
};

enum nl802154_supported_bool_states {
	NL802154_SUPPORTED_BOOL_FALSE = 0,
	NL802154_SUPPORTED_BOOL_TRUE = 1,
	__NL802154_SUPPORTED_BOOL_INVALD = 2,
	NL802154_SUPPORTED_BOOL_BOTH = 3,
	__NL802154_SUPPORTED_BOOL_AFTER_LAST = 4,
	NL802154_SUPPORTED_BOOL_MAX = 3,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGPROMOTE_SUCCESS = 42,
	PGPROMOTE_CANDIDATE = 43,
	PGDEMOTE_KSWAPD = 44,
	PGDEMOTE_DIRECT = 45,
	PGDEMOTE_KHUGEPAGED = 46,
	NR_VM_NODE_STAT_ITEMS = 47,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum of_overlay_notify_action {
	OF_OVERLAY_INIT = 0,
	OF_OVERLAY_PRE_APPLY = 1,
	OF_OVERLAY_POST_APPLY = 2,
	OF_OVERLAY_PRE_REMOVE = 3,
	OF_OVERLAY_POST_REMOVE = 4,
};

enum of_reconfig_change {
	OF_RECONFIG_NO_CHANGE = 0,
	OF_RECONFIG_CHANGE_ADD = 1,
	OF_RECONFIG_CHANGE_REMOVE = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opal_atom_width {
	OPAL_WIDTH_TINY = 0,
	OPAL_WIDTH_SHORT = 1,
	OPAL_WIDTH_MEDIUM = 2,
	OPAL_WIDTH_LONG = 3,
	OPAL_WIDTH_TOKEN = 4,
};

enum opal_key_type {
	OPAL_INCLUDED = 0,
	OPAL_KEYRING = 1,
};

enum opal_lock_flags {
	OPAL_SAVE_FOR_LOCK = 1,
};

enum opal_lock_state {
	OPAL_RO = 1,
	OPAL_RW = 2,
	OPAL_LK = 4,
};

enum opal_mbr {
	OPAL_MBR_ENABLE = 0,
	OPAL_MBR_DISABLE = 1,
};

enum opal_mbr_done_flag {
	OPAL_MBR_NOT_DONE = 0,
	OPAL_MBR_DONE = 1,
};

enum opal_method {
	OPAL_PROPERTIES = 0,
	OPAL_STARTSESSION = 1,
	OPAL_REVERT = 2,
	OPAL_ACTIVATE = 3,
	OPAL_EGET = 4,
	OPAL_ESET = 5,
	OPAL_NEXT = 6,
	OPAL_EAUTHENTICATE = 7,
	OPAL_GETACL = 8,
	OPAL_GENKEY = 9,
	OPAL_REVERTSP = 10,
	OPAL_GET = 11,
	OPAL_SET = 12,
	OPAL_AUTHENTICATE = 13,
	OPAL_RANDOM = 14,
	OPAL_ERASE = 15,
};

enum opal_parameter {
	OPAL_SUM_SET_LIST = 393216,
};

enum opal_response_token {
	OPAL_DTA_TOKENID_BYTESTRING = 224,
	OPAL_DTA_TOKENID_SINT = 225,
	OPAL_DTA_TOKENID_UINT = 226,
	OPAL_DTA_TOKENID_TOKEN = 227,
	OPAL_DTA_TOKENID_INVALID = 0,
};

enum opal_revert_lsp_opts {
	OPAL_PRESERVE = 1,
};

enum opal_revertlsp {
	OPAL_KEEP_GLOBAL_RANGE_KEY = 393216,
};

enum opal_table_ops {
	OPAL_READ_TABLE = 0,
	OPAL_WRITE_TABLE = 1,
};

enum opal_token {
	OPAL_TRUE = 1,
	OPAL_FALSE = 0,
	OPAL_BOOLEAN_EXPR = 3,
	OPAL_TABLE = 0,
	OPAL_STARTROW = 1,
	OPAL_ENDROW = 2,
	OPAL_STARTCOLUMN = 3,
	OPAL_ENDCOLUMN = 4,
	OPAL_VALUES = 1,
	OPAL_TABLE_UID = 0,
	OPAL_TABLE_NAME = 1,
	OPAL_TABLE_COMMON = 2,
	OPAL_TABLE_TEMPLATE = 3,
	OPAL_TABLE_KIND = 4,
	OPAL_TABLE_COLUMN = 5,
	OPAL_TABLE_COLUMNS = 6,
	OPAL_TABLE_ROWS = 7,
	OPAL_TABLE_ROWS_FREE = 8,
	OPAL_TABLE_ROW_BYTES = 9,
	OPAL_TABLE_LASTID = 10,
	OPAL_TABLE_MIN = 11,
	OPAL_TABLE_MAX = 12,
	OPAL_PIN = 3,
	OPAL_RANGESTART = 3,
	OPAL_RANGELENGTH = 4,
	OPAL_READLOCKENABLED = 5,
	OPAL_WRITELOCKENABLED = 6,
	OPAL_READLOCKED = 7,
	OPAL_WRITELOCKED = 8,
	OPAL_ACTIVEKEY = 10,
	OPAL_LIFECYCLE = 6,
	OPAL_MAXRANGES = 4,
	OPAL_MBRENABLE = 1,
	OPAL_MBRDONE = 2,
	OPAL_HOSTPROPERTIES = 0,
	OPAL_STARTLIST = 240,
	OPAL_ENDLIST = 241,
	OPAL_STARTNAME = 242,
	OPAL_ENDNAME = 243,
	OPAL_CALL = 248,
	OPAL_ENDOFDATA = 249,
	OPAL_ENDOFSESSION = 250,
	OPAL_STARTTRANSACTON = 251,
	OPAL_ENDTRANSACTON = 252,
	OPAL_EMPTYATOM = 255,
	OPAL_WHERE = 0,
};

enum opal_uid {
	OPAL_SMUID_UID = 0,
	OPAL_THISSP_UID = 1,
	OPAL_ADMINSP_UID = 2,
	OPAL_LOCKINGSP_UID = 3,
	OPAL_ENTERPRISE_LOCKINGSP_UID = 4,
	OPAL_ANYBODY_UID = 5,
	OPAL_SID_UID = 6,
	OPAL_ADMIN1_UID = 7,
	OPAL_USER1_UID = 8,
	OPAL_USER2_UID = 9,
	OPAL_PSID_UID = 10,
	OPAL_ENTERPRISE_BANDMASTER0_UID = 11,
	OPAL_ENTERPRISE_ERASEMASTER_UID = 12,
	OPAL_TABLE_TABLE = 13,
	OPAL_LOCKINGRANGE_GLOBAL = 14,
	OPAL_LOCKINGRANGE_ACE_START_TO_KEY = 15,
	OPAL_LOCKINGRANGE_ACE_RDLOCKED = 16,
	OPAL_LOCKINGRANGE_ACE_WRLOCKED = 17,
	OPAL_MBRCONTROL = 18,
	OPAL_MBR = 19,
	OPAL_AUTHORITY_TABLE = 20,
	OPAL_C_PIN_TABLE = 21,
	OPAL_LOCKING_INFO_TABLE = 22,
	OPAL_ENTERPRISE_LOCKING_INFO_TABLE = 23,
	OPAL_DATASTORE = 24,
	OPAL_C_PIN_MSID = 25,
	OPAL_C_PIN_SID = 26,
	OPAL_C_PIN_ADMIN1 = 27,
	OPAL_HALF_UID_AUTHORITY_OBJ_REF = 28,
	OPAL_HALF_UID_BOOLEAN_ACE = 29,
	OPAL_UID_HEXFF = 30,
};

enum opal_user {
	OPAL_ADMIN1 = 0,
	OPAL_USER1 = 1,
	OPAL_USER2 = 2,
	OPAL_USER3 = 3,
	OPAL_USER4 = 4,
	OPAL_USER5 = 5,
	OPAL_USER6 = 6,
	OPAL_USER7 = 7,
	OPAL_USER8 = 8,
	OPAL_USER9 = 9,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum osnoise_options_index {
	OSN_DEFAULTS = 0,
	OSN_WORKLOAD = 1,
	OSN_PANIC_ON_STOP = 2,
	OSN_PREEMPT_DISABLE = 3,
	OSN_IRQ_DISABLE = 4,
	OSN_MAX = 5,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum packing_op {
	PACK = 0,
	UNPACK = 1,
};

enum pad_func_e {
	IMX_SC_PAD_FUNC_SET = 15,
	IMX_SC_PAD_FUNC_GET = 16,
};

enum page_ext_flags {
	PAGE_EXT_OWNER = 0,
	PAGE_EXT_OWNER_ALLOCATED = 1,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_mlocked = 19,
	PG_hwpoison = 20,
	PG_young = 21,
	PG_idle = 22,
	PG_arch_2 = 23,
	PG_arch_3 = 24,
	__NR_PAGEFLAGS = 25,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 10,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESERVED = 2,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 1,
	PCI_P2PDMA_MAP_BUS_ADDR = 2,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 3,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_data_rate {
	PCIE_GEN1 = 0,
	PCIE_GEN2 = 1,
	PCIE_GEN3 = 2,
	PCIE_GEN4 = 3,
};

enum pcie_kirin_phy_type {
	PCIE_KIRIN_INTERNAL_PHY = 0,
	PCIE_KIRIN_EXTERNAL_PHY = 1,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcie_soc_base {
	GENERIC = 0,
	BCM2711 = 1,
	BCM4908 = 2,
	BCM7278 = 3,
	BCM7425 = 4,
	BCM7435 = 5,
	BCM7712 = 6,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pdc_irq_config_bits {
	PDC_LEVEL_LOW = 0,
	PDC_EDGE_FALLING = 2,
	PDC_LEVEL_HIGH = 4,
	PDC_EDGE_RISING = 6,
	PDC_EDGE_DUAL = 7,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum peer_app_attr {
	DCB_ATTR_CEE_PEER_APP_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_APP_INFO = 1,
	DCB_ATTR_CEE_PEER_APP = 2,
	__DCB_ATTR_CEE_PEER_APP_MAX = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_arm_regs {
	PERF_REG_ARM64_X0 = 0,
	PERF_REG_ARM64_X1 = 1,
	PERF_REG_ARM64_X2 = 2,
	PERF_REG_ARM64_X3 = 3,
	PERF_REG_ARM64_X4 = 4,
	PERF_REG_ARM64_X5 = 5,
	PERF_REG_ARM64_X6 = 6,
	PERF_REG_ARM64_X7 = 7,
	PERF_REG_ARM64_X8 = 8,
	PERF_REG_ARM64_X9 = 9,
	PERF_REG_ARM64_X10 = 10,
	PERF_REG_ARM64_X11 = 11,
	PERF_REG_ARM64_X12 = 12,
	PERF_REG_ARM64_X13 = 13,
	PERF_REG_ARM64_X14 = 14,
	PERF_REG_ARM64_X15 = 15,
	PERF_REG_ARM64_X16 = 16,
	PERF_REG_ARM64_X17 = 17,
	PERF_REG_ARM64_X18 = 18,
	PERF_REG_ARM64_X19 = 19,
	PERF_REG_ARM64_X20 = 20,
	PERF_REG_ARM64_X21 = 21,
	PERF_REG_ARM64_X22 = 22,
	PERF_REG_ARM64_X23 = 23,
	PERF_REG_ARM64_X24 = 24,
	PERF_REG_ARM64_X25 = 25,
	PERF_REG_ARM64_X26 = 26,
	PERF_REG_ARM64_X27 = 27,
	PERF_REG_ARM64_X28 = 28,
	PERF_REG_ARM64_X29 = 29,
	PERF_REG_ARM64_LR = 30,
	PERF_REG_ARM64_SP = 31,
	PERF_REG_ARM64_PC = 32,
	PERF_REG_ARM64_MAX = 33,
	PERF_REG_ARM64_VG = 46,
	PERF_REG_ARM64_EXTENDED_MAX = 47,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pg_states {
	PG_STATE_OFF = 0,
	PG_STATE_ON = 1,
	PG_STATE_RUNNING = 2,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_LOW = 0,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 1,
	__PHY_LED_MODES_NUM = 2,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum piix_controller_ids {
	piix_pata_mwdma = 0,
	piix_pata_33 = 1,
	ich_pata_33 = 2,
	ich_pata_66 = 3,
	ich_pata_100 = 4,
	ich_pata_100_nomwdma1 = 5,
	ich5_sata = 6,
	ich6_sata = 7,
	ich6m_sata = 8,
	ich8_sata = 9,
	ich8_2port_sata = 10,
	ich8m_apple_sata = 11,
	tolapai_sata = 12,
	piix_pata_vmw = 13,
	ich8_sata_snb = 14,
	ich8_2port_sata_snb = 15,
	ich8_2port_sata_byt = 16,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkey_id_type {
	PKEY_ID_PGP = 0,
	PKEY_ID_X509 = 1,
	PKEY_ID_PKCS7 = 2,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pkvm_component_id {
	PKVM_ID_HOST = 0,
	PKVM_ID_HYP = 1,
	PKVM_ID_FFA = 2,
};

enum pkvm_page_state {
	PKVM_PAGE_OWNED = 0ULL,
	PKVM_PAGE_SHARED_OWNED = 36028797018963968ULL,
	PKVM_PAGE_SHARED_BORROWED = 72057594037927936ULL,
	__PKVM_PAGE_RESERVED = 108086391056891904ULL,
	PKVM_NOPAGE = 108086391056891905ULL,
};

enum plda_int_event {
	PLDA_AXI_POST_ERR = 0,
	PLDA_AXI_FETCH_ERR = 1,
	PLDA_AXI_DISCARD_ERR = 2,
	PLDA_AXI_DOORBELL = 3,
	PLDA_PCIE_POST_ERR = 4,
	PLDA_PCIE_FETCH_ERR = 5,
	PLDA_PCIE_DISCARD_ERR = 6,
	PLDA_PCIE_DOORBELL = 7,
	PLDA_INTX = 8,
	PLDA_MSI = 9,
	PLDA_AER_EVENT = 10,
	PLDA_MISC_EVENTS = 11,
	PLDA_SYS_ERR = 12,
	PLDA_INT_EVENT_NUM = 13,
};

enum pll_mode {
	PLL_MODE_INT = 0,
	PLL_MODE_FRAC = 1,
	PLL_MODE_ERROR = 2,
};

enum pm_api_cb_id {
	PM_INIT_SUSPEND_CB = 30,
	PM_ACKNOWLEDGE_CB = 31,
	PM_NOTIFY_CB = 32,
};

enum pm_api_id {
	PM_API_FEATURES = 0,
	PM_GET_API_VERSION = 1,
	PM_REGISTER_NOTIFIER = 5,
	PM_FORCE_POWERDOWN = 8,
	PM_REQUEST_WAKEUP = 10,
	PM_SYSTEM_SHUTDOWN = 12,
	PM_REQUEST_NODE = 13,
	PM_RELEASE_NODE = 14,
	PM_SET_REQUIREMENT = 15,
	PM_RESET_ASSERT = 17,
	PM_RESET_GET_STATUS = 18,
	PM_MMIO_WRITE = 19,
	PM_MMIO_READ = 20,
	PM_PM_INIT_FINALIZE = 21,
	PM_FPGA_LOAD = 22,
	PM_FPGA_GET_STATUS = 23,
	PM_GET_CHIPID = 24,
	PM_SECURE_SHA = 26,
	PM_PINCTRL_REQUEST = 28,
	PM_PINCTRL_RELEASE = 29,
	PM_PINCTRL_SET_FUNCTION = 31,
	PM_PINCTRL_CONFIG_PARAM_GET = 32,
	PM_PINCTRL_CONFIG_PARAM_SET = 33,
	PM_IOCTL = 34,
	PM_QUERY_DATA = 35,
	PM_CLOCK_ENABLE = 36,
	PM_CLOCK_DISABLE = 37,
	PM_CLOCK_GETSTATE = 38,
	PM_CLOCK_SETDIVIDER = 39,
	PM_CLOCK_GETDIVIDER = 40,
	PM_CLOCK_SETPARENT = 43,
	PM_CLOCK_GETPARENT = 44,
	PM_FPGA_READ = 46,
	PM_SECURE_AES = 47,
	PM_EFUSE_ACCESS = 53,
	PM_FEATURE_CHECK = 63,
};

enum pm_feature_config_id {
	PM_FEATURE_INVALID = 0,
	PM_FEATURE_OVERTEMP_STATUS = 1,
	PM_FEATURE_OVERTEMP_VALUE = 2,
	PM_FEATURE_EXTWDT_STATUS = 3,
	PM_FEATURE_EXTWDT_VALUE = 4,
};

enum pm_gem_config_type {
	GEM_CONFIG_SGMII_MODE = 1,
	GEM_CONFIG_FIXED = 2,
};

enum pm_ioctl_id {
	IOCTL_GET_RPU_OPER_MODE = 0,
	IOCTL_SET_RPU_OPER_MODE = 1,
	IOCTL_RPU_BOOT_ADDR_CONFIG = 2,
	IOCTL_TCM_COMB_CONFIG = 3,
	IOCTL_SET_TAPDELAY_BYPASS = 4,
	IOCTL_SD_DLL_RESET = 6,
	IOCTL_SET_SD_TAPDELAY = 7,
	IOCTL_SET_PLL_FRAC_MODE = 8,
	IOCTL_GET_PLL_FRAC_MODE = 9,
	IOCTL_SET_PLL_FRAC_DATA = 10,
	IOCTL_GET_PLL_FRAC_DATA = 11,
	IOCTL_WRITE_GGS = 12,
	IOCTL_READ_GGS = 13,
	IOCTL_WRITE_PGGS = 14,
	IOCTL_READ_PGGS = 15,
	IOCTL_SET_BOOT_HEALTH_STATUS = 17,
	IOCTL_OSPI_MUX_SELECT = 21,
	IOCTL_REGISTER_SGI = 25,
	IOCTL_SET_FEATURE_CONFIG = 26,
	IOCTL_GET_FEATURE_CONFIG = 27,
	IOCTL_SET_SD_CONFIG = 30,
	IOCTL_SET_GEM_CONFIG = 31,
};

enum pm_module_id {
	PM_MODULE_ID = 0,
	XSEM_MODULE_ID = 3,
	TF_A_MODULE_ID = 10,
};

enum pm_node_id {
	NODE_SD_0 = 39,
	NODE_SD_1 = 40,
};

enum pm_pinctrl_bias_status {
	PM_PINCTRL_BIAS_DISABLE = 0,
	PM_PINCTRL_BIAS_ENABLE = 1,
};

enum pm_pinctrl_config_param {
	PM_PINCTRL_CONFIG_SLEW_RATE = 0,
	PM_PINCTRL_CONFIG_BIAS_STATUS = 1,
	PM_PINCTRL_CONFIG_PULL_CTRL = 2,
	PM_PINCTRL_CONFIG_SCHMITT_CMOS = 3,
	PM_PINCTRL_CONFIG_DRIVE_STRENGTH = 4,
	PM_PINCTRL_CONFIG_VOLTAGE_STATUS = 5,
	PM_PINCTRL_CONFIG_TRI_STATE = 6,
	PM_PINCTRL_CONFIG_MAX = 7,
};

enum pm_pinctrl_drive_strength {
	PM_PINCTRL_DRIVE_STRENGTH_2MA = 0,
	PM_PINCTRL_DRIVE_STRENGTH_4MA = 1,
	PM_PINCTRL_DRIVE_STRENGTH_8MA = 2,
	PM_PINCTRL_DRIVE_STRENGTH_12MA = 3,
};

enum pm_pinctrl_pull_ctrl {
	PM_PINCTRL_BIAS_PULL_DOWN = 0,
	PM_PINCTRL_BIAS_PULL_UP = 1,
};

enum pm_pinctrl_tri_state {
	PM_PINCTRL_TRI_STATE_DISABLE = 0,
	PM_PINCTRL_TRI_STATE_ENABLE = 1,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pm_query_id {
	PM_QID_INVALID = 0,
	PM_QID_CLOCK_GET_NAME = 1,
	PM_QID_CLOCK_GET_TOPOLOGY = 2,
	PM_QID_CLOCK_GET_FIXEDFACTOR_PARAMS = 3,
	PM_QID_CLOCK_GET_PARENTS = 4,
	PM_QID_CLOCK_GET_ATTRIBUTES = 5,
	PM_QID_PINCTRL_GET_NUM_PINS = 6,
	PM_QID_PINCTRL_GET_NUM_FUNCTIONS = 7,
	PM_QID_PINCTRL_GET_NUM_FUNCTION_GROUPS = 8,
	PM_QID_PINCTRL_GET_FUNCTION_NAME = 9,
	PM_QID_PINCTRL_GET_FUNCTION_GROUPS = 10,
	PM_QID_PINCTRL_GET_PIN_GROUPS = 11,
	PM_QID_CLOCK_GET_NUM_CLOCKS = 12,
	PM_QID_CLOCK_GET_MAX_DIVISOR = 13,
};

enum pm_ret_status {
	XST_PM_SUCCESS = 0,
	XST_PM_INVALID_VERSION = 4,
	XST_PM_NO_FEATURE = 19,
	XST_PM_INVALID_CRC = 301,
	XST_PM_INTERNAL = 2000,
	XST_PM_CONFLICT = 2001,
	XST_PM_NO_ACCESS = 2002,
	XST_PM_INVALID_NODE = 2003,
	XST_PM_DOUBLE_REQ = 2004,
	XST_PM_ABORT_SUSPEND = 2005,
	XST_PM_MULT_USER = 2008,
};

enum pm_sd_config_type {
	SD_CONFIG_EMMC_SEL = 1,
	SD_CONFIG_BASECLK = 2,
	SD_CONFIG_8BIT = 3,
	SD_CONFIG_FIXED = 4,
};

enum pm_sleep_mode {
	PM_SLEEP_MODE_STBY = 0,
	PM_SLEEP_MODE_RET = 1,
	PM_SLEEP_MODE_SPC = 2,
	PM_SLEEP_MODE_PC = 3,
	PM_SLEEP_MODE_NR = 4,
};

enum pm_suspend_mode {
	PM_SUSPEND_MODE_FIRST = 0,
	PM_SUSPEND_MODE_STD = 0,
	PM_SUSPEND_MODE_POWER_OFF = 1,
};

enum pmic_arb_channel {
	PMIC_ARB_CHANNEL_RW = 0,
	PMIC_ARB_CHANNEL_OBS = 1,
};

enum pmic_arb_chnl_status {
	PMIC_ARB_STATUS_DONE = 1,
	PMIC_ARB_STATUS_FAILURE = 2,
	PMIC_ARB_STATUS_DENIED = 4,
	PMIC_ARB_STATUS_DROPPED = 8,
};

enum pmic_arb_cmd_op_code {
	PMIC_ARB_OP_EXT_WRITEL = 0,
	PMIC_ARB_OP_EXT_READL = 1,
	PMIC_ARB_OP_EXT_WRITE = 2,
	PMIC_ARB_OP_RESET = 3,
	PMIC_ARB_OP_SLEEP = 4,
	PMIC_ARB_OP_SHUTDOWN = 5,
	PMIC_ARB_OP_WAKEUP = 6,
	PMIC_ARB_OP_AUTHENTICATE = 7,
	PMIC_ARB_OP_MSTR_READ = 8,
	PMIC_ARB_OP_MSTR_WRITE = 9,
	PMIC_ARB_OP_EXT_READ = 13,
	PMIC_ARB_OP_WRITE = 14,
	PMIC_ARB_OP_READ = 15,
	PMIC_ARB_OP_ZERO_WRITE = 16,
};

enum pmic_gpio_func_index {
	PMIC_GPIO_FUNC_INDEX_NORMAL = 0,
	PMIC_GPIO_FUNC_INDEX_PAIRED = 1,
	PMIC_GPIO_FUNC_INDEX_FUNC1 = 2,
	PMIC_GPIO_FUNC_INDEX_FUNC2 = 3,
	PMIC_GPIO_FUNC_INDEX_FUNC3 = 4,
	PMIC_GPIO_FUNC_INDEX_FUNC4 = 5,
	PMIC_GPIO_FUNC_INDEX_DTEST1 = 6,
	PMIC_GPIO_FUNC_INDEX_DTEST2 = 7,
	PMIC_GPIO_FUNC_INDEX_DTEST3 = 8,
	PMIC_GPIO_FUNC_INDEX_DTEST4 = 9,
};

enum poison_cmd_enabled_bits {
	CXL_POISON_ENABLED_LIST = 0,
	CXL_POISON_ENABLED_INJECT = 1,
	CXL_POISON_ENABLED_CLEAR = 2,
	CXL_POISON_ENABLED_SCAN_CAPS = 3,
	CXL_POISON_ENABLED_SCAN_MEDIA = 4,
	CXL_POISON_ENABLED_SCAN_RESULTS = 5,
	CXL_POISON_ENABLED_MAX = 6,
};

enum policy_opt {
	Opt_measure = 0,
	Opt_dont_measure = 1,
	Opt_appraise = 2,
	Opt_dont_appraise = 3,
	Opt_audit = 4,
	Opt_hash___3 = 5,
	Opt_dont_hash = 6,
	Opt_obj_user = 7,
	Opt_obj_role = 8,
	Opt_obj_type = 9,
	Opt_subj_user = 10,
	Opt_subj_role = 11,
	Opt_subj_type = 12,
	Opt_func = 13,
	Opt_mask = 14,
	Opt_fsmagic = 15,
	Opt_fsname = 16,
	Opt_fsuuid = 17,
	Opt_uid_eq = 18,
	Opt_euid_eq = 19,
	Opt_gid_eq = 20,
	Opt_egid_eq = 21,
	Opt_fowner_eq = 22,
	Opt_fgroup_eq = 23,
	Opt_uid_gt = 24,
	Opt_euid_gt = 25,
	Opt_gid_gt = 26,
	Opt_egid_gt = 27,
	Opt_fowner_gt = 28,
	Opt_fgroup_gt = 29,
	Opt_uid_lt = 30,
	Opt_euid_lt = 31,
	Opt_gid_lt = 32,
	Opt_egid_lt = 33,
	Opt_fowner_lt = 34,
	Opt_fgroup_lt = 35,
	Opt_digest_type = 36,
	Opt_appraise_type = 37,
	Opt_appraise_flag = 38,
	Opt_appraise_algos = 39,
	Opt_permit_directio = 40,
	Opt_pcr = 41,
	Opt_template = 42,
	Opt_keyrings = 43,
	Opt_label = 44,
	Opt_err___9 = 45,
};

enum policy_rule_list {
	IMA_DEFAULT_POLICY = 1,
	IMA_CUSTOM_POLICY = 2,
};

enum policy_types {
	ORIGINAL_TCB = 1,
	DEFAULT_TCB = 2,
};

enum poll_states {
	VIO_MSG_NOT_POLLED = 0,
	VIO_MSG_POLL_TIMEOUT = 1,
	VIO_MSG_POLLING = 2,
	VIO_MSG_POLL_DONE = 3,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 2,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_HEALTH = 2,
	POWER_SUPPLY_PROP_PRESENT = 3,
	POWER_SUPPLY_PROP_ONLINE = 4,
	POWER_SUPPLY_PROP_AUTHENTIC = 5,
	POWER_SUPPLY_PROP_TECHNOLOGY = 6,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 7,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 12,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 13,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 14,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 15,
	POWER_SUPPLY_PROP_CURRENT_MAX = 16,
	POWER_SUPPLY_PROP_CURRENT_NOW = 17,
	POWER_SUPPLY_PROP_CURRENT_AVG = 18,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 19,
	POWER_SUPPLY_PROP_POWER_NOW = 20,
	POWER_SUPPLY_PROP_POWER_AVG = 21,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 22,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_FULL = 24,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 25,
	POWER_SUPPLY_PROP_CHARGE_NOW = 26,
	POWER_SUPPLY_PROP_CHARGE_AVG = 27,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 28,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 32,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 37,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 38,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 40,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 41,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_FULL = 43,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 44,
	POWER_SUPPLY_PROP_ENERGY_NOW = 45,
	POWER_SUPPLY_PROP_ENERGY_AVG = 46,
	POWER_SUPPLY_PROP_CAPACITY = 47,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 49,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 50,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 51,
	POWER_SUPPLY_PROP_TEMP = 52,
	POWER_SUPPLY_PROP_TEMP_MAX = 53,
	POWER_SUPPLY_PROP_TEMP_MIN = 54,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 56,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 59,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 61,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 63,
	POWER_SUPPLY_PROP_TYPE = 64,
	POWER_SUPPLY_PROP_USB_TYPE = 65,
	POWER_SUPPLY_PROP_SCOPE = 66,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 67,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 68,
	POWER_SUPPLY_PROP_CALIBRATE = 69,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 72,
	POWER_SUPPLY_PROP_MODEL_NAME = 73,
	POWER_SUPPLY_PROP_MANUFACTURER = 74,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 75,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum pri_resp {
	PRI_RESP_DENY = 0,
	PRI_RESP_FAIL = 1,
	PRI_RESP_SUCC = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum probe_insn {
	INSN_REJECTED = 0,
	INSN_GOOD_NO_SLOT = 1,
	INSN_GOOD = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_cn_mcast_op {
	PROC_CN_MCAST_LISTEN = 1,
	PROC_CN_MCAST_IGNORE = 2,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___7 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	PSI_IRQ = 3,
	NR_PSI_RESOURCES = 4,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_IRQ_FULL = 6,
	PSI_NONIDLE = 7,
	NR_PSI_STATES = 8,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum pstore_type_id {
	PSTORE_TYPE_DMESG = 0,
	PSTORE_TYPE_MCE = 1,
	PSTORE_TYPE_CONSOLE = 2,
	PSTORE_TYPE_FTRACE = 3,
	PSTORE_TYPE_PPC_RTAS = 4,
	PSTORE_TYPE_PPC_OF = 5,
	PSTORE_TYPE_PPC_COMMON = 6,
	PSTORE_TYPE_PMSG = 7,
	PSTORE_TYPE_PPC_OPAL = 8,
	PSTORE_TYPE_MAX = 9,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum ptrace_syscall_dir {
	PTRACE_SYSCALL_ENTER = 0,
	PTRACE_SYSCALL_EXIT = 1,
};

enum pubkey_algo {
	PUBKEY_ALGO_RSA = 0,
	PUBKEY_ALGO_MAX = 1,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum px30_plls {
	apll = 0,
	dpll = 1,
	cpll = 2,
	npll = 3,
	apll_b_h = 4,
	apll_b_l = 5,
};

enum px30_pmu_plls {
	gpll = 0,
};

enum qcom_iommu_clk {
	CLK_IFACE = 0,
	CLK_BUS = 1,
	CLK_TBU = 2,
	CLK_NUM = 3,
};

enum qcom_scm_arg_types {
	QCOM_SCM_VAL = 0,
	QCOM_SCM_RO = 1,
	QCOM_SCM_RW = 2,
	QCOM_SCM_BUFVAL = 3,
};

enum qcom_scm_convention {
	SMC_CONVENTION_UNKNOWN = 0,
	SMC_CONVENTION_LEGACY = 1,
	SMC_CONVENTION_ARM_32 = 2,
	SMC_CONVENTION_ARM_64 = 3,
};

enum qcom_scm_ice_cipher {
	QCOM_SCM_ICE_CIPHER_AES_128_XTS = 0,
	QCOM_SCM_ICE_CIPHER_AES_128_CBC = 1,
	QCOM_SCM_ICE_CIPHER_AES_256_XTS = 3,
	QCOM_SCM_ICE_CIPHER_AES_256_CBC = 4,
};

enum qcom_scm_ocmem_client {
	QCOM_SCM_OCMEM_UNUSED_ID = 0,
	QCOM_SCM_OCMEM_GRAPHICS_ID = 1,
	QCOM_SCM_OCMEM_VIDEO_ID = 2,
	QCOM_SCM_OCMEM_LP_AUDIO_ID = 3,
	QCOM_SCM_OCMEM_SENSORS_ID = 4,
	QCOM_SCM_OCMEM_OTHER_OS_ID = 5,
	QCOM_SCM_OCMEM_DEBUG_ID = 6,
};

enum qcom_scm_qseecom_resp_type {
	QSEECOM_SCM_RES_APP_ID = 60929,
	QSEECOM_SCM_RES_QSEOS_LISTENER_ID = 60930,
};

enum qcom_scm_qseecom_result {
	QSEECOM_RESULT_SUCCESS = 0,
	QSEECOM_RESULT_INCOMPLETE = 1,
	QSEECOM_RESULT_BLOCKED_ON_LISTENER = 2,
	QSEECOM_RESULT_FAILURE = 4294967295,
};

enum qcom_scm_qseecom_tz_cmd_app {
	QSEECOM_TZ_CMD_APP_SEND = 1,
	QSEECOM_TZ_CMD_APP_LOOKUP = 3,
};

enum qcom_scm_qseecom_tz_cmd_info {
	QSEECOM_TZ_CMD_INFO_VERSION = 3,
};

enum qcom_scm_qseecom_tz_owner {
	QSEECOM_TZ_OWNER_SIP = 2,
	QSEECOM_TZ_OWNER_TZ_APPS = 48,
	QSEECOM_TZ_OWNER_QSEE_OS = 50,
};

enum qcom_scm_qseecom_tz_svc {
	QSEECOM_TZ_SVC_APP_ID_PLACEHOLDER = 0,
	QSEECOM_TZ_SVC_APP_MGR = 1,
	QSEECOM_TZ_SVC_INFO = 6,
};

enum qcom_smmu_impl_reg_offset {
	QCOM_SMMU_TBU_PWR_STATUS = 0,
	QCOM_SMMU_STATS_SYNC_INV_TBU_ACK = 1,
	QCOM_SMMU_MMU2QSS_AND_SAFE_WAIT_CNTR = 2,
};

enum qcom_tzmem_policy {
	QCOM_TZMEM_POLICY_STATIC = 1,
	QCOM_TZMEM_POLICY_MULTIPLIER = 2,
	QCOM_TZMEM_POLICY_ON_DEMAND = 3,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum qm_dc_portal {
	qm_dc_portal_fman0 = 0,
	qm_dc_portal_fman1 = 1,
};

enum qm_dqrr_cmode {
	qm_dqrr_cci = 0,
	qm_dqrr_cce = 1,
	qm_dqrr_cdc = 2,
};

enum qm_dqrr_dmode {
	qm_dqrr_dpush = 0,
	qm_dqrr_dpull = 1,
};

enum qm_dqrr_pmode {
	qm_dqrr_pci = 0,
	qm_dqrr_pce = 1,
	qm_dqrr_pvb = 2,
};

enum qm_eqcr_pmode {
	qm_eqcr_pci = 0,
	qm_eqcr_pce = 1,
	qm_eqcr_pvb = 2,
};

enum qm_memory {
	qm_memory_fqd = 0,
	qm_memory_pfdr = 1,
};

enum qm_mr_cmode {
	qm_mr_cci = 0,
	qm_mr_cce = 1,
};

enum qm_mr_pmode {
	qm_mr_pci = 0,
	qm_mr_pce = 1,
	qm_mr_pvb = 2,
};

enum qm_wq_class {
	qm_wq_portal = 0,
	qm_wq_pool = 1,
	qm_wq_fman0 = 2,
	qm_wq_fman1 = 3,
	qm_wq_caam = 4,
	qm_wq_pme = 5,
	qm_wq_first = 0,
	qm_wq_last = 5,
};

enum qman_cb_dqrr_result {
	qman_cb_dqrr_consume = 0,
	qman_cb_dqrr_park = 1,
	qman_cb_dqrr_defer = 2,
	qman_cb_dqrr_stop = 3,
	qman_cb_dqrr_consume_stop = 4,
};

enum qman_fq_state {
	qman_fq_state_oos = 0,
	qman_fq_state_parked = 1,
	qman_fq_state_sched = 2,
	qman_fq_state_retired = 3,
};

enum qpnpint_regs {
	QPNPINT_REG_RT_STS = 16,
	QPNPINT_REG_SET_TYPE = 17,
	QPNPINT_REG_POLARITY_HIGH = 18,
	QPNPINT_REG_POLARITY_LOW = 19,
	QPNPINT_REG_LATCHED_CLR = 20,
	QPNPINT_REG_EN_SET = 21,
	QPNPINT_REG_EN_CLR = 22,
	QPNPINT_REG_LATCHED_STS = 24,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum ramfs_param {
	Opt_mode___5 = 0,
};

enum rc_driver_type {
	RC_DRIVER_SCANCODE = 0,
	RC_DRIVER_IR_RAW = 1,
	RC_DRIVER_IR_RAW_TX = 2,
};

enum rc_filter_type {
	RC_FILTER_NORMAL = 0,
	RC_FILTER_WAKEUP = 1,
	RC_FILTER_MAX = 2,
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

enum rcar_gen3_clk_types {
	CLK_TYPE_GEN3_MAIN = 5,
	CLK_TYPE_GEN3_PLL0 = 6,
	CLK_TYPE_GEN3_PLL1 = 7,
	CLK_TYPE_GEN3_PLL2 = 8,
	CLK_TYPE_GEN3_PLL3 = 9,
	CLK_TYPE_GEN3_PLL4 = 10,
	CLK_TYPE_GEN3_SDH = 11,
	CLK_TYPE_GEN3_SD = 12,
	CLK_TYPE_GEN3_R = 13,
	CLK_TYPE_GEN3_MDSEL = 14,
	CLK_TYPE_GEN3_Z = 15,
	CLK_TYPE_GEN3_ZG = 16,
	CLK_TYPE_GEN3_OSC = 17,
	CLK_TYPE_GEN3_RCKSEL = 18,
	CLK_TYPE_GEN3_RPCSRC = 19,
	CLK_TYPE_GEN3_E3_RPCSRC = 20,
	CLK_TYPE_GEN3_RPC = 21,
	CLK_TYPE_GEN3_RPCD2 = 22,
	CLK_TYPE_GEN3_SOC_BASE = 23,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum recovery_flags {
	MD_RECOVERY_NEEDED = 0,
	MD_RECOVERY_RUNNING = 1,
	MD_RECOVERY_INTR = 2,
	MD_RECOVERY_DONE = 3,
	MD_RECOVERY_FROZEN = 4,
	MD_RECOVERY_WAIT = 5,
	MD_RECOVERY_ERROR = 6,
	MD_RECOVERY_SYNC = 7,
	MD_RECOVERY_REQUESTED = 8,
	MD_RECOVERY_CHECK = 9,
	MD_RECOVERY_RECOVER = 10,
	MD_RECOVERY_RESHAPE = 11,
	MD_RESYNCING_REMOTE = 12,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum reloc_stage {
	MOVE_DATA_EXTENTS = 0,
	UPDATE_DATA_PTRS = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum res_type {
	_MEM = 0,
	_MEMSWAP = 1,
	_KMEM = 2,
	_TCP = 3,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum ring_desc_flags {
	RING_DESC_ISOCH = 1,
	RING_DESC_CRC_ERROR = 1,
	RING_DESC_COMPLETED = 2,
	RING_DESC_POSTED = 4,
	RING_DESC_BUFFER_OVERRUN = 4,
	RING_DESC_INTERRUPT = 8,
};

enum ring_flags {
	RING_FLAG_ISOCH_ENABLE = 134217728,
	RING_FLAG_E2E_FLOW_CONTROL = 268435456,
	RING_FLAG_PCI_NO_SNOOP = 536870912,
	RING_FLAG_RAW = 1073741824,
	RING_FLAG_ENABLE = -2147483648,
};

enum rk3308_plls {
	apll___2 = 0,
	dpll___2 = 1,
	vpll0 = 2,
	vpll1 = 3,
};

enum rk3328_plls {
	apll___3 = 0,
	dpll___3 = 1,
	cpll___2 = 2,
	gpll___2 = 3,
	npll___2 = 4,
};

enum rk3368_plls {
	apllb = 0,
	aplll = 1,
	dpll___4 = 2,
	cpll___3 = 3,
	gpll___3 = 4,
	npll___3 = 5,
};

enum rk3399_plls {
	lpll = 0,
	bpll = 1,
	dpll___5 = 2,
	cpll___4 = 3,
	gpll___4 = 4,
	npll___4 = 5,
	vpll = 6,
};

enum rk3399_pmu_plls {
	ppll = 0,
};

enum rk3568_plls {
	apll___4 = 0,
	dpll___6 = 1,
	gpll___5 = 2,
	cpll___5 = 3,
	npll___5 = 4,
	vpll___2 = 5,
};

enum rk3568_pmu_plls {
	ppll___2 = 0,
	hpll = 1,
};

enum rk3576_plls {
	bpll___2 = 0,
	lpll___2 = 1,
	vpll___3 = 2,
	aupll = 3,
	cpll___6 = 4,
	gpll___6 = 5,
	ppll___3 = 6,
};

enum rk3588_plls {
	b0pll = 0,
	b1pll = 1,
	lpll___3 = 2,
	v0pll = 3,
	aupll___2 = 4,
	cpll___7 = 5,
	gpll___7 = 6,
	npll___6 = 7,
	ppll___4 = 8,
};

enum rk3x_i2c_state {
	STATE_IDLE = 0,
	STATE_START = 1,
	STATE_READ = 2,
	STATE_WRITE = 3,
	STATE_STOP = 4,
};

enum rk817_reg_id {
	RK817_ID_DCDC1 = 0,
	RK817_ID_DCDC2 = 1,
	RK817_ID_DCDC3 = 2,
	RK817_ID_DCDC4 = 3,
	RK817_ID_LDO1 = 4,
	RK817_ID_LDO2 = 5,
	RK817_ID_LDO3 = 6,
	RK817_ID_LDO4 = 7,
	RK817_ID_LDO5 = 8,
	RK817_ID_LDO6 = 9,
	RK817_ID_LDO7 = 10,
	RK817_ID_LDO8 = 11,
	RK817_ID_LDO9 = 12,
	RK817_ID_BOOST = 13,
	RK817_ID_BOOST_OTG_SW = 14,
	RK817_NUM_REGULATORS = 15,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rockchip_clk_branch_type {
	branch_composite = 0,
	branch_mux = 1,
	branch_muxgrf = 2,
	branch_divider = 3,
	branch_fraction_divider = 4,
	branch_gate = 5,
	branch_mmc = 6,
	branch_inverter = 7,
	branch_factor = 8,
	branch_ddrclk = 9,
	branch_half_divider = 10,
};

enum rockchip_mux_route_location {
	ROCKCHIP_ROUTE_SAME = 0,
	ROCKCHIP_ROUTE_PMU = 1,
	ROCKCHIP_ROUTE_GRF = 2,
};

enum rockchip_pin_drv_type {
	DRV_TYPE_IO_DEFAULT = 0,
	DRV_TYPE_IO_1V8_OR_3V0 = 1,
	DRV_TYPE_IO_1V8_ONLY = 2,
	DRV_TYPE_IO_1V8_3V0_AUTO = 3,
	DRV_TYPE_IO_3V3_ONLY = 4,
	DRV_TYPE_MAX = 5,
};

enum rockchip_pin_pull_type {
	PULL_TYPE_IO_DEFAULT = 0,
	PULL_TYPE_IO_1V8_ONLY = 1,
	PULL_TYPE_MAX = 2,
};

enum rockchip_pinctrl_type {
	PX30 = 0,
	RV1108 = 1,
	RV1126 = 2,
	RK2928 = 3,
	RK3066B = 4,
	RK3128 = 5,
	RK3188 = 6,
	RK3288 = 7,
	RK3308 = 8,
	RK3328 = 9,
	RK3368 = 10,
	RK3399 = 11,
	RK3568 = 12,
	RK3576 = 13,
	RK3588 = 14,
};

enum rockchip_pll_type {
	pll_rk3036 = 0,
	pll_rk3066 = 1,
	pll_rk3328 = 2,
	pll_rk3399 = 3,
	pll_rk3588 = 4,
	pll_rk3588_core = 5,
	pll_rk3588_ddr = 6,
};

enum rohm_chip_type {
	ROHM_CHIP_TYPE_BD9571 = 0,
	ROHM_CHIP_TYPE_BD9573 = 1,
	ROHM_CHIP_TYPE_BD9574 = 2,
	ROHM_CHIP_TYPE_BD9576 = 3,
	ROHM_CHIP_TYPE_BD71815 = 4,
	ROHM_CHIP_TYPE_BD71828 = 5,
	ROHM_CHIP_TYPE_BD71837 = 6,
	ROHM_CHIP_TYPE_BD71847 = 7,
	ROHM_CHIP_TYPE_BD96801 = 8,
	ROHM_CHIP_TYPE_AMOUNT = 9,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpi_firmware_clk_id {
	RPI_FIRMWARE_EMMC_CLK_ID = 1,
	RPI_FIRMWARE_UART_CLK_ID = 2,
	RPI_FIRMWARE_ARM_CLK_ID = 3,
	RPI_FIRMWARE_CORE_CLK_ID = 4,
	RPI_FIRMWARE_V3D_CLK_ID = 5,
	RPI_FIRMWARE_H264_CLK_ID = 6,
	RPI_FIRMWARE_ISP_CLK_ID = 7,
	RPI_FIRMWARE_SDRAM_CLK_ID = 8,
	RPI_FIRMWARE_PIXEL_CLK_ID = 9,
	RPI_FIRMWARE_PWM_CLK_ID = 10,
	RPI_FIRMWARE_HEVC_CLK_ID = 11,
	RPI_FIRMWARE_EMMC2_CLK_ID = 12,
	RPI_FIRMWARE_M2MC_CLK_ID = 13,
	RPI_FIRMWARE_PIXEL_BVB_CLK_ID = 14,
	RPI_FIRMWARE_VEC_CLK_ID = 15,
	RPI_FIRMWARE_NUM_CLK_ID = 16,
};

enum rpi_firmware_property_status {
	RPI_FIRMWARE_STATUS_REQUEST = 0,
	RPI_FIRMWARE_STATUS_SUCCESS = 2147483648,
	RPI_FIRMWARE_STATUS_ERROR = 2147483649,
};

enum rpi_firmware_property_tag {
	RPI_FIRMWARE_PROPERTY_END = 0,
	RPI_FIRMWARE_GET_FIRMWARE_REVISION = 1,
	RPI_FIRMWARE_SET_CURSOR_INFO = 32784,
	RPI_FIRMWARE_SET_CURSOR_STATE = 32785,
	RPI_FIRMWARE_GET_BOARD_MODEL = 65537,
	RPI_FIRMWARE_GET_BOARD_REVISION = 65538,
	RPI_FIRMWARE_GET_BOARD_MAC_ADDRESS = 65539,
	RPI_FIRMWARE_GET_BOARD_SERIAL = 65540,
	RPI_FIRMWARE_GET_ARM_MEMORY = 65541,
	RPI_FIRMWARE_GET_VC_MEMORY = 65542,
	RPI_FIRMWARE_GET_CLOCKS = 65543,
	RPI_FIRMWARE_GET_POWER_STATE = 131073,
	RPI_FIRMWARE_GET_TIMING = 131074,
	RPI_FIRMWARE_SET_POWER_STATE = 163841,
	RPI_FIRMWARE_GET_CLOCK_STATE = 196609,
	RPI_FIRMWARE_GET_CLOCK_RATE = 196610,
	RPI_FIRMWARE_GET_VOLTAGE = 196611,
	RPI_FIRMWARE_GET_MAX_CLOCK_RATE = 196612,
	RPI_FIRMWARE_GET_MAX_VOLTAGE = 196613,
	RPI_FIRMWARE_GET_TEMPERATURE = 196614,
	RPI_FIRMWARE_GET_MIN_CLOCK_RATE = 196615,
	RPI_FIRMWARE_GET_MIN_VOLTAGE = 196616,
	RPI_FIRMWARE_GET_TURBO = 196617,
	RPI_FIRMWARE_GET_MAX_TEMPERATURE = 196618,
	RPI_FIRMWARE_GET_STC = 196619,
	RPI_FIRMWARE_ALLOCATE_MEMORY = 196620,
	RPI_FIRMWARE_LOCK_MEMORY = 196621,
	RPI_FIRMWARE_UNLOCK_MEMORY = 196622,
	RPI_FIRMWARE_RELEASE_MEMORY = 196623,
	RPI_FIRMWARE_EXECUTE_CODE = 196624,
	RPI_FIRMWARE_EXECUTE_QPU = 196625,
	RPI_FIRMWARE_SET_ENABLE_QPU = 196626,
	RPI_FIRMWARE_GET_DISPMANX_RESOURCE_MEM_HANDLE = 196628,
	RPI_FIRMWARE_GET_EDID_BLOCK = 196640,
	RPI_FIRMWARE_GET_CUSTOMER_OTP = 196641,
	RPI_FIRMWARE_GET_DOMAIN_STATE = 196656,
	RPI_FIRMWARE_GET_THROTTLED = 196678,
	RPI_FIRMWARE_GET_CLOCK_MEASURED = 196679,
	RPI_FIRMWARE_NOTIFY_REBOOT = 196680,
	RPI_FIRMWARE_SET_CLOCK_STATE = 229377,
	RPI_FIRMWARE_SET_CLOCK_RATE = 229378,
	RPI_FIRMWARE_SET_VOLTAGE = 229379,
	RPI_FIRMWARE_SET_TURBO = 229385,
	RPI_FIRMWARE_SET_CUSTOMER_OTP = 229409,
	RPI_FIRMWARE_SET_DOMAIN_STATE = 229424,
	RPI_FIRMWARE_GET_GPIO_STATE = 196673,
	RPI_FIRMWARE_SET_GPIO_STATE = 229441,
	RPI_FIRMWARE_SET_SDHOST_CLOCK = 229442,
	RPI_FIRMWARE_GET_GPIO_CONFIG = 196675,
	RPI_FIRMWARE_SET_GPIO_CONFIG = 229443,
	RPI_FIRMWARE_GET_PERIPH_REG = 196677,
	RPI_FIRMWARE_SET_PERIPH_REG = 229445,
	RPI_FIRMWARE_GET_POE_HAT_VAL = 196681,
	RPI_FIRMWARE_SET_POE_HAT_VAL = 196688,
	RPI_FIRMWARE_NOTIFY_XHCI_RESET = 196696,
	RPI_FIRMWARE_NOTIFY_DISPLAY_DONE = 196710,
	RPI_FIRMWARE_FRAMEBUFFER_ALLOCATE = 262145,
	RPI_FIRMWARE_FRAMEBUFFER_BLANK = 262146,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PHYSICAL_WIDTH_HEIGHT = 262147,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_WIDTH_HEIGHT = 262148,
	RPI_FIRMWARE_FRAMEBUFFER_GET_DEPTH = 262149,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PIXEL_ORDER = 262150,
	RPI_FIRMWARE_FRAMEBUFFER_GET_ALPHA_MODE = 262151,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PITCH = 262152,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_OFFSET = 262153,
	RPI_FIRMWARE_FRAMEBUFFER_GET_OVERSCAN = 262154,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PALETTE = 262155,
	RPI_FIRMWARE_FRAMEBUFFER_GET_TOUCHBUF = 262159,
	RPI_FIRMWARE_FRAMEBUFFER_GET_GPIOVIRTBUF = 262160,
	RPI_FIRMWARE_FRAMEBUFFER_RELEASE = 294913,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PHYSICAL_WIDTH_HEIGHT = 278531,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_WIDTH_HEIGHT = 278532,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_DEPTH = 278533,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PIXEL_ORDER = 278534,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_ALPHA_MODE = 278535,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_OFFSET = 278537,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_OVERSCAN = 278538,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PALETTE = 278539,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VSYNC = 278542,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PHYSICAL_WIDTH_HEIGHT = 294915,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_WIDTH_HEIGHT = 294916,
	RPI_FIRMWARE_FRAMEBUFFER_SET_DEPTH = 294917,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PIXEL_ORDER = 294918,
	RPI_FIRMWARE_FRAMEBUFFER_SET_ALPHA_MODE = 294919,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_OFFSET = 294921,
	RPI_FIRMWARE_FRAMEBUFFER_SET_OVERSCAN = 294922,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PALETTE = 294923,
	RPI_FIRMWARE_FRAMEBUFFER_SET_TOUCHBUF = 294943,
	RPI_FIRMWARE_FRAMEBUFFER_SET_GPIOVIRTBUF = 294944,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VSYNC = 294926,
	RPI_FIRMWARE_FRAMEBUFFER_SET_BACKLIGHT = 294927,
	RPI_FIRMWARE_VCHIQ_INIT = 294928,
	RPI_FIRMWARE_GET_COMMAND_LINE = 327681,
	RPI_FIRMWARE_GET_DMA_CHANNELS = 393217,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum rpmh_regulator_type {
	VRM = 0,
	XOB = 1,
};

enum rpmh_state {
	RPMH_SLEEP_STATE = 0,
	RPMH_WAKE_ONLY_STATE = 1,
	RPMH_ACTIVE_ONLY_STATE = 2,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rpu_oper_mode {
	PM_RPU_MODE_LOCKSTEP = 0,
	PM_RPU_MODE_SPLIT = 1,
};

enum rpu_tcm_comb {
	PM_RPU_TCM_SPLIT = 0,
	PM_RPU_TCM_COMB = 1,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	__RTA_MAX = 31,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	__RTNLGRP_MAX = 37,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum rzg2l_iolh_index {
	RZG2L_IOLH_IDX_1V8 = 0,
	RZG2L_IOLH_IDX_2V5 = 4,
	RZG2L_IOLH_IDX_3V3 = 8,
	RZG2L_IOLH_IDX_MAX = 12,
};

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s32_pins {
	S32G_MSCR_PA_00 = 0,
	S32G_MSCR_PA_01 = 1,
	S32G_MSCR_PA_02 = 2,
	S32G_MSCR_PA_03 = 3,
	S32G_MSCR_PA_04 = 4,
	S32G_MSCR_PA_05 = 5,
	S32G_MSCR_PA_06 = 6,
	S32G_MSCR_PA_07 = 7,
	S32G_MSCR_PA_08 = 8,
	S32G_MSCR_PA_09 = 9,
	S32G_MSCR_PA_10 = 10,
	S32G_MSCR_PA_11 = 11,
	S32G_MSCR_PA_12 = 12,
	S32G_MSCR_PA_13 = 13,
	S32G_MSCR_PA_14 = 14,
	S32G_MSCR_PA_15 = 15,
	S32G_MSCR_PB_00 = 16,
	S32G_MSCR_PB_01 = 17,
	S32G_MSCR_PB_02 = 18,
	S32G_MSCR_PB_03 = 19,
	S32G_MSCR_PB_04 = 20,
	S32G_MSCR_PB_05 = 21,
	S32G_MSCR_PB_06 = 22,
	S32G_MSCR_PB_07 = 23,
	S32G_MSCR_PB_08 = 24,
	S32G_MSCR_PB_09 = 25,
	S32G_MSCR_PB_10 = 26,
	S32G_MSCR_PB_11 = 27,
	S32G_MSCR_PB_12 = 28,
	S32G_MSCR_PB_13 = 29,
	S32G_MSCR_PB_14 = 30,
	S32G_MSCR_PB_15 = 31,
	S32G_MSCR_PC_00 = 32,
	S32G_MSCR_PC_01 = 33,
	S32G_MSCR_PC_02 = 34,
	S32G_MSCR_PC_03 = 35,
	S32G_MSCR_PC_04 = 36,
	S32G_MSCR_PC_05 = 37,
	S32G_MSCR_PC_06 = 38,
	S32G_MSCR_PC_07 = 39,
	S32G_MSCR_PC_08 = 40,
	S32G_MSCR_PC_09 = 41,
	S32G_MSCR_PC_10 = 42,
	S32G_MSCR_PC_11 = 43,
	S32G_MSCR_PC_12 = 44,
	S32G_MSCR_PC_13 = 45,
	S32G_MSCR_PC_14 = 46,
	S32G_MSCR_PC_15 = 47,
	S32G_MSCR_PD_00 = 48,
	S32G_MSCR_PD_01 = 49,
	S32G_MSCR_PD_02 = 50,
	S32G_MSCR_PD_03 = 51,
	S32G_MSCR_PD_04 = 52,
	S32G_MSCR_PD_05 = 53,
	S32G_MSCR_PD_06 = 54,
	S32G_MSCR_PD_07 = 55,
	S32G_MSCR_PD_08 = 56,
	S32G_MSCR_PD_09 = 57,
	S32G_MSCR_PD_10 = 58,
	S32G_MSCR_PD_11 = 59,
	S32G_MSCR_PD_12 = 60,
	S32G_MSCR_PD_13 = 61,
	S32G_MSCR_PD_14 = 62,
	S32G_MSCR_PD_15 = 63,
	S32G_MSCR_PE_00 = 64,
	S32G_MSCR_PE_01 = 65,
	S32G_MSCR_PE_02 = 66,
	S32G_MSCR_PE_03 = 67,
	S32G_MSCR_PE_04 = 68,
	S32G_MSCR_PE_05 = 69,
	S32G_MSCR_PE_06 = 70,
	S32G_MSCR_PE_07 = 71,
	S32G_MSCR_PE_08 = 72,
	S32G_MSCR_PE_09 = 73,
	S32G_MSCR_PE_10 = 74,
	S32G_MSCR_PE_11 = 75,
	S32G_MSCR_PE_12 = 76,
	S32G_MSCR_PE_13 = 77,
	S32G_MSCR_PE_14 = 78,
	S32G_MSCR_PE_15 = 79,
	S32G_MSCR_PF_00 = 80,
	S32G_MSCR_PF_01 = 81,
	S32G_MSCR_PF_02 = 82,
	S32G_MSCR_PF_03 = 83,
	S32G_MSCR_PF_04 = 84,
	S32G_MSCR_PF_05 = 85,
	S32G_MSCR_PF_06 = 86,
	S32G_MSCR_PF_07 = 87,
	S32G_MSCR_PF_08 = 88,
	S32G_MSCR_PF_09 = 89,
	S32G_MSCR_PF_10 = 90,
	S32G_MSCR_PF_11 = 91,
	S32G_MSCR_PF_12 = 92,
	S32G_MSCR_PF_13 = 93,
	S32G_MSCR_PF_14 = 94,
	S32G_MSCR_PF_15 = 95,
	S32G_MSCR_PG_00 = 96,
	S32G_MSCR_PG_01 = 97,
	S32G_MSCR_PG_02 = 98,
	S32G_MSCR_PG_03 = 99,
	S32G_MSCR_PG_04 = 100,
	S32G_MSCR_PG_05 = 101,
	S32G_MSCR_PH_00 = 112,
	S32G_MSCR_PH_01 = 113,
	S32G_MSCR_PH_02 = 114,
	S32G_MSCR_PH_03 = 115,
	S32G_MSCR_PH_04 = 116,
	S32G_MSCR_PH_05 = 117,
	S32G_MSCR_PH_06 = 118,
	S32G_MSCR_PH_07 = 119,
	S32G_MSCR_PH_08 = 120,
	S32G_MSCR_PH_09 = 121,
	S32G_MSCR_PH_10 = 122,
	S32G_MSCR_PJ_00 = 144,
	S32G_MSCR_PJ_01 = 145,
	S32G_MSCR_PJ_02 = 146,
	S32G_MSCR_PJ_03 = 147,
	S32G_MSCR_PJ_04 = 148,
	S32G_MSCR_PJ_05 = 149,
	S32G_MSCR_PJ_06 = 150,
	S32G_MSCR_PJ_07 = 151,
	S32G_MSCR_PJ_08 = 152,
	S32G_MSCR_PJ_09 = 153,
	S32G_MSCR_PJ_10 = 154,
	S32G_MSCR_PJ_11 = 155,
	S32G_MSCR_PJ_12 = 156,
	S32G_MSCR_PJ_13 = 157,
	S32G_MSCR_PJ_14 = 158,
	S32G_MSCR_PJ_15 = 159,
	S32G_MSCR_PK_00 = 160,
	S32G_MSCR_PK_01 = 161,
	S32G_MSCR_PK_02 = 162,
	S32G_MSCR_PK_03 = 163,
	S32G_MSCR_PK_04 = 164,
	S32G_MSCR_PK_05 = 165,
	S32G_MSCR_PK_06 = 166,
	S32G_MSCR_PK_07 = 167,
	S32G_MSCR_PK_08 = 168,
	S32G_MSCR_PK_09 = 169,
	S32G_MSCR_PK_10 = 170,
	S32G_MSCR_PK_11 = 171,
	S32G_MSCR_PK_12 = 172,
	S32G_MSCR_PK_13 = 173,
	S32G_MSCR_PK_14 = 174,
	S32G_MSCR_PK_15 = 175,
	S32G_MSCR_PL_00 = 176,
	S32G_MSCR_PL_01 = 177,
	S32G_MSCR_PL_02 = 178,
	S32G_MSCR_PL_03 = 179,
	S32G_MSCR_PL_04 = 180,
	S32G_MSCR_PL_05 = 181,
	S32G_MSCR_PL_06 = 182,
	S32G_MSCR_PL_07 = 183,
	S32G_MSCR_PL_08 = 184,
	S32G_MSCR_PL_09 = 185,
	S32G_MSCR_PL_10 = 186,
	S32G_MSCR_PL_11 = 187,
	S32G_MSCR_PL_12 = 188,
	S32G_MSCR_PL_13 = 189,
	S32G_MSCR_PL_14 = 190,
	S32G_IMCR_QSPI_A_DATA0 = 540,
	S32G_IMCR_QSPI_A_DATA1 = 541,
	S32G_IMCR_QSPI_A_DATA2 = 542,
	S32G_IMCR_QSPI_A_DATA3 = 543,
	S32G_IMCR_QSPI_A_DATA4 = 544,
	S32G_IMCR_QSPI_A_DATA5 = 545,
	S32G_IMCR_QSPI_A_DATA6 = 546,
	S32G_IMCR_QSPI_A_DATA7 = 547,
	S32G_IMCR_QSPI_DQS_A = 548,
	S32G_IMCR_QSPI_B_DATA0 = 552,
	S32G_IMCR_QSPI_B_DATA1 = 554,
	S32G_IMCR_QSPI_B_DATA2 = 551,
	S32G_IMCR_QSPI_B_DATA3 = 553,
	S32G_IMCR_QSPI_B_DATA4 = 557,
	S32G_IMCR_QSPI_B_DATA5 = 550,
	S32G_IMCR_QSPI_B_DATA6 = 556,
	S32G_IMCR_QSPI_B_DATA7 = 555,
	S32G_IMCR_QSPI_DQS_B = 558,
	S32G_IMCR_BOOT_BOOTMOD0 = 560,
	S32G_IMCR_BOOT_BOOTMOD1 = 561,
	S32G_IMCR_I2C0_SCL = 566,
	S32G_IMCR_I2C0_SDA = 565,
	S32G_IMCR_LIN0_RX = 512,
	S32G_IMCR_USDHC_CMD = 515,
	S32G_IMCR_USDHC_DAT0 = 516,
	S32G_IMCR_USDHC_DAT1 = 517,
	S32G_IMCR_USDHC_DAT2 = 520,
	S32G_IMCR_USDHC_DAT3 = 521,
	S32G_IMCR_USDHC_DAT4 = 522,
	S32G_IMCR_USDHC_DAT5 = 523,
	S32G_IMCR_USDHC_DAT6 = 519,
	S32G_IMCR_USDHC_DAT7 = 518,
	S32G_IMCR_USDHC_DQS = 524,
	S32G_IMCR_CAN0_RXD = 513,
	S32G_IMCR_CAN1_RXD = 631,
	S32G_IMCR_CAN2_RXD = 632,
	S32G_IMCR_CAN3_RXD = 633,
	S32G_IMCR_Ethernet_MDIO = 527,
	S32G_IMCR_Ethernet_CRS = 526,
	S32G_IMCR_Ethernet_COL = 525,
	S32G_IMCR_Ethernet_RX_D0 = 531,
	S32G_IMCR_Ethernet_RX_D1 = 532,
	S32G_IMCR_Ethernet_RX_D2 = 533,
	S32G_IMCR_Ethernet_RX_D3 = 534,
	S32G_IMCR_Ethernet_RX_ER = 528,
	S32G_IMCR_Ethernet_RX_CLK = 529,
	S32G_IMCR_Ethernet_RX_DV = 530,
	S32G_IMCR_Ethernet_TX_CLK = 538,
	S32G_IMCR_Ethernet_REF_CLK = 535,
	S32G_IMCR_PFE_EMAC_1_MDIO = 857,
	S32G_IMCR_PFE_EMAC_1_CRS = 856,
	S32G_IMCR_PFE_EMAC_1_COL = 855,
	S32G_IMCR_PFE_EMAC_1_RX_D0 = 861,
	S32G_IMCR_PFE_EMAC_1_RX_D1 = 862,
	S32G_IMCR_PFE_EMAC_1_RX_D2 = 863,
	S32G_IMCR_PFE_EMAC_1_RX_D3 = 864,
	S32G_IMCR_PFE_EMAC_1_RX_ER = 860,
	S32G_IMCR_PFE_EMAC_1_RX_CLK = 859,
	S32G_IMCR_PFE_EMAC_1_RX_DV = 865,
	S32G_IMCR_PFE_EMAC_1_TX_CLK = 866,
	S32G_IMCR_PFE_EMAC_1_REF_CLK = 858,
	S32G_IMCR_PFE_EMAC_2_MDIO = 877,
	S32G_IMCR_PFE_EMAC_2_CRS = 876,
	S32G_IMCR_PFE_EMAC_2_COL = 875,
	S32G_IMCR_PFE_EMAC_2_RX_D0 = 881,
	S32G_IMCR_PFE_EMAC_2_RX_D1 = 882,
	S32G_IMCR_PFE_EMAC_2_RX_D2 = 883,
	S32G_IMCR_PFE_EMAC_2_RX_D3 = 884,
	S32G_IMCR_PFE_EMAC_2_RX_ER = 880,
	S32G_IMCR_PFE_EMAC_2_RX_CLK = 879,
	S32G_IMCR_PFE_EMAC_2_RX_DV = 885,
	S32G_IMCR_PFE_EMAC_2_TX_CLK = 886,
	S32G_IMCR_PFE_EMAC_2_REF_CLK = 878,
	S32G_IMCR_FlexRay0_A_RX = 785,
	S32G_IMCR_FlexRay0_B_RX = 786,
	S32G_IMCR_FlexTimer0_CH0 = 655,
	S32G_IMCR_FlexTimer1_CH0 = 665,
	S32G_IMCR_FlexTimer0_CH1 = 656,
	S32G_IMCR_FlexTimer1_CH1 = 666,
	S32G_IMCR_FlexTimer0_CH2 = 657,
	S32G_IMCR_FlexTimer1_CH2 = 667,
	S32G_IMCR_FlexTimer0_CH3 = 658,
	S32G_IMCR_FlexTimer1_CH3 = 668,
	S32G_IMCR_FlexTimer0_CH4 = 659,
	S32G_IMCR_FlexTimer1_CH4 = 669,
	S32G_IMCR_FlexTimer0_CH5 = 660,
	S32G_IMCR_FlexTimer1_CH5 = 670,
	S32G_IMCR_FlexTimer0_EXTCLK = 661,
	S32G_IMCR_FlexTimer1_EXTCLK = 671,
	S32G_IMCR_I2C1_SCL = 717,
	S32G_IMCR_I2C1_SDA = 718,
	S32G_IMCR_I2C2_SCL = 719,
	S32G_IMCR_I2C2_SDA = 720,
	S32G_IMCR_I2C3_SCL = 721,
	S32G_IMCR_I2C3_SDA = 722,
	S32G_IMCR_I2C4_SCL = 723,
	S32G_IMCR_I2C4_SDA = 724,
	S32G_IMCR_LIN1_RX = 736,
	S32G_IMCR_LIN2_RX = 737,
	S32G_IMCR_DSPI0_PCS0 = 980,
	S32G_IMCR_DSPI0_SCK = 981,
	S32G_IMCR_DSPI0_SIN = 982,
	S32G_IMCR_DSPI1_PCS0 = 985,
	S32G_IMCR_DSPI1_SCK = 986,
	S32G_IMCR_DSPI1_SIN = 987,
	S32G_IMCR_DSPI2_PCS0 = 990,
	S32G_IMCR_DSPI2_SCK = 991,
	S32G_IMCR_DSPI2_SIN = 992,
	S32G_IMCR_DSPI3_PCS0 = 995,
	S32G_IMCR_DSPI3_SCK = 996,
	S32G_IMCR_DSPI3_SIN = 997,
	S32G_IMCR_DSPI4_PCS0 = 1000,
	S32G_IMCR_DSPI4_SCK = 1001,
	S32G_IMCR_DSPI4_SIN = 1002,
	S32G_IMCR_DSPI5_PCS0 = 1005,
	S32G_IMCR_DSPI5_SCK = 1006,
	S32G_IMCR_DSPI5_SIN = 1007,
	S32G_IMCR_LLCE_CAN0_RXD = 745,
	S32G_IMCR_LLCE_CAN1_RXD = 746,
	S32G_IMCR_LLCE_CAN2_RXD = 747,
	S32G_IMCR_LLCE_CAN3_RXD = 748,
	S32G_IMCR_LLCE_CAN4_RXD = 749,
	S32G_IMCR_LLCE_CAN5_RXD = 750,
	S32G_IMCR_LLCE_CAN6_RXD = 751,
	S32G_IMCR_LLCE_CAN7_RXD = 752,
	S32G_IMCR_LLCE_CAN8_RXD = 753,
	S32G_IMCR_LLCE_CAN9_RXD = 754,
	S32G_IMCR_LLCE_CAN10_RXD = 755,
	S32G_IMCR_LLCE_CAN11_RXD = 756,
	S32G_IMCR_LLCE_CAN12_RXD = 757,
	S32G_IMCR_LLCE_CAN13_RXD = 758,
	S32G_IMCR_LLCE_CAN14_RXD = 759,
	S32G_IMCR_LLCE_CAN15_RXD = 760,
	S32G_IMCR_USB_CLK = 895,
	S32G_IMCR_USB_DATA0 = 896,
	S32G_IMCR_USB_DATA1 = 897,
	S32G_IMCR_USB_DATA2 = 898,
	S32G_IMCR_USB_DATA3 = 899,
	S32G_IMCR_USB_DATA4 = 900,
	S32G_IMCR_USB_DATA5 = 901,
	S32G_IMCR_USB_DATA6 = 902,
	S32G_IMCR_USB_DATA7 = 903,
	S32G_IMCR_USB_DIR = 904,
	S32G_IMCR_USB_NXT = 905,
	S32G_IMCR_SIUL_EIRQ0 = 910,
	S32G_IMCR_SIUL_EIRQ1 = 911,
	S32G_IMCR_SIUL_EIRQ2 = 912,
	S32G_IMCR_SIUL_EIRQ3 = 913,
	S32G_IMCR_SIUL_EIRQ4 = 914,
	S32G_IMCR_SIUL_EIRQ5 = 915,
	S32G_IMCR_SIUL_EIRQ6 = 916,
	S32G_IMCR_SIUL_EIRQ7 = 917,
	S32G_IMCR_SIUL_EIRQ8 = 918,
	S32G_IMCR_SIUL_EIRQ9 = 919,
	S32G_IMCR_SIUL_EIRQ10 = 920,
	S32G_IMCR_SIUL_EIRQ11 = 921,
	S32G_IMCR_SIUL_EIRQ12 = 922,
	S32G_IMCR_SIUL_EIRQ13 = 923,
	S32G_IMCR_SIUL_EIRQ14 = 924,
	S32G_IMCR_SIUL_EIRQ15 = 925,
	S32G_IMCR_SIUL_EIRQ16 = 926,
	S32G_IMCR_SIUL_EIRQ17 = 927,
	S32G_IMCR_SIUL_EIRQ18 = 928,
	S32G_IMCR_SIUL_EIRQ19 = 929,
	S32G_IMCR_SIUL_EIRQ20 = 930,
	S32G_IMCR_SIUL_EIRQ21 = 931,
	S32G_IMCR_SIUL_EIRQ22 = 932,
	S32G_IMCR_SIUL_EIRQ23 = 933,
	S32G_IMCR_SIUL_EIRQ24 = 934,
	S32G_IMCR_SIUL_EIRQ25 = 935,
	S32G_IMCR_SIUL_EIRQ26 = 936,
	S32G_IMCR_SIUL_EIRQ27 = 937,
	S32G_IMCR_SIUL_EIRQ28 = 938,
	S32G_IMCR_SIUL_EIRQ29 = 939,
	S32G_IMCR_SIUL_EIRQ30 = 940,
	S32G_IMCR_SIUL_EIRQ31 = 941,
};

enum s32_write_type {
	S32_PINCONF_UPDATE_ONLY = 0,
	S32_PINCONF_OVERWRITE = 1,
};

enum s3c24xx_port_type {
	TYPE_S3C6400 = 0,
	TYPE_APPLE_S5L = 1,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum sc7180_functions {
	msm_mux_adsp_ext = 0,
	msm_mux_agera_pll = 1,
	msm_mux_aoss_cti = 2,
	msm_mux_atest_char = 3,
	msm_mux_atest_char0 = 4,
	msm_mux_atest_char1 = 5,
	msm_mux_atest_char2 = 6,
	msm_mux_atest_char3 = 7,
	msm_mux_atest_tsens = 8,
	msm_mux_atest_tsens2 = 9,
	msm_mux_atest_usb1 = 10,
	msm_mux_atest_usb2 = 11,
	msm_mux_atest_usb10 = 12,
	msm_mux_atest_usb11 = 13,
	msm_mux_atest_usb12 = 14,
	msm_mux_atest_usb13 = 15,
	msm_mux_atest_usb20 = 16,
	msm_mux_atest_usb21 = 17,
	msm_mux_atest_usb22 = 18,
	msm_mux_atest_usb23 = 19,
	msm_mux_audio_ref = 20,
	msm_mux_btfm_slimbus = 21,
	msm_mux_cam_mclk = 22,
	msm_mux_cci_async = 23,
	msm_mux_cci_i2c = 24,
	msm_mux_cci_timer0 = 25,
	msm_mux_cci_timer1 = 26,
	msm_mux_cci_timer2 = 27,
	msm_mux_cci_timer3 = 28,
	msm_mux_cci_timer4 = 29,
	msm_mux_cri_trng = 30,
	msm_mux_dbg_out = 31,
	msm_mux_ddr_bist = 32,
	msm_mux_ddr_pxi0 = 33,
	msm_mux_ddr_pxi1 = 34,
	msm_mux_ddr_pxi2 = 35,
	msm_mux_ddr_pxi3 = 36,
	msm_mux_dp_hot = 37,
	msm_mux_edp_lcd = 38,
	msm_mux_gcc_gp1 = 39,
	msm_mux_gcc_gp2 = 40,
	msm_mux_gcc_gp3 = 41,
	msm_mux_gpio = 42,
	msm_mux_gp_pdm0 = 43,
	msm_mux_gp_pdm1 = 44,
	msm_mux_gp_pdm2 = 45,
	msm_mux_gps_tx = 46,
	msm_mux_jitter_bist = 47,
	msm_mux_ldo_en = 48,
	msm_mux_ldo_update = 49,
	msm_mux_lpass_ext = 50,
	msm_mux_mdp_vsync = 51,
	msm_mux_mdp_vsync0 = 52,
	msm_mux_mdp_vsync1 = 53,
	msm_mux_mdp_vsync2 = 54,
	msm_mux_mdp_vsync3 = 55,
	msm_mux_mi2s_1 = 56,
	msm_mux_mi2s_0 = 57,
	msm_mux_mi2s_2 = 58,
	msm_mux_mss_lte = 59,
	msm_mux_m_voc = 60,
	msm_mux_pa_indicator = 61,
	msm_mux_phase_flag = 62,
	msm_mux_PLL_BIST = 63,
	msm_mux_pll_bypassnl = 64,
	msm_mux_pll_reset = 65,
	msm_mux_prng_rosc = 66,
	msm_mux_qdss = 67,
	msm_mux_qdss_cti = 68,
	msm_mux_qlink_enable = 69,
	msm_mux_qlink_request = 70,
	msm_mux_qspi_clk = 71,
	msm_mux_qspi_cs = 72,
	msm_mux_qspi_data = 73,
	msm_mux_qup00 = 74,
	msm_mux_qup01 = 75,
	msm_mux_qup02_i2c = 76,
	msm_mux_qup02_uart = 77,
	msm_mux_qup03 = 78,
	msm_mux_qup04_i2c = 79,
	msm_mux_qup04_uart = 80,
	msm_mux_qup05 = 81,
	msm_mux_qup10 = 82,
	msm_mux_qup11_i2c = 83,
	msm_mux_qup11_uart = 84,
	msm_mux_qup12 = 85,
	msm_mux_qup13_i2c = 86,
	msm_mux_qup13_uart = 87,
	msm_mux_qup14 = 88,
	msm_mux_qup15 = 89,
	msm_mux_sdc1_tb = 90,
	msm_mux_sdc2_tb = 91,
	msm_mux_sd_write = 92,
	msm_mux_sp_cmu = 93,
	msm_mux_tgu_ch0 = 94,
	msm_mux_tgu_ch1 = 95,
	msm_mux_tgu_ch2 = 96,
	msm_mux_tgu_ch3 = 97,
	msm_mux_tsense_pwm1 = 98,
	msm_mux_tsense_pwm2 = 99,
	msm_mux_uim1 = 100,
	msm_mux_uim2 = 101,
	msm_mux_uim_batt = 102,
	msm_mux_usb_phy = 103,
	msm_mux_vfr_1 = 104,
	msm_mux__V_GPIO = 105,
	msm_mux__V_PPS_IN = 106,
	msm_mux__V_PPS_OUT = 107,
	msm_mux_vsense_trigger = 108,
	msm_mux_wlan1_adc0 = 109,
	msm_mux_wlan1_adc1 = 110,
	msm_mux_wlan2_adc0 = 111,
	msm_mux_wlan2_adc1 = 112,
	msm_mux__ = 113,
};

enum scale_freq_source {
	SCALE_FREQ_SOURCE_CPUFREQ = 0,
	SCALE_FREQ_SOURCE_ARCH = 1,
	SCALE_FREQ_SOURCE_CPPC = 2,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_PAGE_RO = 11,
	SCAN_LACK_REFERENCED_PAGE = 12,
	SCAN_PAGE_NULL = 13,
	SCAN_SCAN_ABORT = 14,
	SCAN_PAGE_COUNT = 15,
	SCAN_PAGE_LRU = 16,
	SCAN_PAGE_LOCK = 17,
	SCAN_PAGE_ANON = 18,
	SCAN_PAGE_COMPOUND = 19,
	SCAN_ANY_PROCESS = 20,
	SCAN_VMA_NULL = 21,
	SCAN_VMA_CHECK = 22,
	SCAN_ADDRESS_RANGE = 23,
	SCAN_DEL_PAGE_LRU = 24,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 25,
	SCAN_CGROUP_CHARGE_FAIL = 26,
	SCAN_TRUNCATED = 27,
	SCAN_PAGE_HAS_PRIVATE = 28,
	SCAN_STORE_FAILED = 29,
	SCAN_COPY_MC = 30,
	SCAN_PAGE_FILLED = 31,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scmi_bad_msg {
	MSG_UNEXPECTED = -1,
	MSG_INVALID = -2,
	MSG_UNKNOWN = -3,
	MSG_NOMEM = -4,
	MSG_MBOX_SPURIOUS = -5,
};

enum scmi_base_protocol_cmd {
	BASE_DISCOVER_VENDOR = 3,
	BASE_DISCOVER_SUB_VENDOR = 4,
	BASE_DISCOVER_IMPLEMENT_VERSION = 5,
	BASE_DISCOVER_LIST_PROTOCOLS = 6,
	BASE_DISCOVER_AGENT = 7,
	BASE_NOTIFY_ERRORS = 8,
	BASE_SET_DEVICE_PERMISSIONS = 9,
	BASE_SET_PROTOCOL_PERMISSIONS = 10,
	BASE_RESET_AGENT_CONFIGURATION = 11,
};

enum scmi_clk_feats {
	SCMI_CLK_ATOMIC_SUPPORTED = 0,
	SCMI_CLK_STATE_CTRL_SUPPORTED = 1,
	SCMI_CLK_RATE_CTRL_SUPPORTED = 2,
	SCMI_CLK_PARENT_CTRL_SUPPORTED = 3,
	SCMI_CLK_DUTY_CYCLE_SUPPORTED = 4,
	SCMI_CLK_FEATS_COUNT = 5,
};

enum scmi_clock_oem_config {
	SCMI_CLOCK_CFG_DUTY_CYCLE = 1,
	SCMI_CLOCK_CFG_PHASE = 2,
	SCMI_CLOCK_CFG_OEM_START = 128,
	SCMI_CLOCK_CFG_OEM_END = 255,
};

enum scmi_clock_protocol_cmd {
	CLOCK_ATTRIBUTES = 3,
	CLOCK_DESCRIBE_RATES = 4,
	CLOCK_RATE_SET = 5,
	CLOCK_RATE_GET = 6,
	CLOCK_CONFIG_SET = 7,
	CLOCK_NAME_GET = 8,
	CLOCK_RATE_NOTIFY = 9,
	CLOCK_RATE_CHANGE_REQUESTED_NOTIFY = 10,
	CLOCK_CONFIG_GET = 11,
	CLOCK_POSSIBLE_PARENTS_GET = 12,
	CLOCK_PARENT_SET = 13,
	CLOCK_PARENT_GET = 14,
	CLOCK_GET_PERMISSIONS = 15,
};

enum scmi_common_cmd {
	PROTOCOL_VERSION = 0,
	PROTOCOL_ATTRIBUTES = 1,
	PROTOCOL_MESSAGE_ATTRIBUTES = 2,
	NEGOTIATE_PROTOCOL_VERSION = 16,
};

enum scmi_error_codes {
	SCMI_SUCCESS = 0,
	SCMI_ERR_SUPPORT = -1,
	SCMI_ERR_PARAMS = -2,
	SCMI_ERR_ACCESS = -3,
	SCMI_ERR_ENTRY = -4,
	SCMI_ERR_RANGE = -5,
	SCMI_ERR_BUSY = -6,
	SCMI_ERR_COMMS = -7,
	SCMI_ERR_GENERIC = -8,
	SCMI_ERR_HARDWARE = -9,
	SCMI_ERR_PROTOCOL = -10,
};

enum scmi_imx_bbm_protocol_cmd {
	IMX_BBM_GPR_SET = 3,
	IMX_BBM_GPR_GET = 4,
	IMX_BBM_RTC_ATTRIBUTES = 5,
	IMX_BBM_RTC_TIME_SET = 6,
	IMX_BBM_RTC_TIME_GET = 7,
	IMX_BBM_RTC_ALARM_SET = 8,
	IMX_BBM_BUTTON_GET = 9,
	IMX_BBM_RTC_NOTIFY = 10,
	IMX_BBM_BUTTON_NOTIFY = 11,
};

enum scmi_notification_events {
	SCMI_EVENT_POWER_STATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGE_REQUESTED = 1,
	SCMI_EVENT_PERFORMANCE_LIMITS_CHANGED = 0,
	SCMI_EVENT_PERFORMANCE_LEVEL_CHANGED = 1,
	SCMI_EVENT_SENSOR_TRIP_POINT_EVENT = 0,
	SCMI_EVENT_SENSOR_UPDATE = 1,
	SCMI_EVENT_RESET_ISSUED = 0,
	SCMI_EVENT_BASE_ERROR_EVENT = 0,
	SCMI_EVENT_SYSTEM_POWER_STATE_NOTIFIER = 0,
	SCMI_EVENT_POWERCAP_CAP_CHANGED = 0,
	SCMI_EVENT_POWERCAP_MEASUREMENTS_CHANGED = 1,
};

enum scmi_nxp_notification_events {
	SCMI_EVENT_IMX_BBM_RTC = 0,
	SCMI_EVENT_IMX_BBM_BUTTON = 1,
	SCMI_EVENT_IMX_MISC_CONTROL = 0,
};

enum scmi_nxp_protocol {
	SCMI_PROTOCOL_IMX_BBM = 129,
	SCMI_PROTOCOL_IMX_MISC = 132,
};

enum scmi_performance_protocol_cmd {
	PERF_DOMAIN_ATTRIBUTES = 3,
	PERF_DESCRIBE_LEVELS = 4,
	PERF_LIMITS_SET = 5,
	PERF_LIMITS_GET = 6,
	PERF_LEVEL_SET = 7,
	PERF_LEVEL_GET = 8,
	PERF_NOTIFY_LIMITS = 9,
	PERF_NOTIFY_LEVEL = 10,
	PERF_DESCRIBE_FASTCHANNEL = 11,
	PERF_DOMAIN_NAME_GET = 12,
};

enum scmi_pinctrl_conf_type {
	SCMI_PIN_DEFAULT = 0,
	SCMI_PIN_BIAS_BUS_HOLD = 1,
	SCMI_PIN_BIAS_DISABLE = 2,
	SCMI_PIN_BIAS_HIGH_IMPEDANCE = 3,
	SCMI_PIN_BIAS_PULL_UP = 4,
	SCMI_PIN_BIAS_PULL_DEFAULT = 5,
	SCMI_PIN_BIAS_PULL_DOWN = 6,
	SCMI_PIN_DRIVE_OPEN_DRAIN = 7,
	SCMI_PIN_DRIVE_OPEN_SOURCE = 8,
	SCMI_PIN_DRIVE_PUSH_PULL = 9,
	SCMI_PIN_DRIVE_STRENGTH = 10,
	SCMI_PIN_INPUT_DEBOUNCE = 11,
	SCMI_PIN_INPUT_MODE = 12,
	SCMI_PIN_PULL_MODE = 13,
	SCMI_PIN_INPUT_VALUE = 14,
	SCMI_PIN_INPUT_SCHMITT = 15,
	SCMI_PIN_LOW_POWER_MODE = 16,
	SCMI_PIN_OUTPUT_MODE = 17,
	SCMI_PIN_OUTPUT_VALUE = 18,
	SCMI_PIN_POWER_SOURCE = 19,
	SCMI_PIN_SLEW_RATE = 20,
	SCMI_PIN_OEM_START = 192,
	SCMI_PIN_OEM_END = 255,
};

enum scmi_pinctrl_protocol_cmd {
	PINCTRL_ATTRIBUTES = 3,
	PINCTRL_LIST_ASSOCIATIONS = 4,
	PINCTRL_SETTINGS_GET = 5,
	PINCTRL_SETTINGS_CONFIGURE = 6,
	PINCTRL_REQUEST = 7,
	PINCTRL_RELEASE = 8,
	PINCTRL_NAME_GET = 9,
	PINCTRL_SET_PERMISSIONS = 10,
};

enum scmi_pinctrl_selector_type {
	PIN_TYPE = 0,
	GROUP_TYPE = 1,
	FUNCTION_TYPE = 2,
};

enum scmi_power_protocol_cmd {
	POWER_DOMAIN_ATTRIBUTES = 3,
	POWER_STATE_SET = 4,
	POWER_STATE_GET = 5,
	POWER_STATE_NOTIFY = 6,
	POWER_DOMAIN_NAME_GET = 8,
};

enum scmi_power_scale {
	SCMI_POWER_BOGOWATTS = 0,
	SCMI_POWER_MILLIWATTS = 1,
	SCMI_POWER_MICROWATTS = 2,
};

enum scmi_powercap_protocol_cmd {
	POWERCAP_DOMAIN_ATTRIBUTES = 3,
	POWERCAP_CAP_GET = 4,
	POWERCAP_CAP_SET = 5,
	POWERCAP_PAI_GET = 6,
	POWERCAP_PAI_SET = 7,
	POWERCAP_DOMAIN_NAME_GET = 8,
	POWERCAP_MEASUREMENTS_GET = 9,
	POWERCAP_CAP_NOTIFY = 10,
	POWERCAP_MEASUREMENTS_NOTIFY = 11,
	POWERCAP_DESCRIBE_FASTCHANNEL = 12,
};

enum scmi_reset_protocol_cmd {
	RESET_DOMAIN_ATTRIBUTES = 3,
	RESET = 4,
	RESET_NOTIFY = 5,
	RESET_DOMAIN_NAME_GET = 6,
};

enum scmi_sensor_protocol_cmd {
	SENSOR_DESCRIPTION_GET = 3,
	SENSOR_TRIP_POINT_NOTIFY = 4,
	SENSOR_TRIP_POINT_CONFIG = 5,
	SENSOR_READING_GET = 6,
	SENSOR_AXIS_DESCRIPTION_GET = 7,
	SENSOR_LIST_UPDATE_INTERVALS = 8,
	SENSOR_CONFIG_GET = 9,
	SENSOR_CONFIG_SET = 10,
	SENSOR_CONTINUOUS_UPDATE_NOTIFY = 11,
	SENSOR_NAME_GET = 12,
	SENSOR_AXIS_NAME_GET = 13,
};

enum scmi_std_protocol {
	SCMI_PROTOCOL_BASE = 16,
	SCMI_PROTOCOL_POWER = 17,
	SCMI_PROTOCOL_SYSTEM = 18,
	SCMI_PROTOCOL_PERF = 19,
	SCMI_PROTOCOL_CLOCK = 20,
	SCMI_PROTOCOL_SENSOR = 21,
	SCMI_PROTOCOL_RESET = 22,
	SCMI_PROTOCOL_VOLTAGE = 23,
	SCMI_PROTOCOL_POWERCAP = 24,
	SCMI_PROTOCOL_PINCTRL = 25,
};

enum scmi_syspower_state {
	SCMI_SYSPOWER_IDLE = 0,
	SCMI_SYSPOWER_IN_PROGRESS = 1,
	SCMI_SYSPOWER_REBOOTING = 2,
};

enum scmi_system_events {
	SCMI_SYSTEM_SHUTDOWN = 0,
	SCMI_SYSTEM_COLDRESET = 1,
	SCMI_SYSTEM_WARMRESET = 2,
	SCMI_SYSTEM_POWERUP = 3,
	SCMI_SYSTEM_SUSPEND = 4,
	SCMI_SYSTEM_MAX = 5,
};

enum scmi_system_protocol_cmd {
	SYSTEM_POWER_STATE_NOTIFY = 5,
};

enum scmi_voltage_level_mode {
	SCMI_VOLTAGE_LEVEL_SET_AUTO = 0,
	SCMI_VOLTAGE_LEVEL_SET_SYNC = 1,
};

enum scmi_voltage_protocol_cmd {
	VOLTAGE_DOMAIN_ATTRIBUTES = 3,
	VOLTAGE_DESCRIBE_LEVELS = 4,
	VOLTAGE_CONFIG_SET = 5,
	VOLTAGE_CONFIG_GET = 6,
	VOLTAGE_LEVEL_SET = 7,
	VOLTAGE_LEVEL_GET = 8,
	VOLTAGE_DOMAIN_NAME_GET = 9,
};

enum scrub_stripe_flags {
	SCRUB_STRIPE_FLAG_INITIALIZED = 0,
	SCRUB_STRIPE_FLAG_REPAIR_DONE = 1,
	SCRUB_STRIPE_FLAG_NO_REPORT = 2,
};

enum scrub_type {
	SCRUB_UNKNOWN = 0,
	SCRUB_NONE = 1,
	SCRUB_SW_PROG = 2,
	SCRUB_SW_SRC = 3,
	SCRUB_SW_PROG_SRC = 4,
	SCRUB_SW_TUNABLE = 5,
	SCRUB_HW_PROG = 6,
	SCRUB_HW_SRC = 7,
	SCRUB_HW_PROG_SRC = 8,
	SCRUB_HW_TUNABLE = 9,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 10000,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_cid {
	SCTP_CID_DATA = 0,
	SCTP_CID_INIT = 1,
	SCTP_CID_INIT_ACK = 2,
	SCTP_CID_SACK = 3,
	SCTP_CID_HEARTBEAT = 4,
	SCTP_CID_HEARTBEAT_ACK = 5,
	SCTP_CID_ABORT = 6,
	SCTP_CID_SHUTDOWN = 7,
	SCTP_CID_SHUTDOWN_ACK = 8,
	SCTP_CID_ERROR = 9,
	SCTP_CID_COOKIE_ECHO = 10,
	SCTP_CID_COOKIE_ACK = 11,
	SCTP_CID_ECN_ECNE = 12,
	SCTP_CID_ECN_CWR = 13,
	SCTP_CID_SHUTDOWN_COMPLETE = 14,
	SCTP_CID_AUTH = 15,
	SCTP_CID_I_DATA = 64,
	SCTP_CID_FWD_TSN = 192,
	SCTP_CID_ASCONF = 193,
	SCTP_CID_I_FWD_TSN = 194,
	SCTP_CID_ASCONF_ACK = 128,
	SCTP_CID_RECONF = 130,
	SCTP_CID_PAD = 132,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_endpoint_type {
	SCTP_EP_TYPE_SOCKET = 0,
	SCTP_EP_TYPE_ASSOCIATION = 1,
};

enum sctp_event_timeout {
	SCTP_EVENT_TIMEOUT_NONE = 0,
	SCTP_EVENT_TIMEOUT_T1_COOKIE = 1,
	SCTP_EVENT_TIMEOUT_T1_INIT = 2,
	SCTP_EVENT_TIMEOUT_T2_SHUTDOWN = 3,
	SCTP_EVENT_TIMEOUT_T3_RTX = 4,
	SCTP_EVENT_TIMEOUT_T4_RTO = 5,
	SCTP_EVENT_TIMEOUT_T5_SHUTDOWN_GUARD = 6,
	SCTP_EVENT_TIMEOUT_HEARTBEAT = 7,
	SCTP_EVENT_TIMEOUT_RECONF = 8,
	SCTP_EVENT_TIMEOUT_PROBE = 9,
	SCTP_EVENT_TIMEOUT_SACK = 10,
	SCTP_EVENT_TIMEOUT_AUTOCLOSE = 11,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum sctp_param {
	SCTP_PARAM_HEARTBEAT_INFO = 256,
	SCTP_PARAM_IPV4_ADDRESS = 1280,
	SCTP_PARAM_IPV6_ADDRESS = 1536,
	SCTP_PARAM_STATE_COOKIE = 1792,
	SCTP_PARAM_UNRECOGNIZED_PARAMETERS = 2048,
	SCTP_PARAM_COOKIE_PRESERVATIVE = 2304,
	SCTP_PARAM_HOST_NAME_ADDRESS = 2816,
	SCTP_PARAM_SUPPORTED_ADDRESS_TYPES = 3072,
	SCTP_PARAM_ECN_CAPABLE = 128,
	SCTP_PARAM_RANDOM = 640,
	SCTP_PARAM_CHUNKS = 896,
	SCTP_PARAM_HMAC_ALGO = 1152,
	SCTP_PARAM_SUPPORTED_EXT = 2176,
	SCTP_PARAM_FWD_TSN_SUPPORT = 192,
	SCTP_PARAM_ADD_IP = 448,
	SCTP_PARAM_DEL_IP = 704,
	SCTP_PARAM_ERR_CAUSE = 960,
	SCTP_PARAM_SET_PRIMARY = 1216,
	SCTP_PARAM_SUCCESS_REPORT = 1472,
	SCTP_PARAM_ADAPTATION_LAYER_IND = 1728,
	SCTP_PARAM_RESET_OUT_REQUEST = 3328,
	SCTP_PARAM_RESET_IN_REQUEST = 3584,
	SCTP_PARAM_RESET_TSN_REQUEST = 3840,
	SCTP_PARAM_RESET_RESPONSE = 4096,
	SCTP_PARAM_RESET_ADD_OUT_STREAMS = 4352,
	SCTP_PARAM_RESET_ADD_IN_STREAMS = 4608,
};

enum sctp_scope {
	SCTP_SCOPE_GLOBAL = 0,
	SCTP_SCOPE_PRIVATE = 1,
	SCTP_SCOPE_LINK = 2,
	SCTP_SCOPE_LOOPBACK = 3,
	SCTP_SCOPE_UNUSABLE = 4,
};

enum sctp_socket_type {
	SCTP_SOCKET_UDP = 0,
	SCTP_SOCKET_UDP_HIGH_BANDWIDTH = 1,
	SCTP_SOCKET_TCP = 2,
};

enum sctp_state {
	SCTP_STATE_CLOSED = 0,
	SCTP_STATE_COOKIE_WAIT = 1,
	SCTP_STATE_COOKIE_ECHOED = 2,
	SCTP_STATE_ESTABLISHED = 3,
	SCTP_STATE_SHUTDOWN_PENDING = 4,
	SCTP_STATE_SHUTDOWN_SENT = 5,
	SCTP_STATE_SHUTDOWN_RECEIVED = 6,
	SCTP_STATE_SHUTDOWN_ACK_SENT = 7,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 30000,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_OPS_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 29,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 29,
	SCX_OPI_CPU_HOTPLUG_END = 31,
	SCX_OPI_END = 31,
};

enum scx_ops_enable_state {
	SCX_OPS_ENABLING = 0,
	SCX_OPS_ENABLED = 1,
	SCX_OPS_DISABLING = 2,
	SCX_OPS_DISABLED = 3,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1,
	SCX_OPS_ENQ_LAST = 2,
	SCX_OPS_ENQ_EXITING = 4,
	SCX_OPS_SWITCH_PARTIAL = 8,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536,
	SCX_OPS_ALL_FLAGS = 65551,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum security_cmd_enabled_bits {
	CXL_SEC_ENABLED_SANITIZE = 0,
	CXL_SEC_ENABLED_SECURE_ERASE = 1,
	CXL_SEC_ENABLED_GET_SECURITY_STATE = 2,
	CXL_SEC_ENABLED_SET_PASSPHRASE = 3,
	CXL_SEC_ENABLED_DISABLE_PASSPHRASE = 4,
	CXL_SEC_ENABLED_UNLOCK = 5,
	CXL_SEC_ENABLED_FREEZE_SECURITY = 6,
	CXL_SEC_ENABLED_PASSPHRASE_SECURE_ERASE = 7,
	CXL_SEC_ENABLED_MAX = 8,
};

enum seg6_end_dt_mode {
	DT_INVALID_MODE = -22,
	DT_LEGACY_MODE = 0,
	DT_VRF_MODE = 1,
};

enum seg6_local_flv_action {
	SEG6_LOCAL_FLV_ACT_UNSPEC = 0,
	SEG6_LOCAL_FLV_ACT_END = 1,
	SEG6_LOCAL_FLV_ACT_PSP = 2,
	SEG6_LOCAL_FLV_ACT_USP = 3,
	SEG6_LOCAL_FLV_ACT_USD = 4,
	__SEG6_LOCAL_FLV_ACT_MAX = 5,
};

enum seg6_local_pktinfo {
	SEG6_LOCAL_PKTINFO_NOHDR = 0,
	SEG6_LOCAL_PKTINFO_SL_ZERO = 1,
	SEG6_LOCAL_PKTINFO_SL_ONE = 2,
	SEG6_LOCAL_PKTINFO_SL_MORE = 3,
	__SEG6_LOCAL_PKTINFO_MAX = 4,
};

enum sel_inos {
	SEL_ROOT_INO = 2,
	SEL_LOAD = 3,
	SEL_ENFORCE = 4,
	SEL_CONTEXT = 5,
	SEL_ACCESS = 6,
	SEL_CREATE = 7,
	SEL_RELABEL = 8,
	SEL_USER = 9,
	SEL_POLICYVERS = 10,
	SEL_COMMIT_BOOLS = 11,
	SEL_MLS = 12,
	SEL_DISABLE = 13,
	SEL_MEMBER = 14,
	SEL_CHECKREQPROT = 15,
	SEL_COMPAT_NET = 16,
	SEL_REJECT_UNKNOWN = 17,
	SEL_DENY_UNKNOWN = 18,
	SEL_STATUS = 19,
	SEL_POLICY = 20,
	SEL_VALIDATE_TRANS = 21,
	SEL_INO_NEXT = 22,
};

enum selinux_nlgroups {
	SELNLGRP_NONE = 0,
	SELNLGRP_AVC = 1,
	__SELNLGRP_MAX = 2,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum sh_cmt_model {
	SH_CMT_16BIT = 0,
	SH_CMT_32BIT = 1,
	SH_CMT_48BIT = 2,
	SH_CMT0_RCAR_GEN2 = 3,
	SH_CMT1_RCAR_GEN2 = 4,
};

enum sh_tmu_model {
	SH_TMU = 0,
	SH_TMU_SH3 = 1,
};

enum shmem_param {
	Opt_gid___8 = 0,
	Opt_huge = 1,
	Opt_mode___6 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___7 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_PKT_TOO_SMALL = 4,
	SKB_DROP_REASON_TCP_CSUM = 5,
	SKB_DROP_REASON_SOCKET_FILTER = 6,
	SKB_DROP_REASON_UDP_CSUM = 7,
	SKB_DROP_REASON_NETFILTER_DROP = 8,
	SKB_DROP_REASON_OTHERHOST = 9,
	SKB_DROP_REASON_IP_CSUM = 10,
	SKB_DROP_REASON_IP_INHDR = 11,
	SKB_DROP_REASON_IP_RPFILTER = 12,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 13,
	SKB_DROP_REASON_XFRM_POLICY = 14,
	SKB_DROP_REASON_IP_NOPROTO = 15,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 16,
	SKB_DROP_REASON_PROTO_MEM = 17,
	SKB_DROP_REASON_TCP_AUTH_HDR = 18,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 19,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 20,
	SKB_DROP_REASON_TCP_MD5FAILURE = 21,
	SKB_DROP_REASON_TCP_AONOTFOUND = 22,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 23,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 24,
	SKB_DROP_REASON_TCP_AOFAILURE = 25,
	SKB_DROP_REASON_SOCKET_BACKLOG = 26,
	SKB_DROP_REASON_TCP_FLAGS = 27,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 28,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 29,
	SKB_DROP_REASON_TCP_OLD_DATA = 30,
	SKB_DROP_REASON_TCP_OVERWINDOW = 31,
	SKB_DROP_REASON_TCP_OFOMERGE = 32,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 33,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 34,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 35,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 36,
	SKB_DROP_REASON_TCP_RESET = 37,
	SKB_DROP_REASON_TCP_INVALID_SYN = 38,
	SKB_DROP_REASON_TCP_CLOSE = 39,
	SKB_DROP_REASON_TCP_FASTOPEN = 40,
	SKB_DROP_REASON_TCP_OLD_ACK = 41,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 42,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 43,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 44,
	SKB_DROP_REASON_TCP_OFO_DROP = 45,
	SKB_DROP_REASON_IP_OUTNOROUTES = 46,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 47,
	SKB_DROP_REASON_IPV6DISABLED = 48,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 49,
	SKB_DROP_REASON_NEIGH_FAILED = 50,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 51,
	SKB_DROP_REASON_NEIGH_DEAD = 52,
	SKB_DROP_REASON_TC_EGRESS = 53,
	SKB_DROP_REASON_SECURITY_HOOK = 54,
	SKB_DROP_REASON_QDISC_DROP = 55,
	SKB_DROP_REASON_CPU_BACKLOG = 56,
	SKB_DROP_REASON_XDP = 57,
	SKB_DROP_REASON_TC_INGRESS = 58,
	SKB_DROP_REASON_UNHANDLED_PROTO = 59,
	SKB_DROP_REASON_SKB_CSUM = 60,
	SKB_DROP_REASON_SKB_GSO_SEG = 61,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 62,
	SKB_DROP_REASON_DEV_HDR = 63,
	SKB_DROP_REASON_DEV_READY = 64,
	SKB_DROP_REASON_FULL_RING = 65,
	SKB_DROP_REASON_NOMEM = 66,
	SKB_DROP_REASON_HDR_TRUNC = 67,
	SKB_DROP_REASON_TAP_FILTER = 68,
	SKB_DROP_REASON_TAP_TXFILTER = 69,
	SKB_DROP_REASON_ICMP_CSUM = 70,
	SKB_DROP_REASON_INVALID_PROTO = 71,
	SKB_DROP_REASON_IP_INADDRERRORS = 72,
	SKB_DROP_REASON_IP_INNOROUTES = 73,
	SKB_DROP_REASON_PKT_TOO_BIG = 74,
	SKB_DROP_REASON_DUP_FRAG = 75,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 76,
	SKB_DROP_REASON_FRAG_TOO_FAR = 77,
	SKB_DROP_REASON_TCP_MINTTL = 78,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 79,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 80,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 81,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 82,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 83,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 84,
	SKB_DROP_REASON_QUEUE_PURGE = 85,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 86,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 87,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 88,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 89,
	SKB_DROP_REASON_MAX = 90,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_MAC80211_MONITOR = 2,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 3,
	SKB_DROP_REASON_SUBSYS_NUM = 4,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	TC_SKB_EXT = 2,
	SKB_EXT_MPTCP = 3,
	SKB_EXT_NUM = 4,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE = 1,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_cast_to_kern_ctx = 7,
	KF_bpf_rdonly_cast = 8,
	KF_bpf_rcu_read_lock = 9,
	KF_bpf_rcu_read_unlock = 10,
	KF_bpf_rbtree_remove = 11,
	KF_bpf_rbtree_add_impl = 12,
	KF_bpf_rbtree_first = 13,
	KF_bpf_dynptr_from_skb = 14,
	KF_bpf_dynptr_from_xdp = 15,
	KF_bpf_dynptr_slice = 16,
	KF_bpf_dynptr_slice_rdwr = 17,
	KF_bpf_dynptr_clone = 18,
	KF_bpf_percpu_obj_new_impl = 19,
	KF_bpf_percpu_obj_drop_impl = 20,
	KF_bpf_throw = 21,
	KF_bpf_wq_set_callback_impl = 22,
	KF_bpf_preempt_disable = 23,
	KF_bpf_preempt_enable = 24,
	KF_bpf_iter_css_task_new = 25,
	KF_bpf_session_cookie = 26,
};

enum spectre_v4_policy {
	SPECTRE_V4_POLICY_MITIGATION_DYNAMIC = 0,
	SPECTRE_V4_POLICY_MITIGATION_ENABLED = 1,
	SPECTRE_V4_POLICY_MITIGATION_DISABLED = 2,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spm_reg {
	SPM_REG_CFG = 0,
	SPM_REG_SPM_CTL = 1,
	SPM_REG_DLY = 2,
	SPM_REG_PMIC_DLY = 3,
	SPM_REG_PMIC_DATA_0 = 4,
	SPM_REG_PMIC_DATA_1 = 5,
	SPM_REG_VCTL = 6,
	SPM_REG_SEQ_ENTRY = 7,
	SPM_REG_STS0 = 8,
	SPM_REG_STS1 = 9,
	SPM_REG_PMIC_STS = 10,
	SPM_REG_AVS_CTL = 11,
	SPM_REG_AVS_LIMIT = 12,
	SPM_REG_RST = 13,
	SPM_REG_NR = 14,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum states_wwnr {
	not_running_wwnr = 0,
	running_wwnr = 1,
	state_max_wwnr = 2,
};

enum stats_per_group {
	STATS_SYSTEM = 0,
	STATS_SOFTIRQ = 1,
	STATS_HARDIRQ = 2,
	STATS_IDLE = 3,
	NUM_STATS_PER_GROUP = 4,
};

enum stmpe_block {
	STMPE_BLOCK_GPIO = 1,
	STMPE_BLOCK_KEYPAD = 2,
	STMPE_BLOCK_TOUCHSCREEN = 4,
	STMPE_BLOCK_ADC = 8,
	STMPE_BLOCK_PWM = 16,
	STMPE_BLOCK_ROTATOR = 32,
};

enum stmpe_partnum {
	STMPE610 = 0,
	STMPE801 = 1,
	STMPE811 = 2,
	STMPE1600 = 3,
	STMPE1601 = 4,
	STMPE1801 = 5,
	STMPE2401 = 6,
	STMPE2403 = 7,
	STMPE_NBR_PARTS = 8,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum subpixel_order {
	SubPixelUnknown = 0,
	SubPixelHorizontalRGB = 1,
	SubPixelHorizontalBGR = 2,
	SubPixelVerticalRGB = 3,
	SubPixelVerticalBGR = 4,
	SubPixelNone = 5,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum sun50i_iommu_aci {
	SUN50I_IOMMU_ACI_DO_NOT_USE = 0,
	SUN50I_IOMMU_ACI_NONE = 1,
	SUN50I_IOMMU_ACI_RD = 2,
	SUN50I_IOMMU_ACI_WR = 3,
	SUN50I_IOMMU_ACI_RD_WR = 4,
};

enum sunxi_desc_bias_voltage {
	BIAS_VOLTAGE_NONE = 0,
	BIAS_VOLTAGE_GRP_CONFIG = 1,
	BIAS_VOLTAGE_PIO_POW_MODE_SEL = 2,
	BIAS_VOLTAGE_PIO_POW_MODE_CTL = 3,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_mode {
	PRESUSPEND = 0,
	PRESUSPEND_UNDO = 1,
	POSTSUSPEND = 2,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF___2 = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum switch_power_state {
	DRM_SWITCH_POWER_ON = 0,
	DRM_SWITCH_POWER_OFF = 1,
	DRM_SWITCH_POWER_CHANGING = 2,
	DRM_SWITCH_POWER_DYNAMIC_OFF = 3,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum sync {
	DEFAULTSYNC = 0,
	NOSYNC = 1,
	FORCESYNC = 2,
};

enum sync_action {
	ACTION_RESYNC = 0,
	ACTION_RECOVER = 1,
	ACTION_CHECK = 2,
	ACTION_REPAIR = 3,
	ACTION_RESHAPE = 4,
	ACTION_FROZEN = 5,
	ACTION_IDLE = 6,
	NR_SYNC_ACTIONS = 7,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sysc_clocks {
	SYSC_FCK = 0,
	SYSC_ICK = 1,
	SYSC_OPTFCK0 = 2,
	SYSC_OPTFCK1 = 3,
	SYSC_OPTFCK2 = 4,
	SYSC_OPTFCK3 = 5,
	SYSC_OPTFCK4 = 6,
	SYSC_OPTFCK5 = 7,
	SYSC_OPTFCK6 = 8,
	SYSC_OPTFCK7 = 9,
	SYSC_MAX_CLOCKS = 10,
};

enum sysc_registers {
	SYSC_REVISION = 0,
	SYSC_SYSCONFIG = 1,
	SYSC_SYSSTATUS = 2,
	SYSC_MAX_REGS = 3,
};

enum sysc_soc {
	SOC_UNKNOWN = 0,
	SOC_2420 = 1,
	SOC_2430 = 2,
	SOC_3430 = 3,
	SOC_AM35 = 4,
	SOC_3630 = 5,
	SOC_4430 = 6,
	SOC_4460 = 7,
	SOC_4470 = 8,
	SOC_5430 = 9,
	SOC_AM3 = 10,
	SOC_AM4 = 11,
	SOC_DRA7 = 12,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum tap_delay_type {
	PM_TAPDELAY_INPUT = 0,
	PM_TAPDELAY_OUTPUT = 1,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
	TWA_FLAGS = 65280,
	TWAF_NO_ALLOC = 256,
};

enum tb_cfg_error {
	TB_CFG_ERROR_PORT_NOT_CONNECTED = 0,
	TB_CFG_ERROR_LINK_ERROR = 1,
	TB_CFG_ERROR_INVALID_CONFIG_SPACE = 2,
	TB_CFG_ERROR_NO_SUCH_PORT = 4,
	TB_CFG_ERROR_ACK_PLUG_EVENT = 7,
	TB_CFG_ERROR_LOOP = 8,
	TB_CFG_ERROR_HEC_ERROR_DETECTED = 12,
	TB_CFG_ERROR_FLOW_CONTROL_ERROR = 13,
	TB_CFG_ERROR_LOCK = 15,
	TB_CFG_ERROR_DP_BW = 32,
	TB_CFG_ERROR_ROP_CMPLT = 33,
	TB_CFG_ERROR_POP_CMPLT = 34,
	TB_CFG_ERROR_PCIE_WAKE = 35,
	TB_CFG_ERROR_DP_CON_CHANGE = 36,
	TB_CFG_ERROR_DPTX_DISCOVERY = 37,
	TB_CFG_ERROR_LINK_RECOVERY = 38,
	TB_CFG_ERROR_ASYM_LINK = 39,
};

enum tb_cfg_pkg_type {
	TB_CFG_PKG_READ = 1,
	TB_CFG_PKG_WRITE = 2,
	TB_CFG_PKG_ERROR = 3,
	TB_CFG_PKG_NOTIFY_ACK = 4,
	TB_CFG_PKG_EVENT = 5,
	TB_CFG_PKG_XDOMAIN_REQ = 6,
	TB_CFG_PKG_XDOMAIN_RESP = 7,
	TB_CFG_PKG_OVERRIDE = 8,
	TB_CFG_PKG_RESET = 9,
	TB_CFG_PKG_ICM_EVENT = 10,
	TB_CFG_PKG_ICM_CMD = 11,
	TB_CFG_PKG_ICM_RESP = 12,
};

enum tb_cfg_space {
	TB_CFG_HOPS = 0,
	TB_CFG_PORT = 1,
	TB_CFG_SWITCH = 2,
	TB_CFG_COUNTERS = 3,
};

enum tb_drom_entry_type {
	TB_DROM_ENTRY_GENERIC = 0,
	TB_DROM_ENTRY_PORT = 1,
};

enum tb_eeprom_transfer {
	TB_EEPROM_IN = 0,
	TB_EEPROM_OUT = 1,
};

enum tb_link_width {
	TB_LINK_WIDTH_SINGLE = 1,
	TB_LINK_WIDTH_DUAL = 2,
	TB_LINK_WIDTH_ASYM_TX = 4,
	TB_LINK_WIDTH_ASYM_RX = 8,
};

enum tb_nvm_write_ops {
	WRITE_AND_AUTHENTICATE = 1,
	WRITE_ONLY = 2,
	AUTHENTICATE_ONLY = 3,
};

enum tb_path_port {
	TB_PATH_NONE = 0,
	TB_PATH_SOURCE = 1,
	TB_PATH_INTERNAL = 2,
	TB_PATH_DESTINATION = 4,
	TB_PATH_ALL = 7,
};

enum tb_port_cap {
	TB_PORT_CAP_PHY = 1,
	TB_PORT_CAP_POWER = 2,
	TB_PORT_CAP_TIME1 = 3,
	TB_PORT_CAP_ADAP = 4,
	TB_PORT_CAP_VSE = 5,
	TB_PORT_CAP_USB4 = 6,
};

enum tb_port_state {
	TB_PORT_DISABLED = 0,
	TB_PORT_CONNECTING = 1,
	TB_PORT_UP = 2,
	TB_PORT_TX_CL0S = 3,
	TB_PORT_RX_CL0S = 4,
	TB_PORT_CL1 = 5,
	TB_PORT_CL2 = 6,
	TB_PORT_UNPLUGGED = 7,
};

enum tb_port_type {
	TB_TYPE_INACTIVE = 0,
	TB_TYPE_PORT = 1,
	TB_TYPE_NHI = 2,
	TB_TYPE_DP_HDMI_IN = 917761,
	TB_TYPE_DP_HDMI_OUT = 917762,
	TB_TYPE_PCIE_DOWN = 1048833,
	TB_TYPE_PCIE_UP = 1048834,
	TB_TYPE_USB3_DOWN = 2097409,
	TB_TYPE_USB3_UP = 2097410,
};

enum tb_property_type {
	TB_PROPERTY_TYPE_UNKNOWN = 0,
	TB_PROPERTY_TYPE_DIRECTORY = 68,
	TB_PROPERTY_TYPE_DATA = 100,
	TB_PROPERTY_TYPE_TEXT = 116,
	TB_PROPERTY_TYPE_VALUE = 118,
};

enum tb_security_level {
	TB_SECURITY_NONE = 0,
	TB_SECURITY_USER = 1,
	TB_SECURITY_SECURE = 2,
	TB_SECURITY_DPONLY = 3,
	TB_SECURITY_USBONLY = 4,
	TB_SECURITY_NOPCIE = 5,
};

enum tb_switch_cap {
	TB_SWITCH_CAP_TMU = 3,
	TB_SWITCH_CAP_VSE = 5,
};

enum tb_switch_tmu_mode {
	TB_SWITCH_TMU_MODE_OFF = 0,
	TB_SWITCH_TMU_MODE_LOWRES = 1,
	TB_SWITCH_TMU_MODE_HIFI_UNI = 2,
	TB_SWITCH_TMU_MODE_HIFI_BI = 3,
	TB_SWITCH_TMU_MODE_MEDRES_ENHANCED_UNI = 4,
};

enum tb_switch_vse_cap {
	TB_VSE_CAP_PLUG_EVENTS = 1,
	TB_VSE_CAP_TIME2 = 3,
	TB_VSE_CAP_CP_LP = 4,
	TB_VSE_CAP_LINK_CONTROLLER = 6,
};

enum tb_tunnel_type {
	TB_TUNNEL_PCI = 0,
	TB_TUNNEL_DP = 1,
	TB_TUNNEL_DMA = 2,
	TB_TUNNEL_USB3 = 3,
};

enum tb_xdp_error {
	ERROR_SUCCESS = 0,
	ERROR_UNKNOWN_PACKET = 1,
	ERROR_UNKNOWN_DOMAIN = 2,
	ERROR_NOT_SUPPORTED = 3,
	ERROR_NOT_READY = 4,
};

enum tb_xdp_type {
	UUID_REQUEST_OLD = 1,
	UUID_RESPONSE = 2,
	PROPERTIES_REQUEST = 3,
	PROPERTIES_RESPONSE = 4,
	PROPERTIES_CHANGED_REQUEST = 5,
	PROPERTIES_CHANGED_RESPONSE = 6,
	ERROR_RESPONSE = 7,
	UUID_REQUEST = 12,
	LINK_STATE_STATUS_REQUEST = 15,
	LINK_STATE_STATUS_RESPONSE = 16,
	LINK_STATE_CHANGE_REQUEST = 17,
	LINK_STATE_CHANGE_RESPONSE = 18,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcpa_pc_event_ids {
	SMBIOS = 1,
	BIS_CERT = 2,
	POST_BIOS_ROM = 3,
	ESCD = 4,
	CMOS = 5,
	NVRAM = 6,
	OPTION_ROM_EXEC = 7,
	OPTION_ROM_CONFIG = 8,
	OPTION_ROM_MICROCODE = 10,
	S_CRTM_VERSION = 11,
	S_CRTM_CONTENTS = 12,
	POST_CONTENTS = 13,
	HOST_TABLE_OF_DEVICES = 14,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tegra124_function {
	TEGRA124_FUNC_SNPS = 0,
	TEGRA124_FUNC_XUSB = 1,
	TEGRA124_FUNC_UART = 2,
	TEGRA124_FUNC_PCIE = 3,
	TEGRA124_FUNC_USB3 = 4,
	TEGRA124_FUNC_SATA = 5,
	TEGRA124_FUNC_RSVD = 6,
};

enum tegra210_emc_refresh {
	TEGRA210_EMC_REFRESH_NOMINAL = 0,
	TEGRA210_EMC_REFRESH_2X = 1,
	TEGRA210_EMC_REFRESH_4X = 2,
	TEGRA210_EMC_REFRESH_THROTTLE = 3,
};

enum tegra234_cbb_fabric_ids {
	CBB_FAB_ID = 0,
	SCE_FAB_ID = 1,
	RCE_FAB_ID = 2,
	DCE_FAB_ID = 3,
	AON_FAB_ID = 4,
	PSC_FAB_ID = 5,
	BPMP_FAB_ID = 6,
	FSI_FAB_ID = 7,
	MAX_FAB_ID = 8,
};

enum tegra_dfll_pmu_if {
	TEGRA_DFLL_PMU_I2C = 0,
	TEGRA_DFLL_PMU_PWM = 1,
};

enum tegra_icc_client_type {
	TEGRA_ICC_NONE = 0,
	TEGRA_ICC_NISO = 1,
	TEGRA_ICC_ISO_DISPLAY = 2,
	TEGRA_ICC_ISO_VI = 3,
	TEGRA_ICC_ISO_AUDIO = 4,
	TEGRA_ICC_ISO_VIFAL = 5,
};

enum tegra_io_pad {
	TEGRA_IO_PAD_AUDIO = 0,
	TEGRA_IO_PAD_AUDIO_HV = 1,
	TEGRA_IO_PAD_BB = 2,
	TEGRA_IO_PAD_CAM = 3,
	TEGRA_IO_PAD_COMP = 4,
	TEGRA_IO_PAD_CONN = 5,
	TEGRA_IO_PAD_CSIA = 6,
	TEGRA_IO_PAD_CSIB = 7,
	TEGRA_IO_PAD_CSIC = 8,
	TEGRA_IO_PAD_CSID = 9,
	TEGRA_IO_PAD_CSIE = 10,
	TEGRA_IO_PAD_CSIF = 11,
	TEGRA_IO_PAD_CSIG = 12,
	TEGRA_IO_PAD_CSIH = 13,
	TEGRA_IO_PAD_DAP3 = 14,
	TEGRA_IO_PAD_DAP5 = 15,
	TEGRA_IO_PAD_DBG = 16,
	TEGRA_IO_PAD_DEBUG_NONAO = 17,
	TEGRA_IO_PAD_DMIC = 18,
	TEGRA_IO_PAD_DMIC_HV = 19,
	TEGRA_IO_PAD_DP = 20,
	TEGRA_IO_PAD_DSI = 21,
	TEGRA_IO_PAD_DSIB = 22,
	TEGRA_IO_PAD_DSIC = 23,
	TEGRA_IO_PAD_DSID = 24,
	TEGRA_IO_PAD_EDP = 25,
	TEGRA_IO_PAD_EMMC = 26,
	TEGRA_IO_PAD_EMMC2 = 27,
	TEGRA_IO_PAD_EQOS = 28,
	TEGRA_IO_PAD_GPIO = 29,
	TEGRA_IO_PAD_GP_PWM2 = 30,
	TEGRA_IO_PAD_GP_PWM3 = 31,
	TEGRA_IO_PAD_HDMI = 32,
	TEGRA_IO_PAD_HDMI_DP0 = 33,
	TEGRA_IO_PAD_HDMI_DP1 = 34,
	TEGRA_IO_PAD_HDMI_DP2 = 35,
	TEGRA_IO_PAD_HDMI_DP3 = 36,
	TEGRA_IO_PAD_HSIC = 37,
	TEGRA_IO_PAD_HV = 38,
	TEGRA_IO_PAD_LVDS = 39,
	TEGRA_IO_PAD_MIPI_BIAS = 40,
	TEGRA_IO_PAD_NAND = 41,
	TEGRA_IO_PAD_PEX_BIAS = 42,
	TEGRA_IO_PAD_PEX_CLK_BIAS = 43,
	TEGRA_IO_PAD_PEX_CLK1 = 44,
	TEGRA_IO_PAD_PEX_CLK2 = 45,
	TEGRA_IO_PAD_PEX_CLK3 = 46,
	TEGRA_IO_PAD_PEX_CLK_2_BIAS = 47,
	TEGRA_IO_PAD_PEX_CLK_2 = 48,
	TEGRA_IO_PAD_PEX_CNTRL = 49,
	TEGRA_IO_PAD_PEX_CTL2 = 50,
	TEGRA_IO_PAD_PEX_L0_RST = 51,
	TEGRA_IO_PAD_PEX_L1_RST = 52,
	TEGRA_IO_PAD_PEX_L5_RST = 53,
	TEGRA_IO_PAD_PWR_CTL = 54,
	TEGRA_IO_PAD_SDMMC1 = 55,
	TEGRA_IO_PAD_SDMMC1_HV = 56,
	TEGRA_IO_PAD_SDMMC2 = 57,
	TEGRA_IO_PAD_SDMMC2_HV = 58,
	TEGRA_IO_PAD_SDMMC3 = 59,
	TEGRA_IO_PAD_SDMMC3_HV = 60,
	TEGRA_IO_PAD_SDMMC4 = 61,
	TEGRA_IO_PAD_SOC_GPIO10 = 62,
	TEGRA_IO_PAD_SOC_GPIO12 = 63,
	TEGRA_IO_PAD_SOC_GPIO13 = 64,
	TEGRA_IO_PAD_SOC_GPIO53 = 65,
	TEGRA_IO_PAD_SPI = 66,
	TEGRA_IO_PAD_SPI_HV = 67,
	TEGRA_IO_PAD_SYS_DDC = 68,
	TEGRA_IO_PAD_UART = 69,
	TEGRA_IO_PAD_UART4 = 70,
	TEGRA_IO_PAD_UART5 = 71,
	TEGRA_IO_PAD_UFS = 72,
	TEGRA_IO_PAD_USB0 = 73,
	TEGRA_IO_PAD_USB1 = 74,
	TEGRA_IO_PAD_USB2 = 75,
	TEGRA_IO_PAD_USB3 = 76,
	TEGRA_IO_PAD_USB_BIAS = 77,
	TEGRA_IO_PAD_AO_HV = 78,
};

enum tegra_ivc_state {
	TEGRA_IVC_STATE_ESTABLISHED = 0,
	TEGRA_IVC_STATE_SYNC = 1,
	TEGRA_IVC_STATE_ACK = 2,
};

enum tegra_mux {
	TEGRA_MUX_AUD = 0,
	TEGRA_MUX_BCL = 1,
	TEGRA_MUX_BLINK = 2,
	TEGRA_MUX_CCLA = 3,
	TEGRA_MUX_CEC = 4,
	TEGRA_MUX_CLDVFS = 5,
	TEGRA_MUX_CLK = 6,
	TEGRA_MUX_CORE = 7,
	TEGRA_MUX_CPU = 8,
	TEGRA_MUX_DISPLAYA = 9,
	TEGRA_MUX_DISPLAYB = 10,
	TEGRA_MUX_DMIC1 = 11,
	TEGRA_MUX_DMIC2 = 12,
	TEGRA_MUX_DMIC3 = 13,
	TEGRA_MUX_DP = 14,
	TEGRA_MUX_DTV = 15,
	TEGRA_MUX_EXTPERIPH3 = 16,
	TEGRA_MUX_I2C1 = 17,
	TEGRA_MUX_I2C2 = 18,
	TEGRA_MUX_I2C3 = 19,
	TEGRA_MUX_I2CPMU = 20,
	TEGRA_MUX_I2CVI = 21,
	TEGRA_MUX_I2S1 = 22,
	TEGRA_MUX_I2S2 = 23,
	TEGRA_MUX_I2S3 = 24,
	TEGRA_MUX_I2S4A = 25,
	TEGRA_MUX_I2S4B = 26,
	TEGRA_MUX_I2S5A = 27,
	TEGRA_MUX_I2S5B = 28,
	TEGRA_MUX_IQC0 = 29,
	TEGRA_MUX_IQC1 = 30,
	TEGRA_MUX_JTAG = 31,
	TEGRA_MUX_PE = 32,
	TEGRA_MUX_PE0 = 33,
	TEGRA_MUX_PE1 = 34,
	TEGRA_MUX_PMI = 35,
	TEGRA_MUX_PWM0 = 36,
	TEGRA_MUX_PWM1 = 37,
	TEGRA_MUX_PWM2 = 38,
	TEGRA_MUX_PWM3 = 39,
	TEGRA_MUX_QSPI = 40,
	TEGRA_MUX_RSVD0 = 41,
	TEGRA_MUX_RSVD1 = 42,
	TEGRA_MUX_RSVD2 = 43,
	TEGRA_MUX_RSVD3 = 44,
	TEGRA_MUX_SATA = 45,
	TEGRA_MUX_SDMMC1 = 46,
	TEGRA_MUX_SDMMC3 = 47,
	TEGRA_MUX_SHUTDOWN = 48,
	TEGRA_MUX_SOC = 49,
	TEGRA_MUX_SOR0 = 50,
	TEGRA_MUX_SOR1 = 51,
	TEGRA_MUX_SPDIF = 52,
	TEGRA_MUX_SPI1 = 53,
	TEGRA_MUX_SPI2 = 54,
	TEGRA_MUX_SPI3 = 55,
	TEGRA_MUX_SPI4 = 56,
	TEGRA_MUX_SYS = 57,
	TEGRA_MUX_TOUCH = 58,
	TEGRA_MUX_UART = 59,
	TEGRA_MUX_UARTA = 60,
	TEGRA_MUX_UARTB = 61,
	TEGRA_MUX_UARTC = 62,
	TEGRA_MUX_UARTD = 63,
	TEGRA_MUX_USB = 64,
	TEGRA_MUX_VGP1 = 65,
	TEGRA_MUX_VGP2 = 66,
	TEGRA_MUX_VGP3 = 67,
	TEGRA_MUX_VGP4 = 68,
	TEGRA_MUX_VGP5 = 69,
	TEGRA_MUX_VGP6 = 70,
	TEGRA_MUX_VIMCLK = 71,
	TEGRA_MUX_VIMCLK2 = 72,
};

enum tegra_mux___2 {
	TEGRA_MUX_BLINK___2 = 0,
	TEGRA_MUX_CCLA___2 = 1,
	TEGRA_MUX_CEC___2 = 2,
	TEGRA_MUX_CLDVFS___2 = 3,
	TEGRA_MUX_CLK___2 = 4,
	TEGRA_MUX_CLK12 = 5,
	TEGRA_MUX_CPU___2 = 6,
	TEGRA_MUX_CSI = 7,
	TEGRA_MUX_DAP = 8,
	TEGRA_MUX_DAP1 = 9,
	TEGRA_MUX_DAP2 = 10,
	TEGRA_MUX_DEV3 = 11,
	TEGRA_MUX_DISPLAYA___2 = 12,
	TEGRA_MUX_DISPLAYA_ALT = 13,
	TEGRA_MUX_DISPLAYB___2 = 14,
	TEGRA_MUX_DP___2 = 15,
	TEGRA_MUX_DSI_B = 16,
	TEGRA_MUX_DTV___2 = 17,
	TEGRA_MUX_EXTPERIPH1 = 18,
	TEGRA_MUX_EXTPERIPH2 = 19,
	TEGRA_MUX_EXTPERIPH3___2 = 20,
	TEGRA_MUX_GMI = 21,
	TEGRA_MUX_GMI_ALT = 22,
	TEGRA_MUX_HDA = 23,
	TEGRA_MUX_HSI = 24,
	TEGRA_MUX_I2C1___2 = 25,
	TEGRA_MUX_I2C2___2 = 26,
	TEGRA_MUX_I2C3___2 = 27,
	TEGRA_MUX_I2C4 = 28,
	TEGRA_MUX_I2CPWR = 29,
	TEGRA_MUX_I2S0 = 30,
	TEGRA_MUX_I2S1___2 = 31,
	TEGRA_MUX_I2S2___2 = 32,
	TEGRA_MUX_I2S3___2 = 33,
	TEGRA_MUX_I2S4 = 34,
	TEGRA_MUX_IRDA = 35,
	TEGRA_MUX_KBC = 36,
	TEGRA_MUX_OWR = 37,
	TEGRA_MUX_PE___2 = 38,
	TEGRA_MUX_PE0___2 = 39,
	TEGRA_MUX_PE1___2 = 40,
	TEGRA_MUX_PMI___2 = 41,
	TEGRA_MUX_PWM0___2 = 42,
	TEGRA_MUX_PWM1___2 = 43,
	TEGRA_MUX_PWM2___2 = 44,
	TEGRA_MUX_PWM3___2 = 45,
	TEGRA_MUX_PWRON = 46,
	TEGRA_MUX_RESET_OUT_N = 47,
	TEGRA_MUX_RSVD1___2 = 48,
	TEGRA_MUX_RSVD2___2 = 49,
	TEGRA_MUX_RSVD3___2 = 50,
	TEGRA_MUX_RSVD4 = 51,
	TEGRA_MUX_RTCK = 52,
	TEGRA_MUX_SATA___2 = 53,
	TEGRA_MUX_SDMMC1___2 = 54,
	TEGRA_MUX_SDMMC2 = 55,
	TEGRA_MUX_SDMMC3___2 = 56,
	TEGRA_MUX_SDMMC4 = 57,
	TEGRA_MUX_SOC___2 = 58,
	TEGRA_MUX_SPDIF___2 = 59,
	TEGRA_MUX_SPI1___2 = 60,
	TEGRA_MUX_SPI2___2 = 61,
	TEGRA_MUX_SPI3___2 = 62,
	TEGRA_MUX_SPI4___2 = 63,
	TEGRA_MUX_SPI5 = 64,
	TEGRA_MUX_SPI6 = 65,
	TEGRA_MUX_SYS___2 = 66,
	TEGRA_MUX_TMDS = 67,
	TEGRA_MUX_TRACE = 68,
	TEGRA_MUX_UARTA___2 = 69,
	TEGRA_MUX_UARTB___2 = 70,
	TEGRA_MUX_UARTC___2 = 71,
	TEGRA_MUX_UARTD___2 = 72,
	TEGRA_MUX_ULPI = 73,
	TEGRA_MUX_USB___2 = 74,
	TEGRA_MUX_VGP1___2 = 75,
	TEGRA_MUX_VGP2___2 = 76,
	TEGRA_MUX_VGP3___2 = 77,
	TEGRA_MUX_VGP4___2 = 78,
	TEGRA_MUX_VGP5___2 = 79,
	TEGRA_MUX_VGP6___2 = 80,
	TEGRA_MUX_VI = 81,
	TEGRA_MUX_VI_ALT1 = 82,
	TEGRA_MUX_VI_ALT3 = 83,
	TEGRA_MUX_VIMCLK2___2 = 84,
	TEGRA_MUX_VIMCLK2_ALT = 85,
};

enum tegra_mux_dt {
	TEGRA_MUX_RSVD0___2 = 0,
	TEGRA_MUX_RSVD1___3 = 1,
	TEGRA_MUX_RSVD2___3 = 2,
	TEGRA_MUX_RSVD3___3 = 3,
	TEGRA_MUX_TOUCH___2 = 4,
	TEGRA_MUX_UARTC___3 = 5,
	TEGRA_MUX_I2C8 = 6,
	TEGRA_MUX_UARTG = 7,
	TEGRA_MUX_SPI2___3 = 8,
	TEGRA_MUX_GP = 9,
	TEGRA_MUX_DCA = 10,
	TEGRA_MUX_WDT = 11,
	TEGRA_MUX_I2C2___3 = 12,
	TEGRA_MUX_CAN1 = 13,
	TEGRA_MUX_CAN0 = 14,
	TEGRA_MUX_DMIC3___2 = 15,
	TEGRA_MUX_DMIC5 = 16,
	TEGRA_MUX_GPIO = 17,
	TEGRA_MUX_DSPK1 = 18,
	TEGRA_MUX_DSPK0 = 19,
	TEGRA_MUX_SPDIF___3 = 20,
	TEGRA_MUX_AUD___2 = 21,
	TEGRA_MUX_I2S1___3 = 22,
	TEGRA_MUX_DMIC1___2 = 23,
	TEGRA_MUX_DMIC2___2 = 24,
	TEGRA_MUX_I2S3___3 = 25,
	TEGRA_MUX_DMIC4 = 26,
	TEGRA_MUX_I2S4___2 = 27,
	TEGRA_MUX_EXTPERIPH2___2 = 28,
	TEGRA_MUX_EXTPERIPH1___2 = 29,
	TEGRA_MUX_I2C3___3 = 30,
	TEGRA_MUX_VGP1___3 = 31,
	TEGRA_MUX_VGP2___3 = 32,
	TEGRA_MUX_VGP3___3 = 33,
	TEGRA_MUX_VGP4___3 = 34,
	TEGRA_MUX_VGP5___3 = 35,
	TEGRA_MUX_VGP6___3 = 36,
	TEGRA_MUX_SLVS = 37,
	TEGRA_MUX_EXTPERIPH3___3 = 38,
	TEGRA_MUX_EXTPERIPH4 = 39,
	TEGRA_MUX_I2S2___3 = 40,
	TEGRA_MUX_UARTD___3 = 41,
	TEGRA_MUX_I2C1___3 = 42,
	TEGRA_MUX_UARTA___3 = 43,
	TEGRA_MUX_DIRECTDC1 = 44,
	TEGRA_MUX_DIRECTDC = 45,
	TEGRA_MUX_IQC1___2 = 46,
	TEGRA_MUX_IQC2 = 47,
	TEGRA_MUX_I2S6 = 48,
	TEGRA_MUX_SDMMC3___3 = 49,
	TEGRA_MUX_SDMMC1___3 = 50,
	TEGRA_MUX_DP___3 = 51,
	TEGRA_MUX_HDMI = 52,
	TEGRA_MUX_PE2 = 53,
	TEGRA_MUX_IGPU = 54,
	TEGRA_MUX_SATA___3 = 55,
	TEGRA_MUX_PE1___3 = 56,
	TEGRA_MUX_PE0___3 = 57,
	TEGRA_MUX_PE3 = 58,
	TEGRA_MUX_PE4 = 59,
	TEGRA_MUX_PE5 = 60,
	TEGRA_MUX_SOC___3 = 61,
	TEGRA_MUX_EQOS = 62,
	TEGRA_MUX_QSPI___2 = 63,
	TEGRA_MUX_QSPI0 = 64,
	TEGRA_MUX_QSPI1 = 65,
	TEGRA_MUX_MIPI = 66,
	TEGRA_MUX_SCE = 67,
	TEGRA_MUX_I2C5 = 68,
	TEGRA_MUX_DISPLAYA___3 = 69,
	TEGRA_MUX_DISPLAYB___3 = 70,
	TEGRA_MUX_DCB = 71,
	TEGRA_MUX_SPI1___3 = 72,
	TEGRA_MUX_UARTB___3 = 73,
	TEGRA_MUX_UARTE = 74,
	TEGRA_MUX_SPI3___3 = 75,
	TEGRA_MUX_NV = 76,
	TEGRA_MUX_CCLA___3 = 77,
	TEGRA_MUX_I2S5 = 78,
	TEGRA_MUX_USB___3 = 79,
	TEGRA_MUX_UFS0 = 80,
	TEGRA_MUX_DGPU = 81,
	TEGRA_MUX_SDMMC4___2 = 82,
};

enum tegra_mux_dt___2 {
	TEGRA_MUX_GP___2 = 0,
	TEGRA_MUX_UARTC___4 = 1,
	TEGRA_MUX_I2C8___2 = 2,
	TEGRA_MUX_SPI2___4 = 3,
	TEGRA_MUX_I2C2___4 = 4,
	TEGRA_MUX_CAN1___2 = 5,
	TEGRA_MUX_CAN0___2 = 6,
	TEGRA_MUX_RSVD0___3 = 7,
	TEGRA_MUX_ETH0 = 8,
	TEGRA_MUX_ETH2 = 9,
	TEGRA_MUX_ETH1 = 10,
	TEGRA_MUX_DP___4 = 11,
	TEGRA_MUX_ETH3 = 12,
	TEGRA_MUX_I2C4___2 = 13,
	TEGRA_MUX_I2C7 = 14,
	TEGRA_MUX_I2C9 = 15,
	TEGRA_MUX_EQOS___2 = 16,
	TEGRA_MUX_PE2___2 = 17,
	TEGRA_MUX_PE1___4 = 18,
	TEGRA_MUX_PE0___4 = 19,
	TEGRA_MUX_PE3___2 = 20,
	TEGRA_MUX_PE4___2 = 21,
	TEGRA_MUX_PE5___2 = 22,
	TEGRA_MUX_PE6 = 23,
	TEGRA_MUX_PE10 = 24,
	TEGRA_MUX_PE7 = 25,
	TEGRA_MUX_PE8 = 26,
	TEGRA_MUX_PE9 = 27,
	TEGRA_MUX_QSPI0___2 = 28,
	TEGRA_MUX_QSPI1___2 = 29,
	TEGRA_MUX_QSPI___3 = 30,
	TEGRA_MUX_SDMMC1___4 = 31,
	TEGRA_MUX_SCE___2 = 32,
	TEGRA_MUX_SOC___4 = 33,
	TEGRA_MUX_GPIO___2 = 34,
	TEGRA_MUX_HDMI___2 = 35,
	TEGRA_MUX_UFS0___2 = 36,
	TEGRA_MUX_SPI3___4 = 37,
	TEGRA_MUX_SPI1___4 = 38,
	TEGRA_MUX_UARTB___4 = 39,
	TEGRA_MUX_UARTE___2 = 40,
	TEGRA_MUX_USB___4 = 41,
	TEGRA_MUX_EXTPERIPH2___3 = 42,
	TEGRA_MUX_EXTPERIPH1___3 = 43,
	TEGRA_MUX_I2C3___4 = 44,
	TEGRA_MUX_VI0 = 45,
	TEGRA_MUX_I2C5___2 = 46,
	TEGRA_MUX_UARTA___4 = 47,
	TEGRA_MUX_UARTD___4 = 48,
	TEGRA_MUX_I2C1___4 = 49,
	TEGRA_MUX_I2S4___3 = 50,
	TEGRA_MUX_I2S6___2 = 51,
	TEGRA_MUX_AUD___3 = 52,
	TEGRA_MUX_SPI5___2 = 53,
	TEGRA_MUX_TOUCH___3 = 54,
	TEGRA_MUX_UARTJ = 55,
	TEGRA_MUX_RSVD1___4 = 56,
	TEGRA_MUX_WDT___2 = 57,
	TEGRA_MUX_TSC = 58,
	TEGRA_MUX_DMIC3___3 = 59,
	TEGRA_MUX_LED = 60,
	TEGRA_MUX_VI0_ALT = 61,
	TEGRA_MUX_I2S5___2 = 62,
	TEGRA_MUX_NV___2 = 63,
	TEGRA_MUX_EXTPERIPH3___4 = 64,
	TEGRA_MUX_EXTPERIPH4___2 = 65,
	TEGRA_MUX_SPI4___3 = 66,
	TEGRA_MUX_CCLA___4 = 67,
	TEGRA_MUX_I2S2___4 = 68,
	TEGRA_MUX_I2S1___4 = 69,
	TEGRA_MUX_I2S8 = 70,
	TEGRA_MUX_I2S3___4 = 71,
	TEGRA_MUX_RSVD2___4 = 72,
	TEGRA_MUX_DMIC5___2 = 73,
	TEGRA_MUX_DCA___2 = 74,
	TEGRA_MUX_DISPLAYB___4 = 75,
	TEGRA_MUX_DISPLAYA___4 = 76,
	TEGRA_MUX_VI1 = 77,
	TEGRA_MUX_DCB___2 = 78,
	TEGRA_MUX_DMIC1___3 = 79,
	TEGRA_MUX_DMIC4___2 = 80,
	TEGRA_MUX_I2S7 = 81,
	TEGRA_MUX_DMIC2___3 = 82,
	TEGRA_MUX_DSPK0___2 = 83,
	TEGRA_MUX_RSVD3___4 = 84,
	TEGRA_MUX_TSC_ALT = 85,
	TEGRA_MUX_ISTCTRL = 86,
	TEGRA_MUX_VI1_ALT = 87,
	TEGRA_MUX_DSPK1___2 = 88,
	TEGRA_MUX_IGPU___2 = 89,
};

enum tegra_pinconf_param {
	TEGRA_PINCONF_PARAM_PULL = 0,
	TEGRA_PINCONF_PARAM_TRISTATE = 1,
	TEGRA_PINCONF_PARAM_ENABLE_INPUT = 2,
	TEGRA_PINCONF_PARAM_OPEN_DRAIN = 3,
	TEGRA_PINCONF_PARAM_LOCK = 4,
	TEGRA_PINCONF_PARAM_IORESET = 5,
	TEGRA_PINCONF_PARAM_RCV_SEL = 6,
	TEGRA_PINCONF_PARAM_HIGH_SPEED_MODE = 7,
	TEGRA_PINCONF_PARAM_SCHMITT = 8,
	TEGRA_PINCONF_PARAM_LOW_POWER_MODE = 9,
	TEGRA_PINCONF_PARAM_DRIVE_DOWN_STRENGTH = 10,
	TEGRA_PINCONF_PARAM_DRIVE_UP_STRENGTH = 11,
	TEGRA_PINCONF_PARAM_SLEW_RATE_FALLING = 12,
	TEGRA_PINCONF_PARAM_SLEW_RATE_RISING = 13,
	TEGRA_PINCONF_PARAM_DRIVE_TYPE = 14,
};

enum tegra_platform {
	TEGRA_PLATFORM_SILICON = 0,
	TEGRA_PLATFORM_QT = 1,
	TEGRA_PLATFORM_SYSTEM_FPGA = 2,
	TEGRA_PLATFORM_UNIT_FPGA = 3,
	TEGRA_PLATFORM_ASIM_QT = 4,
	TEGRA_PLATFORM_ASIM_LINSIM = 5,
	TEGRA_PLATFORM_DSIM_ASIM_LINSIM = 6,
	TEGRA_PLATFORM_VERIFICATION_SIMULATION = 7,
	TEGRA_PLATFORM_VDK = 8,
	TEGRA_PLATFORM_VSP = 9,
	TEGRA_PLATFORM_MAX = 10,
};

enum tegra_revision {
	TEGRA_REVISION_UNKNOWN = 0,
	TEGRA_REVISION_A01 = 1,
	TEGRA_REVISION_A02 = 2,
	TEGRA_REVISION_A03 = 3,
	TEGRA_REVISION_A03p = 4,
	TEGRA_REVISION_A04 = 5,
	TEGRA_REVISION_MAX = 6,
};

enum tegra_super_gen {
	gen4 = 4,
	gen5 = 5,
};

enum tegra_suspend_mode {
	TEGRA_SUSPEND_NONE = 0,
	TEGRA_SUSPEND_LP2 = 1,
	TEGRA_SUSPEND_LP1 = 2,
	TEGRA_SUSPEND_LP0 = 3,
	TEGRA_MAX_SUSPEND_MODE = 4,
	TEGRA_SUSPEND_NOT_READY = 5,
};

enum tegra_xusb_padctl_param {
	TEGRA_XUSB_PADCTL_IDDQ = 0,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_CANCELING = 4,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_TRIP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 8,
	THERMAL_GENL_ATTR_TZ_MODE = 9,
	THERMAL_GENL_ATTR_TZ_NAME = 10,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 11,
	THERMAL_GENL_ATTR_TZ_GOV = 12,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 13,
	THERMAL_GENL_ATTR_CDEV = 14,
	THERMAL_GENL_ATTR_CDEV_ID = 15,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 16,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_NAME = 18,
	THERMAL_GENL_ATTR_GOV_NAME = 19,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 23,
	__THERMAL_GENL_ATTR_MAX = 24,
};

enum thermal_genl_cmd {
	THERMAL_GENL_CMD_UNSPEC = 0,
	THERMAL_GENL_CMD_TZ_GET_ID = 1,
	THERMAL_GENL_CMD_TZ_GET_TRIP = 2,
	THERMAL_GENL_CMD_TZ_GET_TEMP = 3,
	THERMAL_GENL_CMD_TZ_GET_GOV = 4,
	THERMAL_GENL_CMD_TZ_GET_MODE = 5,
	THERMAL_GENL_CMD_CDEV_GET = 6,
	__THERMAL_GENL_CMD_MAX = 7,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	__THERMAL_GENL_EVENT_MAX = 15,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum ti_sysc_module_type {
	TI_SYSC_OMAP2 = 0,
	TI_SYSC_OMAP2_TIMER = 1,
	TI_SYSC_OMAP3_SHAM = 2,
	TI_SYSC_OMAP3_AES = 3,
	TI_SYSC_OMAP4 = 4,
	TI_SYSC_OMAP4_TIMER = 5,
	TI_SYSC_OMAP4_SIMPLE = 6,
	TI_SYSC_OMAP34XX_SR = 7,
	TI_SYSC_OMAP36XX_SR = 8,
	TI_SYSC_OMAP4_SR = 9,
	TI_SYSC_OMAP4_MCASP = 10,
	TI_SYSC_OMAP4_USB_HOST_FS = 11,
	TI_SYSC_DRA7_MCAN = 12,
	TI_SYSC_PRUSS = 13,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tis_access {
	TPM_ACCESS_VALID = 128,
	TPM_ACCESS_ACTIVE_LOCALITY = 32,
	TPM_ACCESS_REQUEST_PENDING = 4,
	TPM_ACCESS_REQUEST_USE = 2,
};

enum tis_defaults {
	TIS_MEM_LEN = 20480,
	TIS_SHORT_TIMEOUT = 750,
	TIS_LONG_TIMEOUT = 2000,
	TIS_TIMEOUT_MIN_ATML = 14700,
	TIS_TIMEOUT_MAX_ATML = 15000,
};

enum tis_int_flags {
	TPM_GLOBAL_INT_ENABLE = 2147483648,
	TPM_INTF_BURST_COUNT_STATIC = 256,
	TPM_INTF_CMD_READY_INT = 128,
	TPM_INTF_INT_EDGE_FALLING = 64,
	TPM_INTF_INT_EDGE_RISING = 32,
	TPM_INTF_INT_LEVEL_LOW = 16,
	TPM_INTF_INT_LEVEL_HIGH = 8,
	TPM_INTF_LOCALITY_CHANGE_INT = 4,
	TPM_INTF_STS_VALID_INT = 2,
	TPM_INTF_DATA_AVAIL_INT = 1,
};

enum tis_status {
	TPM_STS_VALID = 128,
	TPM_STS_COMMAND_READY = 64,
	TPM_STS_GO = 32,
	TPM_STS_DATA_AVAIL = 16,
	TPM_STS_DATA_EXPECT = 8,
	TPM_STS_RESPONSE_RETRY = 2,
	TPM_STS_READ_ZERO = 35,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	NR_TLB_FLUSH_REASONS = 5,
};

enum tls_offload_ctx_dir {
	TLS_OFFLOAD_CTX_DIR_RX = 0,
	TLS_OFFLOAD_CTX_DIR_TX = 1,
};

enum tomoyo_acl_entry_type_index {
	TOMOYO_TYPE_PATH_ACL = 0,
	TOMOYO_TYPE_PATH2_ACL = 1,
	TOMOYO_TYPE_PATH_NUMBER_ACL = 2,
	TOMOYO_TYPE_MKDEV_ACL = 3,
	TOMOYO_TYPE_MOUNT_ACL = 4,
	TOMOYO_TYPE_INET_ACL = 5,
	TOMOYO_TYPE_UNIX_ACL = 6,
	TOMOYO_TYPE_ENV_ACL = 7,
	TOMOYO_TYPE_MANUAL_TASK_ACL = 8,
};

enum tomoyo_conditions_index {
	TOMOYO_TASK_UID = 0,
	TOMOYO_TASK_EUID = 1,
	TOMOYO_TASK_SUID = 2,
	TOMOYO_TASK_FSUID = 3,
	TOMOYO_TASK_GID = 4,
	TOMOYO_TASK_EGID = 5,
	TOMOYO_TASK_SGID = 6,
	TOMOYO_TASK_FSGID = 7,
	TOMOYO_TASK_PID = 8,
	TOMOYO_TASK_PPID = 9,
	TOMOYO_EXEC_ARGC = 10,
	TOMOYO_EXEC_ENVC = 11,
	TOMOYO_TYPE_IS_SOCKET = 12,
	TOMOYO_TYPE_IS_SYMLINK = 13,
	TOMOYO_TYPE_IS_FILE = 14,
	TOMOYO_TYPE_IS_BLOCK_DEV = 15,
	TOMOYO_TYPE_IS_DIRECTORY = 16,
	TOMOYO_TYPE_IS_CHAR_DEV = 17,
	TOMOYO_TYPE_IS_FIFO = 18,
	TOMOYO_MODE_SETUID = 19,
	TOMOYO_MODE_SETGID = 20,
	TOMOYO_MODE_STICKY = 21,
	TOMOYO_MODE_OWNER_READ = 22,
	TOMOYO_MODE_OWNER_WRITE = 23,
	TOMOYO_MODE_OWNER_EXECUTE = 24,
	TOMOYO_MODE_GROUP_READ = 25,
	TOMOYO_MODE_GROUP_WRITE = 26,
	TOMOYO_MODE_GROUP_EXECUTE = 27,
	TOMOYO_MODE_OTHERS_READ = 28,
	TOMOYO_MODE_OTHERS_WRITE = 29,
	TOMOYO_MODE_OTHERS_EXECUTE = 30,
	TOMOYO_EXEC_REALPATH = 31,
	TOMOYO_SYMLINK_TARGET = 32,
	TOMOYO_PATH1_UID = 33,
	TOMOYO_PATH1_GID = 34,
	TOMOYO_PATH1_INO = 35,
	TOMOYO_PATH1_MAJOR = 36,
	TOMOYO_PATH1_MINOR = 37,
	TOMOYO_PATH1_PERM = 38,
	TOMOYO_PATH1_TYPE = 39,
	TOMOYO_PATH1_DEV_MAJOR = 40,
	TOMOYO_PATH1_DEV_MINOR = 41,
	TOMOYO_PATH2_UID = 42,
	TOMOYO_PATH2_GID = 43,
	TOMOYO_PATH2_INO = 44,
	TOMOYO_PATH2_MAJOR = 45,
	TOMOYO_PATH2_MINOR = 46,
	TOMOYO_PATH2_PERM = 47,
	TOMOYO_PATH2_TYPE = 48,
	TOMOYO_PATH2_DEV_MAJOR = 49,
	TOMOYO_PATH2_DEV_MINOR = 50,
	TOMOYO_PATH1_PARENT_UID = 51,
	TOMOYO_PATH1_PARENT_GID = 52,
	TOMOYO_PATH1_PARENT_INO = 53,
	TOMOYO_PATH1_PARENT_PERM = 54,
	TOMOYO_PATH2_PARENT_UID = 55,
	TOMOYO_PATH2_PARENT_GID = 56,
	TOMOYO_PATH2_PARENT_INO = 57,
	TOMOYO_PATH2_PARENT_PERM = 58,
	TOMOYO_MAX_CONDITION_KEYWORD = 59,
	TOMOYO_NUMBER_UNION = 60,
	TOMOYO_NAME_UNION = 61,
	TOMOYO_ARGV_ENTRY = 62,
	TOMOYO_ENVP_ENTRY = 63,
};

enum tomoyo_domain_info_flags_index {
	TOMOYO_DIF_QUOTA_WARNED = 0,
	TOMOYO_DIF_TRANSITION_FAILED = 1,
	TOMOYO_MAX_DOMAIN_INFO_FLAGS = 2,
};

enum tomoyo_grant_log {
	TOMOYO_GRANTLOG_AUTO = 0,
	TOMOYO_GRANTLOG_NO = 1,
	TOMOYO_GRANTLOG_YES = 2,
};

enum tomoyo_group_id {
	TOMOYO_PATH_GROUP = 0,
	TOMOYO_NUMBER_GROUP = 1,
	TOMOYO_ADDRESS_GROUP = 2,
	TOMOYO_MAX_GROUP = 3,
};

enum tomoyo_mac_category_index {
	TOMOYO_MAC_CATEGORY_FILE = 0,
	TOMOYO_MAC_CATEGORY_NETWORK = 1,
	TOMOYO_MAC_CATEGORY_MISC = 2,
	TOMOYO_MAX_MAC_CATEGORY_INDEX = 3,
};

enum tomoyo_mac_index {
	TOMOYO_MAC_FILE_EXECUTE = 0,
	TOMOYO_MAC_FILE_OPEN = 1,
	TOMOYO_MAC_FILE_CREATE = 2,
	TOMOYO_MAC_FILE_UNLINK = 3,
	TOMOYO_MAC_FILE_GETATTR = 4,
	TOMOYO_MAC_FILE_MKDIR = 5,
	TOMOYO_MAC_FILE_RMDIR = 6,
	TOMOYO_MAC_FILE_MKFIFO = 7,
	TOMOYO_MAC_FILE_MKSOCK = 8,
	TOMOYO_MAC_FILE_TRUNCATE = 9,
	TOMOYO_MAC_FILE_SYMLINK = 10,
	TOMOYO_MAC_FILE_MKBLOCK = 11,
	TOMOYO_MAC_FILE_MKCHAR = 12,
	TOMOYO_MAC_FILE_LINK = 13,
	TOMOYO_MAC_FILE_RENAME = 14,
	TOMOYO_MAC_FILE_CHMOD = 15,
	TOMOYO_MAC_FILE_CHOWN = 16,
	TOMOYO_MAC_FILE_CHGRP = 17,
	TOMOYO_MAC_FILE_IOCTL = 18,
	TOMOYO_MAC_FILE_CHROOT = 19,
	TOMOYO_MAC_FILE_MOUNT = 20,
	TOMOYO_MAC_FILE_UMOUNT = 21,
	TOMOYO_MAC_FILE_PIVOT_ROOT = 22,
	TOMOYO_MAC_NETWORK_INET_STREAM_BIND = 23,
	TOMOYO_MAC_NETWORK_INET_STREAM_LISTEN = 24,
	TOMOYO_MAC_NETWORK_INET_STREAM_CONNECT = 25,
	TOMOYO_MAC_NETWORK_INET_DGRAM_BIND = 26,
	TOMOYO_MAC_NETWORK_INET_DGRAM_SEND = 27,
	TOMOYO_MAC_NETWORK_INET_RAW_BIND = 28,
	TOMOYO_MAC_NETWORK_INET_RAW_SEND = 29,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_BIND = 30,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_LISTEN = 31,
	TOMOYO_MAC_NETWORK_UNIX_STREAM_CONNECT = 32,
	TOMOYO_MAC_NETWORK_UNIX_DGRAM_BIND = 33,
	TOMOYO_MAC_NETWORK_UNIX_DGRAM_SEND = 34,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_BIND = 35,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_LISTEN = 36,
	TOMOYO_MAC_NETWORK_UNIX_SEQPACKET_CONNECT = 37,
	TOMOYO_MAC_ENVIRON = 38,
	TOMOYO_MAX_MAC_INDEX = 39,
};

enum tomoyo_memory_stat_type {
	TOMOYO_MEMORY_POLICY = 0,
	TOMOYO_MEMORY_AUDIT = 1,
	TOMOYO_MEMORY_QUERY = 2,
	TOMOYO_MAX_MEMORY_STAT = 3,
};

enum tomoyo_mkdev_acl_index {
	TOMOYO_TYPE_MKBLOCK = 0,
	TOMOYO_TYPE_MKCHAR = 1,
	TOMOYO_MAX_MKDEV_OPERATION = 2,
};

enum tomoyo_mode_index {
	TOMOYO_CONFIG_DISABLED = 0,
	TOMOYO_CONFIG_LEARNING = 1,
	TOMOYO_CONFIG_PERMISSIVE = 2,
	TOMOYO_CONFIG_ENFORCING = 3,
	TOMOYO_CONFIG_MAX_MODE = 4,
	TOMOYO_CONFIG_WANT_REJECT_LOG = 64,
	TOMOYO_CONFIG_WANT_GRANT_LOG = 128,
	TOMOYO_CONFIG_USE_DEFAULT = 255,
};

enum tomoyo_network_acl_index {
	TOMOYO_NETWORK_BIND = 0,
	TOMOYO_NETWORK_LISTEN = 1,
	TOMOYO_NETWORK_CONNECT = 2,
	TOMOYO_NETWORK_SEND = 3,
	TOMOYO_MAX_NETWORK_OPERATION = 4,
};

enum tomoyo_path2_acl_index {
	TOMOYO_TYPE_LINK = 0,
	TOMOYO_TYPE_RENAME = 1,
	TOMOYO_TYPE_PIVOT_ROOT = 2,
	TOMOYO_MAX_PATH2_OPERATION = 3,
};

enum tomoyo_path_acl_index {
	TOMOYO_TYPE_EXECUTE = 0,
	TOMOYO_TYPE_READ = 1,
	TOMOYO_TYPE_WRITE = 2,
	TOMOYO_TYPE_APPEND = 3,
	TOMOYO_TYPE_UNLINK = 4,
	TOMOYO_TYPE_GETATTR = 5,
	TOMOYO_TYPE_RMDIR = 6,
	TOMOYO_TYPE_TRUNCATE = 7,
	TOMOYO_TYPE_SYMLINK = 8,
	TOMOYO_TYPE_CHROOT = 9,
	TOMOYO_TYPE_UMOUNT = 10,
	TOMOYO_MAX_PATH_OPERATION = 11,
};

enum tomoyo_path_number_acl_index {
	TOMOYO_TYPE_CREATE = 0,
	TOMOYO_TYPE_MKDIR = 1,
	TOMOYO_TYPE_MKFIFO = 2,
	TOMOYO_TYPE_MKSOCK = 3,
	TOMOYO_TYPE_IOCTL = 4,
	TOMOYO_TYPE_CHMOD = 5,
	TOMOYO_TYPE_CHOWN = 6,
	TOMOYO_TYPE_CHGRP = 7,
	TOMOYO_MAX_PATH_NUMBER_OPERATION = 8,
};

enum tomoyo_path_stat_index {
	TOMOYO_PATH1 = 0,
	TOMOYO_PATH1_PARENT = 1,
	TOMOYO_PATH2 = 2,
	TOMOYO_PATH2_PARENT = 3,
	TOMOYO_MAX_PATH_STAT = 4,
};

enum tomoyo_policy_id {
	TOMOYO_ID_GROUP = 0,
	TOMOYO_ID_ADDRESS_GROUP = 1,
	TOMOYO_ID_PATH_GROUP = 2,
	TOMOYO_ID_NUMBER_GROUP = 3,
	TOMOYO_ID_TRANSITION_CONTROL = 4,
	TOMOYO_ID_AGGREGATOR = 5,
	TOMOYO_ID_MANAGER = 6,
	TOMOYO_ID_CONDITION = 7,
	TOMOYO_ID_NAME = 8,
	TOMOYO_ID_ACL = 9,
	TOMOYO_ID_DOMAIN = 10,
	TOMOYO_MAX_POLICY = 11,
};

enum tomoyo_policy_stat_type {
	TOMOYO_STAT_POLICY_UPDATES = 0,
	TOMOYO_STAT_POLICY_LEARNING = 1,
	TOMOYO_STAT_POLICY_PERMISSIVE = 2,
	TOMOYO_STAT_POLICY_ENFORCING = 3,
	TOMOYO_MAX_POLICY_STAT = 4,
};

enum tomoyo_pref_index {
	TOMOYO_PREF_MAX_AUDIT_LOG = 0,
	TOMOYO_PREF_MAX_LEARNING_ENTRY = 1,
	TOMOYO_MAX_PREF = 2,
};

enum tomoyo_securityfs_interface_index {
	TOMOYO_DOMAINPOLICY = 0,
	TOMOYO_EXCEPTIONPOLICY = 1,
	TOMOYO_PROCESS_STATUS = 2,
	TOMOYO_STAT = 3,
	TOMOYO_AUDIT = 4,
	TOMOYO_VERSION = 5,
	TOMOYO_PROFILE = 6,
	TOMOYO_QUERY = 7,
	TOMOYO_MANAGER = 8,
};

enum tomoyo_special_mount {
	TOMOYO_MOUNT_BIND = 0,
	TOMOYO_MOUNT_MOVE = 1,
	TOMOYO_MOUNT_REMOUNT = 2,
	TOMOYO_MOUNT_MAKE_UNBINDABLE = 3,
	TOMOYO_MOUNT_MAKE_PRIVATE = 4,
	TOMOYO_MOUNT_MAKE_SLAVE = 5,
	TOMOYO_MOUNT_MAKE_SHARED = 6,
	TOMOYO_MAX_SPECIAL_MOUNT = 7,
};

enum tomoyo_transition_type {
	TOMOYO_TRANSITION_CONTROL_NO_RESET = 0,
	TOMOYO_TRANSITION_CONTROL_RESET = 1,
	TOMOYO_TRANSITION_CONTROL_NO_INITIALIZE = 2,
	TOMOYO_TRANSITION_CONTROL_INITIALIZE = 3,
	TOMOYO_TRANSITION_CONTROL_NO_KEEP = 4,
	TOMOYO_TRANSITION_CONTROL_KEEP = 5,
	TOMOYO_MAX_TRANSITION_TYPE = 6,
};

enum tomoyo_value_type {
	TOMOYO_VALUE_TYPE_INVALID = 0,
	TOMOYO_VALUE_TYPE_DECIMAL = 1,
	TOMOYO_VALUE_TYPE_OCTAL = 2,
	TOMOYO_VALUE_TYPE_HEXADECIMAL = 3,
};

enum topology_type {
	TYPE_INVALID = 0,
	TYPE_MUX = 1,
	TYPE_PLL = 2,
	TYPE_FIXEDFACTOR = 3,
	TYPE_DIV1 = 4,
	TYPE_DIV2 = 5,
	TYPE_GATE = 6,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpm2_capabilities {
	TPM2_CAP_HANDLES = 1,
	TPM2_CAP_COMMANDS = 2,
	TPM2_CAP_PCRS = 5,
	TPM2_CAP_TPM_PROPERTIES = 6,
};

enum tpm2_cc_attrs {
	TPM2_CC_ATTR_CHANDLES = 25,
	TPM2_CC_ATTR_RHANDLE = 28,
	TPM2_CC_ATTR_VENDOR = 29,
};

enum tpm2_command_codes {
	TPM2_CC_FIRST = 287,
	TPM2_CC_HIERARCHY_CONTROL = 289,
	TPM2_CC_HIERARCHY_CHANGE_AUTH = 297,
	TPM2_CC_CREATE_PRIMARY = 305,
	TPM2_CC_SEQUENCE_COMPLETE = 318,
	TPM2_CC_SELF_TEST = 323,
	TPM2_CC_STARTUP = 324,
	TPM2_CC_SHUTDOWN = 325,
	TPM2_CC_NV_READ = 334,
	TPM2_CC_CREATE = 339,
	TPM2_CC_LOAD = 343,
	TPM2_CC_SEQUENCE_UPDATE = 348,
	TPM2_CC_UNSEAL = 350,
	TPM2_CC_CONTEXT_LOAD = 353,
	TPM2_CC_CONTEXT_SAVE = 354,
	TPM2_CC_FLUSH_CONTEXT = 357,
	TPM2_CC_READ_PUBLIC = 371,
	TPM2_CC_START_AUTH_SESS = 374,
	TPM2_CC_VERIFY_SIGNATURE = 375,
	TPM2_CC_GET_CAPABILITY = 378,
	TPM2_CC_GET_RANDOM = 379,
	TPM2_CC_PCR_READ = 382,
	TPM2_CC_PCR_EXTEND = 386,
	TPM2_CC_EVENT_SEQUENCE_COMPLETE = 389,
	TPM2_CC_HASH_SEQUENCE_START = 390,
	TPM2_CC_CREATE_LOADED = 401,
	TPM2_CC_LAST = 403,
};

enum tpm2_const {
	TPM2_PLATFORM_PCR = 24,
	TPM2_PCR_SELECT_MIN = 3,
};

enum tpm2_curves {
	TPM2_ECC_NONE = 0,
	TPM2_ECC_NIST_P256 = 3,
};

enum tpm2_handle_types {
	TPM2_HT_HMAC_SESSION = 33554432,
	TPM2_HT_POLICY_SESSION = 50331648,
	TPM2_HT_TRANSIENT = 2147483648,
};

enum tpm2_mso_type {
	TPM2_MSO_NVRAM = 1,
	TPM2_MSO_SESSION = 2,
	TPM2_MSO_POLICY = 3,
	TPM2_MSO_PERMANENT = 64,
	TPM2_MSO_VOLATILE = 128,
	TPM2_MSO_PERSISTENT = 129,
};

enum tpm2_object_attributes {
	TPM2_OA_FIXED_TPM = 2,
	TPM2_OA_ST_CLEAR = 4,
	TPM2_OA_FIXED_PARENT = 16,
	TPM2_OA_SENSITIVE_DATA_ORIGIN = 32,
	TPM2_OA_USER_WITH_AUTH = 64,
	TPM2_OA_ADMIN_WITH_POLICY = 128,
	TPM2_OA_NO_DA = 1024,
	TPM2_OA_ENCRYPTED_DUPLICATION = 2048,
	TPM2_OA_RESTRICTED = 65536,
	TPM2_OA_DECRYPT = 131072,
	TPM2_OA_SIGN = 262144,
};

enum tpm2_permanent_handles {
	TPM2_RH_NULL = 1073741831,
	TPM2_RS_PW = 1073741833,
};

enum tpm2_properties {
	TPM_PT_TOTAL_COMMANDS = 297,
};

enum tpm2_return_codes {
	TPM2_RC_SUCCESS = 0,
	TPM2_RC_HASH = 131,
	TPM2_RC_HANDLE = 139,
	TPM2_RC_INTEGRITY = 159,
	TPM2_RC_INITIALIZE = 256,
	TPM2_RC_FAILURE = 257,
	TPM2_RC_DISABLED = 288,
	TPM2_RC_UPGRADE = 301,
	TPM2_RC_COMMAND_CODE = 323,
	TPM2_RC_TESTING = 2314,
	TPM2_RC_REFERENCE_H0 = 2320,
	TPM2_RC_RETRY = 2338,
};

enum tpm2_session_attributes {
	TPM2_SA_CONTINUE_SESSION = 1,
	TPM2_SA_AUDIT_EXCLUSIVE = 2,
	TPM2_SA_AUDIT_RESET = 8,
	TPM2_SA_DECRYPT = 32,
	TPM2_SA_ENCRYPT = 64,
	TPM2_SA_AUDIT = 128,
};

enum tpm2_session_types {
	TPM2_SE_HMAC = 0,
	TPM2_SE_POLICY = 1,
	TPM2_SE_TRIAL = 2,
};

enum tpm2_startup_types {
	TPM2_SU_CLEAR = 0,
	TPM2_SU_STATE = 1,
};

enum tpm2_structures {
	TPM2_ST_NO_SESSIONS = 32769,
	TPM2_ST_SESSIONS = 32770,
	TPM2_ST_CREATION = 32801,
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 2000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_MEDIUM = 750,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_LONG_LONG = 300000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm2key_actions {
	ACT_tpm2_key_parent = 0,
	ACT_tpm2_key_priv = 1,
	ACT_tpm2_key_pub = 2,
	ACT_tpm2_key_type = 3,
	NR__tpm2key_actions = 4,
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_AES = 6,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
	TPM_ALG_ECC = 35,
	TPM_ALG_CFB = 67,
};

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
	TPM_BUF_TPM2B = 2,
	TPM_BUF_BOUNDARY_ERROR = 4,
};

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
	TPM_CHIP_FLAG_DISABLE = 1024,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_pcrs {
	TPM_PCR0 = 0,
	TPM_PCR8 = 8,
	TPM_PCR10 = 10,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

enum tpm_tis_flags {
	TPM_TIS_ITPM_WORKAROUND = 0,
	TPM_TIS_INVALID_STATUS = 1,
	TPM_TIS_DEFAULT_CANCELLATION = 2,
	TPM_TIS_IRQ_TESTED = 3,
};

enum tpm_tis_io_mode {
	TPM_TIS_PHYS_8 = 0,
	TPM_TIS_PHYS_16 = 1,
	TPM_TIS_PHYS_32 = 2,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_IRQS_NOSUPPORT = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_TRACE_PRINTK_BIT = 23,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 24,
	TRACE_ITER_HASH_PTR_BIT = 25,
	TRACE_ITER_FUNCTION_BIT = 26,
	TRACE_ITER_FUNC_FORK_BIT = 27,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 28,
	TRACE_ITER_STACKTRACE_BIT = 29,
	TRACE_ITER_LAST_BIT = 30,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_PAUSE_ON_TRACE = 16777216,
	TRACE_ITER_HASH_PTR = 33554432,
	TRACE_ITER_FUNCTION = 67108864,
	TRACE_ITER_FUNC_FORK = 134217728,
	TRACE_ITER_DISPLAY_GRAPH = 268435456,
	TRACE_ITER_STACKTRACE = 536870912,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_USER_STACK = 12,
	TRACE_BLK = 13,
	TRACE_BPUTS = 14,
	TRACE_HWLAT = 15,
	TRACE_OSNOISE = 16,
	TRACE_TIMERLAT = 17,
	TRACE_RAW_DATA = 18,
	TRACE_FUNC_REPEATS = 19,
	__TRACE_LAST_TYPE = 20,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum trans_regime {
	TR_EL10 = 0,
	TR_EL20 = 1,
	TR_EL2 = 2,
};

enum transaction_flags {
	TF_ONE_WAY = 1,
	TF_ROOT_OBJECT = 4,
	TF_STATUS_CODE = 8,
	TF_ACCEPT_FDS = 16,
	TF_CLEAR_BUF = 32,
	TF_UPDATE_TXN = 64,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum trap_behaviour {
	BEHAVE_HANDLE_LOCALLY = 0,
	BEHAVE_FORWARD_READ = 1,
	BEHAVE_FORWARD_WRITE = 2,
	BEHAVE_FORWARD_ANY = 3,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb4_ba_index {
	USB4_BA_MAX_USB3 = 1,
	USB4_BA_MIN_DP_AUX = 2,
	USB4_BA_MIN_DP_MAIN = 3,
	USB4_BA_MAX_PCIE = 4,
	USB4_BA_MAX_HI = 5,
};

enum usb4_margin_sw_error_counter {
	USB4_MARGIN_SW_ERROR_COUNTER_NOP = 0,
	USB4_MARGIN_SW_ERROR_COUNTER_CLEAR = 1,
	USB4_MARGIN_SW_ERROR_COUNTER_START = 2,
	USB4_MARGIN_SW_ERROR_COUNTER_STOP = 3,
};

enum usb4_sb_opcode {
	USB4_SB_OPCODE_ERR = 542265925,
	USB4_SB_OPCODE_ONS = 1145914145,
	USB4_SB_OPCODE_ROUTER_OFFLINE = 1313166156,
	USB4_SB_OPCODE_ENUMERATE_RETIMERS = 1297436229,
	USB4_SB_OPCODE_SET_INBOUND_SBTX = 1347769164,
	USB4_SB_OPCODE_UNSET_INBOUND_SBTX = 1347769173,
	USB4_SB_OPCODE_QUERY_LAST_RETIMER = 1414742348,
	USB4_SB_OPCODE_QUERY_CABLE_RETIMER = 1380729411,
	USB4_SB_OPCODE_GET_NVM_SECTOR_SIZE = 1397968455,
	USB4_SB_OPCODE_NVM_SET_OFFSET = 1397772098,
	USB4_SB_OPCODE_NVM_BLOCK_WRITE = 1464552514,
	USB4_SB_OPCODE_NVM_AUTH_WRITE = 1213486401,
	USB4_SB_OPCODE_NVM_READ = 1381123649,
	USB4_SB_OPCODE_READ_LANE_MARGINING_CAP = 1346585682,
	USB4_SB_OPCODE_RUN_HW_LANE_MARGINING = 1196247122,
	USB4_SB_OPCODE_RUN_SW_LANE_MARGINING = 1196249938,
	USB4_SB_OPCODE_READ_SW_MARGIN_ERR = 1465074770,
};

enum usb4_sb_target {
	USB4_SB_TARGET_ROUTER = 0,
	USB4_SB_TARGET_PARTNER = 1,
	USB4_SB_TARGET_RETIMER = 2,
};

enum usb4_switch_op {
	USB4_SWITCH_OP_QUERY_DP_RESOURCE = 16,
	USB4_SWITCH_OP_ALLOC_DP_RESOURCE = 17,
	USB4_SWITCH_OP_DEALLOC_DP_RESOURCE = 18,
	USB4_SWITCH_OP_NVM_WRITE = 32,
	USB4_SWITCH_OP_NVM_AUTH = 33,
	USB4_SWITCH_OP_NVM_READ = 34,
	USB4_SWITCH_OP_NVM_SET_OFFSET = 35,
	USB4_SWITCH_OP_DROM_READ = 36,
	USB4_SWITCH_OP_NVM_SECTOR_SIZE = 37,
	USB4_SWITCH_OP_BUFFER_ALLOC = 51,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vcap_action_field {
	VCAP_AF_NO_VALUE = 0,
	VCAP_AF_ACL_ID = 1,
	VCAP_AF_CLS_VID_SEL = 2,
	VCAP_AF_CNT_ID = 3,
	VCAP_AF_COPY_PORT_NUM = 4,
	VCAP_AF_COPY_QUEUE_NUM = 5,
	VCAP_AF_CPU_COPY_ENA = 6,
	VCAP_AF_CPU_QU = 7,
	VCAP_AF_CPU_QUEUE_NUM = 8,
	VCAP_AF_CUSTOM_ACE_TYPE_ENA = 9,
	VCAP_AF_DEI_A_VAL = 10,
	VCAP_AF_DEI_B_VAL = 11,
	VCAP_AF_DEI_C_VAL = 12,
	VCAP_AF_DEI_ENA = 13,
	VCAP_AF_DEI_VAL = 14,
	VCAP_AF_DLR_SEL = 15,
	VCAP_AF_DP_ENA = 16,
	VCAP_AF_DP_VAL = 17,
	VCAP_AF_DSCP_ENA = 18,
	VCAP_AF_DSCP_SEL = 19,
	VCAP_AF_DSCP_VAL = 20,
	VCAP_AF_ES2_REW_CMD = 21,
	VCAP_AF_ESDX = 22,
	VCAP_AF_FWD_KILL_ENA = 23,
	VCAP_AF_FWD_MODE = 24,
	VCAP_AF_FWD_SEL = 25,
	VCAP_AF_HIT_ME_ONCE = 26,
	VCAP_AF_HOST_MATCH = 27,
	VCAP_AF_IGNORE_PIPELINE_CTRL = 28,
	VCAP_AF_INTR_ENA = 29,
	VCAP_AF_ISDX_ADD_REPLACE_SEL = 30,
	VCAP_AF_ISDX_ADD_VAL = 31,
	VCAP_AF_ISDX_ENA = 32,
	VCAP_AF_ISDX_REPLACE_ENA = 33,
	VCAP_AF_ISDX_VAL = 34,
	VCAP_AF_LOOP_ENA = 35,
	VCAP_AF_LRN_DIS = 36,
	VCAP_AF_MAP_IDX = 37,
	VCAP_AF_MAP_KEY = 38,
	VCAP_AF_MAP_LOOKUP_SEL = 39,
	VCAP_AF_MASK_MODE = 40,
	VCAP_AF_MATCH_ID = 41,
	VCAP_AF_MATCH_ID_MASK = 42,
	VCAP_AF_MIRROR_ENA = 43,
	VCAP_AF_MIRROR_PROBE = 44,
	VCAP_AF_MIRROR_PROBE_ID = 45,
	VCAP_AF_MRP_SEL = 46,
	VCAP_AF_NXT_IDX = 47,
	VCAP_AF_NXT_IDX_CTRL = 48,
	VCAP_AF_OAM_SEL = 49,
	VCAP_AF_PAG_OVERRIDE_MASK = 50,
	VCAP_AF_PAG_VAL = 51,
	VCAP_AF_PCP_A_VAL = 52,
	VCAP_AF_PCP_B_VAL = 53,
	VCAP_AF_PCP_C_VAL = 54,
	VCAP_AF_PCP_ENA = 55,
	VCAP_AF_PCP_VAL = 56,
	VCAP_AF_PIPELINE_ACT = 57,
	VCAP_AF_PIPELINE_FORCE_ENA = 58,
	VCAP_AF_PIPELINE_PT = 59,
	VCAP_AF_POLICE_ENA = 60,
	VCAP_AF_POLICE_IDX = 61,
	VCAP_AF_POLICE_REMARK = 62,
	VCAP_AF_POLICE_VCAP_ONLY = 63,
	VCAP_AF_POP_VAL = 64,
	VCAP_AF_PORT_MASK = 65,
	VCAP_AF_PUSH_CUSTOMER_TAG = 66,
	VCAP_AF_PUSH_INNER_TAG = 67,
	VCAP_AF_PUSH_OUTER_TAG = 68,
	VCAP_AF_QOS_ENA = 69,
	VCAP_AF_QOS_VAL = 70,
	VCAP_AF_REW_OP = 71,
	VCAP_AF_RT_DIS = 72,
	VCAP_AF_SFID_ENA = 73,
	VCAP_AF_SFID_VAL = 74,
	VCAP_AF_SGID_ENA = 75,
	VCAP_AF_SGID_VAL = 76,
	VCAP_AF_SWAP_MACS_ENA = 77,
	VCAP_AF_TAG_A_DEI_SEL = 78,
	VCAP_AF_TAG_A_PCP_SEL = 79,
	VCAP_AF_TAG_A_TPID_SEL = 80,
	VCAP_AF_TAG_A_VID_SEL = 81,
	VCAP_AF_TAG_B_DEI_SEL = 82,
	VCAP_AF_TAG_B_PCP_SEL = 83,
	VCAP_AF_TAG_B_TPID_SEL = 84,
	VCAP_AF_TAG_B_VID_SEL = 85,
	VCAP_AF_TAG_C_DEI_SEL = 86,
	VCAP_AF_TAG_C_PCP_SEL = 87,
	VCAP_AF_TAG_C_TPID_SEL = 88,
	VCAP_AF_TAG_C_VID_SEL = 89,
	VCAP_AF_TYPE = 90,
	VCAP_AF_UNTAG_VID_ENA = 91,
	VCAP_AF_VID_A_VAL = 92,
	VCAP_AF_VID_B_VAL = 93,
	VCAP_AF_VID_C_VAL = 94,
	VCAP_AF_VID_REPLACE_ENA = 95,
	VCAP_AF_VID_VAL = 96,
	VCAP_AF_VLAN_POP_CNT = 97,
	VCAP_AF_VLAN_POP_CNT_ENA = 98,
};

enum vcap_actionfield_set {
	VCAP_AFS_NO_VALUE = 0,
	VCAP_AFS_BASE_TYPE = 1,
	VCAP_AFS_CLASSIFICATION = 2,
	VCAP_AFS_CLASS_REDUCED = 3,
	VCAP_AFS_ES0 = 4,
	VCAP_AFS_FULL = 5,
	VCAP_AFS_S1 = 6,
	VCAP_AFS_SMAC_SIP = 7,
	VCAP_AFS_VID = 8,
};

enum vcap_arp_opcode {
	VCAP_ARP_OP_RESERVED = 0,
	VCAP_ARP_OP_REQUEST = 1,
	VCAP_ARP_OP_REPLY = 2,
};

enum vcap_bit {
	VCAP_BIT_ANY = 0,
	VCAP_BIT_0 = 1,
	VCAP_BIT_1 = 2,
};

enum vcap_command {
	VCAP_CMD_WRITE = 0,
	VCAP_CMD_READ = 1,
	VCAP_CMD_MOVE_DOWN = 2,
	VCAP_CMD_MOVE_UP = 3,
	VCAP_CMD_INITIALIZE = 4,
};

enum vcap_field_type {
	VCAP_FIELD_BIT = 0,
	VCAP_FIELD_U32 = 1,
	VCAP_FIELD_U48 = 2,
	VCAP_FIELD_U56 = 3,
	VCAP_FIELD_U64 = 4,
	VCAP_FIELD_U72 = 5,
	VCAP_FIELD_U112 = 6,
	VCAP_FIELD_U128 = 7,
};

enum vcap_is2_arp_opcode {
	VCAP_IS2_ARP_REQUEST = 0,
	VCAP_IS2_ARP_REPLY = 1,
	VCAP_IS2_RARP_REQUEST = 2,
	VCAP_IS2_RARP_REPLY = 3,
};

enum vcap_key_field {
	VCAP_KF_NO_VALUE = 0,
	VCAP_KF_8021BR_ECID_BASE = 1,
	VCAP_KF_8021BR_ECID_EXT = 2,
	VCAP_KF_8021BR_E_TAGGED = 3,
	VCAP_KF_8021BR_GRP = 4,
	VCAP_KF_8021BR_IGR_ECID_BASE = 5,
	VCAP_KF_8021BR_IGR_ECID_EXT = 6,
	VCAP_KF_8021CB_R_TAGGED_IS = 7,
	VCAP_KF_8021Q_DEI0 = 8,
	VCAP_KF_8021Q_DEI1 = 9,
	VCAP_KF_8021Q_DEI2 = 10,
	VCAP_KF_8021Q_DEI_CLS = 11,
	VCAP_KF_8021Q_PCP0 = 12,
	VCAP_KF_8021Q_PCP1 = 13,
	VCAP_KF_8021Q_PCP2 = 14,
	VCAP_KF_8021Q_PCP_CLS = 15,
	VCAP_KF_8021Q_TPID = 16,
	VCAP_KF_8021Q_TPID0 = 17,
	VCAP_KF_8021Q_TPID1 = 18,
	VCAP_KF_8021Q_TPID2 = 19,
	VCAP_KF_8021Q_VID0 = 20,
	VCAP_KF_8021Q_VID1 = 21,
	VCAP_KF_8021Q_VID2 = 22,
	VCAP_KF_8021Q_VID_CLS = 23,
	VCAP_KF_8021Q_VLAN_DBL_TAGGED_IS = 24,
	VCAP_KF_8021Q_VLAN_TAGGED_IS = 25,
	VCAP_KF_8021Q_VLAN_TAGS = 26,
	VCAP_KF_ACL_GRP_ID = 27,
	VCAP_KF_ARP_ADDR_SPACE_OK_IS = 28,
	VCAP_KF_ARP_LEN_OK_IS = 29,
	VCAP_KF_ARP_OPCODE = 30,
	VCAP_KF_ARP_OPCODE_UNKNOWN_IS = 31,
	VCAP_KF_ARP_PROTO_SPACE_OK_IS = 32,
	VCAP_KF_ARP_SENDER_MATCH_IS = 33,
	VCAP_KF_ARP_TGT_MATCH_IS = 34,
	VCAP_KF_COSID_CLS = 35,
	VCAP_KF_ES0_ISDX_KEY_ENA = 36,
	VCAP_KF_ETYPE = 37,
	VCAP_KF_ETYPE_LEN_IS = 38,
	VCAP_KF_HOST_MATCH = 39,
	VCAP_KF_IF_EGR_PORT_MASK = 40,
	VCAP_KF_IF_EGR_PORT_MASK_RNG = 41,
	VCAP_KF_IF_EGR_PORT_NO = 42,
	VCAP_KF_IF_IGR_PORT = 43,
	VCAP_KF_IF_IGR_PORT_MASK = 44,
	VCAP_KF_IF_IGR_PORT_MASK_L3 = 45,
	VCAP_KF_IF_IGR_PORT_MASK_RNG = 46,
	VCAP_KF_IF_IGR_PORT_MASK_SEL = 47,
	VCAP_KF_IF_IGR_PORT_SEL = 48,
	VCAP_KF_IP4_IS = 49,
	VCAP_KF_IP_MC_IS = 50,
	VCAP_KF_IP_PAYLOAD_5TUPLE = 51,
	VCAP_KF_IP_PAYLOAD_S1_IP6 = 52,
	VCAP_KF_IP_SNAP_IS = 53,
	VCAP_KF_ISDX_CLS = 54,
	VCAP_KF_ISDX_GT0_IS = 55,
	VCAP_KF_L2_BC_IS = 56,
	VCAP_KF_L2_DMAC = 57,
	VCAP_KF_L2_FRM_TYPE = 58,
	VCAP_KF_L2_FWD_IS = 59,
	VCAP_KF_L2_LLC = 60,
	VCAP_KF_L2_MAC = 61,
	VCAP_KF_L2_MC_IS = 62,
	VCAP_KF_L2_PAYLOAD0 = 63,
	VCAP_KF_L2_PAYLOAD1 = 64,
	VCAP_KF_L2_PAYLOAD2 = 65,
	VCAP_KF_L2_PAYLOAD_ETYPE = 66,
	VCAP_KF_L2_SMAC = 67,
	VCAP_KF_L2_SNAP = 68,
	VCAP_KF_L3_DIP_EQ_SIP_IS = 69,
	VCAP_KF_L3_DPL_CLS = 70,
	VCAP_KF_L3_DSCP = 71,
	VCAP_KF_L3_DST_IS = 72,
	VCAP_KF_L3_FRAGMENT = 73,
	VCAP_KF_L3_FRAGMENT_TYPE = 74,
	VCAP_KF_L3_FRAG_INVLD_L4_LEN = 75,
	VCAP_KF_L3_FRAG_OFS_GT0 = 76,
	VCAP_KF_L3_IP4_DIP = 77,
	VCAP_KF_L3_IP4_SIP = 78,
	VCAP_KF_L3_IP6_DIP = 79,
	VCAP_KF_L3_IP6_DIP_MSB = 80,
	VCAP_KF_L3_IP6_SIP = 81,
	VCAP_KF_L3_IP6_SIP_MSB = 82,
	VCAP_KF_L3_IP_PROTO = 83,
	VCAP_KF_L3_OPTIONS_IS = 84,
	VCAP_KF_L3_PAYLOAD = 85,
	VCAP_KF_L3_RT_IS = 86,
	VCAP_KF_L3_TOS = 87,
	VCAP_KF_L3_TTL_GT0 = 88,
	VCAP_KF_L4_1588_DOM = 89,
	VCAP_KF_L4_1588_VER = 90,
	VCAP_KF_L4_ACK = 91,
	VCAP_KF_L4_DPORT = 92,
	VCAP_KF_L4_FIN = 93,
	VCAP_KF_L4_PAYLOAD = 94,
	VCAP_KF_L4_PSH = 95,
	VCAP_KF_L4_RNG = 96,
	VCAP_KF_L4_RST = 97,
	VCAP_KF_L4_SEQUENCE_EQ0_IS = 98,
	VCAP_KF_L4_SPORT = 99,
	VCAP_KF_L4_SPORT_EQ_DPORT_IS = 100,
	VCAP_KF_L4_SYN = 101,
	VCAP_KF_L4_URG = 102,
	VCAP_KF_LOOKUP_FIRST_IS = 103,
	VCAP_KF_LOOKUP_GEN_IDX = 104,
	VCAP_KF_LOOKUP_GEN_IDX_SEL = 105,
	VCAP_KF_LOOKUP_INDEX = 106,
	VCAP_KF_LOOKUP_PAG = 107,
	VCAP_KF_MIRROR_PROBE = 108,
	VCAP_KF_OAM_CCM_CNTS_EQ0 = 109,
	VCAP_KF_OAM_DETECTED = 110,
	VCAP_KF_OAM_FLAGS = 111,
	VCAP_KF_OAM_MEL_FLAGS = 112,
	VCAP_KF_OAM_MEPID = 113,
	VCAP_KF_OAM_OPCODE = 114,
	VCAP_KF_OAM_VER = 115,
	VCAP_KF_OAM_Y1731_IS = 116,
	VCAP_KF_PDU_TYPE = 117,
	VCAP_KF_PROT_ACTIVE = 118,
	VCAP_KF_RTP_ID = 119,
	VCAP_KF_RT_FRMID = 120,
	VCAP_KF_RT_TYPE = 121,
	VCAP_KF_RT_VLAN_IDX = 122,
	VCAP_KF_TCP_IS = 123,
	VCAP_KF_TCP_UDP_IS = 124,
	VCAP_KF_TYPE = 125,
};

enum vcap_keyfield_set {
	VCAP_KFS_NO_VALUE = 0,
	VCAP_KFS_5TUPLE_IP4 = 1,
	VCAP_KFS_5TUPLE_IP6 = 2,
	VCAP_KFS_7TUPLE = 3,
	VCAP_KFS_ARP = 4,
	VCAP_KFS_DBL_VID = 5,
	VCAP_KFS_DMAC_VID = 6,
	VCAP_KFS_ETAG = 7,
	VCAP_KFS_IP4_OTHER = 8,
	VCAP_KFS_IP4_TCP_UDP = 9,
	VCAP_KFS_IP4_VID = 10,
	VCAP_KFS_IP6_OTHER = 11,
	VCAP_KFS_IP6_STD = 12,
	VCAP_KFS_IP6_TCP_UDP = 13,
	VCAP_KFS_IP6_VID = 14,
	VCAP_KFS_IP_7TUPLE = 15,
	VCAP_KFS_ISDX = 16,
	VCAP_KFS_LL_FULL = 17,
	VCAP_KFS_MAC_ETYPE = 18,
	VCAP_KFS_MAC_LLC = 19,
	VCAP_KFS_MAC_SNAP = 20,
	VCAP_KFS_NORMAL = 21,
	VCAP_KFS_NORMAL_5TUPLE_IP4 = 22,
	VCAP_KFS_NORMAL_7TUPLE = 23,
	VCAP_KFS_NORMAL_IP6 = 24,
	VCAP_KFS_OAM = 25,
	VCAP_KFS_PURE_5TUPLE_IP4 = 26,
	VCAP_KFS_RT = 27,
	VCAP_KFS_SMAC_SIP4 = 28,
	VCAP_KFS_SMAC_SIP6 = 29,
	VCAP_KFS_VID = 30,
};

enum vcap_rule_error {
	VCAP_ERR_NONE = 0,
	VCAP_ERR_NO_ADMIN = 1,
	VCAP_ERR_NO_NETDEV = 2,
	VCAP_ERR_NO_KEYSET_MATCH = 3,
	VCAP_ERR_NO_ACTIONSET_MATCH = 4,
	VCAP_ERR_NO_PORT_KEYSET_MATCH = 5,
};

enum vcap_rule_state {
	VCAP_RS_PERMANENT = 0,
	VCAP_RS_ENABLED = 1,
	VCAP_RS_DISABLED = 2,
};

enum vcap_selection {
	VCAP_SEL_ENTRY = 1,
	VCAP_SEL_ACTION = 2,
	VCAP_SEL_COUNTER = 4,
	VCAP_SEL_ALL = 255,
};

enum vcap_type {
	VCAP_TYPE_ES0 = 0,
	VCAP_TYPE_ES2 = 1,
	VCAP_TYPE_IS0 = 2,
	VCAP_TYPE_IS1 = 3,
	VCAP_TYPE_IS2 = 4,
	VCAP_TYPE_MAX = 5,
};

enum vcap_user {
	VCAP_USER_PTP = 0,
	VCAP_USER_MRP = 1,
	VCAP_USER_CFM = 2,
	VCAP_USER_VLAN = 3,
	VCAP_USER_QOS = 4,
	VCAP_USER_VCAP_UTIL = 5,
	VCAP_USER_TC = 6,
	VCAP_USER_TC_EXTRA = 7,
	__VCAP_USER_AFTER_LAST = 8,
	VCAP_USER_MAX = 7,
};

enum vcpu_sysreg {
	__INVALID_SYSREG__ = 0,
	MPIDR_EL1 = 1,
	CLIDR_EL1 = 2,
	CSSELR_EL1 = 3,
	TPIDR_EL0 = 4,
	TPIDRRO_EL0 = 5,
	TPIDR_EL1 = 6,
	CNTKCTL_EL1 = 7,
	PAR_EL1 = 8,
	MDCCINT_EL1 = 9,
	OSLSR_EL1 = 10,
	DISR_EL1 = 11,
	PMCR_EL0 = 12,
	PMSELR_EL0 = 13,
	PMEVCNTR0_EL0 = 14,
	PMEVCNTR30_EL0 = 44,
	PMCCNTR_EL0 = 45,
	PMEVTYPER0_EL0 = 46,
	PMEVTYPER30_EL0 = 76,
	PMCCFILTR_EL0 = 77,
	PMCNTENSET_EL0 = 78,
	PMINTENSET_EL1 = 79,
	PMOVSSET_EL0 = 80,
	PMUSERENR_EL0 = 81,
	APIAKEYLO_EL1 = 82,
	APIAKEYHI_EL1 = 83,
	APIBKEYLO_EL1 = 84,
	APIBKEYHI_EL1 = 85,
	APDAKEYLO_EL1 = 86,
	APDAKEYHI_EL1 = 87,
	APDBKEYLO_EL1 = 88,
	APDBKEYHI_EL1 = 89,
	APGAKEYLO_EL1 = 90,
	APGAKEYHI_EL1 = 91,
	RGSR_EL1 = 92,
	GCR_EL1 = 93,
	TFSRE0_EL1 = 94,
	POR_EL0 = 95,
	SVCR = 96,
	FPMR = 97,
	DACR32_EL2 = 98,
	IFSR32_EL2 = 99,
	FPEXC32_EL2 = 100,
	DBGVCR32_EL2 = 101,
	SCTLR_EL2 = 102,
	ACTLR_EL2 = 103,
	MDCR_EL2 = 104,
	CPTR_EL2 = 105,
	HACR_EL2 = 106,
	ZCR_EL2 = 107,
	TTBR0_EL2 = 108,
	TTBR1_EL2 = 109,
	TCR_EL2 = 110,
	SPSR_EL2 = 111,
	ELR_EL2 = 112,
	AFSR0_EL2 = 113,
	AFSR1_EL2 = 114,
	ESR_EL2 = 115,
	FAR_EL2 = 116,
	HPFAR_EL2 = 117,
	MAIR_EL2 = 118,
	AMAIR_EL2 = 119,
	VBAR_EL2 = 120,
	RVBAR_EL2 = 121,
	CONTEXTIDR_EL2 = 122,
	CNTHCTL_EL2 = 123,
	SP_EL2 = 124,
	CNTHP_CTL_EL2 = 125,
	CNTHP_CVAL_EL2 = 126,
	CNTHV_CTL_EL2 = 127,
	CNTHV_CVAL_EL2 = 128,
	__VNCR_START__ = 129,
	__before_SCTLR_EL1 = 130,
	SCTLR_EL1 = 163,
	__after_SCTLR_EL1 = 163,
	__before_ACTLR_EL1 = 164,
	ACTLR_EL1 = 164,
	__after_ACTLR_EL1 = 164,
	__before_CPACR_EL1 = 165,
	CPACR_EL1 = 161,
	__after_CPACR_EL1 = 164,
	__before_ZCR_EL1 = 165,
	ZCR_EL1 = 189,
	__after_ZCR_EL1 = 189,
	__before_TTBR0_EL1 = 190,
	TTBR0_EL1 = 193,
	__after_TTBR0_EL1 = 193,
	__before_TTBR1_EL1 = 194,
	TTBR1_EL1 = 195,
	__after_TTBR1_EL1 = 195,
	__before_TCR_EL1 = 196,
	TCR_EL1 = 165,
	__after_TCR_EL1 = 195,
	__before_TCR2_EL1 = 196,
	TCR2_EL1 = 207,
	__after_TCR2_EL1 = 207,
	__before_ESR_EL1 = 208,
	ESR_EL1 = 168,
	__after_ESR_EL1 = 207,
	__before_AFSR0_EL1 = 208,
	AFSR0_EL1 = 166,
	__after_AFSR0_EL1 = 207,
	__before_AFSR1_EL1 = 208,
	AFSR1_EL1 = 167,
	__after_AFSR1_EL1 = 207,
	__before_FAR_EL1 = 208,
	FAR_EL1 = 197,
	__after_FAR_EL1 = 207,
	__before_MAIR_EL1 = 208,
	MAIR_EL1 = 169,
	__after_MAIR_EL1 = 207,
	__before_VBAR_EL1 = 208,
	VBAR_EL1 = 203,
	__after_VBAR_EL1 = 207,
	__before_CONTEXTIDR_EL1 = 208,
	CONTEXTIDR_EL1 = 162,
	__after_CONTEXTIDR_EL1 = 207,
	__before_AMAIR_EL1 = 208,
	AMAIR_EL1 = 170,
	__after_AMAIR_EL1 = 207,
	__before_MDSCR_EL1 = 208,
	MDSCR_EL1 = 172,
	__after_MDSCR_EL1 = 207,
	__before_ELR_EL1 = 208,
	ELR_EL1 = 199,
	__after_ELR_EL1 = 207,
	__before_SP_EL1 = 208,
	SP_EL1 = 201,
	__after_SP_EL1 = 207,
	__before_SPSR_EL1 = 208,
	SPSR_EL1 = 173,
	__after_SPSR_EL1 = 207,
	__before_TFSR_EL1 = 208,
	TFSR_EL1 = 179,
	__after_TFSR_EL1 = 207,
	__before_VPIDR_EL2 = 208,
	VPIDR_EL2 = 146,
	__after_VPIDR_EL2 = 207,
	__before_VMPIDR_EL2 = 208,
	VMPIDR_EL2 = 139,
	__after_VMPIDR_EL2 = 207,
	__before_HCR_EL2 = 208,
	HCR_EL2 = 144,
	__after_HCR_EL2 = 207,
	__before_HSTR_EL2 = 208,
	HSTR_EL2 = 145,
	__after_HSTR_EL2 = 207,
	__before_VTTBR_EL2 = 208,
	VTTBR_EL2 = 133,
	__after_VTTBR_EL2 = 207,
	__before_VTCR_EL2 = 208,
	VTCR_EL2 = 137,
	__after_VTCR_EL2 = 207,
	__before_TPIDR_EL2 = 208,
	TPIDR_EL2 = 147,
	__after_TPIDR_EL2 = 207,
	__before_HCRX_EL2 = 208,
	HCRX_EL2 = 149,
	__after_HCRX_EL2 = 207,
	__before_PIR_EL1 = 208,
	PIR_EL1 = 213,
	__after_PIR_EL1 = 213,
	__before_PIRE0_EL1 = 214,
	PIRE0_EL1 = 211,
	__after_PIRE0_EL1 = 213,
	__before_POR_EL1 = 214,
	POR_EL1 = 214,
	__after_POR_EL1 = 214,
	__before_HFGRTR_EL2 = 215,
	HFGRTR_EL2 = 184,
	__after_HFGRTR_EL2 = 214,
	__before_HFGWTR_EL2 = 215,
	HFGWTR_EL2 = 185,
	__after_HFGWTR_EL2 = 214,
	__before_HFGITR_EL2 = 215,
	HFGITR_EL2 = 186,
	__after_HFGITR_EL2 = 214,
	__before_HDFGRTR_EL2 = 215,
	HDFGRTR_EL2 = 187,
	__after_HDFGRTR_EL2 = 214,
	__before_HDFGWTR_EL2 = 215,
	HDFGWTR_EL2 = 188,
	__after_HDFGWTR_EL2 = 214,
	__before_HAFGRTR_EL2 = 215,
	HAFGRTR_EL2 = 190,
	__after_HAFGRTR_EL2 = 214,
	__before_CNTVOFF_EL2 = 215,
	CNTVOFF_EL2 = 141,
	__after_CNTVOFF_EL2 = 214,
	__before_CNTV_CVAL_EL0 = 215,
	CNTV_CVAL_EL0 = 174,
	__after_CNTV_CVAL_EL0 = 214,
	__before_CNTV_CTL_EL0 = 215,
	CNTV_CTL_EL0 = 175,
	__after_CNTV_CTL_EL0 = 214,
	__before_CNTP_CVAL_EL0 = 215,
	CNTP_CVAL_EL0 = 176,
	__after_CNTP_CVAL_EL0 = 214,
	__before_CNTP_CTL_EL0 = 215,
	CNTP_CTL_EL0 = 177,
	__after_CNTP_CTL_EL0 = 214,
	__before_ICH_HCR_EL2 = 215,
	ICH_HCR_EL2 = 281,
	__after_ICH_HCR_EL2 = 281,
	NR_SYS_REGS = 282,
};

enum vdso_abi {
	VDSO_ABI_AA64 = 0,
	VDSO_ABI_AA32 = 1,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_ARCHTIMER_NOCOMPAT = 2,
	VDSO_CLOCKMODE_MAX = 3,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vec_type {
	ARM64_VEC_SVE = 0,
	ARM64_VEC_SME = 1,
	ARM64_VEC_MAX = 2,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vexpress_reset_func {
	FUNC_RESET = 0,
	FUNC_SHUTDOWN = 1,
	FUNC_REBOOT = 2,
};

enum vgic_irq_config {
	VGIC_CONFIG_EDGE = 0,
	VGIC_CONFIG_LEVEL = 1,
};

enum vgic_type {
	VGIC_V2 = 0,
	VGIC_V3 = 1,
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
	VHOST_TASK_FLAGS_KILLED = 1,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	PGALLOC_DEVICE = 8,
	ALLOCSTALL_DMA = 9,
	ALLOCSTALL_DMA32 = 10,
	ALLOCSTALL_NORMAL = 11,
	ALLOCSTALL_MOVABLE = 12,
	ALLOCSTALL_DEVICE = 13,
	PGSCAN_SKIP_DMA = 14,
	PGSCAN_SKIP_DMA32 = 15,
	PGSCAN_SKIP_NORMAL = 16,
	PGSCAN_SKIP_MOVABLE = 17,
	PGSCAN_SKIP_DEVICE = 18,
	PGFREE = 19,
	PGACTIVATE = 20,
	PGDEACTIVATE = 21,
	PGLAZYFREE = 22,
	PGFAULT = 23,
	PGMAJFAULT = 24,
	PGLAZYFREED = 25,
	PGREFILL = 26,
	PGREUSE = 27,
	PGSTEAL_KSWAPD = 28,
	PGSTEAL_DIRECT = 29,
	PGSTEAL_KHUGEPAGED = 30,
	PGSCAN_KSWAPD = 31,
	PGSCAN_DIRECT = 32,
	PGSCAN_KHUGEPAGED = 33,
	PGSCAN_DIRECT_THROTTLE = 34,
	PGSCAN_ANON = 35,
	PGSCAN_FILE = 36,
	PGSTEAL_ANON = 37,
	PGSTEAL_FILE = 38,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 39,
	PGSCAN_ZONE_RECLAIM_FAILED = 40,
	PGINODESTEAL = 41,
	SLABS_SCANNED = 42,
	KSWAPD_INODESTEAL = 43,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 44,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 45,
	PAGEOUTRUN = 46,
	PGROTATED = 47,
	DROP_PAGECACHE = 48,
	DROP_SLAB = 49,
	OOM_KILL = 50,
	NUMA_PTE_UPDATES = 51,
	NUMA_HUGE_PTE_UPDATES = 52,
	NUMA_HINT_FAULTS = 53,
	NUMA_HINT_FAULTS_LOCAL = 54,
	NUMA_PAGE_MIGRATE = 55,
	PGMIGRATE_SUCCESS = 56,
	PGMIGRATE_FAIL = 57,
	THP_MIGRATION_SUCCESS = 58,
	THP_MIGRATION_FAIL = 59,
	THP_MIGRATION_SPLIT = 60,
	COMPACTMIGRATE_SCANNED = 61,
	COMPACTFREE_SCANNED = 62,
	COMPACTISOLATED = 63,
	COMPACTSTALL = 64,
	COMPACTFAIL = 65,
	COMPACTSUCCESS = 66,
	KCOMPACTD_WAKE = 67,
	KCOMPACTD_MIGRATE_SCANNED = 68,
	KCOMPACTD_FREE_SCANNED = 69,
	HTLB_BUDDY_PGALLOC = 70,
	HTLB_BUDDY_PGALLOC_FAIL = 71,
	CMA_ALLOC_SUCCESS = 72,
	CMA_ALLOC_FAIL = 73,
	UNEVICTABLE_PGCULLED = 74,
	UNEVICTABLE_PGSCANNED = 75,
	UNEVICTABLE_PGRESCUED = 76,
	UNEVICTABLE_PGMLOCKED = 77,
	UNEVICTABLE_PGMUNLOCKED = 78,
	UNEVICTABLE_PGCLEARED = 79,
	UNEVICTABLE_PGSTRANDED = 80,
	THP_FAULT_ALLOC = 81,
	THP_FAULT_FALLBACK = 82,
	THP_FAULT_FALLBACK_CHARGE = 83,
	THP_COLLAPSE_ALLOC = 84,
	THP_COLLAPSE_ALLOC_FAILED = 85,
	THP_FILE_ALLOC = 86,
	THP_FILE_FALLBACK = 87,
	THP_FILE_FALLBACK_CHARGE = 88,
	THP_FILE_MAPPED = 89,
	THP_SPLIT_PAGE = 90,
	THP_SPLIT_PAGE_FAILED = 91,
	THP_DEFERRED_SPLIT_PAGE = 92,
	THP_UNDERUSED_SPLIT_PAGE = 93,
	THP_SPLIT_PMD = 94,
	THP_SCAN_EXCEED_NONE_PTE = 95,
	THP_SCAN_EXCEED_SWAP_PTE = 96,
	THP_SCAN_EXCEED_SHARED_PTE = 97,
	THP_ZERO_PAGE_ALLOC = 98,
	THP_ZERO_PAGE_ALLOC_FAILED = 99,
	THP_SWPOUT = 100,
	THP_SWPOUT_FALLBACK = 101,
	BALLOON_INFLATE = 102,
	BALLOON_DEFLATE = 103,
	BALLOON_MIGRATE = 104,
	SWAP_RA = 105,
	SWAP_RA_HIT = 106,
	SWPIN_ZERO = 107,
	SWPOUT_ZERO = 108,
	KSM_SWPIN_COPY = 109,
	COW_KSM = 110,
	ZSWPIN = 111,
	ZSWPOUT = 112,
	ZSWPWB = 113,
	NR_VM_EVENT_ITEMS = 114,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_flags {
	VMG_FLAG_DEFAULT = 0,
	VMG_FLAG_JUST_EXPAND = 1,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

enum vvar_pages {
	VVAR_DATA_PAGE_OFFSET = 0,
	VVAR_TIMENS_PAGE_OFFSET = 1,
	VVAR_NR_PAGES = 2,
};

enum watch_meta_notification_subtype {
	WATCH_META_REMOVAL_NOTIFICATION = 0,
	WATCH_META_LOSS_NOTIFICATION = 1,
};

enum watch_notification_type {
	WATCH_TYPE_META = 0,
	WATCH_TYPE_KEY_NOTIFY = 1,
	WATCH_TYPE__NR = 2,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 512,
	WQ_UNBOUND_MAX_ACTIVE = 512,
	WQ_DFL_ACTIVE = 256,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 300000,
	MAYDAY_INITIAL_TIMEOUT = 10,
	MAYDAY_INTERVAL = 100,
	CREATE_COOLDOWN = 1000,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 4096,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum wwan_port_type {
	WWAN_PORT_AT = 0,
	WWAN_PORT_MBIM = 1,
	WWAN_PORT_QMI = 2,
	WWAN_PORT_QCDM = 3,
	WWAN_PORT_FIREHOSE = 4,
	WWAN_PORT_XMMRPC = 5,
	WWAN_PORT_FASTBOOT = 6,
	__WWAN_PORT_MAX = 7,
	WWAN_PORT_MAX = 6,
	WWAN_PORT_UNKNOWN = 7,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	__XFRMA_MAX = 35,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xfrm_sadattr_type_t {
	XFRMA_SAD_UNSPEC = 0,
	XFRMA_SAD_CNT = 1,
	XFRMA_SAD_HINFO = 2,
	__XFRMA_SAD_MAX = 3,
};

enum xfrm_spdattr_type_t {
	XFRMA_SPD_UNSPEC = 0,
	XFRMA_SPD_INFO = 1,
	XFRMA_SPD_HINFO = 2,
	XFRMA_SPD_IPV4_HTHRESH = 3,
	XFRMA_SPD_IPV6_HTHRESH = 4,
	__XFRMA_SPD_MAX = 5,
};

enum xgene_phy_mode {
	MODE_SATA = 0,
	MODE_SGMII = 1,
	MODE_PCIE = 2,
	MODE_USB = 3,
	MODE_XFI = 4,
	MODE_MAX___2 = 5,
};

enum xgene_pll_type {
	PLL_TYPE_PCP = 0,
	PLL_TYPE_SOC = 1,
};

enum xgene_pmu_dev_type {
	PMU_TYPE_L3C = 0,
	PMU_TYPE_IOB = 1,
	PMU_TYPE_IOB_SLOW = 2,
	PMU_TYPE_MCB = 3,
	PMU_TYPE_MC = 4,
};

enum xgene_pmu_version {
	PCP_PMU_V1 = 1,
	PCP_PMU_V2 = 2,
	PCP_PMU_V3 = 3,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xilinx_cpm_version {
	CPM = 0,
	CPM5 = 1,
};

enum xilinx_pl_dma_version {
	XDMA = 0,
	QDMA = 1,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	ZONE_DEVICE = 4,
	__MAX_NR_ZONES = 5,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zpool_mapmode {
	ZPOOL_MM_RW = 0,
	ZPOOL_MM_RO = 1,
	ZPOOL_MM_WO = 2,
	ZPOOL_MM_DEFAULT = 0,
};

enum zs_mapmode {
	ZS_MM_RW = 0,
	ZS_MM_RO = 1,
	ZS_MM_WO = 2,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

enum zynqmp_pm_request_ack {
	ZYNQMP_PM_REQUEST_ACK_NO = 1,
	ZYNQMP_PM_REQUEST_ACK_BLOCKING = 2,
	ZYNQMP_PM_REQUEST_ACK_NON_BLOCKING = 3,
};

enum zynqmp_pm_reset {
	ZYNQMP_PM_RESET_START = 1000,
	ZYNQMP_PM_RESET_PCIE_CFG = 1000,
	ZYNQMP_PM_RESET_PCIE_BRIDGE = 1001,
	ZYNQMP_PM_RESET_PCIE_CTRL = 1002,
	ZYNQMP_PM_RESET_DP = 1003,
	ZYNQMP_PM_RESET_SWDT_CRF = 1004,
	ZYNQMP_PM_RESET_AFI_FM5 = 1005,
	ZYNQMP_PM_RESET_AFI_FM4 = 1006,
	ZYNQMP_PM_RESET_AFI_FM3 = 1007,
	ZYNQMP_PM_RESET_AFI_FM2 = 1008,
	ZYNQMP_PM_RESET_AFI_FM1 = 1009,
	ZYNQMP_PM_RESET_AFI_FM0 = 1010,
	ZYNQMP_PM_RESET_GDMA = 1011,
	ZYNQMP_PM_RESET_GPU_PP1 = 1012,
	ZYNQMP_PM_RESET_GPU_PP0 = 1013,
	ZYNQMP_PM_RESET_GPU = 1014,
	ZYNQMP_PM_RESET_GT = 1015,
	ZYNQMP_PM_RESET_SATA = 1016,
	ZYNQMP_PM_RESET_ACPU3_PWRON = 1017,
	ZYNQMP_PM_RESET_ACPU2_PWRON = 1018,
	ZYNQMP_PM_RESET_ACPU1_PWRON = 1019,
	ZYNQMP_PM_RESET_ACPU0_PWRON = 1020,
	ZYNQMP_PM_RESET_APU_L2 = 1021,
	ZYNQMP_PM_RESET_ACPU3 = 1022,
	ZYNQMP_PM_RESET_ACPU2 = 1023,
	ZYNQMP_PM_RESET_ACPU1 = 1024,
	ZYNQMP_PM_RESET_ACPU0 = 1025,
	ZYNQMP_PM_RESET_DDR = 1026,
	ZYNQMP_PM_RESET_APM_FPD = 1027,
	ZYNQMP_PM_RESET_SOFT = 1028,
	ZYNQMP_PM_RESET_GEM0 = 1029,
	ZYNQMP_PM_RESET_GEM1 = 1030,
	ZYNQMP_PM_RESET_GEM2 = 1031,
	ZYNQMP_PM_RESET_GEM3 = 1032,
	ZYNQMP_PM_RESET_QSPI = 1033,
	ZYNQMP_PM_RESET_UART0 = 1034,
	ZYNQMP_PM_RESET_UART1 = 1035,
	ZYNQMP_PM_RESET_SPI0 = 1036,
	ZYNQMP_PM_RESET_SPI1 = 1037,
	ZYNQMP_PM_RESET_SDIO0 = 1038,
	ZYNQMP_PM_RESET_SDIO1 = 1039,
	ZYNQMP_PM_RESET_CAN0 = 1040,
	ZYNQMP_PM_RESET_CAN1 = 1041,
	ZYNQMP_PM_RESET_I2C0 = 1042,
	ZYNQMP_PM_RESET_I2C1 = 1043,
	ZYNQMP_PM_RESET_TTC0 = 1044,
	ZYNQMP_PM_RESET_TTC1 = 1045,
	ZYNQMP_PM_RESET_TTC2 = 1046,
	ZYNQMP_PM_RESET_TTC3 = 1047,
	ZYNQMP_PM_RESET_SWDT_CRL = 1048,
	ZYNQMP_PM_RESET_NAND = 1049,
	ZYNQMP_PM_RESET_ADMA = 1050,
	ZYNQMP_PM_RESET_GPIO = 1051,
	ZYNQMP_PM_RESET_IOU_CC = 1052,
	ZYNQMP_PM_RESET_TIMESTAMP = 1053,
	ZYNQMP_PM_RESET_RPU_R50 = 1054,
	ZYNQMP_PM_RESET_RPU_R51 = 1055,
	ZYNQMP_PM_RESET_RPU_AMBA = 1056,
	ZYNQMP_PM_RESET_OCM = 1057,
	ZYNQMP_PM_RESET_RPU_PGE = 1058,
	ZYNQMP_PM_RESET_USB0_CORERESET = 1059,
	ZYNQMP_PM_RESET_USB1_CORERESET = 1060,
	ZYNQMP_PM_RESET_USB0_HIBERRESET = 1061,
	ZYNQMP_PM_RESET_USB1_HIBERRESET = 1062,
	ZYNQMP_PM_RESET_USB0_APB = 1063,
	ZYNQMP_PM_RESET_USB1_APB = 1064,
	ZYNQMP_PM_RESET_IPI = 1065,
	ZYNQMP_PM_RESET_APM_LPD = 1066,
	ZYNQMP_PM_RESET_RTC = 1067,
	ZYNQMP_PM_RESET_SYSMON = 1068,
	ZYNQMP_PM_RESET_AFI_FM6 = 1069,
	ZYNQMP_PM_RESET_LPD_SWDT = 1070,
	ZYNQMP_PM_RESET_FPD = 1071,
	ZYNQMP_PM_RESET_RPU_DBG1 = 1072,
	ZYNQMP_PM_RESET_RPU_DBG0 = 1073,
	ZYNQMP_PM_RESET_DBG_LPD = 1074,
	ZYNQMP_PM_RESET_DBG_FPD = 1075,
	ZYNQMP_PM_RESET_APLL = 1076,
	ZYNQMP_PM_RESET_DPLL = 1077,
	ZYNQMP_PM_RESET_VPLL = 1078,
	ZYNQMP_PM_RESET_IOPLL = 1079,
	ZYNQMP_PM_RESET_RPLL = 1080,
	ZYNQMP_PM_RESET_GPO3_PL_0 = 1081,
	ZYNQMP_PM_RESET_GPO3_PL_1 = 1082,
	ZYNQMP_PM_RESET_GPO3_PL_2 = 1083,
	ZYNQMP_PM_RESET_GPO3_PL_3 = 1084,
	ZYNQMP_PM_RESET_GPO3_PL_4 = 1085,
	ZYNQMP_PM_RESET_GPO3_PL_5 = 1086,
	ZYNQMP_PM_RESET_GPO3_PL_6 = 1087,
	ZYNQMP_PM_RESET_GPO3_PL_7 = 1088,
	ZYNQMP_PM_RESET_GPO3_PL_8 = 1089,
	ZYNQMP_PM_RESET_GPO3_PL_9 = 1090,
	ZYNQMP_PM_RESET_GPO3_PL_10 = 1091,
	ZYNQMP_PM_RESET_GPO3_PL_11 = 1092,
	ZYNQMP_PM_RESET_GPO3_PL_12 = 1093,
	ZYNQMP_PM_RESET_GPO3_PL_13 = 1094,
	ZYNQMP_PM_RESET_GPO3_PL_14 = 1095,
	ZYNQMP_PM_RESET_GPO3_PL_15 = 1096,
	ZYNQMP_PM_RESET_GPO3_PL_16 = 1097,
	ZYNQMP_PM_RESET_GPO3_PL_17 = 1098,
	ZYNQMP_PM_RESET_GPO3_PL_18 = 1099,
	ZYNQMP_PM_RESET_GPO3_PL_19 = 1100,
	ZYNQMP_PM_RESET_GPO3_PL_20 = 1101,
	ZYNQMP_PM_RESET_GPO3_PL_21 = 1102,
	ZYNQMP_PM_RESET_GPO3_PL_22 = 1103,
	ZYNQMP_PM_RESET_GPO3_PL_23 = 1104,
	ZYNQMP_PM_RESET_GPO3_PL_24 = 1105,
	ZYNQMP_PM_RESET_GPO3_PL_25 = 1106,
	ZYNQMP_PM_RESET_GPO3_PL_26 = 1107,
	ZYNQMP_PM_RESET_GPO3_PL_27 = 1108,
	ZYNQMP_PM_RESET_GPO3_PL_28 = 1109,
	ZYNQMP_PM_RESET_GPO3_PL_29 = 1110,
	ZYNQMP_PM_RESET_GPO3_PL_30 = 1111,
	ZYNQMP_PM_RESET_GPO3_PL_31 = 1112,
	ZYNQMP_PM_RESET_RPU_LS = 1113,
	ZYNQMP_PM_RESET_PS_ONLY = 1114,
	ZYNQMP_PM_RESET_PL = 1115,
	ZYNQMP_PM_RESET_PS_PL0 = 1116,
	ZYNQMP_PM_RESET_PS_PL1 = 1117,
	ZYNQMP_PM_RESET_PS_PL2 = 1118,
	ZYNQMP_PM_RESET_PS_PL3 = 1119,
	ZYNQMP_PM_RESET_END = 1119,
};

enum zynqmp_pm_reset_action {
	PM_RESET_ACTION_RELEASE = 0,
	PM_RESET_ACTION_ASSERT = 1,
	PM_RESET_ACTION_PULSE = 2,
};

enum zynqmp_pm_shutdown_subtype {
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SUBSYSTEM = 0,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_PS_ONLY = 1,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SYSTEM = 2,
};

enum zynqmp_pm_shutdown_type {
	ZYNQMP_PM_SHUTDOWN_TYPE_SHUTDOWN = 0,
	ZYNQMP_PM_SHUTDOWN_TYPE_RESET = 1,
	ZYNQMP_PM_SHUTDOWN_TYPE_SETSCOPE_ONLY = 2,
};

enum zynqmp_pm_suspend_reason {
	SUSPEND_POWER_REQUEST = 201,
	SUSPEND_ALERT = 202,
	SUSPEND_SYSTEM_SHUTDOWN = 203,
};

typedef _Bool bool;

typedef unsigned char __Poly8_t;

typedef __Poly8_t poly8x16_t[16];

typedef __int128 s_max;

typedef __int128 unsigned __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef freelist_full_t pcp_op_T__;

typedef __int128 unsigned u_max;

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 codel_tdiff_t;

typedef s32 compat_clock_t;

typedef s32 compat_daddr_t;

typedef s32 compat_int_t;

typedef s32 compat_key_t;

typedef s32 compat_long_t;

typedef s32 compat_off_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef int initcall_entry_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mhp_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef __s32 sctp_assoc_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef const int tracepoint_ptr_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef volatile long int prel64_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long int __s64;

typedef __s64 Elf64_Sxword;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __s64 s64;

typedef s64 compat_loff_t;

typedef s64 compat_s64;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef U64 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_integer;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 arm_lpae_iopte;

typedef u64 async_cookie_t;

typedef __u64 binder_size_t;

typedef __u64 binder_uintptr_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 sector_t;

typedef sector_t chunk_t;

typedef u64 compat_u64;

typedef u64 dart_iopte;

typedef u64 dma_addr_t;

typedef u64 efi_physical_addr_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 hfn_t;

typedef u64 hpa_t;

typedef u64 io_req_flags_t;

typedef hfn_t kvm_pfn_t;

typedef u64 kvm_pte_t;

typedef kvm_pte_t *kvm_pteref_t;

typedef u64 netdev_features_t;

typedef u64 p4dval_t;

typedef u64 pci_bus_addr_t;

typedef u64 pgdval_t;

typedef u64 phys_addr_t;

typedef u64 phys_cpuid_t;

typedef u64 pmdval_t;

typedef u64 pteval_t;

typedef u64 pudval_t;

typedef sector_t region_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 unative_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t HUF_CElt;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int cycles_t;

typedef long unsigned int dax_entry_t;

typedef long unsigned int efi_status_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[34];

typedef long unsigned int hva_t;

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int perf_trace_t[1024];

typedef long unsigned int pte_marker;

typedef long unsigned int uLong;

typedef long unsigned int uint64x2_t[2];

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef u16 __compat_gid16_t;

typedef u16 __compat_gid_t;

typedef u16 __compat_uid16_t;

typedef u16 __compat_uid_t;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_old_gid_t;

typedef short unsigned int __kernel_old_uid_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 access_mask_t;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef __u16 bitmap_counter_t;

typedef u16 blk_short_t;

typedef __u16 comp_t;

typedef u16 compat_ipc_pid_t;

typedef u16 compat_mode_t;

typedef u16 compat_ushort_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef u16 layer_mask_t;

typedef short unsigned int mifi_t;

typedef __kernel_old_gid_t old_gid_t;

typedef __kernel_old_uid_t old_uid_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef signed char int8x16_t[16];

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef __u8 dvd_challenge[10];

typedef __u8 dvd_key[5];

typedef u8 efi_bool_t;

typedef __u8 mctp_eid_t;

typedef u8 rmap_age_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef unsigned char uint8_t___2;

typedef unsigned char uint8x16_t[16];

typedef uint8x16_t unative_t___2;

typedef const unsigned char utf8leaf_t;

typedef const unsigned char utf8trie_t;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int UHWtype;

typedef __u32 __be32;

typedef u32 __compat_gid32_t;

typedef u32 __compat_uid32_t;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 codel_time_t;

typedef u32 compat_aio_context_t;

typedef u32 compat_caddr_t;

typedef u32 compat_dev_t;

typedef unsigned int compat_elf_greg_t;

typedef compat_elf_greg_t compat_elf_gregset_t[18];

typedef u32 compat_ino_t;

typedef u32 compat_old_sigset_t;

typedef u32 compat_sigset_word;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef unsigned int drm_magic_t;

typedef u32 efi_cc_event_algorithm_bitmap_t;

typedef u32 efi_cc_event_log_bitmap_t;

typedef u32 efi_cc_event_log_format_t;

typedef u32 efi_cc_mr_index_t;

typedef u32 efi_tcg2_event_log_format;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef __u32 if_mask;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef u32 kprobe_opcode_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[106];

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef unsigned int pkvm_handle_t;

typedef u32 probe_opcode_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef u32 ssci_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef __le32 uprobe_opcode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
	FSE_DTable dtable[0];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16 base;
	U16 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

struct seqDef_s;

typedef struct seqDef_s seqDef;

typedef struct {
	seqDef *sequencesStart;
	seqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} seqStore_t;

typedef struct {
	symbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	symbolEncodingType_e llType;
	symbolEncodingType_e ofType;
	symbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	seqStore_t fullSeqStoreChunk;
	seqStore_t firstHalfSeqStore;
	seqStore_t secondHalfSeqStore;
	seqStore_t currSeqStore;
	seqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_paramSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} rawSeqStore_t;

struct ZSTD_matchState_t;

typedef struct ZSTD_matchState_t ZSTD_matchState_t;

struct ZSTD_matchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	U16 *tagTable;
	U32 hashCache[8];
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	U32 forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_matchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const rawSeqStore_t *ldmSeqStore;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_matchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ZSTD_frameHeader;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	long long unsigned int ingested;
	long long unsigned int consumed;
	long long unsigned int produced;
	long long unsigned int flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	rawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_sequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_sequencePosition;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	long unsigned int fds_bits[16];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct {
	int counter;
} atomic_t;

typedef struct {
	char ax25_call[7];
} ax25_address;

typedef struct {
	__be64 a;
	__be64 b;
} be128;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
};

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed));

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
};

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
};

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
};

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
};

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} cap_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	int *lock;
	long unsigned int flags;
} class_core_lock_t;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

typedef struct {
	void *lock;
} class_irq_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_preempt_notrace_t;

typedef struct {
	void *lock;
} class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		};
		struct {
			u16 locked_pending;
			u16 tail;
		};
	};
};

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		};
	};
	arch_spinlock_t wait_lock;
};

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
} class_read_lock_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_write_lock_irqsave_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef __kernel_fsid_t compat_fsid_t;

typedef struct {
	compat_sigset_word sig[2];
} compat_sigset_t;

typedef struct {
	__be16 disc_information_length;
	__u8 disc_status: 2;
	__u8 border_status: 2;
	__u8 erasable: 1;
	__u8 reserved1: 3;
	__u8 n_first_track;
	__u8 n_sessions_lsb;
	__u8 first_track_lsb;
	__u8 last_track_lsb;
	__u8 mrw_status: 2;
	__u8 dbit: 1;
	__u8 reserved2: 2;
	__u8 uru: 1;
	__u8 dbc_v: 1;
	__u8 did_v: 1;
	__u8 disc_type;
	__u8 n_sessions_msb;
	__u8 first_track_msb;
	__u8 last_track_msb;
	__u32 disc_id;
	__u32 lead_in;
	__u32 lead_out;
	__u8 disc_bar_code[8];
	__u8 reserved3;
	__u8 n_opc;
} disc_information;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

struct dvd_lu_send_agid {
	__u8 type;
	unsigned int agid: 2;
};

struct dvd_host_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_send_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key key;
};

struct dvd_lu_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_lu_send_title_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key title_key;
	int lba;
	unsigned int cpm: 1;
	unsigned int cp_sec: 1;
	unsigned int cgms: 2;
};

struct dvd_lu_send_asf {
	__u8 type;
	unsigned int agid: 2;
	unsigned int asf: 1;
};

struct dvd_host_send_rpcstate {
	__u8 type;
	__u8 pdrc;
};

struct dvd_lu_send_rpcstate {
	__u8 type: 2;
	__u8 vra: 3;
	__u8 ucca: 3;
	__u8 region_mask;
	__u8 rpc_scheme;
};

typedef union {
	__u8 type;
	struct dvd_lu_send_agid lsa;
	struct dvd_host_send_challenge hsc;
	struct dvd_send_key lsk;
	struct dvd_lu_send_challenge lsc;
	struct dvd_send_key hsk;
	struct dvd_lu_send_title_key lstk;
	struct dvd_lu_send_asf lsasf;
	struct dvd_host_send_rpcstate hrpcs;
	struct dvd_lu_send_rpcstate lrpcs;
} dvd_authinfo;

struct dvd_layer {
	__u8 book_version: 4;
	__u8 book_type: 4;
	__u8 min_rate: 4;
	__u8 disc_size: 4;
	__u8 layer_type: 4;
	__u8 track_path: 1;
	__u8 nlayers: 2;
	char: 1;
	__u8 track_density: 4;
	__u8 linear_density: 4;
	__u8 bca: 1;
	__u32 start_sector;
	__u32 end_sector;
	__u32 end_sector_l0;
};

struct dvd_physical {
	__u8 type;
	__u8 layer_num;
	struct dvd_layer layer[4];
};

struct dvd_copyright {
	__u8 type;
	__u8 layer_num;
	__u8 cpst;
	__u8 rmi;
};

struct dvd_disckey {
	__u8 type;
	unsigned int agid: 2;
	__u8 value[2048];
};

struct dvd_bca {
	__u8 type;
	int len;
	__u8 value[188];
};

struct dvd_manufact {
	__u8 type;
	__u8 layer_num;
	int len;
	__u8 value[2048];
};

typedef union {
	__u8 type;
	struct dvd_physical physical;
	struct dvd_copyright copyright;
	struct dvd_disckey disckey;
	struct dvd_bca bca;
	struct dvd_manufact manufact;
} dvd_struct;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	u8 major;
	u8 minor;
} efi_cc_version_t;

typedef struct {
	u8 type;
	u8 sub_type;
} efi_cc_type_t;

typedef struct {
	u8 size;
	efi_cc_version_t structure_version;
	efi_cc_version_t protocol_version;
	efi_cc_event_algorithm_bitmap_t hash_algorithm_bitmap;
	efi_cc_event_log_bitmap_t supported_event_logs;
	efi_cc_type_t cc_type;
} efi_cc_boot_service_cap_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	long unsigned int *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u64 size;
	u64 file_size;
	u64 phys_size;
	efi_time_t create_time;
	efi_time_t last_access_time;
	efi_time_t modification_time;
	__u64 attribute;
	efi_char16_t filename[0];
} efi_file_info_t;

typedef struct {
	u32 red_mask;
	u32 green_mask;
	u32 blue_mask;
	u32 reserved_mask;
} efi_pixel_bitmask_t;

typedef struct {
	u32 version;
	u32 horizontal_resolution;
	u32 vertical_resolution;
	int pixel_format;
	efi_pixel_bitmask_t pixel_information;
	u32 pixels_per_scan_line;
} efi_graphics_output_mode_info_t;

typedef struct {
	u16 scan_code;
	efi_char16_t unicode_char;
} efi_input_key_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	u8 variable_data[0];
} __attribute__((packed)) efi_load_option_t;

struct efi_generic_dev_path;

typedef struct efi_generic_dev_path efi_device_path_protocol_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	const efi_char16_t *description;
	const efi_device_path_protocol_t *file_path_list;
	u32 optional_data_size;
	const void *optional_data;
} efi_load_option_unpacked_t;

typedef void *efi_handle_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef efi_status_t efi_set_virtual_address_map_t(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);

typedef efi_status_t efi_get_next_variable_t(long unsigned int *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, long unsigned int, efi_char16_t *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, long unsigned int, long unsigned int);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, long unsigned int, u64 *, int *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_get_time_t *get_time;
		efi_set_time_t *set_time;
		efi_get_wakeup_time_t *get_wakeup_time;
		efi_set_wakeup_time_t *set_wakeup_time;
		efi_set_virtual_address_map_t *set_virtual_address_map;
		void *convert_pointer;
		efi_get_variable_t *get_variable;
		efi_get_next_variable_t *get_next_variable;
		efi_set_variable_t *set_variable;
		efi_get_next_high_mono_count_t *get_next_high_mono_count;
		efi_reset_system_t *reset_system;
		efi_update_capsule_t *update_capsule;
		efi_query_capsule_caps_t *query_capsule_caps;
		efi_query_variable_info_t *query_variable_info;
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		long unsigned int fw_vendor;
		u32 fw_revision;
		long unsigned int con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		long unsigned int con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		long unsigned int stderr_handle;
		long unsigned int stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		long unsigned int nr_tables;
		long unsigned int tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef union {
	struct {
		u32 revision;
		efi_handle_t parent_handle;
		efi_system_table_t *system_table;
		efi_handle_t device_handle;
		void *file_path;
		void *reserved;
		u32 load_options_size;
		void *load_options;
		void *image_base;
		__u64 image_size;
		unsigned int image_code_type;
		unsigned int image_data_type;
		efi_status_t (*unload)(efi_handle_t);
	};
	struct {
		u32 revision;
		u32 parent_handle;
		u32 system_table;
		u32 device_handle;
		u32 file_path;
		u32 reserved;
		u32 load_options_size;
		u32 load_options;
		u32 image_base;
		__u64 image_size;
		u32 image_code_type;
		u32 image_data_type;
		u32 unload;
	} mixed_mode;
} efi_loaded_image_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u32 read;
	u32 write;
} efi_pci_io_protocol_access_32_t;

typedef struct {
	void *read;
	void *write;
} efi_pci_io_protocol_access_t;

union efi_pci_io_protocol;

typedef union efi_pci_io_protocol efi_pci_io_protocol_t;

typedef efi_status_t (*efi_pci_io_protocol_cfg_t)(efi_pci_io_protocol_t *, EFI_PCI_IO_PROTOCOL_WIDTH, u32, long unsigned int, void *);

typedef struct {
	efi_pci_io_protocol_cfg_t read;
	efi_pci_io_protocol_cfg_t write;
} efi_pci_io_protocol_config_access_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	efi_guid_t signature_owner;
	u8 signature_data[0];
} efi_signature_data_t;

typedef struct {
	efi_guid_t signature_type;
	u32 signature_list_size;
	u32 signature_header_size;
	u32 signature_size;
	u8 signature_header[0];
} efi_signature_list_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int __softirq_pending;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_paramSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64 rolling;
	U64 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {} lockdep_map_p;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

typedef struct {
	atomic64_t id;
	void *sigpage;
	refcount_t pinned;
	void *vdso;
	long unsigned int flags;
	u8 pkey_allocation_map;
} mm_context_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	__u8 b[16];
} uuid_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct net;

struct auth_domain;

typedef struct {
	uuid_t uuid;
	struct list_head list;
	struct net *net;
	struct auth_domain *dom;
} nfs_uuid_t;

typedef struct {
	long unsigned int bits[8];
} nodemask_t;

typedef struct {
	pgdval_t pgd;
} pgd_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u64 val;
} pfn_t;

typedef struct {
	pteval_t pgprot;
} pgprot_t;

typedef struct {
	pmdval_t pmd;
} pmd_t;

typedef struct {
	long unsigned int bits[4];
} pnp_irq_mask_t;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	pteval_t pte;
} pte_t;

typedef struct {
	pudval_t pud;
} pud_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef union {
} release_pages_arg;

typedef struct {
	__u16 report_key_length;
	__u8 reserved1;
	__u8 reserved2;
	__u8 ucca: 3;
	__u8 vra: 3;
	__u8 type_code: 2;
	__u8 region_mask;
	__u8 rpc_scheme;
	__u8 reserved3;
} rpc_state_t;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[1];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	__be16 track_information_length;
	__u8 track_lsb;
	__u8 session_lsb;
	__u8 reserved1;
	__u8 track_mode: 4;
	__u8 copy: 1;
	__u8 damage: 1;
	__u8 reserved2: 2;
	__u8 data_mode: 4;
	__u8 fp: 1;
	__u8 packet: 1;
	__u8 blank: 1;
	__u8 rt: 1;
	__u8 nwa_v: 1;
	__u8 lra_v: 1;
	__u8 reserved3: 6;
	__be32 track_start;
	__be32 next_writable;
	__be32 free_blocks;
	__be32 fixed_packet_size;
	__be32 track_size;
	__be32 last_rec_address;
} track_information;

typedef struct {
	int data;
	int audio;
	int cdi;
	int xa;
	long int error;
} tracktype;

typedef struct {
	local64_t v;
} u64_stats_t;

typedef struct {
	u64 m_low;
	u64 m_high;
} uint128_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_frameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct device;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool async_in_progress: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dev_archdata {};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_coherent: 1;
	bool dma_skip_sync: 1;
	bool dma_iommu: 1;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	unsigned int no_highmem: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
};

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_paramSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_sequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_paramSwitch_e useBlockSplitter;
	ZSTD_paramSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSize;
	long long unsigned int pledgedSrcSizePlusOne;
	long long unsigned int consumedSrcSize;
	long long unsigned int producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	seqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	rawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	U32 *entropyWorkspace;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	ZSTD_matchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_paramSwitch_e useRowMatchFinder;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_frameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	};
	u16 src;
	u16 dst;
};

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
};

typedef struct __call_single_data call_single_data_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
};

struct __compat_aio_sigset {
	compat_uptr_t sigmask;
	compat_size_t sigsetsize;
};

struct __compat_iw_event {
	__u16 len;
	__u16 cmd;
	union {
		compat_caddr_t pointer;
		struct {
			struct {} __empty_ptr_bytes;
			__u8 ptr_bytes[0];
		};
	};
};

struct drm_connector;

struct drm_connector_state;

struct __drm_connnectors_state {
	struct drm_connector *ptr;
	struct drm_connector_state *state;
	struct drm_connector_state *old_state;
	struct drm_connector_state *new_state;
	s32 *out_fence_ptr;
};

struct drm_crtc;

struct drm_crtc_state;

struct drm_crtc_commit;

struct __drm_crtcs_state {
	struct drm_crtc *ptr;
	struct drm_crtc_state *state;
	struct drm_crtc_state *old_state;
	struct drm_crtc_state *new_state;
	struct drm_crtc_commit *commit;
	s32 *out_fence_ptr;
	u64 last_vblank_count;
};

struct drm_plane;

struct drm_plane_state;

struct __drm_planes_state {
	struct drm_plane *ptr;
	struct drm_plane_state *state;
	struct drm_plane_state *old_state;
	struct drm_plane_state *new_state;
};

struct drm_private_obj;

struct drm_private_state;

struct __drm_private_objs_state {
	struct drm_private_obj *ptr;
	struct drm_private_state *state;
	struct drm_private_state *old_state;
	struct drm_private_state *new_state;
};

struct __extcon_info {
	unsigned int type;
	unsigned int id;
	const char *name;
};

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
};

union __fpsimd_vreg {
	__int128 unsigned raw;
	struct {
		u64 lo;
		u64 hi;
	};
};

struct arm64_ftr_reg;

struct __ftr_reg_entry {
	u32 sys_id;
	struct arm64_ftr_reg *reg;
};

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
};

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
};

struct __ip6_tnl_parm {
	char name[16];
	int link;
	__u8 proto;
	__u8 encap_limit;
	__u8 hop_limit;
	bool collect_md;
	__be32 flowinfo;
	__u32 flags;
	struct in6_addr laddr;
	struct in6_addr raddr;
	long unsigned int i_flags[1];
	long unsigned int o_flags[1];
	__be32 i_key;
	__be32 o_key;
	__u32 fwmark;
	__u32 index;
	__u8 erspan_ver;
	__u8 dir;
	__u16 hwid;
};

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
};

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
};

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
};

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
};

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long int tv_nsec;
};

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
};

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		};
		void *__align;
	};
};

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
};

struct __kernel_timex {
	unsigned int modes;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
};

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
};

struct __pldm_timestamp {
	u8 b[13];
};

struct __pldm_header {
	uuid_t id;
	u8 revision;
	__le16 size;
	struct __pldm_timestamp release_date;
	__le16 component_bitmap_len;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed));

struct __pldmfw_component_area {
	__le16 component_image_count;
	u8 components[0];
};

struct __pldmfw_component_info {
	__le16 classification;
	__le16 identifier;
	__le32 comparison_stamp;
	__le16 options;
	__le16 activation_method;
	__le32 location_offset;
	__le32 size;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed));

struct __pldmfw_desc_tlv {
	__le16 type;
	__le16 size;
	u8 data[0];
};

struct __pldmfw_record_area {
	u8 record_count;
	u8 records[0];
};

struct __pldmfw_record_info {
	__le16 record_len;
	u8 descriptor_count;
	__le32 device_update_flags;
	u8 version_type;
	u8 version_len;
	__le16 package_data_len;
	u8 variable_record_data[0];
} __attribute__((packed));

struct qm_cgr_wr_parm {
	__be32 word;
};

struct qm_cgr_cs_thres {
	__be16 word;
};

struct __qm_mc_cgr {
	struct qm_cgr_wr_parm wr_parm_g;
	struct qm_cgr_wr_parm wr_parm_y;
	struct qm_cgr_wr_parm wr_parm_r;
	u8 wr_en_g;
	u8 wr_en_y;
	u8 wr_en_r;
	u8 cscn_en;
	union {
		struct {
			__be16 cscn_targ_upd_ctrl;
			__be16 cscn_targ_dcp_low;
		};
		__be32 cscn_targ;
	};
	u8 cstd_en;
	u8 cs;
	struct qm_cgr_cs_thres cs_thres;
	u8 mode;
} __attribute__((packed));

struct __qm_mcr_querycongestion {
	u32 state[8];
};

struct net_device;

struct __rt6_probe_work {
	struct work_struct work;
	struct in6_addr target;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
};

union sigval {
	int sival_int;
	void *sival_ptr;
};

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} _perf;
		};
	} _sigfault;
	struct {
		long int _band;
		int _fd;
	} _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} _sigsys;
};

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	};
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	};
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
};

struct dentry;

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
};

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
};

union __u128_halves {
	u128 full;
	struct {
		u64 low;
		u64 high;
	};
};

struct __una_u32 {
	u32 x;
};

struct inode;

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
};

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
};

typedef struct __user_cap_data_struct *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
};

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __va_list {
	void *__stack;
	void *__gr_top;
	void *__vr_top;
	int __gr_offs;
	int __vr_offs;
};

typedef struct __va_list va_list;

struct _aarch64_ctx {
	__u32 magic;
	__u32 size;
};

struct _bpf_dtab_netdev {
	struct net_device *dev;
};

struct _ccu_mult {
	long unsigned int mult;
	long unsigned int min;
	long unsigned int max;
};

struct _ccu_nk {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
};

struct _ccu_nkm {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
};

struct _ccu_nkmp {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
	long unsigned int p;
	long unsigned int min_p;
	long unsigned int max_p;
};

struct _ccu_nm {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
};

struct jump_entry;

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	};
};

struct static_key_true {
	struct static_key key;
};

struct static_key_false {
	struct static_key key;
};

struct _ddebug {
	const char *modname;
	const char *function;
	const char *filename;
	const char *format;
	unsigned int lineno: 18;
	unsigned int class_id: 6;
	unsigned int flags: 8;
	union {
		struct static_key_true dd_key_true;
		struct static_key_false dd_key_false;
	} key;
};

struct ddebug_class_map;

struct _ddebug_info {
	struct _ddebug *descs;
	struct ddebug_class_map *classes;
	unsigned int num_descs;
	unsigned int num_classes;
};

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
};

struct _gpiochip_for_each_data {
	const char **label;
	unsigned int *i;
};

typedef struct _gpiochip_for_each_data class__gpiochip_for_each_data_t;

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
};

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
};

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed));

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
};

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_io_device_ops;

struct kvm_io_device {
	const struct kvm_io_device_ops *ops;
};

struct eventfd_ctx;

struct _ioeventfd {
	struct list_head list;
	u64 addr;
	int length;
	struct eventfd_ctx *eventfd;
	u64 datamatch;
	struct kvm_io_device dev;
	u8 bus_idx;
	bool wildcard;
};

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
};

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
};

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed));

typedef struct _legacy_mbr legacy_mbr;

struct strp_msg {
	int full_len;
	int offset;
};

struct _strp_msg {
	struct strp_msg strp;
	int accum_len;
};

struct a64fx_diag_priv {
	void *mmsc_reg_base;
	int irq;
	bool has_nmi;
};

struct aarch64_insn_patch {
	void **text_addrs;
	u32 *new_insns;
	int insn_cnt;
	atomic_t cpu_count;
};

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
};

struct ac6_iter_state {
	struct seq_net_private p;
	struct net_device *dev;
};

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
};

struct access_masks {
	access_mask_t fs: 16;
	access_mask_t net: 2;
	access_mask_t scope: 2;
};

union access_masks_all {
	struct access_masks masks;
	u32 all;
};

struct access_report_info {
	struct callback_head work;
	const char *access;
	struct task_struct *target;
	struct task_struct *agent;
};

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
};

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
};

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
};

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
};

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
};

struct comp_alg_common {
	struct crypto_alg base;
};

struct acomp_req;

struct scatterlist;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	void (*dst_free)(struct scatterlist *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	unsigned int reqsize;
	union {
		struct {
			struct crypto_alg base;
		};
		struct comp_alg_common calg;
	};
};

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
};

struct acomp_req {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int slen;
	unsigned int dlen;
	u32 flags;
	void *__ctx[0];
};

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	void (*set_charged)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
};

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
};

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	long long unsigned int state;
	struct notifier_block battery_nb;
};

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
};

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
};

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
};

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
};

struct acpi_apmt_node {
	u16 length;
	u8 flags;
	u8 type;
	u32 id;
	u64 inst_primary;
	u32 inst_secondary;
	u64 base_address0;
	u64 base_address1;
	u32 ovflw_irq;
	u32 reserved;
	u32 ovflw_irq_flags;
	u32 proc_affinity;
	u32 impl_id;
} __attribute__((packed));

struct acpi_battery {
	struct mutex lock;
	struct mutex sysfs_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	long unsigned int update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	long unsigned int flags;
};

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
};

struct acpi_bert_region {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
};

struct acpi_buffer {
	acpi_size length;
	void *pointer;
};

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
};

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
};

struct input_dev;

struct acpi_button {
	unsigned int type;
	struct input_dev *input;
	char phys[32];
	long unsigned int pushed;
	int last_state;
	ktime_t last_time;
	bool suspended;
	bool lid_state_initialized;
};

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
};

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed));

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
};

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
};

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
};

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
};

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
};

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
};

struct acpi_csrt_group {
	u32 length;
	u32 vendor_id;
	u32 subvendor_id;
	u16 device_id;
	u16 subdevice_id;
	u16 revision;
	u16 reserved;
	u32 shared_info_length;
};

struct acpi_csrt_shared_info {
	u16 major_version;
	u16 minor_version;
	u32 mmio_base_low;
	u32 mmio_base_high;
	u32 gsi_interrupt;
	u8 interrupt_polarity;
	u8 interrupt_mode;
	u8 num_channels;
	u8 dma_address_width;
	u16 base_request_line;
	u16 num_handshake_signals;
	u32 max_block_size;
};

struct attribute {
	const char *name;
	umode_t mode;
};

struct address_space;

struct file;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, struct bin_attribute *, struct vm_area_struct *);
};

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
};

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
};

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
};

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
};

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
};

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
};

struct acpi_data_table_mapping {
	void *pointer;
};

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
};

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
};

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
};

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
};

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
};

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
};

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
};

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
};

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
};

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
};

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
};

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
};

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
};

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
};

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
};

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
};

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
};

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
};

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
};

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
};

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
};

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
};

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
};

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
};

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
};

union acpi_name_union {
	u32 integer;
	char ascii[4];
};

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
};

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
};

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
};

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
};

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	char *path;
	u8 *data;
	u32 length;
	u32 name;
};

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
};

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
};

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
};

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
};

struct acpi_dev_match_info {
	struct acpi_device_id hid[2];
	const char *uid;
	s64 hrv;
};

struct acpi_dev_walk_context {
	int (*fn)(struct acpi_device *, void *);
	void *data;
};

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
};

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
};

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
};

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
};

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
};

struct acpi_device_power_state {
	struct list_head resources;
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} flags;
	int power;
	int latency;
};

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
};

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
};

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
};

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
};

struct acpi_device_perf_flags {
	u8 reserved: 8;
};

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
};

struct proc_dir_entry;

struct acpi_device_dir {
	struct proc_dir_entry *entry;
};

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_device_software_nodes;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	struct acpi_device_software_nodes *swnodes;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
};

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
};

struct ida {
	struct xarray xa;
};

struct acpi_device_bus_id {
	const char *bus_id;
	struct ida instance_ida;
	struct list_head node;
};

struct acpi_pnp_device_id {
	u32 length;
	char *string;
};

struct acpi_pnp_device_id_list {
	u32 count;
	u32 list_size;
	struct acpi_pnp_device_id ids[0];
};

struct acpi_device_info {
	u32 info_size;
	u32 name;
	acpi_object_type type;
	u8 param_count;
	u16 valid;
	u8 flags;
	u8 highest_dstates[4];
	u8 lowest_dstates[5];
	u64 address;
	struct acpi_pnp_device_id hardware_id;
	struct acpi_pnp_device_id unique_id;
	struct acpi_pnp_device_id class_code;
	struct acpi_pnp_device_id_list compatible_id_list;
};

typedef int (*acpi_op_add)(struct acpi_device *);

typedef void (*acpi_op_remove)(struct acpi_device *);

typedef void (*acpi_op_notify)(struct acpi_device *, u32);

struct acpi_device_ops {
	acpi_op_add add;
	acpi_op_remove remove;
	acpi_op_notify notify;
};

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} flags;
	u8 power;
	u8 performance;
	int latency;
};

struct acpi_device_physical_node {
	struct list_head node;
	struct device *dev;
	unsigned int node_id;
	bool put_online: 1;
};

struct acpi_device_properties {
	struct list_head list;
	const guid_t *guid;
	union acpi_object *properties;
	void **bufs;
};

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} value;
	};
};

struct software_node;

struct software_node_ref_args {
	const struct software_node *node;
	unsigned int nargs;
	u64 args[8];
};

struct acpi_device_software_node_port {
	char port_name[9];
	u32 data_lanes[8];
	u32 lane_polarities[9];
	u64 link_frequencies[8];
	unsigned int port_nr;
	bool crs_csi2_local;
	struct property_entry port_props[2];
	struct property_entry ep_props[8];
	struct software_node_ref_args remote_ep[1];
};

struct acpi_device_software_nodes {
	struct property_entry dev_props[6];
	struct software_node *nodes;
	const struct software_node **nodeptrs;
	struct acpi_device_software_node_port *ports;
	unsigned int num_ports;
};

struct acpi_table_desc;

struct acpi_evaluate_info;

struct acpi_device_walk_info {
	struct acpi_table_desc *table_desc;
	struct acpi_evaluate_info *evaluate_info;
	u32 device_count;
	u32 num_STA;
	u32 num_INI;
};

struct dma_chan;

struct acpi_dma_spec;

struct acpi_dma {
	struct list_head dma_controllers;
	struct device *dev;
	struct dma_chan * (*acpi_dma_xlate)(struct acpi_dma_spec *, struct acpi_dma *);
	void *data;
	short unsigned int base_request_line;
	short unsigned int end_request_line;
};

typedef bool (*dma_filter_fn)(struct dma_chan *, void *);

struct acpi_dma_filter_info {
	dma_cap_mask_t dma_cap;
	dma_filter_fn filter_fn;
};

struct acpi_dma_spec {
	int chan_id;
	int slave_id;
	struct device *dev;
};

struct acpi_dma_parser_data {
	struct acpi_dma_spec dma_spec;
	size_t index;
	size_t n;
};

struct of_device_id;

struct dev_pm_ops;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
};

struct acpi_driver {
	char name[80];
	char class[80];
	const struct acpi_device_id *ids;
	unsigned int flags;
	struct acpi_device_ops ops;
	struct device_driver drv;
};

struct transaction;

struct acpi_ec {
	acpi_handle handle;
	int gpe;
	int irq;
	long unsigned int command_addr;
	long unsigned int data_addr;
	bool global_lock;
	long unsigned int flags;
	long unsigned int reference_count;
	struct mutex mutex;
	wait_queue_head_t wait;
	struct list_head list;
	struct transaction *curr;
	spinlock_t lock;
	struct work_struct work;
	long unsigned int timestamp;
	enum acpi_ec_event_state event_state;
	unsigned int events_to_process;
	unsigned int events_in_progress;
	unsigned int queries_in_progress;
	bool busy_polling;
	unsigned int polling_guard;
};

struct transaction {
	const u8 *wdata;
	u8 *rdata;
	short unsigned int irq_count;
	u8 command;
	u8 wi;
	u8 ri;
	u8 wlen;
	u8 rlen;
	u8 flags;
};

struct acpi_ec_query_handler;

struct acpi_ec_query {
	struct transaction transaction;
	struct work_struct work;
	struct acpi_ec_query_handler *handler;
	struct acpi_ec *ec;
};

typedef int (*acpi_ec_query_func)(void *);

struct acpi_ec_query_handler {
	struct list_head node;
	acpi_ec_query_func func;
	acpi_handle handle;
	void *data;
	u8 query_bit;
	struct kref kref;
};

union acpi_predefined_info;

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
};

struct acpi_exception_info {
	char *name;
};

struct acpi_fadt_info {
	const char *name;
	u16 address64;
	u16 address32;
	u16 length;
	u8 default_length;
	u8 flags;
};

struct acpi_generic_address;

struct acpi_fadt_pm_info {
	struct acpi_generic_address *target;
	u16 source;
	u8 register_num;
};

struct acpi_fan_fif {
	u8 revision;
	u8 fine_grain_ctrl;
	u8 step_size;
	u8 low_speed_notification;
};

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
};

struct acpi_fan_fps;

struct thermal_cooling_device;

struct acpi_fan {
	bool acpi4;
	struct acpi_fan_fif fif;
	struct acpi_fan_fps *fps;
	int fps_count;
	struct thermal_cooling_device *cdev;
	struct device_attribute fst_speed;
	struct device_attribute fine_grain_control;
};

struct acpi_fan_fps {
	u64 control;
	u64 trip_point;
	u64 speed;
	u64 noise_level;
	u64 power;
	char name[20];
	struct device_attribute dev_attr;
};

struct acpi_fan_fst {
	u64 revision;
	u64 control;
	u64 speed;
};

struct acpi_ffh_info {
	u64 offset;
	u64 length;
};

struct arm_smccc_res;

struct arm_smccc_quirk;

struct arm_smccc_1_2_regs;

struct acpi_ffh_data {
	struct acpi_ffh_info info;
	void (*invoke_ffh_fn)(long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, long unsigned int, struct arm_smccc_res *, struct arm_smccc_quirk *);
	void (*invoke_ffh64_fn)(const struct arm_smccc_1_2_regs *, struct arm_smccc_1_2_regs *);
};

struct acpi_ged_device {
	struct device *dev;
	struct list_head event_list;
};

struct acpi_ged_event {
	struct list_head node;
	struct device *dev;
	unsigned int gsi;
	unsigned int irq;
	acpi_handle handle;
};

struct acpi_ged_handler_info {
	struct acpi_ged_handler_info *next;
	u32 int_id;
	struct acpi_namespace_node *evt_method;
};

struct acpi_generic_address {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_width;
	u64 address;
} __attribute__((packed));

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
};

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
};

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
};

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
};

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
};

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
};

struct acpi_global_notify_handler;

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
};

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
};

struct acpi_genl_event {
	acpi_device_class device_class;
	char bus_id[15];
	u32 type;
	u32 data;
};

typedef acpi_status (*acpi_walk_callback)(acpi_handle, u32, void *, void **);

struct acpi_get_devices_info {
	acpi_walk_callback user_function;
	void *context;
	const char *hid;
};

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
};

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
};

struct acpi_gpe_xrupt_info;

struct acpi_gpe_register_info;

struct acpi_gpe_event_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
};

struct acpi_gpe_handler_info;

struct acpi_gpe_notify_info;

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
};

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
};

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
};

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
};

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
};

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
};

struct gpio_chip;

struct acpi_gpio_chip {
	struct acpi_connection_info conn_info;
	struct list_head conns;
	struct mutex conn_lock;
	struct gpio_chip *chip;
	struct list_head events;
	struct list_head deferred_req_irqs_list_entry;
};

struct gpio_desc;

struct acpi_gpio_connection {
	struct list_head node;
	unsigned int pin;
	struct gpio_desc *desc;
};

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct acpi_gpio_event {
	struct list_head node;
	acpi_handle handle;
	irq_handler_t handler;
	unsigned int pin;
	unsigned int irq;
	long unsigned int irqflags;
	bool irq_is_wake;
	bool irq_requested;
	struct gpio_desc *desc;
};

struct acpi_gpio_info {
	struct acpi_device *adev;
	enum gpiod_flags flags;
	bool gpioint;
	int pin_config;
	int polarity;
	int triggering;
	bool wake_capable;
	unsigned int debounce;
	unsigned int quirks;
};

struct acpi_gpio_lookup {
	struct acpi_gpio_info info;
	int index;
	u16 pin_index;
	bool active_low;
	struct gpio_desc *desc;
	int n;
};

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
};

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	unsigned int line_index;
	bool active_low;
};

struct acpi_gpiolib_dmi_quirk {
	bool no_edge_events_on_boot;
	char *ignore_wake;
	char *ignore_interrupt;
};

struct acpi_table_gtdt;

struct acpi_gtdt_descriptor {
	struct acpi_table_gtdt *gtdt;
	void *gtdt_end;
	void *platform_timer;
};

struct acpi_gtdt_header {
	u8 type;
	u16 length;
} __attribute__((packed));

struct acpi_gtdt_timer_block {
	struct acpi_gtdt_header header;
	u8 reserved;
	u64 block_address;
	u32 timer_count;
	u32 timer_offset;
} __attribute__((packed));

struct acpi_gtdt_timer_entry {
	u8 frame_number;
	u8 reserved[3];
	u64 base_address;
	u64 el0_base_address;
	u32 timer_interrupt;
	u32 timer_flags;
	u32 virtual_timer_interrupt;
	u32 virtual_timer_flags;
	u32 common_flags;
} __attribute__((packed));

struct acpi_gtdt_watchdog {
	struct acpi_gtdt_header header;
	u8 reserved;
	u64 refresh_frame_address;
	u64 control_frame_address;
	u32 timer_interrupt;
	u32 timer_flags;
} __attribute__((packed));

struct acpi_handle_list {
	u32 count;
	acpi_handle *handles;
};

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
};

struct acpi_hest_header {
	u16 type;
	u16 source_id;
};

struct acpi_hest_notify {
	u8 type;
	u8 length;
	u16 config_write_enable;
	u32 poll_interval;
	u32 vector;
	u32 polling_threshold_value;
	u32 polling_threshold_window;
	u32 error_threshold_value;
	u32 error_threshold_window;
};

struct acpi_hest_generic {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
};

struct acpi_hest_generic_data {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
};

struct acpi_hest_generic_data_v300 {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
	u64 time_stamp;
};

struct acpi_hest_generic_status {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
};

struct acpi_hest_generic_v2 {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
	struct acpi_generic_address read_ack_register;
	u64 read_ack_preserve;
	u64 read_ack_write;
} __attribute__((packed));

struct acpi_hest_ia_corrected {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
};

struct acpi_hest_ia_deferred_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
};

struct acpi_hest_ia_machine_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u64 global_capability_data;
	u64 global_control_data;
	u8 num_hardware_banks;
	u8 reserved3[7];
};

struct acpi_hmat_structure {
	u16 type;
	u16 reserved;
	u32 length;
};

struct acpi_hmat_cache {
	struct acpi_hmat_structure header;
	u32 memory_PD;
	u32 reserved1;
	u64 cache_size;
	u32 cache_attributes;
	u16 address_mode;
	u16 number_of_SMBIOShandles;
};

struct acpi_hmat_locality {
	struct acpi_hmat_structure header;
	u8 flags;
	u8 data_type;
	u8 min_transfer_size;
	u8 reserved1;
	u32 number_of_initiator_Pds;
	u32 number_of_target_Pds;
	u32 reserved2;
	u64 entry_base_unit;
};

struct acpi_hmat_proximity_domain {
	struct acpi_hmat_structure header;
	u16 flags;
	u16 reserved1;
	u32 processor_PD;
	u32 memory_PD;
	u32 reserved2;
	u64 reserved3;
	u64 reserved4;
};

typedef int (*acpi_hp_notify)(struct acpi_device *, u32);

typedef void (*acpi_hp_uevent)(struct acpi_device *, u32);

typedef void (*acpi_hp_fixup)(struct acpi_device *);

struct acpi_hotplug_context {
	struct acpi_device *self;
	acpi_hp_notify notify;
	acpi_hp_uevent uevent;
	acpi_hp_fixup fixup;
};

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
};

struct acpi_hp_work {
	struct work_struct work;
	struct acpi_device *adev;
	u32 src;
};

struct acpi_init_walk_info {
	u32 table_index;
	u32 object_count;
	u32 method_count;
	u32 serial_method_count;
	u32 non_serial_method_count;
	u32 serialized_method_count;
	u32 device_count;
	u32 op_region_count;
	u32 field_count;
	u32 buffer_count;
	u32 package_count;
	u32 op_region_init;
	u32 field_init;
	u32 buffer_init;
	u32 package_init;
	acpi_owner_id owner_id;
};

struct acpi_interface_info {
	char *name;
	struct acpi_interface_info *next;
	u8 flags;
	u8 value;
};

struct acpi_io_attribute {
	u8 range_type;
	u8 translation;
	u8 translation_type;
	u8 reserved1;
};

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
};

struct acpi_ioremap {
	struct list_head list;
	void *virt;
	acpi_physical_address phys;
	acpi_size size;
	union {
		long unsigned int refcount;
		struct rcu_work rwork;
	} track;
};

struct acpi_iort_id_mapping {
	u32 input_base;
	u32 id_count;
	u32 output_base;
	u32 output_reference;
	u32 flags;
};

struct acpi_iort_its_group {
	u32 its_count;
	u32 identifiers[0];
};

struct acpi_iort_named_component {
	u32 node_flags;
	u64 memory_properties;
	u8 memory_address_limit;
	char device_name[0];
} __attribute__((packed));

struct acpi_iort_node {
	u8 type;
	u16 length;
	u8 revision;
	u32 identifier;
	u32 mapping_count;
	u32 mapping_offset;
	char node_data[0];
} __attribute__((packed));

struct acpi_iort_pmcg {
	u64 page0_base_address;
	u32 overflow_gsiv;
	u32 node_reference;
	u64 page1_base_address;
};

struct acpi_iort_rmr {
	u32 flags;
	u32 rmr_count;
	u32 rmr_offset;
};

struct acpi_iort_rmr_desc {
	u64 base_address;
	u64 length;
	u32 reserved;
} __attribute__((packed));

struct acpi_iort_root_complex {
	u64 memory_properties;
	u32 ats_attribute;
	u32 pci_segment_number;
	u8 memory_address_limit;
	u16 pasid_capabilities;
	u8 reserved[0];
} __attribute__((packed));

struct acpi_iort_smmu {
	u64 base_address;
	u64 span;
	u32 model;
	u32 flags;
	u32 global_interrupt_offset;
	u32 context_interrupt_count;
	u32 context_interrupt_offset;
	u32 pmu_interrupt_count;
	u32 pmu_interrupt_offset;
	u64 interrupts[0];
} __attribute__((packed));

struct acpi_iort_smmu_v3 {
	u64 base_address;
	u32 flags;
	u32 reserved;
	u64 vatos_address;
	u32 model;
	u32 event_gsiv;
	u32 pri_gsiv;
	u32 gerr_gsiv;
	u32 sync_gsiv;
	u32 pxm;
	u32 id_mapping_index;
} __attribute__((packed));

struct irq_fwspec;

struct acpi_irq_parse_one_ctx {
	int rc;
	unsigned int index;
	long unsigned int *res_flags;
	struct irq_fwspec *fwspec;
	bool skip_producer_check;
};

struct acpi_lpat {
	int temp;
	int raw;
};

struct acpi_lpat_conversion_table {
	struct acpi_lpat *lpat;
	int lpat_count;
};

struct acpi_lpi_state {
	u32 min_residency;
	u32 wake_latency;
	u32 flags;
	u32 arch_flags;
	u32 res_cnt_freq;
	u32 enable_parent_state;
	u64 address;
	u8 index;
	u8 entry_method;
	char desc[32];
};

struct acpi_lpi_states_array {
	unsigned int size;
	unsigned int composite_states_size;
	struct acpi_lpi_state *entries;
	struct acpi_lpi_state *composite_states[8];
};

struct acpi_subtable_header {
	u8 type;
	u8 length;
};

struct acpi_madt_core_pic {
	struct acpi_subtable_header header;
	u8 version;
	u32 processor_id;
	u32 core_id;
	u32 flags;
} __attribute__((packed));

struct acpi_madt_generic_distributor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 gic_id;
	u64 base_address;
	u32 global_irq_base;
	u8 version;
	u8 reserved2[3];
};

struct acpi_madt_generic_interrupt {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 cpu_interface_number;
	u32 uid;
	u32 flags;
	u32 parking_version;
	u32 performance_interrupt;
	u64 parked_address;
	u64 base_address;
	u64 gicv_base_address;
	u64 gich_base_address;
	u32 vgic_interrupt;
	u64 gicr_base_address;
	u64 arm_mpidr;
	u8 efficiency_class;
	u8 reserved2[1];
	u16 spe_interrupt;
	u16 trbe_interrupt;
} __attribute__((packed));

struct acpi_madt_generic_msi_frame {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 msi_frame_id;
	u64 base_address;
	u32 flags;
	u16 spi_count;
	u16 spi_base;
};

struct acpi_madt_generic_redistributor {
	struct acpi_subtable_header header;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u32 length;
} __attribute__((packed));

struct acpi_madt_generic_translator {
	struct acpi_subtable_header header;
	u8 flags;
	u8 reserved;
	u32 translation_id;
	u64 base_address;
	u32 reserved2;
} __attribute__((packed));

struct acpi_madt_interrupt_override {
	struct acpi_subtable_header header;
	u8 bus;
	u8 source_irq;
	u32 global_irq;
	u16 inti_flags;
} __attribute__((packed));

struct acpi_madt_interrupt_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u8 type;
	u8 id;
	u8 eid;
	u8 io_sapic_vector;
	u32 global_irq;
	u32 flags;
};

struct acpi_madt_io_apic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 address;
	u32 global_irq_base;
};

struct acpi_madt_io_sapic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 global_irq_base;
	u64 address;
};

struct acpi_madt_local_apic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u32 lapic_flags;
};

struct acpi_madt_local_apic_nmi {
	struct acpi_subtable_header header;
	u8 processor_id;
	u16 inti_flags;
	u8 lint;
} __attribute__((packed));

struct acpi_madt_local_apic_override {
	struct acpi_subtable_header header;
	u16 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_madt_local_sapic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u8 eid;
	u8 reserved[3];
	u32 lapic_flags;
	u32 uid;
	char uid_string[0];
};

struct acpi_madt_local_x2apic {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 local_apic_id;
	u32 lapic_flags;
	u32 uid;
};

struct acpi_madt_local_x2apic_nmi {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 uid;
	u8 lint;
	u8 reserved[3];
};

struct acpi_madt_multiproc_wakeup {
	struct acpi_subtable_header header;
	u16 version;
	u32 reserved;
	u64 mailbox_address;
	u64 reset_vector;
};

struct acpi_madt_nmi_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 global_irq;
};

struct acpi_madt_rintc {
	struct acpi_subtable_header header;
	u8 version;
	u8 reserved;
	u32 flags;
	u64 hart_id;
	u32 uid;
	u32 ext_intc_id;
	u64 imsic_addr;
	u32 imsic_size;
} __attribute__((packed));

struct acpi_mcfg_allocation {
	u64 address;
	u16 pci_segment;
	u8 start_bus_number;
	u8 end_bus_number;
	u32 reserved;
};

struct acpi_mem_mapping {
	acpi_physical_address physical_address;
	u8 *logical_address;
	acpi_size length;
	struct acpi_mem_mapping *next_mm;
};

struct acpi_mem_space_context {
	u32 length;
	acpi_physical_address address;
	struct acpi_mem_mapping *cur_mm;
	struct acpi_mem_mapping *first_mm;
};

struct acpi_memory_attribute {
	u8 write_protect;
	u8 caching;
	u8 range_type;
	u8 translation;
};

struct acpi_memory_device {
	struct acpi_device *device;
	struct list_head res_list;
	int mgid;
};

struct acpi_memory_info {
	struct list_head list;
	u64 start_addr;
	u64 length;
	short unsigned int caching;
	short unsigned int write_protect;
	unsigned int enabled: 1;
};

struct acpi_mutex_info {
	void *mutex;
	u32 use_count;
	u64 thread_id;
};

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed));

struct acpi_namestring_info {
	const char *external_name;
	const char *next_external_char;
	char *internal_name;
	u32 length;
	u32 num_segments;
	u32 num_carats;
	u8 fully_qualified;
};

struct acpi_nhlt_config {
	u32 capabilities_size;
	u8 capabilities[0];
};

struct acpi_nhlt_gendevice_config {
	u8 virtual_slot;
	u8 config_type;
};

struct acpi_nhlt_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
};

struct acpi_nhlt_vendor_mic_config {
	u8 type;
	u8 panel;
	u16 speaker_position_distance;
	u16 horizontal_offset;
	u16 vertical_offset;
	u8 frequency_low_band;
	u8 frequency_high_band;
	u16 direction_angle;
	u16 elevation_angle;
	u16 work_vertical_angle_begin;
	u16 work_vertical_angle_end;
	u16 work_horizontal_angle_begin;
	u16 work_horizontal_angle_end;
};

struct acpi_nhlt_vendor_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
	u8 mics_count;
	struct acpi_nhlt_vendor_mic_config mics[0];
};

union acpi_nhlt_device_config {
	u8 virtual_slot;
	struct acpi_nhlt_gendevice_config gen;
	struct acpi_nhlt_micdevice_config mic;
	struct acpi_nhlt_vendor_micdevice_config vendor_mic;
};

struct acpi_nhlt_endpoint {
	u32 length;
	u8 link_type;
	u8 instance_id;
	u16 vendor_id;
	u16 device_id;
	u16 revision_id;
	u32 subsystem_id;
	u8 device_type;
	u8 direction;
	u8 virtual_bus_id;
} __attribute__((packed));

struct acpi_nhlt_wave_formatext {
	u16 format_tag;
	u16 channel_count;
	u32 samples_per_sec;
	u32 avg_bytes_per_sec;
	u16 block_align;
	u16 bits_per_sample;
	u16 extra_format_size;
	u16 valid_bits_per_sample;
	u32 channel_mask;
	u8 subformat[16];
};

struct acpi_nhlt_format_config {
	struct acpi_nhlt_wave_formatext format;
	struct acpi_nhlt_config config;
};

struct acpi_nhlt_formats_config {
	u8 formats_count;
	struct acpi_nhlt_format_config formats[0];
} __attribute__((packed));

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} power_resource;
};

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
};

struct acpi_offsets {
	size_t offset;
	u8 mode;
};

struct acpi_opcode_info {
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
};

typedef void (*acpi_osd_exec_callback)(void *);

struct acpi_os_dpc {
	acpi_osd_exec_callback function;
	void *context;
	struct work_struct work;
};

struct acpi_osc_context {
	char *uuid_str;
	int rev;
	struct acpi_buffer cap;
	struct acpi_buffer ret;
};

struct acpi_osi_config {
	u8 default_disabling;
	unsigned int linux_enable: 1;
	unsigned int linux_dmi: 1;
	unsigned int linux_cmdline: 1;
	unsigned int darwin_enable: 1;
	unsigned int darwin_dmi: 1;
	unsigned int darwin_cmdline: 1;
};

struct acpi_osi_entry {
	char string[64];
	bool enable;
};

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
};

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed));

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed));

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
};

struct acpi_pcc_info {
	u8 subspace_id;
	u16 length;
	u8 *internal_buffer;
};

struct acpi_pcct_ext_pcc_master {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved1;
	u64 base_address;
	u32 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u32 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_set_mask;
	u64 reserved2;
	struct acpi_generic_address cmd_complete_register;
	u64 cmd_complete_mask;
	struct acpi_generic_address cmd_update_register;
	u64 cmd_update_preserve_mask;
	u64 cmd_update_set_mask;
	struct acpi_generic_address error_status_register;
	u64 error_status_mask;
} __attribute__((packed));

struct acpi_pcct_ext_pcc_shared_memory {
	u32 signature;
	u32 flags;
	u32 length;
	u32 command;
};

struct acpi_pcct_hw_reduced {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pcct_hw_reduced_type2 {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_write_mask;
} __attribute__((packed));

struct acpi_pcct_shared_memory {
	u32 signature;
	u16 command;
	u16 status;
};

struct acpi_pcct_subspace {
	struct acpi_subtable_header header;
	u8 reserved[6];
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed));

struct acpi_pci_device {
	acpi_handle device;
	struct acpi_pci_device *next;
};

struct acpi_pci_root;

struct acpi_pci_root_ops;

struct acpi_pci_root_info {
	struct acpi_pci_root *root;
	struct acpi_device *bridge;
	struct acpi_pci_root_ops *ops;
	struct list_head resources;
	char name[16];
};

struct pci_config_window;

struct acpi_pci_generic_root_info {
	struct acpi_pci_root_info common;
	struct pci_config_window *cfg;
};

struct acpi_pci_id {
	u16 segment;
	u16 bus;
	u16 device;
	u16 function;
};

struct acpi_pci_link_irq {
	u32 active;
	u8 triggering;
	u8 polarity;
	u8 resource_type;
	u8 possible_count;
	u32 possible[16];
	u8 initialized: 1;
	u8 reserved: 7;
};

struct acpi_pci_link {
	struct list_head list;
	struct acpi_device *device;
	struct acpi_pci_link_irq irq;
	int refcnt;
};

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
};

struct pci_bus;

struct acpi_pci_root {
	struct acpi_device *device;
	struct pci_bus *bus;
	u16 segment;
	int bridge_type;
	struct resource secondary;
	u32 osc_support_set;
	u32 osc_control_set;
	u32 osc_ext_support_set;
	u32 osc_ext_control_set;
	phys_addr_t mcfg_addr;
};

struct pci_ops;

struct acpi_pci_root_ops {
	struct pci_ops *pci_ops;
	int (*init_info)(struct acpi_pci_root_info *);
	void (*release_info)(struct acpi_pci_root_info *);
	int (*prepare_resources)(struct acpi_pci_root_info *);
};

struct acpi_pci_routing_table {
	u32 length;
	u32 pin;
	u64 address;
	u32 source_index;
	union {
		char pad[4];
		struct {
			struct {} __Empty_source;
			char source[0];
		};
	};
};

struct pci_slot;

struct acpi_pci_slot {
	struct pci_slot *pci_slot;
	struct list_head list;
};

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed));

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
};

struct acpi_platform_list {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
	char *table;
	enum acpi_predicate pred;
	char *reason;
	u32 data;
};

struct acpi_pld_info {
	u8 revision;
	u8 ignore_color;
	u8 red;
	u8 green;
	u8 blue;
	u16 width;
	u16 height;
	u8 user_visible;
	u8 dock;
	u8 lid;
	u8 panel;
	u8 vertical_position;
	u8 horizontal_position;
	u8 shape;
	u8 group_orientation;
	u8 group_token;
	u8 group_position;
	u8 bay;
	u8 ejectable;
	u8 ospm_eject_required;
	u8 cabinet_number;
	u8 card_cage_number;
	u8 reference;
	u8 rotation;
	u8 order;
	u8 reserved;
	u16 vertical_offset;
	u16 horizontal_offset;
};

struct acpi_port_info {
	char *name;
	u16 start;
	u16 end;
	u8 osi_dependency;
};

struct acpi_power_dependent_device {
	struct device *dev;
	struct list_head node;
};

struct acpi_power_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_power_resource {
	struct acpi_device device;
	struct list_head list_node;
	u32 system_level;
	u32 order;
	unsigned int ref_count;
	u8 state;
	struct mutex resource_lock;
	struct list_head dependents;
};

struct acpi_power_resource_entry {
	struct list_head node;
	struct acpi_power_resource *resource;
};

struct acpi_pptt_cache {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 next_level_of_cache;
	u32 size;
	u32 number_of_sets;
	u8 associativity;
	u8 attributes;
	u16 line_size;
};

struct acpi_pptt_cache_v1 {
	u32 cache_id;
};

struct acpi_pptt_processor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 parent;
	u32 acpi_processor_id;
	u32 number_of_priv_resources;
};

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
};

struct acpi_predefined_names {
	const char *name;
	u8 type;
	char *val;
};

struct acpi_prmt_handler_info {
	u16 revision;
	u16 length;
	u8 handler_guid[16];
	u64 handler_address;
	u64 static_data_buffer_address;
	u64 acpi_param_buffer_address;
} __attribute__((packed));

struct acpi_prmt_module_header {
	u16 revision;
	u16 length;
};

struct acpi_prmt_module_info {
	u16 revision;
	u16 length;
	u8 module_guid[16];
	u16 major_rev;
	u16 minor_rev;
	u16 handler_info_count;
	u32 handler_info_offset;
	u64 mmio_list_pointer;
} __attribute__((packed));

struct acpi_probe_entry;

typedef bool (*acpi_probe_entry_validate_subtbl)(struct acpi_subtable_header *, struct acpi_probe_entry *);

struct acpi_table_header;

typedef int (*acpi_tbl_table_handler)(struct acpi_table_header *);

union acpi_subtable_headers;

typedef int (*acpi_tbl_entry_handler)(union acpi_subtable_headers *, const long unsigned int);

struct acpi_probe_entry {
	__u8 id[5];
	__u8 type;
	acpi_probe_entry_validate_subtbl subtable_valid;
	union {
		acpi_tbl_table_handler probe_table;
		acpi_tbl_entry_handler probe_subtbl;
	};
	kernel_ulong_t driver_data;
};

struct acpi_processor_flags {
	u8 power: 1;
	u8 performance: 1;
	u8 throttling: 1;
	u8 limit: 1;
	u8 bm_control: 1;
	u8 bm_check: 1;
	u8 has_cst: 1;
	u8 has_lpi: 1;
	u8 power_setup_done: 1;
	u8 bm_rld_set: 1;
	u8 previously_online: 1;
};

struct acpi_processor_cx {
	u8 valid;
	u8 type;
	u32 address;
	u8 entry_method;
	u8 index;
	u32 latency;
	u8 bm_sts_skip;
	char desc[32];
};

struct acpi_processor_power {
	int count;
	union {
		struct acpi_processor_cx states[8];
		struct acpi_lpi_state lpi_states[8];
	};
	int timer_broadcast_on_state;
};

struct acpi_tsd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

typedef struct cpumask *cpumask_var_t;

struct acpi_processor_tx {
	u16 power;
	u16 performance;
};

struct acpi_processor_tx_tss;

struct acpi_processor;

struct acpi_processor_throttling {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_tx_tss *states_tss;
	struct acpi_tsd_package domain_info;
	cpumask_var_t shared_cpu_map;
	int (*acpi_processor_get_throttling)(struct acpi_processor *);
	int (*acpi_processor_set_throttling)(struct acpi_processor *, int, bool);
	u32 address;
	u8 duty_offset;
	u8 duty_width;
	u8 tsd_valid_flag;
	unsigned int shared_type;
	struct acpi_processor_tx states[16];
};

struct acpi_processor_lx {
	int px;
	int tx;
};

struct acpi_processor_limit {
	struct acpi_processor_lx state;
	struct acpi_processor_lx thermal;
	struct acpi_processor_lx user;
};

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
};

struct freq_constraints;

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
};

struct acpi_processor_performance;

struct acpi_processor {
	acpi_handle handle;
	u32 acpi_id;
	phys_cpuid_t phys_id;
	u32 id;
	u32 pblk;
	int performance_platform_limit;
	int throttling_platform_limit;
	struct acpi_processor_flags flags;
	struct acpi_processor_power power;
	struct acpi_processor_performance *performance;
	struct acpi_processor_throttling throttling;
	struct acpi_processor_limit limit;
	struct thermal_cooling_device *cdev;
	struct device *dev;
	struct freq_qos_request perflib_req;
	struct freq_qos_request thermal_req;
};

struct acpi_processor_errata {
	u8 smp;
	struct {
		u8 throttle: 1;
		u8 fdma: 1;
		u8 reserved: 6;
		u32 bmisx;
	} piix4;
};

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
};

struct acpi_processor_px;

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
};

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
};

struct acpi_processor_tx_tss {
	u64 freqpercentage;
	u64 power;
	u64 transition_latency;
	u64 control;
	u64 status;
};

struct acpi_prt_entry {
	struct acpi_pci_id id;
	u8 pin;
	acpi_handle link;
	u32 index;
};

struct acpi_reg_walk_info {
	u32 function;
	u32 reg_run_count;
	acpi_adr_space_type space_id;
};

typedef acpi_status (*acpi_repair_function)(struct acpi_evaluate_info *, union acpi_operand_object **);

struct acpi_repair_info {
	char name[4];
	acpi_repair_function repair_function;
};

struct acpi_resource_irq {
	u8 descriptor_length;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	union {
		u8 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u8 interrupts[0];
		};
	};
};

struct acpi_resource_dma {
	u8 type;
	u8 bus_master;
	u8 transfer;
	u8 channel_count;
	union {
		u8 channel;
		struct {
			struct {} __Empty_channels;
			u8 channels[0];
		};
	};
};

struct acpi_resource_start_dependent {
	u8 descriptor_length;
	u8 compatibility_priority;
	u8 performance_robustness;
};

struct acpi_resource_io {
	u8 io_decode;
	u8 alignment;
	u8 address_length;
	u16 minimum;
	u16 maximum;
} __attribute__((packed));

struct acpi_resource_fixed_io {
	u16 address;
	u8 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_dma {
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed));

struct acpi_resource_vendor {
	u16 byte_length;
	u8 byte_data[0];
};

struct acpi_resource_vendor_typed {
	u16 byte_length;
	u8 uuid_subtype;
	u8 uuid[16];
	u8 byte_data[0];
} __attribute__((packed));

struct acpi_resource_end_tag {
	u8 checksum;
};

struct acpi_resource_memory24 {
	u8 write_protect;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed));

struct acpi_resource_memory32 {
	u8 write_protect;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed));

struct acpi_resource_fixed_memory32 {
	u8 write_protect;
	u32 address;
	u32 address_length;
} __attribute__((packed));

union acpi_resource_attribute {
	struct acpi_memory_attribute mem;
	struct acpi_io_attribute io;
	u8 type_specific;
};

struct acpi_resource_source {
	u8 index;
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_address16 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address16_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address32 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address32_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address64_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_extended_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	u8 revision_ID;
	struct acpi_address64_attribute address;
	u64 type_specific;
} __attribute__((packed));

struct acpi_resource_extended_irq {
	u8 producer_consumer;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	struct acpi_resource_source resource_source;
	union {
		u32 interrupt;
		struct {
			struct {} __Empty_interrupts;
			u32 interrupts[0];
		};
	};
} __attribute__((packed));

struct acpi_resource_generic_register {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed));

struct acpi_resource_gpio {
	u8 revision_id;
	u8 connection_type;
	u8 producer_consumer;
	u8 pin_config;
	u8 shareable;
	u8 wake_capable;
	u8 io_restriction;
	u8 triggering;
	u8 polarity;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_i2c_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 access_mode;
	u16 slave_address;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_spi_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 wire_mode;
	u8 device_polarity;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
	u32 connection_speed;
} __attribute__((packed));

struct acpi_resource_uart_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 endian;
	u8 data_bits;
	u8 stop_bits;
	u8 flow_control;
	u8 parity;
	u8 lines_enabled;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u32 default_baud_rate;
} __attribute__((packed));

struct acpi_resource_csi2_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 local_port_instance;
	u8 phy_type;
} __attribute__((packed));

struct acpi_resource_common_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_function {
	u8 revision_id;
	u8 pin_config;
	u8 shareable;
	u16 function_number;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_label {
	u16 string_length;
	char *string_ptr;
} __attribute__((packed));

struct acpi_resource_pin_group {
	u8 revision_id;
	u8 producer_consumer;
	u16 pin_table_length;
	u16 vendor_length;
	u16 *pin_table;
	struct acpi_resource_label resource_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_function {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u16 function_number;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_pin_group_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed));

struct acpi_resource_clock_input {
	u8 revision_id;
	u8 mode;
	u8 scale;
	u16 frequency_divisor;
	u32 frequency_numerator;
	struct acpi_resource_source resource_source;
} __attribute__((packed));

struct acpi_resource_address {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
};

union acpi_resource_data {
	struct acpi_resource_irq irq;
	struct acpi_resource_dma dma;
	struct acpi_resource_start_dependent start_dpf;
	struct acpi_resource_io io;
	struct acpi_resource_fixed_io fixed_io;
	struct acpi_resource_fixed_dma fixed_dma;
	struct acpi_resource_vendor vendor;
	struct acpi_resource_vendor_typed vendor_typed;
	struct acpi_resource_end_tag end_tag;
	struct acpi_resource_memory24 memory24;
	struct acpi_resource_memory32 memory32;
	struct acpi_resource_fixed_memory32 fixed_memory32;
	struct acpi_resource_address16 address16;
	struct acpi_resource_address32 address32;
	struct acpi_resource_address64 address64;
	struct acpi_resource_extended_address64 ext_address64;
	struct acpi_resource_extended_irq extended_irq;
	struct acpi_resource_generic_register generic_reg;
	struct acpi_resource_gpio gpio;
	struct acpi_resource_i2c_serialbus i2c_serial_bus;
	struct acpi_resource_spi_serialbus spi_serial_bus;
	struct acpi_resource_uart_serialbus uart_serial_bus;
	struct acpi_resource_csi2_serialbus csi2_serial_bus;
	struct acpi_resource_common_serialbus common_serial_bus;
	struct acpi_resource_pin_function pin_function;
	struct acpi_resource_pin_config pin_config;
	struct acpi_resource_pin_group pin_group;
	struct acpi_resource_pin_group_function pin_group_function;
	struct acpi_resource_pin_group_config pin_group_config;
	struct acpi_resource_clock_input clock_input;
	struct acpi_resource_address address;
};

struct acpi_resource {
	u32 type;
	u32 length;
	union acpi_resource_data data;
};

struct acpi_rsconvert_info {
	u8 opcode;
	u8 resource_offset;
	u8 aml_offset;
	u8 value;
};

struct acpi_rw_lock {
	void *writer_mutex;
	void *reader_mutex;
	u32 num_readers;
};

struct acpi_scan_clear_dep_work {
	struct work_struct work;
	struct acpi_device *adev;
};

struct acpi_scan_handler {
	struct list_head list_node;
	const struct acpi_device_id *ids;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*post_eject)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
};

typedef u32 (*acpi_sci_handler)(void *);

struct acpi_sci_handler_info {
	struct acpi_sci_handler_info *next;
	acpi_sci_handler address;
	void *context;
};

struct acpi_serdev_lookup {
	acpi_handle device_handle;
	acpi_handle controller_handle;
	int n;
	int index;
};

struct acpi_signal_fatal_info {
	u32 type;
	u32 code;
	u32 argument;
};

typedef acpi_status (*acpi_object_converter)(struct acpi_namespace_node *, union acpi_operand_object *, union acpi_operand_object **);

struct acpi_simple_repair_info {
	char name[4];
	u32 unexpected_btypes;
	u32 package_index;
	acpi_object_converter object_converter;
};

struct spi_controller;

struct acpi_spi_lookup {
	struct spi_controller *ctlr;
	u32 max_speed_hz;
	u32 mode;
	int irq;
	u8 bits_per_word;
	u8 chip_select;
	int n;
	int index;
};

struct acpi_srat_cpu_affinity {
	struct acpi_subtable_header header;
	u8 proximity_domain_lo;
	u8 apic_id;
	u32 flags;
	u8 local_sapic_eid;
	u8 proximity_domain_hi[3];
	u32 clock_domain;
};

struct acpi_srat_generic_affinity {
	struct acpi_subtable_header header;
	u8 reserved;
	u8 device_handle_type;
	u32 proximity_domain;
	u8 device_handle[16];
	u32 flags;
	u32 reserved1;
};

struct acpi_srat_gic_its_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u32 its_id;
} __attribute__((packed));

struct acpi_srat_gicc_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} __attribute__((packed));

struct acpi_srat_mem_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u64 base_address;
	u64 length;
	u32 reserved1;
	u32 flags;
	u64 reserved2;
} __attribute__((packed));

struct acpi_srat_rintc_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
};

struct acpi_srat_x2apic_cpu_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 apic_id;
	u32 flags;
	u32 clock_domain;
	u32 reserved2;
};

struct acpi_subtable_entry {
	union acpi_subtable_headers *hdr;
	enum acpi_subtable_type type;
};

union acpi_subtable_headers {
	struct acpi_subtable_header common;
	struct acpi_hmat_structure hmat;
	struct acpi_prmt_module_header prmt;
	struct acpi_cedt_header cedt;
	struct acpi_cdat_header cdat;
};

typedef int (*acpi_tbl_entry_handler_arg)(union acpi_subtable_headers *, void *, const long unsigned int);

struct acpi_subtable_proc {
	int id;
	acpi_tbl_entry_handler handler;
	acpi_tbl_entry_handler_arg handler_arg;
	void *arg;
	int count;
};

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
};

struct acpi_table_agdi {
	struct acpi_table_header header;
	u8 flags;
	u8 reserved[3];
	u32 sdei_event;
	u32 gsiv;
};

struct acpi_table_apmt {
	struct acpi_table_header header;
};

struct acpi_table_attr {
	struct bin_attribute attr;
	char name[4];
	int instance;
	char filename[8];
	struct list_head node;
};

struct acpi_table_bert {
	struct acpi_table_header header;
	u32 region_length;
	u64 address;
};

struct acpi_table_bgrt {
	struct acpi_table_header header;
	u16 version;
	u8 status;
	u8 image_type;
	u64 image_address;
	u32 image_offset_x;
	u32 image_offset_y;
};

struct acpi_table_ccel {
	struct acpi_table_header header;
	u8 CCtype;
	u8 Ccsub_type;
	u16 reserved;
	u64 log_area_minimum_length;
	u64 log_area_start_address;
};

struct acpi_table_cdat {
	u32 length;
	u8 revision;
	u8 checksum;
	u8 reserved[6];
	u32 sequence;
};

struct acpi_table_csrt {
	struct acpi_table_header header;
};

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
};

struct acpi_table_ecdt {
	struct acpi_table_header header;
	struct acpi_generic_address control;
	struct acpi_generic_address data;
	u32 uid;
	u8 gpe;
	u8 id[0];
} __attribute__((packed));

struct acpi_table_erst {
	struct acpi_table_header header;
	u32 header_length;
	u32 reserved;
	u32 entries;
};

struct acpi_table_facs {
	char signature[4];
	u32 length;
	u32 hardware_signature;
	u32 firmware_waking_vector;
	u32 global_lock;
	u32 flags;
	u64 xfirmware_waking_vector;
	u8 version;
	u8 reserved[3];
	u32 ospm_flags;
	u8 reserved1[24];
};

struct acpi_table_fadt {
	struct acpi_table_header header;
	u32 facs;
	u32 dsdt;
	u8 model;
	u8 preferred_profile;
	u16 sci_interrupt;
	u32 smi_command;
	u8 acpi_enable;
	u8 acpi_disable;
	u8 s4_bios_request;
	u8 pstate_control;
	u32 pm1a_event_block;
	u32 pm1b_event_block;
	u32 pm1a_control_block;
	u32 pm1b_control_block;
	u32 pm2_control_block;
	u32 pm_timer_block;
	u32 gpe0_block;
	u32 gpe1_block;
	u8 pm1_event_length;
	u8 pm1_control_length;
	u8 pm2_control_length;
	u8 pm_timer_length;
	u8 gpe0_block_length;
	u8 gpe1_block_length;
	u8 gpe1_base;
	u8 cst_control;
	u16 c2_latency;
	u16 c3_latency;
	u16 flush_size;
	u16 flush_stride;
	u8 duty_offset;
	u8 duty_width;
	u8 day_alarm;
	u8 month_alarm;
	u8 century;
	u16 boot_flags;
	u8 reserved;
	u32 flags;
	struct acpi_generic_address reset_register;
	u8 reset_value;
	u16 arm_boot_flags;
	u8 minor_revision;
	u64 Xfacs;
	u64 Xdsdt;
	struct acpi_generic_address xpm1a_event_block;
	struct acpi_generic_address xpm1b_event_block;
	struct acpi_generic_address xpm1a_control_block;
	struct acpi_generic