# AI Policy for Developers and Contributors

This is our AI Policy **for** _human contributors_ about
**using** AI assistance with details on:

- Legal/IP requirements
- Disclosure obligations
- Authorship warranties

For instructions **to** _AI assistants_ (e.g.
[Anthropic Claude](https://www.anthropic.com/claude),
[Google Gemini](https://gemini.google.com/app),
[OpenAI ChatGPT](https://openai.com/chatgpt/overview/),
[Microsoft Copilot](https://copilot.microsoft.com/) or other)
about **providing** AI assistance, please see
[CLAUDE](https://github.com/crossbario/txaio/blob/main/CLAUDE.md).

Important

**The Bottom Line - Make the right thing the easy thing.**

Your pull request is your byline. When you submit code, you are
signing your name to it and warranting that you are the
**Author**.

Whether you used an AI as an **Editor** or a **Ghostwriter**, the
final work must be a product of **Your** skill, judgment, and
creative labor.

An AI can never be credited as an author or co-author.

---

## A Helpful Analogy: The AI as an Editor or Ghostwriter

To understand the role you, the human contributor, must play when
using AI tools, it's helpful to draw an analogy from the world of
writing and publishing. For any code you submit to be legally
sound and protect the integrity of this project, your use of AI
**must** mirror the relationship between an author and their
editor or ghostwriter.

### Scenario 1: The AI as an Editor

In publishing, an author writes the original manuscript—the
story, the characters, the plot. They then give it to an editor.
The editor doesn't write the story, but they refine it. They
correct grammar, improve sentence structure, point out
inconsistencies, and suggest better ways to phrase things. The
final work is stronger, but the **Author** is, without question,
the person who wrote the original manuscript.

This is a perfect model for acceptable AI use:

- **You** write the original, substantive code: the architecture,
  the core logic, the solution to the problem.
- The **AI** acts as your editor: it helps you refactor for
  clarity, finds potential bugs (typos), suggests more efficient
  syntax, or helps write comments and documentation for _your_
  code.

In this role, the AI is a powerful tool that polishes your
original work. You remain the sole, undisputed Author.

### Scenario 2: The AI as a Ghostwriter

A ghostwriter is hired to write a book _for_ another person,
based on detailed outlines and extensive interviews. The public
figure who hired them takes the byline and is considered the
author. They are also fully responsible for the book's content,
accuracy, and any legal issues that may arise. They don't just
blindly publish the ghostwriter's draft; they must review,
revise, and ultimately approve every word, making it their own.

This is also an acceptable, but more demanding, model for AI use:

- **You** act as the commissioner: you provide a detailed,
  specific prompt to the AI, outlining exactly what you need a
  block of code to do.
- The **AI** generates a "first draft" of that code block.
- **Your critical responsibility** is to act as the final author:
  you must meticulously review, test, debug, and often
  significantly modify that code. You must understand it
  completely and integrate it into the larger project. By doing
  so, you take full accountability for it.

In this role, you are using the AI to generate raw material, but
it is your intellectual labor — your review, validation, and
integration — that transforms it into a valid contribution.

## The Role an AI Can Never Fill: Author or Co-Author

The hard line is this: an AI can never be credited as an
**Author** or **Co-Author**. It has no legal standing, cannot be
held accountable, and cannot hold copyright. Any contribution
where the AI was the primary creator and the human was merely a
prompter without significant review or modification is not
copyrightable and cannot be accepted.

Accepting such a contribution would have severe consequences for
the project. The code could be considered public domain (and thus
un-licensable) or, worse, a derivative work of the AI's training
data carrying unknown, potentially mixed, viral or even
contradictory license obligations.

In either case, our codebase would cease to be a clean,
single-license work and would become a legally ambiguous
patchwork.
