'''OpenGL extension MESA.framebuffer_flip_x

This module customises the behaviour of the 
OpenGL.raw.GLES2.MESA.framebuffer_flip_x to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines a new framebuffer parameter,
	GL_FRAMEBUFFER_FLIP_X_MESA, that changes the behavior of the reads and
	writes to the framebuffer attachment points. When
	GL_FRAMEBUFFER_FLIP_X_MESA is GL_TRUE, render commands and pixel transfer
	operations access the backing store of each attachment point with an
	x-inverted coordinate system. This x-inversion is relative to the
	coordinate system set when GL_FRAMEBUFFER_FLIP_X_MESA is GL_FALSE.
	
	Access through TexSubImage2D and similar calls will notice the effect of
	the flip when they are not attached to framebuffer objects because
	GL_FRAMEBUFFER_FLIP_X_MESA is associated with the framebuffer object and
	not the attachment points.
	
	This extension is mainly for pre-rotation and recommended to use it with
	MESA_framebuffer_flip_y and MESA_framebuffer_swap_xy to have rotated
	result.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/MESA/framebuffer_flip_x.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.MESA.framebuffer_flip_x import *
from OpenGL.raw.GLES2.MESA.framebuffer_flip_x import _EXTENSION_NAME

def glInitFramebufferFlipXMESA():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION