/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers.stream;

import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.data.IStreamValueEditor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.managers.stream.TextEditorPart;
import org.jkiss.dbeaver.ui.data.managers.stream.TextPanelEditor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class TextStreamValueManager
implements IStreamValueManager {
    private static final Log log = Log.getLog(TextStreamValueManager.class);

    @Override
    public IStreamValueManager.MatchType matchesTo(@NotNull DBRProgressMonitor monitor, @NotNull DBSTypedObject attribute, @Nullable DBDContent value) {
        return ContentUtils.isTextContent((DBDContent)value) ? IStreamValueManager.MatchType.DEFAULT : IStreamValueManager.MatchType.APPLIES;
    }

    @Override
    public IStreamValueEditor createPanelEditor(@NotNull IValueController controller) throws DBException {
        return new TextPanelEditor();
    }

    @Override
    public IEditorPart createEditorPart(@NotNull IValueController controller) {
        return new TextEditorPart();
    }
}

