/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.CollaborationServerInfo;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.xmpp.FindConferenceStrategy;
import com.paterva.maltego.collab.session.xmpp.RegistrationManager;
import com.paterva.maltego.collab.session.xmpp.ServerValidationStrategy;
import com.paterva.maltego.collab.session.xmpp.Utils;
import com.paterva.maltego.collab.session.xmpp.XmppCollaborationConnection;
import java.util.Iterator;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.packet.Version;

abstract class SessionInitializationStrategy {
    SessionInitializationStrategy() {
    }

    public abstract MultiUserChat createChatRoom(XmppCollaborationConnection var1, CollaborationSessionInfo var2) throws CollaborationException;

    public abstract void openChatRoom(MultiUserChat var1, CollaborationSessionInfo var2) throws CollaborationException;

    public abstract void configureChatRoom(MultiUserChat var1, CollaborationSessionInfo var2) throws CollaborationException;

    public abstract void sendSessionID(MultiUserChat var1, CollaborationSessionInfo var2, String var3) throws CollaborationException;

    public static class InstantChat
    extends Abstract {
        public InstantChat(ConnectionInitiationCallback cb) {
            super(cb);
        }

        @Override
        public void openChatRoom(MultiUserChat muc, CollaborationSessionInfo info) throws CollaborationException {
            this.getCallback().progress(LogMessageLevel.Info, "Joining chat room");
            this.openChatRoom(muc, info, 3);
        }

        private void openChatRoom(MultiUserChat muc, CollaborationSessionInfo info, int retry) throws CollaborationException {
            try {
                DiscussionHistory history = new DiscussionHistory();
                history.setMaxStanzas(info.getMaxHistoryCount());
                muc.join(info.getUsername(), null, history, info.getDisconnectTimeout());
            }
            catch (XMPPException ex) {
                XMPPError xmppError = ex.getXMPPError();
                if ((xmppError == null || xmppError.getType() == XMPPError.Type.WAIT) && --retry > 0) {
                    this.sleep(5000);
                    this.getCallback().progress(LogMessageLevel.Info, String.format("Joining chat room (%d tries left)", retry));
                    this.openChatRoom(muc, info, retry);
                }
                throw new CollaborationException("Error joining chat room - no more retries left", ex, false);
            }
        }

        @Override
        public void configureChatRoom(MultiUserChat muc, CollaborationSessionInfo info) throws CollaborationException {
            try {
                muc.sendConfigurationForm(new Form("submit"));
            }
            catch (XMPPException ex) {
                throw new CollaborationException("Error configuring chat room", ex, false);
            }
        }

        @Override
        public void sendSessionID(MultiUserChat muc, CollaborationSessionInfo info, String sessionID) throws CollaborationException {
            try {
                muc.changeSubject(sessionID);
            }
            catch (XMPPException ex) {
                throw new CollaborationException("Error sending session ID", ex, false);
            }
        }

        private void sleep(int millis) throws CollaborationException {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ex) {
                throw new CollaborationException("User cancelled", false);
            }
        }
    }

    public static abstract class Abstract
    extends SessionInitializationStrategy {
        private ConnectionInitiationCallback _cb;

        public Abstract(ConnectionInitiationCallback cb) {
            this._cb = cb;
        }

        @Override
        public MultiUserChat createChatRoom(XmppCollaborationConnection cn, CollaborationSessionInfo info) throws CollaborationException {
            MultiUserChat muc = null;
            try {
                this.getCallback().progress(LogMessageLevel.Info, "Initializing...");
                this.checkCancelled();
                String msg = "Connecting to " + info.getServer();
                if (info.getPort() > 0) {
                    msg = msg + ":" + info.getPort();
                }
                this.getCallback().progress(LogMessageLevel.Info, msg, 10);
                Abstract.sleep();
                cn.connect();
                this.checkCancelled();
                try {
                    this.getCallback().progress(LogMessageLevel.Info, "Authenticating as " + info.getUsername(), 12);
                    Abstract.sleep();
                    cn.login(info.getUsername(), info.getPassword());
                }
                catch (XMPPException e) {
                    if (e.getMessage() != null && (e.getMessage().contains("not-authorized") || e.getMessage().contains("DIGEST-MD5"))) {
                        RegistrationManager.getInstance().authenticationFailed(info, this.getCallback());
                        throw new CollaborationException("Authentication failed", false);
                    }
                    throw new CollaborationException(e, true);
                }
                this.checkCancelled();
                new ServerValidationStrategy.None().checkServerCredentials(cn, info);
                this.checkCancelled();
                if (info.getServerInfo() == null) {
                    CollaborationServerInfo serverInfo = this.getServerInfo(cn, info);
                    if (serverInfo == null) {
                        throw new CollaborationException(String.format("Server %s does not have a conference facility and cannot be used for Maltego Collaboration", info.getServer()), false);
                    }
                    info.setServerInfo(serverInfo);
                }
                this.checkCancelled();
                muc = cn.createChatRoom(Utils.getConferenceRoom(info));
            }
            catch (XMPPException ex) {
                throw new CollaborationException("Connection failed: " + ex.getMessage(), ex, false);
            }
            this.checkCancelled();
            return muc;
        }

        private void checkCancelled() throws CollaborationException {
            if (this.isCancelled()) {
                throw new CollaborationException("User cancelled", false);
            }
        }

        protected static void sleep() throws CollaborationException {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                throw new CollaborationException(ex, false);
            }
        }

        protected void show(Form form) {
            System.out.println("-- FORM --");
            System.out.println(form.getType());
            Iterator it = form.getFields();
            while (it.hasNext()) {
                FormField field = (FormField)it.next();
                System.out.println(String.format("type=%s label=%s var=%s", field.getType(), field.getLabel(), field.getVariable()));
                String value = null;
                System.out.println("  Values:");
                Iterator valueIterator = field.getValues();
                while (valueIterator.hasNext()) {
                    System.out.println("   " + value);
                    value = (String)valueIterator.next();
                }
                FormField.Option option = null;
                System.out.println("  Options:");
                Iterator optionIterator = field.getOptions();
                while (optionIterator.hasNext()) {
                    if (option == null) {
                        System.out.println("   null");
                    } else {
                        System.out.println(String.format("   %s : %s", option.getLabel(), option.getValue()));
                    }
                    option = (FormField.Option)optionIterator.next();
                }
            }
            System.out.println("-- ---- --");
        }

        protected void showUsers(MultiUserChat muc) throws XMPPException {
            System.out.println(" -- Admins --");
            for (Affiliate af : muc.getAdmins()) {
                System.out.println("   " + this.toString(af));
            }
            System.out.println(" -- Owners --");
            for (Affiliate af : muc.getOwners()) {
                System.out.println("   " + this.toString(af));
            }
            System.out.println(" -- Members --");
            for (Affiliate af : muc.getMembers()) {
                System.out.println("   " + this.toString(af));
            }
            System.out.println(" -- Moderators --");
            for (Occupant occ : muc.getModerators()) {
                System.out.println("   " + this.toString(occ));
            }
        }

        private String toString(Affiliate af) {
            return String.format("jid=%s aff=%s role=%s", af.getJid(), af.getAffiliation(), af.getRole());
        }

        private String toString(Occupant occ) {
            return String.format("jid=%s aff=%s role=%s", occ.getJid(), occ.getAffiliation(), occ.getRole());
        }

        protected boolean isCancelled() {
            return this.getCallback().isCancelled();
        }

        protected ConnectionInitiationCallback getCallback() {
            return this._cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CollaborationServerInfo getServerInfo(XmppCollaborationConnection cn, CollaborationSessionInfo info) throws CollaborationException {
            CollaborationServerInfo serverInfo = new CollaborationServerInfo();
            if (!this.isCancelled()) {
                this.getCallback().progress(LogMessageLevel.Info, "Finding conference facility at " + info.getService(), 12);
                String conference = FindConferenceStrategy.quick().getConferenceService(cn, info.getService(), this.getCallback());
                if (conference != null) {
                    serverInfo.setConferenceService(conference);
                } else {
                    return null;
                }
            }
            if (!this.isCancelled()) {
                this.getCallback().progress(LogMessageLevel.Info, "Requesting server version from " + info.getService(), 12);
                Version versionRequest = new Version();
                versionRequest.setType(IQ.Type.GET);
                versionRequest.setTo(info.getService());
                PacketCollector collector = cn.createPacketCollector((PacketFilter)new PacketIDFilter(versionRequest.getPacketID()));
                try {
                    cn.sendPacket((Packet)versionRequest);
                    IQ result = (IQ)collector.nextResult(info.getMessageTimeout());
                    if (result != null && result.getType() == IQ.Type.RESULT) {
                        Version versionResult = (Version)result;
                        serverInfo.setServerVersion(versionResult.getVersion());
                        serverInfo.setOsVersion(versionResult.getOs());
                        serverInfo.setServerName(versionResult.getName());
                    }
                }
                finally {
                    collector.cancel();
                }
            }
            return serverInfo;
        }
    }
}

