/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.AbstractConnectionState;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;

abstract class StateConnecting
extends AbstractConnectionState {
    public StateConnecting() {
        super(ConnectionStatus.Connecting, false);
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) throws CollaborationException {
        for (Payload payload : payloads) {
            if (payload.isType("signal")) continue;
            if (payload.isHistoric()) {
                this.debug(String.format("queueing history: %s - %s", payload.getType(), payload.getID()));
                this.historyQueue().add(payload);
                continue;
            }
            this.debug(String.format("queueing live: %s - %s", payload.getType(), payload.getID()));
            this.liveQueue().add(payload);
        }
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        this.localQueue().sendPayload(to, xml);
        this.graphProvider().addToResolverQueue(Collections.singleton(xml));
    }

    public static abstract class Timeout
    extends StateConnecting {
        private Timer _timer = new Timer("State timer", false);
        private boolean _cancelled;

        @Override
        protected void run() {
            this.startTimer();
            this.onRun();
        }

        @Override
        protected void deinit() {
            this.cancelTimer();
        }

        protected abstract void onRun();

        protected abstract long getTimeout();

        protected abstract void onTimeout();

        private void startTimer() {
            this._cancelled = false;
            this._timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Timeout timeout = this;
                    synchronized (timeout) {
                        if (!_cancelled) {
                            this.cancelTimer();
                            this.onTimeout();
                        }
                    }
                }
            }, this.getTimeout());
        }

        protected synchronized void cancelTimer() {
            this._cancelled = true;
            this._timer.cancel();
            this._timer.purge();
        }
    }
}

