/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.analytics;

import com.maltego.analytics.api.AnalyticsClient;
import com.maltego.analytics.api.AnalyticsEvent;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.util.NormalException;
import java.util.Collection;
import java.util.List;

public class RunTransformEvent {
    private static final String TRIGGER_KEY = "trigger";

    private RunTransformEvent() {
    }

    public static void send(TransformDefinition transform, String rootComponent) {
        Trigger triggerForComponent = RunTransformEvent.getTriggerForComponent(rootComponent);
        RunTransformEvent.send(transform, triggerForComponent);
    }

    public static void send(Collection<TransformDefinition> transforms, String rootComponent) {
        Trigger triggerForComponent = RunTransformEvent.getTriggerForComponent(rootComponent);
        for (TransformDefinition transform : transforms) {
            RunTransformEvent.send(transform, triggerForComponent);
        }
    }

    public static void sendAsSet(Collection<TransformDefinition> transforms) {
        Trigger trigger = Trigger.RUN_ALL_TRANSFORM_SET;
        for (TransformDefinition transform : transforms) {
            RunTransformEvent.send(transform, trigger);
        }
    }

    private static Trigger getTriggerForComponent(String rootComponent) {
        Trigger trigger = null;
        if ("context-menu".equals(rootComponent)) {
            trigger = Trigger.TRANSFORM_CONTEXT_MENU;
        } else if ("run-view".equals(rootComponent)) {
            trigger = Trigger.RUN_VIEW;
        }
        return trigger;
    }

    private static void send(TransformDefinition transform, Trigger trigger) {
        String transformName = transform.getName();
        HubSeedDescriptor hubSeed = null;
        List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds((TransformDescriptor)transform);
        if (!hubSeeds.isEmpty()) {
            hubSeed = (HubSeedDescriptor)hubSeeds.get(0);
        }
        if (hubSeed == null) {
            RunTransformEvent.send(transformName, null, trigger, null, null);
        } else {
            TransformSeed transformSeed = HubSeedRegistry.getDefault().getTransformSeed(hubSeed);
            String transformSeedUrl = null;
            try {
                transformSeedUrl = transformSeed.getUrl().getURL().toString();
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            String hubItemName = hubSeed.getName();
            String hubItemDisplayName = hubSeed.getDisplayName();
            if (hubSeed.isCustom()) {
                transformName = RunTransformEvent.maskWithHash(transformName, "internal-transform");
                transformSeedUrl = RunTransformEvent.maskWithHash(transformSeedUrl, "url");
                hubItemName = RunTransformEvent.maskWithHash(hubItemName, "internal-hub-item");
                hubItemDisplayName = RunTransformEvent.maskWithHash(hubItemName, "internal-hub-item-display");
            }
            RunTransformEvent.send(transformName, transformSeedUrl, trigger, hubItemName, hubItemDisplayName);
        }
    }

    private static void send(String transformName, String transformSeedUrl, Trigger trigger, String hubItemName, String hubItemDisplayName) {
        AnalyticsEvent event = new AnalyticsEvent("run_transform", new AnalyticsEvent.Property[]{AnalyticsEvent.Property.of((String)"transform_name", (Object)transformName), AnalyticsEvent.Property.of((String)"transform_seed_url", (Object)transformSeedUrl), AnalyticsEvent.Property.of((String)TRIGGER_KEY, (Object)(trigger == null ? null : trigger.label)), AnalyticsEvent.Property.of((String)"hub_item_name", (Object)hubItemName), AnalyticsEvent.Property.of((String)"hub_item_display_name", (Object)hubItemDisplayName)});
        AnalyticsClient.getDefault().send(event);
    }

    private static String maskWithHash(String plain, String prefix) {
        if (plain == null) {
            return null;
        }
        String hash = Integer.toHexString(plain.hashCode());
        return prefix + "-" + hash;
    }

    public static enum Trigger {
        TRANSFORM_CONTEXT_MENU("transform_context_menu"),
        RUN_VIEW("run_view"),
        RUN_ALL_TRANSFORM_SET("run_all_transform_set");

        String label;

        private Trigger(String label) {
            this.label = label;
        }
    }
}

