/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.utils.bean;

import com.pinkmatter.utils.bean.ObjectIntrospector;
import java.util.HashMap;
import java.util.Map;

public class CachingObjectIntrospector
extends ObjectIntrospector {
    private final Map<String, ObjectIntrospector.Query> _cache = new HashMap<String, ObjectIntrospector.Query>();
    private int _cacheHits = 0;
    private int _cacheMisses = 0;

    @Override
    public ObjectIntrospector.Query getQuery(String expression) {
        ObjectIntrospector.Query query = this._cache.get(expression);
        if (query == null) {
            ++this._cacheMisses;
            query = super.getQuery(expression);
            this._cache.put(expression, query);
        } else {
            ++this._cacheHits;
        }
        return query;
    }

    public void clearCache() {
        this._cache.clear();
    }

    public int cacheSize() {
        return this._cache.size();
    }

    public int getCacheHits() {
        return this._cacheHits;
    }

    public int getCacheMisses() {
        return this._cacheMisses;
    }
}

