/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.find.files.FileSearchProvider;
import com.paterva.maltego.find.files.FindInFilesCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultFileSearchProvider
extends FileSearchProvider {
    @Override
    public List<FileObject> getFiles(FileObject folder, String[] ext, boolean archive, boolean recursive, FindInFilesCallback callback, AtomicBoolean cancelled) {
        FileObject currentFolder = folder;
        this.setStatus(callback, currentFolder, 0);
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Enumeration children = folder.getChildren(recursive);
        while (children.hasMoreElements() && !cancelled.get()) {
            FileObject file = (FileObject)children.nextElement();
            if (file.isFolder()) continue;
            boolean updateStatus = false;
            FileObject parent = file.getParent();
            if (!currentFolder.equals(parent)) {
                currentFolder = parent;
                updateStatus = true;
            }
            boolean matchExt = false;
            for (String extension : ext) {
                if (!extension.equalsIgnoreCase(file.getExt())) continue;
                matchExt = true;
                break;
            }
            if (matchExt && (!archive || FileUtil.isArchiveFile((FileObject)file))) {
                files.add(file);
                updateStatus = true;
            }
            if (!updateStatus) continue;
            this.setStatus(callback, currentFolder, files.size());
        }
        Collections.sort(files, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                return o1.getPath().compareToIgnoreCase(o2.getPath());
            }
        });
        return files;
    }

    private void setStatus(FindInFilesCallback callback, FileObject currentFolder, int found) {
        if (callback != null) {
            callback.status("Found " + found + " graphs (Scanning " + FileUtil.getFileDisplayName((FileObject)currentFolder) + ")");
        }
    }
}

