/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.fonts;

import com.paterva.maltego.util.StringUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JLabel;
import org.openide.text.AttributedCharacters;

public class FontFallbackStringPainter {
    private static final Logger LOG = Logger.getLogger(FontFallbackStringPainter.class.getName());
    private static final List<Font> ALL_FONTS = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts());
    private static final List<Font> usedFonts = new ArrayList<Font>();

    public static float paint(Graphics2D g2d, String text, Font preferredFont, Color color, float x, float y, boolean center) {
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            FontMetrics fontMetrics = g2d.getFontMetrics(preferredFont);
            List<TextLayout> layouts = FontFallbackStringPainter.getTextLayouts(g2d.getFontRenderContext(), text, preferredFont, color);
            double width = FontFallbackStringPainter.getBounds(preferredFont, layouts).getWidth();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(" ", g2d);
            y += lineMetrics.getDescent();
            for (TextLayout layout : layouts) {
                float textX = x;
                if (center) {
                    textX = (float)((double)x + width / 2.0 - (double)layout.getAdvance() / 2.0 + 3.0);
                }
                FontFallbackStringPainter.paintLine(g2d, layout, textX, y);
                y += lineMetrics.getHeight();
            }
        }
        return y;
    }

    public static Rectangle2D getBounds(FontRenderContext frc, String text, Font preferredFont) {
        List<TextLayout> layouts = FontFallbackStringPainter.getTextLayouts(frc, text, preferredFont, Color.BLACK);
        return FontFallbackStringPainter.getBounds(preferredFont, layouts);
    }

    public static Rectangle2D getBounds(Font preferredFont, List<TextLayout> layouts) {
        FontMetrics fontMetrics = new JLabel().getFontMetrics(preferredFont);
        double maxWidth = layouts.stream().mapToDouble(TextLayout::getAdvance).max().orElse(0.0);
        double height = layouts.stream().mapToDouble(layout -> fontMetrics.getHeight()).sum();
        return new Rectangle2D.Double(0.0, 0.0, maxWidth, height);
    }

    public static List<TextLayout> getTextLayouts(FontRenderContext frc, String text, Font preferredFont, Color color) {
        String[] lines = text.split("\n");
        return Arrays.stream(lines).map(line -> FontFallbackStringPainter.getChars(line, preferredFont, color)).map(chars -> FontFallbackStringPainter.getTextLayout(frc, chars)).collect(Collectors.toList());
    }

    private static void paintLine(Graphics2D g2d, TextLayout layout, float x, float y) {
        layout.draw(g2d, x, y);
        if (LOG.isLoggable(Level.FINE)) {
            Rectangle2D bounds = layout.getBounds();
            g2d.setStroke(new BasicStroke());
            g2d.setColor(Color.MAGENTA);
            g2d.drawRect((int)((double)x + bounds.getX()), (int)((double)y + bounds.getY()), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
    }

    public static TextLayout getTextLayout(FontRenderContext frc, String text, Font preferredFont) {
        AttributedCharacters chars = FontFallbackStringPainter.getChars(text, preferredFont, Color.BLACK);
        return FontFallbackStringPainter.getTextLayout(frc, chars);
    }

    private static TextLayout getTextLayout(FontRenderContext frc, AttributedCharacters chars) {
        return new TextLayout(chars.iterator(), frc);
    }

    private static AttributedCharacters getChars(String text, Font preferredFont, Color color) {
        int charCount;
        if (StringUtilities.isNullOrEmpty((String)text)) {
            text = " ";
        }
        AttributedCharacters chars = new AttributedCharacters();
        int length = text.length();
        for (int offset = 0; offset < length; offset += charCount) {
            int codepoint = text.codePointAt(offset);
            charCount = Character.charCount(codepoint);
            Font font = FontFallbackStringPainter.getFont(preferredFont, codepoint);
            for (int i = 0; i < charCount; ++i) {
                chars.append(text.charAt(offset + i), font, color);
            }
        }
        return chars;
    }

    private static Font getFont(Font preferredFont, int codepoint) {
        return preferredFont.canDisplay(codepoint) ? preferredFont : FontFallbackStringPainter.fallbackToCachedFont(preferredFont, codepoint).orElseGet(() -> FontFallbackStringPainter.fallbackToAnyFont(preferredFont, codepoint).orElse(preferredFont));
    }

    private static Optional<Font> fallbackToCachedFont(Font preferredFont, int codepoint) {
        return FontFallbackStringPainter.getFontStream(usedFonts, codepoint, preferredFont).findFirst();
    }

    private static Optional<Font> fallbackToAnyFont(Font preferredFont, int codepoint) {
        return FontFallbackStringPainter.getFontStream(ALL_FONTS, codepoint, preferredFont).peek(usedFonts::add).findFirst();
    }

    private static Stream<Font> getFontStream(List<Font> fonts, int codepoint, Font preferredFont) {
        return fonts.stream().filter(f -> f.canDisplay(codepoint)).map(f -> f.deriveFont(preferredFont.getStyle(), preferredFont.getSize()));
    }
}

