/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class TranslucentGlassPane
extends JPanel {
    private static final Color TRANSLUCENT_COLOR = new Color(0, 0, 0, 128);
    private GlassPaneCustomizer customizer = new GlassPaneCustomizer();

    TranslucentGlassPane() {
        this.setOpaque(false);
        GlassPaneMouseListener mouseListener = new GlassPaneMouseListener(this);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addKeyListener(this.createKeyListener());
        this.setFocusTraversalKeysEnabled(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                TranslucentGlassPane.this.requestFocusInWindow();
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setDropTarget(new DropTarget(this, 0, null));
    }

    public void setCustomizer(GlassPaneCustomizer customizer) {
        this.customizer = customizer;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(TRANSLUCENT_COLOR);
        Area area = new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        area.subtract(new Area(this.getTitleBarArea()));
        this.customizer.focusAreas.forEach(focusArea -> area.subtract(new Area((Shape)focusArea.get())));
        g2d.fill(area);
        this.customizer.customPainters.forEach(painter -> painter.accept(g2d));
        g2d.dispose();
    }

    private Rectangle getTitleBarArea() {
        return new Rectangle(335, 0, this.getWidth() - 335, 32);
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                TranslucentGlassPane.this.customizer.keyEventDispatchers.forEach(eventDispatcher -> eventDispatcher.accept(e));
                e.consume();
            }
        };
    }

    private class GlassPaneMouseListener
    extends MouseInputAdapter {
        private final Component titlePane = WindowUtil.getTitlePane();
        private final TranslucentGlassPane glasspane;
        private Component lastComponent;

        public GlassPaneMouseListener(TranslucentGlassPane glasspane) {
            this.glasspane = glasspane;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.doActionIfInTitleBarArea(e, () -> {
                Component component = this.getComponent(e.getPoint());
                if (component != this.lastComponent) {
                    if (this.lastComponent != null && this.lastComponent != this.titlePane) {
                        this.redispatchMouseEvent(this.lastComponent, e, 505);
                    }
                    if (component != null && component != this.titlePane) {
                        this.redispatchMouseEvent(component, e, 504);
                    }
                }
                this.lastComponent = component;
            });
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.lastComponent == this.titlePane) {
                this.redispatchMouseEvent(this.lastComponent, e, e.getID());
            } else {
                Component component = this.getComponent(e.getPoint());
                if (this.lastComponent != component) {
                    this.redispatchMouseEvent(this.lastComponent, e, 505);
                    this.redispatchMouseEvent(this.lastComponent, e, 502);
                }
            }
            e.consume();
            this.glasspane.requestFocusInWindow();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doActionIfInTitleBarArea(e, () -> {
                Component component = this.getComponent(e.getPoint());
                this.redispatchMouseEvent(component, e, e.getID());
            });
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
            this.glasspane.requestFocusInWindow();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.consume();
            this.glasspane.requestFocusInWindow();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.doActionIfInTitleBarArea(e, () -> {
                Component component = this.getComponent(e.getPoint());
                this.redispatchMouseEvent(component, e, e.getID());
                this.lastComponent = component;
            });
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Component component = this.getComponent(e.getPoint());
            if (component == null) {
                this.redispatchMouseEvent(this.lastComponent, e, e.getID());
            } else {
                this.redispatchMouseEvent(component, e, e.getID());
            }
            this.lastComponent = component;
            e.consume();
            this.glasspane.requestFocusInWindow();
        }

        private void doActionIfInTitleBarArea(MouseEvent e, Runnable action) {
            Point glassPanePoint;
            Rectangle titleBarArea = this.glasspane.getTitleBarArea();
            if (titleBarArea.contains(glassPanePoint = e.getPoint())) {
                action.run();
            }
            e.consume();
            this.glasspane.requestFocusInWindow();
        }

        private Component getComponent(Point glassPanePoint) {
            Point titlePanePoint = SwingUtilities.convertPoint(this.glasspane, glassPanePoint, this.titlePane);
            return SwingUtilities.getDeepestComponentAt(this.titlePane, titlePanePoint.x, titlePanePoint.y);
        }

        private void redispatchMouseEvent(Component component, MouseEvent e, int id) {
            if (component != null) {
                Point componentPoint = SwingUtilities.convertPoint(this.glasspane, e.getPoint(), component);
                e = new MouseEvent(component, id, e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger());
                component.dispatchEvent(e);
            }
        }
    }

    public static class GlassPaneCustomizer {
        private final List<Supplier<Rectangle>> focusAreas = new ArrayList<Supplier<Rectangle>>();
        private final List<Consumer<Graphics2D>> customPainters = new ArrayList<Consumer<Graphics2D>>();
        private final List<Consumer<KeyEvent>> keyEventDispatchers = new ArrayList<Consumer<KeyEvent>>();

        public void addFocusArea(Supplier<Rectangle> focusArea) {
            this.focusAreas.add(focusArea);
        }

        public void addCustomPainter(Consumer<Graphics2D> customPainter) {
            this.customPainters.add(customPainter);
        }

        public void addKeyEventDispacther(Consumer<KeyEvent> keyEventDispatcher) {
            this.keyEventDispatchers.add(keyEventDispatcher);
        }
    }
}

