/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastURL {
    private final String _url;

    public FastURL(String url) {
        if (StringUtilities.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("URL may not be null or empty");
        }
        if (!url.contains(":/")) {
            url = "http://" + url;
        }
        this._url = url;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this._url);
    }

    public String toString() {
        return this._url;
    }

    public boolean equalsIgnoreCase(FastURL other) {
        if (other == null) {
            return false;
        }
        return this._url.equalsIgnoreCase(other._url);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FastURL other = (FastURL)obj;
        return !(this._url != null ? !this._url.equals(other._url) : other._url != null);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this._url != null ? this._url.hashCode() : 0);
        return hash;
    }

    public static boolean isFastURL(String resourceName) {
        boolean isFastUrl = false;
        if (resourceName != null) {
            try {
                resourceName = ImageUtils.removeBase64Prefix(resourceName);
                Pattern pattern = Pattern.compile("[:|.].*/");
                Matcher matcher = pattern.matcher(resourceName);
                isFastUrl = matcher.find();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isFastUrl;
    }
}

