/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.item;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.action.LicenseManagerAction;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.analytics.InstallHubItemEvent;
import com.paterva.maltego.seeds.ui.analytics.OpenHubItemDetailsEvent;
import com.paterva.maltego.seeds.ui.hub.HubSeedDetailsPanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedLeftPanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedListenerHoverAwarePanel;
import com.paterva.maltego.seeds.ui.hub.item.HubSeedRefreshCallback;
import com.paterva.maltego.seeds.ui.hub.item.custom.CustomSeedHelper;
import com.paterva.maltego.seeds.ui.hub.settings.HubSeedRequiredSettingsController;
import com.paterva.maltego.transform.finder.SeedDiscoveryManager;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.ui.FlatButton;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.MultiLineLabel;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class HubSeedHoverPanel
extends HubSeedListenerHoverAwarePanel {
    private static final Logger LOG = Logger.getLogger(HubSeedHoverPanel.class.getName());
    private static final ImageIcon IMG_DEL_NORMAL = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DeleteNormal.png", (boolean)true);
    private static final ImageIcon IMG_DEL_HOVER = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/seeds/ui/resources/DeleteHover.png", (boolean)true);
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final HubSeedDescriptor _seed;
    private final FlatButton _deleteButton;
    private final HubSeedRefreshCallback _cb;
    private Dimension _detailsButtonSize = new Dimension();
    private Dimension _refreshButtonSize = new Dimension();
    private JPanel _buttonPanel;
    private JPanel _buttonPanel2;
    private JPanel _deletePanel;
    private JLabel _descriptionLabel;
    private JButton _detailsButton;
    private JButton _installButton;
    private HubSeedLeftPanel _leftPanel;
    private JButton _refreshButton;
    private JPanel jPanel1;

    public HubSeedHoverPanel(HubSeedDescriptor seed, HubSeedRefreshCallback cb) {
        this._seed = seed;
        this.initComponents();
        if (this._seed != null) {
            boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
            this.updateBackground(installed);
        }
        Color buttonFg = DarculaButtonUI.getButtonColorHub();
        this._installButton.putClientProperty("inHubPanel", Boolean.TRUE);
        this._installButton.setForeground(buttonFg);
        this._detailsButton.putClientProperty("inHubPanel", Boolean.TRUE);
        this._detailsButton.setForeground(buttonFg);
        this._refreshButton.putClientProperty("inHubPanel", Boolean.TRUE);
        this._refreshButton.setForeground(buttonFg);
        this._deleteButton = new FlatButton((Icon)IMG_DEL_NORMAL, (Icon)IMG_DEL_HOVER);
        this._deleteButton.setBorder(null);
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = "Are you sure you want to remove the Transform Seed completely?";
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Remove");
                if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                    SeedDiscoveryManager.getDefault().uninstall(HubSeedHoverPanel.this._seed);
                    HubSeedSettings.getDefault().setInstalled(HubSeedHoverPanel.this._seed, false);
                    HubSeedRegistry.getDefault().removeSeed(HubSeedHoverPanel.this._seed, true);
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.weighty = 1.0;
        this._deletePanel.add((Component)this._deleteButton, gbc);
        this._detailsButtonSize = this._detailsButton.getPreferredSize();
        this._refreshButtonSize = this._refreshButton.getPreferredSize();
        this._cb = cb;
        if (this._seed != null) {
            this.update();
        }
    }

    @Override
    public HubSeedDescriptor getSeed() {
        return this._seed;
    }

    private void update() {
        this.updateInstall();
        this.updateDetails();
        this.updateRefresh();
        this.updateDelete();
        this.updateDescription();
    }

    private Font getFontScaled(String key) {
        return LAF.getFont(key);
    }

    private void updateDescription() {
        String details;
        String restriction = this._seed.getRestrictionReason();
        String string = details = restriction != null ? restriction : this._seed.getDetails();
        if (details == null) {
            details = "";
        } else if (HtmlUtils.containsHtmlLink((String)details)) {
            details = HtmlUtils.getPlainText((String)details);
        }
        this._descriptionLabel.setForeground(LAF.getColor("hub-item-description-hover-fg"));
        this._descriptionLabel.setFont(this.getFontScaled("hub-item-description-hover-font"));
        this._descriptionLabel.setText(details);
    }

    private void updateInstall() {
        boolean restricted = this._seed.getGrantedHubSeedUrls().isEmpty();
        boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
        this.updateBackground(installed);
        String text = "[UNINSTALL]";
        this._installButton.setVisible(!restricted);
        if (!installed) {
            text = "[INSTALL]";
        }
        this._installButton.setText(text);
        this._installButton.setToolTipText(this._seed.getRestrictionReason());
    }

    private void updateBackground(boolean installed) {
        String bgString = installed ? "hub-item-installed-bg" : "hub-item-bg";
        Color bg = LAF.getColor(bgString);
        this._installButton.putClientProperty("buttonBg", bgString);
        this._detailsButton.putClientProperty("buttonBg", bgString);
        this._refreshButton.putClientProperty("buttonBg", bgString);
        this._buttonPanel2.setBackground(bg);
        this.repaint();
    }

    private Dimension getMax(Dimension ... d) {
        Dimension returnSize = new Dimension(0, 0);
        for (Dimension d1 : d) {
            if (d1.width > returnSize.width) {
                returnSize.width = d1.width;
            }
            if (d1.height <= returnSize.height) continue;
            returnSize.height = d1.height;
        }
        return returnSize;
    }

    private void updateDetails() {
        this._detailsButton.setPreferredSize(this.getMax(this._installButton.getPreferredSize(), this._detailsButtonSize, this._refreshButtonSize));
    }

    private void updateRefresh() {
        boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
        this._refreshButton.setPreferredSize(this.getMax(this._installButton.getPreferredSize(), this._detailsButtonSize, this._refreshButtonSize));
        this._refreshButton.setVisible(installed);
    }

    private void updateDelete() {
        boolean isCustom = this._seed.isCustom();
        this._deletePanel.setVisible(isCustom);
        this._deleteButton.setVisible(isCustom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install() {
        String msg = "Are you sure you want to install " + this._seed.getDisplayName() + "?";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, "Install Transforms");
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            A licenseMode;
            InstallHubItemEvent.send(InstallHubItemEvent.Trigger.MALTEGO_DATA_HUB, this._seed);
            try {
                WindowUtil.showWaitCursor();
                licenseMode = LicenseManager.A().A(true);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
            String errorMessage = null;
            boolean showLicenseManager = false;
            if (licenseMode.B() && !licenseMode.P() || licenseMode.W() && !licenseMode.T()) {
                errorMessage = "The Maltego Data Hub item could not be installed because your license is invalid.";
                showLicenseManager = true;
            } else if (!this._seed.isCustom() && (licenseMode.B() || licenseMode.W()) && !licenseMode.O()) {
                errorMessage = "The Maltego Data Hub item could not be installed because the Maltego license server could not be reached.";
            } else if (licenseMode.D() || licenseMode.F()) {
                errorMessage = "Installing Tranform Hub items are not allowed in your current license mode.";
                showLicenseManager = true;
            } else if (this._seed.isCustom() && licenseMode.W() && !MaltegoIdProductRestrictions.allowInternalHubItem((A)licenseMode)) {
                errorMessage = "Installing Internal Tranform Hub items are not allowed in your current license mode.";
                showLicenseManager = true;
            }
            if (errorMessage != null) {
                LOG.log(Level.WARNING, errorMessage);
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)errorMessage);
                descriptor.setTitle("Failed");
                descriptor.setMessageType(0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (showLicenseManager) {
                    ((LicenseManagerAction)SystemAction.get(LicenseManagerAction.class)).actionPerformed(null);
                }
            } else if (this.requiredInputsPrompt()) {
                List transformSeeds = HubSeedRegistry.getDefault().getTransformSeeds(this._seed);
                HubSeedSettings.getDefault().setInstalled(this._seed, true);
                if (!SeedDiscoveryManager.getDefault().install(this._seed, transformSeeds)) {
                    HubSeedSettings.getDefault().setInstalled(this._seed, false);
                }
            }
        }
    }

    private boolean requiredInputsPrompt() {
        HubSeedRequiredSettingsController controller = new HubSeedRequiredSettingsController(this._seed);
        boolean hasRequired = controller.hasRequiredInputs();
        if (!hasRequired) {
            EditDialogDescriptor descriptor = new EditDialogDescriptor(this._seed.getDisplayName(), (WizardDescriptor.Panel)controller);
            hasRequired = NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor));
        }
        return hasRequired;
    }

    private void uninstall() {
        String msg = "Are you sure you want to uninstall " + this._seed.getDisplayName() + "?";
        String title = "Uninstall Transforms";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title);
        DialogDisplayer dialogDisplayer = DialogDisplayer.getDefault();
        if (NotifyDescriptor.OK_OPTION.equals(dialogDisplayer.notify((NotifyDescriptor)nd))) {
            SeedDiscoveryManager.getDefault().uninstall(this._seed);
            HubSeedSettings.getDefault().setInstalled(this._seed, false);
            msg = "Transforms uninstalled successfully.";
            nd = new NotifyDescriptor.Message((Object)msg);
            nd.setTitle(title);
            dialogDisplayer.notify((NotifyDescriptor)nd);
        }
    }

    @Override
    public void onSeedChanged() {
        this.update();
    }

    protected void onHoveredChanged() {
    }

    protected void onPanelClicked() {
        this._detailsButtonActionPerformed(null);
    }

    private void showDetailsDialog() {
        OpenHubItemDetailsEvent.send(this._seed.getName());
        this.showDialog(new HubSeedDetailsPanel(this._seed), "Transform Seed Details");
    }

    private void refreshSeed() {
        boolean updateInstalledSeed = false;
        for (HubSeedUrl grantedHubSeedUrl : this._seed.getGrantedHubSeedUrls()) {
            try {
                String accessToken = LicenseManager.A().H(grantedHubSeedUrl.getUrl());
                boolean showCertInstallWizard = CertificateUtils.mustShowWizard((String)grantedHubSeedUrl.getUrl(), (boolean)false, (boolean)true, (boolean)false, (String)accessToken);
                if (showCertInstallWizard) {
                    updateInstalledSeed = true;
                    continue;
                }
                updateInstalledSeed = false;
                break;
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Can't fetch certificate for hub seed.", ex);
                updateInstalledSeed = false;
            }
        }
        if (updateInstalledSeed) {
            SeedDiscoveryManager.getDefault().updateInstalledSeed(this._seed);
        }
    }

    private void showDialog(JComponent panel, String title) {
        Color borderBg = LAF.getColor(title);
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout(), borderBg);
        outerPanel.add(panel);
        JButton closeButton = new JButton("Close");
        closeButton.setBorderPainted(false);
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, title, true, (Object[])new JButton[]{closeButton}, (Object)closeButton, 0, HelpCtx.DEFAULT_HELP, null);
        dd.setBackground(borderBg);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setResizable(false);
        closeButton.requestFocusInWindow();
        dialog.setVisible(true);
    }

    private void showEditDialog() {
        CustomSeedHelper.editSeed(this._seed);
    }

    private void initComponents() {
        this._leftPanel = new HubSeedLeftPanel(this._seed);
        this._descriptionLabel = new MultiLineLabel();
        this._buttonPanel = new JPanel();
        this._buttonPanel2 = new JPanel();
        this._installButton = new JButton();
        this._detailsButton = new JButton();
        this._refreshButton = new JButton();
        this.jPanel1 = new JPanel();
        this._deletePanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 6, 5));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this._leftPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this._descriptionLabel, (String)NbBundle.getMessage(HubSeedHoverPanel.class, (String)"HubSeedHoverPanel._descriptionLabel.text"));
        this._descriptionLabel.setVerticalAlignment(1);
        this._descriptionLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 3));
        this._descriptionLabel.setMaximumSize(new Dimension(2000, 2000));
        this._descriptionLabel.setVerticalTextPosition(1);
        this._leftPanel.add((Component)this._descriptionLabel, "Center");
        this.add(this._leftPanel, "Center");
        this._buttonPanel.setOpaque(false);
        this._buttonPanel.setLayout(new BorderLayout());
        this._buttonPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        this._buttonPanel2.setOpaque(false);
        this._buttonPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this._installButton, (String)NbBundle.getMessage(HubSeedHoverPanel.class, (String)"HubSeedHoverPanel._installButton.text"));
        this._installButton.setHorizontalAlignment(4);
        this._installButton.setHorizontalTextPosition(4);
        this._installButton.setMargin(new Insets(1, 3, 1, 3));
        this._installButton.setMinimumSize(new Dimension(1, 1));
        this._installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubSeedHoverPanel.this._installButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this._buttonPanel2.add((Component)this._installButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._detailsButton, (String)NbBundle.getMessage(HubSeedHoverPanel.class, (String)"HubSeedHoverPanel._detailsButton.text"));
        this._detailsButton.setHorizontalAlignment(4);
        this._detailsButton.setHorizontalTextPosition(4);
        this._detailsButton.setMargin(new Insets(1, 3, 1, 3));
        this._detailsButton.setMinimumSize(new Dimension(1, 1));
        this._detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubSeedHoverPanel.this._detailsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this._buttonPanel2.add((Component)this._detailsButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._refreshButton, (String)NbBundle.getMessage(HubSeedHoverPanel.class, (String)"HubSeedHoverPanel._refreshButton.text"));
        this._refreshButton.setHorizontalAlignment(4);
        this._refreshButton.setHorizontalTextPosition(4);
        this._refreshButton.setMargin(new Insets(1, 3, 1, 3));
        this._refreshButton.setMinimumSize(new Dimension(1, 1));
        this._refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubSeedHoverPanel.this._refreshButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this._buttonPanel2.add((Component)this._refreshButton, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this._buttonPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this._buttonPanel.add((Component)this._buttonPanel2, "Center");
        this._deletePanel.setMinimumSize(new Dimension(1, 1));
        this._deletePanel.setOpaque(false);
        this._deletePanel.setLayout(new GridBagLayout());
        this._buttonPanel.add((Component)this._deletePanel, "East");
        this.add(this._buttonPanel, "East");
    }

    private void _detailsButtonActionPerformed(ActionEvent evt) {
        if (this._seed.isCustom()) {
            this.showEditDialog();
        } else {
            this.showDetailsDialog();
        }
    }

    private void _installButtonActionPerformed(ActionEvent evt) {
        boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
        if (installed) {
            this.uninstall();
        } else {
            boolean restricted = this._seed.getGrantedHubSeedUrls().isEmpty();
            if (restricted) {
                A licenseMode = LicenseManager.A().A(false);
                String licenseKey = licenseMode.B() ? LicenseManager.A().C() : null;
                String url = licenseMode.Q() ? MaltegoUrl.getCurrent().getGotoPurchase() : MaltegoUrl.getCurrent().getGotoUpgrade();
                BrowseToUrl.go((String)url, (String)"GatewayMaltegoID", (String)licenseKey, (!licenseMode.Q() ? 1 : 0) != 0);
                if (licenseMode.Q()) {
                    BrowseToUrl.buyPlan((String)licenseKey);
                } else {
                    BrowseToUrl.upgradePlan((String)licenseKey);
                }
                ProductSelectionAction.perform();
            } else {
                this.install();
            }
        }
    }

    private void _refreshButtonActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HubSeedHoverPanel.this._cb.started();
                    HubSeedHoverPanel.this.refreshSeed();
                }
                finally {
                    HubSeedHoverPanel.this._cb.completed();
                }
            }
        }, "Refresh Hub Item").start();
    }
}

