/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.localtx;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.descriptor.TransformServerRegistry;
import com.paterva.maltego.transform.manager.imex.localtx.LocalTransformConfig;
import com.paterva.maltego.transform.manager.imex.transforms.TransformDescriptorEntry;
import com.paterva.maltego.transform.manager.imex.transforms.TransformServerEntry;
import com.paterva.maltego.transform.manager.imex.transforms.TransformSettingsEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class LocalTransformExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        TransformServerInfo server = LocalTransformExporter.getLocalTransformServerInfo();
        if (server != null) {
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            Set transformNames = server.getTransforms();
            ArrayList<TransformDescriptor> transforms = new ArrayList<TransformDescriptor>();
            for (String transformName : transformNames) {
                TransformDefinition transform = registry.findTransform(transformName);
                if (transform == null) continue;
                transforms.add((TransformDescriptor)transform);
            }
            if (!transforms.isEmpty()) {
                return new LocalTransformConfig(server, transforms);
            }
        }
        return null;
    }

    static TransformServerInfo getLocalTransformServerInfo() {
        Collection servers = TransformServerRegistry.getDefault().getAll();
        for (TransformServerInfo server : servers) {
            if (!"Local".equals(server.getDefaultRepository())) continue;
            return server;
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        LocalTransformConfig transformConfig = (LocalTransformConfig)config;
        this.storeServerAndTransforms(writer, transformConfig);
        return ((TransformDescriptor[])transformConfig.getSelected()).length;
    }

    private void storeServerAndTransforms(MaltegoArchiveWriter writer, LocalTransformConfig config) throws IOException {
        TransformServerInfo server = config.getServer();
        if (((TransformDescriptor[])config.getSelected()).length > 0) {
            writer.write((Entry)new TransformServerEntry(server, server.getDisplayName()));
            this.storeTransforms(writer, config);
        }
    }

    private void storeTransforms(MaltegoArchiveWriter writer, LocalTransformConfig config) throws IOException {
        for (TransformDescriptor transform : (TransformDescriptor[])config.getSelected()) {
            if (!(transform instanceof TransformDefinition)) continue;
            TransformDefinition definition = (TransformDefinition)transform;
            writer.write((Entry)new TransformDescriptorEntry(definition));
            writer.write((Entry)new TransformSettingsEntry(definition));
        }
    }
}

