/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.util.HashMap;
import mslinks.Serializable;

public class HotKeyFlags
implements Serializable {
    private static HashMap<Byte, String> keys = new HashMap<Byte, String>(){
        private static final long serialVersionUID = -4817496808975584281L;
        {
            this.put((byte)48, "0");
            this.put((byte)49, "1");
            this.put((byte)50, "2");
            this.put((byte)51, "3");
            this.put((byte)52, "4");
            this.put((byte)53, "5");
            this.put((byte)54, "6");
            this.put((byte)55, "7");
            this.put((byte)56, "8");
            this.put((byte)57, "9");
            this.put((byte)65, "A");
            this.put((byte)66, "B");
            this.put((byte)67, "C");
            this.put((byte)68, "D");
            this.put((byte)69, "E");
            this.put((byte)70, "F");
            this.put((byte)71, "G");
            this.put((byte)72, "H");
            this.put((byte)73, "I");
            this.put((byte)74, "J");
            this.put((byte)75, "K");
            this.put((byte)76, "L");
            this.put((byte)77, "M");
            this.put((byte)78, "N");
            this.put((byte)79, "O");
            this.put((byte)80, "P");
            this.put((byte)81, "Q");
            this.put((byte)82, "R");
            this.put((byte)83, "S");
            this.put((byte)84, "T");
            this.put((byte)85, "U");
            this.put((byte)86, "V");
            this.put((byte)87, "W");
            this.put((byte)88, "X");
            this.put((byte)89, "Y");
            this.put((byte)90, "Z");
            this.put((byte)112, "F1");
            this.put((byte)113, "F2");
            this.put((byte)114, "F3");
            this.put((byte)115, "F4");
            this.put((byte)116, "F5");
            this.put((byte)117, "F6");
            this.put((byte)118, "F7");
            this.put((byte)119, "F8");
            this.put((byte)120, "F9");
            this.put((byte)121, "F10");
            this.put((byte)122, "F11");
            this.put((byte)123, "F12");
            this.put((byte)124, "F13");
            this.put((byte)125, "F14");
            this.put((byte)126, "F15");
            this.put((byte)127, "F16");
            this.put((byte)-128, "F17");
            this.put((byte)-127, "F18");
            this.put((byte)-126, "F19");
            this.put((byte)-125, "F20");
            this.put((byte)-124, "F21");
            this.put((byte)-123, "F22");
            this.put((byte)-122, "F23");
            this.put((byte)-121, "F24");
            this.put((byte)-112, "NUM LOCK");
            this.put((byte)-111, "SCROLL LOCK");
            this.put((byte)1, "SHIFT");
            this.put((byte)2, "CTRL");
            this.put((byte)4, "ALT");
        }
    };
    private static HashMap<String, Byte> keysr = new HashMap();
    private byte low;
    private byte high;

    public HotKeyFlags() {
        this.high = 0;
        this.low = 0;
    }

    public HotKeyFlags(ByteReader data) throws IOException {
        this.low = (byte)data.read();
        this.high = (byte)data.read();
    }

    public String getKey() {
        return keys.get(this.low);
    }

    public HotKeyFlags setKey(String k) {
        if (k != null && !k.equals("")) {
            this.low = keysr.get(k);
        }
        return this;
    }

    public boolean isShift() {
        return (this.high & 1) != 0;
    }

    public boolean isCtrl() {
        return (this.high & 2) != 0;
    }

    public boolean isAlt() {
        return (this.high & 4) != 0;
    }

    public HotKeyFlags setShift() {
        this.high = (byte)(1 | this.high & 6);
        return this;
    }

    public HotKeyFlags setCtrl() {
        this.high = (byte)(2 | this.high & 5);
        return this;
    }

    public HotKeyFlags setAlt() {
        this.high = (byte)(4 | this.high & 3);
        return this;
    }

    public HotKeyFlags clearShift() {
        this.high = (byte)(this.high & 6);
        return this;
    }

    public HotKeyFlags clearCtrl() {
        this.high = (byte)(this.high & 5);
        return this;
    }

    public HotKeyFlags clearAlt() {
        this.high = (byte)(this.high & 3);
        return this;
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        bw.write(this.low);
        bw.write(this.high);
    }

    static {
        for (Byte i : keys.keySet()) {
            keysr.put(keys.get(i), i);
        }
    }
}

