/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoriesLock;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformServerAuthentication;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.repository.FSTransformServerRegistry;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.XmlSerializationException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class LocalAwareServerRegistry
extends FSTransformServerRegistry {
    private static final String LOCAL = "maltego.LocalTAS.tas";
    private static TransformServerInfo _localTas;

    @Override
    protected TransformServerInfo load(FileObject file) throws FileNotFoundException, XmlSerializationException {
        if (LOCAL.equals(file.getNameExt())) {
            return this.localTas(super.load(file));
        }
        return super.load(file);
    }

    @Override
    protected void save(FileObject file, TransformServerInfo server) throws IOException {
        if (LOCAL.equals(file.getNameExt())) {
            super.save(file, new SaveProxy(server));
        } else {
            super.save(file, server);
        }
    }

    @Override
    protected boolean isLocal(FSTransformServerRegistry.TransformServerFile file) {
        return LOCAL.equals(file.getFile().getNameExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformServerInfo localTas(TransformServerInfo loaded) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (_localTas == null) {
                _localTas = new LocalTransformServerInfo(loaded);
            }
            return _localTas;
        }
    }

    private static class SaveProxy
    extends TransformServerInfo {
        private final TransformServerInfo server;

        public SaveProxy(TransformServerInfo server) {
            super("", server.getUrl(), server.getDisplayName());
            this.server = server;
        }

        public List<String> getSeedUrls() {
            return this.server.getSeedUrls();
        }

        public boolean isDirty() {
            return this.server.isDirty();
        }

        public void markClean() {
            this.server.markClean();
        }

        public String getDefaultRepository() {
            return this.server.getDefaultRepository();
        }

        public String getHelpUrl(TransformDefinition transform) {
            return this.server.getHelpUrl(transform);
        }

        public FastURL getUrl() {
            return this.server.getUrl();
        }

        public Date getLastSync() {
            return this.server.getLastSync();
        }

        public ProtocolVersion getProtocolVersion() {
            return this.server.getProtocolVersion();
        }

        public boolean isEnabled() {
            return this.server.isEnabled();
        }

        public String getDescription() {
            return this.server.getDescription();
        }

        public TransformServerAuthentication getAuthentication() {
            return this.server.getAuthentication();
        }

        public Status getStatus() {
            return this.server.getStatus();
        }

        public Set<String> getTransforms() {
            return Collections.emptySet();
        }
    }

    private static class LocalTransformServerInfo
    extends TransformServerInfo {
        public LocalTransformServerInfo(TransformServerInfo server) {
            super("", server.getUrl(), server.getDisplayName());
            this.setEnabled(server.isEnabled());
            this.setDescription(server.getDescription());
        }

        public TransformServerAuthentication getAuthentication() {
            return TransformServerAuthentication.None;
        }

        public Date getLastSync() {
            return new Date();
        }

        public ProtocolVersion getProtocolVersion() {
            return super.getProtocolVersion();
        }

        public String getDefaultRepository() {
            return "Local";
        }

        public Set<String> getTransforms() {
            HashSet<String> names = new HashSet<String>();
            try {
                TransformRepository local = TransformRepositoryRegistry.getDefault().getOrCreateRepository(this.getDefaultRepository());
                for (TransformDefinition def : local.getAll()) {
                    names.add(def.getName());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return names;
        }
    }
}

