/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.editing.form.FormLayout;
import com.paterva.maltego.typing.editing.form.GroupFactory;
import com.paterva.maltego.typing.editing.form.Input;
import com.paterva.maltego.typing.editing.form.InputPanelBuilder;
import com.paterva.maltego.typing.editing.form.PanelGroupFactory;
import com.paterva.maltego.typing.editing.form.VerticalFlowLayout;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;

class DefaultInputPanelBuilder
implements InputPanelBuilder {
    private boolean _showHiddenFields = false;
    private GroupDefinitions _groupDefs;
    private GroupFactory _factoryDelegate;
    private Map<String, Container> _groups;
    private Color _requiredFieldColor = Color.yellow;
    private boolean _showDescriptions = false;
    private boolean _useRequiredFieldColor = true;
    private Color _errorColor = UIManager.getLookAndFeelDefaults().getColor("7-red");
    private Container _previousDefault = null;
    private boolean _useErrorColor;
    private boolean _scrollable;
    private Border _border = BorderFactory.createEmptyBorder(10, 10, 0, 10);
    private LayoutManager _layoutManager = new VerticalFlowLayout(10);

    public DefaultInputPanelBuilder(GroupDefinitions groups, boolean scrollable) {
        this(groups, new PanelGroupFactory(), scrollable);
    }

    public DefaultInputPanelBuilder(GroupDefinitions groups, GroupFactory delegate, boolean scrollable) {
        this._groupDefs = groups;
        this._factoryDelegate = delegate;
        this._groups = new HashMap<String, Container>();
        this._scrollable = scrollable;
    }

    public void setBorder(Border border) {
        this._border = border;
    }

    public void setLayout(LayoutManager layoutManager) {
        this._layoutManager = layoutManager;
    }

    @Override
    public JPanel build(JPanel panel, Collection<Input> inputs) {
        JPanel innerPanel;
        if (!this._scrollable) {
            innerPanel = panel;
        } else {
            panel.setLayout(new BorderLayout());
            innerPanel = new JPanel();
            JScrollPane scrollPane = new JScrollPane(innerPanel);
            scrollPane.setBorder(null);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            panel.add(scrollPane);
        }
        innerPanel.setLayout(this._layoutManager);
        innerPanel.setBorder(this._border);
        FormLayout formLayout = new FormLayout(0, 6, 2);
        for (Input input : inputs) {
            if (input.isHidden() && !this._showHiddenFields) continue;
            Container group = this.createGroup(innerPanel, formLayout, input.getGroupName());
            group.setLayout(formLayout);
            group.add(this.createLabel(input));
            Component control = input.getEditingComponent();
            if (control instanceof JComponent) {
                JComponent component = (JComponent)control;
                component.setToolTipText(input.getDescription());
            }
            control.setEnabled(!input.isReadOnly());
            if (input.isRequired() && this._useRequiredFieldColor) {
                input.getAdapter().setBackgroundColor(control, this._requiredFieldColor);
            }
            input.getAdapter().setErrorColor(this.getErrorColor());
            input.getAdapter().setUseErrorColor(this.getUseErrorColor());
            group.add(control);
            if (!this._showDescriptions || input.getDescription() == null || input.getDescription().isEmpty()) continue;
            group.add(DefaultInputPanelBuilder.createDescriptionControl(input.getDescription()), FormLayout.FOOTER);
        }
        return panel;
    }

    private static Component createDescriptionControl(String description) {
        JLabel label = new JLabel(description);
        Font font = label.getFont();
        label.setForeground(new Color(153, 153, 153));
        label.setFont(font.deriveFont((float)font.getSize() - 2.0f));
        label.setOpaque(false);
        return label;
    }

    @Override
    public JPanel build(Collection<Input> inputs) {
        return this.build(new JPanel(), inputs);
    }

    private Container createGroup(Container parent, LayoutManager defaultLayout, String groupName) {
        if (StringUtilities.isNullOrEmpty((String)groupName)) {
            if (this._previousDefault == null) {
                this._previousDefault = this.createNewGroup(parent, defaultLayout, "");
            }
            return this._previousDefault;
        }
        Container set = this._groups.get(groupName);
        if (set == null) {
            set = this.createNewGroup(parent, defaultLayout, groupName);
            this._groups.put(groupName, set);
            this._previousDefault = null;
        }
        return set;
    }

    public Container createNewGroup(Container parent, LayoutManager defaultLayout, String groupName) {
        Container container;
        if (StringUtilities.isNullOrEmpty((String)groupName)) {
            container = this._factoryDelegate.createGroup("", "", "");
        } else {
            Group group = null;
            if (this._groupDefs != null) {
                group = this._groupDefs.getTopLevelGroups().get(groupName);
            }
            container = group == null ? this._factoryDelegate.createGroup(groupName, groupName, "") : this._factoryDelegate.createGroup(group.getName(), group.getDisplayName(), group.getDescription());
        }
        parent.add(container);
        container.setLayout(defaultLayout);
        return container;
    }

    private JLabel createLabel(Input input) {
        LabelWithBackground label = new LabelWithBackground();
        String mandatory = "";
        String colorPrefix = "";
        String colorSuffix = "";
        if (input.isRequired()) {
            mandatory = "<font color=\"#FF0000\">*</font> ";
        }
        if (input.getHighlight() == HighlightStyle.High) {
            colorPrefix = "<b>";
            colorSuffix = "</b>";
        }
        if (input.isHidden()) {
            colorPrefix = colorPrefix + "<font color=\"#808080\">";
            colorSuffix = "</font>" + colorSuffix;
        }
        label.setText("<html>" + mandatory + colorPrefix + input.getDisplayName() + colorSuffix + "</html>");
        return label;
    }

    public boolean showHiddenFields() {
        return this._showHiddenFields;
    }

    public void setShowHiddenFields(boolean showHiddenFields) {
        this._showHiddenFields = showHiddenFields;
    }

    public Color getRequiredFieldColor() {
        return this._requiredFieldColor;
    }

    public void setRequiredFieldColor(Color requiredFieldColor) {
        this._requiredFieldColor = requiredFieldColor;
    }

    public boolean showDescriptions() {
        return this._showDescriptions;
    }

    public void setShowDescriptions(boolean showDescriptions) {
        this._showDescriptions = showDescriptions;
    }

    public boolean useRequiredFieldColor() {
        return this._useRequiredFieldColor;
    }

    public void setUseRequiredFieldColor(boolean useRequiredFieldColor) {
        this._useRequiredFieldColor = useRequiredFieldColor;
    }

    public Color getErrorColor() {
        return this._errorColor;
    }

    public void setErrorColor(Color errorColor) {
        this._errorColor = errorColor;
    }

    public void setUseErrorColor(boolean setting) {
        this._useErrorColor = setting;
    }

    public boolean getUseErrorColor() {
        return this._useErrorColor;
    }
}

