/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.painter;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.structure.CollectionMods;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.painter.GraphAnimatorSettings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MainEntityPainterAnimatorRegistry {
    public static boolean allowModifications = true;
    private static MainEntityPainterAnimatorRegistry _default;
    private static final Map<GraphID, PropertyChangeListener> _structureListeners;

    protected MainEntityPainterAnimatorRegistry() {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosing".equals(evt.getPropertyName())) {
                    GraphID graphID = (GraphID)evt.getNewValue();
                    PropertyChangeListener listener = (PropertyChangeListener)_structureListeners.get(graphID);
                    if (listener != null) {
                        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                        if (view != null) {
                            view.getGraphStructureStore().removePropertyChangeListener(listener);
                        }
                        _structureListeners.remove(graphID);
                    }
                }
            }
        });
    }

    public static synchronized MainEntityPainterAnimatorRegistry getDefault() {
        if (_default == null) {
            _default = new MainEntityPainterAnimatorRegistry();
        }
        return _default;
    }

    public void register(final GraphID graphID) {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        if (view != null) {
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GraphAnimatorSettings settings;
                    GraphStructureMods mods;
                    if (allowModifications && (mods = (GraphStructureMods)evt.getNewValue()) != null && MaltegoGraphManager.exists((GraphID)graphID) && (settings = GraphAnimatorSettings.getDefault(graphID)) != null) {
                        Map<EntityID, AnimatorSettings> entityAnimatorSettingsMap = settings.getGraphAnimatorSettingsMap();
                        Set cmEntrySet = mods.getCollectionMods().entrySet();
                        Set entitiesAdded = mods.getEntitiesAdded();
                        for (Map.Entry entry : cmEntrySet) {
                            EntityID cn = (EntityID)entry.getKey();
                            entitiesAdded.remove(cn);
                            CollectionMods collectionMods = (CollectionMods)entry.getValue();
                            int changeCount = collectionMods.getEntitiesAdded() - collectionMods.getEntitiesRemoved();
                            int changeType = changeCount > 0 ? 0 : (changeCount < 0 ? 1 : 2);
                            if (entityAnimatorSettingsMap.containsKey(cn)) {
                                if (!entityAnimatorSettingsMap.get(cn).isAnimatorRunning()) {
                                    entityAnimatorSettingsMap.get(cn).restartAnimator(changeType);
                                    continue;
                                }
                                if (entityAnimatorSettingsMap.get(cn).getChangeType() == changeType) {
                                    entityAnimatorSettingsMap.get(cn).extendAnimator();
                                    continue;
                                }
                                entityAnimatorSettingsMap.get(cn).restartAnimator(changeType);
                                continue;
                            }
                            entityAnimatorSettingsMap.put(cn, new AnimatorSettings(graphID, cn, changeType));
                        }
                        for (EntityID entityID : entitiesAdded) {
                            if (entityAnimatorSettingsMap.containsKey(entityID)) {
                                if (!entityAnimatorSettingsMap.get(entityID).isAnimatorRunning()) {
                                    entityAnimatorSettingsMap.get(entityID).restartAnimator(0);
                                    continue;
                                }
                                entityAnimatorSettingsMap.get(entityID).extendAnimator();
                                continue;
                            }
                            entityAnimatorSettingsMap.put(entityID, new AnimatorSettings(graphID, entityID, 0));
                        }
                        Set entitiesRemoved = mods.getEntitiesRemoved();
                        for (EntityID entityID : entitiesRemoved) {
                            if (!entityAnimatorSettingsMap.containsKey(entityID)) continue;
                            entityAnimatorSettingsMap.get(entityID).stopAnimator();
                            entityAnimatorSettingsMap.remove(entityID);
                        }
                        if (!entityAnimatorSettingsMap.isEmpty() && !GraphAnimatorSettings.getDefault(graphID).isTimerRunning()) {
                            GraphAnimatorSettings.getDefault(graphID).restartTimer();
                        }
                    }
                }
            };
            view.getGraphStructureStore().addPropertyChangeListener(listener);
        }
    }

    static {
        _structureListeners = new HashMap<GraphID, PropertyChangeListener>();
    }

    public class AnimatorSettings {
        public static final int COUNT_INCREASED = 0;
        public static final int COUNT_DECREASED = 1;
        public static final int COUNT_UNCHANGED = 2;
        private long _startMillis = System.currentTimeMillis();
        private long _endMillis = this._startMillis + 650L;
        private boolean _isRunning = true;
        private int _changeType;

        public AnimatorSettings(GraphID graphID, EntityID entityID, int changeType) {
            this._changeType = changeType;
        }

        public void restartAnimator(int changeType) {
            this.stopAnimator();
            this._startMillis = System.currentTimeMillis();
            this._endMillis = this._startMillis + 650L;
            this._isRunning = true;
            this._changeType = changeType;
        }

        public void stopAnimator() {
            this._isRunning = false;
        }

        public void extendAnimator() {
            this._endMillis = System.currentTimeMillis() + 650L;
        }

        public int getChangeType() {
            return this._changeType;
        }

        public long getStartMillis() {
            return this._startMillis;
        }

        public long getEndMillis() {
            return this._endMillis;
        }

        public boolean isAnimatorRunning() {
            return this._isRunning;
        }
    }
}

