/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.DataProviders;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import yguard.A.A.D;
import yguard.A.A.K;

public class ViewGraphName {
    private static final String VIEW_NAME_KEY = "maltego.ViewGraphName";

    private ViewGraphName() {
    }

    public static synchronized String get(GraphID graphID) {
        D graph = MaltegoGraphManager.getWrapper((GraphID)graphID).getGraph();
        return ViewGraphName.get(graph);
    }

    public static synchronized String get(D viewGraph) {
        DataProviders.Singleton dataProvider = (DataProviders.Singleton)viewGraph.B((Object)VIEW_NAME_KEY);
        String name = dataProvider != null ? (String)dataProvider.get() : null;
        return name;
    }

    public static synchronized void set(D viewGraph, String name) {
        DataProviders.Singleton dataProvider = new DataProviders.Singleton((Object)name);
        viewGraph.A((Object)VIEW_NAME_KEY, (K)dataProvider);
    }

    public static synchronized Map<String, D> getForModelGraph(D modelGraph) {
        Set<D> viewGraphs = Collections.singleton(modelGraph);
        return ViewGraphName.get(viewGraphs);
    }

    public static synchronized Map<String, D> get(Collection<D> viewGraphs) {
        HashMap<String, D> viewNames = new HashMap<String, D>();
        if (viewGraphs != null) {
            for (D viewGraph : viewGraphs) {
                String viewName = ViewGraphName.get(viewGraph);
                if (viewName == null) continue;
                viewNames.put(viewName, viewGraph);
            }
        }
        return viewNames;
    }
}

