/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.CloudGraphRegistry;
import com.maltego.cloud.serializer.NeoJsonReader;
import com.maltego.cloud.ui.open.CloudGraphOpenAction;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.util.FileExtensionFileFilter;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.WindowUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.IOUtils;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class TestOpenFromCloudAction
extends SystemAction {
    private static final Logger LOG = Logger.getLogger(TestOpenFromCloudAction.class.getName());
    private final CloudAuth cloudAuth = CloudAuth.getDefault();

    public TestOpenFromCloudAction() {
        LicenseManager.A().A(ignored -> this.updateVisible());
        this.updateVisible();
    }

    private void updateVisible() {
        this.putValue("visible", this.cloudAuth.isCloudAuthEnabled() && (Version.getCurrent().isDevBuild() || Version.getCurrent().isQaBuild()));
    }

    public String getName() {
        return "Test open Cloud Graph(s) JSON via disk";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        FileChooserBuilder chooserBuilder = new FileChooserBuilder(Integer.class).setTitle("Open cloud graph file");
        chooserBuilder.setFileFilter((FileFilter)new FileExtensionFileFilter(new String[]{"json"}, "Cloud graph JSON"));
        JFileChooser chooser = chooserBuilder.createFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int result = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (0 == result) {
            File[] selectedFiles = chooser.getSelectedFiles();
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            for (int i = 0; i < selectedFiles.length; ++i) {
                File file = selectedFiles[i];
                int delaySeconds = i * 15;
                scheduler.schedule(() -> {
                    GraphID maltegoGraphID = GraphID.create();
                    try {
                        LOG.log(Level.INFO, "Opening file: {0}", file.getAbsolutePath());
                        byte[] bytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
                        String testGraphJson = new String(bytes);
                        NeoJsonReader reader = new NeoJsonReader(maltegoGraphID, null, false, null);
                        reader.readFromString(testGraphJson);
                        SwingUtilities.invokeLater(() -> {
                            try {
                                WindowUtil.showWaitCursor();
                                this.openGraph(reader);
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            finally {
                                WindowUtil.hideWaitCursor();
                            }
                        });
                    }
                    catch (IOException ex) {
                        try {
                            this.closeGraphStore(maltegoGraphID);
                        }
                        catch (GraphStoreException ex1) {
                            Exceptions.printStackTrace((Throwable)ex1);
                        }
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (Exception ex) {
                        try {
                            this.closeGraphStore(maltegoGraphID);
                        }
                        catch (GraphStoreException ex1) {
                            Exceptions.printStackTrace((Throwable)ex1);
                        }
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, (long)delaySeconds, TimeUnit.SECONDS);
            }
        }
    }

    private String getTestGraphJson() throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("L1-footprint.json"), (String)"UTF-8");
    }

    private void closeGraphStore(GraphID maltegoGraphID) throws GraphStoreException {
        GraphLifeCycleManager.getDefault().fireGraphClosing(maltegoGraphID);
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(maltegoGraphID);
            if (graphStore != null && graphStore.isOpen()) {
                graphStore.close(true);
                GraphLifeCycleManager.getDefault().fireGraphClosed(maltegoGraphID);
            }
        }
        catch (GraphStoreException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
    }

    private void openGraph(NeoJsonReader reader) {
        GraphID maltegoGraphID = reader.getMaltegoGraphID();
        GraphID cloudGraphID = reader.getCloudGraphID();
        String graphName = reader.getGraphName();
        CloudGraphOpenAction openAction = (CloudGraphOpenAction)SystemAction.get(CloudGraphOpenAction.class);
        openAction.setGraph(maltegoGraphID, graphName);
        openAction.performAction();
        CloudGraph cloudgraph = new CloudGraph(maltegoGraphID, cloudGraphID, reader.getCloudGraphVersion(), graphName, Boolean.valueOf(reader.isEditable()), null, reader.getContentMetadata());
        if (maltegoGraphID.equals((Object)cloudGraphID)) {
            CloudGraphRegistry.getDefault().addCloudGraph(cloudGraphID, cloudgraph);
            RecentCloudGraphs.getDefault().addCloudGraph(cloudGraphID.toString(), graphName);
        } else {
            CloudGraphRegistry.getDefault().addVersionOfCloudGraph(maltegoGraphID, cloudgraph);
        }
    }
}

