/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.ToolboxItemSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MaltegoPartSpec<ID extends Guid, T extends MaltegoPart<ID>>
extends ToolboxItemSpec<T> {
    private String pluralName;
    private List<SpecActionDescriptor> actions;

    public MaltegoPartSpec() {
    }

    public MaltegoPartSpec(String name, DisplayDescriptorCollection properties) {
        super(name, properties);
    }

    public MaltegoPartSpec(String name, DisplayDescriptorCollection properties, GroupDefinitions groups) {
        super(name, properties, groups);
    }

    public MaltegoPartSpec(String name, PropertyConfiguration properties) {
        super(name, properties);
    }

    public MaltegoPartSpec(MaltegoPartSpec<ID, T> other) {
        super(other);
        this.pluralName = other.getDisplayNamePlural();
        if (other.getActions() != null) {
            this.actions = new ArrayList<SpecActionDescriptor>(other.getActions());
        }
    }

    public boolean isCopy(Object obj) {
        List<SpecActionDescriptor> otherActions;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaltegoPartSpec)) {
            return false;
        }
        MaltegoPartSpec other = (MaltegoPartSpec)((Object)obj);
        if (!this.getDisplayNamePlural().equals(other.getDisplayNamePlural())) {
            return false;
        }
        List<SpecActionDescriptor> actions = this.getActions();
        if (actions != (otherActions = other.getActions())) {
            if (actions == null || otherActions == null) {
                return false;
            }
            if (actions.size() != otherActions.size()) {
                return false;
            }
            if (!actions.containsAll(otherActions) || !otherActions.containsAll(actions)) {
                return false;
            }
        }
        return super.isCopy((Object)other);
    }

    public String getDisplayNamePlural() {
        if (this.pluralName == null) {
            if (this.getDisplayName().endsWith("s")) {
                return this.getDisplayName() + "es";
            }
            return this.getDisplayName() + "s";
        }
        return this.pluralName;
    }

    public void setDisplayNamePlural(String name) {
        this.pluralName = name;
    }

    public List<String> getBaseEntitySpecs() {
        return new ArrayList<String>();
    }

    public void setActions(List<SpecActionDescriptor> actions) {
        this.actions = actions;
    }

    public List<SpecActionDescriptor> getActions() {
        if (this.actions != null) {
            return Collections.unmodifiableList(this.actions);
        }
        return null;
    }
}

