/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.FilterHelper;
import com.pinkmatter.pandora.lucene.serialize.PrimitiveTypeConverter;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public abstract class NumericTypeConverter<T>
extends PrimitiveTypeConverter<T> {
    private final SortField.Type _sortFieldType;

    public NumericTypeConverter(String typeName, Class<? extends T> clazz, Class primitiveClass, SortField.Type sortFieldType) {
        super(typeName, clazz, primitiveClass);
        this._sortFieldType = sortFieldType;
    }

    @Override
    protected void writeImpl(T value, String field, Document to) throws PandoraException {
        String fieldName = this.getIndexField(field);
        IndexableField valueField = this.createNumberField(value, fieldName);
        to.add(valueField);
        SortedNumericDocValuesField sortField = new SortedNumericDocValuesField(fieldName, this.toSortableLong(value));
        to.add((IndexableField)sortField);
    }

    @Override
    protected T readImpl(IndexableField field) throws PandoraException {
        return this.toType(field.numericValue());
    }

    abstract T toType(Number var1);

    abstract IndexableField createNumberField(T var1, String var2);

    abstract long toSortableLong(T var1);

    @Override
    public SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        String fieldName = this.getIndexField(property);
        SortedNumericSortField sortField = new SortedNumericSortField(fieldName, this._sortFieldType, reverse, reverse ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN);
        if (reverse ^ emptyFirst) {
            sortField.setMissingValue(this.getMinSortField());
        } else {
            sortField.setMissingValue(this.getMaxSortField());
        }
        return new SortField[]{sortField};
    }

    protected abstract T getMinSortField();

    protected abstract T getMaxSortField();

    protected static IndexableField createDocValueField(String fieldName, long value) {
        return new SortedNumericDocValuesField(fieldName, value);
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        String field = this.getIndexField(parameters.getProperty());
        return FilterHelper.createSimpleQuery(field, this.getClassType(), parameters);
    }

    @Override
    protected boolean isFilterTermsSupported() {
        return true;
    }

    @Override
    protected BytesRef createFilterTerm(T value) {
        BytesRefBuilder builder = new BytesRefBuilder();
        NumericUtils.longToPrefixCoded((long)this.toSortableLong(value), (int)0, (BytesRefBuilder)builder);
        return builder.get();
    }
}

