/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;

public class ExportTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[26];
    int rowLimit = -1;
    GraphTableBuilder tableBuilder;

    public void setTableBuilder(GraphTableBuilder tableBuilder) {
        if (!tableBuilder.isBuilt()) {
            try {
                tableBuilder.build();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        boolean structureChanged = this.tableBuilder != tableBuilder;
        this.tableBuilder = tableBuilder;
        if (structureChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        Stream rowStream = this.tableBuilder.getTable().stream();
        if (this.rowLimit > 0) {
            rowStream = rowStream.limit(this.rowLimit);
        }
        return (int)rowStream.count();
    }

    @Override
    public int getColumnCount() {
        Stream rowStream = this.tableBuilder.getTable().stream();
        if (this.rowLimit > 0) {
            rowStream = rowStream.limit(this.rowLimit);
        }
        int columnns = rowStream.max(Comparator.comparing(List::size)).orElse(Collections.emptyList()).size();
        return columnns;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = columnNames[columnIndex % columnNames.length];
        columnIndex -= columnIndex % columnNames.length;
        columnIndex /= columnNames.length;
        --columnIndex;
        while (columnIndex >= 0) {
            name = columnNames[columnIndex % columnNames.length] + name;
            columnIndex -= columnIndex % columnNames.length;
            columnIndex /= columnNames.length;
            --columnIndex;
        }
        return name;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List row = (List)this.tableBuilder.getTable().get(rowIndex);
        if (columnIndex >= row.size()) {
            return null;
        }
        return row.get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    static {
        char name = 'A';
        int index = 0;
        while (index < columnNames.length) {
            ExportTableModel.columnNames[index] = Character.toString(name);
            ++index;
            name = (char)(name + '\u0001');
        }
    }
}

