/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws;

import com.paterva.maltego.pws.ServiceIconProvider;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.pws.oauth.OAuthWebService;
import java.awt.Image;
import java.io.IOException;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.Exceptions;

public abstract class AccountTableModel
extends AbstractTableModel {
    private static final String[] COLUMNS = new String[]{"", "Service", "Description", "Callback Protocol", "Callback Port"};
    public static final int COLUMN_ICON = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_CB_PROTOCOL = 3;
    public static final int COLUMN_CB_PORT = 4;
    public static final int COLUMN_SIGN_IN_BUTTON = 5;

    protected abstract List<PublicWebService> getServices();

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Image.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 3 || column == 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PublicWebService pws = this.getService(rowIndex);
        if (pws != null) {
            switch (columnIndex) {
                case 0: {
                    return ServiceIconProvider.getIcon(pws).getImage();
                }
                case 1: {
                    return pws.getDisplayName();
                }
                case 2: {
                    return pws.getDescription();
                }
                case 3: {
                    String protocol = "n/a";
                    if (pws instanceof OAuthWebService) {
                        OAuthWebService oauth = (OAuthWebService)pws;
                        protocol = oauth.getAuthenticator().useSSLHost() ? "https" : "http";
                    }
                    return protocol;
                }
                case 4: {
                    Integer port = null;
                    if (pws instanceof OAuthWebService) {
                        OAuthWebService oauth = (OAuthWebService)pws;
                        port = oauth.getAuthenticator().getCallbackPort();
                    }
                    return port == null ? "random" : Integer.toString(port);
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        PublicWebService pws = this.getService(rowIndex);
        if (pws != null) {
            super.setValueAt(value, rowIndex, columnIndex);
            if (pws instanceof OAuthWebService) {
                OAuthWebService service = (OAuthWebService)pws;
                switch (columnIndex) {
                    case 3: {
                        boolean useSSL = "https".equals((String)value);
                        service = service.setUseSSLHost(useSSL);
                        break;
                    }
                    case 4: {
                        Integer port = (Integer)value;
                        if (port < 0) {
                            port = null;
                        }
                        service = service.setCallbackPort(port);
                    }
                }
                try {
                    PublicWebServices.getDefault().replace("OAuth", service.getName(), (PublicWebService)service);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public PublicWebService getService(int rowIndex) {
        try {
            return this.getServices().get(rowIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void update(PublicWebService service, int col) {
        List<PublicWebService> services = this.getServices();
        int row = 0;
        for (PublicWebService pws : services) {
            if (pws.equals((Object)service)) {
                this.fireTableCellUpdated(row, col);
                break;
            }
            ++row;
        }
    }
}

