/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineException;
import com.paterva.maltego.automation.runtime.MachineValidationException;
import com.paterva.maltego.automation.view.startup.MachineErrorHandler;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GotoUrl;
import com.paterva.maltego.util.ui.LinkLabel;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DialgoMachineErrorHandler
extends MachineErrorHandler {
    @Override
    public void error(MachineDescriptor machine, MachineException ex) {
        String machineHelpUrl;
        int extraRows = 1;
        String machineInfo = this.getMachineInfo(machine);
        if (!StringUtilities.isNullOrEmpty((String)machineInfo)) {
            extraRows += 2;
        }
        if (!StringUtilities.isNullOrEmpty((String)(machineHelpUrl = this.getMachineHelpUrl(machine)))) {
            extraRows += 3;
        }
        JPanel panel = new JPanel(new GridLayout(ex.getErrors().length + extraRows, 1));
        this.addMachineInfo(machineInfo, panel);
        panel.add(new JLabel("The following errors are preventing the machine from starting:"));
        for (String s : ex.getErrors()) {
            JLabel error = new JLabel(String.format("   - %s", s));
            if (s != null && s.isEmpty()) {
                error = new JLabel("");
            }
            error.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-red"));
            panel.add(error);
        }
        this.addMachineLink(machineHelpUrl, panel);
        NotifyDescriptor nd = new NotifyDescriptor((Object)panel, "Unable to start machine", -1, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notify(nd);
    }

    @Override
    public boolean warn(MachineDescriptor machine, MachineValidationException ex) {
        String machineHelpUrl;
        int extraRows = 4;
        String machineInfo = this.getMachineInfo(machine);
        if (!StringUtilities.isNullOrEmpty((String)machineInfo)) {
            extraRows += 2;
        }
        if (!StringUtilities.isNullOrEmpty((String)(machineHelpUrl = this.getMachineHelpUrl(machine)))) {
            extraRows += 3;
        }
        JPanel panel = new JPanel(new GridLayout(ex.getErrors().length + extraRows, 1));
        this.addMachineInfo(machineInfo, panel);
        panel.add(new JLabel("The following potential problems exist in the machine:"));
        for (String s : ex.getErrors()) {
            JLabel error = new JLabel(String.format("   - %s", s));
            if (s != null && s.isEmpty()) {
                error = new JLabel("");
            }
            error.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-red"));
            panel.add(error);
        }
        this.addMachineLink(machineHelpUrl, panel);
        panel.add(new JLabel(" "));
        panel.add(new JLabel("The machine might still run and retrieve some results."));
        panel.add(new JLabel("Would you like to try and run the machine in any case?"));
        NotifyDescriptor nd = new NotifyDescriptor((Object)panel, "Potential errors in machine", 1, 2, null, NotifyDescriptor.YES_OPTION);
        return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.YES_OPTION;
    }

    private String getMachineInfo(MachineDescriptor machine) {
        return machine == null ? null : machine.getDisplayName() + " [" + machine.getName() + "]";
    }

    private String getMachineHelpUrl(MachineDescriptor machine) {
        return machine == null ? null : machine.getHelpUrl();
    }

    private void addMachineInfo(String machineInfo, JPanel panel) {
        if (!StringUtilities.isNullOrEmpty((String)machineInfo)) {
            panel.add(new JLabel("Machine: " + machineInfo));
            panel.add(new JLabel(" "));
        }
    }

    private void addMachineLink(String machineHelpUrl, JPanel panel) {
        if (!StringUtilities.isNullOrEmpty((String)machineHelpUrl)) {
            panel.add(new JLabel(" "));
            panel.add(new JLabel("Make sure the required Maltego Data Hub items are installed for this machine. Find further info at:"));
            LinkLabel hubInfoLinkLabel = new LinkLabel();
            hubInfoLinkLabel.setText(machineHelpUrl);
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            hubInfoLinkLabel.setForeground(laf.getColor("Link.foreground"));
            hubInfoLinkLabel.setHighlightColor(laf.getColor("link-highlight-fg"));
            hubInfoLinkLabel.addActionListener(e -> GotoUrl.show((String)hubInfoLinkLabel.getText()));
            panel.add((Component)hubInfoLinkLabel);
        }
    }
}

