/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.runtime;

import com.paterva.maltego.automation.runtime.Automaton;
import com.paterva.maltego.automation.runtime.AutomatonListener;
import com.paterva.maltego.automation.runtime.State;
import java.util.LinkedList;

abstract class StateSupport
implements Automaton {
    private State _state = State.Idle;
    private LinkedList<AutomatonListener> _listeners;

    StateSupport() {
    }

    protected synchronized void setState(State newState) {
        if (this._state != newState) {
            State oldState = this._state;
            this._state = newState;
            this.fireStateChange(oldState, newState);
        }
    }

    @Override
    public boolean isReady() {
        return this.getState() == State.Ready;
    }

    @Override
    public boolean isBusy() {
        return this.getState() == State.Busy;
    }

    @Override
    public boolean isCompleted() {
        return this.getState() == State.Completed;
    }

    @Override
    public boolean isDone() {
        return this.isFailed() || this.isCompleted();
    }

    @Override
    public boolean isFailed() {
        return this.getState() == State.Failed;
    }

    @Override
    public State getState() {
        return this._state;
    }

    @Override
    public synchronized void addAutomatonListener(AutomatonListener listener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(listener);
    }

    @Override
    public synchronized void removeAutomatonListener(AutomatonListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
            if (this._listeners.isEmpty()) {
                this._listeners = null;
            }
        }
    }

    protected void fireStateChange(State oldState, State newState) {
        if (this._listeners != null) {
            for (AutomatonListener l : this._listeners) {
                l.stateChanged(this, oldState, newState);
            }
        }
    }
}

