/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.manager.forms.MainPropertyForm;
import com.paterva.maltego.entity.manager.forms.PropertyTypes;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class MainPropertyFormController
extends DataEditController<MainPropertyForm, MaltegoEntitySpec>
implements WizardDescriptor.FinishablePanel {
    public MainPropertyFormController() {
        super("entitySpec");
        this.setName("Main Property");
        this.setDescription("Enter the main property details of the new entity in the fields below. By default the main property is displayed in the graph view (this can be changed later at Manage Entities > [...] > Display Settings).");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/entity/manager/resources/AddEntity.png".replace(".png", "48.png")));
    }

    protected String getFirstError(MainPropertyForm component) {
        if (component.isCreateCustomProperty()) {
            String name = component.getDisplayName();
            if (name.trim().length() == 0) {
                return "Display name is required";
            }
            String id = component.getUniqueName();
            if ((id = id.trim()).length() == 0) {
                return "Unique type name is required";
            }
            String error = TypeNameValidator.checkName((String)id);
            if (error != null) {
                return error;
            }
            if (component.getDataType() == null) {
                return "Data type is required";
            }
            if (component.isSampleValueEmpty()) {
                return "Sample value is required";
            }
        }
        return null;
    }

    protected MainPropertyForm createComponent() {
        final MainPropertyForm f = new MainPropertyForm();
        f.addChangeListener(this.changeListener());
        f.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String id;
                if (!MainPropertyFormController.this.isEditMode() && (id = f.getUniqueName()).trim().length() == 0) {
                    f.setUniqueName(MainPropertyFormController.this.createID(f.getDisplayName()));
                }
            }
        });
        return f;
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty("editMode") == Boolean.TRUE;
    }

    private String createID(String displayName) {
        displayName = displayName.replaceAll(" ", "");
        displayName = displayName.toLowerCase();
        return "properties." + displayName;
    }

    protected void setData(MainPropertyForm component, MaltegoEntitySpec data) {
        component.setDataTypes(new Vector<TypeDescriptor>(PropertyTypes.valueTypes));
        List<MaltegoEntitySpec> inheritedSpecs = this.getInheritedSpecs(data);
        component.setInheritPropertyEnabled(!inheritedSpecs.isEmpty());
        Boolean inheritMainProperty = (Boolean)this.getDescriptor().getProperty("inheritMainProperty");
        if (inheritMainProperty == null) {
            inheritMainProperty = !inheritedSpecs.isEmpty();
        } else if (inheritedSpecs.isEmpty()) {
            inheritMainProperty = Boolean.FALSE;
        }
        component.setCreateCustomProperty(inheritMainProperty == false);
        DisplayDescriptor mainDescriptor = (DisplayDescriptor)this.getDescriptor().getProperty("mainProperty");
        if (mainDescriptor != null) {
            this.setData(component, mainDescriptor);
        } else {
            component.setDisplayName(data.getDisplayName());
            component.setDataType(TypeRegistry.getDefault().getType(String.class));
            component.setSampleValue("-");
            component.setDefaultValue("");
        }
    }

    private void setData(MainPropertyForm component, DisplayDescriptor descriptor) {
        component.setDataType(descriptor.getTypeDescriptor());
        component.setSampleValue(descriptor.getSampleValue());
        component.setDefaultValue(descriptor.getDefaultValue());
        component.setDisplayName(descriptor.getDisplayName());
        component.setDescription(descriptor.getDescription());
        component.setUniqueName(descriptor.getName());
    }

    private List<MaltegoEntitySpec> getInheritedSpecs(MaltegoEntitySpec data) {
        HashSet<MaltegoEntitySpec> inheritedSpecs = new HashSet<MaltegoEntitySpec>();
        EntityRegistry registry = (EntityRegistry)this.getDescriptor().getProperty("entityRegistry");
        Set<MaltegoEntitySpec> baseSpecs = this.getValidVisibleSpecs(registry, data.getBaseEntitySpecs());
        for (MaltegoEntitySpec spec : baseSpecs) {
            List specNames = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)spec.getTypeName());
            Set<MaltegoEntitySpec> validVisibleSpecs = this.getValidVisibleSpecs(registry, specNames);
            inheritedSpecs.addAll(validVisibleSpecs);
        }
        ArrayList<MaltegoEntitySpec> sortedSpecs = new ArrayList<MaltegoEntitySpec>(inheritedSpecs);
        Collections.sort(sortedSpecs, new TypeSpecDisplayNameComparator());
        return sortedSpecs;
    }

    private Set<MaltegoEntitySpec> getValidVisibleSpecs(EntityRegistry registry, List<String> specNames) {
        HashSet<MaltegoEntitySpec> specs = new HashSet<MaltegoEntitySpec>();
        for (String specName : specNames) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(specName);
            if (spec == null || !spec.isVisible()) continue;
            specs.add(spec);
        }
        return specs;
    }

    protected void updateData(MainPropertyForm component, MaltegoEntitySpec data) {
        DisplayDescriptorCollection dataProperties = data.getProperties();
        DisplayDescriptor mainDescriptor = null;
        if (component.getDataType() != null) {
            mainDescriptor = MainPropertyFormController.createProperty(component.getUniqueName(), component.getDataType());
            mainDescriptor.setDisplayName(component.getDisplayName());
            mainDescriptor.setDescription(component.getDescription());
            mainDescriptor.setSampleValue(component.getSampleValue());
            mainDescriptor.setDefaultValue(component.getDefaultValue());
        }
        this.getDescriptor().putProperty("mainProperty", mainDescriptor);
        this.getDescriptor().putProperty("inheritMainProperty", (Object)(!component.isCreateCustomProperty() ? 1 : 0));
        if (component.isCreateCustomProperty() && mainDescriptor != null) {
            if (dataProperties.isEmpty()) {
                dataProperties.add(mainDescriptor);
            } else {
                dataProperties.set(0, (Object)mainDescriptor);
            }
            data.setValueProperty(mainDescriptor);
        }
    }

    private static DisplayDescriptor createProperty(String name, TypeDescriptor type) {
        DisplayDescriptor descriptor = new DisplayDescriptor(type.getType(), name);
        return descriptor;
    }

    public boolean isFinishPanel() {
        return true;
    }

    private boolean checkChars(String id) {
        for (char c : id.toCharArray()) {
            if (Character.isLetter(c) || c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

