/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular;

import com.paterva.maltego.transform.gen.TransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.serialization.TabularTransformSerializer;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.repository.FilesystemRepository;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;

public class TabularTransformSourceRepository
extends FilesystemRepository<TabularTransformSource>
implements TransformSourceRepository<TabularTransformSource> {
    private static final Logger LOG = Logger.getLogger(TabularTransformSourceRepository.class.getName());
    private static final String FOLDER = "Maltego/TransformSource/Tabular";
    private static final String EXT = "tabds";
    private static TabularTransformSourceRepository INSTANCE;

    public TabularTransformSourceRepository() {
        super(FOLDER, EXT);
        this.setInstance();
    }

    public static TabularTransformSourceRepository getInstance() {
        return INSTANCE;
    }

    private void setInstance() {
        INSTANCE = this;
    }

    public String getName(TabularTransformSource item) {
        Args.notNull((Object)((Object)item), (String)"item");
        return item.getName();
    }

    public String getDisplayName(TabularTransformSource item) {
        Args.notNull((Object)((Object)item), (String)"item");
        return item.getDisplayName();
    }

    protected void save(TabularTransformSource txSource, FileObject file) throws Exception {
        Args.notNull((Object)((Object)txSource), (String)"txSource");
        Args.notNull((Object)file, (String)"file");
        TabularTransformSerializer serializer = new TabularTransformSerializer();
        try (OutputStream os = file.getOutputStream();){
            serializer.write(txSource, os);
        }
        if (LOG.isLoggable(Level.FINE)) {
            os = new ByteArrayOutputStream();
            serializer.write(txSource, os);
            LOG.log(Level.FINE, "Saved Tabular Transform:\n{0}", ((ByteArrayOutputStream)os).toString(StandardCharsets.UTF_8.name()));
        }
    }

    protected TabularTransformSource load(FileObject file) throws Exception {
        Args.notNull((Object)file, (String)"file");
        TabularTransformSerializer serializer = new TabularTransformSerializer();
        try (InputStream is = file.getInputStream();){
            TabularTransformSource tabularTransformSource = serializer.read(is);
            return tabularTransformSource;
        }
    }
}

