/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf.debug;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.table.AbstractTableModel;

class MaltegoLAFTableModel
extends AbstractTableModel {
    public static final Color NOT_A_COLOR = new Color(0, 0, 0, 0);
    public static final String[] COLUMNS = new String[]{"Key", "Value", "Sample (Color: RED==fallback)"};
    private final MaltegoLAF _laf = MaltegoLAF.getDefault();
    private String _filter = "";

    MaltegoLAFTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.getFilteredKeys().size();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public String getKey(int rowIndex) {
        Set<String> keys = this.getFilteredKeys();
        return keys.toArray(new String[0])[rowIndex];
    }

    public Color getColor(String key) {
        Color valueColor = null;
        try {
            String rawStr = this._laf.getRawString(key);
            if (MaltegoLAF.isColor(rawStr)) {
                valueColor = this._laf.getColor(key, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (valueColor == null) {
            valueColor = NOT_A_COLOR;
        }
        return new SortableColor(valueColor);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String key = this.getKey(rowIndex);
        switch (columnIndex) {
            case 0: {
                return key;
            }
            case 1: {
                return this._laf.getRawString(key);
            }
            case 2: {
                return this.getColor(key);
            }
        }
        return null;
    }

    public Set<String> getFilteredKeys() {
        Set<String> keys = this._laf.getKeys();
        LinkedHashSet<String> filtered = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile(this._filter);
        for (String key : keys) {
            if (!pattern.matcher(key).find()) continue;
            filtered.add(key);
        }
        return filtered;
    }

    public void setFilter(String text) {
        this._filter = text;
    }

    private class SortableColor
    extends Color
    implements Comparable<SortableColor> {
        public SortableColor(Color c) {
            super(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }

        @Override
        public int compareTo(SortableColor o) {
            return Float.compare(this.getComparator(this), this.getComparator(o));
        }

        private float getComparator(Color c) {
            int redInt = c.getRed();
            int greenInt = c.getGreen();
            int blueInt = c.getBlue();
            int alphaInt = c.getAlpha();
            if (redInt == 0 && greenInt == 0 && blueInt == 0 && alphaInt == 0) {
                return -1.0f;
            }
            int range = 0;
            float[] hsbvals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            float offset = hsbvals[0] * hsbvals[2] * 254.0f;
            if (redInt == greenInt && redInt == blueInt) {
                range = 765;
                offset = hsbvals[2] * 254.0f;
            } else if (redInt > greenInt && redInt > blueInt) {
                range = 510;
            } else if (blueInt >= greenInt) {
                range = 255;
            }
            return (float)range + offset;
        }
    }
}

