/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.image;

import com.paterva.maltego.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class RotatableImage
extends JPanel {
    private BufferedImage _image;
    private int _degrees;

    public RotatableImage(Image image) {
        this._image = ImageUtils.createBufferedImage((Image)image);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Dimension d = new Dimension(width, height);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setOpaque(false);
    }

    public void setRotation(int degrees) {
        this._degrees = degrees;
        this.repaint();
    }

    public int getRotation() {
        return this._degrees;
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            int width = this._image.getWidth(null);
            int height = this._image.getHeight(null);
            double midX = (double)width / 2.0;
            double midY = (double)height / 2.0;
            double radians = (double)this._degrees * Math.PI / 180.0;
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setPaint(new TexturePaint(this._image, new Rectangle2D.Float(0.0f, 0.0f, width, height)));
            AffineTransform xform = new AffineTransform();
            xform.setToIdentity();
            xform.rotate(radians, midX, midY);
            g2D.transform(xform);
            g2D.fillRect(0, 0, width, height);
        }
    }
}

