/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class WizardUtilities {
    private WizardUtilities() {
    }

    public static WizardDescriptor createWizard(WizardSegment segment) {
        WizardDescriptor.Panel[] panels = segment.getPanels();
        WizardUtilities.updatePanels(panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor(segment.getIterator());
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        segment.initialize(wizardDescriptor);
        return wizardDescriptor;
    }

    public static boolean runWizard(WizardDescriptor descriptor) {
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == WizardDescriptor.FINISH_OPTION;
    }

    public static boolean runWizard(WizardSegment segment) {
        WizardDescriptor wizardDescriptor = WizardUtilities.createWizard(segment);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor) == WizardDescriptor.FINISH_OPTION) {
            segment.handleFinish(wizardDescriptor);
            return true;
        }
        segment.handleCancel(wizardDescriptor);
        return false;
    }

    public static void updatePanels(WizardDescriptor.Panel[] panels) {
        Color fgColor = UIManager.getLookAndFeelDefaults().getColor("7-white");
        Color bgColor = UIManager.getLookAndFeelDefaults().getColor("3-main-dark-color");
        WizardUtilities.updatePanels(panels, "com/paterva/maltego/util/ui/dialog/Wizard.png", fgColor, bgColor);
    }

    private static Color getColor(String property, Color defaultColor) {
        Color color = defaultColor;
        try {
            String colorText = NbBundle.getBundle(WizardUtilities.class).getString(property);
            if (colorText != null) {
                try {
                    color = Color.decode(colorText);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return color;
    }

    public static void updatePanels(WizardDescriptor.Panel[] panels, String imageResource, Color foreground, Color background) {
        Image image = null;
        if (imageResource != null) {
            image = ImageUtilities.loadImage((String)imageResource, (boolean)true);
        }
        String[] steps = new String[panels.length];
        for (int i = 0; i < panels.length; ++i) {
            if (panels[i] instanceof ValidatingController) {
                ValidatingController panel = (ValidatingController)panels[i];
                steps[i] = panel.getName();
                panel.putClientProperty("WizardPanel_contentSelectedIndex", i);
                panel.putClientProperty("WizardPanel_contentData", steps);
                panel.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                panel.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                panel.putClientProperty("WizardPanel_contentBackColor", background);
                panel.putClientProperty("WizardPanel_contentForegroundColor", foreground);
                panel.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
                continue;
            }
            Component c = panels[i].getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentBackColor", background);
            jc.putClientProperty("WizardPanel_contentForegroundColor", foreground);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }
}

