/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class MemorySlider
extends JComponent
implements MouseInputListener {
    private int[] _stops;
    private int _minStop;
    private int _maxStop;
    private int _splitLowMedium;
    private int _splitMediumHigh;
    private static final int PAD = 5;
    private static final int MIN_STOP_WIDTH = 25;
    private static final int SPACING_LEFT = 20;
    private static final int SPACING_RIGHT = 20;
    private int _clickValue = -1;
    private List<ChangeListener> _listeners = new ArrayList<ChangeListener>();
    private boolean _updating = false;
    private static final Color _firstLastColor = new Color(55, 222, 37);
    private static final Color _thirdLastColor = new Color(135, 230, 30);
    private static final Color _secondLastColor = new Color(233, 244, 11);
    private static final Color _lastColor = Color.ORANGE;
    private static final Color _fgColor = UIManager.getLookAndFeelDefaults().getColor("Slider.darculaMod.labelForegroundColor");

    public MemorySlider(int[] stops, int splitLowMedium, int splitMediumHigh) {
        this._stops = stops;
        Arrays.sort(this._stops);
        this._minStop = this._stops[0];
        this._maxStop = this._stops[this._stops.length - 1];
        this._splitLowMedium = splitLowMedium;
        this._splitMediumHigh = splitMediumHigh;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    public void removeListener(ChangeListener changeListener) {
        this._listeners.remove(changeListener);
    }

    public int getValue() {
        if (this._clickValue > 0) {
            return this._clickValue;
        }
        return 0;
    }

    public void setValue(int value) {
        if (!this._updating) {
            this._updating = true;
            this._clickValue = value;
            for (ChangeListener listener : this._listeners) {
                listener.stateChanged(null);
            }
            this.repaint();
            this._updating = false;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10 + this._stops.length * 25, this.getFontHeight(this.getFont()) * 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int ll = 20;
        int lm = this.toInt(this.getX(this._splitLowMedium));
        int mh = this.toInt(this.getX(this._splitMediumHigh));
        int hh = this.toInt(this.getWidth() - 20);
        g2d.setPaint(new GradientPaint(new Point(ll, 0), _firstLastColor, new Point(lm, 0), _thirdLastColor));
        g.fillRect(ll, 0, lm - ll, this.toInt(this.getBarHeight()));
        g2d.setPaint(new GradientPaint(new Point(lm, 0), _thirdLastColor, new Point(mh, 0), _secondLastColor));
        g.fillRect(lm, 0, mh - lm, this.toInt(this.getBarHeight()));
        g2d.setPaint(new GradientPaint(new Point(mh, 0), _secondLastColor, new Point(hh, 0), _lastColor));
        g.fillRect(mh, 0, hh - mh, this.toInt(this.getBarHeight()));
        for (int i = 0; i < this._stops.length; ++i) {
            int x = this.toInt(this.getStopX(i));
            g.setColor(_fgColor);
            g.drawLine(x, 0, x, this.toInt(this.getBarHeight()));
            String stopString = this.getStopString(i);
            int stringWidth = g.getFontMetrics(this.getFont()).stringWidth(stopString);
            g.setFont(this.getFont());
            g.setColor(_fgColor);
            g.drawString(stopString, x - this.toInt(stringWidth / 2), this.getHeight() - 2);
        }
        if (this._clickValue >= 0 && this._clickValue <= this._maxStop) {
            int clickValueX = this.toInt(this.getX(this._clickValue));
            int maxY = this.toInt(this.getBarHeight());
            g.setColor(_fgColor);
            g.drawLine(clickValueX, 0, clickValueX, maxY);
            g.fillPolygon(new int[]{clickValueX, clickValueX - 6, clickValueX + 6}, new int[]{maxY - 6, maxY + 3, maxY + 3}, 3);
        }
    }

    private double getBarHeight() {
        return this.getHeight() - this.getFontHeight(this.getFont());
    }

    private double getStopX(int i) {
        return (int)Math.round(20.0 + (double)i * this.getStopWidth());
    }

    private double getStopWidth() {
        return this.getAvailableWidth() / (double)(this._stops.length - 1);
    }

    private double getAvailableWidth() {
        return this.getWidth() - 20 - 20;
    }

    private int toInt(double d) {
        return (int)Math.round(d);
    }

    private int toInt(float f) {
        return Math.round(f);
    }

    private String getStopString(int i) {
        return String.format("%d", this._stops[i]);
    }

    private int getFontHeight(Font f) {
        return f.getSize() + 5;
    }

    private int getFontWidth(Graphics g, Font f, String text) {
        return g.getFontMetrics(f).stringWidth(text);
    }

    private double getX(int value) {
        if (value == this._maxStop) {
            return this.getStopX(this._stops.length - 1);
        }
        for (int i = 0; i < this._stops.length - 1; ++i) {
            int stopValue = this._stops[i];
            int nextStopValue = this._stops[i + 1];
            if (value < stopValue || value >= nextStopValue) continue;
            double frac = (double)(value - stopValue) / (double)(nextStopValue - stopValue);
            return this.getStopX(i) + this.getStopWidth() * frac;
        }
        return 0.0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > 0 && x < 20) {
            x = 20;
        }
        if (x > this.getWidth() - 20 && x < this.getWidth()) {
            x = this.getWidth() - 20 - 1;
        }
        if (this.isOnBar(x, y)) {
            for (int i = 0; i < this._stops.length - 1; ++i) {
                int stopValue = this._stops[i];
                int nextStopValue = this._stops[i + 1];
                int range = nextStopValue - stopValue;
                double stopX = this.getStopX(i);
                double nextStopX = this.getStopX(i + 1);
                if (!((double)x >= stopX) || !((double)x <= nextStopX)) continue;
                if ((double)x - stopX <= 5.0) {
                    x = this.toInt(stopX);
                } else if (nextStopX - (double)x <= 5.0) {
                    x = this.toInt(nextStopX);
                }
                double frac = ((double)x - stopX) / (nextStopX - stopX);
                this._clickValue = this.toInt((double)stopValue + frac * (double)range);
            }
        }
        this.setValue(this._clickValue);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private boolean isOnBar(int x, int y) {
        return x >= 20 && x <= this.getWidth() - 20 && y >= 0 && (double)y <= this.getBarHeight();
    }
}

