/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigFileIO;
import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.Java2DProperty;
import com.paterva.maltego.java.config.Java2DSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;

public class ConfigFileWriter
extends ConfigFileIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ConfigOptions options) {
        block24: {
            if (options.getMaxHeapSize() == null) {
                return;
            }
            OutputStreamWriter fw = null;
            try {
                try {
                    String configPath = this.getUserConfigFilePath();
                    File dir = new File(new File(configPath).getParent());
                    if (dir.exists() || dir.mkdirs()) {
                        String memPrefix;
                        String d3dKey;
                        String openglKey;
                        String ipv6Key;
                        boolean isValidRuntime;
                        File configFile = new File(configPath);
                        String maxMem = "-J-Xmx" + options.getMaxHeapSize() + "m";
                        String ipOptions = "";
                        IPVersionSettings ipVersionSettings = options.getIpVersionSettings();
                        boolean managed = ipVersionSettings.isManaged();
                        if (!managed) {
                            IPVersion ipv4 = ipVersionSettings.getIPv4();
                            IPVersion ipv6 = ipVersionSettings.getIPv6();
                            ipOptions = ipOptions + ipv4.getKey() + "=" + ipv4.isPrefer() + " " + ipv6.getKey() + "=" + ipv6.isPrefer() + " ";
                        }
                        String java2DOptions = "";
                        Java2DSettings java2DSettings = options.getJava2DSettings();
                        Java2DProperty openGL = java2DSettings.getOpenGL();
                        Java2DProperty d3d = java2DSettings.getD3D();
                        java2DOptions = java2DOptions + openGL.getKey() + "=" + openGL.isPrefer() + " " + d3d.getKey() + "=" + d3d.isPrefer() + " ";
                        String openExportPackages = "-J--add-opens=java.base/java.net=ALL-UNNAMED -J--add-opens=java.base/java.lang.ref=ALL-UNNAMED -J--add-opens=java.base/java.lang=ALL-UNNAMED -J--add-opens=java.base/java.security=ALL-UNNAMED -J--add-opens=java.base/java.util=ALL-UNNAMED -J--add-opens=java.desktop/javax.swing.plaf.basic=ALL-UNNAMED -J--add-opens=java.desktop/javax.swing.text=ALL-UNNAMED -J--add-opens=java.desktop/javax.swing=ALL-UNNAMED -J--add-opens=java.desktop/java.awt=ALL-UNNAMED -J--add-opens=java.desktop/java.awt.event=ALL-UNNAMED -J--add-opens=java.prefs/java.util.prefs=ALL-UNNAMED -J--add-exports=java.desktop/sun.awt=ALL-UNNAMED -J--add-exports=java.desktop/java.awt.peer=ALL-UNNAMED -J--add-exports=java.desktop/com.sun.beans.editors=ALL-UNNAMED -J--add-exports=java.desktop/sun.swing=ALL-UNNAMED -J--add-exports=java.desktop/sun.awt.im=ALL-UNNAMED -J--add-exports=java.desktop/com.sun.java.swing.plaf.motif=ALL-UNNAMED -J--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED -J--add-exports=java.management/sun.management=ALL-UNNAMED -J--add-exports=java.base/sun.reflect.annotation=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.jvm=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED -J--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.jvm=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED -J--add-opens=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED -J--add-exports=jdk.jdeps/com.sun.tools.classfile=ALL-UNNAMED -J--add-exports=jdk.jdeps/com.sun.tools.javap=ALL-UNNAMED -J--add-opens=java.desktop/sun.awt.X11=ALL-UNNAMED -J--add-opens=java.desktop/javax.swing.plaf.synth=ALL-UNNAMED -J--add-opens=java.desktop/com.sun.java.swing.plaf.gtk=ALL-UNNAMED -J--add-opens=java.desktop/sun.awt.shell=ALL-UNNAMED -J--add-opens=java.desktop/sun.awt.im=ALL-UNNAMED -J--add-opens=java.base/java.nio=ALL-UNNAMED -J-XX:+IgnoreUnrecognizedVMOptions -J--add-opens=java.desktop/javax.swing.text.html=ALL-UNNAMED -J--add-exports=java.base/sun.security.ssl=ALL-UNNAMED -J--add-exports=java.desktop/sun.awt.image=ALL-UNNAMED -J--add-exports=java.desktop/com.apple.eawt=ALL-UNNAMED";
                        String defaultOptions = "default_options=\"--branding maltego " + maxMem + " -J-XX:+UseG1GC " + ipOptions + "-J-Dsun.java2d.xrender=false " + java2DOptions + "--locale en:US " + openExportPackages + "\"\n";
                        String javaRuntime = options.getJavaRuntime();
                        boolean bl = isValidRuntime = javaRuntime != null && javaRuntime.length() > 0;
                        if (!configFile.exists()) {
                            String text = defaultOptions;
                            if (isValidRuntime) {
                                text = text + "jdkhome=\"" + javaRuntime + "\"\n";
                            }
                            fw = new FileWriter(configPath, false);
                            fw.write(text);
                            break block24;
                        }
                        String text = "";
                        try (BufferedReader reader = null;){
                            String line;
                            reader = new BufferedReader(new FileReader(configFile));
                            while ((line = reader.readLine()) != null) {
                                text = text + line + "\n";
                            }
                        }
                        String ipv4Key = IPVersion.getIPv4Stack().getKey();
                        if (text.contains(ipv4Key)) {
                            text = this.replaceText(text, ipv4Key);
                        }
                        if (text.contains(ipv6Key = IPVersion.getIPv6Addresses().getKey())) {
                            text = this.replaceText(text, ipv6Key);
                        }
                        if (text.contains(openglKey = Java2DProperty.getOpenGL().getKey())) {
                            text = this.replaceText(text, openglKey);
                        }
                        if (text.contains(d3dKey = Java2DProperty.getD3D().getKey())) {
                            text = this.replaceText(text, d3dKey);
                        }
                        if (text.contains(memPrefix = "-J-Xmx")) {
                            text = text.replaceAll(memPrefix + "(\\d*)[kKmMgGbB]*", maxMem);
                            text = text.replaceAll(memPrefix, java2DOptions + memPrefix);
                            text = text.replaceAll(memPrefix, ipOptions + memPrefix);
                        } else {
                            text = text + "\n" + defaultOptions;
                        }
                        text = text.replaceAll(" +", " ");
                        text = text.replaceAll("jdkhome=\"[^\"]*\"", "");
                        if (isValidRuntime) {
                            text = text + "\njdkhome=\"" + javaRuntime + "\"";
                        }
                        while (text.contains("\n\n")) {
                            text = text.replaceAll("\n\n", "\n");
                        }
                        fw = new FileWriter(configPath, false);
                        fw.write(text);
                        break block24;
                    }
                    JOptionPane.showMessageDialog(null, "Unable to create " + dir.getPath(), "Error", 0);
                }
                finally {
                    if (fw != null) {
                        fw.close();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private String replaceText(String text, String key) {
        return text.replaceAll(key + "=(True|true|False|false)", "");
    }
}

