/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingConstants;

class FormLayout
implements LayoutManager,
SwingConstants {
    public static String FOOTER = "footer";
    private int _hGap;
    private int _vGap;
    private int _footerGap = 3;
    private int _footerInset = 10;
    private int _alignment = 2;
    private int _col1Width = -1;
    private List<Component> _footers;

    public FormLayout() {
        this(10, 10);
    }

    public FormLayout(int hGap, int vGap) {
        this._hGap = hGap;
        this._vGap = vGap;
    }

    public FormLayout(int col1_alignment) {
        this(10, 10, col1_alignment);
    }

    public FormLayout(int hGap, int vGap, int col1_alignment) {
        this._hGap = hGap;
        this._vGap = vGap;
        this._alignment = col1_alignment;
    }

    public int getHGap() {
        return this._hGap;
    }

    public void setHGap(int hgap) {
        this._hGap = hgap;
    }

    public int getVGap() {
        return this._vGap;
    }

    public void setVGap(int vgap) {
        this._vGap = vgap;
    }

    public int getColumn1Width() {
        return this._col1Width;
    }

    public void setColumn1Width(int width) {
        this._col1Width = width;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (FOOTER.equals(name)) {
            if (this._footers == null) {
                this._footers = new LinkedList<Component>();
            }
            this._footers.add(comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._footers.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int col1_width = 0;
        int col2_width = 0;
        int height = 0;
        int column = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component component = parent.getComponent(i);
            Dimension dim = component.getPreferredSize();
            if (this.isFooter(component)) {
                height += dim.height;
                continue;
            }
            if ((column %= 2) == 0) {
                col1_width = Math.max(dim.width, col1_width);
                int rowheight = dim.height;
                Component nextComponent = this.getComponent(parent, i + 1);
                if (nextComponent != null && !this.isFooter(nextComponent)) {
                    dim = nextComponent.getPreferredSize();
                    col2_width = Math.max(dim.width, col2_width);
                    rowheight = Math.max(dim.height, rowheight);
                }
                height += rowheight;
            }
            ++column;
        }
        int nrows = (parent.getComponentCount() - this.getFooterCount() + 1) / 2;
        int nFooters = this.getFooterCount();
        Dimension dimension = new Dimension(insets.left + insets.right + col1_width + col2_width + this._hGap, insets.top + insets.bottom + height + (nrows - 1) * this._vGap + nFooters * this._footerGap);
        return dimension;
    }

    private int getCol1Width(Container parent) {
        if (this._col1Width <= 0) {
            int column = 0;
            int width = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component component = parent.getComponent(i);
                Dimension dim = component.getPreferredSize();
                if (this.isFooter(component)) continue;
                if ((column %= 2) == 0) {
                    width = Math.max(dim.width, width);
                }
                ++column;
            }
            return width;
        }
        return this._col1Width;
    }

    private boolean isFooter(Component comp) {
        if (this._footers == null) {
            return false;
        }
        return this._footers.contains(comp);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int col1_width = this.getCol1Width(parent);
        int w = parent.getSize().width - (insets.left + insets.right);
        int h = parent.getSize().height - (insets.top + insets.bottom);
        int x = insets.left;
        int y = insets.top;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component nextComponent;
            Component component = parent.getComponent(i);
            Dimension dim = component.getPreferredSize();
            int rowheight = dim.height;
            if (this.isFooter(component)) {
                int x2 = x + this._footerInset;
                if (this._alignment == 4) {
                    x2 = x + col1_width + this._hGap;
                }
                component.setBounds(x2, y, w - this._footerInset, dim.height);
            } else {
                nextComponent = this.getComponent(parent, i + 1);
                if (nextComponent != null && !this.isFooter(nextComponent)) {
                    dim = nextComponent.getPreferredSize();
                    rowheight = Math.max(dim.height, rowheight);
                }
                if (this._alignment == 4) {
                    dim = component.getPreferredSize();
                    component.setBounds(x + col1_width - dim.width, y, dim.width, dim.height);
                } else {
                    component.setBounds(x, y, col1_width, rowheight);
                }
                if (nextComponent != null && !this.isFooter(nextComponent)) {
                    ++i;
                    int x2 = x + col1_width + this._hGap;
                    nextComponent.setBounds(x2, y, w - x2, rowheight);
                }
            }
            nextComponent = this.getComponent(parent, i + 1);
            if (nextComponent == null) continue;
            if (this.isFooter(nextComponent)) {
                y += rowheight + this._footerGap;
                continue;
            }
            y += rowheight + this._vGap;
        }
    }

    private Component getComponent(Container parent, int i) {
        if (i >= parent.getComponentCount()) {
            return null;
        }
        return parent.getComponent(i);
    }

    private int getFooterCount() {
        if (this._footers == null) {
            return 0;
        }
        return this._footers.size();
    }

    public int getFooterInset() {
        return this._footerInset;
    }

    public void setFooterInset(int footerInset) {
        this._footerInset = footerInset;
    }
}

