/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.typing.editing.AbstractAddAttachmentsAction;
import com.paterva.maltego.typing.editing.attachments.AttachmentsNode;
import com.paterva.maltego.util.FastURL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AttachmentsAddAction
extends NodeAction {
    private final NodeAddAttachmentsAction _delegate = new NodeAddAttachmentsAction();

    public String getName() {
        return "Attach";
    }

    public boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1 && activatedNodes[0] instanceof AttachmentsNode;
    }

    public void performAction(Node[] activatedNodes) {
        AttachmentsNode attsNode = (AttachmentsNode)activatedNodes[0];
        ArrayList<AttachmentsNode> attsNodes = new ArrayList<AttachmentsNode>(1);
        attsNodes.add(attsNode);
        this._delegate.perform(attsNodes);
    }

    public void perform(AttachmentsNode attsNode, List<File> files) {
        ArrayList<AttachmentsNode> attsNodes = new ArrayList<AttachmentsNode>(1);
        attsNodes.add(attsNode);
        this._delegate.attachFiles(attsNodes, files);
    }

    protected boolean surviveFocusChange() {
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class NodeAddAttachmentsAction
    extends AbstractAddAttachmentsAction {
        private NodeAddAttachmentsAction() {
        }

        @Override
        public void attachFile(Object obj, File file, FastURL source) throws IOException {
            if (obj instanceof AttachmentsNode) {
                AttachmentsNode attsNode = (AttachmentsNode)((Object)obj);
                attsNode.addFile(file, source);
            }
        }

        @Override
        public void attachFile(List objs, File file, FastURL source) throws IOException {
            for (Object obj : objs) {
                if (!(obj instanceof AttachmentsNode)) continue;
                AttachmentsNode attsNode = (AttachmentsNode)((Object)obj);
                attsNode.addFile(file, source);
            }
        }

        @Override
        public void done() {
        }
    }
}

