/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.rest;

import com.paterva.maltego.crypto.SignedData;
import com.paterva.maltego.rest.RestException;
import com.paterva.maltego.util.Args;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Objects;
import java.util.logging.Logger;

public class MaltegoRestResponse {
    private static final Logger LOG = Logger.getLogger(MaltegoRestResponse.class.getName());
    private final String response;

    public MaltegoRestResponse(String response, String nonce, boolean checkStatus) throws IOException, RestException {
        Args.notNull((Object)response, (String)"response");
        this.response = response;
        if (checkStatus && !this.isStatusOK()) {
            String message = this.getMessage();
            throw new RestException(message);
        }
        if (nonce != null && !this.isNonceSame(nonce)) {
            throw new RestException("Response does not match request.");
        }
    }

    public String getText() {
        return this.response;
    }

    public String getBlobPlain() throws IOException {
        return new String(this.getBlobRaw(), StandardCharsets.UTF_8);
    }

    public String getMessage() throws IOException {
        return this.getValue("Message");
    }

    public String getNonce() throws IOException {
        return this.getValue("Nonce");
    }

    public String getBlob() throws IOException {
        return this.getValue("Blob");
    }

    public String getSignature() throws IOException {
        return this.getValue("Signature");
    }

    public SignedData getSignedData(boolean checkSignature) throws IOException, GeneralSecurityException {
        byte[] blob = this.getBlobRaw();
        byte[] signature = this.unBase64(this.getSignature());
        SignedData signedData = new SignedData(blob, signature);
        if (checkSignature && !signedData.isValidSignature()) {
            throw new IOException("Invalid signature in response.");
        }
        return signedData;
    }

    public String getValue(String element) throws IOException {
        String startElement = "<" + element + ">";
        String endElement = "</" + element + ">";
        int pos1 = this.response.indexOf(startElement) + startElement.length();
        int pos2 = this.response.indexOf(endElement);
        if (pos1 < 0 || pos2 < 0 || pos2 < pos1) {
            throw new IOException("Invalid response received from server");
        }
        return this.response.substring(pos1, pos2);
    }

    private byte[] getBlobRaw() throws IOException {
        byte[] rawBlob = this.unBase64(this.getBlob());
        LOG.fine(() -> "Response Blob:\n" + new String(rawBlob, StandardCharsets.UTF_8));
        return rawBlob;
    }

    private byte[] unBase64(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    private boolean isNonceSame(String nonceBefore) throws IOException {
        String nonceAfter = this.getNonce();
        return Objects.equals(nonceBefore, nonceAfter);
    }

    private boolean isStatusOK() throws IOException {
        String status = this.getValue("Status");
        return "OK".equals(status);
    }
}

