/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.analytics.AddLinkEvent;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.J.CC;
import yguard.A.J.SA;
import yguard.A.J.q;

class CreateEdgeViewMode
extends CC {
    private static final String SHOW_IN_FUTURE = "showEdgeCreationProperties";
    private static final boolean ALLOW_COLLECTION_LINKING = true;

    public CreateEdgeViewMode() {
        this.allowBendCreation(false);
        this.allowSelfloopCreation(false);
    }

    protected boolean acceptSourceNode(Y source, double x2, double y2) {
        return true;
    }

    protected boolean acceptTargetNode(Y target, double x2, double y2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected H createEdge(SA gd, Y fromNode, Y toNode, q er) {
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)gd);
        GraphID graphID = GraphIDProvider.forGraph((SA)gd);
        GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        boolean showDialog = CreateEdgeViewMode.getShowDialogInFuture();
        GraphStore graphStore = null;
        try {
            Set toIDs;
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            if (!gd.g(toNode)) {
                EntityID toID = graphWrapper.entityID(toNode);
                toIDs = graphStoreView.getModelViewMappings().getModelEntities(toID);
            } else {
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                toIDs = selection.getSelectedModelEntities();
            }
            EntityID sourceID = graphWrapper.entityID(fromNode);
            Set fromIDs = graphStoreView.getModelViewMappings().getModelEntities(sourceID);
            Map<MaltegoLink, LinkEntityIDs> links = this.getLinks(graphID, fromIDs, toIDs);
            if (showDialog) {
                links = this.showPropertiesDialog(graphID, links);
            }
            if (!links.isEmpty()) {
                AddLinkEvent.send();
                String description = "%s " + GraphTransactionHelper.getDescriptionForLinks(graphWrapper.getGraph(), links.keySet(), true);
                SimilarStrings descriptions = new SimilarStrings(description, "Add", "Delete");
                GraphTransaction transaction = GraphTransactions.addLinks(links);
                GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, transaction);
                GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
            }
        }
        PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
        if (action != null) {
            action.perform(gd, null);
        }
        return null;
    }

    private Map<MaltegoLink, LinkEntityIDs> getLinks(GraphID graphID, Collection<EntityID> fromIDs, Collection<EntityID> toIDs) {
        HashMap<MaltegoLink, LinkEntityIDs> links = new HashMap<MaltegoLink, LinkEntityIDs>();
        for (EntityID fromID : fromIDs) {
            for (EntityID toID : toIDs) {
                MaltegoLink link = LinkFactory.forGraphID((GraphID)graphID).createInstance(MaltegoLinkSpec.getManualSpec(), true);
                LinkEntityIDs entityIDs = new LinkEntityIDs(fromID, toID);
                links.put(link, entityIDs);
            }
        }
        return links;
    }

    private Map<MaltegoLink, LinkEntityIDs> showPropertiesDialog(GraphID graphID, Map<MaltegoLink, LinkEntityIDs> links) {
        MaltegoLinkSpec spec = MaltegoLinkSpec.getManualSpec();
        MaltegoLink link = LinkFactory.forGraphID((GraphID)graphID).createInstance(spec, true);
        EdgeCreationForm form = new EdgeCreationForm(link, spec);
        DialogDescriptor dd = new DialogDescriptor((Object)form, "Properties");
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        HashMap<MaltegoLink, LinkEntityIDs> updatedLinks = new HashMap<MaltegoLink, LinkEntityIDs>(links.size());
        if (DialogDescriptor.OK_OPTION.equals(result)) {
            CreateEdgeViewMode.setShowDialogInFuture(form.getShowInFuture());
            for (Map.Entry<MaltegoLink, LinkEntityIDs> entry : links.entrySet()) {
                MaltegoLink linkCopy = link.createCopy();
                LinkEntityIDs entityIDs = entry.getValue();
                updatedLinks.put(linkCopy, entityIDs);
            }
        }
        return updatedLinks;
    }

    private static boolean getShowDialogInFuture() {
        Preferences settings = NbPreferences.forModule(CreateEdgeViewMode.class);
        return settings.getBoolean(SHOW_IN_FUTURE, true);
    }

    private static void setShowDialogInFuture(boolean show) {
        Preferences settings = NbPreferences.forModule(CreateEdgeViewMode.class);
        settings.putBoolean(SHOW_IN_FUTURE, show);
    }

    public void mouseDraggedLeft(double x2, double y2) {
        this.ignoreSpecificException(() -> super.mouseDraggedLeft(x2, y2));
    }

    public void mouseReleasedLeft(double x2, double y2) {
        this.ignoreSpecificException(() -> super.mouseReleasedLeft(x2, y2));
    }

    private void ignoreSpecificException(Runnable runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (IllegalStateException ex) {
                String message = ex.getMessage();
                if ("EdgeRealizer not yet created!".equals(message)) break block2;
                throw ex;
            }
        }
    }

    private static class EdgeCreationForm
    extends JPanel {
        private JCheckBox _doNotShowInFuture = null;

        public EdgeCreationForm(MaltegoLink link, MaltegoLinkSpec spec) {
            this.setLayout(new BorderLayout());
            Component component = ComponentFactories.form().createEditingComponent((DataSource)link, (DisplayDescriptorEnumeration)spec.getProperties(), spec.getPropertyGroups());
            this.add(component, "Center");
            JPanel checkBoxPanel = new JPanel();
            checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
            this._doNotShowInFuture = new JCheckBox("Do not show this dialog again");
            this._doNotShowInFuture.setAlignmentX(1.0f);
            checkBoxPanel.add(Box.createHorizontalGlue());
            checkBoxPanel.add(this._doNotShowInFuture);
            checkBoxPanel.add(Box.createRigidArea(new Dimension(15, 0)));
            this.add((Component)checkBoxPanel, "South");
        }

        public boolean getShowInFuture() {
            if (this._doNotShowInFuture != null) {
                return !this._doNotShowInFuture.isSelected();
            }
            return true;
        }
    }
}

