/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.ExtensibleEntityFactory;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecFactory;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import java.util.Collection;
import org.openide.util.Lookup;

public abstract class EntityFactory
extends SpecFactory<MaltegoEntitySpec, MaltegoEntity> {
    public static synchronized EntityFactory getDefault() {
        EntityFactory factory = (EntityFactory)((Object)Lookup.getDefault().lookup(EntityFactory.class));
        if (factory == null) {
            factory = new ExtensibleEntityFactory(EntityRegistry.getDefault(), null);
        }
        return factory;
    }

    public static synchronized EntityFactory forGraphID(GraphID graphID) {
        EntityRegistry registry = EntityRegistry.forGraphID(graphID);
        if (registry == null) {
            return null;
        }
        return new ExtensibleEntityFactory(registry, graphID);
    }

    public abstract MaltegoEntity createInstance(String var1, boolean var2, EntityID var3, boolean var4) throws TypeInstantiationException;

    public MaltegoEntity createInstance(MaltegoEntitySpec descriptor, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
        return this.createInstanceInternal(descriptor, sampleInstance, id, decorate);
    }

    protected MaltegoEntity createInstanceInternal(MaltegoEntitySpec descriptor, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
        if (descriptor.getInstanceClass() == null) {
            if (id == null) {
                id = EntityID.create();
            }
        } else {
            try {
                MaltegoEntity entity = (MaltegoEntity)descriptor.getInstanceClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new TypeInstantiationException("Could not instantiate class " + descriptor.getInstanceClass(), (Exception)ex);
            }
            catch (IllegalAccessException ex) {
                throw new TypeInstantiationException("Could not instantiate class " + descriptor.getInstanceClass(), (Exception)ex);
            }
            throw new TypeInstantiationException("This functionality is broken. We need to find a way to set the Guid of a created entity.");
        }
        GenericEntity entity = new GenericEntity(id, descriptor.getTypeName());
        DisplayDescriptorCollection properties = this.getProperties(descriptor);
        if (properties != null) {
            entity.beginPropertyUpdating();
            for (DisplayDescriptor desc : properties) {
                entity.addProperty((PropertyDescriptor)desc);
            }
            for (DisplayDescriptor desc : properties) {
                if (!desc.getLinkedProperties().isEmpty()) continue;
                if (sampleInstance && desc.getSampleValue() != null) {
                    entity.setValue((PropertyDescriptor)desc, desc.getSampleValue());
                    continue;
                }
                entity.setValue((PropertyDescriptor)desc, desc.getDefaultValue());
            }
            entity.endPropertyUpdating(false);
        }
        this.setEntityOverlays((MaltegoEntity)entity, descriptor);
        return entity;
    }

    public MaltegoEntity createInstance(MaltegoEntitySpec descriptor, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
        return this.createInstanceInternal(descriptor, sampleInstance, null, decorate);
    }

    void setEntityOverlays(MaltegoEntity entity, MaltegoEntitySpec descriptor) {
        OverlayDescriptorSet superOverlays = this.superLoadOverlays(descriptor);
        OverlayDescriptorSet overlays = descriptor.getOverlaySet();
        if (overlays != null && !overlays.isEmpty()) {
            superOverlays.addAll((Collection)overlays);
        }
        superOverlays.forEach(overlay -> entity.addOverlay(overlay));
    }

    protected abstract DisplayDescriptorCollection getProperties(MaltegoEntitySpec var1);

    protected abstract OverlayDescriptorSet superLoadOverlays(MaltegoEntitySpec var1);

    public static class Registry
    extends EntityFactory {
        private EntityRegistry _registry;

        public Registry(EntityRegistry registry) {
            this._registry = registry;
        }

        @Override
        public MaltegoEntity createInstance(String typeName, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
            return this.createInstanceInternal(typeName, sampleInstance, id, decorate);
        }

        protected MaltegoEntity createInstanceInternal(String typeName, boolean sampleInstance, EntityID id, boolean decorate) throws TypeInstantiationException {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)this._registry.get(typeName);
            if (spec == null) {
                MaltegoEntitySpec rootSpec = (MaltegoEntitySpec)this._registry.get("maltego.Unknown");
                if (rootSpec != null) {
                    MaltegoEntity entity = this.createInstanceInternal(rootSpec, sampleInstance, id, decorate);
                    entity.setTypeName(typeName);
                    return entity;
                }
                return new GenericEntity(id, typeName);
            }
            return this.createInstanceInternal(spec, sampleInstance, id, decorate);
        }

        public MaltegoEntity createInstance(String typeName, boolean sampleInstance, boolean decorate) throws TypeInstantiationException {
            return this.createInstanceInternal(typeName, sampleInstance, null, decorate);
        }

        @Override
        protected DisplayDescriptorCollection getProperties(MaltegoEntitySpec descriptor) {
            return InheritanceHelper.getAggregatedProperties(this._registry, descriptor.getTypeName());
        }

        @Override
        protected OverlayDescriptorSet superLoadOverlays(MaltegoEntitySpec descriptor) {
            return InheritanceHelper.superLoadOverlays(this._registry, descriptor.getTypeName());
        }
    }
}

