/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.serializer;

import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.EditorDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.editors.FileBrowserEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.editors.OptionItemCollection;
import com.paterva.maltego.typing.editors.PasswordEditorDescriptor;
import com.paterva.maltego.typing.serializer.EditorStub;
import com.paterva.maltego.typing.serializer.FileBrowserEditorStub;
import com.paterva.maltego.typing.serializer.OptionEditorStub;
import com.paterva.maltego.typing.serializer.OptionItemStub;
import com.paterva.maltego.typing.serializer.PasswordEditorStub;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import com.paterva.maltego.util.StringUtilities;

class EditorTranslator {
    EditorTranslator() {
    }

    public EditorDescriptor translate(TypeDescriptor type, EditorStub editor, DisplayDescriptor parent) throws UnresolvedReferenceException {
        if (editor == null) {
            return null;
        }
        if (editor instanceof OptionEditorStub) {
            return this.translate(type, (OptionEditorStub)editor, parent);
        }
        if (editor instanceof PasswordEditorStub) {
            return this.translate((PasswordEditorStub)editor);
        }
        if (editor instanceof FileBrowserEditorStub) {
            return this.translate((FileBrowserEditorStub)editor);
        }
        throw new UnresolvedReferenceException("Cannot resolve editor type: " + editor);
    }

    private OptionEditorDescriptor translate(TypeDescriptor type, OptionEditorStub stub, DisplayDescriptor parent) {
        Class componentType = type.getComponentType();
        OptionEditorDescriptor descriptor = new OptionEditorDescriptor(componentType, parent.getFormat());
        descriptor.setUserSpecified(stub.isUserSpecified());
        if (stub.getOptionItems() != null) {
            for (OptionItemStub itemStub : stub.getOptionItems()) {
                Object value;
                String name = itemStub.getName();
                String valueString = itemStub.getText();
                if (StringUtilities.isNullOrEmpty((String)valueString) && !String.class.equals((Object)componentType)) {
                    value = null;
                } else {
                    TypeDescriptor componentDescriptor = TypeRegistry.getDefault().getType(componentType);
                    value = componentDescriptor.convert(valueString);
                }
                descriptor.getItems().add(name, value);
            }
        }
        return descriptor;
    }

    public EditorStub translate(EditorDescriptor descriptor) {
        if (descriptor instanceof OptionEditorDescriptor) {
            return this.translate((OptionEditorDescriptor)descriptor);
        }
        if (descriptor instanceof FileBrowserEditorDescriptor) {
            return this.translate((FileBrowserEditorDescriptor)descriptor);
        }
        if (descriptor instanceof PasswordEditorDescriptor) {
            return this.translate((PasswordEditorDescriptor)descriptor);
        }
        return null;
    }

    private OptionEditorStub translate(OptionEditorDescriptor descriptor) {
        OptionEditorStub stub = new OptionEditorStub();
        stub.setUserSpecified(descriptor.isUserSpecified());
        if (descriptor.getItems() != null) {
            for (OptionItemCollection.OptionItem item : descriptor.getItems()) {
                String name = item.getName();
                Object value = item.getValue();
                String valueString = value == null ? "" : Converter.convertTo(value, descriptor.getItems().getType());
                OptionItemStub itemStub = new OptionItemStub();
                itemStub.setName(name);
                itemStub.setText(valueString);
                stub.getOptionItems().add(itemStub);
            }
        }
        return stub;
    }

    private PasswordEditorDescriptor translate(PasswordEditorStub stub) {
        return new PasswordEditorDescriptor();
    }

    private PasswordEditorStub translate(PasswordEditorDescriptor descriptor) {
        return new PasswordEditorStub();
    }

    private FileBrowserEditorDescriptor translate(FileBrowserEditorStub stub) {
        FileBrowserEditorDescriptor descriptor = new FileBrowserEditorDescriptor();
        descriptor.setExtensions((String[])Converter.convertFrom(stub.getFileNameFilter(), String[].class));
        descriptor.setFilterTitle(stub.getFilterDisplayName());
        descriptor.setSelectDirectories(stub.isSelectDirectory());
        descriptor.setSelectFiles(stub.isSelectFile());
        return descriptor;
    }

    private FileBrowserEditorStub translate(FileBrowserEditorDescriptor descriptor) {
        FileBrowserEditorStub stub = new FileBrowserEditorStub();
        if (descriptor.getExtensions() != null && descriptor.getExtensions().length > 0) {
            stub.setFileNameFilter(Converter.convertTo((Object)descriptor.getExtensions(), String[].class));
        }
        stub.setFilterDisplayName(descriptor.getFilterTitle());
        stub.setSelectDirectory(descriptor.isSelectDirectories());
        stub.setSelectFile(descriptor.isSelectFiles());
        return stub;
    }
}

