/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.json.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.licensing.ActivationException;
import com.paterva.maltego.licensing.json.rest.SignatureService;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseActivateRequest;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseErrorResponse;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseSameRequest;
import com.paterva.maltego.licensing.serialize.M;
import com.paterva.maltego.licensing.serialize.N;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.openide.util.Exceptions;

public class JsonLicenseRestRequests {
    private static final Logger LOG = Logger.getLogger(JsonLicenseRestRequests.class.getName());
    private static final int TIMEOUT_MILLIS = 15000;
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String getMaltegoIDOfflineActivateBlob() throws ActivationException {
        try {
            LOG.log(Level.INFO, "Creating offline activation blob for Maltego ID");
            SignatureService signatureService = SignatureService.getInstance();
            String activateContent = JsonLicenseRestRequests.createActivateContent(signatureService);
            return signatureService.signMessage(activateContent);
        }
        catch (IOException | GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new ActivationException("Offline activation request could not be created", ex, true);
        }
    }

    public static JsonLicenseResponse activateMaltegoIDOffline(String maltegoIdOfflineResponse) throws ActivationException {
        try {
            LOG.log(Level.INFO, "Activating offline with Maltego ID");
            SignatureService signatureService = SignatureService.getInstance();
            String jsonContent = M.A(signatureService, maltegoIdOfflineResponse);
            JsonLicenseResponse licenseResponse = (JsonLicenseResponse)mapper.readValue(jsonContent, JsonLicenseResponse.class);
            N.B().F(maltegoIdOfflineResponse, null);
            return licenseResponse;
        }
        catch (IOException | GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new ActivationException("Maltego could not be activated", ex, false);
        }
    }

    public static JsonLicenseResponse activateWithMaltegoID() throws ActivationException {
        try {
            LOG.log(Level.INFO, "Sending /activate request");
            SignatureService signatureService = SignatureService.getInstance();
            String activateContent = JsonLicenseRestRequests.createActivateContent(signatureService);
            String signedContent = signatureService.signMessage(activateContent);
            CloudAuth cloudAuth = CloudAuth.getDefault();
            HttpAgent httpAgent = JsonLicenseRestRequests.createHttpAgent(cloudAuth, MaltegoUrl.getCurrent().getLicenseMaltegoIdActivate());
            httpAgent.doPost("text/plain", signedContent);
            String maltegoIdActivateResponse = JsonLicenseRestRequests.getResponseBody(httpAgent, false);
            String jsonContent = M.A(signatureService, maltegoIdActivateResponse);
            JsonLicenseResponse licenseResponse = (JsonLicenseResponse)mapper.readValue(jsonContent, JsonLicenseResponse.class);
            N.B().F(maltegoIdActivateResponse, cloudAuth);
            return licenseResponse;
        }
        catch (IOException | GeneralSecurityException ex) {
            if (ex instanceof JsonParseException && ex.getMessage() != null && ex.getMessage().contains("Unexpected character ('<'")) {
                NormalException.logStackTrace((Throwable)ex);
                throw new ActivationException("Maltego could not be activated", null, ex, false, true);
            }
            Throwable cause = ex.getCause();
            String msg = cause == null ? null : cause.getMessage();
            boolean validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Unable to tunnel through proxy. Proxy returns");
            boolean bl = validCommsIssue = validCommsIssue || cause instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("PKIX path building failed");
            if (validCommsIssue || cause instanceof UnknownHostException || cause instanceof SocketTimeoutException || cause instanceof SocketException) {
                NormalException.logStackTrace((Throwable)ex);
                throw new ActivationException("Maltego could not be activated", null, ex, false, true);
            }
            Exceptions.printStackTrace((Throwable)ex);
            throw new ActivationException("Maltego could not be activated", ex, false);
        }
    }

    public static JsonLicenseResponse isSameWithMaltegoID(String activationId) throws ActivationException {
        try {
            LOG.log(Level.INFO, "Sending /same request with activationId: {0}", new Object[]{activationId});
            SignatureService signatureService = SignatureService.getInstance();
            String isSameContent = JsonLicenseRestRequests.createIsSameContent(signatureService, activationId);
            String signedContent = signatureService.signMessage(isSameContent);
            CloudAuth cloudAuth = CloudAuth.getDefault();
            HttpAgent httpAgent = JsonLicenseRestRequests.createHttpAgent(cloudAuth, MaltegoUrl.getCurrent().getLicenseMaltegoIdSame());
            httpAgent.doPost("text/plain", signedContent);
            String maltegoIdIsSameResponse = JsonLicenseRestRequests.getResponseBody(httpAgent, true);
            String jsonContent = M.A(signatureService, maltegoIdIsSameResponse);
            JsonLicenseResponse licenseResponse = (JsonLicenseResponse)mapper.readValue(jsonContent, JsonLicenseResponse.class);
            N.B().F(maltegoIdIsSameResponse, cloudAuth);
            return licenseResponse;
        }
        catch (IOException | GeneralSecurityException ex) {
            if (ex instanceof JsonParseException && ex.getMessage() != null && ex.getMessage().contains("Unexpected character ('<'")) {
                NormalException.logStackTrace((Throwable)ex);
                throw new ActivationException("Activation could not be verified", null, ex, true, true);
            }
            Throwable cause = ex.getCause();
            String msg = cause == null ? null : cause.getMessage();
            boolean validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Unable to tunnel through proxy. Proxy returns");
            validCommsIssue = validCommsIssue || cause instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("PKIX path building failed");
            validCommsIssue = validCommsIssue || cause instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Remote host terminated the handshake");
            validCommsIssue = validCommsIssue || cause instanceof SSLException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Connection reset");
            boolean bl = validCommsIssue = validCommsIssue || cause instanceof IOException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("stream is closed");
            if (validCommsIssue || cause instanceof UnknownHostException || cause instanceof SocketTimeoutException || cause instanceof SocketException) {
                NormalException.logStackTrace((Throwable)ex);
                throw new ActivationException("Activation could not be verified", null, ex, true, true);
            }
            Exceptions.printStackTrace((Throwable)ex);
            throw new ActivationException("Activation could not be verified", ex, true);
        }
    }

    private static String createActivateContent(SignatureService signatureService) throws JsonProcessingException {
        JsonLicenseActivateRequest jsonLicenseActivateRequest = new JsonLicenseActivateRequest("DESKTOP", UUID.randomUUID().toString(), signatureService.getPublicKeyAsString());
        return mapper.writeValueAsString((Object)jsonLicenseActivateRequest);
    }

    private static String createIsSameContent(SignatureService signatureService, String activationId) throws JsonProcessingException {
        JsonLicenseSameRequest jsonLicenseSameRequest = new JsonLicenseSameRequest(activationId, UUID.randomUUID().toString(), signatureService.getPublicKeyAsString());
        return mapper.writeValueAsString((Object)jsonLicenseSameRequest);
    }

    private static HttpAgent createHttpAgent(CloudAuth cloudAuth, String urlStr) throws MalformedURLException {
        String accessToken = cloudAuth.getAccessTokenString();
        URL url = new URL(urlStr);
        HttpAgent httpAgent = new HttpAgent(url);
        httpAgent.setConnectTimeout(15000);
        httpAgent.setReadTimeout(15000);
        httpAgent.setAccessToken(accessToken);
        return httpAgent;
    }

    private static String getResponseBody(HttpAgent httpAgent, boolean canRetryIfError) throws IOException, ActivationException {
        String errorAsString;
        boolean isCommsError;
        String displayMessage;
        String message;
        int responseCode;
        block16: {
            responseCode = httpAgent.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                return httpAgent.getContentAsString();
            }
            message = "License not same as on server";
            displayMessage = null;
            isCommsError = false;
            errorAsString = null;
            try {
                errorAsString = httpAgent.getErrorAsString();
            }
            catch (NullPointerException ex) {
                if (!canRetryIfError) break block16;
                if (responseCode == Integer.MAX_VALUE) {
                    isCommsError = true;
                }
                if (responseCode != -1) break block16;
                isCommsError = true;
            }
        }
        LOG.log(Level.WARNING, "Http request failed. Error code: {0}\nError body: {1}", new Object[]{responseCode, errorAsString});
        if (errorAsString != null) {
            try {
                JsonLicenseErrorResponse errorResponse = (JsonLicenseErrorResponse)mapper.readValue(errorAsString, JsonLicenseErrorResponse.class);
                displayMessage = errorResponse.getDisplayMessage();
            }
            catch (JsonProcessingException | NullPointerException ex) {
                if (ex instanceof JsonParseException && ex.getMessage() != null && ex.getMessage().contains("Unexpected character ('<'")) {
                    NormalException.logStackTrace((Throwable)ex);
                    isCommsError = true;
                }
                LOG.log(Level.SEVERE, "Error parsing", ex);
            }
        }
        switch (responseCode) {
            case 400: {
                break;
            }
            case 403: {
                message = "No valid desktop entitlement";
                break;
            }
            case 409: {
                message = "Activation needed for changed Maltego Plan";
                break;
            }
            case 412: {
                message = "Maximum number of activations reached";
                break;
            }
            case 422: {
                message = "Activation not found on server";
                break;
            }
            case 503: {
                message = "Service Temporarily Unavailable";
                isCommsError = true;
                break;
            }
            default: {
                message = "Http request failed";
            }
        }
        message = message + ". Error code: " + responseCode;
        throw new ActivationException(message, displayMessage, canRetryIfError, isCommsError);
    }
}

