/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.actions.userfilter.EntityNode;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import java.util.Collection;
import java.util.List;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class EntityChildFactory
extends ChildFactory<EntityID> {
    private final Collection<EntityID> _entities;
    private final GraphID _graphID;

    public EntityChildFactory(GraphID graphID, Collection<EntityID> entities) {
        this._entities = entities;
        this._graphID = graphID;
    }

    protected boolean createKeys(List<EntityID> list) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            for (EntityID entity : this._entities) {
                if (!structureReader.exists(entity)) continue;
                list.add(entity);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(EntityID key) {
        return new EntityNode(this._graphID, key);
    }

    public void refresh() {
        this.refresh(true);
    }
}

