/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.InvokeOn;
import org.xlightweb.client.HttpClient;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

final class AutoRedirectHandler
implements IHttpRequestHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(AutoRedirectHandler.class.getName());
    private HttpClient httpClient = null;

    public AutoRedirectHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void onInit() {
    }

    public void onDestroy() throws IOException {
        this.httpClient = null;
    }

    @InvokeOn(value=1)
    @Execution(value=0)
    public void onRequest(IHttpExchange exchange) throws IOException {
        IHttpRequest request = exchange.getRequest();
        exchange.forward(request, (IHttpResponseHandler)new RedirectedHandler(HttpUtils.copy(request), exchange));
    }

    private boolean isRelativeUrl(String url) {
        return !(url = url.toUpperCase()).startsWith("HTTP") && !url.startsWith("HTTPS");
    }

    private final class RedirectedHandler
    implements IHttpResponseHandler {
        private IHttpRequest request = null;
        private IHttpExchange exchange = null;
        private Integer countRedirects = 0;

        RedirectedHandler(IHttpRequest request, IHttpExchange exchange) throws IOException {
            this.request = request;
            this.exchange = exchange;
            this.countRedirects = (Integer)request.getAttribute("org.xlightweb.client.AutoRedirectHandler.countRedirects");
            if (this.countRedirects == null) {
                this.countRedirects = 0;
            }
        }

        @Execution(value=0)
        public void onResponse(IHttpResponse response) throws IOException {
            if (this.isRedirectResponse(this.request.getRequestHeader(), response.getResponseHeader())) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got redirect response: " + response.getResponseHeader());
                }
                URL newLocation = this.getRedirectURI(response, this.request.isSecure(), this.request.getServerName(), this.request.getServerPort());
                this.request.setRequestUrl(newLocation);
                if (this.countRedirects < AutoRedirectHandler.this.httpClient.getMaxRedirects()) {
                    if (this.request.isSecure()) {
                        Runnable task = new Runnable(){

                            public void run() {
                                RedirectedHandler.this.sendRedirectedRequest();
                            }
                        };
                        AutoRedirectHandler.this.httpClient.getWorkerpool().execute(task);
                    } else {
                        this.sendRedirectedRequest();
                    }
                } else {
                    this.exchange.sendError(new IOException("max redirects " + AutoRedirectHandler.this.httpClient.getMaxRedirects() + " reached. request will not be executed: " + this.request.getRequestHeader()));
                }
            } else {
                this.exchange.send(response);
            }
        }

        private void sendRedirectedRequest() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("send redirected request: " + this.request.getRequestHeader());
            }
            try {
                this.countRedirects = this.countRedirects + 1;
                this.request.setAttribute("org.xlightweb.client.AutoRedirectHandler.countRedirects", this.countRedirects);
                IHttpResponseHandler respHdl = new IHttpResponseHandler(){

                    @Execution(value=0)
                    public void onResponse(IHttpResponse response) throws IOException {
                        RedirectedHandler.this.exchange.send(response);
                    }

                    @Execution(value=0)
                    public void onException(IOException ioe) throws IOException {
                        RedirectedHandler.this.exchange.sendError(ioe);
                    }
                };
                AutoRedirectHandler.this.httpClient.send(this.request, respHdl);
            }
            catch (IOException ioe) {
                this.exchange.sendError(new IOException("can execute redirect request " + this.request.getRequestHeader() + " reason: " + ioe.toString()));
            }
        }

        @Execution(value=0)
        public void onException(IOException ioe) {
            this.exchange.sendError(ioe);
        }

        private boolean isRedirectResponse(IHttpRequestHeader requestHeader, IHttpResponseHeader responseHeader) {
            switch (responseHeader.getStatus()) {
                case 300: {
                    return false;
                }
                case 301: {
                    return requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD");
                }
                case 302: {
                    if (AutoRedirectHandler.this.httpClient.isTreat302RedirectAs303()) {
                        return true;
                    }
                    return requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD");
                }
                case 303: {
                    return true;
                }
                case 304: {
                    return false;
                }
                case 305: {
                    return false;
                }
                case 306: {
                    return false;
                }
                case 307: {
                    return false;
                }
            }
            return false;
        }

        private URL getRedirectURI(IHttpResponse response, boolean isSSL, String originalHost, int originalPort) {
            block7: {
                String location = response.getHeader("Location");
                if (location != null) {
                    try {
                        if (AutoRedirectHandler.this.isRelativeUrl(location)) {
                            if (isSSL) {
                                if (originalPort == -1) {
                                    return new URL("https://" + originalHost + location);
                                }
                                return new URL("https://" + originalHost + ":" + originalPort + location);
                            }
                            if (originalPort == -1) {
                                return new URL("http://" + originalHost + location);
                            }
                            return new URL("http://" + originalHost + ":" + originalPort + location);
                        }
                        return new URL(location);
                    }
                    catch (MalformedURLException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                        LOG.fine("could not create relocation url . reason " + e.toString());
                    }
                }
            }
            return null;
        }
    }
}

