/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import org.xlightweb.AbstractHttpHeader;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.HttpUtils;

final class HeaderlineParser {
    private static final char[] ISO_8859_1_ARRAY = HttpUtils.getISO_8859_1_Array();
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte SPACE = 32;
    private static final byte HTAB = 9;
    private static ThreadLocal<HeaderlineParser> instanceThreadLocal = new ThreadLocal();
    private int state = 0;
    private StringBuilder nameBuilder = new StringBuilder(26);
    private StringBuilder valueBuilder = new StringBuilder();
    private int posLastCharNotSpaceOrHtab;
    private boolean isPreviousCharLF = true;

    static HeaderlineParser newInstance() {
        HeaderlineParser instance = instanceThreadLocal.get();
        if (instance == null) {
            instance = new HeaderlineParser();
        }
        instanceThreadLocal.set(null);
        return instance;
    }

    static void recycleInstance(HeaderlineParser parser) {
        instanceThreadLocal.set(parser);
    }

    private HeaderlineParser() {
    }

    public boolean parse(ComposedByteBuffer composedByteBuffer, AbstractHttpHeader messageHeader) throws BadMessageException, IOException {
        return this.parse(composedByteBuffer, (IHeaderSink)messageHeader);
    }

    boolean parse(ComposedByteBuffer composedByteBuffer, IHeaderSink headerSink) throws IOException {
        byte b = composedByteBuffer.getByte();
        block0 : switch (this.state) {
            case 0: {
                switch (b) {
                    case 13: {
                        break block0;
                    }
                    case 10: {
                        if (this.isPreviousCharLF) {
                            this.addLine(headerSink);
                            this.reset();
                            return true;
                        }
                        this.isPreviousCharLF = true;
                        break block0;
                    }
                    case 32: {
                        this.valueBuilder.append(" ");
                        this.state = 10;
                        break block0;
                    }
                    case 9: {
                        this.valueBuilder.append(" ");
                        this.state = 10;
                        break block0;
                    }
                }
                this.isPreviousCharLF = false;
                this.addLine(headerSink);
                this.nameBuilder.append((char)b);
                this.state = 5;
                break;
            }
            case 5: {
                switch (b) {
                    case 13: {
                        break block0;
                    }
                    case 10: {
                        this.state = 0;
                        this.isPreviousCharLF = true;
                        break block0;
                    }
                    case 32: {
                        this.state = 10;
                        break block0;
                    }
                    case 9: {
                        this.state = 10;
                        break block0;
                    }
                    case 58: {
                        this.state = 10;
                        break block0;
                    }
                }
                this.nameBuilder.append((char)b);
                break;
            }
            case 10: {
                switch (b) {
                    case 32: {
                        break block0;
                    }
                    case 9: {
                        break block0;
                    }
                }
                this.valueBuilder.append(this.toISO_8859_1_Char(b));
                this.posLastCharNotSpaceOrHtab = this.valueBuilder.length();
                this.state = 11;
                break;
            }
            case 11: {
                switch (b) {
                    case 13: {
                        break block0;
                    }
                    case 10: {
                        this.isPreviousCharLF = true;
                        this.state = 0;
                        break block0;
                    }
                    case 32: {
                        this.valueBuilder.append(this.toISO_8859_1_Char(b));
                        break block0;
                    }
                    case 9: {
                        this.valueBuilder.append(this.toISO_8859_1_Char(b));
                        break block0;
                    }
                }
                this.valueBuilder.append(this.toISO_8859_1_Char(b));
                this.posLastCharNotSpaceOrHtab = this.valueBuilder.length();
            }
        }
        return false;
    }

    public void reset() {
        this.state = 0;
        this.nameBuilder.setLength(0);
        this.valueBuilder.setLength(0);
        this.posLastCharNotSpaceOrHtab = 0;
        this.isPreviousCharLF = true;
    }

    public void recycle() {
        HeaderlineParser.recycleInstance(this);
    }

    private void addLine(IHeaderSink headerSink) {
        if (this.nameBuilder.length() > 0 && this.valueBuilder.length() > 0) {
            this.valueBuilder.setLength(this.posLastCharNotSpaceOrHtab);
            headerSink.addHeader(this.nameBuilder.toString(), this.valueBuilder.toString());
            this.nameBuilder.setLength(0);
            this.valueBuilder.setLength(0);
        }
    }

    char toISO_8859_1_Char(byte b) {
        int i = b;
        return ISO_8859_1_ARRAY[i &= 0xFF];
    }

    static interface IHeaderSink {
        public void addHeader(String var1, String var2);
    }
}

