/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;

public final class PubSubManager {
    private Connection con;
    private String to;
    private Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public PubSubManager(Connection connection) {
        this.con = connection;
        this.to = "pubsub." + connection.getServiceName();
    }

    public PubSubManager(Connection connection, String toAddress) {
        this.con = connection;
        this.to = toAddress;
    }

    public LeafNode createNode() throws XMPPException {
        PubSub reply = (PubSub)this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE));
        NodeExtension elem = (NodeExtension)reply.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode newNode = new LeafNode(this.con, elem.getNode());
        newNode.setTo(this.to);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public LeafNode createNode(String id) throws XMPPException {
        return (LeafNode)this.createNode(id, null);
    }

    public Node createNode(String name, Form config) throws XMPPException {
        PubSub request = PubSubManager.createPubsubPacket(this.to, IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE, name));
        boolean isLeafNode = true;
        if (config != null) {
            request.addExtension(new FormNode(FormNodeType.CONFIGURE, config));
            FormField nodeTypeField = config.getField(ConfigureNodeFields.node_type.getFieldName());
            if (nodeTypeField != null) {
                isLeafNode = nodeTypeField.getValues().next().equals(NodeType.leaf.toString());
            }
        }
        PubSubManager.sendPubsubPacket(this.con, this.to, IQ.Type.SET, request);
        Node newNode = isLeafNode ? new LeafNode(this.con, name) : new CollectionNode(this.con, name);
        newNode.setTo(this.to);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public Node getNode(String id) throws XMPPException {
        Node node = this.nodeMap.get(id);
        if (node == null) {
            DiscoverInfo info = new DiscoverInfo();
            info.setTo(this.to);
            info.setNode(id);
            DiscoverInfo infoReply = (DiscoverInfo)SyncPacketSend.getReply(this.con, info);
            node = infoReply.getIdentities().next().getType().equals(NodeType.leaf.toString()) ? new LeafNode(this.con, id) : new CollectionNode(this.con, id);
            node.setTo(this.to);
            this.nodeMap.put(id, node);
        }
        return node;
    }

    public DiscoverItems discoverNodes(String nodeId) throws XMPPException {
        DiscoverItems items = new DiscoverItems();
        if (nodeId != null) {
            items.setNode(nodeId);
        }
        items.setTo(this.to);
        DiscoverItems nodeItems = (DiscoverItems)SyncPacketSend.getReply(this.con, items);
        return nodeItems;
    }

    public List<Subscription> getSubscriptions() throws XMPPException {
        Packet reply = this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.SUBSCRIPTIONS));
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws XMPPException {
        PubSub reply = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.AFFILIATIONS));
        AffiliationsExtension listElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return listElem.getAffiliations();
    }

    public void deleteNode(String nodeId) throws XMPPException {
        this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.DELETE, nodeId), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(nodeId);
    }

    public ConfigureForm getDefaultConfiguration() throws XMPPException {
        PubSub reply = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket(reply, PubSubElementType.DEFAULT);
    }

    public DiscoverInfo getSupportedFeatures() throws XMPPException {
        ServiceDiscoveryManager mgr = ServiceDiscoveryManager.getInstanceFor(this.con);
        return mgr.discoverInfo(this.to);
    }

    private Packet sendPubsubPacket(IQ.Type type, PacketExtension ext, PubSubNamespace ns) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, ext, ns);
    }

    private Packet sendPubsubPacket(IQ.Type type, PacketExtension ext) throws XMPPException {
        return this.sendPubsubPacket(type, ext, null);
    }

    static PubSub createPubsubPacket(String to, IQ.Type type, PacketExtension ext) {
        return PubSubManager.createPubsubPacket(to, type, ext, null);
    }

    static PubSub createPubsubPacket(String to, IQ.Type type, PacketExtension ext, PubSubNamespace ns) {
        PubSub request = new PubSub();
        request.setTo(to);
        request.setType(type);
        if (ns != null) {
            request.setPubSubNamespace(ns);
        }
        request.addExtension(ext);
        return request;
    }

    static Packet sendPubsubPacket(Connection con, String to, IQ.Type type, PacketExtension ext) throws XMPPException {
        return PubSubManager.sendPubsubPacket(con, to, type, ext, null);
    }

    static Packet sendPubsubPacket(Connection con, String to, IQ.Type type, PacketExtension ext, PubSubNamespace ns) throws XMPPException {
        return SyncPacketSend.getReply(con, PubSubManager.createPubsubPacket(to, type, ext, ns));
    }

    static Packet sendPubsubPacket(Connection con, String to, IQ.Type type, PubSub packet) throws XMPPException {
        return PubSubManager.sendPubsubPacket(con, to, type, packet, null);
    }

    static Packet sendPubsubPacket(Connection con, String to, IQ.Type type, PubSub packet, PubSubNamespace ns) throws XMPPException {
        return SyncPacketSend.getReply(con, packet);
    }
}

