/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.impl;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.find.files.FileSearchProvider;
import com.paterva.maltego.find.files.FindInFileSearcher;
import com.paterva.maltego.find.files.FindInFilesCallback;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.find.files.FindInFilesResult;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class FindInFilesRunner
implements Runnable,
Cancellable {
    private static final Object LOCK = new Object();
    private FindInFilesInput _input;
    private FindInFilesCallback _callback;
    private AtomicBoolean _cancelled = new AtomicBoolean(false);

    FindInFilesRunner(FindInFilesInput input, FindInFilesCallback callback) {
        this._input = input;
        this._callback = callback;
    }

    @Override
    public void run() {
        this.doFindInFiles();
        this._callback.done(this._cancelled.get());
    }

    public boolean cancel() {
        this._cancelled.set(true);
        return true;
    }

    private void doFindInFiles() {
        List<FileObject> files = this.getSearchableFiles();
        if (this._cancelled.get()) {
            return;
        }
        int num = 0;
        for (FileObject file : files) {
            this._callback.progress(num++, files.size());
            this.findInFile(file);
            if (!this._cancelled.get()) continue;
            return;
        }
    }

    private List<FileObject> getSearchableFiles() {
        String[] extensions = GraphFileType.getAllExtensions();
        return FileSearchProvider.getDefault().getFiles(this._input.getFolder(), extensions, this._input.isRecursive(), this._input.isRecursive(), this._callback, this._cancelled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInFile(FileObject file) {
        Object object = LOCK;
        synchronized (object) {
            this._callback.status(String.format("Searching in %s", FileUtil.getFileDisplayName((FileObject)file)));
            try {
                FindInFilesResult result = FindInFileSearcher.getDefault().find(file, this._input, this._callback, this._cancelled);
                if (result != null) {
                    this._callback.result(result);
                }
            }
            catch (Throwable t) {
                Logger.getLogger(FindInFilesRunner.class.getName()).log(Level.SEVERE, "{0} caused by {1}", new Object[]{t.getClass().getName(), FileUtil.getFileDisplayName((FileObject)file)});
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }
}

