/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SymmetricEncryptionConfig {
    private final String iv;
    private String tag;
    private final String algorithm;

    public SymmetricEncryptionConfig(String algorithm) {
        this(null, null, algorithm);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SymmetricEncryptionConfig(@JsonProperty(value="iv") String iv, @JsonProperty(value="tag") String tag, @JsonProperty(value="algorithm", required=true) String algorithm) {
        this.iv = iv;
        this.tag = tag;
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getIv() {
        return this.iv;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetricEncryptionConfig)) {
            return false;
        }
        SymmetricEncryptionConfig config = (SymmetricEncryptionConfig)o;
        return Objects.equals(this.algorithm, config.algorithm) && Objects.equals(this.iv, config.iv) && Objects.equals(this.tag, config.tag);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.iv, this.tag);
    }

    public String toString() {
        return "SymmetricEncryptionConfig{algorithm='" + this.algorithm + '\'' + ", iv='" + this.iv + '\'' + ", tag='" + this.tag + '\'' + '}';
    }
}

