/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.util.ArrayList;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.ImageEvent;
import org.lobobrowser.html.domimpl.ImageListener;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.style.ImageRenderState;
import org.lobobrowser.html.style.RenderState;
import org.mozilla.javascript.Function;
import org.w3c.dom.html2.HTMLImageElement;

public class HTMLImageElementImpl
extends HTMLAbstractUIElement
implements HTMLImageElement {
    private Function onload;
    private Image image = null;
    private String imageSrc;
    private final ArrayList listeners = new ArrayList(1);

    public HTMLImageElementImpl() {
        super("IMG");
    }

    public HTMLImageElementImpl(String name) {
        super(name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getAlt() {
        return this.getAttribute("alt");
    }

    @Override
    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    @Override
    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    @Override
    public int getHeight() {
        UINode r = this.uiNode;
        return r == null ? 0 : r.getBounds().height;
    }

    @Override
    public void setHeight(int height) {
        this.setAttribute("height", String.valueOf(height));
    }

    @Override
    public int getHspace() {
        return this.getAttributeAsInt("hspace", 0);
    }

    @Override
    public void setHspace(int hspace) {
        this.setAttribute("hspace", String.valueOf("hspace"));
    }

    @Override
    public boolean getIsMap() {
        return this.getAttributeAsBoolean("isMap");
    }

    @Override
    public void setIsMap(boolean isMap) {
        this.setAttribute("isMap", isMap ? "isMap" : null);
    }

    @Override
    public String getLongDesc() {
        return this.getAttribute("longDesc");
    }

    @Override
    public void setLongDesc(String longDesc) {
        this.setAttribute("longDesc", longDesc);
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public String getUseMap() {
        return this.getAttribute("useMap");
    }

    @Override
    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    @Override
    public int getVspace() {
        return this.getAttributeAsInt("vspace", 0);
    }

    @Override
    public void setVspace(int vspace) {
        this.setAttribute("vspace", String.valueOf(vspace));
    }

    @Override
    public int getWidth() {
        UINode r = this.uiNode;
        return r == null ? 0 : r.getBounds().width;
    }

    @Override
    public void setWidth(int width) {
        this.setAttribute("width", String.valueOf(width));
    }

    @Override
    protected void assignAttributeField(String normalName, String value) {
        super.assignAttributeField(normalName, value);
        if ("src".equals(normalName)) {
            this.loadImage(value);
        }
    }

    public Function getOnload() {
        return this.getEventFunction(this.onload, "onload");
    }

    public void setOnload(Function onload) {
        this.onload = onload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String src) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.imageSrc = src;
                this.image = null;
            }
            if (src != null) {
                document.loadImage(src, new LocalImageListener(src));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener listener) {
        Image currentImage;
        ArrayList l;
        ArrayList arrayList = l = this.listeners;
        synchronized (arrayList) {
            currentImage = this.image;
            l.add(listener);
        }
        if (currentImage != null) {
            listener.imageLoaded(new ImageEvent(this, currentImage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener listener) {
        ArrayList l;
        ArrayList arrayList = l = this.listeners;
        synchronized (arrayList) {
            l.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String expectedImgSrc, ImageEvent event) {
        ImageListener[] listenerArray;
        ArrayList l;
        ArrayList arrayList = l = this.listeners;
        synchronized (arrayList) {
            if (!expectedImgSrc.equals(this.imageSrc)) {
                return;
            }
            this.image = event.image;
            listenerArray = l.toArray(ImageListener.EMPTY_ARRAY);
        }
        int llength = listenerArray.length;
        for (int i = 0; i < llength; ++i) {
            listenerArray[i].imageLoaded(event);
        }
        Function onload = this.getOnload();
        if (onload != null) {
            Executor.executeFunction(this, onload, null);
        }
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        return new ImageRenderState(prevRenderState, this);
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String imgSrc) {
            this.expectedImgSrc = imgSrc;
        }

        @Override
        public void imageLoaded(ImageEvent event) {
            HTMLImageElementImpl.this.dispatchEvent(this.expectedImgSrc, event);
        }
    }
}

