/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public abstract class MachineIDProvider {
    private static final Logger LOG = Logger.getLogger(MachineIDProvider.class.getName());
    private static MachineIDProvider _provider;

    public static synchronized MachineIDProvider getDefault() {
        if (_provider == null) {
            boolean testRandom = false;
            MachineIDProvider provider = (MachineIDProvider)Lookup.getDefault().lookup(MachineIDProvider.class);
            if (provider == null) {
                throw new IllegalStateException("Machine ID Provider not found.");
            }
            _provider = new Persisted(provider);
        }
        return _provider;
    }

    public String getUniqueID() {
        String candidate = null;
        String[] candidates = this.getIDCandidates(false);
        if (candidates != null && candidates.length > 0) {
            candidate = candidates[0];
        }
        return candidate;
    }

    public abstract String[] getIDCandidates(boolean var1);

    private static class RandomMachineIDs
    extends MachineIDProvider {
        private RandomMachineIDs() {
        }

        @Override
        public String[] getIDCandidates(boolean appendRnd) {
            Random rnd = new Random();
            String id = IntStream.range(0, 6).map(i -> 10 + rnd.nextInt(90)).mapToObj(Integer::toString).collect(Collectors.joining("-"));
            LOG.log(Level.INFO, "Random Machine ID: {0}", id);
            return new String[]{id};
        }
    }

    static class Persisted
    extends MachineIDProvider {
        private static final String PREF_MAC_ID = "maltego.mac.id";
        private static final String PREF_MAC_ID_COUNT = "maltego.mac.id.count";
        private static final String PREF_MAC_ID_RND = "maltego.mac.id.rnd";
        private final MachineIDProvider _delegate;

        public Persisted(MachineIDProvider delegate) {
            this._delegate = delegate;
        }

        @Override
        public synchronized String[] getIDCandidates(boolean appendRnd) {
            String[] ids = this.loadIDs();
            if (ids == null || ids.length == 0) {
                ids = this._delegate.getIDCandidates(false);
                if (ids != null && ids.length > 0) {
                    this.persistIDs(ids);
                } else {
                    Logger.getLogger(Persisted.class.getName()).log(Level.WARNING, "No machine ID found.");
                }
            }
            if (appendRnd) {
                String rndValue = this.getRndValue();
                ids = (String[])Arrays.stream(ids).map(id -> id + "-" + rndValue).toArray(String[]::new);
            }
            return ids;
        }

        private String[] loadIDs() {
            Preferences prefs = this.getPrefs();
            int count = prefs.getInt(PREF_MAC_ID_COUNT, 0);
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                String id = prefs.get(this.getIdPrefStr(i), null);
                if (id == null) continue;
                ids.add(id);
            }
            LOG.log(Level.FINE, "Machine IDs loaded: {0}", ids);
            return ids.toArray(new String[ids.size()]);
        }

        private void persistIDs(String[] ids) {
            Preferences prefs = this.getPrefs();
            prefs.putInt(PREF_MAC_ID_COUNT, ids.length);
            for (int i = 0; i < ids.length; ++i) {
                String id = ids[i];
                prefs.put(this.getIdPrefStr(i), id);
            }
            LOG.log(Level.FINE, "Machine IDs saved: {0}", ids);
        }

        private String getIdPrefStr(int index) {
            return "maltego.mac.id." + index;
        }

        private synchronized String getRndValue() {
            Preferences prefs = this.getPrefs();
            String rnd = prefs.get(PREF_MAC_ID_RND, null);
            if (rnd == null) {
                Random random = new Random();
                String hex = IntStream.range(0, 4).map(i -> 16 + random.nextInt(239)).mapToObj(Integer::toHexString).map(String::toUpperCase).collect(Collectors.joining());
                prefs.put(PREF_MAC_ID_RND, hex);
                rnd = hex;
            }
            return rnd;
        }

        private Preferences getPrefs() {
            return NbPreferences.forModule(this.getClass());
        }
    }
}

