/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.sets;

import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.sets.TransformSetFormController;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

class NewTransformSetAction
extends CallableSystemAction {
    NewTransformSetAction() {
    }

    public static Action instance() {
        return (Action)SystemAction.findObject(NewTransformSetAction.class, (boolean)true);
    }

    public void performAction() {
        EditDialogDescriptor descriptor = new EditDialogDescriptor(new WizardDescriptor.Panel[]{new TransformSetFormController()});
        descriptor.setTitle("New Transform Set");
        descriptor.setTitleFormat(new MessageFormat("New Transform Set"));
        descriptor.putProperty("editMode", (Object)Boolean.FALSE);
        descriptor.putProperty("setRepository", (Object)TransformSetRepository.getDefault());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == EditDialogDescriptor.FINISH_OPTION) {
            TransformSet set = new TransformSet((String)descriptor.getProperty("setName"));
            set.setDescription((String)descriptor.getProperty("setDescription"));
            set.setCustom(true);
            if (!TransformSetRepository.getDefault().contains(set.getName())) {
                TransformSetRepository.getDefault().put(set);
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)("The set could not be created because a set with the name '" + set.getName() + "' already exists"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    public String getName() {
        return "New Set...";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "com/paterva/maltego/transform/manager/sets/AddTransformSet.png";
    }

    public Component getToolbarPresenter() {
        Component c = super.getToolbarPresenter();
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setText(this.getName());
        }
        return c;
    }

    protected boolean asynchronous() {
        return false;
    }
}

